/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.resources;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.ibm.icu.text.ArabicShaping;
import com.ibm.icu.text.ArabicShapingException;
import com.ibm.icu.text.Bidi;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.client.resources.Language;
import net.minecraft.resources.IResource;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.LanguageMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ClientLanguageMap
extends LanguageMap {
    private static final Logger field_239493_a_ = LogManager.getLogger();
    private static final Pattern field_239494_b_ = Pattern.compile("%(?:(\\d+)\\$)?([A-Za-z])");
    private final Map<String, String> field_239495_c_;
    private final boolean field_239496_d_;

    private ClientLanguageMap(Map<String, String> map, boolean bl) {
        this.field_239495_c_ = map;
        this.field_239496_d_ = bl;
    }

    public static ClientLanguageMap func_239497_a_(IResourceManager iResourceManager, List<Language> list) {
        HashMap hashMap = Maps.newHashMap();
        boolean \u26032 = false;
        for (Language language : list) {
            \u26032 |= language.func_135035_b();
            String string = String.format("lang/%s.json", language.getCode());
            for (String string2 : iResourceManager.func_199001_a()) {
                try {
                    ResourceLocation resourceLocation = new ResourceLocation(string2, string);
                    ClientLanguageMap.func_239498_a_(iResourceManager.func_199004_b(resourceLocation), hashMap);
                }
                catch (FileNotFoundException resourceLocation) {
                }
                catch (Exception exception) {
                    field_239493_a_.warn("Skipped language file: {}:{} ({})", (Object)string2, (Object)string, (Object)exception.toString());
                }
            }
        }
        return new ClientLanguageMap((Map<String, String>)ImmutableMap.copyOf((Map)hashMap), \u26032);
    }

    private static void func_239498_a_(List<IResource> list, Map<String, String> map) {
        for (IResource iResource : list) {
            try {
                InputStream inputStream = iResource.func_199027_b();
                Throwable throwable = null;
                try {
                    LanguageMap.func_240593_a_(inputStream, map::put);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (inputStream == null) continue;
                    if (throwable != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    inputStream.close();
                }
            }
            catch (IOException iOException) {
                field_239493_a_.warn("Failed to load translations from {}", (Object)iResource, (Object)iOException);
            }
        }
    }

    @Override
    public String func_230503_a_(String string) {
        return this.field_239495_c_.getOrDefault(string, string);
    }

    @Override
    public boolean func_230506_b_(String string) {
        return this.field_239495_c_.containsKey(string);
    }

    @Override
    public boolean func_230505_b_() {
        return this.field_239496_d_;
    }

    @Override
    public String func_230504_a_(String string2, boolean bl) {
        String string2;
        if (!this.field_239496_d_) {
            return string2;
        }
        if (bl && string2.indexOf(37) != -1) {
            string2 = ClientLanguageMap.func_239499_c_(string2);
        }
        return this.func_239500_d_(string2);
    }

    public static String func_239499_c_(String string) {
        Matcher matcher = field_239494_b_.matcher(string);
        StringBuffer \u26032 = new StringBuffer();
        int \u26033 = 1;
        while (matcher.find()) {
            String string2 = matcher.group(1);
            \u2603 = string2 != null ? string2 : Integer.toString(\u26033++);
            \u2603 = matcher.group(2);
            \u2603 = Matcher.quoteReplacement("\u2066%" + \u2603 + "$" + \u2603 + "\u2069");
            matcher.appendReplacement(\u26032, \u2603);
        }
        matcher.appendTail(\u26032);
        return \u26032.toString();
    }

    private String func_239500_d_(String string2) {
        try {
            Bidi bidi = new Bidi(new ArabicShaping(8).shape(string2), 127);
            bidi.setReorderingMode(0);
            return bidi.writeReordered(10);
        }
        catch (ArabicShapingException arabicShapingException) {
            String string2;
            return string2;
        }
    }
}

