/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.model;

import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenCustomHashMap;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.Direction;
import net.minecraft.util.Util;
import org.apache.commons.lang3.tuple.Pair;

public class MultipartBakedModel
implements IBakedModel {
    private final List<Pair<Predicate<BlockState>, IBakedModel>> field_188626_f;
    protected final boolean field_188621_a;
    protected final boolean field_188622_b;
    protected final boolean field_230185_c_;
    protected final TextureAtlasSprite field_188623_c;
    protected final ItemCameraTransforms field_188624_d;
    protected final ItemOverrideList field_188625_e;
    private final Map<BlockState, BitSet> field_210277_g = new Object2ObjectOpenCustomHashMap(Util.func_212443_g());

    public MultipartBakedModel(List<Pair<Predicate<BlockState>, IBakedModel>> list) {
        this.field_188626_f = list;
        IBakedModel iBakedModel = (IBakedModel)list.iterator().next().getRight();
        this.field_188621_a = iBakedModel.func_177555_b();
        this.field_188622_b = iBakedModel.func_177556_c();
        this.field_230185_c_ = iBakedModel.func_230044_c_();
        this.field_188623_c = iBakedModel.func_177554_e();
        this.field_188624_d = iBakedModel.func_177552_f();
        this.field_188625_e = iBakedModel.func_188617_f();
    }

    @Override
    public List<BakedQuad> func_200117_a(@Nullable BlockState blockState2, @Nullable Direction direction, Random random) {
        if (blockState2 == null) {
            return Collections.emptyList();
        }
        BitSet bitSet = this.field_210277_g.get(blockState2);
        if (bitSet == null) {
            BlockState blockState2;
            bitSet = new BitSet();
            for (int i = 0; i < this.field_188626_f.size(); ++i) {
                Pair<Predicate<BlockState>, IBakedModel> pair = this.field_188626_f.get(i);
                if (!((Predicate)pair.getLeft()).test(blockState2)) continue;
                bitSet.set(i);
            }
            this.field_210277_g.put(blockState2, bitSet);
        }
        ArrayList arrayList = Lists.newArrayList();
        long \u26032 = random.nextLong();
        for (int i = 0; i < bitSet.length(); ++i) {
            if (!bitSet.get(i)) continue;
            arrayList.addAll(((IBakedModel)this.field_188626_f.get(i).getRight()).func_200117_a(blockState2, direction, new Random(\u26032)));
        }
        return arrayList;
    }

    @Override
    public boolean func_177555_b() {
        return this.field_188621_a;
    }

    @Override
    public boolean func_177556_c() {
        return this.field_188622_b;
    }

    @Override
    public boolean func_230044_c_() {
        return this.field_230185_c_;
    }

    @Override
    public boolean func_188618_c() {
        return false;
    }

    @Override
    public TextureAtlasSprite func_177554_e() {
        return this.field_188623_c;
    }

    @Override
    public ItemCameraTransforms func_177552_f() {
        return this.field_188624_d;
    }

    @Override
    public ItemOverrideList func_188617_f() {
        return this.field_188625_e;
    }

    public static class Builder {
        private final List<Pair<Predicate<BlockState>, IBakedModel>> field_188649_a = Lists.newArrayList();

        public void func_188648_a(Predicate<BlockState> predicate, IBakedModel iBakedModel) {
            this.field_188649_a.add((Pair<Predicate<BlockState>, IBakedModel>)Pair.of(predicate, (Object)iBakedModel));
        }

        public IBakedModel func_188647_a() {
            return new MultipartBakedModel(this.field_188649_a);
        }
    }
}

