/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.debug;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.debug.DebugRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.Heightmap;

public class HeightMapDebugRenderer
implements DebugRenderer.IDebugRenderer {
    private final Minecraft field_190061_a;

    public HeightMapDebugRenderer(Minecraft minecraft) {
        this.field_190061_a = minecraft;
    }

    @Override
    public void func_225619_a_(MatrixStack matrixStack, IRenderTypeBuffer iRenderTypeBuffer, double d, double d2, double d3) {
        ClientWorld clientWorld = this.field_190061_a.field_71441_e;
        RenderSystem.pushMatrix();
        RenderSystem.disableBlend();
        RenderSystem.disableTexture();
        RenderSystem.enableDepthTest();
        BlockPos \u26032 = new BlockPos(d, 0.0, d3);
        Tessellator \u26033 = Tessellator.func_178181_a();
        BufferBuilder \u26034 = \u26033.func_178180_c();
        \u26034.func_181668_a(5, DefaultVertexFormats.field_181706_f);
        for (int i = -32; i <= 32; i += 16) {
            for (\u2603 = -32; \u2603 <= 32; \u2603 += 16) {
                IChunk iChunk = clientWorld.func_217349_x(\u26032.func_177982_a(i, 0, \u2603));
                for (Map.Entry<Heightmap.Type, Heightmap> entry : iChunk.func_217311_f()) {
                    Heightmap.Type type = entry.getKey();
                    ChunkPos \u26035 = iChunk.func_76632_l();
                    Vector3f \u26036 = this.func_239373_a_(type);
                    for (int j = 0; j < 16; ++j) {
                        for (\u2603 = 0; \u2603 < 16; ++\u2603) {
                            \u2603 = \u26035.field_77276_a * 16 + j;
                            \u2603 = \u26035.field_77275_b * 16 + \u2603;
                            float f = (float)((double)((float)clientWorld.func_201676_a(type, \u2603, \u2603) + (float)type.ordinal() * 0.09375f) - d2);
                            WorldRenderer.func_189693_b(\u26034, (double)((float)\u2603 + 0.25f) - d, f, (double)((float)\u2603 + 0.25f) - d3, (double)((float)\u2603 + 0.75f) - d, f + 0.09375f, (double)((float)\u2603 + 0.75f) - d3, \u26036.func_195899_a(), \u26036.func_195900_b(), \u26036.func_195902_c(), 1.0f);
                        }
                    }
                }
            }
        }
        \u26033.func_78381_a();
        RenderSystem.enableTexture();
        RenderSystem.popMatrix();
    }

    private Vector3f func_239373_a_(Heightmap.Type type) {
        switch (type) {
            case WORLD_SURFACE_WG: {
                return new Vector3f(1.0f, 1.0f, 0.0f);
            }
            case OCEAN_FLOOR_WG: {
                return new Vector3f(1.0f, 0.0f, 1.0f);
            }
            case WORLD_SURFACE: {
                return new Vector3f(0.0f, 0.7f, 0.0f);
            }
            case OCEAN_FLOOR: {
                return new Vector3f(0.0f, 0.0f, 0.5f);
            }
            case MOTION_BLOCKING: {
                return new Vector3f(0.0f, 0.3f, 0.3f);
            }
            case MOTION_BLOCKING_NO_LEAVES: {
                return new Vector3f(0.0f, 0.5f, 0.5f);
            }
        }
        return new Vector3f(0.0f, 0.0f, 0.0f);
    }
}

