/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.debug;

import com.google.common.collect.ImmutableMap;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientChunkProvider;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.debug.DebugRenderer;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.server.integrated.IntegratedServer;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.Util;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.server.ServerChunkProvider;
import net.minecraft.world.server.ServerWorld;

public class ChunkInfoDebugRenderer
implements DebugRenderer.IDebugRenderer {
    private final Minecraft field_217678_a;
    private double field_217679_b = Double.MIN_VALUE;
    private final int field_217680_c = 12;
    @Nullable
    private Entry field_217681_d;

    public ChunkInfoDebugRenderer(Minecraft minecraft) {
        this.field_217678_a = minecraft;
    }

    @Override
    public void func_225619_a_(MatrixStack matrixStack, IRenderTypeBuffer iRenderTypeBuffer, double d, double d2, double d3) {
        Object object;
        \u2603 = Util.func_211178_c();
        if (\u2603 - this.field_217679_b > 3.0E9) {
            this.field_217679_b = \u2603;
            object = this.field_217678_a.func_71401_C();
            this.field_217681_d = object != null ? new Entry((IntegratedServer)object, d, d3) : null;
        }
        if (this.field_217681_d != null) {
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            RenderSystem.lineWidth(2.0f);
            RenderSystem.disableTexture();
            RenderSystem.depthMask(false);
            object = this.field_217681_d.field_217722_c.getNow(null);
            double \u26032 = this.field_217678_a.field_71460_t.func_215316_n().func_216785_c().field_72448_b * 0.85;
            for (Map.Entry entry : this.field_217681_d.field_217721_b.entrySet()) {
                ChunkPos chunkPos = (ChunkPos)entry.getKey();
                String \u26033 = (String)entry.getValue();
                if (object != null) {
                    \u26033 = \u26033 + (String)object.get(chunkPos);
                }
                String[] \u26034 = \u26033.split("\n");
                int \u26035 = 0;
                for (String string : \u26034) {
                    DebugRenderer.func_217729_a(string, (chunkPos.field_77276_a << 4) + 8, \u26032 + (double)\u26035, (chunkPos.field_77275_b << 4) + 8, -1, 0.15f);
                    \u26035 -= 2;
                }
            }
            RenderSystem.depthMask(true);
            RenderSystem.enableTexture();
            RenderSystem.disableBlend();
        }
    }

    final class Entry {
        private final Map<ChunkPos, String> field_217721_b;
        private final CompletableFuture<Map<ChunkPos, String>> field_217722_c;

        private Entry(IntegratedServer integratedServer, double d, double d2) {
            ClientWorld clientWorld = ((ChunkInfoDebugRenderer)ChunkInfoDebugRenderer.this).field_217678_a.field_71441_e;
            RegistryKey<World> \u26032 = clientWorld.func_234923_W_();
            int \u26033 = (int)d >> 4;
            int \u26034 = (int)d2 >> 4;
            ImmutableMap.Builder \u26035 = ImmutableMap.builder();
            ClientChunkProvider \u26036 = clientWorld.func_72863_F();
            for (int i = \u26033 - 12; i <= \u26033 + 12; ++i) {
                for (\u2603 = \u26034 - 12; \u2603 <= \u26034 + 12; ++\u2603) {
                    ChunkPos chunkPos = new ChunkPos(i, \u2603);
                    String \u26037 = "";
                    Chunk \u26038 = \u26036.func_217205_a(i, \u2603, false);
                    \u26037 = \u26037 + "Client: ";
                    if (\u26038 == null) {
                        \u26037 = \u26037 + "0n/a\n";
                    } else {
                        \u26037 = \u26037 + (\u26038.func_76621_g() ? " E" : "");
                        \u26037 = \u26037 + "\n";
                    }
                    \u26035.put((Object)chunkPos, (Object)\u26037);
                }
            }
            this.field_217721_b = \u26035.build();
            this.field_217722_c = integratedServer.func_213169_a(() -> {
                ServerWorld serverWorld = integratedServer.func_71218_a(\u26032);
                if (serverWorld == null) {
                    return ImmutableMap.of();
                }
                ImmutableMap.Builder \u26032 = ImmutableMap.builder();
                ServerChunkProvider \u26033 = serverWorld.func_72863_F();
                for (int i = \u26033 - 12; i <= \u26033 + 12; ++i) {
                    for (\u2603 = \u26034 - 12; \u2603 <= \u26034 + 12; ++\u2603) {
                        ChunkPos chunkPos = new ChunkPos(i, \u2603);
                        \u26032.put((Object)chunkPos, (Object)("Server: " + \u26033.func_217208_a(chunkPos)));
                    }
                }
                return \u26032.build();
            });
        }
    }
}

