/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.multiplayer;

import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.CommandBlockBlock;
import net.minecraft.block.JigsawBlock;
import net.minecraft.block.SoundType;
import net.minecraft.block.StructureBlock;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.SimpleSound;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.network.play.ClientPlayNetHandler;
import net.minecraft.client.util.ClientRecipeBook;
import net.minecraft.client.util.PosAndRotation;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.Entity;
import net.minecraft.entity.passive.horse.AbstractHorseEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.inventory.container.ClickType;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.network.play.client.CClickWindowPacket;
import net.minecraft.network.play.client.CCreativeInventoryActionPacket;
import net.minecraft.network.play.client.CEnchantItemPacket;
import net.minecraft.network.play.client.CHeldItemChangePacket;
import net.minecraft.network.play.client.CPickItemPacket;
import net.minecraft.network.play.client.CPlaceRecipePacket;
import net.minecraft.network.play.client.CPlayerDiggingPacket;
import net.minecraft.network.play.client.CPlayerTryUseItemOnBlockPacket;
import net.minecraft.network.play.client.CPlayerTryUseItemPacket;
import net.minecraft.network.play.client.CUseEntityPacket;
import net.minecraft.stats.StatisticsManager;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.GameType;
import net.minecraft.world.World;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PlayerController {
    private static final Logger field_225325_a = LogManager.getLogger();
    private final Minecraft field_78776_a;
    private final ClientPlayNetHandler field_78774_b;
    private BlockPos field_178895_c = new BlockPos(-1, -1, -1);
    private ItemStack field_85183_f = ItemStack.field_190927_a;
    private float field_78770_f;
    private float field_78780_h;
    private int field_78781_i;
    private boolean field_78778_j;
    private GameType field_78779_k = GameType.SURVIVAL;
    private GameType field_239166_k_ = GameType.NOT_SET;
    private final Object2ObjectLinkedOpenHashMap<Pair<BlockPos, CPlayerDiggingPacket.Action>, PosAndRotation> field_225326_k = new Object2ObjectLinkedOpenHashMap();
    private int field_78777_l;

    public PlayerController(Minecraft minecraft, ClientPlayNetHandler clientPlayNetHandler) {
        this.field_78776_a = minecraft;
        this.field_78774_b = clientPlayNetHandler;
    }

    public void func_78748_a(PlayerEntity playerEntity) {
        this.field_78779_k.func_77147_a(playerEntity.field_71075_bZ);
    }

    public void func_241675_a_(GameType gameType) {
        this.field_239166_k_ = gameType;
    }

    public void func_78746_a(GameType gameType) {
        if (gameType != this.field_78779_k) {
            this.field_239166_k_ = this.field_78779_k;
        }
        this.field_78779_k = gameType;
        this.field_78779_k.func_77147_a(this.field_78776_a.field_71439_g.field_71075_bZ);
    }

    public boolean func_78755_b() {
        return this.field_78779_k.func_77144_e();
    }

    public boolean func_187103_a(BlockPos blockPos) {
        if (this.field_78776_a.field_71439_g.func_223729_a(this.field_78776_a.field_71441_e, blockPos, this.field_78779_k)) {
            return false;
        }
        ClientWorld clientWorld = this.field_78776_a.field_71441_e;
        BlockState \u26032 = clientWorld.func_180495_p(blockPos);
        if (!this.field_78776_a.field_71439_g.func_184614_ca().func_77973_b().func_195938_a(\u26032, clientWorld, blockPos, this.field_78776_a.field_71439_g)) {
            return false;
        }
        Block \u26033 = \u26032.func_177230_c();
        if ((\u26033 instanceof CommandBlockBlock || \u26033 instanceof StructureBlock || \u26033 instanceof JigsawBlock) && !this.field_78776_a.field_71439_g.func_195070_dx()) {
            return false;
        }
        if (\u26032.func_196958_f()) {
            return false;
        }
        \u26033.func_176208_a(clientWorld, blockPos, \u26032, this.field_78776_a.field_71439_g);
        FluidState \u26034 = clientWorld.func_204610_c(blockPos);
        boolean \u26035 = clientWorld.func_180501_a(blockPos, \u26034.func_206883_i(), 11);
        if (\u26035) {
            \u26033.func_176206_d(clientWorld, blockPos, \u26032);
        }
        return \u26035;
    }

    public boolean func_180511_b(BlockPos blockPos2, Direction direction) {
        BlockPos blockPos2;
        if (this.field_78776_a.field_71439_g.func_223729_a(this.field_78776_a.field_71441_e, blockPos2, this.field_78779_k)) {
            return false;
        }
        if (!this.field_78776_a.field_71441_e.func_175723_af().func_177746_a(blockPos2)) {
            return false;
        }
        if (this.field_78779_k.func_77145_d()) {
            BlockState blockState = this.field_78776_a.field_71441_e.func_180495_p(blockPos2);
            this.field_78776_a.func_193032_ao().func_193294_a(this.field_78776_a.field_71441_e, blockPos2, blockState, 1.0f);
            this.func_225324_a(CPlayerDiggingPacket.Action.START_DESTROY_BLOCK, blockPos2, direction);
            this.func_187103_a(blockPos2);
            this.field_78781_i = 5;
        } else if (!this.field_78778_j || !this.func_178893_a(blockPos2)) {
            if (this.field_78778_j) {
                this.func_225324_a(CPlayerDiggingPacket.Action.ABORT_DESTROY_BLOCK, this.field_178895_c, direction);
            }
            BlockState blockState = this.field_78776_a.field_71441_e.func_180495_p(blockPos2);
            this.field_78776_a.func_193032_ao().func_193294_a(this.field_78776_a.field_71441_e, blockPos2, blockState, 0.0f);
            this.func_225324_a(CPlayerDiggingPacket.Action.START_DESTROY_BLOCK, blockPos2, direction);
            boolean bl = \u2603 = !blockState.func_196958_f();
            if (\u2603 && this.field_78770_f == 0.0f) {
                blockState.func_196942_a(this.field_78776_a.field_71441_e, blockPos2, this.field_78776_a.field_71439_g);
            }
            if (\u2603 && blockState.func_185903_a(this.field_78776_a.field_71439_g, this.field_78776_a.field_71439_g.field_70170_p, blockPos2) >= 1.0f) {
                this.func_187103_a(blockPos2);
            } else {
                this.field_78778_j = true;
                this.field_178895_c = blockPos2;
                this.field_85183_f = this.field_78776_a.field_71439_g.func_184614_ca();
                this.field_78770_f = 0.0f;
                this.field_78780_h = 0.0f;
                this.field_78776_a.field_71441_e.func_175715_c(this.field_78776_a.field_71439_g.func_145782_y(), this.field_178895_c, (int)(this.field_78770_f * 10.0f) - 1);
            }
        }
        return true;
    }

    public void func_78767_c() {
        if (this.field_78778_j) {
            BlockState blockState = this.field_78776_a.field_71441_e.func_180495_p(this.field_178895_c);
            this.field_78776_a.func_193032_ao().func_193294_a(this.field_78776_a.field_71441_e, this.field_178895_c, blockState, -1.0f);
            this.func_225324_a(CPlayerDiggingPacket.Action.ABORT_DESTROY_BLOCK, this.field_178895_c, Direction.DOWN);
            this.field_78778_j = false;
            this.field_78770_f = 0.0f;
            this.field_78776_a.field_71441_e.func_175715_c(this.field_78776_a.field_71439_g.func_145782_y(), this.field_178895_c, -1);
            this.field_78776_a.field_71439_g.func_184821_cY();
        }
    }

    public boolean func_180512_c(BlockPos blockPos2, Direction direction) {
        BlockPos blockPos2;
        this.func_78750_j();
        if (this.field_78781_i > 0) {
            --this.field_78781_i;
            return true;
        }
        if (this.field_78779_k.func_77145_d() && this.field_78776_a.field_71441_e.func_175723_af().func_177746_a(blockPos2)) {
            this.field_78781_i = 5;
            BlockState blockState = this.field_78776_a.field_71441_e.func_180495_p(blockPos2);
            this.field_78776_a.func_193032_ao().func_193294_a(this.field_78776_a.field_71441_e, blockPos2, blockState, 1.0f);
            this.func_225324_a(CPlayerDiggingPacket.Action.START_DESTROY_BLOCK, blockPos2, direction);
            this.func_187103_a(blockPos2);
            return true;
        }
        if (this.func_178893_a(blockPos2)) {
            BlockState blockState = this.field_78776_a.field_71441_e.func_180495_p(blockPos2);
            if (blockState.func_196958_f()) {
                this.field_78778_j = false;
                return false;
            }
            this.field_78770_f += blockState.func_185903_a(this.field_78776_a.field_71439_g, this.field_78776_a.field_71439_g.field_70170_p, blockPos2);
            if (this.field_78780_h % 4.0f == 0.0f) {
                SoundType soundType = blockState.func_215695_r();
                this.field_78776_a.func_147118_V().func_147682_a(new SimpleSound(soundType.func_185846_f(), SoundCategory.BLOCKS, (soundType.func_185843_a() + 1.0f) / 8.0f, soundType.func_185847_b() * 0.5f, blockPos2));
            }
            this.field_78780_h += 1.0f;
            this.field_78776_a.func_193032_ao().func_193294_a(this.field_78776_a.field_71441_e, blockPos2, blockState, MathHelper.func_76131_a(this.field_78770_f, 0.0f, 1.0f));
            if (this.field_78770_f >= 1.0f) {
                this.field_78778_j = false;
                this.func_225324_a(CPlayerDiggingPacket.Action.STOP_DESTROY_BLOCK, blockPos2, direction);
                this.func_187103_a(blockPos2);
                this.field_78770_f = 0.0f;
                this.field_78780_h = 0.0f;
                this.field_78781_i = 5;
            }
        } else {
            return this.func_180511_b(blockPos2, direction);
        }
        this.field_78776_a.field_71441_e.func_175715_c(this.field_78776_a.field_71439_g.func_145782_y(), this.field_178895_c, (int)(this.field_78770_f * 10.0f) - 1);
        return true;
    }

    public float func_78757_d() {
        if (this.field_78779_k.func_77145_d()) {
            return 5.0f;
        }
        return 4.5f;
    }

    public void func_78765_e() {
        this.func_78750_j();
        if (this.field_78774_b.func_147298_b().func_150724_d()) {
            this.field_78774_b.func_147298_b().func_74428_b();
        } else {
            this.field_78774_b.func_147298_b().func_179293_l();
        }
    }

    private boolean func_178893_a(BlockPos blockPos2) {
        BlockPos blockPos2;
        ItemStack itemStack = this.field_78776_a.field_71439_g.func_184614_ca();
        boolean bl = bl2 = this.field_85183_f.func_190926_b() && itemStack.func_190926_b();
        if (!this.field_85183_f.func_190926_b() && !itemStack.func_190926_b()) {
            boolean bl2 = itemStack.func_77973_b() == this.field_85183_f.func_77973_b() && ItemStack.func_77970_a(itemStack, this.field_85183_f) && (itemStack.func_77984_f() || itemStack.func_77952_i() == this.field_85183_f.func_77952_i());
        }
        return blockPos2.equals(this.field_178895_c) && bl2;
    }

    private void func_78750_j() {
        int n = this.field_78776_a.field_71439_g.field_71071_by.field_70461_c;
        if (n != this.field_78777_l) {
            this.field_78777_l = n;
            this.field_78774_b.func_147297_a(new CHeldItemChangePacket(this.field_78777_l));
        }
    }

    public ActionResultType func_217292_a(ClientPlayerEntity clientPlayerEntity, ClientWorld clientWorld, Hand hand, BlockRayTraceResult blockRayTraceResult) {
        ActionResultType \u26035;
        this.func_78750_j();
        BlockPos blockPos = blockRayTraceResult.func_216350_a();
        if (!this.field_78776_a.field_71441_e.func_175723_af().func_177746_a(blockPos)) {
            return ActionResultType.FAIL;
        }
        ItemStack \u26032 = clientPlayerEntity.func_184586_b(hand);
        if (this.field_78779_k == GameType.SPECTATOR) {
            this.field_78774_b.func_147297_a(new CPlayerTryUseItemOnBlockPacket(hand, blockRayTraceResult));
            return ActionResultType.SUCCESS;
        }
        boolean \u26033 = !clientPlayerEntity.func_184614_ca().func_190926_b() || !clientPlayerEntity.func_184592_cb().func_190926_b();
        boolean bl = \u2603 = clientPlayerEntity.func_226563_dT_() && \u26033;
        if (!\u2603 && (\u26035 = clientWorld.func_180495_p(blockPos).func_227031_a_(clientWorld, clientPlayerEntity, hand, blockRayTraceResult)).func_226246_a_()) {
            this.field_78774_b.func_147297_a(new CPlayerTryUseItemOnBlockPacket(hand, blockRayTraceResult));
            return \u26035;
        }
        this.field_78774_b.func_147297_a(new CPlayerTryUseItemOnBlockPacket(hand, blockRayTraceResult));
        if (\u26032.func_190926_b() || clientPlayerEntity.func_184811_cZ().func_185141_a(\u26032.func_77973_b())) {
            return ActionResultType.PASS;
        }
        ItemUseContext \u26034 = new ItemUseContext(clientPlayerEntity, hand, blockRayTraceResult);
        if (this.field_78779_k.func_77145_d()) {
            int n = \u26032.func_190916_E();
            \u26035 = \u26032.func_196084_a(\u26034);
            \u26032.func_190920_e(n);
        } else {
            \u26035 = \u26032.func_196084_a(\u26034);
        }
        return \u26035;
    }

    public ActionResultType func_187101_a(PlayerEntity playerEntity, World world, Hand hand) {
        if (this.field_78779_k == GameType.SPECTATOR) {
            return ActionResultType.PASS;
        }
        this.func_78750_j();
        this.field_78774_b.func_147297_a(new CPlayerTryUseItemPacket(hand));
        ItemStack itemStack = playerEntity.func_184586_b(hand);
        if (playerEntity.func_184811_cZ().func_185141_a(itemStack.func_77973_b())) {
            return ActionResultType.PASS;
        }
        int \u26032 = itemStack.func_190916_E();
        ActionResult<ItemStack> \u26033 = itemStack.func_77957_a(world, playerEntity, hand);
        \u2603 = \u26033.func_188398_b();
        if (\u2603 != itemStack) {
            playerEntity.func_184611_a(hand, \u2603);
        }
        return \u26033.func_188397_a();
    }

    public ClientPlayerEntity func_199681_a(ClientWorld clientWorld, StatisticsManager statisticsManager, ClientRecipeBook clientRecipeBook) {
        return this.func_239167_a_(clientWorld, statisticsManager, clientRecipeBook, false, false);
    }

    public ClientPlayerEntity func_239167_a_(ClientWorld clientWorld, StatisticsManager statisticsManager, ClientRecipeBook clientRecipeBook, boolean bl, boolean bl2) {
        return new ClientPlayerEntity(this.field_78776_a, clientWorld, this.field_78774_b, statisticsManager, clientRecipeBook, bl, bl2);
    }

    public void func_78764_a(PlayerEntity playerEntity, Entity entity) {
        this.func_78750_j();
        this.field_78774_b.func_147297_a(new CUseEntityPacket(entity, playerEntity.func_225608_bj_()));
        if (this.field_78779_k != GameType.SPECTATOR) {
            playerEntity.func_71059_n(entity);
            playerEntity.func_184821_cY();
        }
    }

    public ActionResultType func_187097_a(PlayerEntity playerEntity, Entity entity, Hand hand) {
        this.func_78750_j();
        this.field_78774_b.func_147297_a(new CUseEntityPacket(entity, hand, playerEntity.func_225608_bj_()));
        if (this.field_78779_k == GameType.SPECTATOR) {
            return ActionResultType.PASS;
        }
        return playerEntity.func_190775_a(entity, hand);
    }

    public ActionResultType func_187102_a(PlayerEntity playerEntity, Entity entity, EntityRayTraceResult entityRayTraceResult, Hand hand) {
        this.func_78750_j();
        Vector3d vector3d = entityRayTraceResult.func_216347_e().func_178786_a(entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_());
        this.field_78774_b.func_147297_a(new CUseEntityPacket(entity, hand, vector3d, playerEntity.func_225608_bj_()));
        if (this.field_78779_k == GameType.SPECTATOR) {
            return ActionResultType.PASS;
        }
        return entity.func_184199_a(playerEntity, vector3d, hand);
    }

    public ItemStack func_187098_a(int n, int n2, int n3, ClickType clickType, PlayerEntity playerEntity) {
        short s = playerEntity.field_71070_bA.func_75136_a(playerEntity.field_71071_by);
        ItemStack \u26032 = playerEntity.field_71070_bA.func_184996_a(n2, n3, clickType, playerEntity);
        this.field_78774_b.func_147297_a(new CClickWindowPacket(n, n2, n3, clickType, \u26032, s));
        return \u26032;
    }

    public void func_203413_a(int n, IRecipe<?> iRecipe, boolean bl) {
        this.field_78774_b.func_147297_a(new CPlaceRecipePacket(n, iRecipe, bl));
    }

    public void func_78756_a(int n, int n2) {
        this.field_78774_b.func_147297_a(new CEnchantItemPacket(n, n2));
    }

    public void func_78761_a(ItemStack itemStack, int n) {
        if (this.field_78779_k.func_77145_d()) {
            this.field_78774_b.func_147297_a(new CCreativeInventoryActionPacket(n, itemStack));
        }
    }

    public void func_78752_a(ItemStack itemStack) {
        if (this.field_78779_k.func_77145_d() && !itemStack.func_190926_b()) {
            this.field_78774_b.func_147297_a(new CCreativeInventoryActionPacket(-1, itemStack));
        }
    }

    public void func_78766_c(PlayerEntity playerEntity) {
        this.func_78750_j();
        this.field_78774_b.func_147297_a(new CPlayerDiggingPacket(CPlayerDiggingPacket.Action.RELEASE_USE_ITEM, BlockPos.field_177992_a, Direction.DOWN));
        playerEntity.func_184597_cx();
    }

    public boolean func_78763_f() {
        return this.field_78779_k.func_77144_e();
    }

    public boolean func_78762_g() {
        return !this.field_78779_k.func_77145_d();
    }

    public boolean func_78758_h() {
        return this.field_78779_k.func_77145_d();
    }

    public boolean func_78749_i() {
        return this.field_78779_k.func_77145_d();
    }

    public boolean func_110738_j() {
        return this.field_78776_a.field_71439_g.func_184218_aH() && this.field_78776_a.field_71439_g.func_184187_bx() instanceof AbstractHorseEntity;
    }

    public boolean func_178887_k() {
        return this.field_78779_k == GameType.SPECTATOR;
    }

    public GameType func_241822_k() {
        return this.field_239166_k_;
    }

    public GameType func_178889_l() {
        return this.field_78779_k;
    }

    public boolean func_181040_m() {
        return this.field_78778_j;
    }

    public void func_187100_a(int n) {
        this.field_78774_b.func_147297_a(new CPickItemPacket(n));
    }

    private void func_225324_a(CPlayerDiggingPacket.Action action, BlockPos blockPos, Direction direction) {
        ClientPlayerEntity clientPlayerEntity = this.field_78776_a.field_71439_g;
        this.field_225326_k.put((Object)Pair.of((Object)blockPos, (Object)((Object)action)), (Object)new PosAndRotation(clientPlayerEntity.func_213303_ch(), clientPlayerEntity.field_70125_A, clientPlayerEntity.field_70177_z));
        this.field_78774_b.func_147297_a(new CPlayerDiggingPacket(action, blockPos, direction));
    }

    public void func_225323_a(ClientWorld clientWorld, BlockPos blockPos, BlockState blockState, CPlayerDiggingPacket.Action action, boolean bl) {
        Vector3d vector3d;
        PosAndRotation posAndRotation = (PosAndRotation)this.field_225326_k.remove((Object)Pair.of((Object)blockPos, (Object)((Object)action)));
        BlockState \u26032 = clientWorld.func_180495_p(blockPos);
        if ((posAndRotation == null || !bl || action != CPlayerDiggingPacket.Action.START_DESTROY_BLOCK && \u26032 != blockState) && \u26032 != blockState) {
            clientWorld.func_195597_b(blockPos, blockState);
            if (posAndRotation != null) {
                vector3d = posAndRotation.func_224783_a();
                this.field_78776_a.field_71439_g.func_70080_a(vector3d.field_72450_a, vector3d.field_72448_b, vector3d.field_72449_c, posAndRotation.func_224785_c(), posAndRotation.func_224784_b());
            }
        }
        while (this.field_225326_k.size() >= 50) {
            vector3d = (Pair)this.field_225326_k.firstKey();
            this.field_225326_k.removeFirst();
            field_225325_a.error("Too many unacked block actions, dropping " + vector3d);
        }
    }
}

