/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.screen;

import com.google.common.hash.Hashing;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.datafixers.util.Function4;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.Path;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.client.AnvilConverterException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.SimpleSound;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.DialogTexts;
import net.minecraft.client.gui.chat.NarratorChatListener;
import net.minecraft.client.gui.screen.AlertScreen;
import net.minecraft.client.gui.screen.ConfirmBackupScreen;
import net.minecraft.client.gui.screen.ConfirmScreen;
import net.minecraft.client.gui.screen.CreateWorldScreen;
import net.minecraft.client.gui.screen.DirtMessageScreen;
import net.minecraft.client.gui.screen.EditWorldScreen;
import net.minecraft.client.gui.screen.ErrorScreen;
import net.minecraft.client.gui.screen.WorkingScreen;
import net.minecraft.client.gui.screen.WorldSelectionScreen;
import net.minecraft.client.gui.toasts.SystemToast;
import net.minecraft.client.gui.widget.list.AbstractList;
import net.minecraft.client.gui.widget.list.ExtendedList;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.NativeImage;
import net.minecraft.client.resources.I18n;
import net.minecraft.resources.IResourceManager;
import net.minecraft.server.IDynamicRegistries;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SharedConstants;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.Util;
import net.minecraft.util.datafix.codec.DatapackCodec;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.WorldSettings;
import net.minecraft.world.gen.settings.DimensionGeneratorSettings;
import net.minecraft.world.storage.FolderName;
import net.minecraft.world.storage.IServerConfiguration;
import net.minecraft.world.storage.SaveFormat;
import net.minecraft.world.storage.WorldSummary;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class WorldSelectionList
extends ExtendedList<Entry> {
    private static final Logger field_186797_u = LogManager.getLogger();
    private static final DateFormat field_214377_b = new SimpleDateFormat();
    private static final ResourceLocation field_214378_c = new ResourceLocation("textures/misc/unknown_server.png");
    private static final ResourceLocation field_214379_d = new ResourceLocation("textures/gui/world_selection.png");
    private final WorldSelectionScreen field_186798_v;
    @Nullable
    private List<WorldSummary> field_212331_y;

    public WorldSelectionList(WorldSelectionScreen worldSelectionScreen, Minecraft minecraft, int n, int n2, int n3, int n4, int n5, Supplier<String> supplier, @Nullable WorldSelectionList worldSelectionList) {
        super(minecraft, n, n2, n3, n4, n5);
        this.field_186798_v = worldSelectionScreen;
        if (worldSelectionList != null) {
            this.field_212331_y = worldSelectionList.field_212331_y;
        }
        this.func_212330_a(supplier, false);
    }

    public void func_212330_a(Supplier<String> supplier2, boolean bl) {
        Supplier<String> supplier2;
        this.func_230963_j_();
        SaveFormat saveFormat = this.field_230668_b_.func_71359_d();
        if (this.field_212331_y == null || bl) {
            try {
                this.field_212331_y = saveFormat.func_75799_b();
            }
            catch (AnvilConverterException anvilConverterException) {
                field_186797_u.error("Couldn't load level list", (Throwable)anvilConverterException);
                this.field_230668_b_.func_147108_a(new ErrorScreen(new TranslationTextComponent("selectWorld.unable_to_load"), new StringTextComponent(anvilConverterException.getMessage())));
                return;
            }
            Collections.sort(this.field_212331_y);
        }
        if (this.field_212331_y.isEmpty()) {
            this.field_230668_b_.func_147108_a(new CreateWorldScreen(null));
            return;
        }
        String \u26032 = supplier2.get().toLowerCase(Locale.ROOT);
        for (WorldSummary worldSummary : this.field_212331_y) {
            if (!worldSummary.func_75788_b().toLowerCase(Locale.ROOT).contains(\u26032) && !worldSummary.func_75786_a().toLowerCase(Locale.ROOT).contains(\u26032)) continue;
            this.func_230513_b_(new Entry(this, worldSummary, this.field_230668_b_.func_71359_d()));
        }
    }

    @Override
    protected int func_230952_d_() {
        return super.func_230952_d_() + 20;
    }

    @Override
    public int func_230949_c_() {
        return super.func_230949_c_() + 50;
    }

    @Override
    protected boolean func_230971_aw__() {
        return this.field_186798_v.func_241217_q_() == this;
    }

    @Override
    public void func_241215_a_(@Nullable Entry entry2) {
        Entry entry2;
        super.func_241215_a_(entry2);
        if (entry2 != null) {
            WorldSummary worldSummary = entry2.field_214451_d;
            NarratorChatListener.field_193643_a.func_216864_a(new TranslationTextComponent("narrator.select", new TranslationTextComponent("narrator.select.world", worldSummary.func_75788_b(), new Date(worldSummary.func_75784_e()), worldSummary.func_75789_g() ? new TranslationTextComponent("gameMode.hardcore") : new TranslationTextComponent("gameMode." + worldSummary.func_75790_f().func_77149_b()), worldSummary.func_75783_h() ? new TranslationTextComponent("selectWorld.cheats") : StringTextComponent.field_240750_d_, worldSummary.func_237313_j_())).getString());
        }
        this.field_186798_v.func_214324_a(entry2 != null && !entry2.field_214451_d.func_237315_o_());
    }

    @Override
    protected void func_241219_a_(AbstractList.Ordering ordering) {
        this.func_241572_a_(ordering, entry -> !((Entry)entry).field_214451_d.func_237315_o_());
    }

    public Optional<Entry> func_214376_a() {
        return Optional.ofNullable(this.func_230958_g_());
    }

    public WorldSelectionScreen func_186796_g() {
        return this.field_186798_v;
    }

    public final class Entry
    extends ExtendedList.AbstractListEntry<Entry>
    implements AutoCloseable {
        private final Minecraft field_214449_b;
        private final WorldSelectionScreen field_214450_c;
        private final WorldSummary field_214451_d;
        private final ResourceLocation field_214452_e;
        private File field_214453_f;
        @Nullable
        private final DynamicTexture field_214454_g;
        private long field_214455_h;

        public Entry(WorldSelectionList worldSelectionList2, WorldSummary worldSummary, SaveFormat saveFormat) {
            this.field_214450_c = worldSelectionList2.func_186796_g();
            this.field_214451_d = worldSummary;
            this.field_214449_b = Minecraft.func_71410_x();
            this.field_214452_e = new ResourceLocation("worlds/" + Hashing.sha1().hashUnencodedChars((CharSequence)worldSummary.func_75786_a()) + "/icon");
            this.field_214453_f = worldSummary.func_237312_c_();
            if (!this.field_214453_f.isFile()) {
                this.field_214453_f = null;
            }
            this.field_214454_g = this.func_214446_f();
        }

        @Override
        public void func_230432_a_(MatrixStack matrixStack2, int n, int n2, int n3, int n4, int n5, int n6, int n7, boolean bl, float f) {
            String string = this.field_214451_d.func_75788_b();
            \u2603 = this.field_214451_d.func_75786_a() + " (" + field_214377_b.format(new Date(this.field_214451_d.func_75784_e())) + ")";
            if (StringUtils.isEmpty((CharSequence)string)) {
                string = I18n.func_135052_a("selectWorld.world", new Object[0]) + " " + (n + 1);
            }
            ITextComponent \u26032 = this.field_214451_d.func_237316_p_();
            this.field_214449_b.field_71466_p.func_238421_b_(matrixStack2, string, n3 + 32 + 3, n2 + 1, 0xFFFFFF);
            this.field_214449_b.field_71466_p.func_238421_b_(matrixStack2, \u2603, n3 + 32 + 3, n2 + this.field_214449_b.field_71466_p.field_78288_b + 3, 0x808080);
            this.field_214449_b.field_71466_p.func_238422_b_(matrixStack2, \u26032, n3 + 32 + 3, n2 + this.field_214449_b.field_71466_p.field_78288_b + this.field_214449_b.field_71466_p.field_78288_b + 3, 0x808080);
            RenderSystem.color4f(1.0f, 1.0f, 1.0f, 1.0f);
            this.field_214449_b.func_110434_K().func_110577_a(this.field_214454_g != null ? this.field_214452_e : field_214378_c);
            RenderSystem.enableBlend();
            AbstractGui.func_238463_a_(matrixStack2, n3, n2, 0.0f, 0.0f, 32, 32, 32, 32);
            RenderSystem.disableBlend();
            if (this.field_214449_b.field_71474_y.field_85185_A || bl) {
                MatrixStack matrixStack2;
                this.field_214449_b.func_110434_K().func_110577_a(field_214379_d);
                AbstractGui.func_238467_a_(matrixStack2, n3, n2, n3 + 32, n2 + 32, -1601138544);
                RenderSystem.color4f(1.0f, 1.0f, 1.0f, 1.0f);
                int n8 = n6 - n3;
                boolean \u26033 = n8 < 32;
                int n9 = \u2603 = \u26033 ? 32 : 0;
                if (this.field_214451_d.func_237315_o_()) {
                    AbstractGui.func_238463_a_(matrixStack2, n3, n2, 96.0f, \u2603, 32, 32, 256, 256);
                    if (\u26033) {
                        IFormattableTextComponent iFormattableTextComponent = new TranslationTextComponent("selectWorld.locked").func_240699_a_(TextFormatting.RED);
                        this.field_214450_c.func_239026_b_(this.field_214449_b.field_71466_p.func_238425_b_(iFormattableTextComponent, 175));
                    }
                } else if (this.field_214451_d.func_186355_l()) {
                    AbstractGui.func_238463_a_(matrixStack2, n3, n2, 32.0f, \u2603, 32, 32, 256, 256);
                    if (this.field_214451_d.func_186356_m()) {
                        AbstractGui.func_238463_a_(matrixStack2, n3, n2, 96.0f, \u2603, 32, 32, 256, 256);
                        if (\u26033) {
                            this.field_214450_c.func_239026_b_(Arrays.asList(new TranslationTextComponent("selectWorld.tooltip.fromNewerVersion1").func_240699_a_(TextFormatting.RED), new TranslationTextComponent("selectWorld.tooltip.fromNewerVersion2").func_240699_a_(TextFormatting.RED)));
                        }
                    } else if (!SharedConstants.func_215069_a().isStable()) {
                        AbstractGui.func_238463_a_(matrixStack2, n3, n2, 64.0f, \u2603, 32, 32, 256, 256);
                        if (\u26033) {
                            this.field_214450_c.func_239026_b_(Arrays.asList(new TranslationTextComponent("selectWorld.tooltip.snapshot1").func_240699_a_(TextFormatting.GOLD), new TranslationTextComponent("selectWorld.tooltip.snapshot2").func_240699_a_(TextFormatting.GOLD)));
                        }
                    }
                } else {
                    AbstractGui.func_238463_a_(matrixStack2, n3, n2, 0.0f, \u2603, 32, 32, 256, 256);
                }
            }
        }

        @Override
        public boolean func_231044_a_(double d, double d2, int n) {
            if (this.field_214451_d.func_237315_o_()) {
                return true;
            }
            WorldSelectionList.this.func_241215_a_(this);
            this.field_214450_c.func_214324_a(WorldSelectionList.this.func_214376_a().isPresent());
            if (d - (double)WorldSelectionList.this.func_230968_n_() <= 32.0) {
                this.func_214438_a();
                return true;
            }
            if (Util.func_211177_b() - this.field_214455_h < 250L) {
                this.func_214438_a();
                return true;
            }
            this.field_214455_h = Util.func_211177_b();
            return false;
        }

        public void func_214438_a() {
            if (this.field_214451_d.func_237315_o_()) {
                return;
            }
            if (this.field_214451_d.func_197731_n()) {
                TranslationTextComponent translationTextComponent = new TranslationTextComponent("selectWorld.backupQuestion");
                \u2603 = new TranslationTextComponent("selectWorld.backupWarning", this.field_214451_d.func_237313_j_(), SharedConstants.func_215069_a().getName());
                this.field_214449_b.func_147108_a(new ConfirmBackupScreen(this.field_214450_c, (bl, bl2) -> {
                    if (bl) {
                        String string = this.field_214451_d.func_75786_a();
                        try (SaveFormat.LevelSave levelSave = this.field_214449_b.func_71359_d().func_237274_c_(string);){
                            EditWorldScreen.func_239019_a_(levelSave);
                        }
                        catch (IOException iOException) {
                            SystemToast.func_238535_a_(this.field_214449_b, string);
                            field_186797_u.error("Failed to backup level {}", (Object)string, (Object)iOException);
                        }
                    }
                    this.func_214443_e();
                }, translationTextComponent, \u2603, false));
            } else if (this.field_214451_d.func_186356_m()) {
                this.field_214449_b.func_147108_a(new ConfirmScreen(bl -> {
                    if (bl) {
                        try {
                            this.func_214443_e();
                        }
                        catch (Exception exception) {
                            field_186797_u.error("Failure to open 'future world'", (Throwable)exception);
                            this.field_214449_b.func_147108_a(new AlertScreen(() -> this.field_214449_b.func_147108_a(this.field_214450_c), new TranslationTextComponent("selectWorld.futureworld.error.title"), new TranslationTextComponent("selectWorld.futureworld.error.text")));
                        }
                    } else {
                        this.field_214449_b.func_147108_a(this.field_214450_c);
                    }
                }, new TranslationTextComponent("selectWorld.versionQuestion"), new TranslationTextComponent("selectWorld.versionWarning", this.field_214451_d.func_237313_j_(), new TranslationTextComponent("selectWorld.versionJoinButton"), DialogTexts.field_240633_d_)));
            } else {
                this.func_214443_e();
            }
        }

        public void func_214442_b() {
            this.field_214449_b.func_147108_a(new ConfirmScreen(bl -> {
                if (bl) {
                    this.field_214449_b.func_147108_a(new WorkingScreen());
                    SaveFormat saveFormat = this.field_214449_b.func_71359_d();
                    String \u26032 = this.field_214451_d.func_75786_a();
                    try (SaveFormat.LevelSave levelSave = saveFormat.func_237274_c_(\u26032);){
                        levelSave.func_237299_g_();
                    }
                    catch (IOException iOException) {
                        SystemToast.func_238538_b_(this.field_214449_b, \u26032);
                        field_186797_u.error("Failed to delete world {}", (Object)\u26032, (Object)iOException);
                    }
                    WorldSelectionList.this.func_212330_a(() -> this.field_214450_c.field_212352_g.func_146179_b(), true);
                }
                this.field_214449_b.func_147108_a(this.field_214450_c);
            }, new TranslationTextComponent("selectWorld.deleteQuestion"), new TranslationTextComponent("selectWorld.deleteWarning", this.field_214451_d.func_75788_b()), new TranslationTextComponent("selectWorld.deleteButton"), DialogTexts.field_240633_d_));
        }

        public void func_214444_c() {
            String string = this.field_214451_d.func_75786_a();
            try {
                SaveFormat.LevelSave levelSave = this.field_214449_b.func_71359_d().func_237274_c_(string);
                this.field_214449_b.func_147108_a(new EditWorldScreen(bl -> {
                    try {
                        levelSave.close();
                    }
                    catch (IOException iOException) {
                        field_186797_u.error("Failed to unlock level {}", (Object)string, (Object)iOException);
                    }
                    if (bl) {
                        WorldSelectionList.this.func_212330_a(() -> this.field_214450_c.field_212352_g.func_146179_b(), true);
                    }
                    this.field_214449_b.func_147108_a(this.field_214450_c);
                }, levelSave));
            }
            catch (IOException iOException) {
                SystemToast.func_238535_a_(this.field_214449_b, string);
                field_186797_u.error("Failed to access level {}", (Object)string, (Object)iOException);
                WorldSelectionList.this.func_212330_a(() -> this.field_214450_c.field_212352_g.func_146179_b(), true);
            }
        }

        public void func_214445_d() {
            this.func_241653_f_();
            IDynamicRegistries.Impl impl = IDynamicRegistries.func_239770_b_();
            try (SaveFormat.LevelSave levelSave = this.field_214449_b.func_71359_d().func_237274_c_(this.field_214451_d.func_75786_a());
                 Minecraft.PackManager packManager = this.field_214449_b.func_238189_a_(impl, Minecraft::func_238180_a_, (Function4<SaveFormat.LevelSave, IDynamicRegistries.Impl, IResourceManager, DatapackCodec, IServerConfiguration>)((Function4)Minecraft::func_238181_a_), false, levelSave);){
                WorldSettings worldSettings = packManager.func_238226_c_().func_230408_H_();
                DimensionGeneratorSettings \u26032 = packManager.func_238226_c_().func_230418_z_();
                Path \u26033 = CreateWorldScreen.func_238943_a_(levelSave.func_237285_a_(FolderName.field_237251_g_), this.field_214449_b);
                if (\u26032.func_236229_j_()) {
                    this.field_214449_b.func_147108_a(new ConfirmScreen(bl -> this.field_214449_b.func_147108_a(bl ? new CreateWorldScreen(this.field_214450_c, worldSettings, \u26032, \u26033, impl) : this.field_214450_c), new TranslationTextComponent("selectWorld.recreate.customized.title"), new TranslationTextComponent("selectWorld.recreate.customized.text"), DialogTexts.field_240636_g_, DialogTexts.field_240633_d_));
                } else {
                    this.field_214449_b.func_147108_a(new CreateWorldScreen(this.field_214450_c, worldSettings, \u26032, \u26033, impl));
                }
            }
            catch (Exception exception) {
                field_186797_u.error("Unable to recreate world", (Throwable)exception);
                this.field_214449_b.func_147108_a(new AlertScreen(() -> this.field_214449_b.func_147108_a(this.field_214450_c), new TranslationTextComponent("selectWorld.recreate.error.title"), new TranslationTextComponent("selectWorld.recreate.error.text")));
            }
        }

        private void func_214443_e() {
            this.field_214449_b.func_147118_V().func_147682_a(SimpleSound.func_184371_a(SoundEvents.field_187909_gi, 1.0f));
            if (this.field_214449_b.func_71359_d().func_90033_f(this.field_214451_d.func_75786_a())) {
                this.func_241653_f_();
                this.field_214449_b.func_238191_a_(this.field_214451_d.func_75786_a());
            }
        }

        private void func_241653_f_() {
            this.field_214449_b.func_241562_c_(new DirtMessageScreen(new TranslationTextComponent("selectWorld.data_read")));
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Nullable
        private DynamicTexture func_214446_f() {
            boolean bl;
            boolean bl2 = bl = this.field_214453_f != null && this.field_214453_f.isFile();
            if (!bl) {
                this.field_214449_b.func_110434_K().func_147645_c(this.field_214452_e);
                return null;
            }
            try (FileInputStream \u26032 = new FileInputStream(this.field_214453_f);){
                NativeImage \u26033 = NativeImage.func_195713_a(\u26032);
                Validate.validState((\u26033.func_195702_a() == 64 ? 1 : 0) != 0, (String)"Must be 64 pixels wide", (Object[])new Object[0]);
                Validate.validState((\u26033.func_195714_b() == 64 ? 1 : 0) != 0, (String)"Must be 64 pixels high", (Object[])new Object[0]);
                DynamicTexture \u26034 = new DynamicTexture(\u26033);
                this.field_214449_b.func_110434_K().func_229263_a_(this.field_214452_e, \u26034);
                DynamicTexture dynamicTexture = \u26034;
                return dynamicTexture;
            }
            catch (Throwable throwable6) {
                field_186797_u.error("Invalid icon for world {}", (Object)this.field_214451_d.func_75786_a(), (Object)throwable6);
                this.field_214453_f = null;
                return null;
            }
        }

        @Override
        public void close() {
            if (this.field_214454_g != null) {
                this.field_214454_g.close();
            }
        }
    }
}

