/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.screen;

import com.google.gson.JsonIOException;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.Lifecycle;
import it.unimi.dsi.fastutil.booleans.BooleanConsumer;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.DialogTexts;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.IRenderable;
import net.minecraft.client.gui.screen.BiomeGeneratorTypeScreens;
import net.minecraft.client.gui.screen.ConfirmScreen;
import net.minecraft.client.gui.screen.CreateWorldScreen;
import net.minecraft.client.gui.screen.IScreen;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.toasts.SystemToast;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.resources.I18n;
import net.minecraft.command.Commands;
import net.minecraft.resources.DataPackRegistries;
import net.minecraft.resources.FolderPackFinder;
import net.minecraft.resources.IPackNameDecorator;
import net.minecraft.resources.ResourcePackInfo;
import net.minecraft.resources.ResourcePackList;
import net.minecraft.resources.ServerPackFinder;
import net.minecraft.server.IDynamicRegistries;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.Util;
import net.minecraft.util.registry.WorldSettingsImport;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.gen.settings.DimensionGeneratorSettings;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.lwjgl.util.tinyfd.TinyFileDialogs;

public class WorldOptionsScreen
implements IScreen,
IRenderable {
    private static final Logger field_239028_b_ = LogManager.getLogger();
    private static final ITextComponent field_239029_c_ = new TranslationTextComponent("generator.custom");
    private static final ITextComponent field_239030_d_ = new TranslationTextComponent("generator.amplified.info");
    private FontRenderer field_239031_e_;
    private int field_239032_f_;
    private TextFieldWidget field_239033_g_;
    private Button field_239034_h_;
    public Button field_239027_a_;
    private Button field_239035_i_;
    private Button field_239036_j_;
    private Button field_239037_k_;
    private IDynamicRegistries.Impl field_239038_l_;
    private DimensionGeneratorSettings field_239039_m_;
    private Optional<BiomeGeneratorTypeScreens> field_239040_n_;
    private String field_239041_o_;

    public WorldOptionsScreen() {
        this.field_239038_l_ = IDynamicRegistries.func_239770_b_();
        this.field_239039_m_ = DimensionGeneratorSettings.func_236210_a_();
        this.field_239040_n_ = Optional.of(BiomeGeneratorTypeScreens.field_239066_a_);
        this.field_239041_o_ = "";
    }

    public WorldOptionsScreen(IDynamicRegistries.Impl impl, DimensionGeneratorSettings dimensionGeneratorSettings) {
        this.field_239038_l_ = impl;
        this.field_239039_m_ = dimensionGeneratorSettings;
        this.field_239040_n_ = BiomeGeneratorTypeScreens.func_239079_a_(dimensionGeneratorSettings);
        this.field_239041_o_ = Long.toString(dimensionGeneratorSettings.func_236221_b_());
    }

    public void func_239048_a_(final CreateWorldScreen createWorldScreen, Minecraft minecraft, FontRenderer fontRenderer) {
        this.field_239031_e_ = fontRenderer;
        this.field_239032_f_ = createWorldScreen.field_230708_k_;
        this.field_239033_g_ = new TextFieldWidget(this.field_239031_e_, this.field_239032_f_ / 2 - 100, 60, 200, 20, new TranslationTextComponent("selectWorld.enterSeed"));
        this.field_239033_g_.func_146180_a(this.field_239041_o_);
        this.field_239033_g_.func_212954_a(string -> {
            this.field_239041_o_ = this.field_239033_g_.func_146179_b();
        });
        createWorldScreen.func_230481_d_(this.field_239033_g_);
        int n = this.field_239032_f_ / 2 - 155;
        \u2603 = this.field_239032_f_ / 2 + 5;
        this.field_239034_h_ = createWorldScreen.func_230480_a_(new Button(n, 100, 150, 20, new TranslationTextComponent("selectWorld.mapFeatures"), button -> {
            this.field_239039_m_ = this.field_239039_m_.func_236231_l_();
            button.func_230994_c_(250);
        }){

            @Override
            public ITextComponent func_230458_i_() {
                return super.func_230458_i_().func_230532_e_().func_240702_b_(" ").func_230529_a_(DialogTexts.func_240638_a_(WorldOptionsScreen.this.field_239039_m_.func_236222_c_()));
            }

            @Override
            protected IFormattableTextComponent func_230442_c_() {
                return super.func_230442_c_().func_240702_b_(". ").func_230529_a_(new TranslationTextComponent("selectWorld.mapFeatures.info"));
            }
        });
        this.field_239034_h_.field_230694_p_ = false;
        this.field_239035_i_ = createWorldScreen.func_230480_a_(new Button(\u2603, 100, 150, 20, new TranslationTextComponent("selectWorld.mapType"), button -> {
            while (this.field_239040_n_.isPresent()) {
                int n = BiomeGeneratorTypeScreens.field_239068_c_.indexOf(this.field_239040_n_.get()) + 1;
                if (n >= BiomeGeneratorTypeScreens.field_239068_c_.size()) {
                    n = 0;
                }
                BiomeGeneratorTypeScreens \u26032 = BiomeGeneratorTypeScreens.field_239068_c_.get(n);
                this.field_239040_n_ = Optional.of(\u26032);
                this.field_239039_m_ = \u26032.func_241220_a_(this.field_239038_l_, this.field_239039_m_.func_236221_b_(), this.field_239039_m_.func_236222_c_(), this.field_239039_m_.func_236223_d_());
                if (this.field_239039_m_.func_236227_h_() && !Screen.func_231173_s_()) continue;
            }
            createWorldScreen.func_238955_g_();
            button.func_230994_c_(250);
        }){

            @Override
            public ITextComponent func_230458_i_() {
                return super.func_230458_i_().func_230532_e_().func_240702_b_(" ").func_230529_a_(WorldOptionsScreen.this.field_239040_n_.map(BiomeGeneratorTypeScreens::func_239077_a_).orElse(field_239029_c_));
            }

            @Override
            protected IFormattableTextComponent func_230442_c_() {
                if (Objects.equals(WorldOptionsScreen.this.field_239040_n_, Optional.of(BiomeGeneratorTypeScreens.field_239067_b_))) {
                    return super.func_230442_c_().func_240702_b_(". ").func_230529_a_(field_239030_d_);
                }
                return super.func_230442_c_();
            }
        });
        this.field_239035_i_.field_230694_p_ = false;
        this.field_239035_i_.field_230693_o_ = this.field_239040_n_.isPresent();
        this.field_239036_j_ = createWorldScreen.func_230480_a_(new Button(\u2603, 120, 150, 20, new TranslationTextComponent("selectWorld.customizeType"), button -> {
            BiomeGeneratorTypeScreens.IFactory iFactory = BiomeGeneratorTypeScreens.field_239069_d_.get(this.field_239040_n_);
            if (iFactory != null) {
                minecraft.func_147108_a(iFactory.createEditScreen(createWorldScreen, this.field_239039_m_));
            }
        }));
        this.field_239036_j_.field_230694_p_ = false;
        this.field_239027_a_ = createWorldScreen.func_230480_a_(new Button(n, 151, 150, 20, new TranslationTextComponent("selectWorld.bonusItems"), button -> {
            this.field_239039_m_ = this.field_239039_m_.func_236232_m_();
            button.func_230994_c_(250);
        }){

            @Override
            public ITextComponent func_230458_i_() {
                return super.func_230458_i_().func_230532_e_().func_240702_b_(" ").func_230529_a_(DialogTexts.func_240638_a_(WorldOptionsScreen.this.field_239039_m_.func_236223_d_() && !createWorldScreen.field_146337_w));
            }
        });
        this.field_239027_a_.field_230694_p_ = false;
        this.field_239037_k_ = createWorldScreen.func_230480_a_(new Button(n, 185, 150, 20, new TranslationTextComponent("selectWorld.import_worldgen_settings"), button -> {
            DataResult dataResult;
            DataPackRegistries \u26035;
            Object object;
            TranslationTextComponent translationTextComponent = new TranslationTextComponent("selectWorld.import_worldgen_settings.select_file");
            String \u26032 = TinyFileDialogs.tinyfd_openFileDialog((CharSequence)translationTextComponent.getString(), null, null, null, (boolean)false);
            if (\u26032 == null) {
                return;
            }
            IDynamicRegistries.Impl \u26033 = IDynamicRegistries.func_239770_b_();
            ResourcePackList<ResourcePackInfo> \u26034 = new ResourcePackList<ResourcePackInfo>(ResourcePackInfo::new, new ServerPackFinder(), new FolderPackFinder(createWorldScreen.func_238957_j_().toFile(), IPackNameDecorator.field_232627_c_));
            try {
                MinecraftServer.func_240772_a_(\u26034, createWorldScreen.field_238933_b_, false);
                object = DataPackRegistries.func_240961_a_(\u26034.func_232623_f_(), Commands.EnvironmentType.INTEGRATED, 2, Util.func_215072_e(), minecraft);
                minecraft.func_213161_c(() -> object.isDone());
                \u26035 = ((CompletableFuture)object).get();
            }
            catch (InterruptedException | ExecutionException exception) {
                field_239028_b_.error("Error loading data packs when importing world settings", (Throwable)exception);
                TranslationTextComponent translationTextComponent2 = new TranslationTextComponent("selectWorld.import_worldgen_settings.failure");
                StringTextComponent \u26036 = new StringTextComponent(exception.getMessage());
                minecraft.func_193033_an().func_192988_a(SystemToast.func_238534_a_(minecraft, SystemToast.Type.WORLD_GEN_SETTINGS_TRANSFER, translationTextComponent2, \u26036));
                \u26034.close();
                return;
            }
            object = WorldSettingsImport.func_240876_a_(JsonOps.INSTANCE, \u26035.func_240970_h_(), \u26033);
            JsonParser \u26037 = new JsonParser();
            try {
                object2 = Files.newBufferedReader(Paths.get(\u26032, new String[0]));
                Throwable throwable = null;
                try {
                    throwable2 = \u26037.parse((Reader)object2);
                    dataResult = DimensionGeneratorSettings.field_236201_a_.parse((DynamicOps)object, throwable2);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (object2 != null) {
                        if (throwable != null) {
                            try {
                                ((BufferedReader)object2).close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        } else {
                            ((BufferedReader)object2).close();
                        }
                    }
                }
            }
            catch (JsonIOException | JsonSyntaxException | IOException throwable) {
                dataResult = DataResult.error((String)("Failed to parse file: " + throwable.getMessage()));
            }
            if (dataResult.error().isPresent()) {
                Object object2 = new TranslationTextComponent("selectWorld.import_worldgen_settings.failure");
                String \u26038 = ((DataResult.PartialResult)dataResult.error().get()).message();
                field_239028_b_.error("Error parsing world settings: {}", (Object)\u26038);
                throwable2 = new StringTextComponent(\u26038);
                minecraft.func_193033_an().func_192988_a(SystemToast.func_238534_a_(minecraft, SystemToast.Type.WORLD_GEN_SETTINGS_TRANSFER, (ITextComponent)object2, (ITextComponent)throwable2));
            }
            object2 = dataResult.lifecycle();
            dataResult.resultOrPartial(arg_0 -> ((Logger)field_239028_b_).error(arg_0)).ifPresent(arg_0 -> this.func_239046_a_(minecraft, createWorldScreen, \u26033, (Lifecycle)object2, arg_0));
        }));
        this.field_239037_k_.field_230694_p_ = false;
    }

    private void func_239052_a_(IDynamicRegistries.Impl impl, DimensionGeneratorSettings dimensionGeneratorSettings) {
        this.field_239038_l_ = impl;
        this.field_239039_m_ = dimensionGeneratorSettings;
        this.field_239040_n_ = BiomeGeneratorTypeScreens.func_239079_a_(dimensionGeneratorSettings);
        this.field_239041_o_ = Long.toString(dimensionGeneratorSettings.func_236221_b_());
        this.field_239033_g_.func_146180_a(this.field_239041_o_);
        this.field_239035_i_.field_230693_o_ = this.field_239040_n_.isPresent();
    }

    @Override
    public void func_231023_e_() {
        this.field_239033_g_.func_146178_a();
    }

    @Override
    public void func_230430_a_(MatrixStack matrixStack, int n, int n2, float f) {
        if (this.field_239034_h_.field_230694_p_) {
            this.field_239031_e_.func_238405_a_(matrixStack, I18n.func_135052_a("selectWorld.mapFeatures.info", new Object[0]), this.field_239032_f_ / 2 - 150, 122.0f, -6250336);
        }
        this.field_239033_g_.func_230430_a_(matrixStack, n, n2, f);
        if (this.field_239040_n_.equals(Optional.of(BiomeGeneratorTypeScreens.field_239067_b_))) {
            this.field_239031_e_.func_238418_a_(field_239030_d_, this.field_239035_i_.field_230690_l_ + 2, this.field_239035_i_.field_230691_m_ + 22, this.field_239035_i_.func_230998_h_(), 0xA0A0A0);
        }
    }

    protected void func_239043_a_(DimensionGeneratorSettings dimensionGeneratorSettings) {
        this.field_239039_m_ = dimensionGeneratorSettings;
    }

    private static OptionalLong func_239053_a_(String string) {
        try {
            return OptionalLong.of(Long.parseLong(string));
        }
        catch (NumberFormatException numberFormatException) {
            return OptionalLong.empty();
        }
    }

    public DimensionGeneratorSettings func_239054_a_(boolean bl) {
        String string = this.field_239033_g_.func_146179_b();
        OptionalLong \u26032 = StringUtils.isEmpty((CharSequence)string) ? OptionalLong.empty() : ((\u2603 = WorldOptionsScreen.func_239053_a_(string)).isPresent() && \u2603.getAsLong() != 0L ? \u2603 : OptionalLong.of(string.hashCode()));
        return this.field_239039_m_.func_236220_a_(bl, \u26032);
    }

    public boolean func_239042_a_() {
        return this.field_239039_m_.func_236227_h_();
    }

    public void func_239059_b_(boolean bl) {
        this.field_239035_i_.field_230694_p_ = bl;
        if (this.field_239039_m_.func_236227_h_()) {
            this.field_239034_h_.field_230694_p_ = false;
            this.field_239027_a_.field_230694_p_ = false;
            this.field_239036_j_.field_230694_p_ = false;
            this.field_239037_k_.field_230694_p_ = false;
        } else {
            this.field_239034_h_.field_230694_p_ = bl;
            this.field_239027_a_.field_230694_p_ = bl;
            this.field_239036_j_.field_230694_p_ = bl && BiomeGeneratorTypeScreens.field_239069_d_.containsKey(this.field_239040_n_);
            this.field_239037_k_.field_230694_p_ = bl;
        }
        this.field_239033_g_.func_146189_e(bl);
    }

    public IDynamicRegistries.Impl func_239055_b_() {
        return this.field_239038_l_;
    }

    private /* synthetic */ void func_239046_a_(Minecraft minecraft, CreateWorldScreen createWorldScreen, IDynamicRegistries.Impl impl, Lifecycle lifecycle, DimensionGeneratorSettings dimensionGeneratorSettings) {
        BooleanConsumer booleanConsumer = bl -> {
            minecraft.func_147108_a(createWorldScreen);
            if (bl) {
                this.func_239052_a_(impl, dimensionGeneratorSettings);
            }
        };
        if (lifecycle == Lifecycle.stable()) {
            this.func_239052_a_(impl, dimensionGeneratorSettings);
        } else if (lifecycle == Lifecycle.experimental()) {
            minecraft.func_147108_a(new ConfirmScreen(booleanConsumer, new TranslationTextComponent("selectWorld.import_worldgen_settings.experimental.title"), new TranslationTextComponent("selectWorld.import_worldgen_settings.experimental.question")));
        } else {
            minecraft.func_147108_a(new ConfirmScreen(booleanConsumer, new TranslationTextComponent("selectWorld.import_worldgen_settings.deprecated.title"), new TranslationTextComponent("selectWorld.import_worldgen_settings.deprecated.question")));
        }
    }
}

