/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.screen;

import com.google.common.collect.Lists;
import com.google.common.hash.Hashing;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadPoolExecutor;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.chat.NarratorChatListener;
import net.minecraft.client.gui.screen.MultiplayerScreen;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.list.AbstractList;
import net.minecraft.client.gui.widget.list.ExtendedList;
import net.minecraft.client.multiplayer.ServerData;
import net.minecraft.client.multiplayer.ServerList;
import net.minecraft.client.network.LanServerInfo;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.NativeImage;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.DefaultUncaughtExceptionHandler;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SharedConstants;
import net.minecraft.util.Util;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import org.apache.commons.lang3.Validate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ServerSelectionList
extends ExtendedList<Entry> {
    private static final Logger field_214357_a = LogManager.getLogger();
    private static final ThreadPoolExecutor field_214358_b = new ScheduledThreadPoolExecutor(5, new ThreadFactoryBuilder().setNameFormat("Server Pinger #%d").setDaemon(true).setUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)new DefaultUncaughtExceptionHandler(field_214357_a)).build());
    private static final ResourceLocation field_214359_c = new ResourceLocation("textures/misc/unknown_server.png");
    private static final ResourceLocation field_214360_d = new ResourceLocation("textures/gui/server_selection.png");
    private final MultiplayerScreen field_148200_k;
    private final List<NormalEntry> field_148198_l = Lists.newArrayList();
    private final Entry field_148196_n = new LanScanEntry();
    private final List<LanDetectedEntry> field_148199_m = Lists.newArrayList();

    public ServerSelectionList(MultiplayerScreen multiplayerScreen, Minecraft minecraft, int n, int n2, int n3, int n4, int n5) {
        super(minecraft, n, n2, n3, n4, n5);
        this.field_148200_k = multiplayerScreen;
    }

    private void func_195094_h() {
        this.func_230963_j_();
        this.field_148198_l.forEach(this::func_230513_b_);
        this.func_230513_b_(this.field_148196_n);
        this.field_148199_m.forEach(this::func_230513_b_);
    }

    @Override
    public void func_241215_a_(@Nullable Entry entry) {
        super.func_241215_a_(entry);
        if (this.func_230958_g_() instanceof NormalEntry) {
            NarratorChatListener.field_193643_a.func_216864_a(new TranslationTextComponent("narrator.select", ((NormalEntry)((NormalEntry)this.func_230958_g_())).field_148301_e.field_78847_a).getString());
        }
        this.field_148200_k.func_214295_b();
    }

    @Override
    public boolean func_231046_a_(int n, int n2, int n3) {
        Entry entry = (Entry)this.func_230958_g_();
        return entry != null && entry.func_231046_a_(n, n2, n3) || super.func_231046_a_(n, n2, n3);
    }

    @Override
    protected void func_241219_a_(AbstractList.Ordering ordering) {
        this.func_241572_a_(ordering, entry -> !(entry instanceof LanScanEntry));
    }

    public void func_148195_a(ServerList serverList) {
        this.field_148198_l.clear();
        for (int i = 0; i < serverList.func_78856_c(); ++i) {
            this.field_148198_l.add(new NormalEntry(this.field_148200_k, serverList.func_78850_a(i)));
        }
        this.func_195094_h();
    }

    public void func_148194_a(List<LanServerInfo> list) {
        this.field_148199_m.clear();
        for (LanServerInfo lanServerInfo : list) {
            this.field_148199_m.add(new LanDetectedEntry(this.field_148200_k, lanServerInfo));
        }
        this.func_195094_h();
    }

    @Override
    protected int func_230952_d_() {
        return super.func_230952_d_() + 30;
    }

    @Override
    public int func_230949_c_() {
        return super.func_230949_c_() + 85;
    }

    @Override
    protected boolean func_230971_aw__() {
        return this.field_148200_k.func_241217_q_() == this;
    }

    public class NormalEntry
    extends Entry {
        private final MultiplayerScreen field_148303_c;
        private final Minecraft field_148300_d;
        private final ServerData field_148301_e;
        private final ResourceLocation field_148306_i;
        private String field_148299_g;
        private DynamicTexture field_148305_h;
        private long field_148298_f;

        protected NormalEntry(MultiplayerScreen multiplayerScreen, ServerData serverData) {
            this.field_148303_c = multiplayerScreen;
            this.field_148301_e = serverData;
            this.field_148300_d = Minecraft.func_71410_x();
            this.field_148306_i = new ResourceLocation("servers/" + Hashing.sha1().hashUnencodedChars((CharSequence)serverData.field_78845_b) + "/icon");
            this.field_148305_h = (DynamicTexture)this.field_148300_d.func_110434_K().func_229267_b_(this.field_148306_i);
        }

        @Override
        public void func_230432_a_(MatrixStack matrixStack, int n, int n2, int n3, int n4, int n5, int n6, int n7, boolean bl, float f) {
            List<ITextComponent> \u26037;
            TranslationTextComponent \u26036;
            boolean bl2;
            if (!this.field_148301_e.field_78841_f) {
                this.field_148301_e.field_78841_f = true;
                this.field_148301_e.field_78844_e = -2L;
                this.field_148301_e.field_78843_d = StringTextComponent.field_240750_d_;
                this.field_148301_e.field_78846_c = StringTextComponent.field_240750_d_;
                field_214358_b.submit(() -> {
                    try {
                        this.field_148303_c.func_146789_i().func_147224_a(this.field_148301_e, () -> this.field_148300_d.execute(this::func_241613_a_));
                    }
                    catch (UnknownHostException unknownHostException) {
                        this.field_148301_e.field_78844_e = -1L;
                        this.field_148301_e.field_78843_d = new TranslationTextComponent("multiplayer.status.cannot_resolve").func_240699_a_(TextFormatting.DARK_RED);
                    }
                    catch (Exception exception) {
                        this.field_148301_e.field_78844_e = -1L;
                        this.field_148301_e.field_78843_d = new TranslationTextComponent("multiplayer.status.cannot_connect").func_240699_a_(TextFormatting.DARK_RED);
                    }
                });
            }
            boolean bl3 = this.field_148301_e.field_82821_f > SharedConstants.func_215069_a().getProtocolVersion();
            \u2603 = this.field_148301_e.field_82821_f < SharedConstants.func_215069_a().getProtocolVersion();
            bl2 = bl3 || \u2603;
            this.field_148300_d.field_71466_p.func_238421_b_(matrixStack, this.field_148301_e.field_78847_a, n3 + 32 + 3, n2 + 1, 0xFFFFFF);
            List<ITextProperties> \u26032 = this.field_148300_d.field_71466_p.func_238425_b_(this.field_148301_e.field_78843_d, n4 - 32 - 2);
            for (int i = 0; i < Math.min(\u26032.size(), 2); ++i) {
                this.field_148300_d.field_71466_p.func_238422_b_(matrixStack, \u26032.get(i), n3 + 32 + 3, n2 + 12 + this.field_148300_d.field_71466_p.field_78288_b * i, 0x808080);
            }
            ITextComponent \u26033 = bl2 ? this.field_148301_e.field_82822_g.func_230532_e_().func_240699_a_(TextFormatting.DARK_RED) : this.field_148301_e.field_78846_c;
            int \u26034 = this.field_148300_d.field_71466_p.func_238414_a_(\u26033);
            this.field_148300_d.field_71466_p.func_238422_b_(matrixStack, \u26033, n3 + n4 - \u26034 - 15 - 2, n2 + 1, 0x808080);
            int \u26035 = 0;
            if (bl2) {
                int n8 = 5;
                \u26036 = new TranslationTextComponent(bl3 ? "multiplayer.status.client_out_of_date" : "multiplayer.status.server_out_of_date");
                \u26037 = this.field_148301_e.field_147412_i;
            } else if (this.field_148301_e.field_78841_f && this.field_148301_e.field_78844_e != -2L) {
                n8 = this.field_148301_e.field_78844_e < 0L ? 5 : (this.field_148301_e.field_78844_e < 150L ? 0 : (this.field_148301_e.field_78844_e < 300L ? 1 : (this.field_148301_e.field_78844_e < 600L ? 2 : (this.field_148301_e.field_78844_e < 1000L ? 3 : 4))));
                if (this.field_148301_e.field_78844_e < 0L) {
                    \u26036 = new TranslationTextComponent("multiplayer.status.no_connection");
                    \u26037 = Collections.emptyList();
                } else {
                    \u26036 = new TranslationTextComponent("multiplayer.status.ping", this.field_148301_e.field_78844_e);
                    \u26037 = this.field_148301_e.field_147412_i;
                }
            } else {
                \u26035 = 1;
                n8 = (int)(Util.func_211177_b() / 100L + (long)(n * 2) & 7L);
                if (n8 > 4) {
                    n8 = 8 - n8;
                }
                \u26036 = new TranslationTextComponent("multiplayer.status.pinging");
                \u26037 = Collections.emptyList();
            }
            RenderSystem.color4f(1.0f, 1.0f, 1.0f, 1.0f);
            this.field_148300_d.func_110434_K().func_110577_a(AbstractGui.field_230665_h_);
            AbstractGui.func_238463_a_(matrixStack, n3 + n4 - 15, n2, \u26035 * 10, 176 + n8 * 8, 10, 8, 256, 256);
            String string = this.field_148301_e.func_147409_e();
            if (!Objects.equals(string, this.field_148299_g)) {
                if (this.func_241614_a_(string)) {
                    this.field_148299_g = string;
                } else {
                    this.field_148301_e.func_147407_a(null);
                    this.func_241613_a_();
                }
            }
            if (this.field_148305_h != null) {
                this.func_238859_a_(matrixStack, n3, n2, this.field_148306_i);
            } else {
                this.func_238859_a_(matrixStack, n3, n2, field_214359_c);
            }
            int \u26038 = n6 - n3;
            int \u26039 = n7 - n2;
            if (\u26038 >= n4 - 15 && \u26038 <= n4 - 5 && \u26039 >= 0 && \u26039 <= 8) {
                this.field_148303_c.func_238854_b_(Collections.singletonList(\u26036));
            } else if (\u26038 >= n4 - \u26034 - 15 - 2 && \u26038 <= n4 - 15 - 2 && \u26039 >= 0 && \u26039 <= 8) {
                this.field_148303_c.func_238854_b_(\u26037);
            }
            if (this.field_148300_d.field_71474_y.field_85185_A || bl) {
                this.field_148300_d.func_110434_K().func_110577_a(field_214360_d);
                AbstractGui.func_238467_a_(matrixStack, n3, n2, n3 + 32, n2 + 32, -1601138544);
                RenderSystem.color4f(1.0f, 1.0f, 1.0f, 1.0f);
                int n9 = n6 - n3;
                \u2603 = n7 - n2;
                if (this.func_178013_b()) {
                    if (n9 < 32 && n9 > 16) {
                        AbstractGui.func_238463_a_(matrixStack, n3, n2, 0.0f, 32.0f, 32, 32, 256, 256);
                    } else {
                        AbstractGui.func_238463_a_(matrixStack, n3, n2, 0.0f, 0.0f, 32, 32, 256, 256);
                    }
                }
                if (n > 0) {
                    if (n9 < 16 && \u2603 < 16) {
                        AbstractGui.func_238463_a_(matrixStack, n3, n2, 96.0f, 32.0f, 32, 32, 256, 256);
                    } else {
                        AbstractGui.func_238463_a_(matrixStack, n3, n2, 96.0f, 0.0f, 32, 32, 256, 256);
                    }
                }
                if (n < this.field_148303_c.func_146795_p().func_78856_c() - 1) {
                    if (n9 < 16 && \u2603 > 16) {
                        AbstractGui.func_238463_a_(matrixStack, n3, n2, 64.0f, 32.0f, 32, 32, 256, 256);
                    } else {
                        AbstractGui.func_238463_a_(matrixStack, n3, n2, 64.0f, 0.0f, 32, 32, 256, 256);
                    }
                }
            }
        }

        public void func_241613_a_() {
            this.field_148303_c.func_146795_p().func_78855_b();
        }

        protected void func_238859_a_(MatrixStack matrixStack, int n, int n2, ResourceLocation resourceLocation) {
            this.field_148300_d.func_110434_K().func_110577_a(resourceLocation);
            RenderSystem.enableBlend();
            AbstractGui.func_238463_a_(matrixStack, n, n2, 0.0f, 0.0f, 32, 32, 32, 32);
            RenderSystem.disableBlend();
        }

        private boolean func_178013_b() {
            return true;
        }

        private boolean func_241614_a_(@Nullable String string) {
            if (string == null) {
                this.field_148300_d.func_110434_K().func_147645_c(this.field_148306_i);
                if (this.field_148305_h != null && this.field_148305_h.func_195414_e() != null) {
                    this.field_148305_h.func_195414_e().close();
                }
                this.field_148305_h = null;
            } else {
                try {
                    NativeImage nativeImage = NativeImage.func_216511_b(string);
                    Validate.validState((nativeImage.func_195702_a() == 64 ? 1 : 0) != 0, (String)"Must be 64 pixels wide", (Object[])new Object[0]);
                    Validate.validState((nativeImage.func_195714_b() == 64 ? 1 : 0) != 0, (String)"Must be 64 pixels high", (Object[])new Object[0]);
                    if (this.field_148305_h == null) {
                        this.field_148305_h = new DynamicTexture(nativeImage);
                    } else {
                        this.field_148305_h.func_195415_a(nativeImage);
                        this.field_148305_h.func_110564_a();
                    }
                    this.field_148300_d.func_110434_K().func_229263_a_(this.field_148306_i, this.field_148305_h);
                }
                catch (Throwable throwable) {
                    field_214357_a.error("Invalid icon for server {} ({})", (Object)this.field_148301_e.field_78847_a, (Object)this.field_148301_e.field_78845_b, (Object)throwable);
                    return false;
                }
            }
            return true;
        }

        @Override
        public boolean func_231046_a_(int n, int n2, int n3) {
            if (Screen.func_231173_s_()) {
                ServerSelectionList serverSelectionList = this.field_148303_c.field_146803_h;
                int \u26032 = serverSelectionList.func_231039_at__().indexOf(this);
                if (n == 264 && \u26032 < this.field_148303_c.func_146795_p().func_78856_c() - 1 || n == 265 && \u26032 > 0) {
                    this.func_228196_a_(\u26032, n == 264 ? \u26032 + 1 : \u26032 - 1);
                    return true;
                }
            }
            return super.func_231046_a_(n, n2, n3);
        }

        private void func_228196_a_(int n, int n2) {
            this.field_148303_c.func_146795_p().func_78857_a(n, n2);
            this.field_148303_c.field_146803_h.func_148195_a(this.field_148303_c.func_146795_p());
            Entry entry = (Entry)this.field_148303_c.field_146803_h.func_231039_at__().get(n2);
            this.field_148303_c.field_146803_h.func_241215_a_(entry);
            ServerSelectionList.this.func_230954_d_(entry);
        }

        @Override
        public boolean func_231044_a_(double d, double d2, int n) {
            double d3 = d - (double)ServerSelectionList.this.func_230968_n_();
            \u2603 = d2 - (double)ServerSelectionList.this.func_230962_i_(ServerSelectionList.this.func_231039_at__().indexOf(this));
            if (d3 <= 32.0) {
                if (d3 < 32.0 && d3 > 16.0 && this.func_178013_b()) {
                    this.field_148303_c.func_214287_a(this);
                    this.field_148303_c.func_146796_h();
                    return true;
                }
                int n2 = this.field_148303_c.field_146803_h.func_231039_at__().indexOf(this);
                if (d3 < 16.0 && \u2603 < 16.0 && n2 > 0) {
                    this.func_228196_a_(n2, n2 - 1);
                    return true;
                }
                if (d3 < 16.0 && \u2603 > 16.0 && n2 < this.field_148303_c.func_146795_p().func_78856_c() - 1) {
                    this.func_228196_a_(n2, n2 + 1);
                    return true;
                }
            }
            this.field_148303_c.func_214287_a(this);
            if (Util.func_211177_b() - this.field_148298_f < 250L) {
                this.field_148303_c.func_146796_h();
            }
            this.field_148298_f = Util.func_211177_b();
            return false;
        }

        public ServerData func_148296_a() {
            return this.field_148301_e;
        }
    }

    public static class LanDetectedEntry
    extends Entry {
        private final MultiplayerScreen field_148292_c;
        protected final Minecraft field_148293_a;
        protected final LanServerInfo field_148291_b;
        private long field_148290_d;

        protected LanDetectedEntry(MultiplayerScreen multiplayerScreen, LanServerInfo lanServerInfo) {
            this.field_148292_c = multiplayerScreen;
            this.field_148291_b = lanServerInfo;
            this.field_148293_a = Minecraft.func_71410_x();
        }

        @Override
        public void func_230432_a_(MatrixStack matrixStack, int n, int n2, int n3, int n4, int n5, int n6, int n7, boolean bl, float f) {
            this.field_148293_a.field_71466_p.func_238421_b_(matrixStack, I18n.func_135052_a("lanServer.title", new Object[0]), n3 + 32 + 3, n2 + 1, 0xFFFFFF);
            this.field_148293_a.field_71466_p.func_238421_b_(matrixStack, this.field_148291_b.func_77487_a(), n3 + 32 + 3, n2 + 12, 0x808080);
            if (this.field_148293_a.field_71474_y.field_80005_w) {
                this.field_148293_a.field_71466_p.func_238421_b_(matrixStack, I18n.func_135052_a("selectServer.hiddenAddress", new Object[0]), n3 + 32 + 3, n2 + 12 + 11, 0x303030);
            } else {
                this.field_148293_a.field_71466_p.func_238421_b_(matrixStack, this.field_148291_b.func_77488_b(), n3 + 32 + 3, n2 + 12 + 11, 0x303030);
            }
        }

        @Override
        public boolean func_231044_a_(double d, double d2, int n) {
            this.field_148292_c.func_214287_a(this);
            if (Util.func_211177_b() - this.field_148290_d < 250L) {
                this.field_148292_c.func_146796_h();
            }
            this.field_148290_d = Util.func_211177_b();
            return false;
        }

        public LanServerInfo func_189995_a() {
            return this.field_148291_b;
        }
    }

    public static class LanScanEntry
    extends Entry {
        private final Minecraft field_148288_a = Minecraft.func_71410_x();

        @Override
        public void func_230432_a_(MatrixStack matrixStack2, int n, int n2, int n3, int n4, int n5, int n6, int n7, boolean bl, float f) {
            MatrixStack matrixStack2;
            int n8 = n2 + n5 / 2 - this.field_148288_a.field_71466_p.field_78288_b / 2;
            this.field_148288_a.field_71466_p.func_238421_b_(matrixStack2, I18n.func_135052_a("lanServer.scanning", new Object[0]), this.field_148288_a.field_71462_r.field_230708_k_ / 2 - this.field_148288_a.field_71466_p.func_78256_a(I18n.func_135052_a("lanServer.scanning", new Object[0])) / 2, n8, 0xFFFFFF);
            switch ((int)(Util.func_211177_b() / 300L % 4L)) {
                default: {
                    String string = "O o o";
                    break;
                }
                case 1: 
                case 3: {
                    String string = "o O o";
                    break;
                }
                case 2: {
                    String string = "o o O";
                }
            }
            this.field_148288_a.field_71466_p.func_238421_b_(matrixStack2, string, this.field_148288_a.field_71462_r.field_230708_k_ / 2 - this.field_148288_a.field_71466_p.func_78256_a(string) / 2, n8 + this.field_148288_a.field_71466_p.field_78288_b, 0x808080);
        }
    }

    public static abstract class Entry
    extends ExtendedList.AbstractListEntry<Entry> {
    }
}

