/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.screen;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FocusableGui;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.IRenderable;
import net.minecraft.client.gui.screen.ConfirmOpenLinkScreen;
import net.minecraft.client.gui.screen.IScreen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.WorldVertexBufferUploader;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.client.util.InputMappings;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.crash.ReportedException;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Util;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraft.util.text.event.HoverEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class Screen
extends FocusableGui
implements IScreen,
IRenderable {
    private static final Logger field_230701_a_ = LogManager.getLogger();
    private static final Set<String> field_230702_b_ = Sets.newHashSet((Object[])new String[]{"http", "https"});
    protected final ITextComponent field_230704_d_;
    protected final List<IGuiEventListener> field_230705_e_ = Lists.newArrayList();
    @Nullable
    protected Minecraft field_230706_i_;
    protected ItemRenderer field_230707_j_;
    public int field_230708_k_;
    public int field_230709_l_;
    protected final List<Widget> field_230710_m_ = Lists.newArrayList();
    public boolean field_230711_n_;
    protected FontRenderer field_230712_o_;
    private URI field_230703_c_;

    protected Screen(ITextComponent iTextComponent) {
        this.field_230704_d_ = iTextComponent;
    }

    public ITextComponent func_231171_q_() {
        return this.field_230704_d_;
    }

    public String func_231167_h_() {
        return this.func_231171_q_().getString();
    }

    @Override
    public void func_230430_a_(MatrixStack matrixStack, int n, int n2, float f) {
        for (int i = 0; i < this.field_230710_m_.size(); ++i) {
            this.field_230710_m_.get(i).func_230430_a_(matrixStack, n, n2, f);
        }
    }

    @Override
    public boolean func_231046_a_(int n, int n2, int n3) {
        if (n == 256 && this.func_231178_ax__()) {
            this.func_231175_as__();
            return true;
        }
        if (n == 258) {
            boolean bl = \u2603 = !Screen.func_231173_s_();
            if (!this.func_231049_c__(\u2603)) {
                this.func_231049_c__(\u2603);
            }
            return true;
        }
        return super.func_231046_a_(n, n2, n3);
    }

    public boolean func_231178_ax__() {
        return true;
    }

    public void func_231175_as__() {
        this.field_230706_i_.func_147108_a(null);
    }

    protected <T extends Widget> T func_230480_a_(T t) {
        this.field_230710_m_.add(t);
        return this.func_230481_d_(t);
    }

    protected <T extends IGuiEventListener> T func_230481_d_(T t) {
        this.field_230705_e_.add(t);
        return t;
    }

    protected void func_230457_a_(MatrixStack matrixStack, ItemStack itemStack, int n, int n2) {
        this.func_238654_b_(matrixStack, this.func_231151_a_(itemStack), n, n2);
    }

    public List<ITextComponent> func_231151_a_(ItemStack itemStack) {
        return itemStack.func_82840_a(this.field_230706_i_.field_71439_g, this.field_230706_i_.field_71474_y.field_82882_x ? ITooltipFlag.TooltipFlags.ADVANCED : ITooltipFlag.TooltipFlags.NORMAL);
    }

    public void func_238652_a_(MatrixStack matrixStack, ITextProperties iTextProperties, int n, int n2) {
        this.func_238654_b_(matrixStack, Arrays.asList(iTextProperties), n, n2);
    }

    /*
     * WARNING - void declaration
     */
    public void func_238654_b_(MatrixStack matrixStack2, List<? extends ITextProperties> list, int n3, int n2) {
        int n;
        if (list.isEmpty()) {
            return;
        }
        int n4 = 0;
        for (ITextProperties iTextProperties : list) {
            int n42 = this.field_230712_o_.func_238414_a_(iTextProperties);
            if (n42 <= n4) continue;
            n4 = n42;
        }
        \u2603 = n3 + 12;
        int n5 = n2 - 12;
        \u2603 = n4;
        \u2603 = 8;
        if (list.size() > 1) {
            \u2603 += 2 + (list.size() - 1) * 10;
        }
        if (\u2603 + n4 > this.field_230708_k_) {
            \u2603 -= 28 + n4;
        }
        if (n5 + \u2603 + 6 > this.field_230709_l_) {
            n = this.field_230709_l_ - \u2603 - 6;
        }
        matrixStack2.func_227860_a_();
        \u2603 = -267386864;
        \u2603 = 0x505000FF;
        \u2603 = 1344798847;
        \u2603 = 400;
        Tessellator \u26032 = Tessellator.func_178181_a();
        BufferBuilder \u26033 = \u26032.func_178180_c();
        \u26033.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        Matrix4f \u26034 = matrixStack2.func_227866_c_().func_227870_a_();
        Screen.func_238462_a_(\u26034, \u26033, \u2603 - 3, n - 4, \u2603 + \u2603 + 3, n - 3, 400, -267386864, -267386864);
        Screen.func_238462_a_(\u26034, \u26033, \u2603 - 3, n + \u2603 + 3, \u2603 + \u2603 + 3, n + \u2603 + 4, 400, -267386864, -267386864);
        Screen.func_238462_a_(\u26034, \u26033, \u2603 - 3, n - 3, \u2603 + \u2603 + 3, n + \u2603 + 3, 400, -267386864, -267386864);
        Screen.func_238462_a_(\u26034, \u26033, \u2603 - 4, n - 3, \u2603 - 3, n + \u2603 + 3, 400, -267386864, -267386864);
        Screen.func_238462_a_(\u26034, \u26033, \u2603 + \u2603 + 3, n - 3, \u2603 + \u2603 + 4, n + \u2603 + 3, 400, -267386864, -267386864);
        Screen.func_238462_a_(\u26034, \u26033, \u2603 - 3, n - 3 + 1, \u2603 - 3 + 1, n + \u2603 + 3 - 1, 400, 0x505000FF, 1344798847);
        Screen.func_238462_a_(\u26034, \u26033, \u2603 + \u2603 + 2, n - 3 + 1, \u2603 + \u2603 + 3, n + \u2603 + 3 - 1, 400, 0x505000FF, 1344798847);
        Screen.func_238462_a_(\u26034, \u26033, \u2603 - 3, n - 3, \u2603 + \u2603 + 3, n - 3 + 1, 400, 0x505000FF, 0x505000FF);
        Screen.func_238462_a_(\u26034, \u26033, \u2603 - 3, n + \u2603 + 2, \u2603 + \u2603 + 3, n + \u2603 + 3, 400, 1344798847, 1344798847);
        RenderSystem.enableDepthTest();
        RenderSystem.disableTexture();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.shadeModel(7425);
        \u26033.func_178977_d();
        WorldVertexBufferUploader.func_181679_a(\u26033);
        RenderSystem.shadeModel(7424);
        RenderSystem.disableBlend();
        RenderSystem.enableTexture();
        IRenderTypeBuffer.Impl \u26035 = IRenderTypeBuffer.func_228455_a_(Tessellator.func_178181_a().func_178180_c());
        matrixStack2.func_227861_a_(0.0, 0.0, 400.0);
        for (\u2603 = 0; \u2603 < list.size(); ++\u2603) {
            ITextProperties iTextProperties = list.get(\u2603);
            if (iTextProperties != null) {
                void var7_11;
                this.field_230712_o_.func_238416_a_(iTextProperties, \u2603, (float)var7_11, -1, true, \u26034, \u26035, false, 0, 0xF000F0);
            }
            if (\u2603 == 0) {
                var7_11 += 2;
            }
            var7_11 += 10;
        }
        \u26035.func_228461_a_();
        matrixStack2.func_227865_b_();
    }

    protected void func_238653_a_(MatrixStack matrixStack, @Nullable Style style, int n, int n2) {
        if (style == null || style.func_150210_i() == null) {
            return;
        }
        HoverEvent hoverEvent = style.func_150210_i();
        HoverEvent.ItemHover \u26032 = hoverEvent.func_240662_a_(HoverEvent.Action.field_230551_b_);
        if (\u26032 != null) {
            this.func_230457_a_(matrixStack, \u26032.func_240689_a_(), n, n2);
        } else {
            HoverEvent.EntityHover entityHover = hoverEvent.func_240662_a_(HoverEvent.Action.field_230552_c_);
            if (entityHover != null) {
                if (this.field_230706_i_.field_71474_y.field_82882_x) {
                    this.func_238654_b_(matrixStack, entityHover.func_240684_b_(), n, n2);
                }
            } else {
                ITextComponent iTextComponent = hoverEvent.func_240662_a_(HoverEvent.Action.field_230550_a_);
                if (iTextComponent != null) {
                    this.func_238654_b_(matrixStack, this.field_230706_i_.field_71466_p.func_238425_b_(iTextComponent, Math.max(this.field_230708_k_ / 2, 200)), n, n2);
                }
            }
        }
    }

    protected void func_231155_a_(String string, boolean bl) {
    }

    public boolean func_230455_a_(@Nullable Style style) {
        if (style == null) {
            return false;
        }
        ClickEvent clickEvent = style.func_150235_h();
        if (Screen.func_231173_s_()) {
            if (style.func_179986_j() != null) {
                this.func_231155_a_(style.func_179986_j(), false);
            }
        } else if (clickEvent != null) {
            block21: {
                if (clickEvent.func_150669_a() == ClickEvent.Action.OPEN_URL) {
                    if (!this.field_230706_i_.field_71474_y.field_74359_p) {
                        return false;
                    }
                    try {
                        URI uRI = new URI(clickEvent.func_150668_b());
                        String \u26032 = uRI.getScheme();
                        if (\u26032 == null) {
                            throw new URISyntaxException(clickEvent.func_150668_b(), "Missing protocol");
                        }
                        if (!field_230702_b_.contains(\u26032.toLowerCase(Locale.ROOT))) {
                            throw new URISyntaxException(clickEvent.func_150668_b(), "Unsupported protocol: " + \u26032.toLowerCase(Locale.ROOT));
                        }
                        if (this.field_230706_i_.field_71474_y.field_74358_q) {
                            this.field_230703_c_ = uRI;
                            this.field_230706_i_.func_147108_a(new ConfirmOpenLinkScreen(this::func_231162_c_, clickEvent.func_150668_b(), false));
                            break block21;
                        }
                        this.func_231156_a_(uRI);
                    }
                    catch (URISyntaxException uRISyntaxException) {
                        field_230701_a_.error("Can't open url for {}", (Object)clickEvent, (Object)uRISyntaxException);
                    }
                } else if (clickEvent.func_150669_a() == ClickEvent.Action.OPEN_FILE) {
                    URI uRI = new File(clickEvent.func_150668_b()).toURI();
                    this.func_231156_a_(uRI);
                } else if (clickEvent.func_150669_a() == ClickEvent.Action.SUGGEST_COMMAND) {
                    this.func_231155_a_(clickEvent.func_150668_b(), true);
                } else if (clickEvent.func_150669_a() == ClickEvent.Action.RUN_COMMAND) {
                    this.func_231159_b_(clickEvent.func_150668_b(), false);
                } else if (clickEvent.func_150669_a() == ClickEvent.Action.COPY_TO_CLIPBOARD) {
                    this.field_230706_i_.field_195559_v.func_197960_a(clickEvent.func_150668_b());
                } else {
                    field_230701_a_.error("Don't know how to handle {}", (Object)clickEvent);
                }
            }
            return true;
        }
        return false;
    }

    public void func_231161_c_(String string) {
        this.func_231159_b_(string, true);
    }

    public void func_231159_b_(String string, boolean bl) {
        if (bl) {
            this.field_230706_i_.field_71456_v.func_146158_b().func_146239_a(string);
        }
        this.field_230706_i_.field_71439_g.func_71165_d(string);
    }

    public void func_231158_b_(Minecraft minecraft, int n, int n2) {
        this.field_230706_i_ = minecraft;
        this.field_230707_j_ = minecraft.func_175599_af();
        this.field_230712_o_ = minecraft.field_71466_p;
        this.field_230708_k_ = n;
        this.field_230709_l_ = n2;
        this.field_230710_m_.clear();
        this.field_230705_e_.clear();
        this.func_231035_a_(null);
        this.func_231160_c_();
    }

    @Override
    public List<? extends IGuiEventListener> func_231039_at__() {
        return this.field_230705_e_;
    }

    protected void func_231160_c_() {
    }

    @Override
    public void func_231023_e_() {
    }

    public void func_231164_f_() {
    }

    public void func_230446_a_(MatrixStack matrixStack) {
        this.func_238651_a_(matrixStack, 0);
    }

    public void func_238651_a_(MatrixStack matrixStack, int n) {
        if (this.field_230706_i_.field_71441_e != null) {
            this.func_238468_a_(matrixStack, 0, 0, this.field_230708_k_, this.field_230709_l_, -1072689136, -804253680);
        } else {
            this.func_231165_f_(n);
        }
    }

    public void func_231165_f_(int n) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder \u26032 = tessellator.func_178180_c();
        this.field_230706_i_.func_110434_K().func_110577_a(field_230663_f_);
        RenderSystem.color4f(1.0f, 1.0f, 1.0f, 1.0f);
        float \u26033 = 32.0f;
        \u26032.func_181668_a(7, DefaultVertexFormats.field_181709_i);
        \u26032.func_225582_a_(0.0, this.field_230709_l_, 0.0).func_225583_a_(0.0f, (float)this.field_230709_l_ / 32.0f + (float)n).func_225586_a_(64, 64, 64, 255).func_181675_d();
        \u26032.func_225582_a_(this.field_230708_k_, this.field_230709_l_, 0.0).func_225583_a_((float)this.field_230708_k_ / 32.0f, (float)this.field_230709_l_ / 32.0f + (float)n).func_225586_a_(64, 64, 64, 255).func_181675_d();
        \u26032.func_225582_a_(this.field_230708_k_, 0.0, 0.0).func_225583_a_((float)this.field_230708_k_ / 32.0f, n).func_225586_a_(64, 64, 64, 255).func_181675_d();
        \u26032.func_225582_a_(0.0, 0.0, 0.0).func_225583_a_(0.0f, n).func_225586_a_(64, 64, 64, 255).func_181675_d();
        tessellator.func_78381_a();
    }

    public boolean func_231177_au__() {
        return true;
    }

    private void func_231162_c_(boolean bl) {
        if (bl) {
            this.func_231156_a_(this.field_230703_c_);
        }
        this.field_230703_c_ = null;
        this.field_230706_i_.func_147108_a(this);
    }

    private void func_231156_a_(URI uRI) {
        Util.func_110647_a().func_195642_a(uRI);
    }

    public static boolean func_231172_r_() {
        if (Minecraft.field_142025_a) {
            return InputMappings.func_216506_a(Minecraft.func_71410_x().func_228018_at_().func_198092_i(), 343) || InputMappings.func_216506_a(Minecraft.func_71410_x().func_228018_at_().func_198092_i(), 347);
        }
        return InputMappings.func_216506_a(Minecraft.func_71410_x().func_228018_at_().func_198092_i(), 341) || InputMappings.func_216506_a(Minecraft.func_71410_x().func_228018_at_().func_198092_i(), 345);
    }

    public static boolean func_231173_s_() {
        return InputMappings.func_216506_a(Minecraft.func_71410_x().func_228018_at_().func_198092_i(), 340) || InputMappings.func_216506_a(Minecraft.func_71410_x().func_228018_at_().func_198092_i(), 344);
    }

    public static boolean func_231174_t_() {
        return InputMappings.func_216506_a(Minecraft.func_71410_x().func_228018_at_().func_198092_i(), 342) || InputMappings.func_216506_a(Minecraft.func_71410_x().func_228018_at_().func_198092_i(), 346);
    }

    public static boolean func_231166_g_(int n) {
        return n == 88 && Screen.func_231172_r_() && !Screen.func_231173_s_() && !Screen.func_231174_t_();
    }

    public static boolean func_231168_h_(int n) {
        return n == 86 && Screen.func_231172_r_() && !Screen.func_231173_s_() && !Screen.func_231174_t_();
    }

    public static boolean func_231169_i_(int n) {
        return n == 67 && Screen.func_231172_r_() && !Screen.func_231173_s_() && !Screen.func_231174_t_();
    }

    public static boolean func_231170_j_(int n) {
        return n == 65 && Screen.func_231172_r_() && !Screen.func_231173_s_() && !Screen.func_231174_t_();
    }

    public void func_231152_a_(Minecraft minecraft, int n, int n2) {
        this.func_231158_b_(minecraft, n, n2);
    }

    public static void func_231153_a_(Runnable runnable, String string, String string2) {
        try {
            runnable.run();
        }
        catch (Throwable throwable) {
            CrashReport crashReport = CrashReport.func_85055_a(throwable, string);
            CrashReportCategory \u26032 = crashReport.func_85058_a("Affected screen");
            \u26032.func_189529_a("Screen name", () -> string2);
            throw new ReportedException(crashReport);
        }
    }

    protected boolean func_231154_a_(String string, char c, int n) {
        \u2603 = string.indexOf(58);
        \u2603 = string.indexOf(47);
        if (c == ':') {
            return (\u2603 == -1 || n <= \u2603) && \u2603 == -1;
        }
        if (c == '/') {
            return n > \u2603;
        }
        return c == '_' || c == '-' || c >= 'a' && c <= 'z' || c >= '0' && c <= '9' || c == '.';
    }

    @Override
    public boolean func_231047_b_(double d, double d2) {
        return true;
    }

    public void func_230476_a_(List<Path> list) {
    }
}

