/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.screen;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.DialogTexts;
import net.minecraft.client.gui.screen.ConfirmScreen;
import net.minecraft.client.gui.screen.PackLoadingManager;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.toasts.SystemToast;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.gui.widget.list.ResourcePackList;
import net.minecraft.util.Util;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class PackScreen
extends Screen {
    private static final Logger field_238883_a_ = LogManager.getLogger();
    private static final ITextComponent field_238884_b_ = new TranslationTextComponent("pack.dropInfo").func_240699_a_(TextFormatting.DARK_GRAY);
    private static final ITextComponent field_238885_c_ = new TranslationTextComponent("pack.folderInfo");
    private final PackLoadingManager<?> field_238887_q_;
    private final Screen field_238888_r_;
    private boolean field_238890_t_;
    private ResourcePackList field_238891_u_;
    private ResourcePackList field_238892_v_;
    private final File field_241817_w_;
    private Button field_238894_x_;

    public PackScreen(Screen screen, TranslationTextComponent translationTextComponent, Function<Runnable, PackLoadingManager<?>> function, File file) {
        super(translationTextComponent);
        this.field_238888_r_ = screen;
        this.field_238887_q_ = function.apply(this::func_238904_g_);
        this.field_241817_w_ = file;
    }

    @Override
    public void func_231164_f_() {
        if (this.field_238890_t_) {
            this.field_238890_t_ = false;
            this.field_238887_q_.func_241618_c_();
        }
    }

    @Override
    public void func_231175_as__() {
        this.field_238890_t_ = true;
        this.field_230706_i_.func_147108_a(this.field_238888_r_);
    }

    @Override
    protected void func_231160_c_() {
        this.field_238894_x_ = this.func_230480_a_(new Button(this.field_230708_k_ / 2 + 4, this.field_230709_l_ - 48, 150, 20, DialogTexts.field_240632_c_, button -> this.func_231175_as__()));
        this.func_230480_a_(new Button(this.field_230708_k_ / 2 - 154, this.field_230709_l_ - 48, 150, 20, new TranslationTextComponent("pack.openFolder"), button -> Util.func_110647_a().func_195641_a(this.field_241817_w_), (button, matrixStack, n, n2) -> this.func_238652_a_(matrixStack, field_238885_c_, n, n2)));
        this.field_238891_u_ = new ResourcePackList(this.field_230706_i_, 200, this.field_230709_l_, new TranslationTextComponent("pack.available.title"));
        this.field_238891_u_.func_230959_g_(this.field_230708_k_ / 2 - 4 - 200);
        this.field_230705_e_.add(this.field_238891_u_);
        this.field_238892_v_ = new ResourcePackList(this.field_230706_i_, 200, this.field_230709_l_, new TranslationTextComponent("pack.selected.title"));
        this.field_238892_v_.func_230959_g_(this.field_230708_k_ / 2 + 4);
        this.field_230705_e_.add(this.field_238892_v_);
        this.func_238904_g_();
    }

    private void func_238904_g_() {
        this.func_238899_a_(this.field_238892_v_, this.field_238887_q_.func_238869_b_());
        this.func_238899_a_(this.field_238891_u_, this.field_238887_q_.func_238865_a_());
        this.field_238894_x_.field_230693_o_ = !this.field_238892_v_.func_231039_at__().isEmpty();
    }

    private void func_238899_a_(ResourcePackList resourcePackList, Stream<PackLoadingManager.IPack> stream) {
        resourcePackList.func_231039_at__().clear();
        stream.forEach(iPack -> resourcePackList.func_231039_at__().add(new ResourcePackList.ResourcePackEntry(this.field_230706_i_, resourcePackList, this, (PackLoadingManager.IPack)iPack)));
    }

    private void func_238906_l_() {
        this.field_238887_q_.func_241619_d_();
        this.func_238904_g_();
        this.field_238890_t_ = true;
    }

    @Override
    public void func_230430_a_(MatrixStack matrixStack, int n, int n2, float f) {
        this.func_231165_f_(0);
        this.field_238891_u_.func_230430_a_(matrixStack, n, n2, f);
        this.field_238892_v_.func_230430_a_(matrixStack, n, n2, f);
        this.func_238472_a_(matrixStack, this.field_230712_o_, this.field_230704_d_, this.field_230708_k_ / 2, 8, 0xFFFFFF);
        this.func_238472_a_(matrixStack, this.field_230712_o_, field_238884_b_, this.field_230708_k_ / 2, 20, 0xFFFFFF);
        super.func_230430_a_(matrixStack, n, n2, f);
    }

    protected static void func_238895_a_(Minecraft minecraft, List<Path> list, Path path) {
        MutableBoolean mutableBoolean = new MutableBoolean();
        list.forEach(path2 -> {
            try (Stream<Path> stream = Files.walk(path2, new FileVisitOption[0]);){
                stream.forEach(path3 -> {
                    try {
                        Util.func_240984_a_(path2.getParent(), path, path3);
                    }
                    catch (IOException iOException) {
                        field_238883_a_.warn("Failed to copy datapack file  from {} to {}", path3, (Object)path, (Object)iOException);
                        mutableBoolean.setTrue();
                    }
                });
            }
            catch (IOException iOException) {
                field_238883_a_.warn("Failed to copy datapack file from {} to {}", path2, (Object)path);
                mutableBoolean.setTrue();
            }
        });
        if (mutableBoolean.isTrue()) {
            SystemToast.func_238539_c_(minecraft, path.toString());
        }
    }

    @Override
    public void func_230476_a_(List<Path> list) {
        String string = list.stream().map(Path::getFileName).map(Path::toString).collect(Collectors.joining(", "));
        this.field_230706_i_.func_147108_a(new ConfirmScreen(bl -> {
            if (bl) {
                PackScreen.func_238895_a_(this.field_230706_i_, list, this.field_241817_w_.toPath());
                this.func_238906_l_();
            }
            this.field_230706_i_.func_147108_a(this);
        }, new TranslationTextComponent("pack.dropConfirm"), new StringTextComponent(string)));
    }
}

