/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.screen;

import com.google.common.collect.ImmutableSet;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.datafixers.DataFixer;
import com.mojang.datafixers.util.Function4;
import it.unimi.dsi.fastutil.booleans.BooleanConsumer;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenCustomHashMap;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.DialogTexts;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.resources.I18n;
import net.minecraft.resources.IResourceManager;
import net.minecraft.server.IDynamicRegistries;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.Util;
import net.minecraft.util.WorldOptimizer;
import net.minecraft.util.datafix.codec.DatapackCodec;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.WorldSettings;
import net.minecraft.world.storage.IServerConfiguration;
import net.minecraft.world.storage.SaveFormat;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class OptimizeWorldScreen
extends Screen {
    private static final Logger field_239024_a_ = LogManager.getLogger();
    private static final Object2IntMap<RegistryKey<World>> field_212348_a = (Object2IntMap)Util.func_200696_a(new Object2IntOpenCustomHashMap(Util.func_212443_g()), object2IntOpenCustomHashMap -> {
        object2IntOpenCustomHashMap.put(World.field_234918_g_, -13408734);
        object2IntOpenCustomHashMap.put(World.field_234919_h_, -10075085);
        object2IntOpenCustomHashMap.put(World.field_234920_i_, -8943531);
        object2IntOpenCustomHashMap.defaultReturnValue(-2236963);
    });
    private final BooleanConsumer field_214332_b;
    private final WorldOptimizer field_212203_f;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public static OptimizeWorldScreen func_239025_a_(Minecraft minecraft, BooleanConsumer booleanConsumer, DataFixer dataFixer, SaveFormat.LevelSave levelSave, boolean bl) {
        IDynamicRegistries.Impl impl = IDynamicRegistries.func_239770_b_();
        try (Minecraft.PackManager \u26032 = minecraft.func_238189_a_(impl, Minecraft::func_238180_a_, (Function4<SaveFormat.LevelSave, IDynamicRegistries.Impl, IResourceManager, DatapackCodec, IServerConfiguration>)((Function4)Minecraft::func_238181_a_), false, levelSave);){
            IServerConfiguration \u26033 = \u26032.func_238226_c_();
            levelSave.func_237287_a_(impl, \u26033);
            ImmutableSet<RegistryKey<World>> \u26034 = \u26033.func_230418_z_().func_236226_g_();
            OptimizeWorldScreen optimizeWorldScreen = new OptimizeWorldScreen(booleanConsumer, dataFixer, levelSave, \u26033.func_230408_H_(), bl, \u26034);
            return optimizeWorldScreen;
        }
        catch (Exception exception) {
            field_239024_a_.warn("Failed to load datapacks, can't optimize world", (Throwable)exception);
            return null;
        }
    }

    private OptimizeWorldScreen(BooleanConsumer booleanConsumer, DataFixer dataFixer, SaveFormat.LevelSave levelSave, WorldSettings worldSettings, boolean bl, ImmutableSet<RegistryKey<World>> immutableSet) {
        super(new TranslationTextComponent("optimizeWorld.title", worldSettings.func_234947_a_()));
        this.field_214332_b = booleanConsumer;
        this.field_212203_f = new WorldOptimizer(levelSave, dataFixer, immutableSet, bl);
    }

    @Override
    protected void func_231160_c_() {
        super.func_231160_c_();
        this.func_230480_a_(new Button(this.field_230708_k_ / 2 - 100, this.field_230709_l_ / 4 + 150, 200, 20, DialogTexts.field_240633_d_, button -> {
            this.field_212203_f.func_212217_a();
            this.field_214332_b.accept(false);
        }));
    }

    @Override
    public void func_231023_e_() {
        if (this.field_212203_f.func_212218_b()) {
            this.field_214332_b.accept(true);
        }
    }

    @Override
    public void func_231175_as__() {
        this.field_214332_b.accept(false);
    }

    @Override
    public void func_231164_f_() {
        this.field_212203_f.func_212217_a();
    }

    @Override
    public void func_230430_a_(MatrixStack matrixStack2, int n, int n2, float f) {
        MatrixStack matrixStack2;
        this.func_230446_a_(matrixStack2);
        this.func_238472_a_(matrixStack2, this.field_230712_o_, this.field_230704_d_, this.field_230708_k_ / 2, 20, 0xFFFFFF);
        int n3 = this.field_230708_k_ / 2 - 150;
        \u2603 = this.field_230708_k_ / 2 + 150;
        \u2603 = this.field_230709_l_ / 4 + 100;
        \u2603 = \u2603 + 10;
        this.func_238472_a_(matrixStack2, this.field_230712_o_, this.field_212203_f.func_212215_m(), this.field_230708_k_ / 2, \u2603 - this.field_230712_o_.field_78288_b - 2, 0xA0A0A0);
        if (this.field_212203_f.func_212211_j() > 0) {
            OptimizeWorldScreen.func_238467_a_(matrixStack2, n3 - 1, \u2603 - 1, \u2603 + 1, \u2603 + 1, -16777216);
            this.func_238476_c_(matrixStack2, this.field_230712_o_, I18n.func_135052_a("optimizeWorld.info.converted", this.field_212203_f.func_212208_k()), n3, 40, 0xA0A0A0);
            this.func_238476_c_(matrixStack2, this.field_230712_o_, I18n.func_135052_a("optimizeWorld.info.skipped", this.field_212203_f.func_212209_l()), n3, 40 + this.field_230712_o_.field_78288_b + 3, 0xA0A0A0);
            this.func_238476_c_(matrixStack2, this.field_230712_o_, I18n.func_135052_a("optimizeWorld.info.total", this.field_212203_f.func_212211_j()), n3, 40 + (this.field_230712_o_.field_78288_b + 3) * 2, 0xA0A0A0);
            \u2603 = 0;
            for (RegistryKey registryKey : this.field_212203_f.func_233533_c_()) {
                int n4 = MathHelper.func_76141_d(this.field_212203_f.func_233531_a_(registryKey) * (float)(\u2603 - n3));
                OptimizeWorldScreen.func_238467_a_(matrixStack2, n3 + \u2603, \u2603, n3 + \u2603 + n4, \u2603, field_212348_a.getInt((Object)registryKey));
                \u2603 += n4;
            }
            int n5 = this.field_212203_f.func_212208_k() + this.field_212203_f.func_212209_l();
            this.func_238471_a_(matrixStack2, this.field_230712_o_, n5 + " / " + this.field_212203_f.func_212211_j(), this.field_230708_k_ / 2, \u2603 + 2 * this.field_230712_o_.field_78288_b + 2, 0xA0A0A0);
            this.func_238471_a_(matrixStack2, this.field_230712_o_, MathHelper.func_76141_d(this.field_212203_f.func_212207_i() * 100.0f) + "%", this.field_230708_k_ / 2, \u2603 + (\u2603 - \u2603) / 2 - this.field_230712_o_.field_78288_b / 2, 0xA0A0A0);
        }
        super.func_230430_a_(matrixStack2, n, n2, f);
    }
}

