/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.screen;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonIOException;
import com.google.gson.stream.JsonWriter;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.datafixers.util.Function4;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.JsonOps;
import it.unimi.dsi.fastutil.booleans.BooleanConsumer;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.ExecutionException;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.DialogTexts;
import net.minecraft.client.gui.screen.ConfirmBackupScreen;
import net.minecraft.client.gui.screen.OptimizeWorldScreen;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.toasts.SystemToast;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.resources.I18n;
import net.minecraft.resources.IResourceManager;
import net.minecraft.server.IDynamicRegistries;
import net.minecraft.util.Util;
import net.minecraft.util.datafix.codec.DatapackCodec;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.registry.WorldGenSettingsExport;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.gen.settings.DimensionGeneratorSettings;
import net.minecraft.world.storage.FolderName;
import net.minecraft.world.storage.IServerConfiguration;
import net.minecraft.world.storage.SaveFormat;
import net.minecraft.world.storage.WorldSummary;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class EditWorldScreen
extends Screen {
    private static final Logger field_239014_a_ = LogManager.getLogger();
    private static final Gson field_239015_b_ = new GsonBuilder().setPrettyPrinting().serializeNulls().disableHtmlEscaping().create();
    private Button field_195327_a;
    private final BooleanConsumer field_214311_b;
    private TextFieldWidget field_184859_f;
    private final SaveFormat.LevelSave field_239016_r_;

    public EditWorldScreen(BooleanConsumer booleanConsumer, SaveFormat.LevelSave levelSave) {
        super(new TranslationTextComponent("selectWorld.edit.title"));
        this.field_214311_b = booleanConsumer;
        this.field_239016_r_ = levelSave;
    }

    @Override
    public void func_231023_e_() {
        this.field_184859_f.func_146178_a();
    }

    @Override
    protected void func_231160_c_() {
        this.field_230706_i_.field_195559_v.func_197967_a(true);
        Button button2 = this.func_230480_a_(new Button(this.field_230708_k_ / 2 - 100, this.field_230709_l_ / 4 + 0 + 5, 200, 20, new TranslationTextComponent("selectWorld.edit.resetIcon"), button -> {
            FileUtils.deleteQuietly((File)this.field_239016_r_.func_237298_f_());
            button.field_230693_o_ = false;
        }));
        this.func_230480_a_(new Button(this.field_230708_k_ / 2 - 100, this.field_230709_l_ / 4 + 24 + 5, 200, 20, new TranslationTextComponent("selectWorld.edit.openFolder"), button -> Util.func_110647_a().func_195641_a(this.field_239016_r_.func_237285_a_(FolderName.field_237253_i_).toFile())));
        this.func_230480_a_(new Button(this.field_230708_k_ / 2 - 100, this.field_230709_l_ / 4 + 48 + 5, 200, 20, new TranslationTextComponent("selectWorld.edit.backup"), button -> {
            boolean bl = EditWorldScreen.func_239019_a_(this.field_239016_r_);
            this.field_214311_b.accept(!bl);
        }));
        this.func_230480_a_(new Button(this.field_230708_k_ / 2 - 100, this.field_230709_l_ / 4 + 72 + 5, 200, 20, new TranslationTextComponent("selectWorld.edit.backupFolder"), button -> {
            SaveFormat saveFormat = this.field_230706_i_.func_71359_d();
            Path \u26032 = saveFormat.func_197712_e();
            try {
                Files.createDirectories(Files.exists(\u26032, new LinkOption[0]) ? \u26032.toRealPath(new LinkOption[0]) : \u26032, new FileAttribute[0]);
            }
            catch (IOException \u26033) {
                throw new RuntimeException(\u26033);
            }
            Util.func_110647_a().func_195641_a(\u26032.toFile());
        }));
        this.func_230480_a_(new Button(this.field_230708_k_ / 2 - 100, this.field_230709_l_ / 4 + 96 + 5, 200, 20, new TranslationTextComponent("selectWorld.edit.optimize"), button -> this.field_230706_i_.func_147108_a(new ConfirmBackupScreen(this, (bl, bl2) -> {
            if (bl) {
                EditWorldScreen.func_239019_a_(this.field_239016_r_);
            }
            this.field_230706_i_.func_147108_a(OptimizeWorldScreen.func_239025_a_(this.field_230706_i_, this.field_214311_b, this.field_230706_i_.func_184126_aj(), this.field_239016_r_, bl2));
        }, new TranslationTextComponent("optimizeWorld.confirm.title"), new TranslationTextComponent("optimizeWorld.confirm.description"), true))));
        this.func_230480_a_(new Button(this.field_230708_k_ / 2 - 100, this.field_230709_l_ / 4 + 120 + 5, 200, 20, new TranslationTextComponent("selectWorld.edit.export_worldgen_settings"), button -> {
            DataResult \u26033;
            Object object;
            IDynamicRegistries.Impl impl = IDynamicRegistries.func_239770_b_();
            try {
                object = this.field_230706_i_.func_238189_a_(impl, Minecraft::func_238180_a_, (Function4<SaveFormat.LevelSave, IDynamicRegistries.Impl, IResourceManager, DatapackCodec, IServerConfiguration>)((Function4)Minecraft::func_238181_a_), false, this.field_239016_r_);
                Throwable throwable = null;
                try {
                    WorldGenSettingsExport worldGenSettingsExport = WorldGenSettingsExport.func_240896_a_(JsonOps.INSTANCE, impl);
                    DataResult \u26032 = DimensionGeneratorSettings.field_236201_a_.encodeStart(worldGenSettingsExport, (Object)((Minecraft.PackManager)object).func_238226_c_().func_230418_z_());
                    \u26033 = \u26032.flatMap(jsonElement -> {
                        Path path = this.field_239016_r_.func_237285_a_(FolderName.field_237253_i_).resolve("worldgen_settings_export.json");
                        try (JsonWriter jsonWriter = field_239015_b_.newJsonWriter((Writer)Files.newBufferedWriter(path, StandardCharsets.UTF_8, new OpenOption[0]));){
                            field_239015_b_.toJson(jsonElement, jsonWriter);
                        }
                        catch (JsonIOException | IOException throwable) {
                            return DataResult.error((String)("Error writing file: " + throwable.getMessage()));
                        }
                        return DataResult.success((Object)path.toString());
                    });
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (object != null) {
                        if (throwable != null) {
                            try {
                                ((Minecraft.PackManager)object).close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        } else {
                            ((Minecraft.PackManager)object).close();
                        }
                    }
                }
            }
            catch (InterruptedException | ExecutionException exception) {
                \u26033 = DataResult.error((String)"Could not parse level data!");
            }
            object = new StringTextComponent((String)\u26033.get().map(Function.identity(), DataResult.PartialResult::message));
            TranslationTextComponent \u26034 = new TranslationTextComponent(\u26033.result().isPresent() ? "selectWorld.edit.export_worldgen_settings.success" : "selectWorld.edit.export_worldgen_settings.failure");
            \u26033.error().ifPresent(partialResult -> field_239014_a_.error("Error exporting world settings: {}", partialResult));
            this.field_230706_i_.func_193033_an().func_192988_a(SystemToast.func_238534_a_(this.field_230706_i_, SystemToast.Type.WORLD_GEN_SETTINGS_TRANSFER, \u26034, (ITextComponent)object));
        }));
        this.field_195327_a = this.func_230480_a_(new Button(this.field_230708_k_ / 2 - 100, this.field_230709_l_ / 4 + 144 + 5, 98, 20, new TranslationTextComponent("selectWorld.edit.save"), button -> this.func_195317_h()));
        this.func_230480_a_(new Button(this.field_230708_k_ / 2 + 2, this.field_230709_l_ / 4 + 144 + 5, 98, 20, DialogTexts.field_240633_d_, button -> this.field_214311_b.accept(false)));
        button2.field_230693_o_ = this.field_239016_r_.func_237298_f_().isFile();
        WorldSummary \u26032 = this.field_239016_r_.func_237296_d_();
        String \u26033 = \u26032 == null ? "" : \u26032.func_75788_b();
        this.field_184859_f = new TextFieldWidget(this.field_230712_o_, this.field_230708_k_ / 2 - 100, 38, 200, 20, new TranslationTextComponent("selectWorld.enterName"));
        this.field_184859_f.func_146180_a(\u26033);
        this.field_184859_f.func_212954_a(string -> {
            this.field_195327_a.field_230693_o_ = !string.trim().isEmpty();
        });
        this.field_230705_e_.add(this.field_184859_f);
        this.func_212928_a(this.field_184859_f);
    }

    @Override
    public void func_231152_a_(Minecraft minecraft, int n, int n2) {
        String string = this.field_184859_f.func_146179_b();
        this.func_231158_b_(minecraft, n, n2);
        this.field_184859_f.func_146180_a(string);
    }

    @Override
    public void func_231175_as__() {
        this.field_214311_b.accept(false);
    }

    @Override
    public void func_231164_f_() {
        this.field_230706_i_.field_195559_v.func_197967_a(false);
    }

    private void func_195317_h() {
        try {
            this.field_239016_r_.func_237290_a_(this.field_184859_f.func_146179_b().trim());
            this.field_214311_b.accept(true);
        }
        catch (IOException iOException) {
            field_239014_a_.error("Failed to access world '{}'", (Object)this.field_239016_r_.func_237282_a_(), (Object)iOException);
            SystemToast.func_238535_a_(this.field_230706_i_, this.field_239016_r_.func_237282_a_());
            this.field_214311_b.accept(true);
        }
    }

    public static void func_241651_a_(SaveFormat saveFormat, String string) {
        boolean bl = false;
        try (SaveFormat.LevelSave levelSave = saveFormat.func_237274_c_(string);){
            bl = true;
            EditWorldScreen.func_239019_a_(levelSave);
        }
        catch (IOException iOException) {
            if (!bl) {
                SystemToast.func_238535_a_(Minecraft.func_71410_x(), string);
            }
            field_239014_a_.warn("Failed to create backup of level {}", (Object)string, (Object)iOException);
        }
    }

    public static boolean func_239019_a_(SaveFormat.LevelSave levelSave) {
        long l = 0L;
        IOException \u26032 = null;
        try {
            l = levelSave.func_237300_h_();
        }
        catch (IOException \u26033) {
            \u26032 = \u26033;
        }
        if (\u26032 != null) {
            TranslationTextComponent translationTextComponent = new TranslationTextComponent("selectWorld.edit.backupFailed");
            StringTextComponent \u26034 = new StringTextComponent(\u26032.getMessage());
            Minecraft.func_71410_x().func_193033_an().func_192988_a(new SystemToast(SystemToast.Type.WORLD_BACKUP, translationTextComponent, \u26034));
            return false;
        }
        \u2603 = new TranslationTextComponent("selectWorld.edit.backupCreated", levelSave.func_237282_a_());
        \u2603 = new TranslationTextComponent("selectWorld.edit.backupSize", MathHelper.func_76143_f((double)l / 1048576.0));
        Minecraft.func_71410_x().func_193033_an().func_192988_a(new SystemToast(SystemToast.Type.WORLD_BACKUP, \u2603, \u2603));
        return true;
    }

    @Override
    public void func_230430_a_(MatrixStack matrixStack, int n, int n2, float f) {
        this.func_230446_a_(matrixStack);
        this.func_238472_a_(matrixStack, this.field_230712_o_, this.field_230704_d_, this.field_230708_k_ / 2, 15, 0xFFFFFF);
        this.func_238476_c_(matrixStack, this.field_230712_o_, I18n.func_135052_a("selectWorld.enterName", new Object[0]), this.field_230708_k_ / 2 - 100, 24, 0xA0A0A0);
        this.field_184859_f.func_230430_a_(matrixStack, n, n2, f);
        super.func_230430_a_(matrixStack, n, n2, f);
    }
}

