/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.screen;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.client.gui.DialogTexts;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.gui.widget.list.AbstractList;
import net.minecraft.client.gui.widget.list.AbstractOptionList;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.GameRules;

public class EditGamerulesScreen
extends Screen {
    private final Consumer<Optional<GameRules>> field_238965_a_;
    private GamerulesList field_238966_b_;
    private final Set<Gamerule> field_238967_c_ = Sets.newHashSet();
    private Button field_238968_p_;
    @Nullable
    private List<ITextProperties> field_238969_q_;
    private final GameRules field_238970_r_;

    public EditGamerulesScreen(GameRules gameRules, Consumer<Optional<GameRules>> consumer) {
        super(new TranslationTextComponent("editGamerule.title"));
        this.field_238970_r_ = gameRules;
        this.field_238965_a_ = consumer;
    }

    @Override
    protected void func_231160_c_() {
        this.field_230706_i_.field_195559_v.func_197967_a(true);
        super.func_231160_c_();
        this.field_238966_b_ = new GamerulesList(this.field_238970_r_);
        this.field_230705_e_.add(this.field_238966_b_);
        this.func_230480_a_(new Button(this.field_230708_k_ / 2 - 155 + 160, this.field_230709_l_ - 29, 150, 20, DialogTexts.field_240633_d_, button -> this.field_238965_a_.accept(Optional.empty())));
        this.field_238968_p_ = this.func_230480_a_(new Button(this.field_230708_k_ / 2 - 155, this.field_230709_l_ - 29, 150, 20, DialogTexts.field_240632_c_, button -> this.field_238965_a_.accept(Optional.of(this.field_238970_r_))));
    }

    @Override
    public void func_231164_f_() {
        this.field_230706_i_.field_195559_v.func_197967_a(false);
    }

    @Override
    public void func_231175_as__() {
        this.field_238965_a_.accept(Optional.empty());
    }

    @Override
    public void func_230430_a_(MatrixStack matrixStack, int n, int n2, float f) {
        this.field_238969_q_ = null;
        this.field_238966_b_.func_230430_a_(matrixStack, n, n2, f);
        this.func_238472_a_(matrixStack, this.field_230712_o_, this.field_230704_d_, this.field_230708_k_ / 2, 20, 0xFFFFFF);
        super.func_230430_a_(matrixStack, n, n2, f);
        if (this.field_238969_q_ != null) {
            this.func_238654_b_(matrixStack, this.field_238969_q_, n, n2);
        }
    }

    private void func_238980_b_(@Nullable List<ITextProperties> list) {
        this.field_238969_q_ = list;
    }

    private void func_238984_g_() {
        this.field_238968_p_.field_230693_o_ = this.field_238967_c_.isEmpty();
    }

    private void func_238972_a_(Gamerule gamerule) {
        this.field_238967_c_.add(gamerule);
        this.func_238984_g_();
    }

    private void func_238977_b_(Gamerule gamerule) {
        this.field_238967_c_.remove(gamerule);
        this.func_238984_g_();
    }

    public class GamerulesList
    extends AbstractOptionList<Gamerule> {
        public GamerulesList(final GameRules gameRules) {
            super(EditGamerulesScreen.this.field_230706_i_, EditGamerulesScreen.this.field_230708_k_, EditGamerulesScreen.this.field_230709_l_, 43, EditGamerulesScreen.this.field_230709_l_ - 32, 24);
            final HashMap hashMap = Maps.newHashMap();
            GameRules.func_223590_a(new GameRules.IRuleEntryVisitor(){

                @Override
                public void func_230482_b_(GameRules.RuleKey<GameRules.BooleanValue> ruleKey, GameRules.RuleType<GameRules.BooleanValue> ruleType) {
                    this.func_239011_a_(ruleKey, (iTextComponent, list, string, booleanValue) -> new BooleanEntry(iTextComponent, list, string, (GameRules.BooleanValue)booleanValue));
                }

                @Override
                public void func_230483_c_(GameRules.RuleKey<GameRules.IntegerValue> ruleKey, GameRules.RuleType<GameRules.IntegerValue> ruleType) {
                    this.func_239011_a_(ruleKey, (iTextComponent, list, string, integerValue) -> new IntegerEntry(iTextComponent, list, string, (GameRules.IntegerValue)integerValue));
                }

                private <T extends GameRules.RuleValue<T>> void func_239011_a_(GameRules.RuleKey<T> ruleKey, IRuleEntry<T> iRuleEntry) {
                    String \u26039;
                    ImmutableList \u26038;
                    TranslationTextComponent translationTextComponent = new TranslationTextComponent(ruleKey.func_234911_b_());
                    IFormattableTextComponent \u26032 = new StringTextComponent(ruleKey.func_223576_a()).func_240699_a_(TextFormatting.YELLOW);
                    T \u26033 = gameRules.func_223585_a(ruleKey);
                    String \u26034 = ((GameRules.RuleValue)\u26033).func_223552_b();
                    IFormattableTextComponent \u26035 = new TranslationTextComponent("editGamerule.default", new StringTextComponent(\u26034)).func_240699_a_(TextFormatting.GRAY);
                    String \u26036 = ruleKey.func_234911_b_() + ".description";
                    if (I18n.func_188566_a(\u26036)) {
                        ImmutableList.Builder builder = ImmutableList.builder().add((Object)\u26032);
                        TranslationTextComponent \u26037 = new TranslationTextComponent(\u26036);
                        EditGamerulesScreen.this.field_230712_o_.func_238425_b_(\u26037, 150).forEach(arg_0 -> ((ImmutableList.Builder)builder).add(arg_0));
                        \u26038 = builder.add((Object)\u26035).build();
                        \u26039 = \u26037.getString() + "\n" + \u26035.getString();
                    } else {
                        \u26038 = ImmutableList.of((Object)\u26032, (Object)\u26035);
                        \u26039 = \u26035.getString();
                    }
                    hashMap.computeIfAbsent(ruleKey.func_234912_c_(), category -> Maps.newHashMap()).put(ruleKey, iRuleEntry.create(translationTextComponent, (List<ITextProperties>)\u26038, \u26039, \u26033));
                }
            });
            hashMap.entrySet().stream().sorted(Map.Entry.comparingByKey()).forEach(entry2 -> {
                this.func_230513_b_(new NameEntry(new TranslationTextComponent(((GameRules.Category)((Object)((Object)entry2.getKey()))).func_234908_a_()).func_240701_a_(TextFormatting.BOLD, TextFormatting.YELLOW)));
                ((Map)entry2.getValue()).entrySet().stream().sorted(Map.Entry.comparingByKey(Comparator.comparing(GameRules.RuleKey::func_223576_a))).forEach(entry -> this.func_230513_b_((AbstractList.AbstractListEntry)entry.getValue()));
            });
        }

        @Override
        public void func_230430_a_(MatrixStack matrixStack, int n, int n2, float f) {
            super.func_230430_a_(matrixStack, n, n2, f);
            if (this.func_231047_b_(n, n2) && (\u2603 = (Gamerule)this.func_230933_a_(n, n2)) != null) {
                EditGamerulesScreen.this.func_238980_b_(\u2603.field_239000_a_);
            }
        }
    }

    public class IntegerEntry
    extends ValueEntry {
        private final TextFieldWidget field_238997_d_;

        public IntegerEntry(ITextComponent iTextComponent, List<ITextProperties> list, String string2, GameRules.IntegerValue integerValue) {
            super(list, iTextComponent);
            this.field_238997_d_ = new TextFieldWidget(((EditGamerulesScreen)EditGamerulesScreen.this).field_230706_i_.field_71466_p, 10, 5, 42, 20, iTextComponent.func_230532_e_().func_240702_b_("\n").func_240702_b_(string2).func_240702_b_("\n"));
            this.field_238997_d_.func_146180_a(Integer.toString(integerValue.func_223560_a()));
            this.field_238997_d_.func_212954_a(string -> {
                if (integerValue.func_234909_b_((String)string)) {
                    this.field_238997_d_.func_146193_g(0xE0E0E0);
                    EditGamerulesScreen.this.func_238977_b_(this);
                } else {
                    this.field_238997_d_.func_146193_g(0xFF0000);
                    EditGamerulesScreen.this.func_238972_a_(this);
                }
            });
            this.field_241647_b_.add(this.field_238997_d_);
        }

        @Override
        public void func_230432_a_(MatrixStack matrixStack, int n, int n2, int n3, int n4, int n5, int n6, int n7, boolean bl, float f) {
            this.func_241649_a_(matrixStack, n2, n3);
            this.field_238997_d_.field_230690_l_ = n3 + n4 - 44;
            this.field_238997_d_.field_230691_m_ = n2;
            this.field_238997_d_.func_230430_a_(matrixStack, n6, n7, f);
        }
    }

    public class BooleanEntry
    extends ValueEntry {
        private final Button field_238986_c_;

        public BooleanEntry(final ITextComponent iTextComponent, List<ITextProperties> list, final String string, final GameRules.BooleanValue booleanValue) {
            super(list, iTextComponent);
            this.field_238986_c_ = new Button(10, 5, 44, 20, DialogTexts.func_240638_a_(booleanValue.func_223572_a()), button -> {
                boolean bl = !booleanValue.func_223572_a();
                booleanValue.func_223570_a(bl, null);
                button.func_238482_a_(DialogTexts.func_240638_a_(booleanValue.func_223572_a()));
            }){

                @Override
                protected IFormattableTextComponent func_230442_c_() {
                    return BooleanEntry.this.func_238989_a_(iTextComponent, booleanValue.func_223572_a()).func_230532_e_().func_240702_b_("\n").func_240702_b_(string);
                }
            };
            this.field_241647_b_.add(this.field_238986_c_);
        }

        private IFormattableTextComponent func_238989_a_(ITextComponent iTextComponent, boolean bl) {
            return new StringTextComponent("").func_230529_a_(iTextComponent).func_240702_b_(": ").func_230529_a_(DialogTexts.func_240638_a_(bl));
        }

        @Override
        public void func_230432_a_(MatrixStack matrixStack, int n, int n2, int n3, int n4, int n5, int n6, int n7, boolean bl, float f) {
            this.func_241649_a_(matrixStack, n2, n3);
            this.field_238986_c_.field_230690_l_ = n3 + n4 - 45;
            this.field_238986_c_.field_230691_m_ = n2;
            this.field_238986_c_.func_230430_a_(matrixStack, n6, n7, f);
        }
    }

    public abstract class ValueEntry
    extends Gamerule {
        private final List<ITextProperties> field_241646_a_;
        protected final List<IGuiEventListener> field_241647_b_;

        public ValueEntry(@Nullable List<ITextProperties> list, ITextComponent iTextComponent) {
            super(list);
            this.field_241647_b_ = Lists.newArrayList();
            this.field_241646_a_ = ((EditGamerulesScreen)EditGamerulesScreen.this).field_230706_i_.field_71466_p.func_238425_b_(iTextComponent, 175);
        }

        @Override
        public List<? extends IGuiEventListener> func_231039_at__() {
            return this.field_241647_b_;
        }

        protected void func_241649_a_(MatrixStack matrixStack, int n, int n2) {
            if (this.field_241646_a_.size() == 1) {
                ((EditGamerulesScreen)EditGamerulesScreen.this).field_230706_i_.field_71466_p.func_238422_b_(matrixStack, this.field_241646_a_.get(0), n2, n + 5, 0xFFFFFF);
            } else if (this.field_241646_a_.size() >= 2) {
                ((EditGamerulesScreen)EditGamerulesScreen.this).field_230706_i_.field_71466_p.func_238422_b_(matrixStack, this.field_241646_a_.get(0), n2, n, 0xFFFFFF);
                ((EditGamerulesScreen)EditGamerulesScreen.this).field_230706_i_.field_71466_p.func_238422_b_(matrixStack, this.field_241646_a_.get(1), n2, n + 10, 0xFFFFFF);
            }
        }
    }

    @FunctionalInterface
    static interface IRuleEntry<T extends GameRules.RuleValue<T>> {
        public Gamerule create(ITextComponent var1, List<ITextProperties> var2, String var3, T var4);
    }

    public class NameEntry
    extends Gamerule {
        private final ITextComponent field_238994_c_;

        public NameEntry(ITextComponent iTextComponent) {
            super(null);
            this.field_238994_c_ = iTextComponent;
        }

        @Override
        public void func_230432_a_(MatrixStack matrixStack, int n, int n2, int n3, int n4, int n5, int n6, int n7, boolean bl, float f) {
            EditGamerulesScreen.this.func_238472_a_(matrixStack, ((EditGamerulesScreen)EditGamerulesScreen.this).field_230706_i_.field_71466_p, this.field_238994_c_, n3 + n4 / 2, n2 + 5, 0xFFFFFF);
        }

        @Override
        public List<? extends IGuiEventListener> func_231039_at__() {
            return ImmutableList.of();
        }
    }

    public abstract class Gamerule
    extends AbstractOptionList.Entry<Gamerule> {
        @Nullable
        private final List<ITextProperties> field_239000_a_;

        public Gamerule(@Nullable List<ITextProperties> list) {
            this.field_239000_a_ = list;
        }
    }
}

