/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.screen;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.DialogTexts;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.screen.ConfirmScreen;
import net.minecraft.client.gui.screen.DataPackScreen;
import net.minecraft.client.gui.screen.DirtMessageScreen;
import net.minecraft.client.gui.screen.EditGamerulesScreen;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.screen.WorldOptionsScreen;
import net.minecraft.client.gui.toasts.SystemToast;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.resources.I18n;
import net.minecraft.command.Commands;
import net.minecraft.resources.DataPackRegistries;
import net.minecraft.resources.FolderPackFinder;
import net.minecraft.resources.IPackNameDecorator;
import net.minecraft.resources.ResourcePackInfo;
import net.minecraft.resources.ResourcePackList;
import net.minecraft.resources.ServerPackFinder;
import net.minecraft.server.IDynamicRegistries;
import net.minecraft.util.FileUtil;
import net.minecraft.util.Util;
import net.minecraft.util.datafix.codec.DatapackCodec;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.Difficulty;
import net.minecraft.world.GameRules;
import net.minecraft.world.GameType;
import net.minecraft.world.WorldSettings;
import net.minecraft.world.gen.settings.DimensionGeneratorSettings;
import net.minecraft.world.storage.FolderName;
import net.minecraft.world.storage.SaveFormat;
import org.apache.commons.lang3.mutable.MutableObject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CreateWorldScreen
extends Screen {
    private static final Logger field_238935_p_ = LogManager.getLogger();
    private final Screen field_146332_f;
    private TextFieldWidget field_146333_g;
    private String field_146336_i;
    private GameMode field_228197_f_ = GameMode.SURVIVAL;
    @Nullable
    private GameMode field_228198_g_;
    private Difficulty field_238936_v_ = Difficulty.NORMAL;
    private Difficulty field_238937_w_ = Difficulty.NORMAL;
    private boolean field_146340_t;
    private boolean field_146339_u;
    public boolean field_146337_w;
    protected DatapackCodec field_238933_b_ = DatapackCodec.field_234880_a_;
    @Nullable
    private Path field_238928_A_;
    private boolean field_146344_y;
    private Button field_195355_B;
    private Button field_146343_z;
    private Button field_238929_E_;
    private Button field_146324_A;
    private Button field_238930_G_;
    private Button field_238931_H_;
    private Button field_146321_E;
    private ITextComponent field_146323_G;
    private ITextComponent field_146328_H;
    private String field_146330_J;
    private GameRules field_238932_M_ = new GameRules();
    public final WorldOptionsScreen field_238934_c_;

    public CreateWorldScreen(@Nullable Screen screen, WorldSettings worldSettings, DimensionGeneratorSettings dimensionGeneratorSettings, @Nullable Path path, IDynamicRegistries.Impl impl) {
        this(screen, new WorldOptionsScreen(impl, dimensionGeneratorSettings));
        this.field_146330_J = worldSettings.func_234947_a_();
        this.field_146340_t = worldSettings.func_234956_e_();
        this.field_146339_u = true;
        this.field_238937_w_ = this.field_238936_v_ = worldSettings.func_234955_d_();
        this.field_238932_M_.func_234899_a_(worldSettings.func_234957_f_(), null);
        this.field_238933_b_ = worldSettings.func_234958_g_();
        if (worldSettings.func_234954_c_()) {
            this.field_228197_f_ = GameMode.HARDCORE;
        } else if (worldSettings.func_234953_b_().func_77144_e()) {
            this.field_228197_f_ = GameMode.SURVIVAL;
        } else if (worldSettings.func_234953_b_().func_77145_d()) {
            this.field_228197_f_ = GameMode.CREATIVE;
        }
        this.field_238928_A_ = path;
    }

    public CreateWorldScreen(@Nullable Screen screen) {
        this(screen, new WorldOptionsScreen());
    }

    private CreateWorldScreen(@Nullable Screen screen, WorldOptionsScreen worldOptionsScreen) {
        super(new TranslationTextComponent("selectWorld.create"));
        this.field_146332_f = screen;
        this.field_146330_J = I18n.func_135052_a("selectWorld.newWorld", new Object[0]);
        this.field_238934_c_ = worldOptionsScreen;
    }

    @Override
    public void func_231023_e_() {
        this.field_146333_g.func_146178_a();
        this.field_238934_c_.func_231023_e_();
    }

    @Override
    protected void func_231160_c_() {
        this.field_230706_i_.field_195559_v.func_197967_a(true);
        this.field_146333_g = new TextFieldWidget(this.field_230712_o_, this.field_230708_k_ / 2 - 100, 60, 200, 20, (ITextComponent)new TranslationTextComponent("selectWorld.enterName")){

            @Override
            protected IFormattableTextComponent func_230442_c_() {
                return super.func_230442_c_().func_240702_b_(". ").func_230529_a_(new TranslationTextComponent("selectWorld.resultFolder")).func_240702_b_(" ").func_240702_b_(CreateWorldScreen.this.field_146336_i);
            }
        };
        this.field_146333_g.func_146180_a(this.field_146330_J);
        this.field_146333_g.func_212954_a(string -> {
            this.field_146330_J = string;
            this.field_195355_B.field_230693_o_ = !this.field_146333_g.func_146179_b().isEmpty();
            this.func_146314_g();
        });
        this.field_230705_e_.add(this.field_146333_g);
        int n = this.field_230708_k_ / 2 - 155;
        \u2603 = this.field_230708_k_ / 2 + 5;
        this.field_146343_z = this.func_230480_a_(new Button(n, 100, 150, 20, new TranslationTextComponent("selectWorld.gameMode"), button -> {
            switch (this.field_228197_f_) {
                case SURVIVAL: {
                    this.func_228200_a_(GameMode.HARDCORE);
                    break;
                }
                case HARDCORE: {
                    this.func_228200_a_(GameMode.CREATIVE);
                    break;
                }
                case CREATIVE: {
                    this.func_228200_a_(GameMode.SURVIVAL);
                }
            }
            button.func_230994_c_(250);
        }){

            @Override
            public ITextComponent func_230458_i_() {
                return super.func_230458_i_().func_230532_e_().func_240702_b_(": ").func_230529_a_(new TranslationTextComponent("selectWorld.gameMode." + CreateWorldScreen.this.field_228197_f_.field_228217_e_));
            }

            @Override
            protected IFormattableTextComponent func_230442_c_() {
                return super.func_230442_c_().func_240702_b_(". ").func_230529_a_(CreateWorldScreen.this.field_146323_G).func_240702_b_(" ").func_230529_a_(CreateWorldScreen.this.field_146328_H);
            }
        });
        this.field_238929_E_ = this.func_230480_a_(new Button(\u2603, 100, 150, 20, new TranslationTextComponent("options.difficulty"), button -> {
            this.field_238937_w_ = this.field_238936_v_ = this.field_238936_v_.func_233536_d_();
            button.func_230994_c_(250);
        }){

            @Override
            public ITextComponent func_230458_i_() {
                return new TranslationTextComponent("options.difficulty").func_240702_b_(": ").func_230529_a_(CreateWorldScreen.this.field_238937_w_.func_199285_b());
            }
        });
        this.field_146321_E = this.func_230480_a_(new Button(n, 151, 150, 20, new TranslationTextComponent("selectWorld.allowCommands"), button -> {
            this.field_146339_u = true;
            this.field_146340_t = !this.field_146340_t;
            button.func_230994_c_(250);
        }){

            @Override
            public ITextComponent func_230458_i_() {
                return super.func_230458_i_().func_230532_e_().func_240702_b_(" ").func_230529_a_(DialogTexts.func_240638_a_(CreateWorldScreen.this.field_146340_t && !CreateWorldScreen.this.field_146337_w));
            }

            @Override
            protected IFormattableTextComponent func_230442_c_() {
                return super.func_230442_c_().func_240702_b_(". ").func_230529_a_(new TranslationTextComponent("selectWorld.allowCommands.info"));
            }
        });
        this.field_238931_H_ = this.func_230480_a_(new Button(\u2603, 151, 150, 20, new TranslationTextComponent("selectWorld.dataPacks"), button -> this.func_238958_v_()));
        this.field_238930_G_ = this.func_230480_a_(new Button(n, 185, 150, 20, new TranslationTextComponent("selectWorld.gameRules"), button -> this.field_230706_i_.func_147108_a(new EditGamerulesScreen(this.field_238932_M_.func_234905_b_(), optional -> {
            this.field_230706_i_.func_147108_a(this);
            optional.ifPresent(gameRules -> {
                this.field_238932_M_ = gameRules;
            });
        }))));
        this.field_238934_c_.func_239048_a_(this, this.field_230706_i_, this.field_230712_o_);
        this.field_146324_A = this.func_230480_a_(new Button(\u2603, 185, 150, 20, new TranslationTextComponent("selectWorld.moreWorldOptions"), button -> this.func_146315_i()));
        this.field_195355_B = this.func_230480_a_(new Button(n, this.field_230709_l_ - 28, 150, 20, new TranslationTextComponent("selectWorld.create"), button -> this.func_195352_j()));
        this.field_195355_B.field_230693_o_ = !this.field_146330_J.isEmpty();
        this.func_230480_a_(new Button(\u2603, this.field_230709_l_ - 28, 150, 20, DialogTexts.field_240633_d_, button -> {
            this.func_238959_w_();
            this.field_230706_i_.func_147108_a(this.field_146332_f);
        }));
        this.func_238955_g_();
        this.func_212928_a(this.field_146333_g);
        this.func_228200_a_(this.field_228197_f_);
        this.func_146314_g();
    }

    private void func_228199_a_() {
        this.field_146323_G = new TranslationTextComponent("selectWorld.gameMode." + this.field_228197_f_.field_228217_e_ + ".line1");
        this.field_146328_H = new TranslationTextComponent("selectWorld.gameMode." + this.field_228197_f_.field_228217_e_ + ".line2");
    }

    private void func_146314_g() {
        this.field_146336_i = this.field_146333_g.func_146179_b().trim();
        if (this.field_146336_i.isEmpty()) {
            this.field_146336_i = "World";
        }
        try {
            this.field_146336_i = FileUtil.func_214992_a(this.field_230706_i_.func_71359_d().func_215781_c(), this.field_146336_i, "");
        }
        catch (Exception exception) {
            this.field_146336_i = "World";
            try {
                this.field_146336_i = FileUtil.func_214992_a(this.field_230706_i_.func_71359_d().func_215781_c(), this.field_146336_i, "");
            }
            catch (Exception exception2) {
                throw new RuntimeException("Could not create save folder", exception2);
            }
        }
    }

    @Override
    public void func_231164_f_() {
        this.field_230706_i_.field_195559_v.func_197967_a(false);
    }

    private void func_195352_j() {
        WorldSettings \u26032;
        this.field_230706_i_.func_241562_c_(new DirtMessageScreen(new TranslationTextComponent("createWorld.preparing")));
        if (!this.func_238960_x_()) {
            return;
        }
        DimensionGeneratorSettings dimensionGeneratorSettings = this.field_238934_c_.func_239054_a_(this.field_146337_w);
        if (dimensionGeneratorSettings.func_236227_h_()) {
            GameRules gameRules = new GameRules();
            gameRules.func_223585_a(GameRules.field_223607_j).func_223570_a(false, null);
            \u26032 = new WorldSettings(this.field_146333_g.func_146179_b().trim(), GameType.SPECTATOR, false, Difficulty.PEACEFUL, true, gameRules, DatapackCodec.field_234880_a_);
        } else {
            \u26032 = new WorldSettings(this.field_146333_g.func_146179_b().trim(), this.field_228197_f_.field_228218_f_, this.field_146337_w, this.field_238937_w_, this.field_146340_t && !this.field_146337_w, this.field_238932_M_, this.field_238933_b_);
        }
        this.field_230706_i_.func_238192_a_(this.field_146336_i, \u26032, this.field_238934_c_.func_239055_b_(), dimensionGeneratorSettings);
    }

    private void func_146315_i() {
        this.func_146316_a(!this.field_146344_y);
    }

    private void func_228200_a_(GameMode gameMode) {
        if (!this.field_146339_u) {
            boolean bl = this.field_146340_t = gameMode == GameMode.CREATIVE;
        }
        if (gameMode == GameMode.HARDCORE) {
            this.field_146337_w = true;
            this.field_146321_E.field_230693_o_ = false;
            this.field_238934_c_.field_239027_a_.field_230693_o_ = false;
            this.field_238937_w_ = Difficulty.HARD;
            this.field_238929_E_.field_230693_o_ = false;
        } else {
            this.field_146337_w = false;
            this.field_146321_E.field_230693_o_ = true;
            this.field_238934_c_.field_239027_a_.field_230693_o_ = true;
            this.field_238937_w_ = this.field_238936_v_;
            this.field_238929_E_.field_230693_o_ = true;
        }
        this.field_228197_f_ = gameMode;
        this.func_228199_a_();
    }

    public void func_238955_g_() {
        this.func_146316_a(this.field_146344_y);
    }

    private void func_146316_a(boolean bl) {
        this.field_146344_y = bl;
        this.field_146343_z.field_230694_p_ = !this.field_146344_y;
        boolean bl2 = this.field_238929_E_.field_230694_p_ = !this.field_146344_y;
        if (this.field_238934_c_.func_239042_a_()) {
            this.field_238931_H_.field_230694_p_ = false;
            this.field_146343_z.field_230693_o_ = false;
            if (this.field_228198_g_ == null) {
                this.field_228198_g_ = this.field_228197_f_;
            }
            this.func_228200_a_(GameMode.DEBUG);
            this.field_146321_E.field_230694_p_ = false;
        } else {
            this.field_146343_z.field_230693_o_ = true;
            if (this.field_228198_g_ != null) {
                this.func_228200_a_(this.field_228198_g_);
            }
            this.field_146321_E.field_230694_p_ = !this.field_146344_y;
            this.field_238931_H_.field_230694_p_ = !this.field_146344_y;
        }
        this.field_238934_c_.func_239059_b_(this.field_146344_y);
        this.field_146333_g.func_146189_e(!this.field_146344_y);
        if (this.field_146344_y) {
            this.field_146324_A.func_238482_a_(DialogTexts.field_240632_c_);
        } else {
            this.field_146324_A.func_238482_a_(new TranslationTextComponent("selectWorld.moreWorldOptions"));
        }
        this.field_238930_G_.field_230694_p_ = !this.field_146344_y;
    }

    @Override
    public boolean func_231046_a_(int n, int n2, int n3) {
        if (super.func_231046_a_(n, n2, n3)) {
            return true;
        }
        if (n == 257 || n == 335) {
            this.func_195352_j();
            return true;
        }
        return false;
    }

    @Override
    public void func_231175_as__() {
        if (this.field_146344_y) {
            this.func_146316_a(false);
        } else {
            this.field_230706_i_.func_147108_a(this.field_146332_f);
        }
        this.func_238959_w_();
    }

    @Override
    public void func_230430_a_(MatrixStack matrixStack, int n, int n2, float f) {
        this.func_230446_a_(matrixStack);
        this.func_238472_a_(matrixStack, this.field_230712_o_, this.field_230704_d_, this.field_230708_k_ / 2, 20, -1);
        if (this.field_146344_y) {
            this.func_238476_c_(matrixStack, this.field_230712_o_, I18n.func_135052_a("selectWorld.enterSeed", new Object[0]), this.field_230708_k_ / 2 - 100, 47, -6250336);
            this.func_238476_c_(matrixStack, this.field_230712_o_, I18n.func_135052_a("selectWorld.seedInfo", new Object[0]), this.field_230708_k_ / 2 - 100, 85, -6250336);
            this.field_238934_c_.func_230430_a_(matrixStack, n, n2, f);
        } else {
            this.func_238476_c_(matrixStack, this.field_230712_o_, I18n.func_135052_a("selectWorld.enterName", new Object[0]), this.field_230708_k_ / 2 - 100, 47, -6250336);
            this.func_238476_c_(matrixStack, this.field_230712_o_, I18n.func_135052_a("selectWorld.resultFolder", new Object[0]) + " " + this.field_146336_i, this.field_230708_k_ / 2 - 100, 85, -6250336);
            this.field_146333_g.func_230430_a_(matrixStack, n, n2, f);
            this.func_238475_b_(matrixStack, this.field_230712_o_, this.field_146323_G, this.field_230708_k_ / 2 - 150, 122, -6250336);
            this.func_238475_b_(matrixStack, this.field_230712_o_, this.field_146328_H, this.field_230708_k_ / 2 - 150, 134, -6250336);
            if (this.field_146321_E.field_230694_p_) {
                this.func_238476_c_(matrixStack, this.field_230712_o_, I18n.func_135052_a("selectWorld.allowCommands.info", new Object[0]), this.field_230708_k_ / 2 - 150, 172, -6250336);
            }
        }
        super.func_230430_a_(matrixStack, n, n2, f);
    }

    @Override
    protected <T extends IGuiEventListener> T func_230481_d_(T t) {
        return super.func_230481_d_(t);
    }

    @Override
    protected <T extends Widget> T func_230480_a_(T t) {
        return super.func_230480_a_(t);
    }

    @Nullable
    protected Path func_238957_j_() {
        if (this.field_238928_A_ == null) {
            try {
                this.field_238928_A_ = Files.createTempDirectory("mcworld-", new FileAttribute[0]);
            }
            catch (IOException iOException) {
                field_238935_p_.warn("Failed to create temporary dir", (Throwable)iOException);
                SystemToast.func_238539_c_(this.field_230706_i_, this.field_146336_i);
                this.field_230706_i_.func_147108_a(this.field_146332_f);
            }
        }
        return this.field_238928_A_;
    }

    private void func_238958_v_() {
        Path path = this.func_238957_j_();
        if (path != null) {
            File file = path.toFile();
            ResourcePackList<ResourcePackInfo> \u26032 = new ResourcePackList<ResourcePackInfo>(ResourcePackInfo::new, new ServerPackFinder(), new FolderPackFinder(file, IPackNameDecorator.field_232625_a_));
            \u26032.func_198983_a();
            \u26032.func_198985_a(this.field_238933_b_.func_234884_a_());
            this.field_230706_i_.func_147108_a(new DataPackScreen((Screen)this, \u26032, this::func_241621_a_, file));
        }
    }

    private void func_241621_a_(ResourcePackList<ResourcePackInfo> resourcePackList) {
        ImmutableList immutableList = ImmutableList.copyOf(resourcePackList.func_232621_d_());
        List \u26032 = (List)resourcePackList.func_232616_b_().stream().filter(arg_0 -> CreateWorldScreen.func_241626_a_((List)immutableList, arg_0)).collect(ImmutableList.toImmutableList());
        DatapackCodec \u26033 = new DatapackCodec((List<String>)immutableList, \u26032);
        if (immutableList.equals(this.field_238933_b_.func_234884_a_())) {
            this.field_238933_b_ = \u26033;
            return;
        }
        this.field_230706_i_.func_212871_a_(() -> this.field_230706_i_.func_147108_a(new DirtMessageScreen(new TranslationTextComponent("dataPack.validation.working"))));
        DataPackRegistries.func_240961_a_(resourcePackList.func_232623_f_(), Commands.EnvironmentType.INTEGRATED, 2, Util.func_215072_e(), this.field_230706_i_).handle((dataPackRegistries, throwable) -> {
            if (throwable != null) {
                field_238935_p_.warn("Failed to validate datapack", throwable);
                this.field_230706_i_.func_212871_a_(() -> this.field_230706_i_.func_147108_a(new ConfirmScreen(bl -> {
                    if (bl) {
                        this.func_238958_v_();
                    } else {
                        this.field_238933_b_ = DatapackCodec.field_234880_a_;
                        this.field_230706_i_.func_147108_a(this);
                    }
                }, new TranslationTextComponent("dataPack.validation.failed"), StringTextComponent.field_240750_d_, new TranslationTextComponent("dataPack.validation.back"), new TranslationTextComponent("dataPack.validation.reset"))));
            } else {
                this.field_230706_i_.func_212871_a_(() -> {
                    this.field_238933_b_ = \u26033;
                    this.field_230706_i_.func_147108_a(this);
                });
            }
            return null;
        });
    }

    private void func_238959_w_() {
        if (this.field_238928_A_ != null) {
            try (Stream<Path> stream = Files.walk(this.field_238928_A_, new FileVisitOption[0]);){
                stream.sorted(Comparator.reverseOrder()).forEach(path -> {
                    try {
                        Files.delete(path);
                    }
                    catch (IOException iOException) {
                        field_238935_p_.warn("Failed to remove temporary file {}", path, (Object)iOException);
                    }
                });
            }
            catch (IOException iOException) {
                field_238935_p_.warn("Failed to list temporary dir {}", (Object)this.field_238928_A_);
            }
            this.field_238928_A_ = null;
        }
    }

    private static void func_238945_a_(Path path, Path path2, Path path3) {
        try {
            Util.func_240984_a_(path, path2, path3);
        }
        catch (IOException iOException) {
            field_238935_p_.warn("Failed to copy datapack file from {} to {}", (Object)path3, (Object)path2);
            throw new DatapackException(iOException);
        }
    }

    private boolean func_238960_x_() {
        if (this.field_238928_A_ != null) {
            try (SaveFormat.LevelSave levelSave = this.field_230706_i_.func_71359_d().func_237274_c_(this.field_146336_i);
                 Stream<Path> stream = Files.walk(this.field_238928_A_, new FileVisitOption[0]);){
                Path path3 = levelSave.func_237285_a_(FolderName.field_237251_g_);
                Files.createDirectories(path3, new FileAttribute[0]);
                stream.filter(path -> !path.equals(this.field_238928_A_)).forEach(path2 -> CreateWorldScreen.func_238945_a_(this.field_238928_A_, path3, path2));
            }
            catch (IOException | DatapackException exception) {
                field_238935_p_.warn("Failed to copy datapacks to world {}", (Object)this.field_146336_i, (Object)exception);
                SystemToast.func_238539_c_(this.field_230706_i_, this.field_146336_i);
                this.field_230706_i_.func_147108_a(this.field_146332_f);
                this.func_238959_w_();
                return false;
            }
            this.func_238959_w_();
        }
        return true;
    }

    @Nullable
    public static Path func_238943_a_(Path path, Minecraft minecraft) {
        MutableObject mutableObject = new MutableObject();
        try (Stream<Path> stream = Files.walk(path, new FileVisitOption[0]);){
            stream.filter(path2 -> !path2.equals(path)).forEach(path2 -> {
                Path path3;
                \u2603 = (Path)mutableObject.getValue();
                if (\u2603 == null) {
                    try {
                        \u2603 = Files.createTempDirectory("mcworld-", new FileAttribute[0]);
                    }
                    catch (IOException iOException) {
                        field_238935_p_.warn("Failed to create temporary dir");
                        throw new DatapackException(iOException);
                    }
                    mutableObject.setValue((Object)\u2603);
                }
                CreateWorldScreen.func_238945_a_(path, \u2603, path2);
            });
        }
        catch (IOException | DatapackException exception) {
            field_238935_p_.warn("Failed to copy datapacks from world {}", (Object)path, (Object)exception);
            SystemToast.func_238539_c_(minecraft, path.toString());
            return null;
        }
        return (Path)mutableObject.getValue();
    }

    private static /* synthetic */ boolean func_241626_a_(List list, String string) {
        return !list.contains(string);
    }

    static class DatapackException
    extends RuntimeException {
        public DatapackException(Throwable throwable) {
            super(throwable);
        }
    }

    static enum GameMode {
        SURVIVAL("survival", GameType.SURVIVAL),
        HARDCORE("hardcore", GameType.SURVIVAL),
        CREATIVE("creative", GameType.CREATIVE),
        DEBUG("spectator", GameType.SPECTATOR);

        private final String field_228217_e_;
        private final GameType field_228218_f_;

        private GameMode(String string2, GameType gameType) {
            this.field_228217_e_ = string2;
            this.field_228218_f_ = gameType;
        }
    }
}

