/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.screen;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.client.gui.screen.CreateBuffetWorldScreen;
import net.minecraft.client.gui.screen.CreateFlatWorldScreen;
import net.minecraft.client.gui.screen.CreateWorldScreen;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.server.IDynamicRegistries;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.DimensionType;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.Biomes;
import net.minecraft.world.biome.provider.OverworldBiomeProvider;
import net.minecraft.world.biome.provider.SingleBiomeProvider;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.DebugChunkGenerator;
import net.minecraft.world.gen.DimensionSettings;
import net.minecraft.world.gen.FlatChunkGenerator;
import net.minecraft.world.gen.FlatGenerationSettings;
import net.minecraft.world.gen.NoiseChunkGenerator;
import net.minecraft.world.gen.settings.DimensionGeneratorSettings;

public abstract class BiomeGeneratorTypeScreens {
    public static final BiomeGeneratorTypeScreens field_239066_a_ = new BiomeGeneratorTypeScreens("default"){

        @Override
        protected ChunkGenerator func_230484_a_(long l) {
            return new NoiseChunkGenerator(new OverworldBiomeProvider(l, false, false), l, DimensionSettings.Preset.field_236122_b_.func_236137_b_());
        }
    };
    private static final BiomeGeneratorTypeScreens field_239070_e_ = new BiomeGeneratorTypeScreens("flat"){

        @Override
        protected ChunkGenerator func_230484_a_(long l) {
            return new FlatChunkGenerator(FlatGenerationSettings.func_82649_e());
        }
    };
    private static final BiomeGeneratorTypeScreens field_239071_f_ = new BiomeGeneratorTypeScreens("large_biomes"){

        @Override
        protected ChunkGenerator func_230484_a_(long l) {
            return new NoiseChunkGenerator(new OverworldBiomeProvider(l, false, true), l, DimensionSettings.Preset.field_236122_b_.func_236137_b_());
        }
    };
    public static final BiomeGeneratorTypeScreens field_239067_b_ = new BiomeGeneratorTypeScreens("amplified"){

        @Override
        protected ChunkGenerator func_230484_a_(long l) {
            return new NoiseChunkGenerator(new OverworldBiomeProvider(l, false, false), l, DimensionSettings.Preset.field_236123_c_.func_236137_b_());
        }
    };
    private static final BiomeGeneratorTypeScreens field_239072_g_ = new BiomeGeneratorTypeScreens("single_biome_surface"){

        @Override
        protected ChunkGenerator func_230484_a_(long l) {
            return new NoiseChunkGenerator(new SingleBiomeProvider(Biomes.field_76772_c), l, DimensionSettings.Preset.field_236122_b_.func_236137_b_());
        }
    };
    private static final BiomeGeneratorTypeScreens field_239073_h_ = new BiomeGeneratorTypeScreens("single_biome_caves"){

        @Override
        public DimensionGeneratorSettings func_241220_a_(IDynamicRegistries.Impl impl, long l, boolean bl, boolean bl2) {
            return new DimensionGeneratorSettings(l, bl, bl2, DimensionGeneratorSettings.func_241520_a_(DimensionType.func_236022_a_(l), DimensionType::func_241507_b_, this.func_230484_a_(l)));
        }

        @Override
        protected ChunkGenerator func_230484_a_(long l) {
            return new NoiseChunkGenerator(new SingleBiomeProvider(Biomes.field_76772_c), l, DimensionSettings.Preset.field_236126_f_.func_236137_b_());
        }
    };
    private static final BiomeGeneratorTypeScreens field_239074_i_ = new BiomeGeneratorTypeScreens("single_biome_floating_islands"){

        @Override
        protected ChunkGenerator func_230484_a_(long l) {
            return new NoiseChunkGenerator(new SingleBiomeProvider(Biomes.field_76772_c), l, DimensionSettings.Preset.field_236127_g_.func_236137_b_());
        }
    };
    private static final BiomeGeneratorTypeScreens field_239075_j_ = new BiomeGeneratorTypeScreens("debug_all_block_states"){

        @Override
        protected ChunkGenerator func_230484_a_(long l) {
            return DebugChunkGenerator.field_236065_d_;
        }
    };
    protected static final List<BiomeGeneratorTypeScreens> field_239068_c_ = Lists.newArrayList((Object[])new BiomeGeneratorTypeScreens[]{field_239066_a_, field_239070_e_, field_239071_f_, field_239067_b_, field_239072_g_, field_239073_h_, field_239074_i_, field_239075_j_});
    protected static final Map<Optional<BiomeGeneratorTypeScreens>, IFactory> field_239069_d_ = ImmutableMap.of(Optional.of(field_239070_e_), (createWorldScreen, dimensionGeneratorSettings) -> {
        ChunkGenerator chunkGenerator = dimensionGeneratorSettings.func_236225_f_();
        return new CreateFlatWorldScreen(createWorldScreen, flatGenerationSettings -> createWorldScreen.field_238934_c_.func_239043_a_(new DimensionGeneratorSettings(dimensionGeneratorSettings.func_236221_b_(), dimensionGeneratorSettings.func_236222_c_(), dimensionGeneratorSettings.func_236223_d_(), DimensionGeneratorSettings.func_236216_a_(dimensionGeneratorSettings.func_236224_e_(), new FlatChunkGenerator((FlatGenerationSettings)flatGenerationSettings)))), chunkGenerator instanceof FlatChunkGenerator ? ((FlatChunkGenerator)chunkGenerator).func_236073_g_() : FlatGenerationSettings.func_82649_e());
    }, Optional.of(field_239072_g_), (createWorldScreen, dimensionGeneratorSettings) -> new CreateBuffetWorldScreen(createWorldScreen, biome -> createWorldScreen.field_238934_c_.func_239043_a_(BiomeGeneratorTypeScreens.func_239080_a_(dimensionGeneratorSettings, field_239072_g_, biome)), BiomeGeneratorTypeScreens.func_239084_b_(dimensionGeneratorSettings)), Optional.of(field_239073_h_), (createWorldScreen, dimensionGeneratorSettings) -> new CreateBuffetWorldScreen(createWorldScreen, biome -> createWorldScreen.field_238934_c_.func_239043_a_(BiomeGeneratorTypeScreens.func_239080_a_(dimensionGeneratorSettings, field_239073_h_, biome)), BiomeGeneratorTypeScreens.func_239084_b_(dimensionGeneratorSettings)), Optional.of(field_239074_i_), (createWorldScreen, dimensionGeneratorSettings) -> new CreateBuffetWorldScreen(createWorldScreen, biome -> createWorldScreen.field_238934_c_.func_239043_a_(BiomeGeneratorTypeScreens.func_239080_a_(dimensionGeneratorSettings, field_239074_i_, biome)), BiomeGeneratorTypeScreens.func_239084_b_(dimensionGeneratorSettings)));
    private final ITextComponent field_239076_k_;

    private BiomeGeneratorTypeScreens(String string) {
        this.field_239076_k_ = new TranslationTextComponent("generator." + string);
    }

    private static DimensionGeneratorSettings func_239080_a_(DimensionGeneratorSettings dimensionGeneratorSettings, BiomeGeneratorTypeScreens biomeGeneratorTypeScreens, Biome biome) {
        SingleBiomeProvider singleBiomeProvider = new SingleBiomeProvider(biome);
        DimensionSettings \u26032 = biomeGeneratorTypeScreens == field_239073_h_ ? DimensionSettings.Preset.field_236126_f_.func_236137_b_() : (biomeGeneratorTypeScreens == field_239074_i_ ? DimensionSettings.Preset.field_236127_g_.func_236137_b_() : DimensionSettings.Preset.field_236122_b_.func_236137_b_());
        return new DimensionGeneratorSettings(dimensionGeneratorSettings.func_236221_b_(), dimensionGeneratorSettings.func_236222_c_(), dimensionGeneratorSettings.func_236223_d_(), DimensionGeneratorSettings.func_236216_a_(dimensionGeneratorSettings.func_236224_e_(), new NoiseChunkGenerator(singleBiomeProvider, dimensionGeneratorSettings.func_236221_b_(), \u26032)));
    }

    private static Biome func_239084_b_(DimensionGeneratorSettings dimensionGeneratorSettings) {
        return dimensionGeneratorSettings.func_236225_f_().func_202090_b().func_235203_c_().stream().findFirst().orElse(Biomes.field_76772_c);
    }

    public static Optional<BiomeGeneratorTypeScreens> func_239079_a_(DimensionGeneratorSettings dimensionGeneratorSettings) {
        ChunkGenerator chunkGenerator = dimensionGeneratorSettings.func_236225_f_();
        if (chunkGenerator instanceof FlatChunkGenerator) {
            return Optional.of(field_239070_e_);
        }
        if (chunkGenerator instanceof DebugChunkGenerator) {
            return Optional.of(field_239075_j_);
        }
        return Optional.empty();
    }

    public ITextComponent func_239077_a_() {
        return this.field_239076_k_;
    }

    public DimensionGeneratorSettings func_241220_a_(IDynamicRegistries.Impl impl, long l, boolean bl, boolean bl2) {
        return new DimensionGeneratorSettings(l, bl, bl2, DimensionGeneratorSettings.func_236216_a_(DimensionType.func_236022_a_(l), this.func_230484_a_(l)));
    }

    protected abstract ChunkGenerator func_230484_a_(long var1);

    public static interface IFactory {
        public Screen createEditScreen(CreateWorldScreen var1, DimensionGeneratorSettings var2);
    }
}

