/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui;

import com.google.common.collect.Maps;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.storage.MapData;
import net.minecraft.world.storage.MapDecoration;

public class MapItemRenderer
implements AutoCloseable {
    private static final ResourceLocation field_148253_a = new ResourceLocation("textures/map/map_icons.png");
    private static final RenderType field_228085_d_ = RenderType.func_228658_l_(field_148253_a);
    private final TextureManager field_148251_b;
    private final Map<String, Instance> field_148252_c = Maps.newHashMap();

    public MapItemRenderer(TextureManager textureManager) {
        this.field_148251_b = textureManager;
    }

    public void func_148246_a(MapData mapData) {
        this.func_148248_b(mapData).func_148236_a();
    }

    public void func_228086_a_(MatrixStack matrixStack, IRenderTypeBuffer iRenderTypeBuffer, MapData mapData, boolean bl, int n) {
        this.func_148248_b(mapData).func_228089_a_(matrixStack, iRenderTypeBuffer, bl, n);
    }

    private Instance func_148248_b(MapData mapData) {
        Instance instance = this.field_148252_c.get(mapData.func_195925_e());
        if (instance == null) {
            instance = new Instance(mapData);
            this.field_148252_c.put(mapData.func_195925_e(), instance);
        }
        return instance;
    }

    @Nullable
    public Instance func_191205_a(String string) {
        return this.field_148252_c.get(string);
    }

    public void func_148249_a() {
        for (Instance instance : this.field_148252_c.values()) {
            instance.close();
        }
        this.field_148252_c.clear();
    }

    @Nullable
    public MapData func_191207_a(@Nullable Instance instance) {
        if (instance != null) {
            return instance.field_148242_b;
        }
        return null;
    }

    @Override
    public void close() {
        this.func_148249_a();
    }

    class Instance
    implements AutoCloseable {
        private final MapData field_148242_b;
        private final DynamicTexture field_148243_c;
        private final RenderType field_228088_d_;

        private Instance(MapData mapData) {
            this.field_148242_b = mapData;
            this.field_148243_c = new DynamicTexture(128, 128, true);
            ResourceLocation resourceLocation = MapItemRenderer.this.field_148251_b.func_110578_a("map/" + mapData.func_195925_e(), this.field_148243_c);
            this.field_228088_d_ = RenderType.func_228658_l_(resourceLocation);
        }

        private void func_148236_a() {
            for (int i = 0; i < 128; ++i) {
                for (\u2603 = 0; \u2603 < 128; ++\u2603) {
                    \u2603 = \u2603 + i * 128;
                    \u2603 = this.field_148242_b.field_76198_e[\u2603] & 0xFF;
                    if (\u2603 / 4 == 0) {
                        this.field_148243_c.func_195414_e().func_195700_a(\u2603, i, 0);
                        continue;
                    }
                    this.field_148243_c.func_195414_e().func_195700_a(\u2603, i, MaterialColor.field_76281_a[\u2603 / 4].func_151643_b(\u2603 & 3));
                }
            }
            this.field_148243_c.func_110564_a();
        }

        private void func_228089_a_(MatrixStack matrixStack, IRenderTypeBuffer iRenderTypeBuffer, boolean bl, int n) {
            boolean bl2 = false;
            \u2603 = false;
            float \u26032 = 0.0f;
            Matrix4f \u26033 = matrixStack.func_227866_c_().func_227870_a_();
            IVertexBuilder \u26034 = iRenderTypeBuffer.getBuffer(this.field_228088_d_);
            \u26034.func_227888_a_(\u26033, 0.0f, 128.0f, -0.01f).func_225586_a_(255, 255, 255, 255).func_225583_a_(0.0f, 1.0f).func_227886_a_(n).func_181675_d();
            \u26034.func_227888_a_(\u26033, 128.0f, 128.0f, -0.01f).func_225586_a_(255, 255, 255, 255).func_225583_a_(1.0f, 1.0f).func_227886_a_(n).func_181675_d();
            \u26034.func_227888_a_(\u26033, 128.0f, 0.0f, -0.01f).func_225586_a_(255, 255, 255, 255).func_225583_a_(1.0f, 0.0f).func_227886_a_(n).func_181675_d();
            \u26034.func_227888_a_(\u26033, 0.0f, 0.0f, -0.01f).func_225586_a_(255, 255, 255, 255).func_225583_a_(0.0f, 0.0f).func_227886_a_(n).func_181675_d();
            int \u26035 = 0;
            for (MapDecoration mapDecoration : this.field_148242_b.field_76203_h.values()) {
                if (bl && !mapDecoration.func_191180_f()) continue;
                matrixStack.func_227860_a_();
                matrixStack.func_227861_a_(0.0f + (float)mapDecoration.func_176112_b() / 2.0f + 64.0f, 0.0f + (float)mapDecoration.func_176113_c() / 2.0f + 64.0f, -0.02f);
                matrixStack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_((float)(mapDecoration.func_176111_d() * 360) / 16.0f));
                matrixStack.func_227862_a_(4.0f, 4.0f, 3.0f);
                matrixStack.func_227861_a_(-0.125, 0.125, 0.0);
                byte by = mapDecoration.func_176110_a();
                float \u26036 = (float)(by % 16 + 0) / 16.0f;
                float \u26037 = (float)(by / 16 + 0) / 16.0f;
                float \u26038 = (float)(by % 16 + 1) / 16.0f;
                float \u26039 = (float)(by / 16 + 1) / 16.0f;
                Matrix4f \u260310 = matrixStack.func_227866_c_().func_227870_a_();
                float \u260311 = -0.001f;
                IVertexBuilder \u260312 = iRenderTypeBuffer.getBuffer(field_228085_d_);
                \u260312.func_227888_a_(\u260310, -1.0f, 1.0f, (float)\u26035 * -0.001f).func_225586_a_(255, 255, 255, 255).func_225583_a_(\u26036, \u26037).func_227886_a_(n).func_181675_d();
                \u260312.func_227888_a_(\u260310, 1.0f, 1.0f, (float)\u26035 * -0.001f).func_225586_a_(255, 255, 255, 255).func_225583_a_(\u26038, \u26037).func_227886_a_(n).func_181675_d();
                \u260312.func_227888_a_(\u260310, 1.0f, -1.0f, (float)\u26035 * -0.001f).func_225586_a_(255, 255, 255, 255).func_225583_a_(\u26038, \u26039).func_227886_a_(n).func_181675_d();
                \u260312.func_227888_a_(\u260310, -1.0f, -1.0f, (float)\u26035 * -0.001f).func_225586_a_(255, 255, 255, 255).func_225583_a_(\u26036, \u26039).func_227886_a_(n).func_181675_d();
                matrixStack.func_227865_b_();
                if (mapDecoration.func_204309_g() != null) {
                    FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
                    ITextComponent \u260313 = mapDecoration.func_204309_g();
                    float \u260314 = fontRenderer.func_238414_a_(\u260313);
                    float f = 25.0f / \u260314;
                    fontRenderer.getClass();
                    float \u260315 = MathHelper.func_76131_a(f, 0.0f, 6.0f / 9.0f);
                    matrixStack.func_227860_a_();
                    matrixStack.func_227861_a_(0.0f + (float)mapDecoration.func_176112_b() / 2.0f + 64.0f - \u260314 * \u260315 / 2.0f, 0.0f + (float)mapDecoration.func_176113_c() / 2.0f + 64.0f + 4.0f, -0.025f);
                    matrixStack.func_227862_a_(\u260315, \u260315, 1.0f);
                    matrixStack.func_227861_a_(0.0, 0.0, -0.1f);
                    fontRenderer.func_238416_a_(\u260313, 0.0f, 0.0f, -1, false, matrixStack.func_227866_c_().func_227870_a_(), iRenderTypeBuffer, false, Integer.MIN_VALUE, n);
                    matrixStack.func_227865_b_();
                }
                ++\u26035;
            }
        }

        @Override
        public void close() {
            this.field_148243_c.close();
        }
    }
}

