/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui;

import com.google.common.collect.Lists;
import com.ibm.icu.text.ArabicShaping;
import com.ibm.icu.text.ArabicShapingException;
import com.ibm.icu.text.Bidi;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.List;
import java.util.Random;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.client.gui.fonts.EmptyGlyph;
import net.minecraft.client.gui.fonts.Font;
import net.minecraft.client.gui.fonts.IGlyph;
import net.minecraft.client.gui.fonts.TexturedGlyph;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.TransformationMatrix;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.text.CharacterManager;
import net.minecraft.util.text.Color;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.LanguageMap;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextProcessing;

public class FontRenderer {
    private static final Vector3f field_238401_c_ = new Vector3f(0.0f, 0.0f, 0.03f);
    public final int field_78288_b = 9;
    public final Random field_78289_c = new Random();
    private final Function<ResourceLocation, Font> field_211127_e;
    private final CharacterManager field_238402_e_;

    public FontRenderer(Function<ResourceLocation, Font> function) {
        this.field_211127_e = function;
        this.field_238402_e_ = new CharacterManager((n, style) -> this.func_238419_a_(style.func_240729_k_()).func_238557_a_(n).func_223274_a_(style.func_150223_b()));
    }

    private Font func_238419_a_(ResourceLocation resourceLocation) {
        return this.field_211127_e.apply(resourceLocation);
    }

    public int func_238405_a_(MatrixStack matrixStack, String string, float f, float f2, int n) {
        return this.func_228078_a_(string, f, f2, n, matrixStack.func_227866_c_().func_227870_a_(), true, this.func_78260_a());
    }

    public int func_238406_a_(MatrixStack matrixStack, String string, float f, float f2, int n, boolean bl) {
        RenderSystem.enableAlphaTest();
        return this.func_228078_a_(string, f, f2, n, matrixStack.func_227866_c_().func_227870_a_(), true, bl);
    }

    public int func_238421_b_(MatrixStack matrixStack, String string, float f, float f2, int n) {
        RenderSystem.enableAlphaTest();
        return this.func_228078_a_(string, f, f2, n, matrixStack.func_227866_c_().func_227870_a_(), false, this.func_78260_a());
    }

    public int func_238407_a_(MatrixStack matrixStack, ITextProperties iTextProperties, float f, float f2, int n) {
        RenderSystem.enableAlphaTest();
        return this.func_238415_a_(iTextProperties, f, f2, n, matrixStack.func_227866_c_().func_227870_a_(), true);
    }

    public int func_238422_b_(MatrixStack matrixStack, ITextProperties iTextProperties, float f, float f2, int n) {
        RenderSystem.enableAlphaTest();
        return this.func_238415_a_(iTextProperties, f, f2, n, matrixStack.func_227866_c_().func_227870_a_(), false);
    }

    public String func_147647_b(String string2) {
        try {
            Bidi bidi = new Bidi(new ArabicShaping(8).shape(string2), 127);
            bidi.setReorderingMode(0);
            return bidi.writeReordered(2);
        }
        catch (ArabicShapingException arabicShapingException) {
            String string2;
            return string2;
        }
    }

    private int func_228078_a_(String string, float f, float f2, int n, Matrix4f matrix4f, boolean bl, boolean bl2) {
        if (string == null) {
            return 0;
        }
        IRenderTypeBuffer.Impl impl = IRenderTypeBuffer.func_228455_a_(Tessellator.func_178181_a().func_178180_c());
        int \u26032 = this.func_238411_a_(string, f, f2, n, bl, matrix4f, impl, false, 0, 0xF000F0, bl2);
        impl.func_228461_a_();
        return \u26032;
    }

    private int func_238415_a_(ITextProperties iTextProperties, float f, float f2, int n, Matrix4f matrix4f, boolean bl) {
        IRenderTypeBuffer.Impl impl = IRenderTypeBuffer.func_228455_a_(Tessellator.func_178181_a().func_178180_c());
        int \u26032 = this.func_238416_a_(iTextProperties, f, f2, n, bl, matrix4f, impl, false, 0, 0xF000F0);
        impl.func_228461_a_();
        return \u26032;
    }

    public int func_228079_a_(String string, float f, float f2, int n, boolean bl, Matrix4f matrix4f, IRenderTypeBuffer iRenderTypeBuffer, boolean bl2, int n2, int n3) {
        return this.func_238411_a_(string, f, f2, n, bl, matrix4f, iRenderTypeBuffer, bl2, n2, n3, this.func_78260_a());
    }

    public int func_238411_a_(String string, float f, float f2, int n, boolean bl, Matrix4f matrix4f, IRenderTypeBuffer iRenderTypeBuffer, boolean bl2, int n2, int n3, boolean bl3) {
        return this.func_238423_b_(string, f, f2, n, bl, matrix4f, iRenderTypeBuffer, bl2, n2, n3, bl3);
    }

    public int func_238416_a_(ITextProperties iTextProperties, float f, float f2, int n, boolean bl, Matrix4f matrix4f, IRenderTypeBuffer iRenderTypeBuffer, boolean bl2, int n2, int n3) {
        return this.func_238424_b_(iTextProperties, f, f2, n, bl, matrix4f, iRenderTypeBuffer, bl2, n2, n3);
    }

    private static int func_238403_a_(int n) {
        if ((n & 0xFC000000) == 0) {
            return n | 0xFF000000;
        }
        return n;
    }

    private int func_238423_b_(String string2, float \u260332, float f, int n4, boolean bl, Matrix4f matrix4f, IRenderTypeBuffer iRenderTypeBuffer, boolean bl2, int n2, int n3, boolean bl3) {
        int n4;
        if (bl3) {
            String string2 = this.func_147647_b(string2);
        }
        n4 = FontRenderer.func_238403_a_(n4);
        Matrix4f \u26032 = matrix4f.func_226601_d_();
        if (bl) {
            this.func_228081_c_(string2, \u260332, f, n4, true, matrix4f, iRenderTypeBuffer, bl2, n2, n3);
            \u26032.func_226597_a_(field_238401_c_);
        }
        float \u260332 = this.func_228081_c_(string2, \u260332, f, n4, false, \u26032, iRenderTypeBuffer, bl2, n2, n3);
        return (int)\u260332 + (bl ? 1 : 0);
    }

    private int func_238424_b_(ITextProperties iTextProperties, float \u260322, float f, int n, boolean bl, Matrix4f matrix4f, IRenderTypeBuffer iRenderTypeBuffer, boolean bl2, int n2, int n3) {
        n = FontRenderer.func_238403_a_(n);
        Matrix4f matrix4f2 = matrix4f.func_226601_d_();
        if (bl) {
            this.func_238426_c_(iTextProperties, \u260322, f, n, true, matrix4f, iRenderTypeBuffer, bl2, n2, n3);
            matrix4f2.func_226597_a_(field_238401_c_);
        }
        float \u260322 = this.func_238426_c_(iTextProperties, \u260322, f, n, false, matrix4f2, iRenderTypeBuffer, bl2, n2, n3);
        return (int)\u260322 + (bl ? 1 : 0);
    }

    private float func_228081_c_(String string, float f, float f2, int n, boolean bl, Matrix4f matrix4f, IRenderTypeBuffer iRenderTypeBuffer, boolean bl2, int n2, int n3) {
        CharacterRenderer characterRenderer = new CharacterRenderer(iRenderTypeBuffer, f, f2, n, bl, matrix4f, bl2, n3);
        TextProcessing.func_238346_c_(string, Style.field_240709_b_, characterRenderer);
        return characterRenderer.func_238441_a_(n2, f);
    }

    private float func_238426_c_(ITextProperties iTextProperties, float f, float f2, int n, boolean bl, Matrix4f matrix4f, IRenderTypeBuffer iRenderTypeBuffer, boolean bl2, int n2, int n3) {
        CharacterRenderer characterRenderer = new CharacterRenderer(iRenderTypeBuffer, f, f2, n, bl, matrix4f, bl2, n3);
        TextProcessing.func_238343_a_(iTextProperties, Style.field_240709_b_, characterRenderer);
        return characterRenderer.func_238441_a_(n2, f);
    }

    private void func_228077_a_(TexturedGlyph texturedGlyph, boolean bl, boolean bl2, float f, float f2, float f3, Matrix4f matrix4f, IVertexBuilder iVertexBuilder, float f4, float f5, float f6, float f7, int n) {
        texturedGlyph.func_225595_a_(bl2, f2, f3, matrix4f, iVertexBuilder, f4, f5, f6, f7, n);
        if (bl) {
            texturedGlyph.func_225595_a_(bl2, f2 + f, f3, matrix4f, iVertexBuilder, f4, f5, f6, f7, n);
        }
    }

    public int func_78256_a(String string) {
        return MathHelper.func_76123_f(this.field_238402_e_.func_238350_a_(string));
    }

    public int func_238414_a_(ITextProperties iTextProperties) {
        return MathHelper.func_76123_f(this.field_238402_e_.func_238356_a_(iTextProperties));
    }

    public String func_238413_a_(String string, int n, boolean bl) {
        return bl ? this.field_238402_e_.func_238364_c_(string, n, Style.field_240709_b_) : this.field_238402_e_.func_238361_b_(string, n, Style.field_240709_b_);
    }

    public String func_238412_a_(String string, int n) {
        return this.field_238402_e_.func_238361_b_(string, n, Style.field_240709_b_);
    }

    public ITextProperties func_238417_a_(ITextProperties iTextProperties, int n) {
        return this.field_238402_e_.func_238358_a_(iTextProperties, n, Style.field_240709_b_);
    }

    public void func_238418_a_(ITextProperties iTextProperties, int n, int n2, int n3, int n4) {
        Matrix4f matrix4f = TransformationMatrix.func_227983_a_().func_227988_c_();
        for (ITextProperties iTextProperties2 : this.func_238425_b_(iTextProperties, n3)) {
            this.func_238415_a_(iTextProperties2, n, n2, n4, matrix4f, false);
            n2 += 9;
        }
    }

    public int func_78267_b(String string, int n) {
        return 9 * this.field_238402_e_.func_238365_g_(string, n, Style.field_240709_b_).size();
    }

    public List<ITextProperties> func_238425_b_(ITextProperties iTextProperties, int n) {
        return this.field_238402_e_.func_238362_b_(iTextProperties, n, Style.field_240709_b_);
    }

    public boolean func_78260_a() {
        return LanguageMap.func_74808_a().func_230505_b_();
    }

    public CharacterManager func_238420_b_() {
        return this.field_238402_e_;
    }

    class CharacterRenderer
    implements TextProcessing.ICharacterConsumer {
        final IRenderTypeBuffer field_238427_a_;
        private final boolean field_238429_c_;
        private final float field_238430_d_;
        private final float field_238431_e_;
        private final float field_238432_f_;
        private final float field_238433_g_;
        private final float field_238434_h_;
        private final Matrix4f field_238435_i_;
        private final boolean field_238436_j_;
        private final int field_238437_k_;
        private float field_238438_l_;
        private float field_238439_m_;
        @Nullable
        private List<TexturedGlyph.Effect> field_238440_n_;

        private void func_238442_a_(TexturedGlyph.Effect effect) {
            if (this.field_238440_n_ == null) {
                this.field_238440_n_ = Lists.newArrayList();
            }
            this.field_238440_n_.add(effect);
        }

        public CharacterRenderer(IRenderTypeBuffer iRenderTypeBuffer, float f, float f2, int n, boolean bl, Matrix4f matrix4f, boolean bl2, int n2) {
            this.field_238427_a_ = iRenderTypeBuffer;
            this.field_238438_l_ = f;
            this.field_238439_m_ = f2;
            this.field_238429_c_ = bl;
            this.field_238430_d_ = bl ? 0.25f : 1.0f;
            this.field_238431_e_ = (float)(n >> 16 & 0xFF) / 255.0f * this.field_238430_d_;
            this.field_238432_f_ = (float)(n >> 8 & 0xFF) / 255.0f * this.field_238430_d_;
            this.field_238433_g_ = (float)(n & 0xFF) / 255.0f * this.field_238430_d_;
            this.field_238434_h_ = (float)(n >> 24 & 0xFF) / 255.0f;
            this.field_238435_i_ = matrix4f;
            this.field_238436_j_ = bl2;
            this.field_238437_k_ = n2;
        }

        @Override
        public boolean onChar(int n, Style style, int n2) {
            float \u260311;
            float \u26039;
            float \u26038;
            float \u26037;
            Font font = FontRenderer.this.func_238419_a_(style.func_240729_k_());
            IGlyph \u26032 = font.func_238557_a_(n2);
            TexturedGlyph \u26033 = style.func_150233_f() && n2 != 32 ? font.func_211188_a(\u26032) : font.func_238559_b_(n2);
            boolean \u26034 = style.func_150223_b();
            float \u26035 = this.field_238434_h_;
            Color \u26036 = style.func_240711_a_();
            if (\u26036 != null) {
                int n3 = \u26036.func_240742_a_();
                \u26037 = (float)(n3 >> 16 & 0xFF) / 255.0f * this.field_238430_d_;
                \u26038 = (float)(n3 >> 8 & 0xFF) / 255.0f * this.field_238430_d_;
                \u26039 = (float)(n3 & 0xFF) / 255.0f * this.field_238430_d_;
            } else {
                \u26037 = this.field_238431_e_;
                \u26038 = this.field_238432_f_;
                \u26039 = this.field_238433_g_;
            }
            if (!(\u26033 instanceof EmptyGlyph)) {
                float \u260310 = \u26034 ? \u26032.func_223275_b_() : 0.0f;
                \u260311 = this.field_238429_c_ ? \u26032.func_223276_c_() : 0.0f;
                IVertexBuilder \u260312 = this.field_238427_a_.getBuffer(\u26033.func_228163_a_(this.field_238436_j_));
                FontRenderer.this.func_228077_a_(\u26033, \u26034, style.func_150242_c(), \u260310, this.field_238438_l_ + \u260311, this.field_238439_m_ + \u260311, this.field_238435_i_, \u260312, \u26037, \u26038, \u26039, \u26035, this.field_238437_k_);
            }
            float f = \u26032.func_223274_a_(\u26034);
            float f2 = \u260311 = this.field_238429_c_ ? 1.0f : 0.0f;
            if (style.func_150236_d()) {
                this.func_238442_a_(new TexturedGlyph.Effect(this.field_238438_l_ + \u260311 - 1.0f, this.field_238439_m_ + \u260311 + 4.5f, this.field_238438_l_ + \u260311 + f, this.field_238439_m_ + \u260311 + 4.5f - 1.0f, 0.01f, \u26037, \u26038, \u26039, \u26035));
            }
            if (style.func_150234_e()) {
                this.func_238442_a_(new TexturedGlyph.Effect(this.field_238438_l_ + \u260311 - 1.0f, this.field_238439_m_ + \u260311 + 9.0f, this.field_238438_l_ + \u260311 + f, this.field_238439_m_ + \u260311 + 9.0f - 1.0f, 0.01f, \u26037, \u26038, \u26039, \u26035));
            }
            this.field_238438_l_ += f;
            return true;
        }

        public float func_238441_a_(int n, float f) {
            if (n != 0) {
                \u2603 = (float)(n >> 24 & 0xFF) / 255.0f;
                \u2603 = (float)(n >> 16 & 0xFF) / 255.0f;
                \u2603 = (float)(n >> 8 & 0xFF) / 255.0f;
                \u2603 = (float)(n & 0xFF) / 255.0f;
                this.func_238442_a_(new TexturedGlyph.Effect(f - 1.0f, this.field_238439_m_ + 9.0f, this.field_238438_l_ + 1.0f, this.field_238439_m_ - 1.0f, 0.01f, \u2603, \u2603, \u2603, \u2603));
            }
            if (this.field_238440_n_ != null) {
                TexturedGlyph texturedGlyph = FontRenderer.this.func_238419_a_(Style.field_240708_a_).func_228157_b_();
                IVertexBuilder \u26032 = this.field_238427_a_.getBuffer(texturedGlyph.func_228163_a_(this.field_238436_j_));
                for (TexturedGlyph.Effect effect : this.field_238440_n_) {
                    texturedGlyph.func_228162_a_(effect, this.field_238435_i_, \u26032, this.field_238437_k_);
                }
            }
            return this.field_238438_l_;
        }
    }
}

