/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.audio;

import com.google.common.collect.Sets;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.client.audio.ALUtils;
import net.minecraft.client.audio.Listener;
import net.minecraft.client.audio.SoundSource;
import net.minecraft.util.math.MathHelper;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.lwjgl.openal.AL;
import org.lwjgl.openal.AL10;
import org.lwjgl.openal.ALC;
import org.lwjgl.openal.ALC10;
import org.lwjgl.openal.ALCCapabilities;
import org.lwjgl.openal.ALCapabilities;
import org.lwjgl.system.MemoryStack;

public class SoundSystem {
    private static final Logger field_216410_a = LogManager.getLogger();
    private long field_216411_b;
    private long field_216412_c;
    private static final IHandler field_216413_d = new IHandler(){

        @Override
        @Nullable
        public SoundSource func_216398_a() {
            return null;
        }

        @Override
        public boolean func_216396_a(SoundSource soundSource) {
            return false;
        }

        @Override
        public void func_216399_b() {
        }

        @Override
        public int func_216395_c() {
            return 0;
        }

        @Override
        public int func_216397_d() {
            return 0;
        }
    };
    private IHandler field_216414_e = field_216413_d;
    private IHandler field_216415_f = field_216413_d;
    private final Listener field_216416_g = new Listener();

    public void func_216404_a() {
        this.field_216411_b = SoundSystem.func_216406_f();
        ALCCapabilities aLCCapabilities = ALC.createCapabilities((long)this.field_216411_b);
        if (ALUtils.func_216481_a(this.field_216411_b, "Get capabilities")) {
            throw new IllegalStateException("Failed to get OpenAL capabilities");
        }
        if (!aLCCapabilities.OpenALC11) {
            throw new IllegalStateException("OpenAL 1.1 not supported");
        }
        this.field_216412_c = ALC10.alcCreateContext((long)this.field_216411_b, (IntBuffer)null);
        ALC10.alcMakeContextCurrent((long)this.field_216412_c);
        int \u26032 = this.func_216405_e();
        int \u26033 = MathHelper.func_76125_a((int)MathHelper.func_76129_c(\u26032), 2, 8);
        int \u26034 = MathHelper.func_76125_a(\u26032 - \u26033, 8, 255);
        this.field_216414_e = new HandlerImpl(\u26034);
        this.field_216415_f = new HandlerImpl(\u26033);
        ALCapabilities \u26035 = AL.createCapabilities((ALCCapabilities)aLCCapabilities);
        ALUtils.func_216483_a("Initialization");
        if (!\u26035.AL_EXT_source_distance_model) {
            throw new IllegalStateException("AL_EXT_source_distance_model is not supported");
        }
        AL10.alEnable((int)512);
        if (!\u26035.AL_EXT_LINEAR_DISTANCE) {
            throw new IllegalStateException("AL_EXT_LINEAR_DISTANCE is not supported");
        }
        ALUtils.func_216483_a("Enable per-source distance models");
        field_216410_a.info("OpenAL initialized.");
    }

    private int func_216405_e() {
        try (MemoryStack memoryStack = MemoryStack.stackPush();){
            int n = ALC10.alcGetInteger((long)this.field_216411_b, (int)4098);
            if (ALUtils.func_216481_a(this.field_216411_b, "Get attributes size")) {
                throw new IllegalStateException("Failed to get OpenAL attributes");
            }
            IntBuffer \u26032 = memoryStack.mallocInt(n);
            ALC10.alcGetIntegerv((long)this.field_216411_b, (int)4099, (IntBuffer)\u26032);
            if (ALUtils.func_216481_a(this.field_216411_b, "Get attributes")) {
                throw new IllegalStateException("Failed to get OpenAL attributes");
            }
            \u2603 = 0;
            while (\u2603 < n) {
                if ((\u2603 = \u26032.get(\u2603++)) == 0) {
                    break;
                }
                \u2603 = \u26032.get(\u2603++);
                if (\u2603 != 4112) continue;
                int n2 = \u2603;
                return n2;
            }
        }
        return 30;
    }

    private static long func_216406_f() {
        for (int i = 0; i < 3; ++i) {
            long l = ALC10.alcOpenDevice((ByteBuffer)null);
            if (l == 0L || ALUtils.func_216481_a(l, "Open device")) continue;
            return l;
        }
        throw new IllegalStateException("Failed to open OpenAL device");
    }

    public void func_216409_b() {
        this.field_216414_e.func_216399_b();
        this.field_216415_f.func_216399_b();
        ALC10.alcDestroyContext((long)this.field_216412_c);
        if (this.field_216411_b != 0L) {
            ALC10.alcCloseDevice((long)this.field_216411_b);
        }
    }

    public Listener func_216407_c() {
        return this.field_216416_g;
    }

    @Nullable
    public SoundSource func_216403_a(Mode mode) {
        return (mode == Mode.STREAMING ? this.field_216415_f : this.field_216414_e).func_216398_a();
    }

    public void func_216408_a(SoundSource soundSource) {
        if (!this.field_216414_e.func_216396_a(soundSource) && !this.field_216415_f.func_216396_a(soundSource)) {
            throw new IllegalStateException("Tried to release unknown channel");
        }
    }

    public String func_216402_d() {
        return String.format("Sounds: %d/%d + %d/%d", this.field_216414_e.func_216397_d(), this.field_216414_e.func_216395_c(), this.field_216415_f.func_216397_d(), this.field_216415_f.func_216395_c());
    }

    static class HandlerImpl
    implements IHandler {
        private final int field_216400_a;
        private final Set<SoundSource> field_216401_b = Sets.newIdentityHashSet();

        public HandlerImpl(int n) {
            this.field_216400_a = n;
        }

        @Override
        @Nullable
        public SoundSource func_216398_a() {
            if (this.field_216401_b.size() >= this.field_216400_a) {
                field_216410_a.warn("Maximum sound pool size {} reached", (Object)this.field_216400_a);
                return null;
            }
            SoundSource soundSource = SoundSource.func_216426_a();
            if (soundSource != null) {
                this.field_216401_b.add(soundSource);
            }
            return soundSource;
        }

        @Override
        public boolean func_216396_a(SoundSource soundSource) {
            if (!this.field_216401_b.remove(soundSource)) {
                return false;
            }
            soundSource.func_216436_b();
            return true;
        }

        @Override
        public void func_216399_b() {
            this.field_216401_b.forEach(SoundSource::func_216436_b);
            this.field_216401_b.clear();
        }

        @Override
        public int func_216395_c() {
            return this.field_216400_a;
        }

        @Override
        public int func_216397_d() {
            return this.field_216401_b.size();
        }
    }

    static interface IHandler {
        @Nullable
        public SoundSource func_216398_a();

        public boolean func_216396_a(SoundSource var1);

        public void func_216399_b();

        public int func_216395_c();

        public int func_216397_d();
    }

    public static enum Mode {
        STATIC,
        STREAMING;

    }
}

