/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Queues;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.GameProfileRepository;
import com.mojang.authlib.minecraft.MinecraftSessionService;
import com.mojang.authlib.properties.PropertyMap;
import com.mojang.authlib.yggdrasil.YggdrasilAuthenticationService;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.PlatformDescriptors;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.datafixers.DataFixer;
import com.mojang.datafixers.util.Function4;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.Lifecycle;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.Proxy;
import java.net.SocketAddress;
import java.nio.ByteOrder;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Queue;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.client.AbstractOption;
import net.minecraft.client.ClientBrandRetriever;
import net.minecraft.client.GameConfiguration;
import net.minecraft.client.GameSettings;
import net.minecraft.client.KeyboardListener;
import net.minecraft.client.MainWindow;
import net.minecraft.client.MinecraftGame;
import net.minecraft.client.MouseHelper;
import net.minecraft.client.audio.BackgroundMusicSelector;
import net.minecraft.client.audio.BackgroundMusicTracks;
import net.minecraft.client.audio.MusicTicker;
import net.minecraft.client.audio.SoundHandler;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.DialogTexts;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.IngameGui;
import net.minecraft.client.gui.LoadingGui;
import net.minecraft.client.gui.ResourceLoadProgressGui;
import net.minecraft.client.gui.ScreenManager;
import net.minecraft.client.gui.advancements.AdvancementsScreen;
import net.minecraft.client.gui.chat.NarratorChatListener;
import net.minecraft.client.gui.fonts.FontResourceManager;
import net.minecraft.client.gui.recipebook.RecipeList;
import net.minecraft.client.gui.screen.ChatScreen;
import net.minecraft.client.gui.screen.ConfirmBackupScreen;
import net.minecraft.client.gui.screen.ConfirmScreen;
import net.minecraft.client.gui.screen.ConnectingScreen;
import net.minecraft.client.gui.screen.DatapackFailureScreen;
import net.minecraft.client.gui.screen.DeathScreen;
import net.minecraft.client.gui.screen.DirtMessageScreen;
import net.minecraft.client.gui.screen.EditWorldScreen;
import net.minecraft.client.gui.screen.IngameMenuScreen;
import net.minecraft.client.gui.screen.MainMenuScreen;
import net.minecraft.client.gui.screen.MemoryErrorScreen;
import net.minecraft.client.gui.screen.MultiplayerScreen;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.screen.SleepInMultiplayerScreen;
import net.minecraft.client.gui.screen.WinGameScreen;
import net.minecraft.client.gui.screen.WorkingScreen;
import net.minecraft.client.gui.screen.WorldLoadProgressScreen;
import net.minecraft.client.gui.screen.inventory.CreativeScreen;
import net.minecraft.client.gui.screen.inventory.InventoryScreen;
import net.minecraft.client.gui.toasts.SystemToast;
import net.minecraft.client.gui.toasts.ToastGui;
import net.minecraft.client.multiplayer.PlayerController;
import net.minecraft.client.multiplayer.ServerData;
import net.minecraft.client.network.login.ClientLoginNetHandler;
import net.minecraft.client.network.play.ClientPlayNetHandler;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.client.renderer.BlockModelShapes;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.FirstPersonRenderer;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.client.renderer.GPUWarning;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.IWindowEventListener;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.RenderTypeBuffers;
import net.minecraft.client.renderer.ScreenSize;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VirtualScreen;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.color.BlockColors;
import net.minecraft.client.renderer.color.ItemColors;
import net.minecraft.client.renderer.debug.DebugRenderer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ModelManager;
import net.minecraft.client.renderer.texture.PaintingSpriteUploader;
import net.minecraft.client.renderer.texture.PotionSpriteUploader;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.ClientResourcePackInfo;
import net.minecraft.client.resources.DownloadingPackFinder;
import net.minecraft.client.resources.FoliageColorReloadListener;
import net.minecraft.client.resources.GrassColorReloadListener;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.resources.LanguageManager;
import net.minecraft.client.resources.LegacyResourcePackWrapper;
import net.minecraft.client.resources.LegacyResourcePackWrapperV4;
import net.minecraft.client.resources.SkinManager;
import net.minecraft.client.settings.AmbientOcclusionStatus;
import net.minecraft.client.settings.CloudOption;
import net.minecraft.client.settings.CreativeSettings;
import net.minecraft.client.settings.GraphicsFanciness;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.client.shader.Framebuffer;
import net.minecraft.client.tutorial.Tutorial;
import net.minecraft.client.util.IMutableSearchTree;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.client.util.SearchTree;
import net.minecraft.client.util.SearchTreeManager;
import net.minecraft.client.util.SearchTreeReloadable;
import net.minecraft.client.util.Splashes;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.command.Commands;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.crash.ReportedException;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.item.ArmorStandEntity;
import net.minecraft.entity.item.BoatEntity;
import net.minecraft.entity.item.EnderCrystalEntity;
import net.minecraft.entity.item.ItemFrameEntity;
import net.minecraft.entity.item.LeashKnotEntity;
import net.minecraft.entity.item.PaintingEntity;
import net.minecraft.entity.item.minecart.AbstractMinecartEntity;
import net.minecraft.entity.player.ChatVisibility;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.SkullItem;
import net.minecraft.item.SpawnEggItem;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.NBTDynamicOps;
import net.minecraft.nbt.StringNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.ProtocolType;
import net.minecraft.network.handshake.client.CHandshakePacket;
import net.minecraft.network.login.client.CLoginStartPacket;
import net.minecraft.network.play.client.CPlayerDiggingPacket;
import net.minecraft.profiler.DataPoint;
import net.minecraft.profiler.EmptyProfiler;
import net.minecraft.profiler.IProfileResult;
import net.minecraft.profiler.IProfiler;
import net.minecraft.profiler.ISnooperInfo;
import net.minecraft.profiler.LongTickDetector;
import net.minecraft.profiler.Snooper;
import net.minecraft.profiler.TimeTracker;
import net.minecraft.resources.DataPackRegistries;
import net.minecraft.resources.FolderPackFinder;
import net.minecraft.resources.IPackNameDecorator;
import net.minecraft.resources.IReloadableResourceManager;
import net.minecraft.resources.IResourceManager;
import net.minecraft.resources.IResourcePack;
import net.minecraft.resources.ResourcePackInfo;
import net.minecraft.resources.ResourcePackList;
import net.minecraft.resources.ResourcePackType;
import net.minecraft.resources.ServerPackFinder;
import net.minecraft.resources.SimpleReloadableResourceManager;
import net.minecraft.resources.data.PackMetadataSection;
import net.minecraft.server.IDynamicRegistries;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.integrated.IntegratedServer;
import net.minecraft.server.management.PlayerProfileCache;
import net.minecraft.tags.ItemTags;
import net.minecraft.tileentity.SkullTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.FrameTimer;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Session;
import net.minecraft.util.SharedConstants;
import net.minecraft.util.Timer;
import net.minecraft.util.Unit;
import net.minecraft.util.Util;
import net.minecraft.util.concurrent.RecursiveEventLoop;
import net.minecraft.util.datafix.DataFixesManager;
import net.minecraft.util.datafix.codec.DatapackCodec;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.registry.Bootstrap;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.registry.SimpleRegistry;
import net.minecraft.util.registry.WorldSettingsImport;
import net.minecraft.util.text.KeybindTextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.Dimension;
import net.minecraft.world.World;
import net.minecraft.world.WorldSettings;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.listener.ChainedChunkStatusListener;
import net.minecraft.world.chunk.listener.TrackingChunkStatusListener;
import net.minecraft.world.gen.settings.DimensionGeneratorSettings;
import net.minecraft.world.storage.FolderName;
import net.minecraft.world.storage.IServerConfiguration;
import net.minecraft.world.storage.SaveFormat;
import net.minecraft.world.storage.ServerWorldInfo;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Minecraft
extends RecursiveEventLoop<Runnable>
implements ISnooperInfo,
IWindowEventListener {
    private static Minecraft field_71432_P;
    private static final Logger field_147123_G;
    public static final boolean field_142025_a;
    public static final ResourceLocation field_211502_b;
    public static final ResourceLocation field_238177_c_;
    public static final ResourceLocation field_71464_q;
    private static final CompletableFuture<Unit> field_223714_G;
    private final File field_130070_K;
    private final PropertyMap field_181038_N;
    private final TextureManager field_71446_o;
    private final DataFixer field_184131_U;
    private final VirtualScreen field_195557_T;
    private final MainWindow field_195558_d;
    private final Timer field_71428_T = new Timer(20.0f, 0L);
    private final Snooper field_71427_U = new Snooper("client", this, Util.func_211177_b());
    private final RenderTypeBuffers field_228006_P_;
    public final WorldRenderer field_71438_f;
    private final EntityRendererManager field_175616_W;
    private final ItemRenderer field_175621_X;
    private final FirstPersonRenderer field_175620_Y;
    public final ParticleManager field_71452_i;
    private final SearchTreeManager field_193995_ae = new SearchTreeManager();
    private final Session field_71449_j;
    public final FontRenderer field_71466_p;
    public final GameRenderer field_71460_t;
    public final DebugRenderer field_184132_p;
    private final AtomicReference<TrackingChunkStatusListener> field_213277_ad = new AtomicReference();
    public final IngameGui field_71456_v;
    public final GameSettings field_71474_y;
    private final CreativeSettings field_191950_u;
    public final MouseHelper field_71417_B;
    public final KeyboardListener field_195559_v;
    public final File field_71412_D;
    private final String field_110447_Z;
    private final String field_184130_ao;
    private final Proxy field_110453_aa;
    private final SaveFormat field_71469_aa;
    public final FrameTimer field_181542_y = new FrameTimer();
    private final boolean field_147129_ai;
    private final boolean field_71459_aj;
    private final boolean field_238175_ae_;
    private final boolean field_238176_af_;
    private final IReloadableResourceManager field_110451_am;
    private final DownloadingPackFinder field_195554_ax;
    private final ResourcePackList<ClientResourcePackInfo> field_110448_aq;
    private final LanguageManager field_135017_as;
    private final BlockColors field_184127_aH;
    private final ItemColors field_184128_aI;
    private final Framebuffer field_147124_at;
    private final SoundHandler field_147127_av;
    private final MusicTicker field_147126_aw;
    private final FontResourceManager field_211501_aD;
    private final Splashes field_213271_aF;
    private final GPUWarning field_241557_ar_;
    private final MinecraftSessionService field_152355_az;
    private final SkinManager field_152350_aA;
    private final ModelManager field_175617_aL;
    private final BlockRendererDispatcher field_175618_aM;
    private final PaintingSpriteUploader field_213272_aL;
    private final PotionSpriteUploader field_213273_aM;
    private final ToastGui field_193034_aS;
    private final MinecraftGame field_213274_aO = new MinecraftGame(this);
    private final Tutorial field_193035_aW;
    public static byte[] field_71444_a;
    @Nullable
    public PlayerController field_71442_b;
    @Nullable
    public ClientWorld field_71441_e;
    @Nullable
    public ClientPlayerEntity field_71439_g;
    @Nullable
    private IntegratedServer field_71437_Z;
    @Nullable
    private ServerData field_71422_O;
    @Nullable
    private NetworkManager field_71453_ak;
    private boolean field_71455_al;
    @Nullable
    public Entity field_175622_Z;
    @Nullable
    public Entity field_147125_j;
    @Nullable
    public RayTraceResult field_71476_x;
    private int field_71467_ac;
    protected int field_71429_W;
    private boolean field_71445_n;
    private float field_193996_ah;
    private long field_181543_z = Util.func_211178_c();
    private long field_71419_L;
    private int field_71420_M;
    public boolean field_71454_w;
    @Nullable
    public Screen field_71462_r;
    @Nullable
    public LoadingGui field_213279_p;
    private boolean field_181541_X;
    private Thread field_152352_aC;
    private volatile boolean field_71425_J = true;
    @Nullable
    private CrashReport field_71433_S;
    private static int field_71470_ab;
    public String field_71426_K = "";
    public boolean field_228004_B_;
    public boolean field_228005_C_;
    public boolean field_175612_E = true;
    private boolean field_195555_I;
    private final Queue<Runnable> field_213275_aU = Queues.newConcurrentLinkedQueue();
    @Nullable
    private CompletableFuture<Void> field_213276_aV;
    private IProfiler field_71424_I = EmptyProfiler.field_219906_a;
    private int field_238172_aT_;
    private final TimeTracker field_238173_aU_ = new TimeTracker(Util.field_211180_a, () -> this.field_238172_aT_);
    @Nullable
    private IProfileResult field_238174_aV_;
    private String field_71465_an = "root";

    public Minecraft(GameConfiguration gameConfiguration) {
        super("Client");
        Object object;
        int \u26032;
        field_71432_P = this;
        this.field_71412_D = gameConfiguration.field_178744_c.field_178760_a;
        File file = gameConfiguration.field_178744_c.field_178759_c;
        this.field_130070_K = gameConfiguration.field_178744_c.field_178758_b;
        this.field_110447_Z = gameConfiguration.field_178741_d.field_178755_b;
        this.field_184130_ao = gameConfiguration.field_178741_d.field_187053_c;
        this.field_181038_N = gameConfiguration.field_178745_a.field_181172_c;
        this.field_195554_ax = new DownloadingPackFinder(new File(this.field_71412_D, "server-resource-packs"), gameConfiguration.field_178744_c.func_187052_a());
        this.field_110448_aq = new ResourcePackList<ClientResourcePackInfo>(Minecraft::func_228011_a_, this.field_195554_ax, new FolderPackFinder(this.field_130070_K, IPackNameDecorator.field_232625_a_));
        this.field_110453_aa = gameConfiguration.field_178745_a.field_178751_c;
        this.field_152355_az = new YggdrasilAuthenticationService(this.field_110453_aa, UUID.randomUUID().toString()).createMinecraftSessionService();
        this.field_71449_j = gameConfiguration.field_178745_a.field_178752_a;
        field_147123_G.info("Setting user: {}", (Object)this.field_71449_j.func_111285_a());
        field_147123_G.debug("(Session ID is {})", (Object)this.field_71449_j.func_111286_b());
        this.field_71459_aj = gameConfiguration.field_178741_d.field_178756_a;
        this.field_238175_ae_ = !gameConfiguration.field_178741_d.field_239099_d_;
        this.field_238176_af_ = !gameConfiguration.field_178741_d.field_239100_e_;
        this.field_147129_ai = Minecraft.func_147122_X();
        this.field_71437_Z = null;
        if (this.field_238175_ae_ && gameConfiguration.field_178742_e.field_178754_a != null) {
            String string = gameConfiguration.field_178742_e.field_178754_a;
            \u26032 = gameConfiguration.field_178742_e.field_178753_b;
        } else {
            string = null;
            \u26032 = 0;
        }
        KeybindTextComponent.func_240696_a_(KeyBinding::func_193626_b);
        this.field_184131_U = DataFixesManager.func_210901_a();
        this.field_193034_aS = new ToastGui(this);
        this.field_193035_aW = new Tutorial(this);
        this.field_152352_aC = Thread.currentThread();
        this.field_71474_y = new GameSettings(this, this.field_71412_D);
        this.field_191950_u = new CreativeSettings(this.field_71412_D, this.field_184131_U);
        field_147123_G.info("Backend library: {}", (Object)RenderSystem.getBackendDescription());
        ScreenSize screenSize = this.field_71474_y.field_92119_C > 0 && this.field_71474_y.field_92118_B > 0 ? new ScreenSize(this.field_71474_y.field_92118_B, this.field_71474_y.field_92119_C, gameConfiguration.field_178743_b.field_216496_c, gameConfiguration.field_178743_b.field_216497_d, gameConfiguration.field_178743_b.field_216498_e) : gameConfiguration.field_178743_b;
        Util.field_211180_a = RenderSystem.initBackendSystem();
        this.field_195557_T = new VirtualScreen(this);
        this.field_195558_d = this.field_195557_T.func_217626_a(screenSize, this.field_71474_y.field_198019_u, this.func_230149_ax_());
        this.func_213228_a(true);
        try {
            object = this.func_195541_I().func_195746_a().func_195761_a(ResourcePackType.CLIENT_RESOURCES, new ResourceLocation("icons/icon_16x16.png"));
            InputStream \u26033 = this.func_195541_I().func_195746_a().func_195761_a(ResourcePackType.CLIENT_RESOURCES, new ResourceLocation("icons/icon_32x32.png"));
            this.field_195558_d.func_216529_a((InputStream)object, \u26033);
        }
        catch (IOException iOException) {
            field_147123_G.error("Couldn't set icon", (Throwable)iOException);
        }
        this.field_195558_d.func_216526_a(this.field_71474_y.field_74350_i);
        this.field_71417_B = new MouseHelper(this);
        this.field_71417_B.func_198029_a(this.field_195558_d.func_198092_i());
        this.field_195559_v = new KeyboardListener(this);
        this.field_195559_v.func_197968_a(this.field_195558_d.func_198092_i());
        RenderSystem.initRenderer(this.field_71474_y.field_209231_W, false);
        this.field_147124_at = new Framebuffer(this.field_195558_d.func_198109_k(), this.field_195558_d.func_198091_l(), true, field_142025_a);
        this.field_147124_at.func_147604_a(0.0f, 0.0f, 0.0f, 0.0f);
        this.field_110451_am = new SimpleReloadableResourceManager(ResourcePackType.CLIENT_RESOURCES);
        this.field_110448_aq.func_198983_a();
        this.field_71474_y.func_198017_a(this.field_110448_aq);
        this.field_135017_as = new LanguageManager(this.field_71474_y.field_74363_ab);
        this.field_110451_am.func_219534_a(this.field_135017_as);
        this.field_71446_o = new TextureManager(this.field_110451_am);
        this.field_110451_am.func_219534_a(this.field_71446_o);
        this.field_152350_aA = new SkinManager(this.field_71446_o, new File(file, "skins"), this.field_152355_az);
        this.field_71469_aa = new SaveFormat(this.field_71412_D.toPath().resolve("saves"), this.field_71412_D.toPath().resolve("backups"), this.field_184131_U);
        this.field_147127_av = new SoundHandler(this.field_110451_am, this.field_71474_y);
        this.field_110451_am.func_219534_a(this.field_147127_av);
        this.field_213271_aF = new Splashes(this.field_71449_j);
        this.field_110451_am.func_219534_a(this.field_213271_aF);
        this.field_147126_aw = new MusicTicker(this);
        this.field_211501_aD = new FontResourceManager(this.field_71446_o);
        this.field_71466_p = this.field_211501_aD.func_238548_a_();
        this.field_110451_am.func_219534_a(this.field_211501_aD.func_216884_a());
        this.func_238209_b_(this.func_211821_e());
        this.field_110451_am.func_219534_a(new GrassColorReloadListener());
        this.field_110451_am.func_219534_a(new FoliageColorReloadListener());
        this.field_195558_d.func_227799_a_("Startup");
        RenderSystem.setupDefaultState(0, 0, this.field_195558_d.func_198109_k(), this.field_195558_d.func_198091_l());
        this.field_195558_d.func_227799_a_("Post startup");
        this.field_184127_aH = BlockColors.func_186723_a();
        this.field_184128_aI = ItemColors.func_186729_a(this.field_184127_aH);
        this.field_175617_aL = new ModelManager(this.field_71446_o, this.field_184127_aH, this.field_71474_y.field_151442_I);
        this.field_110451_am.func_219534_a(this.field_175617_aL);
        this.field_175621_X = new ItemRenderer(this.field_71446_o, this.field_175617_aL, this.field_184128_aI);
        this.field_175616_W = new EntityRendererManager(this.field_71446_o, this.field_175621_X, this.field_110451_am, this.field_71466_p, this.field_71474_y);
        this.field_175620_Y = new FirstPersonRenderer(this);
        this.field_110451_am.func_219534_a(this.field_175621_X);
        this.field_228006_P_ = new RenderTypeBuffers();
        this.field_71460_t = new GameRenderer(this, this.field_110451_am, this.field_228006_P_);
        this.field_110451_am.func_219534_a(this.field_71460_t);
        this.field_175618_aM = new BlockRendererDispatcher(this.field_175617_aL.func_174954_c(), this.field_184127_aH);
        this.field_110451_am.func_219534_a(this.field_175618_aM);
        this.field_71438_f = new WorldRenderer(this, this.field_228006_P_);
        this.field_110451_am.func_219534_a(this.field_71438_f);
        this.func_193986_ar();
        this.field_110451_am.func_219534_a(this.field_193995_ae);
        this.field_71452_i = new ParticleManager(this.field_71441_e, this.field_71446_o);
        this.field_110451_am.func_219534_a(this.field_71452_i);
        this.field_213272_aL = new PaintingSpriteUploader(this.field_71446_o);
        this.field_110451_am.func_219534_a(this.field_213272_aL);
        this.field_213273_aM = new PotionSpriteUploader(this.field_71446_o);
        this.field_110451_am.func_219534_a(this.field_213273_aM);
        this.field_241557_ar_ = new GPUWarning();
        this.field_110451_am.func_219534_a(this.field_241557_ar_);
        this.field_71456_v = new IngameGui(this);
        this.field_184132_p = new DebugRenderer(this);
        RenderSystem.setErrorCallback(this::func_195545_a);
        if (this.field_71474_y.field_74353_u && !this.field_195558_d.func_198113_j()) {
            this.field_195558_d.func_198077_g();
            this.field_71474_y.field_74353_u = this.field_195558_d.func_198113_j();
        }
        this.field_195558_d.func_216523_b(this.field_71474_y.field_74352_v);
        this.field_195558_d.func_224798_d(this.field_71474_y.field_225307_E);
        this.field_195558_d.func_227801_c_();
        this.func_213226_a();
        if (string != null) {
            this.func_147108_a(new ConnectingScreen(new MainMenuScreen(), this, string, \u26032));
        } else {
            this.func_147108_a(new MainMenuScreen(true));
        }
        ResourceLoadProgressGui.func_212970_a(this);
        object = this.field_110448_aq.func_232623_f_();
        this.func_213268_a(new ResourceLoadProgressGui(this, this.field_110451_am.func_219537_a(Util.func_215072_e(), this, field_223714_G, (List<IResourcePack>)object), optional -> Util.func_215077_a(optional, this::func_229988_a_, () -> {
            if (SharedConstants.field_206244_b) {
                this.func_213256_aB();
            }
        }), false));
    }

    public void func_230150_b_() {
        this.field_195558_d.func_230148_b_(this.func_230149_ax_());
    }

    private String func_230149_ax_() {
        StringBuilder stringBuilder = new StringBuilder("Minecraft");
        if (this.func_230151_c_()) {
            stringBuilder.append("*");
        }
        stringBuilder.append(" ");
        stringBuilder.append(SharedConstants.func_215069_a().getName());
        ClientPlayNetHandler \u26032 = this.func_147114_u();
        if (\u26032 != null && \u26032.func_147298_b().func_150724_d()) {
            stringBuilder.append(" - ");
            if (this.field_71437_Z != null && !this.field_71437_Z.func_71344_c()) {
                stringBuilder.append(I18n.func_135052_a("title.singleplayer", new Object[0]));
            } else if (this.func_181540_al()) {
                stringBuilder.append(I18n.func_135052_a("title.multiplayer.realms", new Object[0]));
            } else if (this.field_71437_Z != null || this.field_71422_O != null && this.field_71422_O.func_181041_d()) {
                stringBuilder.append(I18n.func_135052_a("title.multiplayer.lan", new Object[0]));
            } else {
                stringBuilder.append(I18n.func_135052_a("title.multiplayer.other", new Object[0]));
            }
        }
        return stringBuilder.toString();
    }

    public boolean func_230151_c_() {
        return !"vanilla".equals(ClientBrandRetriever.getClientModName()) || Minecraft.class.getSigners() == null;
    }

    private void func_229988_a_(Throwable throwable2) {
        if (this.field_110448_aq.func_232621_d_().size() > 1) {
            StringTextComponent stringTextComponent = throwable2 instanceof SimpleReloadableResourceManager.FailedPackException ? new StringTextComponent(((SimpleReloadableResourceManager.FailedPackException)throwable2).func_241203_a().func_195762_a()) : null;
            field_147123_G.info("Caught error loading resourcepacks, removing all selected resourcepacks", throwable2);
            this.field_110448_aq.func_198985_a(Collections.emptyList());
            this.field_71474_y.field_151453_l.clear();
            this.field_71474_y.field_183018_l.clear();
            this.field_71474_y.func_74303_b();
            this.func_213237_g().thenRun(() -> {
                ToastGui toastGui = this.func_193033_an();
                SystemToast.func_193657_a(toastGui, SystemToast.Type.PACK_LOAD_FAILURE, new TranslationTextComponent("resourcePack.load_fail"), stringTextComponent);
            });
        } else {
            Throwable throwable2;
            Util.func_229756_b_(throwable2);
        }
    }

    public void func_99999_d() {
        this.field_152352_aC = Thread.currentThread();
        try {
            boolean bl = false;
            while (this.field_71425_J) {
                if (this.field_71433_S != null) {
                    Minecraft.func_71377_b(this.field_71433_S);
                    return;
                }
                try {
                    LongTickDetector longTickDetector = LongTickDetector.func_233524_a_("Renderer");
                    boolean \u26032 = this.func_238202_aF_();
                    this.func_238201_a_(\u26032, longTickDetector);
                    this.field_71424_I.func_219894_a();
                    this.func_195542_b(!bl);
                    this.field_71424_I.func_219897_b();
                    this.func_238210_b_(\u26032, longTickDetector);
                }
                catch (OutOfMemoryError outOfMemoryError) {
                    if (bl) {
                        throw outOfMemoryError;
                    }
                    this.func_71398_f();
                    this.func_147108_a(new MemoryErrorScreen());
                    System.gc();
                    field_147123_G.fatal("Out of memory", (Throwable)outOfMemoryError);
                    bl = true;
                }
            }
        }
        catch (ReportedException reportedException) {
            this.func_71396_d(reportedException.func_71575_a());
            this.func_71398_f();
            field_147123_G.fatal("Reported exception thrown!", (Throwable)reportedException);
            Minecraft.func_71377_b(reportedException.func_71575_a());
        }
        catch (Throwable throwable) {
            CrashReport crashReport = this.func_71396_d(new CrashReport("Unexpected error", throwable));
            field_147123_G.fatal("Unreported exception thrown!", throwable);
            this.func_71398_f();
            Minecraft.func_71377_b(crashReport);
        }
    }

    void func_238209_b_(boolean bl) {
        this.field_211501_aD.func_238551_a_((Map<ResourceLocation, ResourceLocation>)(bl ? ImmutableMap.of((Object)field_211502_b, (Object)field_238177_c_) : ImmutableMap.of()));
    }

    private void func_193986_ar() {
        SearchTree<ItemStack> searchTree = new SearchTree<ItemStack>(itemStack -> itemStack.func_82840_a(null, ITooltipFlag.TooltipFlags.NORMAL).stream().map(iTextComponent -> TextFormatting.func_110646_a(iTextComponent.getString()).trim()).filter(string -> !string.isEmpty()), itemStack -> Stream.of(Registry.field_212630_s.func_177774_c(itemStack.func_77973_b())));
        SearchTreeReloadable<ItemStack> \u26032 = new SearchTreeReloadable<ItemStack>(itemStack -> ItemTags.func_199903_a().func_199913_a(itemStack.func_77973_b()).stream());
        NonNullList<ItemStack> \u26033 = NonNullList.func_191196_a();
        for (Item item : Registry.field_212630_s) {
            item.func_150895_a(ItemGroup.field_78027_g, \u26033);
        }
        \u26033.forEach(itemStack -> {
            searchTree.func_217872_a((ItemStack)itemStack);
            \u26032.func_217872_a((ItemStack)itemStack);
        });
        SearchTree<RecipeList> \u26034 = new SearchTree<RecipeList>(recipeList -> recipeList.func_192711_b().stream().flatMap(iRecipe -> iRecipe.func_77571_b().func_82840_a(null, ITooltipFlag.TooltipFlags.NORMAL).stream()).map(iTextComponent -> TextFormatting.func_110646_a(iTextComponent.getString()).trim()).filter(string -> !string.isEmpty()), recipeList -> recipeList.func_192711_b().stream().map(iRecipe -> Registry.field_212630_s.func_177774_c(iRecipe.func_77571_b().func_77973_b())));
        this.field_193995_ae.func_215357_a(SearchTreeManager.field_215359_a, searchTree);
        this.field_193995_ae.func_215357_a(SearchTreeManager.field_215360_b, \u26032);
        this.field_193995_ae.func_215357_a(SearchTreeManager.field_194012_b, \u26034);
    }

    private void func_195545_a(int n, long l) {
        this.field_71474_y.field_74352_v = false;
        this.field_71474_y.func_74303_b();
    }

    private static boolean func_147122_X() {
        String[] stringArray;
        for (String \u26032 : stringArray = new String[]{"sun.arch.data.model", "com.ibm.vm.bitmode", "os.arch"}) {
            String string = System.getProperty(\u26032);
            if (string == null || !string.contains("64")) continue;
            return true;
        }
        return false;
    }

    public Framebuffer func_147110_a() {
        return this.field_147124_at;
    }

    public String func_175600_c() {
        return this.field_110447_Z;
    }

    public String func_184123_d() {
        return this.field_184130_ao;
    }

    public void func_71404_a(CrashReport crashReport) {
        this.field_71433_S = crashReport;
    }

    public static void func_71377_b(CrashReport crashReport) {
        File file = new File(Minecraft.func_71410_x().field_71412_D, "crash-reports");
        \u2603 = new File(file, "crash-" + new SimpleDateFormat("yyyy-MM-dd_HH.mm.ss").format(new Date()) + "-client.txt");
        Bootstrap.func_179870_a(crashReport.func_71502_e());
        if (crashReport.func_71497_f() != null) {
            Bootstrap.func_179870_a("#@!@# Game crashed! Crash report saved to: #@!@# " + crashReport.func_71497_f());
            System.exit(-1);
        } else if (crashReport.func_147149_a(\u2603)) {
            Bootstrap.func_179870_a("#@!@# Game crashed! Crash report saved to: #@!@# " + \u2603.getAbsolutePath());
            System.exit(-1);
        } else {
            Bootstrap.func_179870_a("#@?@# Game crashed! Crash report could not be saved. #@?@#");
            System.exit(-2);
        }
    }

    public boolean func_211821_e() {
        return this.field_71474_y.field_211842_aO;
    }

    public CompletableFuture<Void> func_213237_g() {
        if (this.field_213276_aV != null) {
            return this.field_213276_aV;
        }
        CompletableFuture<Void> completableFuture = new CompletableFuture<Void>();
        if (this.field_213279_p instanceof ResourceLoadProgressGui) {
            this.field_213276_aV = completableFuture;
            return completableFuture;
        }
        this.field_110448_aq.func_198983_a();
        List<IResourcePack> \u26032 = this.field_110448_aq.func_232623_f_();
        this.func_213268_a(new ResourceLoadProgressGui(this, this.field_110451_am.func_219537_a(Util.func_215072_e(), this, field_223714_G, \u26032), optional -> Util.func_215077_a(optional, this::func_229988_a_, () -> {
            this.field_71438_f.func_72712_a();
            completableFuture.complete(null);
        }), true));
        return completableFuture;
    }

    private void func_213256_aB() {
        boolean bl = false;
        BlockModelShapes \u26032 = this.func_175602_ab().func_175023_a();
        IBakedModel \u26033 = \u26032.func_178126_b().func_174951_a();
        for (Block block : Registry.field_212618_g) {
            for (Object object : block.func_176194_O().func_177619_a()) {
                if (((AbstractBlock.AbstractBlockState)object).func_185901_i() != BlockRenderType.MODEL || (object = \u26032.func_178125_b((BlockState)object)) != \u26033) continue;
                field_147123_G.debug("Missing model for: {}", object);
                bl = true;
            }
        }
        TextureAtlasSprite textureAtlasSprite = \u26033.func_177554_e();
        for (Block block : Registry.field_212618_g) {
            for (Object object : block.func_176194_O().func_177619_a()) {
                object2 = \u26032.func_178122_a((BlockState)object);
                if (((AbstractBlock.AbstractBlockState)object).func_196958_f() || object2 != textureAtlasSprite) continue;
                field_147123_G.debug("Missing particle icon for: {}", object);
                bl = true;
            }
        }
        NonNullList<ItemStack> nonNullList = NonNullList.func_191196_a();
        for (Object object : Registry.field_212630_s) {
            nonNullList.clear();
            ((Item)object).func_150895_a(ItemGroup.field_78027_g, nonNullList);
            for (Object object2 : nonNullList) {
                String string = ((ItemStack)object2).func_77977_a();
                \u2603 = new TranslationTextComponent(string).getString();
                if (!\u2603.toLowerCase(Locale.ROOT).equals(((Item)object).func_77658_a())) continue;
                field_147123_G.debug("Missing translation for: {} {} {}", object2, (Object)string, (Object)((ItemStack)object2).func_77973_b());
            }
        }
        if (bl |= ScreenManager.func_216910_a()) {
            throw new IllegalStateException("Your game data is foobar, fix the errors above!");
        }
    }

    public SaveFormat func_71359_d() {
        return this.field_71469_aa;
    }

    private void func_238207_b_(String string) {
        if (!this.func_71387_A() && !this.func_238217_s_()) {
            if (this.field_71439_g != null) {
                this.field_71439_g.func_145747_a(new TranslationTextComponent("chat.cannotSend").func_240699_a_(TextFormatting.RED), Util.field_240973_b_);
            }
        } else {
            this.func_147108_a(new ChatScreen(string));
        }
    }

    public void func_147108_a(@Nullable Screen screen) {
        if (this.field_71462_r != null) {
            this.field_71462_r.func_231164_f_();
        }
        if (screen == null && this.field_71441_e == null) {
            screen = new MainMenuScreen();
        } else if (screen == null && this.field_71439_g.func_233643_dh_()) {
            if (this.field_71439_g.func_228353_F_()) {
                screen = new DeathScreen(null, this.field_71441_e.func_72912_H().func_76093_s());
            } else {
                this.field_71439_g.func_71004_bE();
            }
        }
        if (screen instanceof MainMenuScreen || screen instanceof MultiplayerScreen) {
            this.field_71474_y.field_74330_P = false;
            this.field_71456_v.func_146158_b().func_146231_a(true);
        }
        this.field_71462_r = screen;
        if (screen != null) {
            this.field_71417_B.func_198032_j();
            KeyBinding.func_74506_a();
            screen.func_231158_b_(this, this.field_195558_d.func_198107_o(), this.field_195558_d.func_198087_p());
            this.field_71454_w = false;
            NarratorChatListener.field_193643_a.func_216864_a(screen.func_231167_h_());
        } else {
            this.field_147127_av.func_147687_e();
            this.field_71417_B.func_198034_i();
        }
        this.func_230150_b_();
    }

    public void func_213268_a(@Nullable LoadingGui loadingGui) {
        this.field_213279_p = loadingGui;
    }

    public void func_71405_e() {
        try {
            field_147123_G.info("Stopping!");
            try {
                NarratorChatListener.field_193643_a.func_216867_c();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                if (this.field_71441_e != null) {
                    this.field_71441_e.func_72882_A();
                }
                this.func_213254_o();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (this.field_71462_r != null) {
                this.field_71462_r.func_231164_f_();
            }
            this.close();
        }
        finally {
            Util.field_211180_a = System::nanoTime;
            if (this.field_71433_S == null) {
                System.exit(0);
            }
        }
    }

    @Override
    public void close() {
        try {
            this.field_175617_aL.close();
            this.field_211501_aD.close();
            this.field_71460_t.close();
            this.field_71438_f.close();
            this.field_147127_av.func_147685_d();
            this.field_110448_aq.close();
            this.field_71452_i.func_215232_a();
            this.field_213273_aM.close();
            this.field_213272_aL.close();
            this.field_71446_o.close();
            this.field_110451_am.close();
            Util.func_240993_h_();
        }
        catch (Throwable throwable) {
            field_147123_G.error("Shutdown failure!", throwable);
            throw throwable;
        }
        finally {
            this.field_195557_T.close();
            this.field_195558_d.close();
        }
    }

    private void func_195542_b(boolean bl) {
        int n;
        Object object;
        this.field_195558_d.func_227799_a_("Pre render");
        long l = Util.func_211178_c();
        if (this.field_195558_d.func_227800_b_()) {
            this.func_71400_g();
        }
        if (this.field_213276_aV != null && !(this.field_213279_p instanceof ResourceLoadProgressGui)) {
            object = this.field_213276_aV;
            this.field_213276_aV = null;
            this.func_213237_g().thenRun(() -> Minecraft.func_229997_b_((CompletableFuture)object));
        }
        while ((object = this.field_213275_aU.poll()) != null) {
            object.run();
        }
        if (bl) {
            n = this.field_71428_T.func_238400_a_(Util.func_211177_b());
            this.field_71424_I.func_76320_a("scheduledExecutables");
            this.func_213160_bf();
            this.field_71424_I.func_76319_b();
            this.field_71424_I.func_76320_a("tick");
            for (\u2603 = 0; \u2603 < Math.min(10, n); ++\u2603) {
                this.field_71424_I.func_230035_c_("clientTick");
                this.func_71407_l();
            }
            this.field_71424_I.func_76319_b();
        }
        this.field_71417_B.func_198028_a();
        this.field_195558_d.func_227799_a_("Render");
        this.field_71424_I.func_76320_a("sound");
        this.field_147127_av.func_215289_a(this.field_71460_t.func_215316_n());
        this.field_71424_I.func_76319_b();
        this.field_71424_I.func_76320_a("render");
        RenderSystem.pushMatrix();
        RenderSystem.clear(16640, field_142025_a);
        this.field_147124_at.func_147610_a(true);
        FogRenderer.func_228370_a_();
        this.field_71424_I.func_76320_a("display");
        RenderSystem.enableTexture();
        RenderSystem.enableCull();
        this.field_71424_I.func_76319_b();
        if (!this.field_71454_w) {
            this.field_71424_I.func_219895_b("gameRenderer");
            this.field_71460_t.func_195458_a(this.field_71445_n ? this.field_193996_ah : this.field_71428_T.field_194147_b, l, bl);
            this.field_71424_I.func_219895_b("toasts");
            this.field_193034_aS.func_238541_a_(new MatrixStack());
            this.field_71424_I.func_76319_b();
        }
        if (this.field_238174_aV_ != null) {
            this.field_71424_I.func_76320_a("fpsPie");
            this.func_238183_a_(new MatrixStack(), this.field_238174_aV_);
            this.field_71424_I.func_76319_b();
        }
        this.field_71424_I.func_76320_a("blit");
        this.field_147124_at.func_147609_e();
        RenderSystem.popMatrix();
        RenderSystem.pushMatrix();
        this.field_147124_at.func_147615_c(this.field_195558_d.func_198109_k(), this.field_195558_d.func_198091_l());
        RenderSystem.popMatrix();
        this.field_71424_I.func_219895_b("updateDisplay");
        this.field_195558_d.func_227802_e_();
        n = this.func_213243_aC();
        if ((double)n < AbstractOption.field_216701_h.func_216733_c()) {
            RenderSystem.limitDisplayFPS(n);
        }
        this.field_71424_I.func_219895_b("yield");
        Thread.yield();
        this.field_71424_I.func_76319_b();
        this.field_195558_d.func_227799_a_("Post render");
        ++this.field_71420_M;
        int n2 = \u2603 = this.func_71356_B() && (this.field_71462_r != null && this.field_71462_r.func_231177_au__() || this.field_213279_p != null && this.field_213279_p.func_212969_a()) && !this.field_71437_Z.func_71344_c() ? 1 : 0;
        if (this.field_71445_n != \u2603) {
            if (this.field_71445_n) {
                this.field_193996_ah = this.field_71428_T.field_194147_b;
            } else {
                this.field_71428_T.field_194147_b = this.field_193996_ah;
            }
            this.field_71445_n = \u2603;
        }
        long \u26032 = Util.func_211178_c();
        this.field_181542_y.func_181747_a(\u26032 - this.field_181543_z);
        this.field_181543_z = \u26032;
        this.field_71424_I.func_76320_a("fpsUpdate");
        while (Util.func_211177_b() >= this.field_71419_L + 1000L) {
            field_71470_ab = this.field_71420_M;
            this.field_71426_K = String.format("%d fps T: %s%s%s%s B: %d", field_71470_ab, (double)this.field_71474_y.field_74350_i == AbstractOption.field_216701_h.func_216733_c() ? "inf" : Integer.valueOf(this.field_71474_y.field_74350_i), this.field_71474_y.field_74352_v ? " vsync" : "", this.field_71474_y.field_238330_f_.toString(), this.field_71474_y.field_74345_l == CloudOption.OFF ? "" : (this.field_71474_y.field_74345_l == CloudOption.FAST ? " fast-clouds" : " fancy-clouds"), this.field_71474_y.field_205217_U);
            this.field_71419_L += 1000L;
            this.field_71420_M = 0;
            this.field_71427_U.func_76471_b();
            if (this.field_71427_U.func_76468_d()) continue;
            this.field_71427_U.func_76463_a();
        }
        this.field_71424_I.func_76319_b();
    }

    private boolean func_238202_aF_() {
        return this.field_71474_y.field_74330_P && this.field_71474_y.field_74329_Q && !this.field_71474_y.field_74319_N;
    }

    private void func_238201_a_(boolean bl, @Nullable LongTickDetector longTickDetector) {
        if (bl) {
            if (!this.field_238173_aU_.func_233505_a_()) {
                this.field_238172_aT_ = 0;
                this.field_238173_aU_.func_233507_c_();
            }
            ++this.field_238172_aT_;
        } else {
            this.field_238173_aU_.func_233506_b_();
        }
        this.field_71424_I = LongTickDetector.func_233523_a_(this.field_238173_aU_.func_233508_d_(), longTickDetector);
    }

    private void func_238210_b_(boolean bl, @Nullable LongTickDetector longTickDetector) {
        if (longTickDetector != null) {
            longTickDetector.func_233525_b_();
        }
        this.field_238174_aV_ = bl ? this.field_238173_aU_.func_233509_e_() : null;
        this.field_71424_I = this.field_238173_aU_.func_233508_d_();
    }

    @Override
    public void func_213226_a() {
        int n = this.field_195558_d.func_216521_a(this.field_71474_y.field_74335_Z, this.func_211821_e());
        this.field_195558_d.func_216525_a(n);
        if (this.field_71462_r != null) {
            this.field_71462_r.func_231152_a_(this, this.field_195558_d.func_198107_o(), this.field_195558_d.func_198087_p());
        }
        Framebuffer \u26032 = this.func_147110_a();
        \u26032.func_216491_a(this.field_195558_d.func_198109_k(), this.field_195558_d.func_198091_l(), field_142025_a);
        this.field_71460_t.func_147704_a(this.field_195558_d.func_198109_k(), this.field_195558_d.func_198091_l());
        this.field_71417_B.func_198021_g();
    }

    @Override
    public void func_241216_b_() {
        this.field_71417_B.func_241563_k_();
    }

    private int func_213243_aC() {
        if (this.field_71441_e == null && (this.field_71462_r != null || this.field_213279_p != null)) {
            return 60;
        }
        return this.field_195558_d.func_198082_x();
    }

    public void func_71398_f() {
        try {
            field_71444_a = new byte[0];
            this.field_71438_f.func_72728_f();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            System.gc();
            if (this.field_71455_al && this.field_71437_Z != null) {
                this.field_71437_Z.func_71263_m(true);
            }
            this.func_213231_b(new DirtMessageScreen(new TranslationTextComponent("menu.savingLevel")));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        System.gc();
    }

    void func_71383_b(int n) {
        if (this.field_238174_aV_ == null) {
            return;
        }
        List<DataPoint> list = this.field_238174_aV_.func_219917_a(this.field_71465_an);
        if (list.isEmpty()) {
            return;
        }
        DataPoint \u26032 = list.remove(0);
        if (n == 0) {
            if (!\u26032.field_219945_c.isEmpty() && (\u2603 = this.field_71465_an.lastIndexOf(30)) >= 0) {
                this.field_71465_an = this.field_71465_an.substring(0, \u2603);
            }
        } else if (--n < list.size() && !"unspecified".equals(list.get((int)n).field_219945_c)) {
            if (!this.field_71465_an.isEmpty()) {
                this.field_71465_an = this.field_71465_an + '\u001e';
            }
            this.field_71465_an = this.field_71465_an + list.get((int)n).field_219945_c;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void func_238183_a_(MatrixStack matrixStack, IProfileResult iProfileResult) {
        void var13_15;
        List<DataPoint> list = iProfileResult.func_219917_a(this.field_71465_an);
        DataPoint \u26032 = list.remove(0);
        RenderSystem.clear(256, field_142025_a);
        RenderSystem.matrixMode(5889);
        RenderSystem.loadIdentity();
        RenderSystem.ortho(0.0, this.field_195558_d.func_198109_k(), this.field_195558_d.func_198091_l(), 0.0, 1000.0, 3000.0);
        RenderSystem.matrixMode(5888);
        RenderSystem.loadIdentity();
        RenderSystem.translatef(0.0f, 0.0f, -2000.0f);
        RenderSystem.lineWidth(1.0f);
        RenderSystem.disableTexture();
        Tessellator \u26033 = Tessellator.func_178181_a();
        BufferBuilder \u26034 = \u26033.func_178180_c();
        int \u26035 = 160;
        int \u26036 = this.field_195558_d.func_198109_k() - 160 - 10;
        int \u26037 = this.field_195558_d.func_198091_l() - 320;
        RenderSystem.enableBlend();
        \u26034.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        \u26034.func_225582_a_((float)\u26036 - 176.0f, (float)\u26037 - 96.0f - 16.0f, 0.0).func_225586_a_(200, 0, 0, 0).func_181675_d();
        \u26034.func_225582_a_((float)\u26036 - 176.0f, \u26037 + 320, 0.0).func_225586_a_(200, 0, 0, 0).func_181675_d();
        \u26034.func_225582_a_((float)\u26036 + 176.0f, \u26037 + 320, 0.0).func_225586_a_(200, 0, 0, 0).func_181675_d();
        \u26034.func_225582_a_((float)\u26036 + 176.0f, (float)\u26037 - 96.0f - 16.0f, 0.0).func_225586_a_(200, 0, 0, 0).func_181675_d();
        \u26033.func_78381_a();
        RenderSystem.disableBlend();
        double \u26038 = 0.0;
        for (DataPoint dataPoint : list) {
            int n = MathHelper.func_76128_c(dataPoint.field_219943_a / 4.0) + 1;
            \u26034.func_181668_a(6, DefaultVertexFormats.field_181706_f);
            int \u260311 = dataPoint.func_219942_a();
            int n2 = \u260311 >> 16 & 0xFF;
            \u2603 = \u260311 >> 8 & 0xFF;
            \u2603 = \u260311 & 0xFF;
            \u26034.func_225582_a_(\u26036, \u26037, 0.0).func_225586_a_(n2, \u2603, \u2603, 255).func_181675_d();
            for (int i = n; i >= 0; --i) {
                float f = (float)((\u26038 + dataPoint.field_219943_a * (double)i / (double)n) * 6.2831854820251465 / 100.0);
                float f2 = MathHelper.func_76126_a(f) * 160.0f;
                \u2603 = MathHelper.func_76134_b(f) * 160.0f * 0.5f;
                \u26034.func_225582_a_((float)\u26036 + f2, (float)\u26037 - \u2603, 0.0).func_225586_a_(n2, \u2603, \u2603, 255).func_181675_d();
            }
            \u26033.func_78381_a();
            \u26034.func_181668_a(5, DefaultVertexFormats.field_181706_f);
            for (int i = n; i >= 0; --i) {
                float f = (float)((\u26038 + dataPoint.field_219943_a * (double)i / (double)n) * 6.2831854820251465 / 100.0);
                f2 = MathHelper.func_76126_a(f) * 160.0f;
                \u2603 = MathHelper.func_76134_b(f) * 160.0f * 0.5f;
                if (\u2603 > 0.0f) continue;
                \u26034.func_225582_a_((float)\u26036 + f2, (float)\u26037 - \u2603, 0.0).func_225586_a_(n2 >> 1, \u2603 >> 1, \u2603 >> 1, 255).func_181675_d();
                \u26034.func_225582_a_((float)\u26036 + f2, (float)\u26037 - \u2603 + 10.0f, 0.0).func_225586_a_(n2 >> 1, \u2603 >> 1, \u2603 >> 1, 255).func_181675_d();
            }
            \u26033.func_78381_a();
            \u26038 += dataPoint.field_219943_a;
        }
        DecimalFormat decimalFormat = new DecimalFormat("##0.00");
        decimalFormat.setDecimalFormatSymbols(DecimalFormatSymbols.getInstance(Locale.ROOT));
        RenderSystem.enableTexture();
        String string = IProfileResult.func_225434_b(\u26032.field_219945_c);
        String \u260310 = "";
        if (!"unspecified".equals(string)) {
            \u260310 = \u260310 + "[0] ";
        }
        \u260310 = string.isEmpty() ? \u260310 + "ROOT " : \u260310 + string + ' ';
        int n = 0xFFFFFF;
        this.field_71466_p.func_238405_a_(matrixStack, \u260310, \u26036 - 160, \u26037 - 80 - 16, 0xFFFFFF);
        \u260310 = decimalFormat.format(\u26032.field_219944_b) + "%";
        this.field_71466_p.func_238405_a_(matrixStack, \u260310, \u26036 + 160 - this.field_71466_p.func_78256_a(\u260310), \u26037 - 80 - 16, 0xFFFFFF);
        boolean bl = false;
        while (var13_15 < list.size()) {
            DataPoint dataPoint = list.get((int)var13_15);
            StringBuilder stringBuilder = new StringBuilder();
            if ("unspecified".equals(dataPoint.field_219945_c)) {
                stringBuilder.append("[?] ");
            } else {
                stringBuilder.append("[").append((int)(var13_15 + true)).append("] ");
            }
            String \u260312 = stringBuilder.append(dataPoint.field_219945_c).toString();
            this.field_71466_p.func_238405_a_(matrixStack, \u260312, \u26036 - 160, \u26037 + 80 + var13_15 * 8 + 20, dataPoint.func_219942_a());
            \u260312 = decimalFormat.format(dataPoint.field_219943_a) + "%";
            this.field_71466_p.func_238405_a_(matrixStack, \u260312, \u26036 + 160 - 50 - this.field_71466_p.func_78256_a(\u260312), \u26037 + 80 + var13_15 * 8 + 20, dataPoint.func_219942_a());
            \u260312 = decimalFormat.format(dataPoint.field_219944_b) + "%";
            this.field_71466_p.func_238405_a_(matrixStack, \u260312, \u26036 + 160 - this.field_71466_p.func_78256_a(\u260312), \u26037 + 80 + var13_15 * 8 + 20, dataPoint.func_219942_a());
            ++var13_15;
        }
    }

    public void func_71400_g() {
        this.field_71425_J = false;
    }

    public boolean func_228025_l_() {
        return this.field_71425_J;
    }

    public void func_71385_j(boolean bl) {
        if (this.field_71462_r != null) {
            return;
        }
        boolean bl2 = \u2603 = this.func_71356_B() && !this.field_71437_Z.func_71344_c();
        if (\u2603) {
            this.func_147108_a(new IngameMenuScreen(!bl));
            this.field_147127_av.func_147689_b();
        } else {
            this.func_147108_a(new IngameMenuScreen(true));
        }
    }

    private void func_147115_a(boolean bl) {
        if (!bl) {
            this.field_71429_W = 0;
        }
        if (this.field_71429_W > 0 || this.field_71439_g.func_184587_cr()) {
            return;
        }
        if (bl && this.field_71476_x != null && this.field_71476_x.func_216346_c() == RayTraceResult.Type.BLOCK) {
            BlockRayTraceResult blockRayTraceResult = (BlockRayTraceResult)this.field_71476_x;
            BlockPos \u26032 = blockRayTraceResult.func_216350_a();
            if (!this.field_71441_e.func_180495_p(\u26032).func_196958_f() && this.field_71442_b.func_180512_c(\u26032, \u2603 = blockRayTraceResult.func_216354_b())) {
                this.field_71452_i.func_180532_a(\u26032, \u2603);
                this.field_71439_g.func_184609_a(Hand.MAIN_HAND);
            }
            return;
        }
        this.field_71442_b.func_78767_c();
    }

    private void func_147116_af() {
        if (this.field_71429_W > 0) {
            return;
        }
        if (this.field_71476_x == null) {
            field_147123_G.error("Null returned as 'hitResult', this shouldn't happen!");
            if (this.field_71442_b.func_78762_g()) {
                this.field_71429_W = 10;
            }
            return;
        }
        if (this.field_71439_g.func_184838_M()) {
            return;
        }
        switch (this.field_71476_x.func_216346_c()) {
            case ENTITY: {
                this.field_71442_b.func_78764_a(this.field_71439_g, ((EntityRayTraceResult)this.field_71476_x).func_216348_a());
                break;
            }
            case BLOCK: {
                BlockRayTraceResult blockRayTraceResult = (BlockRayTraceResult)this.field_71476_x;
                BlockPos \u26032 = blockRayTraceResult.func_216350_a();
                if (!this.field_71441_e.func_180495_p(\u26032).func_196958_f()) {
                    this.field_71442_b.func_180511_b(\u26032, blockRayTraceResult.func_216354_b());
                    break;
                }
            }
            case MISS: {
                if (this.field_71442_b.func_78762_g()) {
                    this.field_71429_W = 10;
                }
                this.field_71439_g.func_184821_cY();
            }
        }
        this.field_71439_g.func_184609_a(Hand.MAIN_HAND);
    }

    private void func_147121_ag() {
        if (this.field_71442_b.func_181040_m()) {
            return;
        }
        this.field_71467_ac = 4;
        if (this.field_71439_g.func_184838_M()) {
            return;
        }
        if (this.field_71476_x == null) {
            field_147123_G.warn("Null returned as 'hitResult', this shouldn't happen!");
        }
        for (Hand hand : Hand.values()) {
            ItemStack itemStack = this.field_71439_g.func_184586_b(hand);
            if (this.field_71476_x != null) {
                switch (this.field_71476_x.func_216346_c()) {
                    case ENTITY: {
                        Object object = (EntityRayTraceResult)this.field_71476_x;
                        Entity \u26032 = ((EntityRayTraceResult)object).func_216348_a();
                        ActionResultType \u26033 = this.field_71442_b.func_187102_a(this.field_71439_g, \u26032, (EntityRayTraceResult)object, hand);
                        if (!\u26033.func_226246_a_()) {
                            \u26033 = this.field_71442_b.func_187097_a(this.field_71439_g, \u26032, hand);
                        }
                        if (!\u26033.func_226246_a_()) break;
                        if (\u26033.func_226247_b_()) {
                            this.field_71439_g.func_184609_a(hand);
                        }
                        return;
                    }
                    case BLOCK: {
                        BlockRayTraceResult \u26034 = (BlockRayTraceResult)this.field_71476_x;
                        int \u26035 = itemStack.func_190916_E();
                        ActionResultType \u26036 = this.field_71442_b.func_217292_a(this.field_71439_g, this.field_71441_e, hand, \u26034);
                        if (\u26036.func_226246_a_()) {
                            if (\u26036.func_226247_b_()) {
                                this.field_71439_g.func_184609_a(hand);
                                if (!itemStack.func_190926_b() && (itemStack.func_190916_E() != \u26035 || this.field_71442_b.func_78758_h())) {
                                    this.field_71460_t.field_78516_c.func_187460_a(hand);
                                }
                            }
                            return;
                        }
                        if (\u26036 != ActionResultType.FAIL) break;
                        return;
                    }
                }
            }
            if (itemStack.func_190926_b() || !((ActionResultType)((Object)(object = this.field_71442_b.func_187101_a(this.field_71439_g, this.field_71441_e, hand)))).func_226246_a_()) continue;
            if (((ActionResultType)((Object)object)).func_226247_b_()) {
                this.field_71439_g.func_184609_a(hand);
            }
            this.field_71460_t.field_78516_c.func_187460_a(hand);
            return;
        }
    }

    public MusicTicker func_181535_r() {
        return this.field_147126_aw;
    }

    public void func_71407_l() {
        if (this.field_71467_ac > 0) {
            --this.field_71467_ac;
        }
        this.field_71424_I.func_76320_a("gui");
        if (!this.field_71445_n) {
            this.field_71456_v.func_73831_a();
        }
        this.field_71424_I.func_76319_b();
        this.field_71460_t.func_78473_a(1.0f);
        this.field_193035_aW.func_193297_a(this.field_71441_e, this.field_71476_x);
        this.field_71424_I.func_76320_a("gameMode");
        if (!this.field_71445_n && this.field_71441_e != null) {
            this.field_71442_b.func_78765_e();
        }
        this.field_71424_I.func_219895_b("textures");
        if (this.field_71441_e != null) {
            this.field_71446_o.func_110550_d();
        }
        if (this.field_71462_r == null && this.field_71439_g != null) {
            if (this.field_71439_g.func_233643_dh_() && !(this.field_71462_r instanceof DeathScreen)) {
                this.func_147108_a(null);
            } else if (this.field_71439_g.func_70608_bn() && this.field_71441_e != null) {
                this.func_147108_a(new SleepInMultiplayerScreen());
            }
        } else if (this.field_71462_r != null && this.field_71462_r instanceof SleepInMultiplayerScreen && !this.field_71439_g.func_70608_bn()) {
            this.func_147108_a(null);
        }
        if (this.field_71462_r != null) {
            this.field_71429_W = 10000;
        }
        if (this.field_71462_r != null) {
            Screen.func_231153_a_(() -> this.field_71462_r.func_231023_e_(), "Ticking screen", this.field_71462_r.getClass().getCanonicalName());
        }
        if (!this.field_71474_y.field_74330_P) {
            this.field_71456_v.func_212910_m();
        }
        if (this.field_213279_p == null && (this.field_71462_r == null || this.field_71462_r.field_230711_n_)) {
            this.field_71424_I.func_219895_b("Keybindings");
            this.func_184117_aA();
            if (this.field_71429_W > 0) {
                --this.field_71429_W;
            }
        }
        if (this.field_71441_e != null) {
            this.field_71424_I.func_219895_b("gameRenderer");
            if (!this.field_71445_n) {
                this.field_71460_t.func_78464_a();
            }
            this.field_71424_I.func_219895_b("levelRenderer");
            if (!this.field_71445_n) {
                this.field_71438_f.func_72734_e();
            }
            this.field_71424_I.func_219895_b("level");
            if (!this.field_71445_n) {
                if (this.field_71441_e.func_228332_n_() > 0) {
                    this.field_71441_e.func_225605_c_(this.field_71441_e.func_228332_n_() - 1);
                }
                this.field_71441_e.func_217419_d();
            }
        } else if (this.field_71460_t.func_147706_e() != null) {
            this.field_71460_t.func_181022_b();
        }
        if (!this.field_71445_n) {
            this.field_147126_aw.func_73660_a();
        }
        this.field_147127_av.func_215290_a(this.field_71445_n);
        if (this.field_71441_e != null) {
            if (!this.field_71445_n) {
                this.field_193035_aW.func_193303_d();
                try {
                    this.field_71441_e.func_72835_b(() -> true);
                }
                catch (Throwable throwable) {
                    CrashReport crashReport = CrashReport.func_85055_a(throwable, "Exception in world tick");
                    if (this.field_71441_e == null) {
                        CrashReportCategory crashReportCategory = crashReport.func_85058_a("Affected level");
                        crashReportCategory.func_71507_a("Problem", "Level is null!");
                    } else {
                        this.field_71441_e.func_72914_a(crashReport);
                    }
                    throw new ReportedException(crashReport);
                }
            }
            this.field_71424_I.func_219895_b("animateTick");
            if (!this.field_71445_n && this.field_71441_e != null) {
                this.field_71441_e.func_73029_E(MathHelper.func_76128_c(this.field_71439_g.func_226277_ct_()), MathHelper.func_76128_c(this.field_71439_g.func_226278_cu_()), MathHelper.func_76128_c(this.field_71439_g.func_226281_cx_()));
            }
            this.field_71424_I.func_219895_b("particles");
            if (!this.field_71445_n) {
                this.field_71452_i.func_78868_a();
            }
        } else if (this.field_71453_ak != null) {
            this.field_71424_I.func_219895_b("pendingConnection");
            this.field_71453_ak.func_74428_b();
        }
        this.field_71424_I.func_219895_b("keyboard");
        this.field_195559_v.func_204870_b();
        this.field_71424_I.func_76319_b();
    }

    private void func_184117_aA() {
        int n;
        while (this.field_71474_y.field_151457_aa.func_151468_f()) {
            ++this.field_71474_y.field_74320_O;
            if (this.field_71474_y.field_74320_O > 2) {
                this.field_71474_y.field_74320_O = 0;
            }
            if (this.field_71474_y.field_74320_O == 0) {
                this.field_71460_t.func_175066_a(this.func_175606_aa());
            } else if (this.field_71474_y.field_74320_O == 1) {
                this.field_71460_t.func_175066_a(null);
            }
            this.field_71438_f.func_174979_m();
        }
        while (this.field_71474_y.field_151458_ab.func_151468_f()) {
            this.field_71474_y.field_74326_T = !this.field_71474_y.field_74326_T;
        }
        for (n = 0; n < 9; ++n) {
            boolean bl = this.field_71474_y.field_193629_ap.func_151470_d();
            \u2603 = this.field_71474_y.field_193630_aq.func_151470_d();
            if (!this.field_71474_y.field_151456_ac[n].func_151468_f()) continue;
            if (this.field_71439_g.func_175149_v()) {
                this.field_71456_v.func_175187_g().func_175260_a(n);
                continue;
            }
            if (this.field_71439_g.func_184812_l_() && this.field_71462_r == null && (\u2603 || bl)) {
                CreativeScreen.func_192044_a(this, n, \u2603, bl);
                continue;
            }
            this.field_71439_g.field_71071_by.field_70461_c = n;
        }
        while (this.field_71474_y.field_151445_Q.func_151468_f()) {
            if (this.field_71442_b.func_110738_j()) {
                this.field_71439_g.func_175163_u();
                continue;
            }
            this.field_193035_aW.func_193296_a();
            this.func_147108_a(new InventoryScreen(this.field_71439_g));
        }
        while (this.field_71474_y.field_194146_ao.func_151468_f()) {
            this.func_147108_a(new AdvancementsScreen(this.field_71439_g.field_71174_a.func_191982_f()));
        }
        while (this.field_71474_y.field_186718_X.func_151468_f()) {
            if (this.field_71439_g.func_175149_v()) continue;
            this.func_147114_u().func_147297_a(new CPlayerDiggingPacket(CPlayerDiggingPacket.Action.SWAP_ITEM_WITH_OFFHAND, BlockPos.field_177992_a, Direction.DOWN));
        }
        while (this.field_71474_y.field_74316_C.func_151468_f()) {
            if (this.field_71439_g.func_175149_v() || !this.field_71439_g.func_225609_n_(Screen.func_231172_r_())) continue;
            this.field_71439_g.func_184609_a(Hand.MAIN_HAND);
        }
        int n2 = n = this.field_71474_y.field_74343_n != ChatVisibility.HIDDEN ? 1 : 0;
        if (n != 0) {
            while (this.field_71474_y.field_74310_D.func_151468_f()) {
                this.func_238207_b_("");
            }
            if (this.field_71462_r == null && this.field_213279_p == null && this.field_71474_y.field_74323_J.func_151468_f()) {
                this.func_238207_b_("/");
            }
        }
        if (this.field_71439_g.func_184587_cr()) {
            if (!this.field_71474_y.field_74313_G.func_151470_d()) {
                this.field_71442_b.func_78766_c(this.field_71439_g);
            }
            while (this.field_71474_y.field_74312_F.func_151468_f()) {
            }
            while (this.field_71474_y.field_74313_G.func_151468_f()) {
            }
            while (this.field_71474_y.field_74322_I.func_151468_f()) {
            }
        } else {
            while (this.field_71474_y.field_74312_F.func_151468_f()) {
                this.func_147116_af();
            }
            while (this.field_71474_y.field_74313_G.func_151468_f()) {
                this.func_147121_ag();
            }
            while (this.field_71474_y.field_74322_I.func_151468_f()) {
                this.func_147112_ai();
            }
        }
        if (this.field_71474_y.field_74313_G.func_151470_d() && this.field_71467_ac == 0 && !this.field_71439_g.func_184587_cr()) {
            this.func_147121_ag();
        }
        this.func_147115_a(this.field_71462_r == null && this.field_71474_y.field_74312_F.func_151470_d() && this.field_71417_B.func_198035_h());
    }

    public static DatapackCodec func_238180_a_(SaveFormat.LevelSave levelSave) {
        MinecraftServer.func_240777_a_(levelSave);
        DatapackCodec datapackCodec = levelSave.func_237297_e_();
        if (datapackCodec == null) {
            throw new IllegalStateException("Failed to load data pack config");
        }
        return datapackCodec;
    }

    public static IServerConfiguration func_238181_a_(SaveFormat.LevelSave levelSave, IDynamicRegistries.Impl impl, IResourceManager iResourceManager, DatapackCodec datapackCodec) {
        WorldSettingsImport<INBT> worldSettingsImport = WorldSettingsImport.func_240876_a_(NBTDynamicOps.field_210820_a, iResourceManager, impl);
        IServerConfiguration \u26032 = levelSave.func_237284_a_(worldSettingsImport, datapackCodec);
        if (\u26032 == null) {
            throw new IllegalStateException("Failed to load world");
        }
        return \u26032;
    }

    public void func_238191_a_(String string) {
        this.func_238195_a_(string, IDynamicRegistries.func_239770_b_(), Minecraft::func_238180_a_, (Function4<SaveFormat.LevelSave, IDynamicRegistries.Impl, IResourceManager, DatapackCodec, IServerConfiguration>)((Function4)Minecraft::func_238181_a_), false, WorldSelectionType.BACKUP);
    }

    public void func_238192_a_(String string, WorldSettings worldSettings, IDynamicRegistries.Impl impl, DimensionGeneratorSettings dimensionGeneratorSettings) {
        this.func_238195_a_(string, impl, levelSave -> worldSettings.func_234958_g_(), (Function4<SaveFormat.LevelSave, IDynamicRegistries.Impl, IResourceManager, DatapackCodec, IServerConfiguration>)((Function4)(levelSave, impl2, iResourceManager, datapackCodec) -> {
            WorldSettingsImport worldSettingsImport = WorldSettingsImport.func_240876_a_(JsonOps.INSTANCE, iResourceManager, impl);
            DataResult<SimpleRegistry<Dimension>> \u26032 = worldSettingsImport.func_241797_a_(dimensionGeneratorSettings.func_236224_e_(), Registry.field_239700_af_, Dimension.field_236052_a_);
            SimpleRegistry<Dimension> \u26033 = \u26032.resultOrPartial(arg_0 -> ((Logger)field_147123_G).error(arg_0)).orElse(dimensionGeneratorSettings.func_236224_e_());
            return new ServerWorldInfo(worldSettings, dimensionGeneratorSettings.func_236215_a_(\u26033), \u26032.lifecycle());
        }), false, WorldSelectionType.CREATE);
    }

    private void func_238195_a_(String string, IDynamicRegistries.Impl impl, Function<SaveFormat.LevelSave, DatapackCodec> function, Function4<SaveFormat.LevelSave, IDynamicRegistries.Impl, IResourceManager, DatapackCodec, IServerConfiguration> function4, boolean bl, WorldSelectionType worldSelectionType) {
        Object \u26036;
        Object \u26035;
        Object \u26034;
        PackManager packManager;
        SaveFormat.LevelSave levelSave;
        try {
            levelSave = this.field_71469_aa.func_237274_c_(string);
        }
        catch (IOException iOException) {
            field_147123_G.warn("Failed to read level {} data", (Object)string, (Object)iOException);
            SystemToast.func_238535_a_(this, string);
            this.func_147108_a(null);
            return;
        }
        try {
            packManager = this.func_238189_a_(impl, function, function4, bl, levelSave);
        }
        catch (Exception exception) {
            field_147123_G.warn("Failed to load datapacks, can't proceed with server load", (Throwable)exception);
            this.func_147108_a(new DatapackFailureScreen(() -> this.func_238195_a_(string, impl, function, function4, true, worldSelectionType)));
            try {
                levelSave.close();
            }
            catch (IOException iOException) {
                field_147123_G.warn("Failed to unlock access to level {}", (Object)string, (Object)iOException);
            }
            return;
        }
        IServerConfiguration \u26032 = packManager.func_238226_c_();
        boolean \u26033 = \u26032.func_230418_z_().func_236229_j_();
        boolean bl2 = \u2603 = \u26032.func_230401_A_() != Lifecycle.stable();
        if (worldSelectionType != WorldSelectionType.NONE && (\u26033 || \u2603)) {
            this.func_241559_a_(worldSelectionType, string, \u26033, () -> this.func_238195_a_(string, impl, function, function4, bl, WorldSelectionType.NONE));
            packManager.close();
            try {
                levelSave.close();
            }
            catch (IOException iOException) {
                field_147123_G.warn("Failed to unlock access to level {}", (Object)string, (Object)iOException);
            }
            return;
        }
        this.func_213254_o();
        this.field_213277_ad.set(null);
        try {
            levelSave.func_237287_a_(impl, \u26032);
            packManager.func_238225_b_().func_240971_i_();
            \u26034 = new YggdrasilAuthenticationService(this.field_110453_aa, UUID.randomUUID().toString());
            \u26035 = \u26034.createMinecraftSessionService();
            \u26036 = \u26034.createProfileRepository();
            PlayerProfileCache \u26037 = new PlayerProfileCache((GameProfileRepository)\u26036, new File(this.field_71412_D, MinecraftServer.field_152367_a.getName()));
            SkullTileEntity.func_184293_a(\u26037);
            SkullTileEntity.func_184294_a((MinecraftSessionService)\u26035);
            PlayerProfileCache.func_187320_a(false);
            this.field_71437_Z = MinecraftServer.func_240784_a_(arg_0 -> this.func_238188_a_(impl, levelSave, packManager, \u26032, (MinecraftSessionService)\u26035, (GameProfileRepository)\u26036, \u26037, arg_0));
            this.field_71455_al = true;
        }
        catch (Throwable throwable) {
            CrashReport \u26039 = CrashReport.func_85055_a(throwable, "Starting integrated server");
            CrashReportCategory \u26038 = \u26039.func_85058_a("Starting integrated server");
            \u26038.func_71507_a("Level ID", string);
            \u26038.func_71507_a("Level Name", \u26032.func_76065_j());
            throw new ReportedException(\u26039);
        }
        while (this.field_213277_ad.get() == null) {
            Thread.yield();
        }
        \u26034 = new WorldLoadProgressScreen(this.field_213277_ad.get());
        this.func_147108_a((Screen)\u26034);
        this.field_71424_I.func_76320_a("waitForServer");
        while (!this.field_71437_Z.func_71200_ad()) {
            ((Screen)\u26034).func_231023_e_();
            this.func_195542_b(false);
            try {
                Thread.sleep(16L);
            }
            catch (InterruptedException \u26039) {
                // empty catch block
            }
            if (this.field_71433_S == null) continue;
            Minecraft.func_71377_b(this.field_71433_S);
            return;
        }
        this.field_71424_I.func_76319_b();
        \u26035 = this.field_71437_Z.func_147137_ag().func_151270_a();
        \u26036 = NetworkManager.func_150722_a((SocketAddress)\u26035);
        ((NetworkManager)((Object)\u26036)).func_150719_a(new ClientLoginNetHandler((NetworkManager)((Object)\u26036), this, null, iTextComponent -> {}));
        ((NetworkManager)((Object)\u26036)).func_179290_a(new CHandshakePacket(\u26035.toString(), 0, ProtocolType.LOGIN));
        ((NetworkManager)((Object)\u26036)).func_179290_a(new CLoginStartPacket(this.func_110432_I().func_148256_e()));
        this.field_71453_ak = \u26036;
    }

    private void func_241559_a_(WorldSelectionType worldSelectionType, String string2, boolean bl3, Runnable runnable2) {
        if (worldSelectionType == WorldSelectionType.BACKUP) {
            String string2;
            TranslationTextComponent translationTextComponent;
            if (bl3) {
                translationTextComponent = new TranslationTextComponent("selectWorld.backupQuestion.customized");
                \u2603 = new TranslationTextComponent("selectWorld.backupWarning.customized");
            } else {
                translationTextComponent = new TranslationTextComponent("selectWorld.backupQuestion.experimental");
                \u2603 = new TranslationTextComponent("selectWorld.backupWarning.experimental");
            }
            this.func_147108_a(new ConfirmBackupScreen(null, (bl, bl2) -> {
                if (bl) {
                    EditWorldScreen.func_241651_a_(this.field_71469_aa, string2);
                }
                runnable2.run();
            }, translationTextComponent, \u2603, false));
        } else {
            Runnable runnable2;
            this.func_147108_a(new ConfirmScreen(bl -> {
                if (bl) {
                    runnable2.run();
                } else {
                    this.func_147108_a(null);
                    try (SaveFormat.LevelSave levelSave = this.field_71469_aa.func_237274_c_(string2);){
                        levelSave.func_237299_g_();
                    }
                    catch (IOException iOException) {
                        SystemToast.func_238538_b_(this, string2);
                        field_147123_G.error("Failed to delete world {}", (Object)string2, (Object)iOException);
                    }
                }
            }, new TranslationTextComponent("selectWorld.backupQuestion.experimental"), new TranslationTextComponent("selectWorld.backupWarning.experimental"), DialogTexts.field_240636_g_, DialogTexts.field_240633_d_));
        }
    }

    public PackManager func_238189_a_(IDynamicRegistries.Impl impl, Function<SaveFormat.LevelSave, DatapackCodec> function, Function4<SaveFormat.LevelSave, IDynamicRegistries.Impl, IResourceManager, DatapackCodec, IServerConfiguration> function4, boolean bl, SaveFormat.LevelSave levelSave) throws InterruptedException, ExecutionException {
        DatapackCodec datapackCodec = function.apply(levelSave);
        ResourcePackList<ResourcePackInfo> \u26032 = new ResourcePackList<ResourcePackInfo>(ResourcePackInfo::new, new ServerPackFinder(), new FolderPackFinder(levelSave.func_237285_a_(FolderName.field_237251_g_).toFile(), IPackNameDecorator.field_232627_c_));
        try {
            \u2603 = MinecraftServer.func_240772_a_(\u26032, datapackCodec, bl);
            CompletableFuture<DataPackRegistries> completableFuture = DataPackRegistries.func_240961_a_(\u26032.func_232623_f_(), Commands.EnvironmentType.INTEGRATED, 2, Util.func_215072_e(), this);
            this.func_213161_c(completableFuture::isDone);
            DataPackRegistries \u26033 = completableFuture.get();
            IServerConfiguration \u26034 = (IServerConfiguration)function4.apply((Object)levelSave, (Object)impl, (Object)\u26033.func_240970_h_(), (Object)\u2603);
            return new PackManager(\u26032, \u26033, \u26034);
        }
        catch (InterruptedException | ExecutionException exception) {
            \u26032.close();
            throw exception;
        }
    }

    public void func_71403_a(ClientWorld clientWorld) {
        WorkingScreen workingScreen = new WorkingScreen();
        workingScreen.func_200210_a(new TranslationTextComponent("connect.joining"));
        this.func_213241_c(workingScreen);
        this.field_71441_e = clientWorld;
        this.func_213257_b(clientWorld);
        if (!this.field_71455_al) {
            YggdrasilAuthenticationService yggdrasilAuthenticationService = new YggdrasilAuthenticationService(this.field_110453_aa, UUID.randomUUID().toString());
            MinecraftSessionService \u26032 = yggdrasilAuthenticationService.createMinecraftSessionService();
            GameProfileRepository \u26033 = yggdrasilAuthenticationService.createProfileRepository();
            PlayerProfileCache \u26034 = new PlayerProfileCache(\u26033, new File(this.field_71412_D, MinecraftServer.field_152367_a.getName()));
            SkullTileEntity.func_184293_a(\u26034);
            SkullTileEntity.func_184294_a(\u26032);
            PlayerProfileCache.func_187320_a(false);
        }
    }

    public void func_213254_o() {
        this.func_213231_b(new WorkingScreen());
    }

    public void func_213231_b(Screen screen) {
        ClientPlayNetHandler clientPlayNetHandler = this.func_147114_u();
        if (clientPlayNetHandler != null) {
            this.func_213159_be();
            clientPlayNetHandler.func_147296_c();
        }
        IntegratedServer \u26032 = this.field_71437_Z;
        this.field_71437_Z = null;
        this.field_71460_t.func_190564_k();
        this.field_71442_b = null;
        NarratorChatListener.field_193643_a.func_193642_b();
        this.func_213241_c(screen);
        if (this.field_71441_e != null) {
            if (\u26032 != null) {
                this.field_71424_I.func_76320_a("waitForServer");
                while (!\u26032.func_213201_w()) {
                    this.func_195542_b(false);
                }
                this.field_71424_I.func_76319_b();
            }
            this.field_195554_ax.func_195749_c();
            this.field_71456_v.func_181029_i();
            this.field_71422_O = null;
            this.field_71455_al = false;
            this.field_213274_aO.func_216815_b();
        }
        this.field_71441_e = null;
        this.func_213257_b(null);
        this.field_71439_g = null;
    }

    private void func_213241_c(Screen screen) {
        this.field_71424_I.func_76320_a("forcedTick");
        this.field_147127_av.func_147690_c();
        this.field_175622_Z = null;
        this.field_71453_ak = null;
        this.func_147108_a(screen);
        this.func_195542_b(false);
        this.field_71424_I.func_76319_b();
    }

    public void func_241562_c_(Screen screen) {
        this.field_71424_I.func_76320_a("forcedTick");
        this.func_147108_a(screen);
        this.func_195542_b(false);
        this.field_71424_I.func_76319_b();
    }

    private void func_213257_b(@Nullable ClientWorld clientWorld) {
        this.field_71438_f.func_72732_a(clientWorld);
        this.field_71452_i.func_78870_a(clientWorld);
        TileEntityRendererDispatcher.field_147556_a.func_147543_a(clientWorld);
        this.func_230150_b_();
    }

    public boolean func_238216_r_() {
        return this.field_238175_ae_;
    }

    public boolean func_238198_a_(UUID uUID) {
        if (!this.func_238217_s_()) {
            return (this.field_71439_g == null || !uUID.equals(this.field_71439_g.func_110124_au())) && !uUID.equals(Util.field_240973_b_);
        }
        return false;
    }

    public boolean func_238217_s_() {
        return this.field_238176_af_;
    }

    public final boolean func_71355_q() {
        return this.field_71459_aj;
    }

    @Nullable
    public ClientPlayNetHandler func_147114_u() {
        return this.field_71439_g == null ? null : this.field_71439_g.field_71174_a;
    }

    public static boolean func_71382_s() {
        return !Minecraft.field_71432_P.field_71474_y.field_74319_N;
    }

    public static boolean func_71375_t() {
        return Minecraft.field_71432_P.field_71474_y.field_238330_f_.func_238162_a_() >= GraphicsFanciness.FANCY.func_238162_a_();
    }

    public static boolean func_238218_y_() {
        return Minecraft.field_71432_P.field_71474_y.field_238330_f_.func_238162_a_() >= GraphicsFanciness.FABULOUS.func_238162_a_();
    }

    public static boolean func_71379_u() {
        return Minecraft.field_71432_P.field_71474_y.field_74348_k != AmbientOcclusionStatus.OFF;
    }

    private void func_147112_ai() {
        ItemStack \u26035;
        Object object;
        if (this.field_71476_x == null || this.field_71476_x.func_216346_c() == RayTraceResult.Type.MISS) {
            return;
        }
        boolean bl = this.field_71439_g.field_71075_bZ.field_75098_d;
        TileEntity \u26032 = null;
        RayTraceResult.Type \u26033 = this.field_71476_x.func_216346_c();
        if (\u26033 == RayTraceResult.Type.BLOCK) {
            object = ((BlockRayTraceResult)this.field_71476_x).func_216350_a();
            \u2603 = this.field_71441_e.func_180495_p((BlockPos)object);
            Block \u26034 = ((AbstractBlock.AbstractBlockState)\u2603).func_177230_c();
            if (((AbstractBlock.AbstractBlockState)\u2603).func_196958_f()) {
                return;
            }
            \u26035 = \u26034.func_185473_a(this.field_71441_e, (BlockPos)object, (BlockState)\u2603);
            if (\u26035.func_190926_b()) {
                return;
            }
            if (bl && Screen.func_231172_r_() && \u26034.func_235695_q_()) {
                \u26032 = this.field_71441_e.func_175625_s((BlockPos)object);
            }
        } else if (\u26033 == RayTraceResult.Type.ENTITY && bl) {
            object = ((EntityRayTraceResult)this.field_71476_x).func_216348_a();
            if (object instanceof PaintingEntity) {
                \u26035 = new ItemStack(Items.field_151159_an);
            } else if (object instanceof LeashKnotEntity) {
                \u26035 = new ItemStack(Items.field_151058_ca);
            } else if (object instanceof ItemFrameEntity) {
                \u2603 = (ItemFrameEntity)object;
                ItemStack itemStack = ((ItemFrameEntity)\u2603).func_82335_i();
                \u26035 = itemStack.func_190926_b() ? new ItemStack(Items.field_151160_bD) : itemStack.func_77946_l();
            } else if (object instanceof AbstractMinecartEntity) {
                Item item;
                \u2603 = (AbstractMinecartEntity)object;
                switch (((AbstractMinecartEntity)\u2603).func_184264_v()) {
                    case FURNACE: {
                        item = Items.field_151109_aJ;
                        break;
                    }
                    case CHEST: {
                        item = Items.field_151108_aI;
                        break;
                    }
                    case TNT: {
                        item = Items.field_151142_bV;
                        break;
                    }
                    case HOPPER: {
                        item = Items.field_151140_bW;
                        break;
                    }
                    case COMMAND_BLOCK: {
                        item = Items.field_151095_cc;
                        break;
                    }
                    default: {
                        item = Items.field_151143_au;
                    }
                }
                \u26035 = new ItemStack(item);
            } else if (object instanceof BoatEntity) {
                \u26035 = new ItemStack(((BoatEntity)object).func_184455_j());
            } else if (object instanceof ArmorStandEntity) {
                \u26035 = new ItemStack(Items.field_179565_cj);
            } else if (object instanceof EnderCrystalEntity) {
                \u26035 = new ItemStack(Items.field_185158_cP);
            } else {
                \u2603 = SpawnEggItem.func_200889_b(((Entity)object).func_200600_R());
                if (\u2603 == null) {
                    return;
                }
                \u26035 = new ItemStack((IItemProvider)\u2603);
            }
        } else {
            return;
        }
        if (\u26035.func_190926_b()) {
            object = "";
            if (\u26033 == RayTraceResult.Type.BLOCK) {
                object = Registry.field_212618_g.func_177774_c(this.field_71441_e.func_180495_p(((BlockRayTraceResult)this.field_71476_x).func_216350_a()).func_177230_c()).toString();
            } else if (\u26033 == RayTraceResult.Type.ENTITY) {
                object = Registry.field_212629_r.func_177774_c(((EntityRayTraceResult)this.field_71476_x).func_216348_a().func_200600_R()).toString();
            }
            field_147123_G.warn("Picking on: [{}] {} gave null item", (Object)\u26033, object);
            return;
        }
        object = this.field_71439_g.field_71071_by;
        if (\u26032 != null) {
            this.func_184119_a(\u26035, \u26032);
        }
        int \u26036 = ((PlayerInventory)object).func_184429_b(\u26035);
        if (bl) {
            ((PlayerInventory)object).func_184434_a(\u26035);
            this.field_71442_b.func_78761_a(this.field_71439_g.func_184586_b(Hand.MAIN_HAND), 36 + ((PlayerInventory)object).field_70461_c);
        } else if (\u26036 != -1) {
            if (PlayerInventory.func_184435_e(\u26036)) {
                ((PlayerInventory)object).field_70461_c = \u26036;
            } else {
                this.field_71442_b.func_187100_a(\u26036);
            }
        }
    }

    private ItemStack func_184119_a(ItemStack itemStack, TileEntity tileEntity) {
        CompoundNBT compoundNBT = tileEntity.func_189515_b(new CompoundNBT());
        if (itemStack.func_77973_b() instanceof SkullItem && compoundNBT.func_74764_b("SkullOwner")) {
            \u2603 = compoundNBT.func_74775_l("SkullOwner");
            itemStack.func_196082_o().func_218657_a("SkullOwner", \u2603);
            return itemStack;
        }
        itemStack.func_77983_a("BlockEntityTag", compoundNBT);
        \u2603 = new CompoundNBT();
        ListNBT \u26032 = new ListNBT();
        \u26032.add(StringNBT.func_229705_a_("\"(+NBT)\""));
        \u2603.func_218657_a("Lore", \u26032);
        itemStack.func_77983_a("display", \u2603);
        return itemStack;
    }

    public CrashReport func_71396_d(CrashReport crashReport) {
        Minecraft.func_228009_a_(this.field_135017_as, this.field_110447_Z, this.field_71474_y, crashReport);
        if (this.field_71441_e != null) {
            this.field_71441_e.func_72914_a(crashReport);
        }
        return crashReport;
    }

    public static void func_228009_a_(@Nullable LanguageManager languageManager, String string, @Nullable GameSettings gameSettings, CrashReport crashReport) {
        CrashReportCategory crashReportCategory = crashReport.func_85056_g();
        crashReportCategory.func_189529_a("Launched Version", () -> string);
        crashReportCategory.func_189529_a("Backend library", RenderSystem::getBackendDescription);
        crashReportCategory.func_189529_a("Backend API", RenderSystem::getApiDescription);
        crashReportCategory.func_189529_a("GL Caps", RenderSystem::getCapsString);
        crashReportCategory.func_189529_a("Using VBOs", () -> "Yes");
        crashReportCategory.func_189529_a("Is Modded", () -> {
            String string = ClientBrandRetriever.getClientModName();
            if (!"vanilla".equals(string)) {
                return "Definitely; Client brand changed to '" + string + "'";
            }
            if (Minecraft.class.getSigners() == null) {
                return "Very likely; Jar signature invalidated";
            }
            return "Probably not. Jar signature remains and client brand is untouched.";
        });
        crashReportCategory.func_71507_a("Type", "Client (map_client.txt)");
        if (gameSettings != null) {
            crashReportCategory.func_189529_a("Resource Packs", () -> {
                StringBuilder stringBuilder = new StringBuilder();
                for (String string : gameSettings.field_151453_l) {
                    if (stringBuilder.length() > 0) {
                        stringBuilder.append(", ");
                    }
                    stringBuilder.append(string);
                    if (!gameSettings.field_183018_l.contains(string)) continue;
                    stringBuilder.append(" (incompatible)");
                }
                return stringBuilder.toString();
            });
        }
        if (languageManager != null) {
            crashReportCategory.func_189529_a("Current Language", () -> languageManager.func_135041_c().toString());
        }
        crashReportCategory.func_189529_a("CPU", PlatformDescriptors::func_227775_b_);
    }

    public static Minecraft func_71410_x() {
        return field_71432_P;
    }

    public CompletableFuture<Void> func_213245_w() {
        return this.func_213169_a(this::func_213237_g).thenCompose(completableFuture -> completableFuture);
    }

    @Override
    public void func_70000_a(Snooper snooper2) {
        Snooper snooper2;
        snooper2.func_152768_a("fps", field_71470_ab);
        snooper2.func_152768_a("vsync_enabled", this.field_71474_y.field_74352_v);
        snooper2.func_152768_a("display_frequency", this.field_195558_d.func_227798_a_());
        snooper2.func_152768_a("display_type", this.field_195558_d.func_198113_j() ? "fullscreen" : "windowed");
        snooper2.func_152768_a("run_time", (Util.func_211177_b() - snooper2.func_130105_g()) / 60L * 1000L);
        snooper2.func_152768_a("current_action", this.func_181538_aA());
        snooper2.func_152768_a("language", this.field_71474_y.field_74363_ab == null ? "en_us" : this.field_71474_y.field_74363_ab);
        String string = ByteOrder.nativeOrder() == ByteOrder.LITTLE_ENDIAN ? "little" : "big";
        snooper2.func_152768_a("endianness", string);
        snooper2.func_152768_a("subtitles", this.field_71474_y.field_186717_N);
        snooper2.func_152768_a("touch", this.field_71474_y.field_85185_A ? "touch" : "mouse");
        int \u26032 = 0;
        for (ClientResourcePackInfo clientResourcePackInfo : this.field_110448_aq.func_198980_d()) {
            if (clientResourcePackInfo.func_195797_g() || clientResourcePackInfo.func_195798_h()) continue;
            snooper2.func_152768_a("resource_pack[" + \u26032++ + "]", clientResourcePackInfo.func_195790_f());
        }
        snooper2.func_152768_a("resource_packs", \u26032);
        if (this.field_71437_Z != null) {
            snooper2.func_152768_a("snooper_partner", this.field_71437_Z.func_80003_ah().func_80006_f());
        }
    }

    private String func_181538_aA() {
        if (this.field_71437_Z != null) {
            if (this.field_71437_Z.func_71344_c()) {
                return "hosting_lan";
            }
            return "singleplayer";
        }
        if (this.field_71422_O != null) {
            if (this.field_71422_O.func_181041_d()) {
                return "playing_lan";
            }
            return "multiplayer";
        }
        return "out_of_game";
    }

    public void func_71351_a(@Nullable ServerData serverData) {
        this.field_71422_O = serverData;
    }

    @Nullable
    public ServerData func_147104_D() {
        return this.field_71422_O;
    }

    public boolean func_71387_A() {
        return this.field_71455_al;
    }

    public boolean func_71356_B() {
        return this.field_71455_al && this.field_71437_Z != null;
    }

    @Nullable
    public IntegratedServer func_71401_C() {
        return this.field_71437_Z;
    }

    public Snooper func_71378_E() {
        return this.field_71427_U;
    }

    public Session func_110432_I() {
        return this.field_71449_j;
    }

    public PropertyMap func_181037_M() {
        if (this.field_181038_N.isEmpty()) {
            GameProfile gameProfile = this.func_152347_ac().fillProfileProperties(this.field_71449_j.func_148256_e(), false);
            this.field_181038_N.putAll((Multimap)gameProfile.getProperties());
        }
        return this.field_181038_N;
    }

    public Proxy func_110437_J() {
        return this.field_110453_aa;
    }

    public TextureManager func_110434_K() {
        return this.field_71446_o;
    }

    public IResourceManager func_195551_G() {
        return this.field_110451_am;
    }

    public ResourcePackList<ClientResourcePackInfo> func_195548_H() {
        return this.field_110448_aq;
    }

    public DownloadingPackFinder func_195541_I() {
        return this.field_195554_ax;
    }

    public File func_195549_J() {
        return this.field_130070_K;
    }

    public LanguageManager func_135016_M() {
        return this.field_135017_as;
    }

    public Function<ResourceLocation, TextureAtlasSprite> func_228015_a_(ResourceLocation resourceLocation) {
        return this.field_175617_aL.func_229356_a_(resourceLocation)::func_195424_a;
    }

    public boolean func_147111_S() {
        return this.field_147129_ai;
    }

    public boolean func_147113_T() {
        return this.field_71445_n;
    }

    public GPUWarning func_241558_U_() {
        return this.field_241557_ar_;
    }

    public SoundHandler func_147118_V() {
        return this.field_147127_av;
    }

    public BackgroundMusicSelector func_238178_U_() {
        if (this.field_71462_r instanceof WinGameScreen) {
            return BackgroundMusicTracks.field_232672_c_;
        }
        if (this.field_71439_g != null) {
            if (this.field_71439_g.field_70170_p.func_234923_W_() == World.field_234920_i_) {
                if (this.field_71456_v.func_184046_j().func_184054_d()) {
                    return BackgroundMusicTracks.field_232673_d_;
                }
                return BackgroundMusicTracks.field_232674_e_;
            }
            Biome.Category category = this.field_71439_g.field_70170_p.func_226691_t_(this.field_71439_g.func_233580_cy_()).func_201856_r();
            if (this.field_147126_aw.func_239540_b_(BackgroundMusicTracks.field_232675_f_) || this.field_71439_g.func_204231_K() && (category == Biome.Category.OCEAN || category == Biome.Category.RIVER)) {
                return BackgroundMusicTracks.field_232675_f_;
            }
            if (this.field_71439_g.field_70170_p.func_234923_W_() != World.field_234919_h_ && this.field_71439_g.field_71075_bZ.field_75098_d && this.field_71439_g.field_71075_bZ.field_75101_c) {
                return BackgroundMusicTracks.field_232671_b_;
            }
            return this.field_71441_e.func_225523_d_().func_235201_b_(this.field_71439_g.func_233580_cy_()).func_235094_x_().orElse(BackgroundMusicTracks.field_232676_g_);
        }
        return BackgroundMusicTracks.field_232670_a_;
    }

    public MinecraftSessionService func_152347_ac() {
        return this.field_152355_az;
    }

    public SkinManager func_152342_ad() {
        return this.field_152350_aA;
    }

    @Nullable
    public Entity func_175606_aa() {
        return this.field_175622_Z;
    }

    public void func_175607_a(Entity entity) {
        this.field_175622_Z = entity;
        this.field_71460_t.func_175066_a(entity);
    }

    public boolean func_238206_b_(Entity entity) {
        return entity.func_225510_bt_() || this.field_71439_g != null && this.field_71439_g.func_175149_v() && this.field_71474_y.field_178883_an.func_151470_d() && entity.func_200600_R() == EntityType.field_200729_aH;
    }

    @Override
    protected Thread func_213170_ax() {
        return this.field_152352_aC;
    }

    @Override
    protected Runnable func_212875_d_(Runnable runnable) {
        return runnable;
    }

    @Override
    protected boolean func_212874_c_(Runnable runnable) {
        return true;
    }

    public BlockRendererDispatcher func_175602_ab() {
        return this.field_175618_aM;
    }

    public EntityRendererManager func_175598_ae() {
        return this.field_175616_W;
    }

    public ItemRenderer func_175599_af() {
        return this.field_175621_X;
    }

    public FirstPersonRenderer func_175597_ag() {
        return this.field_175620_Y;
    }

    public <T> IMutableSearchTree<T> func_213253_a(SearchTreeManager.Key<T> key) {
        return this.field_193995_ae.func_215358_a(key);
    }

    public FrameTimer func_181539_aj() {
        return this.field_181542_y;
    }

    public boolean func_181540_al() {
        return this.field_181541_X;
    }

    public void func_181537_a(boolean bl) {
        this.field_181541_X = bl;
    }

    public DataFixer func_184126_aj() {
        return this.field_184131_U;
    }

    public float func_184121_ak() {
        return this.field_71428_T.field_194147_b;
    }

    public float func_193989_ak() {
        return this.field_71428_T.field_194148_c;
    }

    public BlockColors func_184125_al() {
        return this.field_184127_aH;
    }

    public boolean func_189648_am() {
        return this.field_71439_g != null && this.field_71439_g.func_175140_cp() || this.field_71474_y.field_178879_v;
    }

    public ToastGui func_193033_an() {
        return this.field_193034_aS;
    }

    public Tutorial func_193032_ao() {
        return this.field_193035_aW;
    }

    public boolean func_195544_aj() {
        return this.field_195555_I;
    }

    public CreativeSettings func_199403_al() {
        return this.field_191950_u;
    }

    public ModelManager func_209506_al() {
        return this.field_175617_aL;
    }

    public PaintingSpriteUploader func_213263_ao() {
        return this.field_213272_aL;
    }

    public PotionSpriteUploader func_213248_ap() {
        return this.field_213273_aM;
    }

    @Override
    public void func_213228_a(boolean bl) {
        this.field_195555_I = bl;
    }

    public IProfiler func_213239_aq() {
        return this.field_71424_I;
    }

    public MinecraftGame func_213229_ar() {
        return this.field_213274_aO;
    }

    public Splashes func_213269_at() {
        return this.field_213271_aF;
    }

    @Nullable
    public LoadingGui func_213250_au() {
        return this.field_213279_p;
    }

    public boolean func_228017_as_() {
        return false;
    }

    public MainWindow func_228018_at_() {
        return this.field_195558_d;
    }

    public RenderTypeBuffers func_228019_au_() {
        return this.field_228006_P_;
    }

    private static ClientResourcePackInfo func_228011_a_(String string, boolean bl, Supplier<IResourcePack> supplier, IResourcePack iResourcePack, PackMetadataSection packMetadataSection, ResourcePackInfo.Priority priority, IPackNameDecorator iPackNameDecorator) {
        int n = packMetadataSection.func_198962_b();
        Supplier<IResourcePack> \u26032 = supplier;
        if (n <= 3) {
            \u26032 = Minecraft.func_228021_b_(\u26032);
        }
        if (n <= 4) {
            \u26032 = Minecraft.func_228022_c_(\u26032);
        }
        return new ClientResourcePackInfo(string, bl, \u26032, iResourcePack, packMetadataSection, priority, iPackNameDecorator);
    }

    private static Supplier<IResourcePack> func_228021_b_(Supplier<IResourcePack> supplier) {
        return () -> new LegacyResourcePackWrapper((IResourcePack)supplier.get(), LegacyResourcePackWrapper.field_211853_a);
    }

    private static Supplier<IResourcePack> func_228022_c_(Supplier<IResourcePack> supplier) {
        return () -> new LegacyResourcePackWrapperV4((IResourcePack)supplier.get());
    }

    public void func_228020_b_(int n) {
        this.field_175617_aL.func_229355_a_(n);
    }

    private /* synthetic */ IntegratedServer func_238188_a_(IDynamicRegistries.Impl impl, SaveFormat.LevelSave levelSave, PackManager packManager, IServerConfiguration iServerConfiguration, MinecraftSessionService minecraftSessionService, GameProfileRepository gameProfileRepository, PlayerProfileCache playerProfileCache, Thread thread) {
        return new IntegratedServer(thread, this, impl, levelSave, packManager.func_238224_a_(), packManager.func_238225_b_(), iServerConfiguration, minecraftSessionService, gameProfileRepository, playerProfileCache, n -> {
            TrackingChunkStatusListener trackingChunkStatusListener = new TrackingChunkStatusListener(n + 0);
            trackingChunkStatusListener.func_219521_a();
            this.field_213277_ad.set(trackingChunkStatusListener);
            return new ChainedChunkStatusListener(trackingChunkStatusListener, this.field_213275_aU::add);
        });
    }

    private static /* synthetic */ void func_229997_b_(CompletableFuture completableFuture) {
        completableFuture.complete(null);
    }

    static {
        field_147123_G = LogManager.getLogger();
        field_142025_a = Util.func_110647_a() == Util.OS.OSX;
        field_211502_b = new ResourceLocation("default");
        field_238177_c_ = new ResourceLocation("uniform");
        field_71464_q = new ResourceLocation("alt");
        field_223714_G = CompletableFuture.completedFuture(Unit.INSTANCE);
        field_71444_a = new byte[0xA00000];
    }

    public static final class PackManager
    implements AutoCloseable {
        private final ResourcePackList<ResourcePackInfo> field_238221_a_;
        private final DataPackRegistries field_238222_b_;
        private final IServerConfiguration field_238223_c_;

        private PackManager(ResourcePackList<ResourcePackInfo> resourcePackList, DataPackRegistries dataPackRegistries, IServerConfiguration iServerConfiguration) {
            this.field_238221_a_ = resourcePackList;
            this.field_238222_b_ = dataPackRegistries;
            this.field_238223_c_ = iServerConfiguration;
        }

        public ResourcePackList<ResourcePackInfo> func_238224_a_() {
            return this.field_238221_a_;
        }

        public DataPackRegistries func_238225_b_() {
            return this.field_238222_b_;
        }

        public IServerConfiguration func_238226_c_() {
            return this.field_238223_c_;
        }

        @Override
        public void close() {
            this.field_238221_a_.close();
            this.field_238222_b_.close();
        }
    }

    static enum WorldSelectionType {
        NONE,
        CREATE,
        BACKUP;

    }
}

