/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.block;

import java.util.Optional;
import java.util.Random;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.BedBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.pathfinding.PathType;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.DefaultExplosionContext;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IExplosionContext;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;

public class RespawnAnchorBlock
extends Block {
    public static final IntegerProperty field_235559_a_ = BlockStateProperties.field_235912_aC_;

    public RespawnAnchorBlock(AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a(field_235559_a_, 0));
    }

    @Override
    public ActionResultType func_225533_a_(BlockState blockState, World world, BlockPos blockPos, PlayerEntity playerEntity, Hand hand, BlockRayTraceResult blockRayTraceResult) {
        ItemStack itemStack = playerEntity.func_184586_b(hand);
        if (hand == Hand.MAIN_HAND && !RespawnAnchorBlock.func_235561_a_(itemStack) && RespawnAnchorBlock.func_235561_a_(playerEntity.func_184586_b(Hand.OFF_HAND))) {
            return ActionResultType.PASS;
        }
        if (RespawnAnchorBlock.func_235561_a_(itemStack) && RespawnAnchorBlock.func_235568_h_(blockState)) {
            RespawnAnchorBlock.func_235564_a_(world, blockPos, blockState);
            if (!playerEntity.field_71075_bZ.field_75098_d) {
                itemStack.func_190918_g(1);
            }
            return ActionResultType.func_233537_a_(world.field_72995_K);
        }
        if (blockState.func_177229_b(field_235559_a_) == 0) {
            return ActionResultType.PASS;
        }
        if (RespawnAnchorBlock.func_235562_a_(world)) {
            if (!(world.field_72995_K || (\u2603 = (ServerPlayerEntity)playerEntity).func_241141_L_() == world.func_234923_W_() && \u2603.func_241140_K_().equals(blockPos))) {
                \u2603.func_241153_a_(world.func_234923_W_(), blockPos, false, true);
                world.func_184148_a(null, (double)blockPos.func_177958_n() + 0.5, (double)blockPos.func_177956_o() + 0.5, (double)blockPos.func_177952_p() + 0.5, SoundEvents.field_232819_mt_, SoundCategory.BLOCKS, 1.0f, 1.0f);
                return ActionResultType.SUCCESS;
            }
            return ActionResultType.CONSUME;
        }
        if (!world.field_72995_K) {
            this.func_235567_d_(blockState, world, blockPos);
        }
        return ActionResultType.func_233537_a_(world.field_72995_K);
    }

    private static boolean func_235561_a_(ItemStack itemStack) {
        return itemStack.func_77973_b() == Items.field_221695_cJ;
    }

    private static boolean func_235568_h_(BlockState blockState) {
        return blockState.func_177229_b(field_235559_a_) < 4;
    }

    private static boolean func_235566_a_(BlockPos blockPos, World world) {
        FluidState fluidState = world.func_204610_c(blockPos);
        if (!fluidState.func_206884_a(FluidTags.field_206959_a)) {
            return false;
        }
        if (fluidState.func_206889_d()) {
            return true;
        }
        float \u26032 = fluidState.func_206882_g();
        if (\u26032 < 2.0f) {
            return false;
        }
        \u2603 = world.func_204610_c(blockPos.func_177977_b());
        return !\u2603.func_206884_a(FluidTags.field_206959_a);
    }

    private void func_235567_d_(BlockState blockState, World world, final BlockPos blockPos2) {
        world.func_217377_a(blockPos2, false);
        boolean bl = Direction.Plane.HORIZONTAL.func_239636_a_().map(blockPos2::func_177972_a).anyMatch(blockPos -> RespawnAnchorBlock.func_235566_a_(blockPos, world));
        \u2603 = bl || world.func_204610_c(blockPos2.func_177984_a()).func_206884_a(FluidTags.field_206959_a);
        IExplosionContext \u26032 = new IExplosionContext(){

            @Override
            public Optional<Float> func_230312_a_(Explosion explosion, IBlockReader iBlockReader, BlockPos blockPos, BlockState blockState, FluidState fluidState) {
                if (blockPos.equals(blockPos2) && \u2603) {
                    return Optional.of(Float.valueOf(Blocks.field_150355_j.func_149638_a()));
                }
                return DefaultExplosionContext.INSTANCE.func_230312_a_(explosion, iBlockReader, blockPos, blockState, fluidState);
            }

            @Override
            public boolean func_230311_a_(Explosion explosion, IBlockReader iBlockReader, BlockPos blockPos, BlockState blockState, float f) {
                return DefaultExplosionContext.INSTANCE.func_230311_a_(explosion, iBlockReader, blockPos, blockState, f);
            }
        };
        world.func_230546_a_(null, DamageSource.func_233546_a_(), \u26032, (double)blockPos2.func_177958_n() + 0.5, (double)blockPos2.func_177956_o() + 0.5, (double)blockPos2.func_177952_p() + 0.5, 5.0f, true, Explosion.Mode.DESTROY);
    }

    public static boolean func_235562_a_(World world) {
        return world.func_230315_m_().func_241511_k_();
    }

    public static void func_235564_a_(World world, BlockPos blockPos, BlockState blockState) {
        world.func_180501_a(blockPos, (BlockState)blockState.func_206870_a(field_235559_a_, blockState.func_177229_b(field_235559_a_) + 1), 3);
        world.func_184148_a(null, (double)blockPos.func_177958_n() + 0.5, (double)blockPos.func_177956_o() + 0.5, (double)blockPos.func_177952_p() + 0.5, SoundEvents.field_232817_mr_, SoundCategory.BLOCKS, 1.0f, 1.0f);
    }

    @Override
    public void func_180655_c(BlockState blockState, World world, BlockPos blockPos, Random random) {
        if (blockState.func_177229_b(field_235559_a_) == 0) {
            return;
        }
        if (random.nextInt(100) == 0) {
            world.func_184148_a(null, (double)blockPos.func_177958_n() + 0.5, (double)blockPos.func_177956_o() + 0.5, (double)blockPos.func_177952_p() + 0.5, SoundEvents.field_232816_mq_, SoundCategory.BLOCKS, 1.0f, 1.0f);
        }
        double d = (double)blockPos.func_177958_n() + 0.5 + (0.5 - random.nextDouble());
        \u2603 = (double)blockPos.func_177956_o() + 1.0;
        \u2603 = (double)blockPos.func_177952_p() + 0.5 + (0.5 - random.nextDouble());
        \u2603 = (double)random.nextFloat() * 0.04;
        world.func_195594_a(ParticleTypes.field_239819_as_, d, \u2603, \u2603, 0.0, \u2603, 0.0);
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(field_235559_a_);
    }

    @Override
    public boolean func_149740_M(BlockState blockState) {
        return true;
    }

    public static int func_235565_a_(BlockState blockState, int n) {
        return MathHelper.func_76141_d((float)(blockState.func_177229_b(field_235559_a_) - 0) / 4.0f * (float)n);
    }

    @Override
    public int func_180641_l(BlockState blockState, World world, BlockPos blockPos) {
        return RespawnAnchorBlock.func_235565_a_(blockState, 15);
    }

    public static Optional<Vector3d> func_235560_a_(EntityType<?> entityType, IWorldReader iWorldReader, BlockPos blockPos) {
        for (BlockPos blockPos2 : BlockPos.func_218278_a(blockPos.func_177982_a(-1, -1, -1), blockPos.func_177982_a(1, 1, 1))) {
            Optional<Vector3d> optional = BedBlock.func_220175_a(entityType, iWorldReader, blockPos2);
            if (!optional.isPresent()) continue;
            return optional;
        }
        return Optional.empty();
    }

    @Override
    public boolean func_196266_a(BlockState blockState, IBlockReader iBlockReader, BlockPos blockPos, PathType pathType) {
        return false;
    }
}

