/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements.criterion;

import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import javax.annotation.Nullable;
import net.minecraft.advancements.criterion.AbstractCriterionTrigger;
import net.minecraft.advancements.criterion.CriterionInstance;
import net.minecraft.advancements.criterion.EntityPredicate;
import net.minecraft.advancements.criterion.ItemPredicate;
import net.minecraft.advancements.criterion.LocationPredicate;
import net.minecraft.advancements.criterion.StatePropertiesPredicate;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.ConditionArrayParser;
import net.minecraft.loot.ConditionArraySerializer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.server.ServerWorld;

public class PlacedBlockTrigger
extends AbstractCriterionTrigger<Instance> {
    private static final ResourceLocation field_193174_a = new ResourceLocation("placed_block");

    @Override
    public ResourceLocation func_192163_a() {
        return field_193174_a;
    }

    @Override
    public Instance func_230241_b_(JsonObject jsonObject, EntityPredicate.AndPredicate andPredicate, ConditionArrayParser conditionArrayParser) {
        Block block = PlacedBlockTrigger.func_226950_a_(jsonObject);
        StatePropertiesPredicate \u26032 = StatePropertiesPredicate.func_227186_a_(jsonObject.get("state"));
        if (block != null) {
            \u26032.func_227183_a_(block.func_176194_O(), string -> {
                throw new JsonSyntaxException("Block " + block + " has no property " + string + ":");
            });
        }
        LocationPredicate \u26033 = LocationPredicate.func_193454_a(jsonObject.get("location"));
        ItemPredicate \u26034 = ItemPredicate.func_192492_a(jsonObject.get("item"));
        return new Instance(andPredicate, block, \u26032, \u26033, \u26034);
    }

    @Nullable
    private static Block func_226950_a_(JsonObject jsonObject) {
        if (jsonObject.has("block")) {
            ResourceLocation resourceLocation = new ResourceLocation(JSONUtils.func_151200_h(jsonObject, "block"));
            return (Block)Registry.field_212618_g.func_218349_b(resourceLocation).orElseThrow(() -> new JsonSyntaxException("Unknown block type '" + resourceLocation + "'"));
        }
        return null;
    }

    public void func_193173_a(ServerPlayerEntity serverPlayerEntity, BlockPos blockPos, ItemStack itemStack) {
        BlockState blockState = serverPlayerEntity.func_71121_q().func_180495_p(blockPos);
        this.func_235959_a_(serverPlayerEntity, instance -> instance.func_193210_a(blockState, blockPos, serverPlayerEntity.func_71121_q(), itemStack));
    }

    @Override
    public /* synthetic */ CriterionInstance func_230241_b_(JsonObject jsonObject, EntityPredicate.AndPredicate andPredicate, ConditionArrayParser conditionArrayParser) {
        return this.func_230241_b_(jsonObject, andPredicate, conditionArrayParser);
    }

    public static class Instance
    extends CriterionInstance {
        private final Block field_193211_a;
        private final StatePropertiesPredicate field_193212_b;
        private final LocationPredicate field_193213_c;
        private final ItemPredicate field_193214_d;

        public Instance(EntityPredicate.AndPredicate andPredicate, @Nullable Block block, StatePropertiesPredicate statePropertiesPredicate, LocationPredicate locationPredicate, ItemPredicate itemPredicate) {
            super(field_193174_a, andPredicate);
            this.field_193211_a = block;
            this.field_193212_b = statePropertiesPredicate;
            this.field_193213_c = locationPredicate;
            this.field_193214_d = itemPredicate;
        }

        public static Instance func_203934_a(Block block) {
            return new Instance(EntityPredicate.AndPredicate.field_234582_a_, block, StatePropertiesPredicate.field_227178_a_, LocationPredicate.field_193455_a, ItemPredicate.field_192495_a);
        }

        public boolean func_193210_a(BlockState blockState, BlockPos blockPos, ServerWorld serverWorld, ItemStack itemStack) {
            if (this.field_193211_a != null && !blockState.func_203425_a(this.field_193211_a)) {
                return false;
            }
            if (!this.field_193212_b.func_227181_a_(blockState)) {
                return false;
            }
            if (!this.field_193213_c.func_193453_a(serverWorld, blockPos.func_177958_n(), blockPos.func_177956_o(), blockPos.func_177952_p())) {
                return false;
            }
            return this.field_193214_d.func_192493_a(itemStack);
        }

        @Override
        public JsonObject func_230240_a_(ConditionArraySerializer conditionArraySerializer) {
            JsonObject jsonObject = super.func_230240_a_(conditionArraySerializer);
            if (this.field_193211_a != null) {
                jsonObject.addProperty("block", Registry.field_212618_g.func_177774_c(this.field_193211_a).toString());
            }
            jsonObject.add("state", this.field_193212_b.func_227180_a_());
            jsonObject.add("location", this.field_193213_c.func_204009_a());
            jsonObject.add("item", this.field_193214_d.func_200319_a());
            return jsonObject;
        }
    }
}

