/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.DisplayInfo;
import net.minecraft.advancements.FrameType;
import net.minecraft.advancements.ICriterionInstance;
import net.minecraft.advancements.IRequirementsStrategy;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.ConditionArrayParser;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentUtils;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.event.HoverEvent;
import org.apache.commons.lang3.ArrayUtils;

public class Advancement {
    private final Advancement field_192076_a;
    private final DisplayInfo field_192077_b;
    private final AdvancementRewards field_192078_c;
    private final ResourceLocation field_192079_d;
    private final Map<String, Criterion> field_192080_e;
    private final String[][] field_192081_f;
    private final Set<Advancement> field_192082_g = Sets.newLinkedHashSet();
    private final ITextComponent field_193125_h;

    public Advancement(ResourceLocation resourceLocation, @Nullable Advancement advancement, @Nullable DisplayInfo displayInfo, AdvancementRewards advancementRewards, Map<String, Criterion> map, String[][] stringArray) {
        this.field_192079_d = resourceLocation;
        this.field_192077_b = displayInfo;
        this.field_192080_e = ImmutableMap.copyOf(map);
        this.field_192076_a = advancement;
        this.field_192078_c = advancementRewards;
        this.field_192081_f = stringArray;
        if (advancement != null) {
            advancement.func_192071_a(this);
        }
        if (displayInfo == null) {
            this.field_193125_h = new StringTextComponent(resourceLocation.toString());
        } else {
            ITextComponent iTextComponent = displayInfo.func_192297_a();
            TextFormatting \u26032 = displayInfo.func_192291_d().func_193229_c();
            IFormattableTextComponent \u26033 = TextComponentUtils.func_240648_a_(iTextComponent.func_230532_e_(), Style.field_240709_b_.func_240712_a_(\u26032)).func_240702_b_("\n").func_230529_a_(displayInfo.func_193222_b());
            IFormattableTextComponent \u26034 = iTextComponent.func_230532_e_().func_240700_a_(style -> style.func_240716_a_(new HoverEvent(HoverEvent.Action.field_230550_a_, \u26033)));
            this.field_193125_h = new StringTextComponent("[").func_230529_a_(\u26034).func_240702_b_("]").func_240699_a_(\u26032);
        }
    }

    public Builder func_192075_a() {
        return new Builder(this.field_192076_a == null ? null : this.field_192076_a.func_192067_g(), this.field_192077_b, this.field_192078_c, this.field_192080_e, this.field_192081_f);
    }

    @Nullable
    public Advancement func_192070_b() {
        return this.field_192076_a;
    }

    @Nullable
    public DisplayInfo func_192068_c() {
        return this.field_192077_b;
    }

    public AdvancementRewards func_192072_d() {
        return this.field_192078_c;
    }

    public String toString() {
        return "SimpleAdvancement{id=" + this.func_192067_g() + ", parent=" + (this.field_192076_a == null ? "null" : this.field_192076_a.func_192067_g()) + ", display=" + this.field_192077_b + ", rewards=" + this.field_192078_c + ", criteria=" + this.field_192080_e + ", requirements=" + Arrays.deepToString((Object[])this.field_192081_f) + '}';
    }

    public Iterable<Advancement> func_192069_e() {
        return this.field_192082_g;
    }

    public Map<String, Criterion> func_192073_f() {
        return this.field_192080_e;
    }

    public int func_193124_g() {
        return this.field_192081_f.length;
    }

    public void func_192071_a(Advancement advancement) {
        this.field_192082_g.add(advancement);
    }

    public ResourceLocation func_192067_g() {
        return this.field_192079_d;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Advancement)) {
            return false;
        }
        Advancement advancement = (Advancement)object;
        return this.field_192079_d.equals(advancement.field_192079_d);
    }

    public int hashCode() {
        return this.field_192079_d.hashCode();
    }

    public String[][] func_192074_h() {
        return this.field_192081_f;
    }

    public ITextComponent func_193123_j() {
        return this.field_193125_h;
    }

    public static class Builder {
        private ResourceLocation field_192061_a;
        private Advancement field_192062_b;
        private DisplayInfo field_192063_c;
        private AdvancementRewards field_192064_d = AdvancementRewards.field_192114_a;
        private Map<String, Criterion> field_192065_e = Maps.newLinkedHashMap();
        private String[][] field_192066_f;
        private IRequirementsStrategy field_199751_g = IRequirementsStrategy.field_223214_a_;

        private Builder(@Nullable ResourceLocation resourceLocation, @Nullable DisplayInfo displayInfo, AdvancementRewards advancementRewards, Map<String, Criterion> map, String[][] stringArray) {
            this.field_192061_a = resourceLocation;
            this.field_192063_c = displayInfo;
            this.field_192064_d = advancementRewards;
            this.field_192065_e = map;
            this.field_192066_f = stringArray;
        }

        private Builder() {
        }

        public static Builder func_200278_a() {
            return new Builder();
        }

        public Builder func_203905_a(Advancement advancement) {
            this.field_192062_b = advancement;
            return this;
        }

        public Builder func_200272_a(ResourceLocation resourceLocation) {
            this.field_192061_a = resourceLocation;
            return this;
        }

        public Builder func_215092_a(ItemStack itemStack, ITextComponent iTextComponent, ITextComponent iTextComponent2, @Nullable ResourceLocation resourceLocation, FrameType frameType, boolean bl, boolean bl2, boolean bl3) {
            return this.func_203903_a(new DisplayInfo(itemStack, iTextComponent, iTextComponent2, resourceLocation, frameType, bl, bl2, bl3));
        }

        public Builder func_203902_a(IItemProvider iItemProvider, ITextComponent iTextComponent, ITextComponent iTextComponent2, @Nullable ResourceLocation resourceLocation, FrameType frameType, boolean bl, boolean bl2, boolean bl3) {
            return this.func_203903_a(new DisplayInfo(new ItemStack(iItemProvider.func_199767_j()), iTextComponent, iTextComponent2, resourceLocation, frameType, bl, bl2, bl3));
        }

        public Builder func_203903_a(DisplayInfo displayInfo) {
            this.field_192063_c = displayInfo;
            return this;
        }

        public Builder func_200271_a(AdvancementRewards.Builder builder) {
            return this.func_200274_a(builder.func_200281_a());
        }

        public Builder func_200274_a(AdvancementRewards advancementRewards) {
            this.field_192064_d = advancementRewards;
            return this;
        }

        public Builder func_200275_a(String string, ICriterionInstance iCriterionInstance) {
            return this.func_200276_a(string, new Criterion(iCriterionInstance));
        }

        public Builder func_200276_a(String string, Criterion criterion) {
            if (this.field_192065_e.containsKey(string)) {
                throw new IllegalArgumentException("Duplicate criterion " + string);
            }
            this.field_192065_e.put(string, criterion);
            return this;
        }

        public Builder func_200270_a(IRequirementsStrategy iRequirementsStrategy) {
            this.field_199751_g = iRequirementsStrategy;
            return this;
        }

        public boolean func_192058_a(Function<ResourceLocation, Advancement> function) {
            if (this.field_192061_a == null) {
                return true;
            }
            if (this.field_192062_b == null) {
                this.field_192062_b = function.apply(this.field_192061_a);
            }
            return this.field_192062_b != null;
        }

        public Advancement func_192056_a(ResourceLocation resourceLocation2) {
            if (!this.func_192058_a(resourceLocation -> null)) {
                throw new IllegalStateException("Tried to build incomplete advancement!");
            }
            if (this.field_192066_f == null) {
                this.field_192066_f = this.field_199751_g.createRequirements(this.field_192065_e.keySet());
            }
            return new Advancement(resourceLocation2, this.field_192062_b, this.field_192063_c, this.field_192064_d, this.field_192065_e, this.field_192066_f);
        }

        public Advancement func_203904_a(Consumer<Advancement> consumer, String string) {
            Advancement advancement = this.func_192056_a(new ResourceLocation(string));
            consumer.accept(advancement);
            return advancement;
        }

        public JsonObject func_200273_b() {
            if (this.field_192066_f == null) {
                this.field_192066_f = this.field_199751_g.createRequirements(this.field_192065_e.keySet());
            }
            JsonObject jsonObject = new JsonObject();
            if (this.field_192062_b != null) {
                jsonObject.addProperty("parent", this.field_192062_b.func_192067_g().toString());
            } else if (this.field_192061_a != null) {
                jsonObject.addProperty("parent", this.field_192061_a.toString());
            }
            if (this.field_192063_c != null) {
                jsonObject.add("display", this.field_192063_c.func_200290_k());
            }
            jsonObject.add("rewards", this.field_192064_d.func_200286_b());
            \u2603 = new JsonObject();
            for (Map.Entry<String, Criterion> entry : this.field_192065_e.entrySet()) {
                \u2603.add(entry.getKey(), entry.getValue().func_200287_b());
            }
            jsonObject.add("criteria", (JsonElement)\u2603);
            JsonArray \u26032 = new JsonArray();
            for (String[] stringArray : this.field_192066_f) {
                JsonArray jsonArray = new JsonArray();
                for (String string : stringArray) {
                    jsonArray.add(string);
                }
                \u26032.add((JsonElement)jsonArray);
            }
            jsonObject.add("requirements", (JsonElement)\u26032);
            return jsonObject;
        }

        public void func_192057_a(PacketBuffer packetBuffer) {
            if (this.field_192061_a == null) {
                packetBuffer.writeBoolean(false);
            } else {
                packetBuffer.writeBoolean(true);
                packetBuffer.func_192572_a(this.field_192061_a);
            }
            if (this.field_192063_c == null) {
                packetBuffer.writeBoolean(false);
            } else {
                packetBuffer.writeBoolean(true);
                this.field_192063_c.func_192290_a(packetBuffer);
            }
            Criterion.func_192141_a(this.field_192065_e, packetBuffer);
            packetBuffer.func_150787_b(this.field_192066_f.length);
            for (String[] stringArray : this.field_192066_f) {
                packetBuffer.func_150787_b(stringArray.length);
                for (String string : stringArray) {
                    packetBuffer.func_180714_a(string);
                }
            }
        }

        public String toString() {
            return "Task Advancement{parentId=" + this.field_192061_a + ", display=" + this.field_192063_c + ", rewards=" + this.field_192064_d + ", criteria=" + this.field_192065_e + ", requirements=" + Arrays.deepToString((Object[])this.field_192066_f) + '}';
        }

        public static Builder func_241043_a_(JsonObject jsonObject, ConditionArrayParser conditionArrayParser) {
            ResourceLocation resourceLocation = jsonObject.has("parent") ? new ResourceLocation(JSONUtils.func_151200_h(jsonObject, "parent")) : null;
            DisplayInfo \u26032 = jsonObject.has("display") ? DisplayInfo.func_192294_a(JSONUtils.func_152754_s(jsonObject, "display")) : null;
            AdvancementRewards \u26033 = jsonObject.has("rewards") ? AdvancementRewards.func_241096_a_(JSONUtils.func_152754_s(jsonObject, "rewards")) : AdvancementRewards.field_192114_a;
            Map<String, Criterion> \u26034 = Criterion.func_232634_b_(JSONUtils.func_152754_s(jsonObject, "criteria"), conditionArrayParser);
            if (\u26034.isEmpty()) {
                throw new JsonSyntaxException("Advancement criteria cannot be empty");
            }
            JsonArray \u26035 = JSONUtils.func_151213_a(jsonObject, "requirements", new JsonArray());
            String[][] \u26036 = new String[\u26035.size()][];
            for (int n = 0; n < \u26035.size(); ++n) {
                JsonArray jsonArray = JSONUtils.func_151207_m(\u26035.get(n), "requirements[" + n + "]");
                \u26036[n] = new String[jsonArray.size()];
                for (int i = 0; i < jsonArray.size(); ++i) {
                    \u26036[n][i] = JSONUtils.func_151206_a(jsonArray.get(i), "requirements[" + n + "][" + i + "]");
                }
            }
            if (\u26036.length == 0) {
                \u26036 = new String[\u26034.size()][];
                int n = 0;
                for (String string2 : \u26034.keySet()) {
                    \u26036[n++] = new String[]{string2};
                }
            }
            for (String[] stringArray : \u26036) {
                if (stringArray.length == 0 && \u26034.isEmpty()) {
                    throw new JsonSyntaxException("Requirement entry cannot be empty");
                }
                String[] stringArray2 = stringArray;
                int n2 = stringArray2.length;
                for (int i = 0; i < n2; ++i) {
                    String string = stringArray2[i];
                    if (\u26034.containsKey(string)) continue;
                    throw new JsonSyntaxException("Unknown required criterion '" + string + "'");
                }
            }
            for (String string : \u26034.keySet()) {
                boolean bl = false;
                for (Object[] objectArray : \u26036) {
                    if (!ArrayUtils.contains((Object[])objectArray, (Object)string)) continue;
                    bl = true;
                    break;
                }
                if (bl) continue;
                throw new JsonSyntaxException("Criterion '" + string + "' isn't a requirement for completion. This isn't supported behaviour, all criteria must be required.");
            }
            return new Builder(resourceLocation, \u26032, \u26033, \u26034, \u26036);
        }

        public static Builder func_192060_b(PacketBuffer packetBuffer) {
            ResourceLocation resourceLocation = packetBuffer.readBoolean() ? packetBuffer.func_192575_l() : null;
            DisplayInfo \u26032 = packetBuffer.readBoolean() ? DisplayInfo.func_192295_b(packetBuffer) : null;
            Map<String, Criterion> \u26033 = Criterion.func_192142_c(packetBuffer);
            String[][] \u26034 = new String[packetBuffer.func_150792_a()][];
            for (int i = 0; i < \u26034.length; ++i) {
                \u26034[i] = new String[packetBuffer.func_150792_a()];
                for (\u2603 = 0; \u2603 < \u26034[i].length; ++\u2603) {
                    \u26034[i][\u2603] = packetBuffer.func_150789_c(Short.MAX_VALUE);
                }
            }
            return new Builder(resourceLocation, \u26032, AdvancementRewards.field_192114_a, \u26033, \u26034);
        }

        public Map<String, Criterion> func_200277_c() {
            return this.field_192065_e;
        }
    }
}

