/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.realmsclient.gui.screens;

import com.google.common.collect.Lists;
import com.google.common.util.concurrent.RateLimiter;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.realmsclient.client.FileUpload;
import com.mojang.realmsclient.client.RealmsClient;
import com.mojang.realmsclient.client.UploadStatus;
import com.mojang.realmsclient.dto.UploadInfo;
import com.mojang.realmsclient.exception.RealmsServiceException;
import com.mojang.realmsclient.exception.RetryCallException;
import com.mojang.realmsclient.gui.screens.RealmsResetWorldScreen;
import com.mojang.realmsclient.util.UploadTokenCache;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Stream;
import java.util.zip.GZIPOutputStream;
import net.minecraft.client.gui.DialogTexts;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.util.UploadSpeed;
import net.minecraft.realms.RealmsNarratorHelper;
import net.minecraft.realms.RealmsScreen;
import net.minecraft.util.SharedConstants;
import net.minecraft.util.Util;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.storage.WorldSummary;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;
import org.apache.commons.compress.utils.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RealmsUploadScreen
extends RealmsScreen {
    private static final Logger field_224696_a = LogManager.getLogger();
    private static final ReentrantLock field_238081_b_ = new ReentrantLock();
    private static final String[] field_224713_r = new String[]{"", ".", ". .", ". . ."};
    private final RealmsResetWorldScreen field_224697_b;
    private final WorldSummary field_224698_c;
    private final long field_224699_d;
    private final int field_224700_e;
    private final UploadStatus field_224701_f;
    private final RateLimiter field_224702_g;
    private volatile ITextComponent[] field_224703_h;
    private volatile ITextComponent field_224704_i = new TranslationTextComponent("mco.upload.preparing");
    private volatile String field_224705_j;
    private volatile boolean field_224706_k;
    private volatile boolean field_224707_l;
    private volatile boolean field_224708_m = true;
    private volatile boolean field_224709_n;
    private Button field_224710_o;
    private Button field_224711_p;
    private int field_238079_E_;
    private Long field_224715_t;
    private Long field_224716_u;
    private long field_224717_v;
    private final Runnable field_238080_I_;

    public RealmsUploadScreen(long l, int n, RealmsResetWorldScreen realmsResetWorldScreen, WorldSummary worldSummary, Runnable runnable) {
        this.field_224699_d = l;
        this.field_224700_e = n;
        this.field_224697_b = realmsResetWorldScreen;
        this.field_224698_c = worldSummary;
        this.field_224701_f = new UploadStatus();
        this.field_224702_g = RateLimiter.create((double)0.1f);
        this.field_238080_I_ = runnable;
    }

    @Override
    public void func_231160_c_() {
        this.field_230706_i_.field_195559_v.func_197967_a(true);
        this.field_224710_o = new Button(this.field_230708_k_ / 2 - 100, this.field_230709_l_ - 42, 200, 20, DialogTexts.field_240637_h_, button -> this.func_224679_c());
        this.field_224711_p = this.func_230480_a_(new Button(this.field_230708_k_ / 2 - 100, this.field_230709_l_ - 42, 200, 20, DialogTexts.field_240633_d_, button -> this.func_224695_d()));
        if (!this.field_224709_n) {
            if (this.field_224697_b.field_224455_a == -1) {
                this.func_224682_h();
            } else {
                this.field_224697_b.func_237952_a_(() -> {
                    if (!this.field_224709_n) {
                        this.field_224709_n = true;
                        this.field_230706_i_.func_147108_a(this);
                        this.func_224682_h();
                    }
                });
            }
        }
    }

    @Override
    public void func_231164_f_() {
        this.field_230706_i_.field_195559_v.func_197967_a(false);
    }

    private void func_224679_c() {
        this.field_238080_I_.run();
    }

    private void func_224695_d() {
        this.field_224706_k = true;
        this.field_230706_i_.func_147108_a(this.field_224697_b);
    }

    @Override
    public boolean func_231046_a_(int n, int n2, int n3) {
        if (n == 256) {
            if (this.field_224708_m) {
                this.func_224695_d();
            } else {
                this.func_224679_c();
            }
            return true;
        }
        return super.func_231046_a_(n, n2, n3);
    }

    @Override
    public void func_230430_a_(MatrixStack matrixStack2, int n, int n2, float f) {
        MatrixStack matrixStack2;
        this.func_230446_a_(matrixStack2);
        if (!this.field_224707_l && this.field_224701_f.field_224978_a != 0L && this.field_224701_f.field_224978_a.longValue() == this.field_224701_f.field_224979_b.longValue()) {
            this.field_224704_i = new TranslationTextComponent("mco.upload.verifying");
            this.field_224711_p.field_230693_o_ = false;
        }
        this.func_238472_a_(matrixStack2, this.field_230712_o_, this.field_224704_i, this.field_230708_k_ / 2, 50, 0xFFFFFF);
        if (this.field_224708_m) {
            this.func_238086_b_(matrixStack2);
        }
        if (this.field_224701_f.field_224978_a != 0L && !this.field_224706_k) {
            this.func_238088_c_(matrixStack2);
            this.func_238089_d_(matrixStack2);
        }
        if (this.field_224703_h != null) {
            for (int i = 0; i < this.field_224703_h.length; ++i) {
                this.func_238472_a_(matrixStack2, this.field_230712_o_, this.field_224703_h[i], this.field_230708_k_ / 2, 110 + 12 * i, 0xFF0000);
            }
        }
        super.func_230430_a_(matrixStack2, n, n2, f);
    }

    private void func_238086_b_(MatrixStack matrixStack) {
        int n = this.field_230712_o_.func_238414_a_(this.field_224704_i);
        this.field_230712_o_.func_238421_b_(matrixStack, field_224713_r[this.field_238079_E_ / 10 % field_224713_r.length], this.field_230708_k_ / 2 + n / 2 + 5, 50.0f, 0xFFFFFF);
    }

    private void func_238088_c_(MatrixStack matrixStack) {
        double d = this.field_224701_f.field_224978_a.doubleValue() / this.field_224701_f.field_224979_b.doubleValue() * 100.0;
        if (d > 100.0) {
            d = 100.0;
        }
        this.field_224705_j = String.format(Locale.ROOT, "%.1f", d);
        RenderSystem.color4f(1.0f, 1.0f, 1.0f, 1.0f);
        RenderSystem.disableTexture();
        \u2603 = this.field_230708_k_ / 2 - 100;
        \u2603 = 0.5;
        Tessellator \u26032 = Tessellator.func_178181_a();
        BufferBuilder \u26033 = \u26032.func_178180_c();
        \u26033.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        \u26033.func_225582_a_(\u2603 - 0.5, 95.5, 0.0).func_225586_a_(217, 210, 210, 255).func_181675_d();
        \u26033.func_225582_a_(\u2603 + 200.0 * d / 100.0 + 0.5, 95.5, 0.0).func_225586_a_(217, 210, 210, 255).func_181675_d();
        \u26033.func_225582_a_(\u2603 + 200.0 * d / 100.0 + 0.5, 79.5, 0.0).func_225586_a_(217, 210, 210, 255).func_181675_d();
        \u26033.func_225582_a_(\u2603 - 0.5, 79.5, 0.0).func_225586_a_(217, 210, 210, 255).func_181675_d();
        \u26033.func_225582_a_(\u2603, 95.0, 0.0).func_225586_a_(128, 128, 128, 255).func_181675_d();
        \u26033.func_225582_a_(\u2603 + 200.0 * d / 100.0, 95.0, 0.0).func_225586_a_(128, 128, 128, 255).func_181675_d();
        \u26033.func_225582_a_(\u2603 + 200.0 * d / 100.0, 80.0, 0.0).func_225586_a_(128, 128, 128, 255).func_181675_d();
        \u26033.func_225582_a_(\u2603, 80.0, 0.0).func_225586_a_(128, 128, 128, 255).func_181675_d();
        \u26032.func_78381_a();
        RenderSystem.enableTexture();
        this.func_238471_a_(matrixStack, this.field_230712_o_, this.field_224705_j + " %", this.field_230708_k_ / 2, 84, 0xFFFFFF);
    }

    private void func_238089_d_(MatrixStack matrixStack2) {
        if (this.field_238079_E_ % 20 == 0) {
            if (this.field_224715_t != null) {
                long l = Util.func_211177_b() - this.field_224716_u;
                if (l == 0L) {
                    l = 1L;
                }
                this.field_224717_v = 1000L * (this.field_224701_f.field_224978_a - this.field_224715_t) / l;
                this.func_238083_a_(matrixStack2, this.field_224717_v);
            }
            this.field_224715_t = this.field_224701_f.field_224978_a;
            this.field_224716_u = Util.func_211177_b();
        } else {
            MatrixStack matrixStack2;
            this.func_238083_a_(matrixStack2, this.field_224717_v);
        }
    }

    private void func_238083_a_(MatrixStack matrixStack, long l) {
        if (l > 0L) {
            int n = this.field_230712_o_.func_78256_a(this.field_224705_j);
            String \u26032 = "(" + UploadSpeed.func_237684_b_(l) + "/s)";
            this.field_230712_o_.func_238421_b_(matrixStack, \u26032, this.field_230708_k_ / 2 + n / 2 + 15, 84.0f, 0xFFFFFF);
        }
    }

    @Override
    public void func_231023_e_() {
        super.func_231023_e_();
        ++this.field_238079_E_;
        if (this.field_224704_i != null && this.field_224702_g.tryAcquire(1)) {
            ArrayList arrayList = Lists.newArrayList();
            arrayList.add(this.field_224704_i.getString());
            if (this.field_224705_j != null) {
                arrayList.add(this.field_224705_j + "%");
            }
            if (this.field_224703_h != null) {
                Stream.of(this.field_224703_h).map(ITextComponent::getString).forEach(arrayList::add);
            }
            RealmsNarratorHelper.func_239550_a_(String.join((CharSequence)System.lineSeparator(), arrayList));
        }
    }

    private void func_224682_h() {
        this.field_224709_n = true;
        new Thread(() -> {
            File \u26035 = null;
            RealmsClient \u26032 = RealmsClient.func_224911_a();
            long \u26033 = this.field_224699_d;
            try {
                if (!field_238081_b_.tryLock(1L, TimeUnit.SECONDS)) {
                    this.field_224704_i = new TranslationTextComponent("mco.upload.close.failure");
                    return;
                }
                UploadInfo uploadInfo = null;
                for (int i = 0; i < 20; ++i) {
                    block35: {
                        try {
                            if (!this.field_224706_k) break block35;
                            this.func_224676_i();
                            return;
                        }
                        catch (RetryCallException retryCallException) {
                            Thread.sleep(retryCallException.field_224985_e * 1000);
                            continue;
                        }
                    }
                    uploadInfo = \u26032.func_224934_h(\u26033, UploadTokenCache.func_225235_a(\u26033));
                    break;
                }
                if (uploadInfo == null) {
                    this.field_224704_i = new TranslationTextComponent("mco.upload.close.failure");
                    return;
                }
                UploadTokenCache.func_225234_a(\u26033, uploadInfo.func_230795_a_());
                if (!uploadInfo.func_230799_c_()) {
                    this.field_224704_i = new TranslationTextComponent("mco.upload.close.failure");
                    return;
                }
                if (this.field_224706_k) {
                    this.func_224676_i();
                    return;
                }
                File \u26034 = new File(this.field_230706_i_.field_71412_D.getAbsolutePath(), "saves");
                \u26035 = this.func_224675_b(new File(\u26034, this.field_224698_c.func_75786_a()));
                if (this.field_224706_k) {
                    this.func_224676_i();
                    return;
                }
                if (!this.func_224692_a(\u26035)) {
                    long l = \u26035.length();
                    UploadSpeed \u26036 = UploadSpeed.func_237682_a_(l);
                    UploadSpeed \u26037 = UploadSpeed.func_237682_a_(0x140000000L);
                    if (UploadSpeed.func_237685_b_(l, \u26036).equals(UploadSpeed.func_237685_b_(0x140000000L, \u26037)) && \u26036 != UploadSpeed.B) {
                        UploadSpeed uploadSpeed = UploadSpeed.values()[\u26036.ordinal() - 1];
                        this.func_238085_a_(new TranslationTextComponent("mco.upload.size.failure.line1", this.field_224698_c.func_75788_b()), new TranslationTextComponent("mco.upload.size.failure.line2", UploadSpeed.func_237685_b_(l, uploadSpeed), UploadSpeed.func_237685_b_(0x140000000L, uploadSpeed)));
                        return;
                    }
                    this.func_238085_a_(new TranslationTextComponent("mco.upload.size.failure.line1", this.field_224698_c.func_75788_b()), new TranslationTextComponent("mco.upload.size.failure.line2", UploadSpeed.func_237685_b_(l, \u26036), UploadSpeed.func_237685_b_(0x140000000L, \u26037)));
                    return;
                }
                this.field_224704_i = new TranslationTextComponent("mco.upload.uploading", this.field_224698_c.func_75788_b());
                FileUpload \u26038 = new FileUpload(\u26035, this.field_224699_d, this.field_224700_e, uploadInfo, this.field_230706_i_.func_110432_I(), SharedConstants.func_215069_a().getName(), this.field_224701_f);
                \u26038.func_224874_a(uploadResult -> {
                    if (uploadResult.field_225179_a >= 200 && uploadResult.field_225179_a < 300) {
                        this.field_224707_l = true;
                        this.field_224704_i = new TranslationTextComponent("mco.upload.done");
                        this.field_224710_o.func_238482_a_(DialogTexts.field_240632_c_);
                        UploadTokenCache.func_225233_b(\u26033);
                    } else if (uploadResult.field_225179_a == 400 && uploadResult.field_225180_b != null) {
                        this.func_238085_a_(new TranslationTextComponent("mco.upload.failed", uploadResult.field_225180_b));
                    } else {
                        this.func_238085_a_(new TranslationTextComponent("mco.upload.failed", uploadResult.field_225179_a));
                    }
                });
                while (!\u26038.func_224881_b()) {
                    if (this.field_224706_k) {
                        \u26038.func_224878_a();
                        this.func_224676_i();
                        return;
                    }
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException interruptedException) {
                        field_224696_a.error("Failed to check Realms file upload status");
                    }
                }
            }
            catch (IOException iOException) {
                this.func_238085_a_(new TranslationTextComponent("mco.upload.failed", iOException.getMessage()));
            }
            catch (RealmsServiceException realmsServiceException) {
                this.func_238085_a_(new TranslationTextComponent("mco.upload.failed", realmsServiceException.toString()));
            }
            catch (InterruptedException interruptedException) {
                field_224696_a.error("Could not acquire upload lock");
            }
            finally {
                this.field_224707_l = true;
                if (!field_238081_b_.isHeldByCurrentThread()) {
                    return;
                }
                field_238081_b_.unlock();
                this.field_224708_m = false;
                this.field_230705_e_.clear();
                this.func_230480_a_(this.field_224710_o);
                if (\u26035 != null) {
                    field_224696_a.debug("Deleting file " + \u26035.getAbsolutePath());
                    \u26035.delete();
                }
            }
        }).start();
    }

    private void func_238085_a_(ITextComponent ... iTextComponentArray) {
        this.field_224703_h = iTextComponentArray;
    }

    private void func_224676_i() {
        this.field_224704_i = new TranslationTextComponent("mco.upload.cancelled");
        field_224696_a.debug("Upload was cancelled");
    }

    private boolean func_224692_a(File file) {
        return file.length() < 0x140000000L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File func_224675_b(File file) throws IOException {
        try (TarArchiveOutputStream \u26032 = null;){
            File file2 = File.createTempFile("realms-upload-file", ".tar.gz");
            \u26032 = new TarArchiveOutputStream((OutputStream)new GZIPOutputStream(new FileOutputStream(file2)));
            \u26032.setLongFileMode(3);
            this.func_224669_a(\u26032, file.getAbsolutePath(), "world", true);
            \u26032.finish();
            File file3 = file2;
            return file3;
        }
    }

    private void func_224669_a(TarArchiveOutputStream tarArchiveOutputStream, String string, String string2, boolean bl) throws IOException {
        if (this.field_224706_k) {
            return;
        }
        File file = new File(string);
        String \u26032 = bl ? string2 : string2 + file.getName();
        TarArchiveEntry \u26033 = new TarArchiveEntry(file, \u26032);
        tarArchiveOutputStream.putArchiveEntry((ArchiveEntry)\u26033);
        if (file.isFile()) {
            IOUtils.copy((InputStream)new FileInputStream(file), (OutputStream)tarArchiveOutputStream);
            tarArchiveOutputStream.closeArchiveEntry();
        } else {
            tarArchiveOutputStream.closeArchiveEntry();
            File[] fileArray = file.listFiles();
            if (fileArray != null) {
                for (File file2 : fileArray) {
                    this.func_224669_a(tarArchiveOutputStream, file2.getAbsolutePath(), \u26032 + "/", false);
                }
            }
        }
    }
}

