/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.realmsclient.gui.screens;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.realmsclient.client.RealmsClient;
import com.mojang.realmsclient.dto.Backup;
import com.mojang.realmsclient.dto.RealmsServer;
import com.mojang.realmsclient.exception.RealmsServiceException;
import com.mojang.realmsclient.gui.screens.RealmsBackupInfoScreen;
import com.mojang.realmsclient.gui.screens.RealmsConfigureWorldScreen;
import com.mojang.realmsclient.gui.screens.RealmsLongConfirmationScreen;
import com.mojang.realmsclient.gui.screens.RealmsLongRunningMcoTaskScreen;
import com.mojang.realmsclient.util.RealmsUtil;
import java.text.DateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.DialogTexts;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.gui.widget.list.ExtendedList;
import net.minecraft.client.resources.I18n;
import net.minecraft.realms.RealmsLabel;
import net.minecraft.realms.RealmsNarratorHelper;
import net.minecraft.realms.RealmsObjectSelectionList;
import net.minecraft.realms.RealmsScreen;
import net.minecraft.realms.action.PrepareDownloadRealmsAction;
import net.minecraft.realms.action.RestoringBackupRealmsAction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TranslationTextComponent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RealmsBackupScreen
extends RealmsScreen {
    private static final Logger field_224114_a = LogManager.getLogger();
    private static final ResourceLocation field_237740_b_ = new ResourceLocation("realms", "textures/gui/realms/plus_icon.png");
    private static final ResourceLocation field_237741_c_ = new ResourceLocation("realms", "textures/gui/realms/restore_icon.png");
    private static int field_224115_b = -1;
    private final RealmsConfigureWorldScreen field_224116_c;
    private List<Backup> field_224117_d = Collections.emptyList();
    private String field_224118_e;
    private BackupObjectSelectionList field_224119_f;
    private int field_224120_g = -1;
    private final int field_224121_h;
    private Button field_224122_i;
    private Button field_224123_j;
    private Button field_224124_k;
    private Boolean field_224125_l = false;
    private final RealmsServer field_224126_m;
    private RealmsLabel field_224127_n;

    public RealmsBackupScreen(RealmsConfigureWorldScreen realmsConfigureWorldScreen, RealmsServer realmsServer, int n) {
        this.field_224116_c = realmsConfigureWorldScreen;
        this.field_224126_m = realmsServer;
        this.field_224121_h = n;
    }

    @Override
    public void func_231160_c_() {
        this.field_230706_i_.field_195559_v.func_197967_a(true);
        this.field_224119_f = new BackupObjectSelectionList();
        if (field_224115_b != -1) {
            this.field_224119_f.func_230932_a_(field_224115_b);
        }
        new Thread("Realms-fetch-backups"){

            @Override
            public void run() {
                RealmsClient realmsClient = RealmsClient.func_224911_a();
                try {
                    List<Backup> list = realmsClient.func_224923_d((long)((RealmsBackupScreen)RealmsBackupScreen.this).field_224126_m.field_230582_a_).field_230560_a_;
                    RealmsBackupScreen.this.field_230706_i_.execute(() -> {
                        RealmsBackupScreen.this.field_224117_d = list;
                        RealmsBackupScreen.this.field_224125_l = RealmsBackupScreen.this.field_224117_d.isEmpty();
                        RealmsBackupScreen.this.field_224119_f.func_231409_q_();
                        for (Backup backup : RealmsBackupScreen.this.field_224117_d) {
                            RealmsBackupScreen.this.field_224119_f.func_223867_a(backup);
                        }
                        RealmsBackupScreen.this.func_224112_b();
                    });
                }
                catch (RealmsServiceException realmsServiceException) {
                    field_224114_a.error("Couldn't request backups", (Throwable)realmsServiceException);
                }
            }
        }.start();
        this.field_224122_i = this.func_230480_a_(new Button(this.field_230708_k_ - 135, RealmsBackupScreen.func_239562_k_(1), 120, 20, new TranslationTextComponent("mco.backup.button.download"), button -> this.func_224088_g()));
        this.field_224123_j = this.func_230480_a_(new Button(this.field_230708_k_ - 135, RealmsBackupScreen.func_239562_k_(3), 120, 20, new TranslationTextComponent("mco.backup.button.restore"), button -> this.func_224104_b(this.field_224120_g)));
        this.field_224124_k = this.func_230480_a_(new Button(this.field_230708_k_ - 135, RealmsBackupScreen.func_239562_k_(5), 120, 20, new TranslationTextComponent("mco.backup.changes.tooltip"), button -> {
            this.field_230706_i_.func_147108_a(new RealmsBackupInfoScreen(this, this.field_224117_d.get(this.field_224120_g)));
            this.field_224120_g = -1;
        }));
        this.func_230480_a_(new Button(this.field_230708_k_ - 100, this.field_230709_l_ - 35, 85, 20, DialogTexts.field_240637_h_, button -> this.field_230706_i_.func_147108_a(this.field_224116_c)));
        this.func_230481_d_(this.field_224119_f);
        this.field_224127_n = this.func_230481_d_(new RealmsLabel(new TranslationTextComponent("mco.configure.world.backup"), this.field_230708_k_ / 2, 12, 0xFFFFFF));
        this.func_212932_b(this.field_224119_f);
        this.func_224113_d();
        this.func_231411_u_();
    }

    private void func_224112_b() {
        if (this.field_224117_d.size() <= 1) {
            return;
        }
        for (int i = 0; i < this.field_224117_d.size() - 1; ++i) {
            Backup backup = this.field_224117_d.get(i);
            \u2603 = this.field_224117_d.get(i + 1);
            if (backup.field_230556_d_.isEmpty() || \u2603.field_230556_d_.isEmpty()) continue;
            for (String string : backup.field_230556_d_.keySet()) {
                if (!string.contains("Uploaded") && \u2603.field_230556_d_.containsKey(string)) {
                    if (backup.field_230556_d_.get(string).equals(\u2603.field_230556_d_.get(string))) continue;
                    this.func_224103_a(backup, string);
                    continue;
                }
                this.func_224103_a(backup, string);
            }
        }
    }

    private void func_224103_a(Backup backup, String string) {
        if (string.contains("Uploaded")) {
            \u2603 = DateFormat.getDateTimeInstance(3, 3).format(backup.field_230554_b_);
            backup.field_230557_e_.put(string, \u2603);
            backup.func_230752_a_(true);
        } else {
            backup.field_230557_e_.put(string, backup.field_230556_d_.get(string));
        }
    }

    private void func_224113_d() {
        this.field_224123_j.field_230694_p_ = this.func_224111_f();
        this.field_224124_k.field_230694_p_ = this.func_224096_e();
    }

    private boolean func_224096_e() {
        if (this.field_224120_g == -1) {
            return false;
        }
        return !this.field_224117_d.get((int)this.field_224120_g).field_230557_e_.isEmpty();
    }

    private boolean func_224111_f() {
        if (this.field_224120_g == -1) {
            return false;
        }
        return !this.field_224126_m.field_230591_j_;
    }

    @Override
    public boolean func_231046_a_(int n, int n2, int n3) {
        if (n == 256) {
            this.field_230706_i_.func_147108_a(this.field_224116_c);
            return true;
        }
        return super.func_231046_a_(n, n2, n3);
    }

    private void func_224104_b(int n) {
        if (n >= 0 && n < this.field_224117_d.size() && !this.field_224126_m.field_230591_j_) {
            this.field_224120_g = n;
            Date date = this.field_224117_d.get((int)n).field_230554_b_;
            String \u26032 = DateFormat.getDateTimeInstance(3, 3).format(date);
            String \u26033 = RealmsUtil.func_238105_a_(date);
            TranslationTextComponent \u26034 = new TranslationTextComponent("mco.configure.world.restore.question.line1", \u26032, \u26033);
            TranslationTextComponent \u26035 = new TranslationTextComponent("mco.configure.world.restore.question.line2");
            this.field_230706_i_.func_147108_a(new RealmsLongConfirmationScreen(bl -> {
                if (bl) {
                    this.func_224097_i();
                } else {
                    this.field_224120_g = -1;
                    this.field_230706_i_.func_147108_a(this);
                }
            }, RealmsLongConfirmationScreen.Type.Warning, \u26034, \u26035, true));
        }
    }

    private void func_224088_g() {
        TranslationTextComponent translationTextComponent = new TranslationTextComponent("mco.configure.world.restore.download.question.line1");
        \u2603 = new TranslationTextComponent("mco.configure.world.restore.download.question.line2");
        this.field_230706_i_.func_147108_a(new RealmsLongConfirmationScreen(bl -> {
            if (bl) {
                this.func_224100_h();
            } else {
                this.field_230706_i_.func_147108_a(this);
            }
        }, RealmsLongConfirmationScreen.Type.Info, translationTextComponent, \u2603, true));
    }

    private void func_224100_h() {
        this.field_230706_i_.func_147108_a(new RealmsLongRunningMcoTaskScreen(this.field_224116_c.func_224407_b(), new PrepareDownloadRealmsAction(this.field_224126_m.field_230582_a_, this.field_224121_h, this.field_224126_m.field_230584_c_ + " (" + this.field_224126_m.field_230590_i_.get(this.field_224126_m.field_230595_n_).func_230787_a_(this.field_224126_m.field_230595_n_) + ")", this)));
    }

    private void func_224097_i() {
        Backup backup = this.field_224117_d.get(this.field_224120_g);
        this.field_224120_g = -1;
        this.field_230706_i_.func_147108_a(new RealmsLongRunningMcoTaskScreen(this.field_224116_c.func_224407_b(), new RestoringBackupRealmsAction(backup, this.field_224126_m.field_230582_a_, this.field_224116_c)));
    }

    @Override
    public void func_230430_a_(MatrixStack matrixStack, int n, int n2, float f) {
        this.field_224118_e = null;
        this.func_230446_a_(matrixStack);
        this.field_224119_f.func_230430_a_(matrixStack, n, n2, f);
        this.field_224127_n.func_239560_a_(this, matrixStack);
        this.field_230712_o_.func_238421_b_(matrixStack, I18n.func_135052_a("mco.configure.world.backup", new Object[0]), (this.field_230708_k_ - 150) / 2 - 90, 20.0f, 0xA0A0A0);
        if (this.field_224125_l.booleanValue()) {
            this.field_230712_o_.func_238421_b_(matrixStack, I18n.func_135052_a("mco.backup.nobackups", new Object[0]), 20.0f, this.field_230709_l_ / 2 - 10, 0xFFFFFF);
        }
        this.field_224122_i.field_230693_o_ = this.field_224125_l == false;
        super.func_230430_a_(matrixStack, n, n2, f);
        if (this.field_224118_e != null) {
            this.func_237744_a_(matrixStack, this.field_224118_e, n, n2);
        }
    }

    protected void func_237744_a_(MatrixStack matrixStack, String string, int n, int n2) {
        if (string == null) {
            return;
        }
        \u2603 = n + 12;
        \u2603 = n2 - 12;
        \u2603 = this.field_230712_o_.func_78256_a(string);
        this.func_238468_a_(matrixStack, \u2603 - 3, \u2603 - 3, \u2603 + \u2603 + 3, \u2603 + 8 + 3, -1073741824, -1073741824);
        this.field_230712_o_.func_238405_a_(matrixStack, string, \u2603, \u2603, 0xFFFFFF);
    }

    class BackupObjectSelectionListEntry
    extends ExtendedList.AbstractListEntry<BackupObjectSelectionListEntry> {
        private final Backup field_237765_b_;

        public BackupObjectSelectionListEntry(Backup backup) {
            this.field_237765_b_ = backup;
        }

        @Override
        public void func_230432_a_(MatrixStack matrixStack, int n, int n2, int n3, int n4, int n5, int n6, int n7, boolean bl, float f) {
            this.func_237767_a_(matrixStack, this.field_237765_b_, n3 - 40, n2, n6, n7);
        }

        private void func_237767_a_(MatrixStack matrixStack, Backup backup, int n, int n2, int n3, int n4) {
            \u2603 = backup.func_230749_a_() ? -8388737 : 0xFFFFFF;
            RealmsBackupScreen.this.field_230712_o_.func_238421_b_(matrixStack, "Backup (" + RealmsUtil.func_238105_a_(backup.field_230554_b_) + ")", n + 40, n2 + 1, \u2603);
            RealmsBackupScreen.this.field_230712_o_.func_238421_b_(matrixStack, this.func_223738_a(backup.field_230554_b_), n + 40, n2 + 12, 0x4C4C4C);
            \u2603 = RealmsBackupScreen.this.field_230708_k_ - 175;
            \u2603 = -3;
            \u2603 = \u2603 - 10;
            boolean bl = false;
            if (!((RealmsBackupScreen)RealmsBackupScreen.this).field_224126_m.field_230591_j_) {
                this.func_237766_a_(matrixStack, \u2603, n2 + -3, n3, n4);
            }
            if (!backup.field_230557_e_.isEmpty()) {
                this.func_237768_b_(matrixStack, \u2603, n2 + 0, n3, n4);
            }
        }

        private String func_223738_a(Date date) {
            return DateFormat.getDateTimeInstance(3, 3).format(date);
        }

        private void func_237766_a_(MatrixStack matrixStack, int n, int n2, int n3, int n4) {
            boolean bl = n3 >= n && n3 <= n + 12 && n4 >= n2 && n4 <= n2 + 14 && n4 < RealmsBackupScreen.this.field_230709_l_ - 15 && n4 > 32;
            RealmsBackupScreen.this.field_230706_i_.func_110434_K().func_110577_a(field_237741_c_);
            RenderSystem.color4f(1.0f, 1.0f, 1.0f, 1.0f);
            RenderSystem.pushMatrix();
            RenderSystem.scalef(0.5f, 0.5f, 0.5f);
            float \u26032 = bl ? 28.0f : 0.0f;
            AbstractGui.func_238463_a_(matrixStack, n * 2, n2 * 2, 0.0f, \u26032, 23, 28, 23, 56);
            RenderSystem.popMatrix();
            if (bl) {
                RealmsBackupScreen.this.field_224118_e = I18n.func_135052_a("mco.backup.button.restore", new Object[0]);
            }
        }

        private void func_237768_b_(MatrixStack matrixStack, int n, int n2, int n3, int n4) {
            boolean bl = n3 >= n && n3 <= n + 8 && n4 >= n2 && n4 <= n2 + 8 && n4 < RealmsBackupScreen.this.field_230709_l_ - 15 && n4 > 32;
            RealmsBackupScreen.this.field_230706_i_.func_110434_K().func_110577_a(field_237740_b_);
            RenderSystem.color4f(1.0f, 1.0f, 1.0f, 1.0f);
            RenderSystem.pushMatrix();
            RenderSystem.scalef(0.5f, 0.5f, 0.5f);
            float \u26032 = bl ? 15.0f : 0.0f;
            AbstractGui.func_238463_a_(matrixStack, n * 2, n2 * 2, 0.0f, \u26032, 15, 15, 15, 30);
            RenderSystem.popMatrix();
            if (bl) {
                RealmsBackupScreen.this.field_224118_e = I18n.func_135052_a("mco.backup.changes.tooltip", new Object[0]);
            }
        }
    }

    class BackupObjectSelectionList
    extends RealmsObjectSelectionList<BackupObjectSelectionListEntry> {
        public BackupObjectSelectionList() {
            super(RealmsBackupScreen.this.field_230708_k_ - 150, RealmsBackupScreen.this.field_230709_l_, 32, RealmsBackupScreen.this.field_230709_l_ - 15, 36);
        }

        public void func_223867_a(Backup backup) {
            this.func_230513_b_(new BackupObjectSelectionListEntry(backup));
        }

        @Override
        public int func_230949_c_() {
            return (int)((double)this.field_230670_d_ * 0.93);
        }

        @Override
        public boolean func_230971_aw__() {
            return RealmsBackupScreen.this.func_241217_q_() == this;
        }

        @Override
        public int func_230945_b_() {
            return this.func_230965_k_() * 36;
        }

        @Override
        public void func_230433_a_(MatrixStack matrixStack) {
            RealmsBackupScreen.this.func_230446_a_(matrixStack);
        }

        @Override
        public boolean func_231044_a_(double d, double d2, int n) {
            if (n != 0) {
                return false;
            }
            if (d < (double)this.func_230952_d_() && d2 >= (double)this.field_230672_i_ && d2 <= (double)this.field_230673_j_) {
                \u2603 = this.field_230670_d_ / 2 - 92;
                \u2603 = this.field_230670_d_;
                \u2603 = (int)Math.floor(d2 - (double)this.field_230672_i_) - this.field_230677_n_ + (int)this.func_230966_l_();
                \u2603 = \u2603 / this.field_230669_c_;
                if (d >= (double)\u2603 && d <= (double)\u2603 && \u2603 >= 0 && \u2603 >= 0 && \u2603 < this.func_230965_k_()) {
                    this.func_231400_a_(\u2603);
                    this.func_231401_a_(\u2603, \u2603, d, d2, this.field_230670_d_);
                }
                return true;
            }
            return false;
        }

        @Override
        public int func_230952_d_() {
            return this.field_230670_d_ - 5;
        }

        @Override
        public void func_231401_a_(int n, int n2, double d, double d2, int n3) {
            \u2603 = this.field_230670_d_ - 35;
            \u2603 = n2 * this.field_230669_c_ + 36 - (int)this.func_230966_l_();
            \u2603 = \u2603 + 10;
            \u2603 = \u2603 - 3;
            if (d >= (double)\u2603 && d <= (double)(\u2603 + 9) && d2 >= (double)\u2603 && d2 <= (double)(\u2603 + 9)) {
                if (!((Backup)((RealmsBackupScreen)RealmsBackupScreen.this).field_224117_d.get((int)n2)).field_230557_e_.isEmpty()) {
                    RealmsBackupScreen.this.field_224120_g = -1;
                    field_224115_b = (int)this.func_230966_l_();
                    this.field_230668_b_.func_147108_a(new RealmsBackupInfoScreen(RealmsBackupScreen.this, (Backup)RealmsBackupScreen.this.field_224117_d.get(n2)));
                }
            } else if (d >= (double)\u2603 && d < (double)(\u2603 + 13) && d2 >= (double)\u2603 && d2 < (double)(\u2603 + 15)) {
                field_224115_b = (int)this.func_230966_l_();
                RealmsBackupScreen.this.func_224104_b(n2);
            }
        }

        @Override
        public void func_231400_a_(int n) {
            this.func_239561_k_(n);
            if (n != -1) {
                RealmsNarratorHelper.func_239550_a_(I18n.func_135052_a("narrator.select", ((Backup)((RealmsBackupScreen)RealmsBackupScreen.this).field_224117_d.get((int)n)).field_230554_b_.toString()));
            }
            this.func_223866_a(n);
        }

        public void func_223866_a(int n) {
            RealmsBackupScreen.this.field_224120_g = n;
            RealmsBackupScreen.this.func_224113_d();
        }

        @Override
        public void func_241215_a_(@Nullable BackupObjectSelectionListEntry backupObjectSelectionListEntry) {
            super.func_241215_a_(backupObjectSelectionListEntry);
            RealmsBackupScreen.this.field_224120_g = this.func_231039_at__().indexOf(backupObjectSelectionListEntry);
            RealmsBackupScreen.this.func_224113_d();
        }
    }
}

