/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.realmsclient.client;

import com.google.common.hash.Hashing;
import com.google.common.io.Files;
import com.mojang.realmsclient.dto.WorldDownload;
import com.mojang.realmsclient.exception.RealmsDefaultUncaughtExceptionHandler;
import com.mojang.realmsclient.gui.screens.RealmsDownloadLatestWorldScreen;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Path;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.util.SharedConstants;
import net.minecraft.world.storage.FolderName;
import net.minecraft.world.storage.SaveFormat;
import net.minecraft.world.storage.WorldSummary;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.CountingOutputStream;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FileDownload {
    private static final Logger field_224843_a = LogManager.getLogger();
    private volatile boolean field_224844_b;
    private volatile boolean field_224845_c;
    private volatile boolean field_224846_d;
    private volatile boolean field_224847_e;
    private volatile File field_224848_f;
    private volatile File field_224849_g;
    private volatile HttpGet field_224850_h;
    private Thread field_224851_i;
    private final RequestConfig field_224852_j = RequestConfig.custom().setSocketTimeout(120000).setConnectTimeout(120000).build();
    private static final String[] field_224853_k = new String[]{"CON", "COM", "PRN", "AUX", "CLOCK$", "NUL", "COM1", "COM2", "COM3", "COM4", "COM5", "COM6", "COM7", "COM8", "COM9", "LPT1", "LPT2", "LPT3", "LPT4", "LPT5", "LPT6", "LPT7", "LPT8", "LPT9"};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long func_224827_a(String string) {
        CloseableHttpClient closeableHttpClient = null;
        HttpGet \u26032 = null;
        try {
            \u26032 = new HttpGet(string);
            closeableHttpClient = HttpClientBuilder.create().setDefaultRequestConfig(this.field_224852_j).build();
            CloseableHttpResponse closeableHttpResponse = closeableHttpClient.execute((HttpUriRequest)\u26032);
            long l = Long.parseLong(closeableHttpResponse.getFirstHeader("Content-Length").getValue());
            return l;
        }
        catch (Throwable throwable) {
            field_224843_a.error("Unable to get content length for download");
            long l = 0L;
            return l;
        }
        finally {
            if (\u26032 != null) {
                \u26032.releaseConnection();
            }
            if (closeableHttpClient != null) {
                try {
                    closeableHttpClient.close();
                }
                catch (IOException iOException) {
                    field_224843_a.error("Could not close http client", (Throwable)iOException);
                }
            }
        }
    }

    public void func_237688_a_(WorldDownload worldDownload, String string, RealmsDownloadLatestWorldScreen.DownloadStatus downloadStatus, SaveFormat saveFormat) {
        if (this.field_224851_i != null) {
            return;
        }
        this.field_224851_i = new Thread(() -> {
            CloseableHttpClient closeableHttpClient = null;
            try {
                this.field_224848_f = File.createTempFile("backup", ".tar.gz");
                this.field_224850_h = new HttpGet(worldDownload.field_230643_a_);
                closeableHttpClient = HttpClientBuilder.create().setDefaultRequestConfig(this.field_224852_j).build();
                CloseableHttpResponse closeableHttpResponse = closeableHttpClient.execute((HttpUriRequest)this.field_224850_h);
                downloadStatus.field_225140_b = Long.parseLong(closeableHttpResponse.getFirstHeader("Content-Length").getValue());
                if (closeableHttpResponse.getStatusLine().getStatusCode() != 200) {
                    this.field_224846_d = true;
                    this.field_224850_h.abort();
                    return;
                }
                FileOutputStream \u26032 = new FileOutputStream(this.field_224848_f);
                ActionListener \u26033 = new ProgressListener(string.trim(), this.field_224848_f, saveFormat, downloadStatus);
                DownloadCountingOutputStream \u26034 = new DownloadCountingOutputStream(\u26032);
                \u26034.func_224804_a(\u26033);
                IOUtils.copy((InputStream)closeableHttpResponse.getEntity().getContent(), (OutputStream)((Object)\u26034));
                return;
            }
            catch (Exception exception) {
                field_224843_a.error("Caught exception while downloading: " + exception.getMessage());
                this.field_224846_d = true;
                return;
            }
            finally {
                block40: {
                    block41: {
                        this.field_224850_h.releaseConnection();
                        if (this.field_224848_f != null) {
                            this.field_224848_f.delete();
                        }
                        if (this.field_224846_d) break block40;
                        if (worldDownload.field_230644_b_.isEmpty() || worldDownload.field_230645_c_.isEmpty()) break block41;
                        try {
                            this.field_224848_f = File.createTempFile("resources", ".tar.gz");
                            this.field_224850_h = new HttpGet(worldDownload.field_230644_b_);
                            CloseableHttpResponse closeableHttpResponse = closeableHttpClient.execute((HttpUriRequest)this.field_224850_h);
                            downloadStatus.field_225140_b = Long.parseLong(closeableHttpResponse.getFirstHeader("Content-Length").getValue());
                            if (closeableHttpResponse.getStatusLine().getStatusCode() != 200) {
                                this.field_224846_d = true;
                                this.field_224850_h.abort();
                                return;
                            }
                        }
                        catch (Exception exception) {
                            field_224843_a.error("Caught exception while downloading: " + exception.getMessage());
                            this.field_224846_d = true;
                        }
                        FileOutputStream fileOutputStream = new FileOutputStream(this.field_224848_f);
                        ResourcePackProgressListener \u26035 = new ResourcePackProgressListener(this.field_224848_f, downloadStatus, worldDownload);
                        DownloadCountingOutputStream \u26036 = new DownloadCountingOutputStream(fileOutputStream);
                        \u26036.func_224804_a(\u26035);
                        IOUtils.copy((InputStream)closeableHttpResponse.getEntity().getContent(), (OutputStream)((Object)\u26036));
                        break block40;
                        finally {
                            this.field_224850_h.releaseConnection();
                            if (this.field_224848_f != null) {
                                this.field_224848_f.delete();
                            }
                        }
                    }
                    this.field_224845_c = true;
                }
                if (closeableHttpClient != null) {
                    try {
                        closeableHttpClient.close();
                    }
                    catch (IOException iOException) {
                        field_224843_a.error("Failed to close Realms download client");
                    }
                }
            }
        });
        this.field_224851_i.setUncaughtExceptionHandler(new RealmsDefaultUncaughtExceptionHandler(field_224843_a));
        this.field_224851_i.start();
    }

    public void func_224834_a() {
        if (this.field_224850_h != null) {
            this.field_224850_h.abort();
        }
        if (this.field_224848_f != null) {
            this.field_224848_f.delete();
        }
        this.field_224844_b = true;
    }

    public boolean func_224835_b() {
        return this.field_224845_c;
    }

    public boolean func_224836_c() {
        return this.field_224846_d;
    }

    public boolean func_224837_d() {
        return this.field_224847_e;
    }

    public static String func_224828_b(String string) {
        string = string.replaceAll("[\\./\"]", "_");
        for (String string2 : field_224853_k) {
            if (!string.equalsIgnoreCase(string2)) continue;
            string = "_" + string + "_";
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void func_237690_a_(String string2, File file, SaveFormat saveFormat) throws IOException {
        block66: {
            boolean \u26034;
            String string2;
            int \u26032;
            block67: {
                block65: {
                    Pattern pattern = Pattern.compile(".*-([0-9]+)$");
                    \u26032 = 1;
                    Object object = SharedConstants.field_71567_b;
                    int n = ((char[])object).length;
                    for (int n2 = 0; n2 < n; string2 = string2.replace(c, '_'), ++n2) {
                        char c = object[n2];
                    }
                    if (StringUtils.isEmpty((CharSequence)string2)) {
                        string2 = "Realm";
                    }
                    string2 = FileDownload.func_224828_b(string2);
                    try {
                        object = saveFormat.func_75799_b().iterator();
                        while (object.hasNext()) {
                            WorldSummary worldSummary = (WorldSummary)object.next();
                            if (!worldSummary.func_75786_a().toLowerCase(Locale.ROOT).startsWith(string2.toLowerCase(Locale.ROOT))) continue;
                            Matcher \u26033 = pattern.matcher(worldSummary.func_75786_a());
                            if (\u26033.matches()) {
                                if (Integer.valueOf(\u26033.group(1)) <= \u26032) continue;
                                \u26032 = Integer.valueOf(\u26033.group(1));
                                continue;
                            }
                            ++\u26032;
                        }
                    }
                    catch (Exception exception) {
                        field_224843_a.error("Error getting level list", (Throwable)exception);
                        this.field_224846_d = true;
                        return;
                    }
                    if (saveFormat.func_207742_d(string2) && \u26032 <= true) break block65;
                    String string3 = string2 + (\u26032 == 1 ? "" : "-" + \u26032);
                    if (saveFormat.func_207742_d(string3)) break block66;
                    \u26034 = false;
                    break block67;
                }
                string3 = string2;
                break block66;
            }
            while (!\u26034) {
                string3 = string2 + (++\u26032 == 1 ? "" : "-" + \u26032);
                if (!saveFormat.func_207742_d(string3)) continue;
                \u26034 = true;
            }
        }
        TarArchiveInputStream tarArchiveInputStream = null;
        File \u26035 = new File(Minecraft.func_71410_x().field_71412_D.getAbsolutePath(), "saves");
        try {
            \u26035.mkdir();
            tarArchiveInputStream = new TarArchiveInputStream((InputStream)new GzipCompressorInputStream((InputStream)new BufferedInputStream(new FileInputStream(file))));
            Object \u26036 = tarArchiveInputStream.getNextTarEntry();
            while (\u26036 != null) {
                File file2 = new File(\u26035, \u26036.getName().replace("world", string3));
                if (\u26036.isDirectory()) {
                    file2.mkdirs();
                } else {
                    file2.createNewFile();
                    try (FileOutputStream fileOutputStream = new FileOutputStream(file2);){
                        IOUtils.copy((InputStream)tarArchiveInputStream, (OutputStream)fileOutputStream);
                    }
                }
                \u26036 = tarArchiveInputStream.getNextTarEntry();
            }
            return;
        }
        catch (Exception exception) {
            field_224843_a.error("Error extracting world", (Throwable)exception);
            this.field_224846_d = true;
            return;
        }
        finally {
            if (tarArchiveInputStream != null) {
                tarArchiveInputStream.close();
            }
            if (file != null) {
                file.delete();
            }
            try (SaveFormat.LevelSave levelSave = saveFormat.func_237274_c_(string3);){
                levelSave.func_237290_a_(string3.trim());
                Path path = levelSave.func_237285_a_(FolderName.field_237249_e_);
                FileDownload.func_237689_a_(path.toFile());
            }
            catch (IOException iOException) {
                field_224843_a.error("Failed to rename unpacked realms level {}", (Object)string3, (Object)iOException);
            }
            this.field_224849_g = new File(\u26035, string3 + File.separator + "resources.zip");
        }
    }

    private static void func_237689_a_(File file) {
        if (file.exists()) {
            try {
                CompoundNBT compoundNBT = CompressedStreamTools.func_74796_a(new FileInputStream(file));
                \u2603 = compoundNBT.func_74775_l("Data");
                \u2603.func_82580_o("Player");
                CompressedStreamTools.func_74799_a(compoundNBT, new FileOutputStream(file));
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    class DownloadCountingOutputStream
    extends CountingOutputStream {
        private ActionListener field_224806_b;

        public DownloadCountingOutputStream(OutputStream outputStream) {
            super(outputStream);
        }

        public void func_224804_a(ActionListener actionListener) {
            this.field_224806_b = actionListener;
        }

        protected void afterWrite(int n) throws IOException {
            super.afterWrite(n);
            if (this.field_224806_b != null) {
                this.field_224806_b.actionPerformed(new ActionEvent((Object)this, 0, null));
            }
        }
    }

    class ResourcePackProgressListener
    implements ActionListener {
        private final File field_224819_b;
        private final RealmsDownloadLatestWorldScreen.DownloadStatus field_224820_c;
        private final WorldDownload field_224821_d;

        private ResourcePackProgressListener(File file, RealmsDownloadLatestWorldScreen.DownloadStatus downloadStatus, WorldDownload worldDownload) {
            this.field_224819_b = file;
            this.field_224820_c = downloadStatus;
            this.field_224821_d = worldDownload;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.field_224820_c.field_225139_a = ((DownloadCountingOutputStream)((Object)actionEvent.getSource())).getByteCount();
            if (this.field_224820_c.field_225139_a >= this.field_224820_c.field_225140_b && !FileDownload.this.field_224844_b) {
                try {
                    String string = Hashing.sha1().hashBytes(Files.toByteArray((File)this.field_224819_b)).toString();
                    if (string.equals(this.field_224821_d.field_230645_c_)) {
                        FileUtils.copyFile((File)this.field_224819_b, (File)FileDownload.this.field_224849_g);
                        FileDownload.this.field_224845_c = true;
                    } else {
                        field_224843_a.error("Resourcepack had wrong hash (expected " + this.field_224821_d.field_230645_c_ + ", found " + string + "). Deleting it.");
                        FileUtils.deleteQuietly((File)this.field_224819_b);
                        FileDownload.this.field_224846_d = true;
                    }
                }
                catch (IOException iOException) {
                    field_224843_a.error("Error copying resourcepack file", (Object)iOException.getMessage());
                    FileDownload.this.field_224846_d = true;
                }
            }
        }
    }

    class ProgressListener
    implements ActionListener {
        private final String field_224813_b;
        private final File field_224814_c;
        private final SaveFormat field_224815_d;
        private final RealmsDownloadLatestWorldScreen.DownloadStatus field_224816_e;

        private ProgressListener(String string, File file, SaveFormat saveFormat, RealmsDownloadLatestWorldScreen.DownloadStatus downloadStatus) {
            this.field_224813_b = string;
            this.field_224814_c = file;
            this.field_224815_d = saveFormat;
            this.field_224816_e = downloadStatus;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.field_224816_e.field_225139_a = ((DownloadCountingOutputStream)((Object)actionEvent.getSource())).getByteCount();
            if (this.field_224816_e.field_225139_a >= this.field_224816_e.field_225140_b && !FileDownload.this.field_224844_b && !FileDownload.this.field_224846_d) {
                try {
                    FileDownload.this.field_224847_e = true;
                    FileDownload.this.func_237690_a_(this.field_224813_b, this.field_224814_c, this.field_224815_d);
                }
                catch (IOException iOException) {
                    field_224843_a.error("Error extracting archive", (Throwable)iOException);
                    FileDownload.this.field_224846_d = true;
                }
            }
        }
    }
}

