/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.realmsclient;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.RateLimiter;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.realmsclient.client.Ping;
import com.mojang.realmsclient.client.RealmsClient;
import com.mojang.realmsclient.dto.PingResult;
import com.mojang.realmsclient.dto.RealmsServer;
import com.mojang.realmsclient.dto.RealmsServerPlayerList;
import com.mojang.realmsclient.dto.RealmsServerPlayerLists;
import com.mojang.realmsclient.dto.RegionPingResult;
import com.mojang.realmsclient.exception.RealmsServiceException;
import com.mojang.realmsclient.gui.RealmsDataFetcher;
import com.mojang.realmsclient.gui.screens.RealmsClientOutdatedScreen;
import com.mojang.realmsclient.gui.screens.RealmsConfigureWorldScreen;
import com.mojang.realmsclient.gui.screens.RealmsCreateRealmScreen;
import com.mojang.realmsclient.gui.screens.RealmsGenericErrorScreen;
import com.mojang.realmsclient.gui.screens.RealmsLongConfirmationScreen;
import com.mojang.realmsclient.gui.screens.RealmsLongRunningMcoTaskScreen;
import com.mojang.realmsclient.gui.screens.RealmsParentalConsentScreen;
import com.mojang.realmsclient.gui.screens.RealmsPendingInvitesScreen;
import com.mojang.realmsclient.util.RealmsPersistence;
import com.mojang.realmsclient.util.RealmsTextureManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.DialogTexts;
import net.minecraft.client.gui.screen.IScreen;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.gui.widget.list.AbstractList;
import net.minecraft.client.gui.widget.list.ExtendedList;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.KeyCombo;
import net.minecraft.realms.RealmsNarratorHelper;
import net.minecraft.realms.RealmsObjectSelectionList;
import net.minecraft.realms.RealmsScreen;
import net.minecraft.realms.action.ConnectingToRealmsAction;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RealmsMainScreen
extends RealmsScreen {
    private static final Logger field_224012_a = LogManager.getLogger();
    private static final ResourceLocation field_237540_b_ = new ResourceLocation("realms", "textures/gui/realms/on_icon.png");
    private static final ResourceLocation field_237541_c_ = new ResourceLocation("realms", "textures/gui/realms/off_icon.png");
    private static final ResourceLocation field_237542_p_ = new ResourceLocation("realms", "textures/gui/realms/expired_icon.png");
    private static final ResourceLocation field_237543_q_ = new ResourceLocation("realms", "textures/gui/realms/expires_soon_icon.png");
    private static final ResourceLocation field_237544_r_ = new ResourceLocation("realms", "textures/gui/realms/leave_icon.png");
    private static final ResourceLocation field_237545_s_ = new ResourceLocation("realms", "textures/gui/realms/invitation_icons.png");
    private static final ResourceLocation field_237546_t_ = new ResourceLocation("realms", "textures/gui/realms/invite_icon.png");
    private static final ResourceLocation field_237547_u_ = new ResourceLocation("realms", "textures/gui/realms/world_icon.png");
    private static final ResourceLocation field_237548_v_ = new ResourceLocation("realms", "textures/gui/title/realms.png");
    private static final ResourceLocation field_237549_w_ = new ResourceLocation("realms", "textures/gui/realms/configure_icon.png");
    private static final ResourceLocation field_237550_x_ = new ResourceLocation("realms", "textures/gui/realms/questionmark.png");
    private static final ResourceLocation field_237551_y_ = new ResourceLocation("realms", "textures/gui/realms/news_icon.png");
    private static final ResourceLocation field_237552_z_ = new ResourceLocation("realms", "textures/gui/realms/popup.png");
    private static final ResourceLocation field_237534_A_ = new ResourceLocation("realms", "textures/gui/realms/darken.png");
    private static final ResourceLocation field_237535_B_ = new ResourceLocation("realms", "textures/gui/realms/cross_icon.png");
    private static final ResourceLocation field_237536_C_ = new ResourceLocation("realms", "textures/gui/realms/trial_icon.png");
    private static final ResourceLocation field_237537_D_ = new ResourceLocation("minecraft", "textures/gui/widgets.png");
    private static List<ResourceLocation> field_227918_e_ = ImmutableList.of();
    private static final RealmsDataFetcher field_224017_f = new RealmsDataFetcher();
    private static boolean field_224013_b;
    private static int field_224018_g;
    private static volatile boolean field_224031_t;
    private static volatile boolean field_224032_u;
    private static volatile boolean field_224033_v;
    private static Screen field_224000_H;
    private static boolean field_224001_I;
    private final RateLimiter field_224014_c;
    private boolean field_224015_d;
    private final Screen field_224019_h;
    private volatile ServerList field_224020_i;
    private long field_224021_j = -1L;
    private Button field_224022_k;
    private Button field_224023_l;
    private Button field_224024_m;
    private Button field_224025_n;
    private Button field_224026_o;
    private List<ITextComponent> field_224027_p;
    private List<RealmsServer> field_224028_q = Lists.newArrayList();
    private volatile int field_224029_r;
    private int field_224030_s;
    private boolean field_224034_w;
    private boolean field_224035_x;
    private boolean field_224036_y;
    private volatile boolean field_224037_z;
    private volatile boolean field_223993_A;
    private volatile boolean field_223994_B;
    private volatile boolean field_223995_C;
    private volatile String field_223996_D;
    private int field_223997_E;
    private int field_223998_F;
    private boolean field_223999_G;
    private List<KeyCombo> field_224002_J;
    private int field_224003_K;
    private ReentrantLock field_224004_L = new ReentrantLock();
    private ServerState field_237539_ap_;
    private Button field_224006_N;
    private Button field_224007_O;
    private Button field_224008_P;
    private Button field_224009_Q;
    private Button field_224010_R;
    private Button field_224011_S;

    public RealmsMainScreen(Screen screen) {
        this.field_224019_h = screen;
        this.field_224014_c = RateLimiter.create((double)0.01666666753590107);
    }

    private boolean func_223928_a() {
        if (!RealmsMainScreen.func_223968_l() || !this.field_224034_w) {
            return false;
        }
        if (this.field_224037_z && !this.field_223993_A) {
            return true;
        }
        for (RealmsServer realmsServer : this.field_224028_q) {
            if (!realmsServer.field_230588_g_.equals(this.field_230706_i_.func_110432_I().func_148255_b())) continue;
            return false;
        }
        return true;
    }

    public boolean func_223990_b() {
        if (!RealmsMainScreen.func_223968_l() || !this.field_224034_w) {
            return false;
        }
        if (this.field_224035_x) {
            return true;
        }
        if (this.field_224037_z && !this.field_223993_A && this.field_224028_q.isEmpty()) {
            return true;
        }
        return this.field_224028_q.isEmpty();
    }

    @Override
    public void func_231160_c_() {
        this.field_224002_J = Lists.newArrayList((Object[])new KeyCombo[]{new KeyCombo(new char[]{'3', '2', '1', '4', '5', '6'}, () -> {
            field_224013_b = !field_224013_b;
        }), new KeyCombo(new char[]{'9', '8', '7', '1', '2', '3'}, () -> {
            if (RealmsClient.field_224944_a == RealmsClient.Environment.STAGE) {
                this.func_223973_x();
            } else {
                this.func_223884_v();
            }
        }), new KeyCombo(new char[]{'9', '8', '7', '4', '5', '6'}, () -> {
            if (RealmsClient.field_224944_a == RealmsClient.Environment.LOCAL) {
                this.func_223973_x();
            } else {
                this.func_223962_w();
            }
        })});
        if (field_224000_H != null) {
            this.field_230706_i_.func_147108_a(field_224000_H);
            return;
        }
        this.field_224004_L = new ReentrantLock();
        if (field_224033_v && !RealmsMainScreen.func_223968_l()) {
            this.func_223975_u();
        }
        this.func_223895_s();
        this.func_223965_t();
        if (!this.field_224015_d) {
            this.field_230706_i_.func_181537_a(false);
        }
        this.field_230706_i_.field_195559_v.func_197967_a(true);
        if (RealmsMainScreen.func_223968_l()) {
            field_224017_f.func_225087_d();
        }
        this.field_223994_B = false;
        if (RealmsMainScreen.func_223968_l() && this.field_224034_w) {
            this.func_223901_c();
        }
        this.field_224020_i = new ServerList();
        if (field_224018_g != -1) {
            this.field_224020_i.func_230932_a_(field_224018_g);
        }
        this.func_230481_d_(this.field_224020_i);
        this.func_212932_b(this.field_224020_i);
    }

    private static boolean func_223968_l() {
        return field_224032_u && field_224031_t;
    }

    public void func_223901_c() {
        this.field_224025_n = this.func_230480_a_(new Button(this.field_230708_k_ / 2 - 190, this.field_230709_l_ - 32, 90, 20, new TranslationTextComponent("mco.selectServer.configure"), button -> this.func_223966_f(this.func_223967_a(this.field_224021_j))));
        this.field_224022_k = this.func_230480_a_(new Button(this.field_230708_k_ / 2 - 93, this.field_230709_l_ - 32, 90, 20, new TranslationTextComponent("mco.selectServer.play"), button -> {
            RealmsServer realmsServer = this.func_223967_a(this.field_224021_j);
            if (realmsServer == null) {
                return;
            }
            this.func_223911_a(realmsServer, this);
        }));
        this.field_224023_l = this.func_230480_a_(new Button(this.field_230708_k_ / 2 + 4, this.field_230709_l_ - 32, 90, 20, DialogTexts.field_240637_h_, button -> {
            if (!this.field_224036_y) {
                this.field_230706_i_.func_147108_a(this.field_224019_h);
            }
        }));
        this.field_224024_m = this.func_230480_a_(new Button(this.field_230708_k_ / 2 + 100, this.field_230709_l_ - 32, 90, 20, new TranslationTextComponent("mco.selectServer.expiredRenew"), button -> this.func_223930_q()));
        this.field_224026_o = this.func_230480_a_(new Button(this.field_230708_k_ / 2 - 202, this.field_230709_l_ - 32, 90, 20, new TranslationTextComponent("mco.selectServer.leave"), button -> this.func_223906_g(this.func_223967_a(this.field_224021_j))));
        this.field_224007_O = this.func_230480_a_(new PendingInvitesButton());
        this.field_224008_P = this.func_230480_a_(new NewsButton());
        this.field_224006_N = this.func_230480_a_(new InfoButton());
        this.field_224011_S = this.func_230480_a_(new CloseButton());
        this.field_224009_Q = this.func_230480_a_(new Button(this.field_230708_k_ / 2 + 52, this.func_223932_C() + 137 - 20, 98, 20, new TranslationTextComponent("mco.selectServer.trial"), button -> {
            if (!this.field_224037_z || this.field_223993_A) {
                return;
            }
            Util.func_110647_a().func_195640_a("https://aka.ms/startjavarealmstrial");
            this.field_230706_i_.func_147108_a(this.field_224019_h);
        }));
        this.field_224010_R = this.func_230480_a_(new Button(this.field_230708_k_ / 2 + 52, this.func_223932_C() + 160 - 20, 98, 20, new TranslationTextComponent("mco.selectServer.buy"), button -> Util.func_110647_a().func_195640_a("https://aka.ms/BuyJavaRealms")));
        RealmsServer realmsServer = this.func_223967_a(this.field_224021_j);
        this.func_223915_a(realmsServer);
    }

    private void func_223915_a(@Nullable RealmsServer realmsServer) {
        this.field_224022_k.field_230693_o_ = this.func_223897_b(realmsServer) && !this.func_223990_b();
        this.field_224024_m.field_230694_p_ = this.func_223920_c(realmsServer);
        this.field_224025_n.field_230694_p_ = this.func_223941_d(realmsServer);
        this.field_224026_o.field_230694_p_ = this.func_223959_e(realmsServer);
        this.field_224009_Q.field_230694_p_ = \u2603 = this.func_223990_b() && this.field_224037_z && !this.field_223993_A;
        this.field_224009_Q.field_230693_o_ = \u2603;
        this.field_224010_R.field_230694_p_ = this.func_223990_b();
        this.field_224011_S.field_230694_p_ = this.func_223990_b() && this.field_224035_x;
        this.field_224024_m.field_230693_o_ = !this.func_223990_b();
        this.field_224025_n.field_230693_o_ = !this.func_223990_b();
        this.field_224026_o.field_230693_o_ = !this.func_223990_b();
        this.field_224008_P.field_230693_o_ = true;
        this.field_224007_O.field_230693_o_ = true;
        this.field_224023_l.field_230693_o_ = true;
        this.field_224006_N.field_230693_o_ = !this.func_223990_b();
    }

    private boolean func_223977_m() {
        return (!this.func_223990_b() || this.field_224035_x) && RealmsMainScreen.func_223968_l() && this.field_224034_w;
    }

    private boolean func_223897_b(@Nullable RealmsServer realmsServer) {
        return realmsServer != null && !realmsServer.field_230591_j_ && realmsServer.field_230586_e_ == RealmsServer.Status.OPEN;
    }

    private boolean func_223920_c(@Nullable RealmsServer realmsServer) {
        return realmsServer != null && realmsServer.field_230591_j_ && this.func_223885_h(realmsServer);
    }

    private boolean func_223941_d(@Nullable RealmsServer realmsServer) {
        return realmsServer != null && this.func_223885_h(realmsServer);
    }

    private boolean func_223959_e(@Nullable RealmsServer realmsServer) {
        return realmsServer != null && !this.func_223885_h(realmsServer);
    }

    @Override
    public void func_231023_e_() {
        Object object;
        super.func_231023_e_();
        this.field_224036_y = false;
        ++this.field_224030_s;
        --this.field_224003_K;
        if (this.field_224003_K < 0) {
            this.field_224003_K = 0;
        }
        if (!RealmsMainScreen.func_223968_l()) {
            return;
        }
        field_224017_f.func_225086_b();
        if (field_224017_f.func_225083_a(RealmsDataFetcher.Task.SERVER_LIST)) {
            object = field_224017_f.func_225078_e();
            this.field_224020_i.func_231409_q_();
            boolean bl = \u2603 = !this.field_224034_w;
            if (\u2603) {
                this.field_224034_w = true;
            }
            if (object != null) {
                boolean \u26032 = false;
                Iterator<Object> iterator = object.iterator();
                while (iterator.hasNext()) {
                    RealmsServer realmsServer = (RealmsServer)iterator.next();
                    if (!this.func_223991_i(realmsServer)) continue;
                    \u26032 = true;
                }
                this.field_224028_q = object;
                if (this.func_223928_a()) {
                    this.field_224020_i.func_241825_a_(new TrialServerEntry());
                }
                for (RealmsServer realmsServer : this.field_224028_q) {
                    this.field_224020_i.func_230513_b_(new ServerEntry(realmsServer));
                }
                if (!field_224001_I && \u26032) {
                    field_224001_I = true;
                    this.func_223944_n();
                }
            }
            if (\u2603) {
                this.func_223901_c();
            }
        }
        if (field_224017_f.func_225083_a(RealmsDataFetcher.Task.PENDING_INVITE)) {
            this.field_224029_r = field_224017_f.func_225081_f();
            if (this.field_224029_r > 0 && this.field_224014_c.tryAcquire(1)) {
                RealmsNarratorHelper.func_239550_a_(I18n.func_135052_a("mco.configure.world.invite.narration", this.field_224029_r));
            }
        }
        if (field_224017_f.func_225083_a(RealmsDataFetcher.Task.TRIAL_AVAILABLE) && !this.field_223993_A) {
            boolean bl = field_224017_f.func_225071_g();
            if (bl != this.field_224037_z && this.func_223990_b()) {
                this.field_224037_z = bl;
                this.field_223994_B = false;
            } else {
                this.field_224037_z = bl;
            }
        }
        if (field_224017_f.func_225083_a(RealmsDataFetcher.Task.LIVE_STATS)) {
            object = field_224017_f.func_225079_h();
            block2: for (RealmsServerPlayerList realmsServerPlayerList : ((RealmsServerPlayerLists)object).field_230612_a_) {
                for (RealmsServer realmsServer : this.field_224028_q) {
                    if (realmsServer.field_230582_a_ != realmsServerPlayerList.field_230609_a_) continue;
                    realmsServer.func_230772_a_(realmsServerPlayerList);
                    continue block2;
                }
            }
        }
        if (field_224017_f.func_225083_a(RealmsDataFetcher.Task.UNREAD_NEWS)) {
            this.field_223995_C = field_224017_f.func_225059_i();
            this.field_223996_D = field_224017_f.func_225063_j();
        }
        field_224017_f.func_225072_c();
        if (this.func_223990_b()) {
            ++this.field_223998_F;
        }
        if (this.field_224006_N != null) {
            this.field_224006_N.field_230694_p_ = this.func_223977_m();
        }
    }

    private void func_223944_n() {
        new Thread(() -> {
            List<RegionPingResult> list = Ping.func_224864_a();
            RealmsClient \u26032 = RealmsClient.func_224911_a();
            PingResult \u26033 = new PingResult();
            \u26033.field_230571_a_ = list;
            \u26033.field_230572_b_ = this.func_223952_o();
            try {
                \u26032.func_224903_a(\u26033);
            }
            catch (Throwable \u26034) {
                field_224012_a.warn("Could not send ping result to Realms: ", \u26034);
            }
        }).start();
    }

    private List<Long> func_223952_o() {
        ArrayList arrayList = Lists.newArrayList();
        for (RealmsServer realmsServer : this.field_224028_q) {
            if (!this.func_223991_i(realmsServer)) continue;
            arrayList.add(realmsServer.field_230582_a_);
        }
        return arrayList;
    }

    @Override
    public void func_231164_f_() {
        this.field_230706_i_.field_195559_v.func_197967_a(false);
        this.func_223939_y();
    }

    private void func_223930_q() {
        RealmsServer realmsServer = this.func_223967_a(this.field_224021_j);
        if (realmsServer == null) {
            return;
        }
        String \u26032 = "https://aka.ms/ExtendJavaRealms?subscriptionId=" + realmsServer.field_230583_b_ + "&profileId=" + this.field_230706_i_.func_110432_I().func_148255_b() + "&ref=" + (realmsServer.field_230592_k_ ? "expiredTrial" : "expiredRealm");
        this.field_230706_i_.field_195559_v.func_197960_a(\u26032);
        Util.func_110647_a().func_195640_a(\u26032);
    }

    private void func_223895_s() {
        if (!field_224033_v) {
            field_224033_v = true;
            new Thread("MCO Compatability Checker #1"){

                @Override
                public void run() {
                    RealmsClient realmsClient = RealmsClient.func_224911_a();
                    try {
                        RealmsClient.CompatibleVersionResponse compatibleVersionResponse = realmsClient.func_224939_i();
                        if (compatibleVersionResponse == RealmsClient.CompatibleVersionResponse.OUTDATED) {
                            field_224000_H = new RealmsClientOutdatedScreen(RealmsMainScreen.this.field_224019_h, true);
                            RealmsMainScreen.this.field_230706_i_.execute(() -> RealmsMainScreen.this.field_230706_i_.func_147108_a(field_224000_H));
                            return;
                        }
                        if (compatibleVersionResponse == RealmsClient.CompatibleVersionResponse.OTHER) {
                            field_224000_H = new RealmsClientOutdatedScreen(RealmsMainScreen.this.field_224019_h, false);
                            RealmsMainScreen.this.field_230706_i_.execute(() -> RealmsMainScreen.this.field_230706_i_.func_147108_a(field_224000_H));
                            return;
                        }
                        RealmsMainScreen.this.func_223975_u();
                    }
                    catch (RealmsServiceException realmsServiceException) {
                        field_224033_v = false;
                        field_224012_a.error("Couldn't connect to realms", (Throwable)realmsServiceException);
                        if (realmsServiceException.field_224981_a == 401) {
                            field_224000_H = new RealmsGenericErrorScreen(new TranslationTextComponent("mco.error.invalid.session.title"), new TranslationTextComponent("mco.error.invalid.session.message"), RealmsMainScreen.this.field_224019_h);
                            RealmsMainScreen.this.field_230706_i_.execute(() -> RealmsMainScreen.this.field_230706_i_.func_147108_a(field_224000_H));
                        }
                        RealmsMainScreen.this.field_230706_i_.execute(() -> RealmsMainScreen.this.field_230706_i_.func_147108_a(new RealmsGenericErrorScreen(realmsServiceException, RealmsMainScreen.this.field_224019_h)));
                    }
                }
            }.start();
        }
    }

    private void func_223965_t() {
    }

    private void func_223975_u() {
        new Thread("MCO Compatability Checker #1"){

            @Override
            public void run() {
                RealmsClient realmsClient = RealmsClient.func_224911_a();
                try {
                    Boolean bl = realmsClient.func_224918_g();
                    if (bl.booleanValue()) {
                        field_224012_a.info("Realms is available for this user");
                        field_224031_t = true;
                    } else {
                        field_224012_a.info("Realms is not available for this user");
                        field_224031_t = false;
                        RealmsMainScreen.this.field_230706_i_.execute(() -> RealmsMainScreen.this.field_230706_i_.func_147108_a(new RealmsParentalConsentScreen(RealmsMainScreen.this.field_224019_h)));
                    }
                    field_224032_u = true;
                }
                catch (RealmsServiceException realmsServiceException) {
                    field_224012_a.error("Couldn't connect to realms", (Throwable)realmsServiceException);
                    RealmsMainScreen.this.field_230706_i_.execute(() -> RealmsMainScreen.this.field_230706_i_.func_147108_a(new RealmsGenericErrorScreen(realmsServiceException, RealmsMainScreen.this.field_224019_h)));
                }
            }
        }.start();
    }

    private void func_223884_v() {
        if (RealmsClient.field_224944_a != RealmsClient.Environment.STAGE) {
            new Thread("MCO Stage Availability Checker #1"){

                @Override
                public void run() {
                    RealmsClient realmsClient = RealmsClient.func_224911_a();
                    try {
                        Boolean bl = realmsClient.func_224931_h();
                        if (bl.booleanValue()) {
                            RealmsClient.func_224940_b();
                            field_224012_a.info("Switched to stage");
                            field_224017_f.func_225087_d();
                        }
                    }
                    catch (RealmsServiceException realmsServiceException) {
                        field_224012_a.error("Couldn't connect to Realms: " + realmsServiceException);
                    }
                }
            }.start();
        }
    }

    private void func_223962_w() {
        if (RealmsClient.field_224944_a != RealmsClient.Environment.LOCAL) {
            new Thread("MCO Local Availability Checker #1"){

                @Override
                public void run() {
                    RealmsClient realmsClient = RealmsClient.func_224911_a();
                    try {
                        Boolean bl = realmsClient.func_224931_h();
                        if (bl.booleanValue()) {
                            RealmsClient.func_224941_d();
                            field_224012_a.info("Switched to local");
                            field_224017_f.func_225087_d();
                        }
                    }
                    catch (RealmsServiceException realmsServiceException) {
                        field_224012_a.error("Couldn't connect to Realms: " + realmsServiceException);
                    }
                }
            }.start();
        }
    }

    private void func_223973_x() {
        RealmsClient.func_224921_c();
        field_224017_f.func_225087_d();
    }

    private void func_223939_y() {
        field_224017_f.func_225070_k();
    }

    private void func_223966_f(RealmsServer realmsServer) {
        if (this.field_230706_i_.func_110432_I().func_148255_b().equals(realmsServer.field_230588_g_) || field_224013_b) {
            this.func_223949_z();
            this.field_230706_i_.func_147108_a(new RealmsConfigureWorldScreen(this, realmsServer.field_230582_a_));
        }
    }

    private void func_223906_g(@Nullable RealmsServer realmsServer) {
        if (realmsServer != null && !this.field_230706_i_.func_110432_I().func_148255_b().equals(realmsServer.field_230588_g_)) {
            this.func_223949_z();
            TranslationTextComponent translationTextComponent = new TranslationTextComponent("mco.configure.world.leave.question.line1");
            \u2603 = new TranslationTextComponent("mco.configure.world.leave.question.line2");
            this.field_230706_i_.func_147108_a(new RealmsLongConfirmationScreen(this::func_237625_d_, RealmsLongConfirmationScreen.Type.Info, translationTextComponent, \u2603, true));
        }
    }

    private void func_223949_z() {
        field_224018_g = (int)this.field_224020_i.func_230966_l_();
    }

    @Nullable
    private RealmsServer func_223967_a(long l) {
        for (RealmsServer realmsServer : this.field_224028_q) {
            if (realmsServer.field_230582_a_ != l) continue;
            return realmsServer;
        }
        return null;
    }

    private void func_237625_d_(boolean bl) {
        if (bl) {
            new Thread("Realms-leave-server"){

                @Override
                public void run() {
                    try {
                        RealmsServer realmsServer = RealmsMainScreen.this.func_223967_a(RealmsMainScreen.this.field_224021_j);
                        if (realmsServer != null) {
                            RealmsClient realmsClient = RealmsClient.func_224911_a();
                            realmsClient.func_224912_c(realmsServer.field_230582_a_);
                            field_224017_f.func_225085_a(realmsServer);
                            RealmsMainScreen.this.field_224028_q.remove(realmsServer);
                            RealmsMainScreen.this.field_224020_i.func_231039_at__().removeIf(listEntry -> listEntry instanceof ServerEntry && ((ServerEntry)((ServerEntry)listEntry)).field_223734_a.field_230582_a_ == RealmsMainScreen.this.field_224021_j);
                            RealmsMainScreen.this.field_224020_i.func_241215_a_((ListEntry)null);
                            RealmsMainScreen.this.func_223915_a(null);
                            RealmsMainScreen.this.field_224021_j = -1L;
                            ((RealmsMainScreen)RealmsMainScreen.this).field_224022_k.field_230693_o_ = false;
                        }
                    }
                    catch (RealmsServiceException realmsServiceException) {
                        field_224012_a.error("Couldn't configure world");
                        RealmsMainScreen.this.field_230706_i_.execute(() -> RealmsMainScreen.this.field_230706_i_.func_147108_a(new RealmsGenericErrorScreen(realmsServiceException, (Screen)RealmsMainScreen.this)));
                    }
                }
            }.start();
        }
        this.field_230706_i_.func_147108_a(this);
    }

    public void func_223978_e() {
        this.field_224021_j = -1L;
    }

    @Override
    public boolean func_231046_a_(int n, int n2, int n3) {
        if (n == 256) {
            this.field_224002_J.forEach(KeyCombo::func_224800_a);
            this.func_223955_A();
            return true;
        }
        return super.func_231046_a_(n, n2, n3);
    }

    private void func_223955_A() {
        if (this.func_223990_b() && this.field_224035_x) {
            this.field_224035_x = false;
        } else {
            this.field_230706_i_.func_147108_a(this.field_224019_h);
        }
    }

    @Override
    public boolean func_231042_a_(char c, int n) {
        this.field_224002_J.forEach(keyCombo -> keyCombo.func_224799_a(c));
        return true;
    }

    @Override
    public void func_230430_a_(MatrixStack matrixStack2, int n, int n2, float f) {
        MatrixStack matrixStack2;
        this.field_237539_ap_ = ServerState.NONE;
        this.field_224027_p = null;
        this.func_230446_a_(matrixStack2);
        this.field_224020_i.func_230430_a_(matrixStack2, n, n2, f);
        this.func_237579_a_(matrixStack2, this.field_230708_k_ / 2 - 50, 7);
        if (RealmsClient.field_224944_a == RealmsClient.Environment.STAGE) {
            this.func_237613_c_(matrixStack2);
        }
        if (RealmsClient.field_224944_a == RealmsClient.Environment.LOCAL) {
            this.func_237604_b_(matrixStack2);
        }
        if (this.func_223990_b()) {
            this.func_237605_b_(matrixStack2, n, n2);
        } else {
            if (this.field_223994_B) {
                this.func_223915_a(null);
                if (!this.field_230705_e_.contains(this.field_224020_i)) {
                    this.field_230705_e_.add(this.field_224020_i);
                }
                RealmsServer realmsServer = this.func_223967_a(this.field_224021_j);
                this.field_224022_k.field_230693_o_ = this.func_223897_b(realmsServer);
            }
            this.field_223994_B = false;
        }
        super.func_230430_a_(matrixStack2, n, n2, f);
        if (this.field_224027_p != null) {
            this.func_237583_a_(matrixStack2, this.field_224027_p, n, n2);
        }
        if (this.field_224037_z && !this.field_223993_A && this.func_223990_b()) {
            this.field_230706_i_.func_110434_K().func_110577_a(field_237536_C_);
            RenderSystem.color4f(1.0f, 1.0f, 1.0f, 1.0f);
            int n3 = 8;
            \u2603 = 8;
            \u2603 = 0;
            if ((Util.func_211177_b() / 800L & 1L) == 1L) {
                \u2603 = 8;
            }
            AbstractGui.func_238463_a_(matrixStack2, this.field_224009_Q.field_230690_l_ + this.field_224009_Q.func_230998_h_() - 8 - 4, this.field_224009_Q.field_230691_m_ + this.field_224009_Q.func_238483_d_() / 2 - 4, 0.0f, \u2603, 8, 8, 8, 16);
        }
    }

    private void func_237579_a_(MatrixStack matrixStack, int n, int n2) {
        this.field_230706_i_.func_110434_K().func_110577_a(field_237548_v_);
        RenderSystem.color4f(1.0f, 1.0f, 1.0f, 1.0f);
        RenderSystem.pushMatrix();
        RenderSystem.scalef(0.5f, 0.5f, 0.5f);
        AbstractGui.func_238463_a_(matrixStack, n * 2, n2 * 2 - 5, 0.0f, 0.0f, 200, 50, 200, 50);
        RenderSystem.popMatrix();
    }

    @Override
    public boolean func_231044_a_(double d, double d2, int n) {
        if (this.func_223979_a(d, d2) && this.field_224035_x) {
            this.field_224035_x = false;
            this.field_224036_y = true;
            return true;
        }
        return super.func_231044_a_(d, d2, n);
    }

    private boolean func_223979_a(double d, double d2) {
        int n = this.func_223989_B();
        \u2603 = this.func_223932_C();
        return d < (double)(n - 5) || d > (double)(n + 315) || d2 < (double)(\u2603 - 5) || d2 > (double)(\u2603 + 171);
    }

    private void func_237605_b_(MatrixStack matrixStack, int n, int n2) {
        \u2603 = this.func_223989_B();
        \u2603 = this.func_223932_C();
        TranslationTextComponent translationTextComponent = new TranslationTextComponent("mco.selectServer.popup");
        List<ITextProperties> \u26032 = this.field_230712_o_.func_238425_b_(translationTextComponent, 100);
        if (!this.field_223994_B) {
            this.field_223997_E = 0;
            this.field_223998_F = 0;
            this.field_223999_G = true;
            this.func_223915_a(null);
            if (this.field_230705_e_.contains(this.field_224020_i) && !this.field_230705_e_.remove(\u2603 = this.field_224020_i)) {
                field_224012_a.error("Unable to remove widget: " + \u2603);
            }
            RealmsNarratorHelper.func_239550_a_(translationTextComponent.getString());
        }
        if (this.field_224034_w) {
            this.field_223994_B = true;
        }
        RenderSystem.color4f(1.0f, 1.0f, 1.0f, 0.7f);
        RenderSystem.enableBlend();
        this.field_230706_i_.func_110434_K().func_110577_a(field_237534_A_);
        boolean \u26033 = false;
        int \u26034 = 32;
        AbstractGui.func_238463_a_(matrixStack, 0, 32, 0.0f, 0.0f, this.field_230708_k_, this.field_230709_l_ - 40 - 32, 310, 166);
        RenderSystem.disableBlend();
        RenderSystem.color4f(1.0f, 1.0f, 1.0f, 1.0f);
        this.field_230706_i_.func_110434_K().func_110577_a(field_237552_z_);
        AbstractGui.func_238463_a_(matrixStack, \u2603, \u2603, 0.0f, 0.0f, 310, 166, 310, 166);
        if (!field_227918_e_.isEmpty()) {
            this.field_230706_i_.func_110434_K().func_110577_a(field_227918_e_.get(this.field_223997_E));
            RenderSystem.color4f(1.0f, 1.0f, 1.0f, 1.0f);
            AbstractGui.func_238463_a_(matrixStack, \u2603 + 7, \u2603 + 7, 0.0f, 0.0f, 195, 152, 195, 152);
            if (this.field_223998_F % 95 < 5) {
                if (!this.field_223999_G) {
                    this.field_223997_E = (this.field_223997_E + 1) % field_227918_e_.size();
                    this.field_223999_G = true;
                }
            } else {
                this.field_223999_G = false;
            }
        }
        int \u26035 = 0;
        for (ITextProperties iTextProperties : \u26032) {
            int n3 = \u2603 + 10 * ++\u26035 - 3;
            this.field_230712_o_.func_238422_b_(matrixStack, iTextProperties, this.field_230708_k_ / 2 + 52, n3, 0x4C4C4C);
        }
    }

    private int func_223989_B() {
        return (this.field_230708_k_ - 310) / 2;
    }

    private int func_223932_C() {
        return this.field_230709_l_ / 2 - 80;
    }

    private void func_237581_a_(MatrixStack matrixStack, int n, int n2, int n3, int n4, boolean bl, boolean bl2) {
        int n5 = this.field_224029_r;
        boolean \u26032 = this.func_223931_b(n, n2);
        boolean bl3 = \u2603 = bl2 && bl;
        if (\u2603) {
            float f = 0.25f + (1.0f + MathHelper.func_76126_a((float)this.field_224030_s * 0.5f)) * 0.25f;
            int \u26033 = 0xFF000000 | (int)(f * 64.0f) << 16 | (int)(f * 64.0f) << 8 | (int)(f * 64.0f) << 0;
            this.func_238468_a_(matrixStack, n3 - 2, n4 - 2, n3 + 18, n4 + 18, \u26033, \u26033);
            \u26033 = 0xFF000000 | (int)(f * 255.0f) << 16 | (int)(f * 255.0f) << 8 | (int)(f * 255.0f) << 0;
            this.func_238468_a_(matrixStack, n3 - 2, n4 - 2, n3 + 18, n4 - 1, \u26033, \u26033);
            this.func_238468_a_(matrixStack, n3 - 2, n4 - 2, n3 - 1, n4 + 18, \u26033, \u26033);
            this.func_238468_a_(matrixStack, n3 + 17, n4 - 2, n3 + 18, n4 + 18, \u26033, \u26033);
            this.func_238468_a_(matrixStack, n3 - 2, n4 + 17, n3 + 18, n4 + 18, \u26033, \u26033);
        }
        this.field_230706_i_.func_110434_K().func_110577_a(field_237546_t_);
        RenderSystem.color4f(1.0f, 1.0f, 1.0f, 1.0f);
        boolean bl4 = bl2 && bl;
        float \u26034 = bl4 ? 16.0f : 0.0f;
        AbstractGui.func_238463_a_(matrixStack, n3, n4 - 6, \u26034, 0.0f, 15, 25, 31, 25);
        boolean bl5 = \u2603 = bl2 && n5 != 0;
        if (\u2603) {
            int n6 = (Math.min(n5, 6) - 1) * 8;
            \u2603 = (int)(Math.max(0.0f, Math.max(MathHelper.func_76126_a((float)(10 + this.field_224030_s) * 0.57f), MathHelper.func_76134_b((float)this.field_224030_s * 0.35f))) * -6.0f);
            this.field_230706_i_.func_110434_K().func_110577_a(field_237545_s_);
            RenderSystem.color4f(1.0f, 1.0f, 1.0f, 1.0f);
            float \u26035 = \u26032 ? 8.0f : 0.0f;
            AbstractGui.func_238463_a_(matrixStack, n3 + 4, n4 + 4 + \u2603, n6, \u26035, 8, 8, 48, 16);
        }
        n6 = n + 12;
        \u2603 = n2;
        boolean bl6 = \u2603 = bl2 && \u26032;
        if (\u2603) {
            String \u26036 = n5 == 0 ? "mco.invites.nopending" : "mco.invites.pending";
            String \u26037 = I18n.func_135052_a(\u26036, new Object[0]);
            \u2603 = this.field_230712_o_.func_78256_a(\u26037);
            this.func_238468_a_(matrixStack, n6 - 3, \u2603 - 3, n6 + \u2603 + 3, \u2603 + 8 + 3, -1073741824, -1073741824);
            this.field_230712_o_.func_238405_a_(matrixStack, \u26037, n6, \u2603, -1);
        }
    }

    private boolean func_223931_b(double d, double d2) {
        int n = this.field_230708_k_ / 2 + 50;
        \u2603 = this.field_230708_k_ / 2 + 66;
        \u2603 = 11;
        \u2603 = 23;
        if (this.field_224029_r != 0) {
            n -= 3;
            \u2603 += 3;
            \u2603 -= 5;
            \u2603 += 5;
        }
        return (double)n <= d && d <= (double)\u2603 && (double)\u2603 <= d2 && d2 <= (double)\u2603;
    }

    public void func_223911_a(RealmsServer realmsServer, Screen screen) {
        if (realmsServer != null) {
            try {
                if (!this.field_224004_L.tryLock(1L, TimeUnit.SECONDS)) {
                    return;
                }
                if (this.field_224004_L.getHoldCount() > 1) {
                    return;
                }
            }
            catch (InterruptedException interruptedException) {
                return;
            }
            this.field_224015_d = true;
            this.field_230706_i_.func_147108_a(new RealmsLongRunningMcoTaskScreen(screen, new ConnectingToRealmsAction(this, screen, realmsServer, this.field_224004_L)));
        }
    }

    private boolean func_223885_h(RealmsServer realmsServer) {
        return realmsServer.field_230588_g_ != null && realmsServer.field_230588_g_.equals(this.field_230706_i_.func_110432_I().func_148255_b());
    }

    private boolean func_223991_i(RealmsServer realmsServer) {
        return this.func_223885_h(realmsServer) && !realmsServer.field_230591_j_;
    }

    private void func_237614_c_(MatrixStack matrixStack, int n, int n2, int n3, int n4) {
        this.field_230706_i_.func_110434_K().func_110577_a(field_237542_p_);
        RenderSystem.color4f(1.0f, 1.0f, 1.0f, 1.0f);
        AbstractGui.func_238463_a_(matrixStack, n, n2, 0.0f, 0.0f, 10, 28, 10, 28);
        if (n3 >= n && n3 <= n + 9 && n4 >= n2 && n4 <= n2 + 27 && n4 < this.field_230709_l_ - 40 && n4 > 32 && !this.func_223990_b()) {
            this.func_237603_a_(new TranslationTextComponent("mco.selectServer.expired"));
        }
    }

    private void func_237606_b_(MatrixStack matrixStack, int n, int n2, int n3, int n4, int n5) {
        this.field_230706_i_.func_110434_K().func_110577_a(field_237543_q_);
        RenderSystem.color4f(1.0f, 1.0f, 1.0f, 1.0f);
        if (this.field_224030_s % 20 < 10) {
            AbstractGui.func_238463_a_(matrixStack, n, n2, 0.0f, 0.0f, 10, 28, 20, 28);
        } else {
            AbstractGui.func_238463_a_(matrixStack, n, n2, 10.0f, 0.0f, 10, 28, 20, 28);
        }
        if (n3 >= n && n3 <= n + 9 && n4 >= n2 && n4 <= n2 + 27 && n4 < this.field_230709_l_ - 40 && n4 > 32 && !this.func_223990_b()) {
            if (n5 <= 0) {
                this.func_237603_a_(new TranslationTextComponent("mco.selectServer.expires.soon"));
            } else if (n5 == 1) {
                this.func_237603_a_(new TranslationTextComponent("mco.selectServer.expires.day"));
            } else {
                this.func_237603_a_(new TranslationTextComponent("mco.selectServer.expires.days", n5));
            }
        }
    }

    private void func_237620_d_(MatrixStack matrixStack, int n, int n2, int n3, int n4) {
        this.field_230706_i_.func_110434_K().func_110577_a(field_237540_b_);
        RenderSystem.color4f(1.0f, 1.0f, 1.0f, 1.0f);
        AbstractGui.func_238463_a_(matrixStack, n, n2, 0.0f, 0.0f, 10, 28, 10, 28);
        if (n3 >= n && n3 <= n + 9 && n4 >= n2 && n4 <= n2 + 27 && n4 < this.field_230709_l_ - 40 && n4 > 32 && !this.func_223990_b()) {
            this.func_237603_a_(new TranslationTextComponent("mco.selectServer.open"));
        }
    }

    private void func_237626_e_(MatrixStack matrixStack, int n, int n2, int n3, int n4) {
        this.field_230706_i_.func_110434_K().func_110577_a(field_237541_c_);
        RenderSystem.color4f(1.0f, 1.0f, 1.0f, 1.0f);
        AbstractGui.func_238463_a_(matrixStack, n, n2, 0.0f, 0.0f, 10, 28, 10, 28);
        if (n3 >= n && n3 <= n + 9 && n4 >= n2 && n4 <= n2 + 27 && n4 < this.field_230709_l_ - 40 && n4 > 32 && !this.func_223990_b()) {
            this.func_237603_a_(new TranslationTextComponent("mco.selectServer.closed"));
        }
    }

    private void func_237630_f_(MatrixStack matrixStack, int n, int n2, int n3, int n4) {
        boolean bl = false;
        if (n3 >= n && n3 <= n + 28 && n4 >= n2 && n4 <= n2 + 28 && n4 < this.field_230709_l_ - 40 && n4 > 32 && !this.func_223990_b()) {
            bl = true;
        }
        this.field_230706_i_.func_110434_K().func_110577_a(field_237544_r_);
        RenderSystem.color4f(1.0f, 1.0f, 1.0f, 1.0f);
        float \u26032 = bl ? 28.0f : 0.0f;
        AbstractGui.func_238463_a_(matrixStack, n, n2, \u26032, 0.0f, 28, 28, 56, 28);
        if (bl) {
            this.func_237603_a_(new TranslationTextComponent("mco.selectServer.leave"));
            this.field_237539_ap_ = ServerState.LEAVE;
        }
    }

    private void func_237633_g_(MatrixStack matrixStack, int n, int n2, int n3, int n4) {
        boolean bl = false;
        if (n3 >= n && n3 <= n + 28 && n4 >= n2 && n4 <= n2 + 28 && n4 < this.field_230709_l_ - 40 && n4 > 32 && !this.func_223990_b()) {
            bl = true;
        }
        this.field_230706_i_.func_110434_K().func_110577_a(field_237549_w_);
        RenderSystem.color4f(1.0f, 1.0f, 1.0f, 1.0f);
        float \u26032 = bl ? 28.0f : 0.0f;
        AbstractGui.func_238463_a_(matrixStack, n, n2, \u26032, 0.0f, 28, 28, 56, 28);
        if (bl) {
            this.func_237603_a_(new TranslationTextComponent("mco.selectServer.configure"));
            this.field_237539_ap_ = ServerState.CONFIGURE;
        }
    }

    protected void func_237583_a_(MatrixStack matrixStack, List<ITextComponent> list, int n3, int n2) {
        int n3;
        if (list.isEmpty()) {
            return;
        }
        \u2603 = 0;
        \u2603 = 0;
        for (ITextComponent iTextComponent : list) {
            int n4 = this.field_230712_o_.func_238414_a_(iTextComponent);
            if (n4 <= \u2603) continue;
            \u2603 = n4;
        }
        \u2603 = n3 - \u2603 - 5;
        \u2603 = n2;
        if (\u2603 < 0) {
            \u2603 = n3 + 12;
        }
        for (ITextComponent iTextComponent : list) {
            int n5 = \u2603 - (\u2603 == 0 ? 3 : 0) + \u2603;
            this.func_238468_a_(matrixStack, \u2603 - 3, n5, \u2603 + \u2603 + 3, \u2603 + 8 + 3 + \u2603, -1073741824, -1073741824);
            this.field_230712_o_.func_238407_a_(matrixStack, iTextComponent, \u2603, \u2603 + \u2603, 0xFFFFFF);
            \u2603 += 10;
        }
    }

    private void func_237580_a_(MatrixStack matrixStack, int n, int n2, int n3, int n4, boolean bl) {
        \u2603 = false;
        if (n >= n3 && n <= n3 + 20 && n2 >= n4 && n2 <= n4 + 20) {
            \u2603 = true;
        }
        this.field_230706_i_.func_110434_K().func_110577_a(field_237550_x_);
        RenderSystem.color4f(1.0f, 1.0f, 1.0f, 1.0f);
        float f = bl ? 20.0f : 0.0f;
        AbstractGui.func_238463_a_(matrixStack, n3, n4, f, 0.0f, 20, 20, 40, 20);
        if (\u2603) {
            this.func_237603_a_(new TranslationTextComponent("mco.selectServer.info"));
        }
    }

    private void func_237582_a_(MatrixStack matrixStack, int n, int n2, boolean bl, int n3, int n4, boolean bl2, boolean bl3) {
        \u2603 = false;
        if (n >= n3 && n <= n3 + 20 && n2 >= n4 && n2 <= n4 + 20) {
            \u2603 = true;
        }
        this.field_230706_i_.func_110434_K().func_110577_a(field_237551_y_);
        if (bl3) {
            RenderSystem.color4f(1.0f, 1.0f, 1.0f, 1.0f);
        } else {
            RenderSystem.color4f(0.5f, 0.5f, 0.5f, 1.0f);
        }
        \u2603 = bl3 && bl2;
        float f = \u2603 ? 20.0f : 0.0f;
        AbstractGui.func_238463_a_(matrixStack, n3, n4, f, 0.0f, 20, 20, 40, 20);
        if (\u2603 && bl3) {
            this.func_237603_a_(new TranslationTextComponent("mco.news"));
        }
        if (bl && bl3) {
            int n5 = \u2603 ? 0 : (int)(Math.max(0.0f, Math.max(MathHelper.func_76126_a((float)(10 + this.field_224030_s) * 0.57f), MathHelper.func_76134_b((float)this.field_224030_s * 0.35f))) * -6.0f);
            this.field_230706_i_.func_110434_K().func_110577_a(field_237545_s_);
            RenderSystem.color4f(1.0f, 1.0f, 1.0f, 1.0f);
            AbstractGui.func_238463_a_(matrixStack, n3 + 10, n4 + 2 + n5, 40.0f, 0.0f, 8, 8, 48, 16);
        }
    }

    private void func_237604_b_(MatrixStack matrixStack) {
        String string = "LOCAL!";
        RenderSystem.color4f(1.0f, 1.0f, 1.0f, 1.0f);
        RenderSystem.pushMatrix();
        RenderSystem.translatef(this.field_230708_k_ / 2 - 25, 20.0f, 0.0f);
        RenderSystem.rotatef(-20.0f, 0.0f, 0.0f, 1.0f);
        RenderSystem.scalef(1.5f, 1.5f, 1.5f);
        this.field_230712_o_.func_238421_b_(matrixStack, "LOCAL!", 0.0f, 0.0f, 0x7FFF7F);
        RenderSystem.popMatrix();
    }

    private void func_237613_c_(MatrixStack matrixStack) {
        String string = "STAGE!";
        RenderSystem.color4f(1.0f, 1.0f, 1.0f, 1.0f);
        RenderSystem.pushMatrix();
        RenderSystem.translatef(this.field_230708_k_ / 2 - 25, 20.0f, 0.0f);
        RenderSystem.rotatef(-20.0f, 0.0f, 0.0f, 1.0f);
        RenderSystem.scalef(1.5f, 1.5f, 1.5f);
        this.field_230712_o_.func_238421_b_(matrixStack, "STAGE!", 0.0f, 0.0f, -256);
        RenderSystem.popMatrix();
    }

    public RealmsMainScreen func_223942_f() {
        RealmsMainScreen realmsMainScreen = new RealmsMainScreen(this.field_224019_h);
        realmsMainScreen.func_231158_b_(this.field_230706_i_, this.field_230708_k_, this.field_230709_l_);
        return realmsMainScreen;
    }

    public static void func_227932_a_(IResourceManager iResourceManager) {
        Collection<ResourceLocation> collection = iResourceManager.func_199003_a("textures/gui/images", string -> string.endsWith(".png"));
        field_227918_e_ = (List)collection.stream().filter(resourceLocation -> resourceLocation.func_110624_b().equals("realms")).collect(ImmutableList.toImmutableList());
    }

    private void func_237603_a_(ITextComponent ... iTextComponentArray) {
        this.field_224027_p = Arrays.asList(iTextComponentArray);
    }

    private void func_237598_a_(Button button) {
        this.field_230706_i_.func_147108_a(new RealmsPendingInvitesScreen(this.field_224019_h));
    }

    static {
        field_224018_g = -1;
    }

    class CloseButton
    extends Button {
        public CloseButton() {
            super(RealmsMainScreen.this.func_223989_B() + 4, RealmsMainScreen.this.func_223932_C() + 4, 12, 12, new TranslationTextComponent("mco.selectServer.close"), button -> RealmsMainScreen.this.func_223955_A());
        }

        @Override
        public void func_230431_b_(MatrixStack matrixStack, int n, int n2, float f) {
            RealmsMainScreen.this.field_230706_i_.func_110434_K().func_110577_a(field_237535_B_);
            RenderSystem.color4f(1.0f, 1.0f, 1.0f, 1.0f);
            \u2603 = this.func_230449_g_() ? 12.0f : 0.0f;
            CloseButton.func_238463_a_(matrixStack, this.field_230690_l_, this.field_230691_m_, 0.0f, \u2603, 12, 12, 12, 24);
            if (this.func_231047_b_(n, n2)) {
                RealmsMainScreen.this.func_237603_a_(new ITextComponent[]{this.func_230458_i_()});
            }
        }
    }

    class InfoButton
    extends Button {
        public InfoButton() {
            super(RealmsMainScreen.this.field_230708_k_ - 37, 6, 20, 20, new TranslationTextComponent("mco.selectServer.info"), button -> RealmsMainScreen.this.field_224035_x = !RealmsMainScreen.this.field_224035_x);
        }

        @Override
        public void func_230431_b_(MatrixStack matrixStack, int n, int n2, float f) {
            RealmsMainScreen.this.func_237580_a_(matrixStack, n, n2, this.field_230690_l_, this.field_230691_m_, this.func_230449_g_());
        }
    }

    class NewsButton
    extends Button {
        public NewsButton() {
            super(RealmsMainScreen.this.field_230708_k_ - 62, 6, 20, 20, StringTextComponent.field_240750_d_, button -> {
                if (RealmsMainScreen.this.field_223996_D == null) {
                    return;
                }
                Util.func_110647_a().func_195640_a(RealmsMainScreen.this.field_223996_D);
                if (RealmsMainScreen.this.field_223995_C) {
                    RealmsPersistence.RealmsPersistenceData realmsPersistenceData = RealmsPersistence.func_225188_a();
                    realmsPersistenceData.field_225186_b = false;
                    RealmsMainScreen.this.field_223995_C = false;
                    RealmsPersistence.func_225187_a(realmsPersistenceData);
                }
            });
            this.func_238482_a_(new TranslationTextComponent("mco.news"));
        }

        @Override
        public void func_230431_b_(MatrixStack matrixStack, int n, int n2, float f) {
            RealmsMainScreen.this.func_237582_a_(matrixStack, n, n2, RealmsMainScreen.this.field_223995_C, this.field_230690_l_, this.field_230691_m_, this.func_230449_g_(), this.field_230693_o_);
        }
    }

    class PendingInvitesButton
    extends Button
    implements IScreen {
        public PendingInvitesButton() {
            super(RealmsMainScreen.this.field_230708_k_ / 2 + 47, 6, 22, 22, StringTextComponent.field_240750_d_, button -> RealmsMainScreen.this.func_237598_a_(button));
        }

        @Override
        public void func_231023_e_() {
            this.func_238482_a_(new TranslationTextComponent(RealmsMainScreen.this.field_224029_r == 0 ? "mco.invites.nopending" : "mco.invites.pending"));
        }

        @Override
        public void func_230431_b_(MatrixStack matrixStack, int n, int n2, float f) {
            RealmsMainScreen.this.func_237581_a_(matrixStack, n, n2, this.field_230690_l_, this.field_230691_m_, this.func_230449_g_(), this.field_230693_o_);
        }
    }

    class ServerEntry
    extends ListEntry {
        private final RealmsServer field_223734_a;

        public ServerEntry(RealmsServer realmsServer) {
            this.field_223734_a = realmsServer;
        }

        @Override
        public void func_230432_a_(MatrixStack matrixStack, int n, int n2, int n3, int n4, int n5, int n6, int n7, boolean bl, float f) {
            this.func_237678_a_(this.field_223734_a, matrixStack, n3, n2, n6, n7);
        }

        @Override
        public boolean func_231044_a_(double d, double d2, int n) {
            if (this.field_223734_a.field_230586_e_ == RealmsServer.Status.UNINITIALIZED) {
                RealmsMainScreen.this.field_224021_j = -1L;
                RealmsMainScreen.this.field_230706_i_.func_147108_a(new RealmsCreateRealmScreen(this.field_223734_a, RealmsMainScreen.this));
            } else {
                RealmsMainScreen.this.field_224021_j = this.field_223734_a.field_230582_a_;
            }
            return true;
        }

        private void func_237678_a_(RealmsServer realmsServer, MatrixStack matrixStack, int n, int n2, int n3, int n4) {
            this.func_237679_b_(realmsServer, matrixStack, n + 36, n2, n3, n4);
        }

        private void func_237679_b_(RealmsServer realmsServer2, MatrixStack matrixStack, int n, int n2, int n3, int n4) {
            RealmsServer realmsServer2;
            String string;
            if (realmsServer2.field_230586_e_ == RealmsServer.Status.UNINITIALIZED) {
                RealmsMainScreen.this.field_230706_i_.func_110434_K().func_110577_a(field_237547_u_);
                RenderSystem.color4f(1.0f, 1.0f, 1.0f, 1.0f);
                RenderSystem.enableAlphaTest();
                AbstractGui.func_238463_a_(matrixStack, n + 10, n2 + 6, 0.0f, 0.0f, 40, 20, 40, 20);
                float f = 0.5f + (1.0f + MathHelper.func_76126_a((float)RealmsMainScreen.this.field_224030_s * 0.25f)) * 0.25f;
                int \u26032 = 0xFF000000 | (int)(127.0f * f) << 16 | (int)(255.0f * f) << 8 | (int)(127.0f * f);
                RealmsMainScreen.this.func_238471_a_(matrixStack, RealmsMainScreen.this.field_230712_o_, I18n.func_135052_a("mco.selectServer.uninitialized", new Object[0]), n + 10 + 40 + 75, n2 + 12, \u26032);
                return;
            }
            int n5 = 225;
            \u2603 = 2;
            if (realmsServer2.field_230591_j_) {
                RealmsMainScreen.this.func_237614_c_(matrixStack, n + 225 - 14, n2 + 2, n3, n4);
            } else if (realmsServer2.field_230586_e_ == RealmsServer.Status.CLOSED) {
                RealmsMainScreen.this.func_237626_e_(matrixStack, n + 225 - 14, n2 + 2, n3, n4);
            } else if (RealmsMainScreen.this.func_223885_h(realmsServer2) && realmsServer2.field_230593_l_ < 7) {
                RealmsMainScreen.this.func_237606_b_(matrixStack, n + 225 - 14, n2 + 2, n3, n4, realmsServer2.field_230593_l_);
            } else if (realmsServer2.field_230586_e_ == RealmsServer.Status.OPEN) {
                RealmsMainScreen.this.func_237620_d_(matrixStack, n + 225 - 14, n2 + 2, n3, n4);
            }
            if (!RealmsMainScreen.this.func_223885_h(realmsServer2) && !field_224013_b) {
                RealmsMainScreen.this.func_237630_f_(matrixStack, n + 225, n2 + 2, n3, n4);
            } else {
                RealmsMainScreen.this.func_237633_g_(matrixStack, n + 225, n2 + 2, n3, n4);
            }
            if (!"0".equals(realmsServer2.field_230599_r_.field_230607_a_)) {
                string = (Object)((Object)TextFormatting.GRAY) + "" + realmsServer2.field_230599_r_.field_230607_a_;
                RealmsMainScreen.this.field_230712_o_.func_238421_b_(matrixStack, string, n + 207 - RealmsMainScreen.this.field_230712_o_.func_78256_a(string), n2 + 3, 0x808080);
                if (n3 >= n + 207 - RealmsMainScreen.this.field_230712_o_.func_78256_a(string) && n3 <= n + 207 && n4 >= n2 + 1 && n4 <= n2 + 10 && n4 < RealmsMainScreen.this.field_230709_l_ - 40 && n4 > 32 && !RealmsMainScreen.this.func_223990_b()) {
                    RealmsMainScreen.this.func_237603_a_(new ITextComponent[]{new StringTextComponent(realmsServer2.field_230599_r_.field_230608_b_)});
                }
            }
            if (RealmsMainScreen.this.func_223885_h(realmsServer2) && realmsServer2.field_230591_j_) {
                RenderSystem.color4f(1.0f, 1.0f, 1.0f, 1.0f);
                RenderSystem.enableBlend();
                RealmsMainScreen.this.field_230706_i_.func_110434_K().func_110577_a(field_237537_D_);
                RenderSystem.blendFunc(GlStateManager.SourceFactor.SRC_ALPHA, GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
                string = I18n.func_135052_a("mco.selectServer.expiredList", new Object[0]);
                \u2603 = I18n.func_135052_a("mco.selectServer.expiredRenew", new Object[0]);
                if (realmsServer2.field_230592_k_) {
                    string = I18n.func_135052_a("mco.selectServer.expiredTrial", new Object[0]);
                    \u2603 = I18n.func_135052_a("mco.selectServer.expiredSubscribe", new Object[0]);
                }
                int \u26033 = RealmsMainScreen.this.field_230712_o_.func_78256_a(\u2603) + 17;
                int \u26034 = 16;
                int \u26035 = n + RealmsMainScreen.this.field_230712_o_.func_78256_a(string) + 8;
                int \u26036 = n2 + 13;
                boolean \u26037 = false;
                if (n3 >= \u26035 && n3 < \u26035 + \u26033 && n4 > \u26036 && n4 <= \u26036 + 16 & n4 < RealmsMainScreen.this.field_230709_l_ - 40 && n4 > 32 && !RealmsMainScreen.this.func_223990_b()) {
                    \u26037 = true;
                    RealmsMainScreen.this.field_237539_ap_ = ServerState.EXPIRED;
                }
                int \u26038 = \u26037 ? 2 : 1;
                AbstractGui.func_238463_a_(matrixStack, \u26035, \u26036, 0.0f, 46 + \u26038 * 20, \u26033 / 2, 8, 256, 256);
                AbstractGui.func_238463_a_(matrixStack, \u26035 + \u26033 / 2, \u26036, 200 - \u26033 / 2, 46 + \u26038 * 20, \u26033 / 2, 8, 256, 256);
                AbstractGui.func_238463_a_(matrixStack, \u26035, \u26036 + 8, 0.0f, 46 + \u26038 * 20 + 12, \u26033 / 2, 8, 256, 256);
                AbstractGui.func_238463_a_(matrixStack, \u26035 + \u26033 / 2, \u26036 + 8, 200 - \u26033 / 2, 46 + \u26038 * 20 + 12, \u26033 / 2, 8, 256, 256);
                RenderSystem.disableBlend();
                int \u26039 = n2 + 11 + 5;
                int \u260310 = \u26037 ? 0xFFFFA0 : 0xFFFFFF;
                RealmsMainScreen.this.field_230712_o_.func_238421_b_(matrixStack, string, n + 2, \u26039 + 1, 15553363);
                RealmsMainScreen.this.func_238471_a_(matrixStack, RealmsMainScreen.this.field_230712_o_, \u2603, \u26035 + \u26033 / 2, \u26039 + 1, \u260310);
            } else {
                if (realmsServer2.field_230594_m_ == RealmsServer.ServerType.MINIGAME) {
                    int n6 = 0xCCAC5C;
                    String \u260311 = I18n.func_135052_a("mco.selectServer.minigame", new Object[0]) + " ";
                    \u2603 = RealmsMainScreen.this.field_230712_o_.func_78256_a(\u260311);
                    RealmsMainScreen.this.field_230712_o_.func_238421_b_(matrixStack, \u260311, n + 2, n2 + 12, 0xCCAC5C);
                    RealmsMainScreen.this.field_230712_o_.func_238421_b_(matrixStack, realmsServer2.func_230778_c_(), n + 2 + \u2603, n2 + 12, 0x6C6C6C);
                } else {
                    RealmsMainScreen.this.field_230712_o_.func_238421_b_(matrixStack, realmsServer2.func_230768_a_(), n + 2, n2 + 12, 0x6C6C6C);
                }
                if (!RealmsMainScreen.this.func_223885_h(realmsServer2)) {
                    RealmsMainScreen.this.field_230712_o_.func_238421_b_(matrixStack, realmsServer2.field_230587_f_, n + 2, n2 + 12 + 11, 0x4C4C4C);
                }
            }
            RealmsMainScreen.this.field_230712_o_.func_238421_b_(matrixStack, realmsServer2.func_230775_b_(), n + 2, n2 + 1, 0xFFFFFF);
            RealmsTextureManager.func_225205_a(realmsServer2.field_230588_g_, () -> {
                RenderSystem.color4f(1.0f, 1.0f, 1.0f, 1.0f);
                AbstractGui.func_238466_a_(matrixStack, n - 36, n2, 32, 32, 8.0f, 8.0f, 8, 8, 64, 64);
                AbstractGui.func_238466_a_(matrixStack, n - 36, n2, 32, 32, 40.0f, 8.0f, 8, 8, 64, 64);
            });
        }
    }

    class TrialServerEntry
    extends ListEntry {
        private TrialServerEntry() {
        }

        @Override
        public void func_230432_a_(MatrixStack matrixStack, int n, int n2, int n3, int n4, int n5, int n6, int n7, boolean bl, float f) {
            this.func_237681_a_(matrixStack, n, n3, n2, n6, n7);
        }

        @Override
        public boolean func_231044_a_(double d, double d2, int n) {
            RealmsMainScreen.this.field_224035_x = true;
            return true;
        }

        private void func_237681_a_(MatrixStack matrixStack, int n, int n2, int n3, int n4, int n5) {
            \u2603 = n3 + 8;
            \u2603 = 0;
            String string = I18n.func_135052_a("mco.trial.message.line1", new Object[0]) + "\\n" + I18n.func_135052_a("mco.trial.message.line2", new Object[0]);
            boolean \u26032 = false;
            if (n2 <= n4 && n4 <= (int)RealmsMainScreen.this.field_224020_i.func_230966_l_() && n3 <= n5 && n5 <= n3 + 32) {
                \u26032 = true;
            }
            int \u26033 = 0x7FFF7F;
            if (\u26032 && !RealmsMainScreen.this.func_223990_b()) {
                \u26033 = 6077788;
            }
            for (String string2 : string.split("\\\\n")) {
                RealmsMainScreen.this.func_238471_a_(matrixStack, RealmsMainScreen.this.field_230712_o_, string2, RealmsMainScreen.this.field_230708_k_ / 2, \u2603 + \u2603, \u26033);
                \u2603 += 10;
            }
        }
    }

    abstract class ListEntry
    extends ExtendedList.AbstractListEntry<ListEntry> {
        private ListEntry() {
        }
    }

    class ServerList
    extends RealmsObjectSelectionList<ListEntry> {
        private boolean field_241824_o_;

        public ServerList() {
            super(RealmsMainScreen.this.field_230708_k_, RealmsMainScreen.this.field_230709_l_, 32, RealmsMainScreen.this.field_230709_l_ - 40, 36);
        }

        @Override
        public void func_231409_q_() {
            super.func_231409_q_();
            this.field_241824_o_ = false;
        }

        public int func_241825_a_(ListEntry listEntry) {
            this.field_241824_o_ = true;
            return this.func_230513_b_(listEntry);
        }

        @Override
        public boolean func_230971_aw__() {
            return RealmsMainScreen.this.func_241217_q_() == this;
        }

        @Override
        public boolean func_231046_a_(int n4, int n2, int n3) {
            int n4;
            if (n4 == 257 || n4 == 32 || n4 == 335) {
                ExtendedList.AbstractListEntry abstractListEntry = (ExtendedList.AbstractListEntry)this.func_230958_g_();
                if (abstractListEntry == null) {
                    return super.func_231046_a_(n4, n2, n3);
                }
                return abstractListEntry.func_231044_a_(0.0, 0.0, 0);
            }
            return super.func_231046_a_(n4, n2, n3);
        }

        @Override
        public boolean func_231044_a_(double d, double d2, int n) {
            if (n == 0 && d < (double)this.func_230952_d_() && d2 >= (double)this.field_230672_i_ && d2 <= (double)this.field_230673_j_) {
                \u2603 = RealmsMainScreen.this.field_224020_i.func_230968_n_();
                \u2603 = this.func_230952_d_();
                \u2603 = (int)Math.floor(d2 - (double)this.field_230672_i_) - this.field_230677_n_ + (int)this.func_230966_l_() - 4;
                \u2603 = \u2603 / this.field_230669_c_;
                if (d >= (double)\u2603 && d <= (double)\u2603 && \u2603 >= 0 && \u2603 >= 0 && \u2603 < this.func_230965_k_()) {
                    this.func_231401_a_(\u2603, \u2603, d, d2, this.field_230670_d_);
                    RealmsMainScreen.this.field_224003_K = RealmsMainScreen.this.field_224003_K + 7;
                    this.func_231400_a_(\u2603);
                }
                return true;
            }
            return super.func_231044_a_(d, d2, n);
        }

        @Override
        public void func_231400_a_(int n2) {
            RealmsServer \u26032;
            this.func_239561_k_(n2);
            if (n2 == -1) {
                return;
            }
            if (this.field_241824_o_) {
                if (n2 == 0) {
                    RealmsNarratorHelper.func_239551_a_(I18n.func_135052_a("mco.trial.message.line1", new Object[0]), I18n.func_135052_a("mco.trial.message.line2", new Object[0]));
                    \u26032 = null;
                } else {
                    int n2;
                    if (n2 - 1 >= RealmsMainScreen.this.field_224028_q.size()) {
                        RealmsMainScreen.this.field_224021_j = -1L;
                        return;
                    }
                    \u26032 = (RealmsServer)RealmsMainScreen.this.field_224028_q.get(n2 - 1);
                }
            } else {
                if (n2 >= RealmsMainScreen.this.field_224028_q.size()) {
                    RealmsMainScreen.this.field_224021_j = -1L;
                    return;
                }
                \u26032 = (RealmsServer)RealmsMainScreen.this.field_224028_q.get(n2);
            }
            RealmsMainScreen.this.func_223915_a(\u26032);
            if (\u26032 == null) {
                RealmsMainScreen.this.field_224021_j = -1L;
                return;
            }
            if (\u26032.field_230586_e_ == RealmsServer.Status.UNINITIALIZED) {
                RealmsNarratorHelper.func_239550_a_(I18n.func_135052_a("mco.selectServer.uninitialized", new Object[0]) + I18n.func_135052_a("mco.gui.button", new Object[0]));
                RealmsMainScreen.this.field_224021_j = -1L;
                return;
            }
            RealmsMainScreen.this.field_224021_j = \u26032.field_230582_a_;
            if (RealmsMainScreen.this.field_224003_K >= 10 && ((RealmsMainScreen)RealmsMainScreen.this).field_224022_k.field_230693_o_) {
                RealmsMainScreen.this.func_223911_a(RealmsMainScreen.this.func_223967_a(RealmsMainScreen.this.field_224021_j), RealmsMainScreen.this);
            }
            RealmsNarratorHelper.func_239550_a_(I18n.func_135052_a("narrator.select", \u26032.field_230584_c_));
        }

        @Override
        public void func_241215_a_(@Nullable ListEntry listEntry) {
            super.func_241215_a_(listEntry);
            int n = this.func_231039_at__().indexOf(listEntry);
            if (!this.field_241824_o_ || n > 0) {
                RealmsServer realmsServer = (RealmsServer)RealmsMainScreen.this.field_224028_q.get(n - (this.field_241824_o_ ? 1 : 0));
                RealmsMainScreen.this.field_224021_j = realmsServer.field_230582_a_;
                RealmsMainScreen.this.func_223915_a(realmsServer);
            }
        }

        @Override
        public void func_231401_a_(int n, int n2, double d, double d2, int n3) {
            if (this.field_241824_o_) {
                if (n2 == 0) {
                    RealmsMainScreen.this.field_224035_x = true;
                    return;
                }
                --n2;
            }
            if (n2 >= RealmsMainScreen.this.field_224028_q.size()) {
                return;
            }
            RealmsServer realmsServer = (RealmsServer)RealmsMainScreen.this.field_224028_q.get(n2);
            if (realmsServer == null) {
                return;
            }
            if (realmsServer.field_230586_e_ == RealmsServer.Status.UNINITIALIZED) {
                RealmsMainScreen.this.field_224021_j = -1L;
                Minecraft.func_71410_x().func_147108_a(new RealmsCreateRealmScreen(realmsServer, RealmsMainScreen.this));
            } else {
                RealmsMainScreen.this.field_224021_j = realmsServer.field_230582_a_;
            }
            if (RealmsMainScreen.this.field_237539_ap_ == ServerState.CONFIGURE) {
                RealmsMainScreen.this.field_224021_j = realmsServer.field_230582_a_;
                RealmsMainScreen.this.func_223966_f(realmsServer);
            } else if (RealmsMainScreen.this.field_237539_ap_ == ServerState.LEAVE) {
                RealmsMainScreen.this.field_224021_j = realmsServer.field_230582_a_;
                RealmsMainScreen.this.func_223906_g(realmsServer);
            } else if (RealmsMainScreen.this.field_237539_ap_ == ServerState.EXPIRED) {
                RealmsMainScreen.this.func_223930_q();
            }
        }

        @Override
        public int func_230945_b_() {
            return this.func_230965_k_() * 36;
        }

        @Override
        public int func_230949_c_() {
            return 300;
        }

        @Override
        public /* synthetic */ void func_241215_a_(@Nullable AbstractList.AbstractListEntry abstractListEntry) {
            this.func_241215_a_((ListEntry)abstractListEntry);
        }
    }

    static enum ServerState {
        NONE,
        EXPIRED,
        LEAVE,
        CONFIGURE;

    }
}

