/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.storage;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.datafixers.DataFixer;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.Lifecycle;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.SignStyle;
import java.time.temporal.ChronoField;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.annotation.Nullable;
import net.minecraft.client.AnvilConverterException;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTDynamicOps;
import net.minecraft.server.IDynamicRegistries;
import net.minecraft.server.SessionLockManager;
import net.minecraft.util.FileUtil;
import net.minecraft.util.IProgressUpdate;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.SharedConstants;
import net.minecraft.util.Util;
import net.minecraft.util.datafix.DataFixesManager;
import net.minecraft.util.datafix.DefaultTypeReferences;
import net.minecraft.util.datafix.TypeReferences;
import net.minecraft.util.datafix.codec.DatapackCodec;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.DimensionType;
import net.minecraft.world.World;
import net.minecraft.world.WorldSettings;
import net.minecraft.world.gen.settings.DimensionGeneratorSettings;
import net.minecraft.world.storage.AnvilSaveConverter;
import net.minecraft.world.storage.FolderName;
import net.minecraft.world.storage.IServerConfiguration;
import net.minecraft.world.storage.PlayerData;
import net.minecraft.world.storage.ServerWorldInfo;
import net.minecraft.world.storage.VersionData;
import net.minecraft.world.storage.WorldSummary;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.StartupQuery;
import net.minecraftforge.fml.WorldPersistenceHooks;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SaveFormat {
    private static final Logger field_215785_a = LogManager.getLogger();
    private static final DateTimeFormatter field_197716_d = new DateTimeFormatterBuilder().appendValue(ChronoField.YEAR, 4, 10, SignStyle.EXCEEDS_PAD).appendLiteral('-').appendValue(ChronoField.MONTH_OF_YEAR, 2).appendLiteral('-').appendValue(ChronoField.DAY_OF_MONTH, 2).appendLiteral('_').appendValue(ChronoField.HOUR_OF_DAY, 2).appendLiteral('-').appendValue(ChronoField.MINUTE_OF_HOUR, 2).appendLiteral('-').appendValue(ChronoField.SECOND_OF_MINUTE, 2).toFormatter();
    private static final ImmutableList<String> field_237257_c_ = ImmutableList.of((Object)"RandomSeed", (Object)"generatorName", (Object)"generatorOptions", (Object)"generatorVersion", (Object)"legacy_custom_options", (Object)"MapFeatures", (Object)"BonusChest");
    private final Path field_215786_c;
    private final Path field_215787_d;
    private final DataFixer field_215788_e;

    public SaveFormat(Path p_i51277_1_, Path p_i51277_2_, DataFixer p_i51277_3_) {
        this.field_215788_e = p_i51277_3_;
        try {
            Files.createDirectories(Files.exists(p_i51277_1_, new LinkOption[0]) ? p_i51277_1_.toRealPath(new LinkOption[0]) : p_i51277_1_, new FileAttribute[0]);
        }
        catch (IOException ioexception) {
            throw new RuntimeException(ioexception);
        }
        this.field_215786_c = p_i51277_1_;
        this.field_215787_d = p_i51277_2_;
    }

    public static SaveFormat func_237269_a_(Path p_237269_0_) {
        return new SaveFormat(p_237269_0_, p_237269_0_.resolve("../backups"), DataFixesManager.func_210901_a());
    }

    private static Pair<DimensionGeneratorSettings, Lifecycle> func_237259_a_(Dynamic<?> p_237259_0_, DataFixer p_237259_1_, int p_237259_2_) {
        Dynamic dynamic = p_237259_0_.get("WorldGenSettings").orElseEmptyMap();
        for (String s : field_237257_c_) {
            Optional optional = p_237259_0_.get(s).result();
            if (!optional.isPresent()) continue;
            dynamic = dynamic.set(s, (Dynamic)optional.get());
        }
        Dynamic dynamic1 = p_237259_1_.update(TypeReferences.field_233375_y_, dynamic, p_237259_2_, SharedConstants.func_215069_a().getWorldVersion());
        DataResult dataresult = DimensionGeneratorSettings.field_236201_a_.parse(dynamic1);
        return Pair.of((Object)dataresult.resultOrPartial(Util.func_240982_a_((String)"WorldGenSettings: ", arg_0 -> ((Logger)field_215785_a).error(arg_0))).orElseGet(DimensionGeneratorSettings::func_236210_a_), (Object)dataresult.lifecycle());
    }

    private static DatapackCodec func_237258_a_(Dynamic<?> p_237258_0_) {
        return DatapackCodec.field_234881_b_.parse(p_237258_0_).resultOrPartial(arg_0 -> ((Logger)field_215785_a).error(arg_0)).orElse(DatapackCodec.field_234880_a_);
    }

    @OnlyIn(value=Dist.CLIENT)
    public List<WorldSummary> func_75799_b() throws AnvilConverterException {
        File[] afile;
        if (!Files.isDirectory(this.field_215786_c, new LinkOption[0])) {
            throw new AnvilConverterException(new TranslationTextComponent("selectWorld.load_folder_access").getString());
        }
        ArrayList list = Lists.newArrayList();
        for (File file1 : afile = this.field_215786_c.toFile().listFiles()) {
            boolean flag;
            if (!file1.isDirectory()) continue;
            try {
                flag = SessionLockManager.func_232999_b_((Path)file1.toPath());
            }
            catch (Exception exception) {
                field_215785_a.warn("Failed to read {} lock", (Object)file1, (Object)exception);
                continue;
            }
            WorldSummary worldsummary = this.func_237266_a_(file1, this.func_237267_a_(file1, flag));
            if (worldsummary == null) continue;
            list.add(worldsummary);
        }
        return list;
    }

    private int func_215782_e() {
        return 19133;
    }

    @Nullable
    private <T> T func_237266_a_(File p_237266_1_, BiFunction<File, DataFixer, T> p_237266_2_) {
        T t;
        if (!p_237266_1_.exists()) {
            return null;
        }
        File file1 = new File(p_237266_1_, "level.dat");
        if (file1.exists() && (t = p_237266_2_.apply(file1, this.field_215788_e)) != null) {
            return t;
        }
        file1 = new File(p_237266_1_, "level.dat_old");
        return file1.exists() ? (T)p_237266_2_.apply(file1, this.field_215788_e) : null;
    }

    @Nullable
    private static DatapackCodec func_237272_b_(File p_237272_0_, DataFixer p_237272_1_) {
        try {
            CompoundNBT compoundnbt = CompressedStreamTools.func_74796_a(new FileInputStream(p_237272_0_));
            CompoundNBT compoundnbt1 = compoundnbt.func_74775_l("Data");
            compoundnbt1.func_82580_o("Player");
            int i = compoundnbt1.func_150297_b("DataVersion", 99) ? compoundnbt1.func_74762_e("DataVersion") : -1;
            Dynamic dynamic = p_237272_1_.update(DefaultTypeReferences.LEVEL.func_219816_a(), new Dynamic((DynamicOps)NBTDynamicOps.field_210820_a, (Object)compoundnbt1), i, SharedConstants.func_215069_a().getWorldVersion());
            return dynamic.get("DataPacks").result().map(SaveFormat::func_237258_a_).orElse(DatapackCodec.field_234880_a_);
        }
        catch (Exception exception) {
            field_215785_a.error("Exception reading {}", (Object)p_237272_0_, (Object)exception);
            return null;
        }
    }

    private static BiFunction<File, DataFixer, ServerWorldInfo> func_237270_b_(DynamicOps<INBT> p_237270_0_, DatapackCodec p_237270_1_) {
        return SaveFormat.func_237270_b_(p_237270_0_, p_237270_1_, null);
    }

    private static BiFunction<File, DataFixer, ServerWorldInfo> func_237270_b_(DynamicOps<INBT> p_237270_0_, DatapackCodec p_237270_1_, @Nullable LevelSave levelSave) {
        return (p_237261_2_, p_237261_3_) -> {
            try {
                CompoundNBT compoundnbt = CompressedStreamTools.func_74796_a(new FileInputStream((File)p_237261_2_));
                CompoundNBT compoundnbt1 = compoundnbt.func_74775_l("Data");
                CompoundNBT compoundnbt2 = compoundnbt1.func_150297_b("Player", 10) ? compoundnbt1.func_74775_l("Player") : null;
                compoundnbt1.func_82580_o("Player");
                int i = compoundnbt1.func_150297_b("DataVersion", 99) ? compoundnbt1.func_74762_e("DataVersion") : -1;
                Dynamic dynamic = p_237261_3_.update(DefaultTypeReferences.LEVEL.func_219816_a(), new Dynamic(p_237270_0_, (Object)compoundnbt1), i, SharedConstants.func_215069_a().getWorldVersion());
                Pair<DimensionGeneratorSettings, Lifecycle> pair = SaveFormat.func_237259_a_(dynamic, p_237261_3_, i);
                VersionData versiondata = VersionData.func_237324_a_((Dynamic)dynamic);
                WorldSettings worldsettings = WorldSettings.func_234951_a_((Dynamic)dynamic, (DatapackCodec)p_237270_1_);
                ServerWorldInfo info = ServerWorldInfo.func_237369_a_((Dynamic)dynamic, (DataFixer)p_237261_3_, (int)i, (CompoundNBT)compoundnbt2, (WorldSettings)worldsettings, (VersionData)versiondata, (DimensionGeneratorSettings)((DimensionGeneratorSettings)pair.getFirst()), (Lifecycle)((Lifecycle)pair.getSecond()));
                if (levelSave != null) {
                    WorldPersistenceHooks.handleWorldDataLoad((LevelSave)levelSave, (IServerConfiguration)info, (CompoundNBT)compoundnbt);
                }
                return info;
            }
            catch (StartupQuery.AbortedException e) {
                throw e;
            }
            catch (Exception exception) {
                field_215785_a.error("Exception reading {}", p_237261_2_, (Object)exception);
                return null;
            }
        };
    }

    private BiFunction<File, DataFixer, WorldSummary> func_237267_a_(File p_237267_1_, boolean p_237267_2_) {
        return (p_237268_3_, p_237268_4_) -> {
            try {
                CompoundNBT compoundnbt = CompressedStreamTools.func_74796_a(new FileInputStream((File)p_237268_3_));
                CompoundNBT compoundnbt1 = compoundnbt.func_74775_l("Data");
                compoundnbt1.func_82580_o("Player");
                int i = compoundnbt1.func_150297_b("DataVersion", 99) ? compoundnbt1.func_74762_e("DataVersion") : -1;
                Dynamic dynamic = p_237268_4_.update(DefaultTypeReferences.LEVEL.func_219816_a(), new Dynamic((DynamicOps)NBTDynamicOps.field_210820_a, (Object)compoundnbt1), i, SharedConstants.func_215069_a().getWorldVersion());
                VersionData versiondata = VersionData.func_237324_a_((Dynamic)dynamic);
                int j = versiondata.func_237323_a_();
                if (j != 19132 && j != 19133) {
                    return null;
                }
                boolean flag = j != this.func_215782_e();
                File file1 = new File(p_237267_1_, "icon.png");
                DatapackCodec datapackcodec = dynamic.get("DataPacks").result().map(SaveFormat::func_237258_a_).orElse(DatapackCodec.field_234880_a_);
                WorldSettings worldsettings = WorldSettings.func_234951_a_((Dynamic)dynamic, (DatapackCodec)datapackcodec);
                return new WorldSummary(worldsettings, versiondata, p_237267_1_.getName(), flag, p_237267_2_, file1);
            }
            catch (Exception exception) {
                field_215785_a.error("Exception reading {}", p_237268_3_, (Object)exception);
                return null;
            }
        };
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_207742_d(String saveName) {
        try {
            Path path = this.field_215786_c.resolve(saveName);
            Files.createDirectory(path, new FileAttribute[0]);
            Files.deleteIfExists(path);
            return true;
        }
        catch (IOException ioexception) {
            return false;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_90033_f(String saveName) {
        return Files.isDirectory(this.field_215786_c.resolve(saveName), new LinkOption[0]);
    }

    @OnlyIn(value=Dist.CLIENT)
    public Path func_215781_c() {
        return this.field_215786_c;
    }

    @OnlyIn(value=Dist.CLIENT)
    public Path func_197712_e() {
        return this.field_215787_d;
    }

    public LevelSave func_237274_c_(String p_237274_1_) throws IOException {
        return new LevelSave(p_237274_1_);
    }

    public class LevelSave
    implements AutoCloseable {
        private final SessionLockManager field_237278_b_;
        private final Path field_237279_c_;
        private final String field_237280_d_;
        private final Map<FolderName, Path> field_237281_e_ = Maps.newHashMap();

        public LevelSave(String p_i232152_2_) throws IOException {
            this.field_237280_d_ = p_i232152_2_;
            this.field_237279_c_ = SaveFormat.this.field_215786_c.resolve(p_i232152_2_);
            this.field_237278_b_ = SessionLockManager.func_232998_a_((Path)this.field_237279_c_);
        }

        public String func_237282_a_() {
            return this.field_237280_d_;
        }

        public Path func_237285_a_(FolderName p_237285_1_) {
            return this.field_237281_e_.computeIfAbsent(p_237285_1_, p_237293_1_ -> this.field_237279_c_.resolve(p_237293_1_.func_237255_a_()));
        }

        public File func_237291_a_(RegistryKey<World> p_237291_1_) {
            return DimensionType.func_236031_a_(p_237291_1_, (File)this.field_237279_c_.toFile());
        }

        private void func_237301_i_() {
            if (!this.field_237278_b_.func_232997_a_()) {
                throw new IllegalStateException("Lock is no longer valid");
            }
        }

        public PlayerData func_237292_b_() {
            this.func_237301_i_();
            return new PlayerData(this, SaveFormat.this.field_215788_e);
        }

        public boolean func_237295_c_() {
            WorldSummary worldsummary = this.func_237296_d_();
            return worldsummary != null && worldsummary.func_237314_k_().func_237323_a_() != SaveFormat.this.func_215782_e();
        }

        public boolean func_237283_a_(IProgressUpdate p_237283_1_) {
            this.func_237301_i_();
            return AnvilSaveConverter.func_237330_a_((LevelSave)this, (IProgressUpdate)p_237283_1_);
        }

        @Nullable
        public WorldSummary func_237296_d_() {
            this.func_237301_i_();
            return (WorldSummary)SaveFormat.this.func_237266_a_(this.field_237279_c_.toFile(), SaveFormat.this.func_237267_a_(this.field_237279_c_.toFile(), false));
        }

        @Nullable
        public IServerConfiguration func_237284_a_(DynamicOps<INBT> p_237284_1_, DatapackCodec p_237284_2_) {
            this.func_237301_i_();
            return (IServerConfiguration)SaveFormat.this.func_237266_a_(this.field_237279_c_.toFile(), SaveFormat.func_237270_b_((DynamicOps<INBT>)p_237284_1_, p_237284_2_, this));
        }

        @Nullable
        public DatapackCodec func_237297_e_() {
            this.func_237301_i_();
            return (DatapackCodec)SaveFormat.this.func_237266_a_(this.field_237279_c_.toFile(), (p_237289_0_, p_237289_1_) -> SaveFormat.func_237272_b_(p_237289_0_, p_237289_1_));
        }

        public void func_237287_a_(IDynamicRegistries p_237287_1_, IServerConfiguration p_237287_2_) {
            this.func_237288_a_(p_237287_1_, p_237287_2_, null);
        }

        public void func_237288_a_(IDynamicRegistries p_237288_1_, IServerConfiguration p_237288_2_, @Nullable CompoundNBT p_237288_3_) {
            File file1 = this.field_237279_c_.toFile();
            CompoundNBT compoundnbt = p_237288_2_.func_230411_a_(p_237288_1_, p_237288_3_);
            CompoundNBT compoundnbt1 = new CompoundNBT();
            compoundnbt1.func_218657_a("Data", compoundnbt);
            WorldPersistenceHooks.handleWorldDataSave((LevelSave)this, (IServerConfiguration)p_237288_2_, (CompoundNBT)compoundnbt1);
            try {
                File file2 = File.createTempFile("level", ".dat", file1);
                CompressedStreamTools.func_74799_a(compoundnbt1, new FileOutputStream(file2));
                File file3 = new File(file1, "level.dat_old");
                File file4 = new File(file1, "level.dat");
                Util.func_240977_a_((File)file4, (File)file2, (File)file3);
            }
            catch (Exception exception) {
                field_215785_a.error("Failed to save level {}", (Object)file1, (Object)exception);
            }
        }

        public File func_237298_f_() {
            this.func_237301_i_();
            return this.field_237279_c_.resolve("icon.png").toFile();
        }

        public Path getWorldDir() {
            return this.field_237279_c_;
        }

        @OnlyIn(value=Dist.CLIENT)
        public void func_237299_g_() throws IOException {
            this.func_237301_i_();
            final Path path = this.field_237279_c_.resolve("session.lock");
            for (int i = 1; i <= 5; ++i) {
                field_215785_a.info("Attempt {}...", (Object)i);
                try {
                    Files.walkFileTree(this.field_237279_c_, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                        @Override
                        public FileVisitResult visitFile(Path p_visitFile_1_, BasicFileAttributes p_visitFile_2_) throws IOException {
                            if (!p_visitFile_1_.equals(path)) {
                                field_215785_a.debug("Deleting {}", (Object)p_visitFile_1_);
                                Files.delete(p_visitFile_1_);
                            }
                            return FileVisitResult.CONTINUE;
                        }

                        @Override
                        public FileVisitResult postVisitDirectory(Path p_postVisitDirectory_1_, IOException p_postVisitDirectory_2_) throws IOException {
                            if (p_postVisitDirectory_2_ != null) {
                                throw p_postVisitDirectory_2_;
                            }
                            if (p_postVisitDirectory_1_.equals(LevelSave.this.field_237279_c_)) {
                                LevelSave.this.field_237278_b_.close();
                                Files.deleteIfExists(path);
                            }
                            Files.delete(p_postVisitDirectory_1_);
                            return FileVisitResult.CONTINUE;
                        }
                    });
                    break;
                }
                catch (IOException ioexception) {
                    if (i >= 5) {
                        throw ioexception;
                    }
                    field_215785_a.warn("Failed to delete {}", (Object)this.field_237279_c_, (Object)ioexception);
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    continue;
                }
            }
        }

        @OnlyIn(value=Dist.CLIENT)
        public void func_237290_a_(String p_237290_1_) throws IOException {
            File file2;
            this.func_237301_i_();
            File file1 = new File(SaveFormat.this.field_215786_c.toFile(), this.field_237280_d_);
            if (file1.exists() && (file2 = new File(file1, "level.dat")).exists()) {
                CompoundNBT compoundnbt = CompressedStreamTools.func_74796_a(new FileInputStream(file2));
                CompoundNBT compoundnbt1 = compoundnbt.func_74775_l("Data");
                compoundnbt1.func_74778_a("LevelName", p_237290_1_);
                CompressedStreamTools.func_74799_a(compoundnbt, new FileOutputStream(file2));
            }
        }

        @OnlyIn(value=Dist.CLIENT)
        public long func_237300_h_() throws IOException {
            this.func_237301_i_();
            String s = LocalDateTime.now().format(field_197716_d) + "_" + this.field_237280_d_;
            Path path = SaveFormat.this.func_197712_e();
            try {
                Files.createDirectories(Files.exists(path, new LinkOption[0]) ? path.toRealPath(new LinkOption[0]) : path, new FileAttribute[0]);
            }
            catch (IOException ioexception) {
                throw new RuntimeException(ioexception);
            }
            Path path1 = path.resolve(FileUtil.func_214992_a((Path)path, (String)s, (String)".zip"));
            try (final ZipOutputStream zipoutputstream = new ZipOutputStream(new BufferedOutputStream(Files.newOutputStream(path1, new OpenOption[0])));){
                final Path path2 = Paths.get(this.field_237280_d_, new String[0]);
                Files.walkFileTree(this.field_237279_c_, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult visitFile(Path p_visitFile_1_, BasicFileAttributes p_visitFile_2_) throws IOException {
                        if (p_visitFile_1_.endsWith("session.lock")) {
                            return FileVisitResult.CONTINUE;
                        }
                        String s1 = path2.resolve(LevelSave.this.field_237279_c_.relativize(p_visitFile_1_)).toString().replace('\\', '/');
                        ZipEntry zipentry = new ZipEntry(s1);
                        zipoutputstream.putNextEntry(zipentry);
                        com.google.common.io.Files.asByteSource((File)p_visitFile_1_.toFile()).copyTo((OutputStream)zipoutputstream);
                        zipoutputstream.closeEntry();
                        return FileVisitResult.CONTINUE;
                    }
                });
            }
            return Files.size(path1);
        }

        @Override
        public void close() throws IOException {
            this.field_237278_b_.close();
        }
    }
}

