/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.lighting;

import java.util.Arrays;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.SectionPos;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.LightType;
import net.minecraft.world.chunk.IChunkLightProvider;
import net.minecraft.world.chunk.NibbleArray;
import net.minecraft.world.lighting.IWorldLightListener;
import net.minecraft.world.lighting.LevelBasedGraph;
import net.minecraft.world.lighting.LightDataMap;
import net.minecraft.world.lighting.SectionLightStorage;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.lang3.mutable.MutableInt;

public abstract class LightEngine<M extends LightDataMap<M>, S extends SectionLightStorage<M>>
extends LevelBasedGraph
implements IWorldLightListener {
    private static final Direction[] field_215628_d = Direction.values();
    protected final IChunkLightProvider field_215625_a;
    protected final LightType field_215626_b;
    protected final S field_215627_c;
    private boolean field_215629_e;
    protected final BlockPos.Mutable field_215630_f = new BlockPos.Mutable();
    private final long[] field_215631_g = new long[2];
    private final IBlockReader[] field_215632_h = new IBlockReader[2];

    public LightEngine(IChunkLightProvider chunkLightProvider, LightType lightTypeIn, S storageIn) {
        super(16, 256, 8192);
        this.field_215625_a = chunkLightProvider;
        this.field_215626_b = lightTypeIn;
        this.field_215627_c = storageIn;
        this.func_215624_c();
    }

    @Override
    protected void func_215473_f(long worldPos) {
        this.field_215627_c.func_215532_c();
        if (this.field_215627_c.func_215518_g(SectionPos.func_218162_e((long)worldPos))) {
            super.func_215473_f(worldPos);
        }
    }

    @Nullable
    private IBlockReader func_215615_a(int chunkX, int chunkZ) {
        long i = ChunkPos.func_77272_a((int)chunkX, (int)chunkZ);
        for (int j = 0; j < 2; ++j) {
            if (i != this.field_215631_g[j]) continue;
            return this.field_215632_h[j];
        }
        IBlockReader iblockreader = this.field_215625_a.func_217202_b(chunkX, chunkZ);
        for (int k = 1; k > 0; --k) {
            this.field_215631_g[k] = this.field_215631_g[k - 1];
            this.field_215632_h[k] = this.field_215632_h[k - 1];
        }
        this.field_215631_g[0] = i;
        this.field_215632_h[0] = iblockreader;
        return iblockreader;
    }

    private void func_215624_c() {
        Arrays.fill(this.field_215631_g, ChunkPos.field_222244_a);
        Arrays.fill(this.field_215632_h, null);
    }

    protected BlockState func_227468_a_(long p_227468_1_, @Nullable MutableInt p_227468_3_) {
        boolean flag;
        int j;
        if (p_227468_1_ == Long.MAX_VALUE) {
            if (p_227468_3_ != null) {
                p_227468_3_.setValue(0);
            }
            return Blocks.field_150350_a.func_176223_P();
        }
        int i = SectionPos.func_218159_a((int)BlockPos.func_218290_b((long)p_227468_1_));
        IBlockReader iblockreader = this.func_215615_a(i, j = SectionPos.func_218159_a((int)BlockPos.func_218282_d((long)p_227468_1_)));
        if (iblockreader == null) {
            if (p_227468_3_ != null) {
                p_227468_3_.setValue(16);
            }
            return Blocks.field_150357_h.func_176223_P();
        }
        this.field_215630_f.func_218294_g(p_227468_1_);
        BlockState blockstate = iblockreader.func_180495_p((BlockPos)this.field_215630_f);
        boolean bl = flag = blockstate.func_200132_m() && blockstate.func_215691_g();
        if (p_227468_3_ != null) {
            p_227468_3_.setValue(blockstate.func_200016_a(this.field_215625_a.func_212864_k_(), (BlockPos)this.field_215630_f));
        }
        return flag ? blockstate : Blocks.field_150350_a.func_176223_P();
    }

    protected VoxelShape func_223405_a(BlockState blockStateIn, long worldPos, Direction directionIn) {
        return blockStateIn.func_200132_m() ? blockStateIn.func_215702_a(this.field_215625_a.func_212864_k_(), (BlockPos)this.field_215630_f.func_218294_g(worldPos), directionIn) : VoxelShapes.func_197880_a();
    }

    public static int func_215613_a(IBlockReader p_215613_0_, BlockState p_215613_1_, BlockPos p_215613_2_, BlockState p_215613_3_, BlockPos p_215613_4_, Direction p_215613_5_, int p_215613_6_) {
        boolean flag1;
        boolean flag = p_215613_1_.func_200132_m() && p_215613_1_.func_215691_g();
        boolean bl = flag1 = p_215613_3_.func_200132_m() && p_215613_3_.func_215691_g();
        if (!flag && !flag1) {
            return p_215613_6_;
        }
        VoxelShape voxelshape = flag ? p_215613_1_.func_235754_c_(p_215613_0_, p_215613_2_) : VoxelShapes.func_197880_a();
        VoxelShape voxelshape1 = flag1 ? p_215613_3_.func_235754_c_(p_215613_0_, p_215613_4_) : VoxelShapes.func_197880_a();
        return VoxelShapes.func_204642_b((VoxelShape)voxelshape, (VoxelShape)voxelshape1, (Direction)p_215613_5_) ? 16 : p_215613_6_;
    }

    @Override
    protected boolean func_215485_a(long pos) {
        return pos == Long.MAX_VALUE;
    }

    @Override
    protected int func_215477_a(long pos, long excludedSourcePos, int level) {
        return 0;
    }

    @Override
    protected int func_215471_c(long sectionPosIn) {
        return sectionPosIn == Long.MAX_VALUE ? 0 : 15 - this.field_215627_c.func_215521_h(sectionPosIn);
    }

    protected int func_215622_a(NibbleArray array, long worldPos) {
        return 15 - array.func_76582_a(SectionPos.func_218171_b((int)BlockPos.func_218290_b((long)worldPos)), SectionPos.func_218171_b((int)BlockPos.func_218274_c((long)worldPos)), SectionPos.func_218171_b((int)BlockPos.func_218282_d((long)worldPos)));
    }

    @Override
    protected void func_215476_a(long sectionPosIn, int level) {
        this.field_215627_c.func_215517_b(sectionPosIn, Math.min(15, 15 - level));
    }

    @Override
    protected int func_215480_b(long startPos, long endPos, int startLevel) {
        return 0;
    }

    public boolean func_215619_a() {
        return this.func_215481_b() || this.field_215627_c.func_215481_b() || this.field_215627_c.func_215527_a();
    }

    public int func_215616_a(int toUpdateCount, boolean updateSkyLight, boolean updateBlockLight) {
        if (!this.field_215629_e) {
            if (this.field_215627_c.func_215481_b() && (toUpdateCount = this.field_215627_c.func_215483_b(toUpdateCount)) == 0) {
                return toUpdateCount;
            }
            this.field_215627_c.func_215522_a(this, updateSkyLight, updateBlockLight);
        }
        this.field_215629_e = true;
        if (this.func_215481_b()) {
            toUpdateCount = this.func_215483_b(toUpdateCount);
            this.func_215624_c();
            if (toUpdateCount == 0) {
                return toUpdateCount;
            }
        }
        this.field_215629_e = false;
        this.field_215627_c.func_215533_d();
        return toUpdateCount;
    }

    protected void func_215621_a(long sectionPosIn, @Nullable NibbleArray array, boolean p_215621_4_) {
        this.field_215627_c.func_215529_a(sectionPosIn, array, p_215621_4_);
    }

    @Nullable
    public NibbleArray func_215612_a(SectionPos p_215612_1_) {
        return this.field_215627_c.func_222858_h(p_215612_1_.func_218146_v());
    }

    public int func_215611_b(BlockPos worldPos) {
        return this.field_215627_c.func_215525_d(worldPos.func_218275_a());
    }

    @OnlyIn(value=Dist.CLIENT)
    public String func_215614_b(long sectionPosIn) {
        return "" + this.field_215627_c.func_215471_c(sectionPosIn);
    }

    public void func_215617_a(BlockPos worldPos) {
        long i = worldPos.func_218275_a();
        this.func_215473_f(i);
        for (Direction direction : field_215628_d) {
            this.func_215473_f(BlockPos.func_218289_a((long)i, (Direction)direction));
        }
    }

    public void func_215623_a(BlockPos p_215623_1_, int p_215623_2_) {
    }

    public void func_215566_a(SectionPos pos, boolean isEmpty) {
        this.field_215627_c.func_215519_c(pos.func_218146_v(), isEmpty);
    }

    public void func_215620_a(ChunkPos p_215620_1_, boolean p_215620_2_) {
        long i = SectionPos.func_218169_f((long)SectionPos.func_218166_b((int)p_215620_1_.field_77276_a, (int)0, (int)p_215620_1_.field_77275_b));
        this.field_215627_c.func_215526_b(i, p_215620_2_);
    }

    public void func_223129_b(ChunkPos pos, boolean retain) {
        long i = SectionPos.func_218169_f((long)SectionPos.func_218166_b((int)pos.field_77276_a, (int)0, (int)pos.field_77275_b));
        this.field_215627_c.func_223113_c(i, retain);
    }

    @Override
    public abstract int queuedUpdateSize();
}

