/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.math.vector;

import it.unimi.dsi.fastutil.floats.Float2FloatFunction;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Matrix3f;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public final class Vector3f {
    public static Vector3f field_229178_a_ = new Vector3f(-1.0f, 0.0f, 0.0f);
    public static Vector3f field_229179_b_ = new Vector3f(1.0f, 0.0f, 0.0f);
    public static Vector3f field_229180_c_ = new Vector3f(0.0f, -1.0f, 0.0f);
    public static Vector3f field_229181_d_ = new Vector3f(0.0f, 1.0f, 0.0f);
    public static Vector3f field_229182_e_ = new Vector3f(0.0f, 0.0f, -1.0f);
    public static Vector3f field_229183_f_ = new Vector3f(0.0f, 0.0f, 1.0f);
    private float field_229184_g_;
    private float field_229185_h_;
    private float field_229186_i_;

    public Vector3f() {
    }

    public Vector3f(float x, float y, float z) {
        this.field_229184_g_ = x;
        this.field_229185_h_ = y;
        this.field_229186_i_ = z;
    }

    public Vector3f(Vector3d vecIn) {
        this((float)vecIn.field_72450_a, (float)vecIn.field_72448_b, (float)vecIn.field_72449_c);
    }

    public boolean equals(Object p_equals_1_) {
        if (this == p_equals_1_) {
            return true;
        }
        if (p_equals_1_ != null && this.getClass() == p_equals_1_.getClass()) {
            Vector3f vector3f = (Vector3f)p_equals_1_;
            if (Float.compare(vector3f.field_229184_g_, this.field_229184_g_) != 0) {
                return false;
            }
            if (Float.compare(vector3f.field_229185_h_, this.field_229185_h_) != 0) {
                return false;
            }
            return Float.compare(vector3f.field_229186_i_, this.field_229186_i_) == 0;
        }
        return false;
    }

    public int hashCode() {
        int i = Float.floatToIntBits(this.field_229184_g_);
        i = 31 * i + Float.floatToIntBits(this.field_229185_h_);
        return 31 * i + Float.floatToIntBits(this.field_229186_i_);
    }

    public float func_195899_a() {
        return this.field_229184_g_;
    }

    public float func_195900_b() {
        return this.field_229185_h_;
    }

    public float func_195902_c() {
        return this.field_229186_i_;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_195898_a(float multiplier) {
        this.field_229184_g_ *= multiplier;
        this.field_229185_h_ *= multiplier;
        this.field_229186_i_ *= multiplier;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_229192_b_(float mx, float my, float mz) {
        this.field_229184_g_ *= mx;
        this.field_229185_h_ *= my;
        this.field_229186_i_ *= mz;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_195901_a(float min, float max) {
        this.field_229184_g_ = MathHelper.func_76131_a((float)this.field_229184_g_, (float)min, (float)max);
        this.field_229185_h_ = MathHelper.func_76131_a((float)this.field_229185_h_, (float)min, (float)max);
        this.field_229186_i_ = MathHelper.func_76131_a((float)this.field_229186_i_, (float)min, (float)max);
    }

    public void func_195905_a(float x, float y, float z) {
        this.field_229184_g_ = x;
        this.field_229185_h_ = y;
        this.field_229186_i_ = z;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_195904_b(float x, float y, float z) {
        this.field_229184_g_ += x;
        this.field_229185_h_ += y;
        this.field_229186_i_ += z;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_229189_a_(Vector3f vectorIn) {
        this.field_229184_g_ += vectorIn.field_229184_g_;
        this.field_229185_h_ += vectorIn.field_229185_h_;
        this.field_229186_i_ += vectorIn.field_229186_i_;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_195897_a(Vector3f vec) {
        this.field_229184_g_ -= vec.field_229184_g_;
        this.field_229185_h_ -= vec.field_229185_h_;
        this.field_229186_i_ -= vec.field_229186_i_;
    }

    @OnlyIn(value=Dist.CLIENT)
    public float func_195903_b(Vector3f vec) {
        return this.field_229184_g_ * vec.field_229184_g_ + this.field_229185_h_ * vec.field_229185_h_ + this.field_229186_i_ * vec.field_229186_i_;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_229194_d_() {
        float f = this.field_229184_g_ * this.field_229184_g_ + this.field_229185_h_ * this.field_229185_h_ + this.field_229186_i_ * this.field_229186_i_;
        if ((double)f < 1.0E-5) {
            return false;
        }
        float f1 = MathHelper.func_226165_i_((float)f);
        this.field_229184_g_ *= f1;
        this.field_229185_h_ *= f1;
        this.field_229186_i_ *= f1;
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_195896_c(Vector3f vec) {
        float f = this.field_229184_g_;
        float f1 = this.field_229185_h_;
        float f2 = this.field_229186_i_;
        float f3 = vec.func_195899_a();
        float f4 = vec.func_195900_b();
        float f5 = vec.func_195902_c();
        this.field_229184_g_ = f1 * f5 - f2 * f4;
        this.field_229185_h_ = f2 * f3 - f * f5;
        this.field_229186_i_ = f * f4 - f1 * f3;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_229188_a_(Matrix3f matrixIn) {
        float f = this.field_229184_g_;
        float f1 = this.field_229185_h_;
        float f2 = this.field_229186_i_;
        this.field_229184_g_ = matrixIn.field_226097_a_ * f + matrixIn.field_226098_b_ * f1 + matrixIn.field_226099_c_ * f2;
        this.field_229185_h_ = matrixIn.field_226100_d_ * f + matrixIn.field_226101_e_ * f1 + matrixIn.field_226102_f_ * f2;
        this.field_229186_i_ = matrixIn.field_226103_g_ * f + matrixIn.field_226104_h_ * f1 + matrixIn.field_226105_i_ * f2;
    }

    public void func_214905_a(Quaternion quaternionIn) {
        Quaternion quaternion = new Quaternion(quaternionIn);
        quaternion.func_195890_a(new Quaternion(this.func_195899_a(), this.func_195900_b(), this.func_195902_c(), 0.0f));
        Quaternion quaternion1 = new Quaternion(quaternionIn);
        quaternion1.func_195892_e();
        quaternion.func_195890_a(quaternion1);
        this.func_195905_a(quaternion.func_195889_a(), quaternion.func_195891_b(), quaternion.func_195893_c());
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_229190_a_(Vector3f vectorIn, float pctIn) {
        float f = 1.0f - pctIn;
        this.field_229184_g_ = this.field_229184_g_ * f + vectorIn.field_229184_g_ * pctIn;
        this.field_229185_h_ = this.field_229185_h_ * f + vectorIn.field_229185_h_ * pctIn;
        this.field_229186_i_ = this.field_229186_i_ * f + vectorIn.field_229186_i_ * pctIn;
    }

    @OnlyIn(value=Dist.CLIENT)
    public Quaternion func_229193_c_(float valueIn) {
        return new Quaternion(this, valueIn, false);
    }

    @OnlyIn(value=Dist.CLIENT)
    public Quaternion func_229187_a_(float valueIn) {
        return new Quaternion(this, valueIn, true);
    }

    @OnlyIn(value=Dist.CLIENT)
    public Vector3f func_229195_e_() {
        return new Vector3f(this.field_229184_g_, this.field_229185_h_, this.field_229186_i_);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_229191_a_(Float2FloatFunction functionIn) {
        this.field_229184_g_ = functionIn.get(this.field_229184_g_);
        this.field_229185_h_ = functionIn.get(this.field_229185_h_);
        this.field_229186_i_ = functionIn.get(this.field_229186_i_);
    }

    public String toString() {
        return "[" + this.field_229184_g_ + ", " + this.field_229185_h_ + ", " + this.field_229186_i_ + "]";
    }

    public Vector3f(float[] values) {
        this.set(values);
    }

    public void set(float[] values) {
        this.field_229184_g_ = values[0];
        this.field_229185_h_ = values[1];
        this.field_229186_i_ = values[2];
    }

    public void setX(float x) {
        this.field_229184_g_ = x;
    }

    public void setY(float y) {
        this.field_229185_h_ = y;
    }

    public void setZ(float z) {
        this.field_229186_i_ = z;
    }
}

