/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.resources;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.FileSystem;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.resources.FolderPack;
import net.minecraft.resources.IResourcePack;
import net.minecraft.resources.ResourcePack;
import net.minecraft.resources.ResourcePackType;
import net.minecraft.resources.data.IMetadataSectionSerializer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class VanillaPack
implements IResourcePack {
    public static Path field_199754_a;
    private static final Logger field_195784_b;
    public static Class<?> field_211688_b;
    private static final Map<ResourcePackType, FileSystem> field_217810_e;
    public final Set<String> field_195783_a;

    public VanillaPack(String ... resourceNamespacesIn) {
        this.field_195783_a = ImmutableSet.copyOf((Object[])resourceNamespacesIn);
    }

    @Override
    public InputStream func_195763_b(String fileName) throws IOException {
        if (!fileName.contains("/") && !fileName.contains("\\")) {
            Path path;
            if (field_199754_a != null && Files.exists(path = field_199754_a.resolve(fileName), new LinkOption[0])) {
                return Files.newInputStream(path, new OpenOption[0]);
            }
            return this.func_200010_a(fileName);
        }
        throw new IllegalArgumentException("Root resources can only be filenames, not paths (no / allowed!)");
    }

    @Override
    public InputStream func_195761_a(ResourcePackType type, ResourceLocation location) throws IOException {
        InputStream inputstream = this.func_195782_c(type, location);
        if (inputstream != null) {
            return inputstream;
        }
        throw new FileNotFoundException(location.func_110623_a());
    }

    @Override
    public Collection<ResourceLocation> func_225637_a_(ResourcePackType type, String namespaceIn, String pathIn, int maxDepthIn, Predicate<String> filterIn) {
        HashSet set = Sets.newHashSet();
        if (field_199754_a != null) {
            try {
                VanillaPack.func_229867_a_(set, maxDepthIn, namespaceIn, field_199754_a.resolve(type.func_198956_a()), pathIn, filterIn);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (type == ResourcePackType.CLIENT_RESOURCES) {
                Enumeration<URL> enumeration = null;
                try {
                    enumeration = field_211688_b.getClassLoader().getResources(type.func_198956_a() + "/");
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                while (enumeration != null && enumeration.hasMoreElements()) {
                    try {
                        URI uri = ((URL)enumeration.nextElement()).toURI();
                        if (!"file".equals(uri.getScheme())) continue;
                        VanillaPack.func_229867_a_(set, maxDepthIn, namespaceIn, Paths.get(uri), pathIn, filterIn);
                    }
                    catch (IOException | URISyntaxException uri) {}
                }
            }
        }
        try {
            URL url1 = VanillaPack.class.getResource("/" + type.func_198956_a() + "/.mcassetsroot");
            if (url1 == null) {
                field_195784_b.error("Couldn't find .mcassetsroot, cannot load vanilla resources");
                return set;
            }
            URI uri1 = url1.toURI();
            if ("file".equals(uri1.getScheme())) {
                URL url = new URL(url1.toString().substring(0, url1.toString().length() - ".mcassetsroot".length()));
                Path path = Paths.get(url.toURI());
                VanillaPack.func_229867_a_(set, maxDepthIn, namespaceIn, path, pathIn, filterIn);
            } else if ("jar".equals(uri1.getScheme())) {
                Path path1 = field_217810_e.get(type).getPath("/" + type.func_198956_a(), new String[0]);
                VanillaPack.func_229867_a_(set, maxDepthIn, "minecraft", path1, pathIn, filterIn);
            } else {
                field_195784_b.error("Unsupported scheme {} trying to list vanilla resources (NYI?)", (Object)uri1);
            }
        }
        catch (FileNotFoundException | NoSuchFileException url1) {
        }
        catch (IOException | URISyntaxException urisyntaxexception) {
            field_195784_b.error("Couldn't get a list of all vanilla resources", (Throwable)urisyntaxexception);
        }
        return set;
    }

    private static void func_229867_a_(Collection<ResourceLocation> resourceLocationsIn, int maxDepthIn, String namespaceIn, Path pathIn, String pathNameIn, Predicate<String> filterIn) throws IOException {
        Path path = pathIn.resolve(namespaceIn);
        try (Stream<Path> stream = Files.walk(path.resolve(pathNameIn), maxDepthIn, new FileVisitOption[0]);){
            stream.filter(p_229868_1_ -> !p_229868_1_.endsWith(".mcmeta") && Files.isRegularFile(p_229868_1_, new LinkOption[0]) && filterIn.test(p_229868_1_.getFileName().toString())).map(p_229866_2_ -> new ResourceLocation(namespaceIn, path.relativize((Path)p_229866_2_).toString().replaceAll("\\\\", "/"))).forEach(resourceLocationsIn::add);
        }
    }

    @Nullable
    protected InputStream func_195782_c(ResourcePackType type, ResourceLocation location) {
        Path path;
        String s = VanillaPack.func_223458_d(type, location);
        if (field_199754_a != null && Files.exists(path = field_199754_a.resolve(type.func_198956_a() + "/" + location.func_110624_b() + "/" + location.func_110623_a()), new LinkOption[0])) {
            try {
                return Files.newInputStream(path, new OpenOption[0]);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        try {
            URL url = VanillaPack.class.getResource(s);
            return VanillaPack.func_223459_a(s, url) ? this.getExtraInputStream(type, s) : null;
        }
        catch (IOException ioexception) {
            return VanillaPack.class.getResourceAsStream(s);
        }
    }

    private static String func_223458_d(ResourcePackType packTypeIn, ResourceLocation locationIn) {
        return "/" + packTypeIn.func_198956_a() + "/" + locationIn.func_110624_b() + "/" + locationIn.func_110623_a();
    }

    private static boolean func_223459_a(String pathIn, @Nullable URL urlIn) throws IOException {
        return urlIn != null && (urlIn.getProtocol().equals("jar") || FolderPack.func_195777_a((File)new File(urlIn.getFile()), (String)pathIn));
    }

    @Nullable
    protected InputStream func_200010_a(String pathIn) {
        return this.getExtraInputStream(ResourcePackType.SERVER_DATA, "/" + pathIn);
    }

    @Override
    public boolean func_195764_b(ResourcePackType type, ResourceLocation location) {
        Path path;
        String s = VanillaPack.func_223458_d(type, location);
        if (field_199754_a != null && Files.exists(path = field_199754_a.resolve(type.func_198956_a() + "/" + location.func_110624_b() + "/" + location.func_110623_a()), new LinkOption[0])) {
            return true;
        }
        try {
            URL url = VanillaPack.class.getResource(s);
            return VanillaPack.func_223459_a(s, url);
        }
        catch (IOException ioexception) {
            return false;
        }
    }

    @Override
    public Set<String> func_195759_a(ResourcePackType type) {
        return this.field_195783_a;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @Nullable
    public <T> T func_195760_a(IMetadataSectionSerializer<T> deserializer) throws IOException {
        try (InputStream inputstream = this.func_195763_b("pack.mcmeta");){
            Object object = ResourcePack.func_195770_a(deserializer, (InputStream)inputstream);
            return (T)object;
        }
        catch (FileNotFoundException | RuntimeException runtimeexception) {
            return null;
        }
    }

    @Override
    public String func_195762_a() {
        return "Default";
    }

    @Override
    public void close() {
    }

    private InputStream getExtraInputStream(ResourcePackType type, String resource) {
        try {
            FileSystem fs = field_217810_e.get(type);
            if (fs != null) {
                return Files.newInputStream(fs.getPath(resource, new String[0]), new OpenOption[0]);
            }
            return VanillaPack.class.getResourceAsStream(resource);
        }
        catch (IOException e) {
            return VanillaPack.class.getResourceAsStream(resource);
        }
    }

    static {
        field_195784_b = LogManager.getLogger();
        field_217810_e = (Map)Util.func_200696_a((Object)Maps.newHashMap(), p_217809_0_ -> {
            Class<VanillaPack> clazz = VanillaPack.class;
            synchronized (VanillaPack.class) {
                for (ResourcePackType resourcepacktype : ResourcePackType.values()) {
                    URL url = VanillaPack.class.getResource("/" + resourcepacktype.func_198956_a() + "/.mcassetsroot");
                    try {
                        FileSystem filesystem;
                        URI uri = url.toURI();
                        if (!"jar".equals(uri.getScheme())) continue;
                        try {
                            filesystem = FileSystems.getFileSystem(uri);
                        }
                        catch (FileSystemNotFoundException filesystemnotfoundexception) {
                            filesystem = FileSystems.newFileSystem(uri, Collections.emptyMap());
                        }
                        p_217809_0_.put(resourcepacktype, filesystem);
                    }
                    catch (IOException | URISyntaxException urisyntaxexception) {
                        field_195784_b.error("Couldn't get a list of all vanilla resources", (Throwable)urisyntaxexception);
                    }
                }
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
        });
    }
}

