/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.item;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.enchantment.IVanishable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.IItemTier;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.TieredItem;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.common.ToolType;

public class ToolItem
extends TieredItem
implements IVanishable {
    private final Set<Block> field_150914_c;
    protected final float field_77864_a;
    private final float field_77865_bY;
    private final Multimap<Attribute, AttributeModifier> field_234674_d_;

    public ToolItem(float attackDamageIn, float attackSpeedIn, IItemTier tier, Set<Block> effectiveBlocksIn, Item.Properties p_i48512_5_) {
        super(tier, p_i48512_5_);
        this.field_150914_c = effectiveBlocksIn;
        this.field_77864_a = tier.func_200928_b();
        this.field_77865_bY = attackDamageIn + tier.func_200929_c();
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        builder.put((Object)Attributes.field_233823_f_, (Object)new AttributeModifier(field_111210_e, "Tool modifier", (double)this.field_77865_bY, AttributeModifier.Operation.ADDITION));
        builder.put((Object)Attributes.field_233825_h_, (Object)new AttributeModifier(field_185050_h, "Tool modifier", (double)attackSpeedIn, AttributeModifier.Operation.ADDITION));
        this.field_234674_d_ = builder.build();
    }

    public float func_150893_a(ItemStack stack, BlockState state) {
        if (this.getToolTypes(stack).stream().anyMatch(e -> state.isToolEffective((ToolType)e))) {
            return this.field_77864_a;
        }
        return this.field_150914_c.contains((Object)state.func_177230_c()) ? this.field_77864_a : 1.0f;
    }

    public boolean func_77644_a(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        stack.func_222118_a(2, attacker, p_220039_0_ -> p_220039_0_.func_213361_c(EquipmentSlotType.MAINHAND));
        return true;
    }

    public boolean func_179218_a(ItemStack stack, World worldIn, BlockState state, BlockPos pos, LivingEntity entityLiving) {
        if (!worldIn.field_72995_K && state.func_185887_b((IBlockReader)((Object)worldIn), pos) != 0.0f) {
            stack.func_222118_a(1, entityLiving, p_220038_0_ -> p_220038_0_.func_213361_c(EquipmentSlotType.MAINHAND));
        }
        return true;
    }

    public Multimap<Attribute, AttributeModifier> func_111205_h(EquipmentSlotType equipmentSlot) {
        return equipmentSlot == EquipmentSlotType.MAINHAND ? this.field_234674_d_ : super.func_111205_h(equipmentSlot);
    }

    public float func_234675_d_() {
        return this.field_77865_bY;
    }
}

