/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.passive;

import com.google.common.collect.Sets;
import java.util.EnumSet;
import java.util.Random;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.TurtleEggBlock;
import net.minecraft.dispenser.IPosition;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityPredicate;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.RandomPositionGenerator;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.controller.MovementController;
import net.minecraft.entity.ai.goal.BreedGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.MoveToBlockGoal;
import net.minecraft.entity.ai.goal.RandomWalkingGoal;
import net.minecraft.entity.effect.LightningBoltEntity;
import net.minecraft.entity.item.ExperienceOrbEntity;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.PathFinder;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.pathfinding.SwimmerPathNavigator;
import net.minecraft.pathfinding.WalkAndSwimNodeProcessor;
import net.minecraft.state.Property;
import net.minecraft.stats.Stats;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.GameRules;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;

public class TurtleEntity
extends AnimalEntity {
    private static final DataParameter<BlockPos> field_203030_by = EntityDataManager.func_187226_a(TurtleEntity.class, DataSerializers.field_187200_j);
    private static final DataParameter<Boolean> field_203031_bz = EntityDataManager.func_187226_a(TurtleEntity.class, DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> field_203024_bB = EntityDataManager.func_187226_a(TurtleEntity.class, DataSerializers.field_187198_h);
    private static final DataParameter<BlockPos> field_203025_bC = EntityDataManager.func_187226_a(TurtleEntity.class, DataSerializers.field_187200_j);
    private static final DataParameter<Boolean> field_203026_bD = EntityDataManager.func_187226_a(TurtleEntity.class, DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> field_203027_bE = EntityDataManager.func_187226_a(TurtleEntity.class, DataSerializers.field_187198_h);
    private int field_203028_bF;
    public static final Predicate<LivingEntity> field_203029_bx = p_213616_0_ -> p_213616_0_.func_70631_g_() && !p_213616_0_.func_70090_H();

    public TurtleEntity(EntityType<? extends TurtleEntity> type, World worldIn) {
        super(type, worldIn);
        this.func_184644_a(PathNodeType.WATER, 0.0f);
        this.field_70765_h = new MoveHelperController(this);
        this.field_70138_W = 1.0f;
    }

    public void func_203011_g(BlockPos position) {
        this.field_70180_af.func_187227_b(field_203030_by, position);
    }

    private BlockPos func_203018_dA() {
        return this.field_70180_af.func_187225_a(field_203030_by);
    }

    private void func_203019_h(BlockPos position) {
        this.field_70180_af.func_187227_b(field_203025_bC, position);
    }

    private BlockPos func_203013_dB() {
        return this.field_70180_af.func_187225_a(field_203025_bC);
    }

    public boolean func_203020_dx() {
        return this.field_70180_af.func_187225_a(field_203031_bz);
    }

    private void func_203017_r(boolean hasEgg) {
        this.field_70180_af.func_187227_b(field_203031_bz, hasEgg);
    }

    public boolean func_203023_dy() {
        return this.field_70180_af.func_187225_a(field_203024_bB);
    }

    private void func_203015_s(boolean isDigging) {
        this.field_203028_bF = isDigging ? 1 : 0;
        this.field_70180_af.func_187227_b(field_203024_bB, isDigging);
    }

    private boolean func_203022_dF() {
        return this.field_70180_af.func_187225_a(field_203026_bD);
    }

    private void func_203012_t(boolean isGoingHome) {
        this.field_70180_af.func_187227_b(field_203026_bD, isGoingHome);
    }

    private boolean func_203014_dG() {
        return this.field_70180_af.func_187225_a(field_203027_bE);
    }

    private void func_203021_u(boolean isTravelling) {
        this.field_70180_af.func_187227_b(field_203027_bE, isTravelling);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(field_203030_by, BlockPos.field_177992_a);
        this.field_70180_af.func_187214_a(field_203031_bz, false);
        this.field_70180_af.func_187214_a(field_203025_bC, BlockPos.field_177992_a);
        this.field_70180_af.func_187214_a(field_203026_bD, false);
        this.field_70180_af.func_187214_a(field_203027_bE, false);
        this.field_70180_af.func_187214_a(field_203024_bB, false);
    }

    @Override
    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74768_a("HomePosX", this.func_203018_dA().func_177958_n());
        compound.func_74768_a("HomePosY", this.func_203018_dA().func_177956_o());
        compound.func_74768_a("HomePosZ", this.func_203018_dA().func_177952_p());
        compound.func_74757_a("HasEgg", this.func_203020_dx());
        compound.func_74768_a("TravelPosX", this.func_203013_dB().func_177958_n());
        compound.func_74768_a("TravelPosY", this.func_203013_dB().func_177956_o());
        compound.func_74768_a("TravelPosZ", this.func_203013_dB().func_177952_p());
    }

    @Override
    public void func_70037_a(CompoundNBT compound) {
        int i = compound.func_74762_e("HomePosX");
        int j = compound.func_74762_e("HomePosY");
        int k = compound.func_74762_e("HomePosZ");
        this.func_203011_g(new BlockPos(i, j, k));
        super.func_70037_a(compound);
        this.func_203017_r(compound.func_74767_n("HasEgg"));
        int l = compound.func_74762_e("TravelPosX");
        int i1 = compound.func_74762_e("TravelPosY");
        int j1 = compound.func_74762_e("TravelPosZ");
        this.func_203019_h(new BlockPos(l, i1, j1));
    }

    @Nullable
    public ILivingEntityData func_213386_a(IWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, @Nullable ILivingEntityData spawnDataIn, @Nullable CompoundNBT dataTag) {
        this.func_203011_g(this.func_233580_cy_());
        this.func_203019_h(BlockPos.field_177992_a);
        return super.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    public static boolean func_223322_c(EntityType<TurtleEntity> p_223322_0_, IWorld p_223322_1_, SpawnReason reason, BlockPos p_223322_3_, Random p_223322_4_) {
        return p_223322_3_.func_177956_o() < p_223322_1_.func_181545_F() + 4 && TurtleEggBlock.func_203168_a((IBlockReader)p_223322_1_, p_223322_3_) && p_223322_1_.func_226659_b_(p_223322_3_, 0) > 8;
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (Goal)new PanicGoal(this, 1.2));
        this.field_70714_bg.func_75776_a(1, (Goal)new MateGoal(this, 1.0));
        this.field_70714_bg.func_75776_a(1, (Goal)new LayEggGoal(this, 1.0));
        this.field_70714_bg.func_75776_a(2, (Goal)new PlayerTemptGoal(this, 1.1, Blocks.field_203198_aQ.func_199767_j()));
        this.field_70714_bg.func_75776_a(3, (Goal)new GoToWaterGoal(this, 1.0));
        this.field_70714_bg.func_75776_a(4, (Goal)new GoHomeGoal(this, 1.0));
        this.field_70714_bg.func_75776_a(7, (Goal)new TravelGoal(this, 1.0));
        this.field_70714_bg.func_75776_a(8, (Goal)new LookAtGoal((MobEntity)((Object)this), PlayerEntity.class, 8.0f));
        this.field_70714_bg.func_75776_a(9, (Goal)new WanderGoal(this, 1.0, 100));
    }

    public static AttributeModifierMap.MutableAttribute func_234228_eK_() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 30.0).func_233815_a_(Attributes.field_233821_d_, 0.25);
    }

    public boolean func_96092_aw() {
        return false;
    }

    public boolean func_70648_aU() {
        return true;
    }

    public CreatureAttribute func_70668_bt() {
        return CreatureAttribute.field_203100_e;
    }

    @Override
    public int func_70627_aG() {
        return 200;
    }

    @Nullable
    protected SoundEvent func_184639_G() {
        return !this.func_70090_H() && this.field_70122_E && !this.func_70631_g_() ? SoundEvents.field_203277_iv : super.func_184639_G();
    }

    protected void func_203006_d(float volume) {
        super.func_203006_d(volume * 1.5f);
    }

    protected SoundEvent func_184184_Z() {
        return SoundEvents.field_203265_iE;
    }

    @Nullable
    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return this.func_70631_g_() ? SoundEvents.field_203262_iB : SoundEvents.field_203261_iA;
    }

    @Nullable
    protected SoundEvent func_184615_bR() {
        return this.func_70631_g_() ? SoundEvents.field_203264_iD : SoundEvents.field_203263_iC;
    }

    protected void func_180429_a(BlockPos pos, BlockState blockIn) {
        SoundEvent soundevent = this.func_70631_g_() ? SoundEvents.field_203267_iG : SoundEvents.field_203266_iF;
        this.func_184185_a(soundevent, 0.15f, 1.0f);
    }

    @Override
    public boolean func_204701_dC() {
        return super.func_204701_dC() && !this.func_203020_dx();
    }

    protected float func_203009_ad() {
        return this.field_82151_R + 0.15f;
    }

    public float func_213355_cm() {
        return this.func_70631_g_() ? 0.3f : 1.0f;
    }

    protected PathNavigator func_175447_b(World worldIn) {
        return new Navigator(this, worldIn);
    }

    @Nullable
    public AgeableEntity func_90011_a(AgeableEntity ageable) {
        return EntityType.field_203099_aq.func_200721_a(this.field_70170_p);
    }

    @Override
    public boolean func_70877_b(ItemStack stack) {
        return stack.func_77973_b() == Blocks.field_203198_aQ.func_199767_j();
    }

    @Override
    public float func_205022_a(BlockPos pos, IWorldReader worldIn) {
        if (!this.func_203022_dF() && worldIn.func_204610_c(pos).func_206884_a(FluidTags.field_206959_a)) {
            return 10.0f;
        }
        return TurtleEggBlock.func_203168_a((IBlockReader)((Object)worldIn), pos) ? 10.0f : worldIn.func_205052_D(pos) - 0.5f;
    }

    @Override
    public void func_70636_d() {
        BlockPos blockpos;
        super.func_70636_d();
        if (this.func_70089_S() && this.func_203023_dy() && this.field_203028_bF >= 1 && this.field_203028_bF % 5 == 0 && TurtleEggBlock.func_203168_a((IBlockReader)((Object)this.field_70170_p), blockpos = this.func_233580_cy_())) {
            this.field_70170_p.func_217379_c(2001, blockpos, Block.func_196246_j(Blocks.field_150354_m.func_176223_P()));
        }
    }

    protected void func_175500_n() {
        super.func_175500_n();
        if (!this.func_70631_g_() && this.field_70170_p.func_82736_K().func_223586_b(GameRules.field_223602_e)) {
            this.func_199702_a(Items.field_203183_eM, 1);
        }
    }

    public void func_213352_e(Vector3d p_213352_1_) {
        if (this.func_70613_aW() && this.func_70090_H()) {
            this.func_213309_a(0.1f, p_213352_1_);
            this.func_213315_a(MoverType.SELF, this.func_213322_ci());
            this.func_213317_d(this.func_213322_ci().func_186678_a(0.9));
            if (!(this.func_70638_az() != null || this.func_203022_dF() && this.func_203018_dA().func_218137_a((IPosition)this.func_213303_ch(), 20.0))) {
                this.func_213317_d(this.func_213322_ci().func_72441_c(0.0, -0.005, 0.0));
            }
        } else {
            super.func_213352_e(p_213352_1_);
        }
    }

    public boolean func_184652_a(PlayerEntity player) {
        return false;
    }

    public void func_70077_a(LightningBoltEntity lightningBolt) {
        this.func_70097_a(DamageSource.field_180137_b, Float.MAX_VALUE);
    }

    static class WanderGoal
    extends RandomWalkingGoal {
        private final TurtleEntity field_203123_h;

        private WanderGoal(TurtleEntity turtle, double speedIn, int chance) {
            super((CreatureEntity)turtle, speedIn, chance);
            this.field_203123_h = turtle;
        }

        public boolean func_75250_a() {
            return !this.field_75457_a.func_70090_H() && !this.field_203123_h.func_203022_dF() && !this.field_203123_h.func_203020_dx() ? super.func_75250_a() : false;
        }
    }

    static class TravelGoal
    extends Goal {
        private final TurtleEntity field_203137_a;
        private final double field_203138_b;
        private boolean field_203139_c;

        TravelGoal(TurtleEntity turtle, double speedIn) {
            this.field_203137_a = turtle;
            this.field_203138_b = speedIn;
        }

        public boolean func_75250_a() {
            return !this.field_203137_a.func_203022_dF() && !this.field_203137_a.func_203020_dx() && this.field_203137_a.func_70090_H();
        }

        public void func_75249_e() {
            int i = 512;
            int j = 4;
            Random random = this.field_203137_a.field_70146_Z;
            int k = random.nextInt(1025) - 512;
            int l = random.nextInt(9) - 4;
            int i1 = random.nextInt(1025) - 512;
            if ((double)l + this.field_203137_a.func_226278_cu_() > (double)(this.field_203137_a.field_70170_p.func_181545_F() - 1)) {
                l = 0;
            }
            BlockPos blockpos = new BlockPos((double)k + this.field_203137_a.func_226277_ct_(), (double)l + this.field_203137_a.func_226278_cu_(), (double)i1 + this.field_203137_a.func_226281_cx_());
            this.field_203137_a.func_203019_h(blockpos);
            this.field_203137_a.func_203021_u(true);
            this.field_203139_c = false;
        }

        public void func_75246_d() {
            if (this.field_203137_a.func_70661_as().func_75500_f()) {
                Vector3d vector3d = Vector3d.func_237492_c_((Vector3i)this.field_203137_a.func_203013_dB());
                Vector3d vector3d1 = RandomPositionGenerator.func_203155_a((CreatureEntity)this.field_203137_a, (int)16, (int)3, (Vector3d)vector3d, (double)0.3141592741012573);
                if (vector3d1 == null) {
                    vector3d1 = RandomPositionGenerator.func_75464_a((CreatureEntity)this.field_203137_a, (int)8, (int)7, (Vector3d)vector3d);
                }
                if (vector3d1 != null) {
                    int i = MathHelper.func_76128_c((double)vector3d1.field_72450_a);
                    int j = MathHelper.func_76128_c((double)vector3d1.field_72449_c);
                    int k = 34;
                    if (!this.field_203137_a.field_70170_p.func_217344_a(i - 34, 0, j - 34, i + 34, 0, j + 34)) {
                        vector3d1 = null;
                    }
                }
                if (vector3d1 == null) {
                    this.field_203139_c = true;
                    return;
                }
                this.field_203137_a.func_70661_as().func_75492_a(vector3d1.field_72450_a, vector3d1.field_72448_b, vector3d1.field_72449_c, this.field_203138_b);
            }
        }

        public boolean func_75253_b() {
            return !this.field_203137_a.func_70661_as().func_75500_f() && !this.field_203139_c && !this.field_203137_a.func_203022_dF() && !this.field_203137_a.func_70880_s() && !this.field_203137_a.func_203020_dx();
        }

        public void func_75251_c() {
            this.field_203137_a.func_203021_u(false);
            super.func_75251_c();
        }
    }

    static class PlayerTemptGoal
    extends Goal {
        private static final EntityPredicate field_220834_a = new EntityPredicate().func_221013_a(10.0).func_221011_b().func_221008_a();
        private final TurtleEntity field_203132_a;
        private final double field_203133_b;
        private PlayerEntity field_203134_c;
        private int field_203135_d;
        private final Set<Item> field_203136_e;

        PlayerTemptGoal(TurtleEntity turtle, double speedIn, Item temptItem) {
            this.field_203132_a = turtle;
            this.field_203133_b = speedIn;
            this.field_203136_e = Sets.newHashSet((Object[])new Item[]{temptItem});
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean func_75250_a() {
            if (this.field_203135_d > 0) {
                --this.field_203135_d;
                return false;
            }
            this.field_203134_c = this.field_203132_a.field_70170_p.func_217370_a(field_220834_a, (LivingEntity)((Object)this.field_203132_a));
            if (this.field_203134_c == null) {
                return false;
            }
            return this.func_203131_a(this.field_203134_c.func_184614_ca()) || this.func_203131_a(this.field_203134_c.func_184592_cb());
        }

        private boolean func_203131_a(ItemStack p_203131_1_) {
            return this.field_203136_e.contains((Object)p_203131_1_.func_77973_b());
        }

        public boolean func_75253_b() {
            return this.func_75250_a();
        }

        public void func_75251_c() {
            this.field_203134_c = null;
            this.field_203132_a.func_70661_as().func_75499_g();
            this.field_203135_d = 100;
        }

        public void func_75246_d() {
            this.field_203132_a.func_70671_ap().func_75651_a((Entity)this.field_203134_c, (float)(this.field_203132_a.func_184649_cE() + 20), (float)this.field_203132_a.func_70646_bf());
            if (this.field_203132_a.func_70068_e(this.field_203134_c) < 6.25) {
                this.field_203132_a.func_70661_as().func_75499_g();
            } else {
                this.field_203132_a.func_70661_as().func_75497_a((Entity)this.field_203134_c, this.field_203133_b);
            }
        }
    }

    static class PanicGoal
    extends net.minecraft.entity.ai.goal.PanicGoal {
        PanicGoal(TurtleEntity turtle, double speedIn) {
            super((CreatureEntity)turtle, speedIn);
        }

        public boolean func_75250_a() {
            if (this.field_75267_a.func_70643_av() == null && !this.field_75267_a.func_70027_ad()) {
                return false;
            }
            BlockPos blockpos = this.func_188497_a((IBlockReader)((Object)this.field_75267_a.field_70170_p), (Entity)this.field_75267_a, 7, 4);
            if (blockpos != null) {
                this.field_75266_c = blockpos.func_177958_n();
                this.field_75263_d = blockpos.func_177956_o();
                this.field_75264_e = blockpos.func_177952_p();
                return true;
            }
            return this.func_190863_f();
        }
    }

    static class Navigator
    extends SwimmerPathNavigator {
        Navigator(TurtleEntity turtle, World worldIn) {
            super((MobEntity)((Object)turtle), worldIn);
        }

        protected boolean func_75485_k() {
            return true;
        }

        protected PathFinder func_179679_a(int p_179679_1_) {
            this.field_179695_a = new WalkAndSwimNodeProcessor();
            return new PathFinder(this.field_179695_a, p_179679_1_);
        }

        public boolean func_188555_b(BlockPos pos) {
            TurtleEntity turtleentity;
            if (this.field_75515_a instanceof TurtleEntity && (turtleentity = (TurtleEntity)((Object)this.field_75515_a)).func_203014_dG()) {
                return this.field_75513_b.func_180495_p(pos).func_203425_a(Blocks.field_150355_j);
            }
            return !this.field_75513_b.func_180495_p(pos.func_177977_b()).func_196958_f();
        }
    }

    static class MoveHelperController
    extends MovementController {
        private final TurtleEntity field_203103_i;

        MoveHelperController(TurtleEntity turtleIn) {
            super((MobEntity)((Object)turtleIn));
            this.field_203103_i = turtleIn;
        }

        private void func_203102_g() {
            if (this.field_203103_i.func_70090_H()) {
                this.field_203103_i.func_213317_d(this.field_203103_i.func_213322_ci().func_72441_c(0.0, 0.005, 0.0));
                if (!this.field_203103_i.func_203018_dA().func_218137_a((IPosition)this.field_203103_i.func_213303_ch(), 16.0)) {
                    this.field_203103_i.func_70659_e(Math.max(this.field_203103_i.func_70689_ay() / 2.0f, 0.08f));
                }
                if (this.field_203103_i.func_70631_g_()) {
                    this.field_203103_i.func_70659_e(Math.max(this.field_203103_i.func_70689_ay() / 3.0f, 0.06f));
                }
            } else if (this.field_203103_i.field_70122_E) {
                this.field_203103_i.func_70659_e(Math.max(this.field_203103_i.func_70689_ay() / 2.0f, 0.06f));
            }
        }

        public void func_75641_c() {
            this.func_203102_g();
            if (this.field_188491_h == MovementController.Action.MOVE_TO && !this.field_203103_i.func_70661_as().func_75500_f()) {
                double d0 = this.field_75646_b - this.field_203103_i.func_226277_ct_();
                double d1 = this.field_75647_c - this.field_203103_i.func_226278_cu_();
                double d2 = this.field_75644_d - this.field_203103_i.func_226281_cx_();
                double d3 = MathHelper.func_76133_a((double)(d0 * d0 + d1 * d1 + d2 * d2));
                float f = (float)(MathHelper.func_181159_b((double)d2, (double)d0) * 57.2957763671875) - 90.0f;
                this.field_203103_i.field_70761_aq = this.field_203103_i.field_70177_z = this.func_75639_a(this.field_203103_i.field_70177_z, f, 90.0f);
                float f1 = (float)(this.field_75645_e * this.field_203103_i.func_233637_b_(Attributes.field_233821_d_));
                this.field_203103_i.func_70659_e(MathHelper.func_219799_g((float)0.125f, (float)this.field_203103_i.func_70689_ay(), (float)f1));
                this.field_203103_i.func_213317_d(this.field_203103_i.func_213322_ci().func_72441_c(0.0, (double)this.field_203103_i.func_70689_ay() * (d1 /= d3) * 0.1, 0.0));
            } else {
                this.field_203103_i.func_70659_e(0.0f);
            }
        }
    }

    static class MateGoal
    extends BreedGoal {
        private final TurtleEntity field_203107_f;

        MateGoal(TurtleEntity turtle, double speedIn) {
            super((AnimalEntity)turtle, speedIn);
            this.field_203107_f = turtle;
        }

        public boolean func_75250_a() {
            return super.func_75250_a() && !this.field_203107_f.func_203020_dx();
        }

        protected void func_75388_i() {
            ServerPlayerEntity serverplayerentity = this.field_75390_d.func_191993_do();
            if (serverplayerentity == null && this.field_75391_e.func_191993_do() != null) {
                serverplayerentity = this.field_75391_e.func_191993_do();
            }
            if (serverplayerentity != null) {
                serverplayerentity.func_195066_a(Stats.field_151186_x);
                CriteriaTriggers.field_192134_n.func_192168_a(serverplayerentity, this.field_75390_d, this.field_75391_e, (AgeableEntity)null);
            }
            this.field_203107_f.func_203017_r(true);
            this.field_75390_d.func_70875_t();
            this.field_75391_e.func_70875_t();
            Random random = this.field_75390_d.func_70681_au();
            if (this.field_75394_a.func_82736_K().func_223586_b(GameRules.field_223602_e)) {
                this.field_75394_a.func_217376_c(new ExperienceOrbEntity(this.field_75394_a, this.field_75390_d.func_226277_ct_(), this.field_75390_d.func_226278_cu_(), this.field_75390_d.func_226281_cx_(), random.nextInt(7) + 1));
            }
        }
    }

    static class LayEggGoal
    extends MoveToBlockGoal {
        private final TurtleEntity field_203122_f;

        LayEggGoal(TurtleEntity turtle, double speedIn) {
            super((CreatureEntity)turtle, speedIn, 16);
            this.field_203122_f = turtle;
        }

        public boolean func_75250_a() {
            return this.field_203122_f.func_203020_dx() && this.field_203122_f.func_203018_dA().func_218137_a((IPosition)this.field_203122_f.func_213303_ch(), 9.0) ? super.func_75250_a() : false;
        }

        public boolean func_75253_b() {
            return super.func_75253_b() && this.field_203122_f.func_203020_dx() && this.field_203122_f.func_203018_dA().func_218137_a((IPosition)this.field_203122_f.func_213303_ch(), 9.0);
        }

        public void func_75246_d() {
            super.func_75246_d();
            BlockPos blockpos = this.field_203122_f.func_233580_cy_();
            if (!this.field_203122_f.func_70090_H() && this.func_179487_f()) {
                if (this.field_203122_f.field_203028_bF < 1) {
                    this.field_203122_f.func_203015_s(true);
                } else if (this.field_203122_f.field_203028_bF > 200) {
                    World world = this.field_203122_f.field_70170_p;
                    world.func_184133_a(null, blockpos, SoundEvents.field_203278_iw, SoundCategory.BLOCKS, 0.3f, 0.9f + world.field_73012_v.nextFloat() * 0.2f);
                    world.func_180501_a(this.field_179494_b.func_177984_a(), (BlockState)((Object)Blocks.field_203213_jA.func_176223_P().func_206870_a((Property)TurtleEggBlock.field_203171_b, Integer.valueOf(this.field_203122_f.field_70146_Z.nextInt(4) + 1))), 3);
                    this.field_203122_f.func_203017_r(false);
                    this.field_203122_f.func_203015_s(false);
                    this.field_203122_f.func_204700_e(600);
                }
                if (this.field_203122_f.func_203023_dy()) {
                    this.field_203122_f.field_203028_bF++;
                }
            }
        }

        protected boolean func_179488_a(IWorldReader worldIn, BlockPos pos) {
            return !worldIn.func_175623_d(pos.func_177984_a()) ? false : TurtleEggBlock.func_241473_b_((IBlockReader)((Object)worldIn), pos);
        }
    }

    static class GoToWaterGoal
    extends MoveToBlockGoal {
        private final TurtleEntity field_203121_f;

        private GoToWaterGoal(TurtleEntity turtle, double speedIn) {
            super((CreatureEntity)turtle, turtle.func_70631_g_() ? 2.0 : speedIn, 24);
            this.field_203121_f = turtle;
            this.field_203112_e = -1;
        }

        public boolean func_75253_b() {
            return !this.field_203121_f.func_70090_H() && this.field_179493_e <= 1200 && this.func_179488_a((IWorldReader)((Object)this.field_203121_f.field_70170_p), this.field_179494_b);
        }

        public boolean func_75250_a() {
            if (this.field_203121_f.func_70631_g_() && !this.field_203121_f.func_70090_H()) {
                return super.func_75250_a();
            }
            return !this.field_203121_f.func_203022_dF() && !this.field_203121_f.func_70090_H() && !this.field_203121_f.func_203020_dx() ? super.func_75250_a() : false;
        }

        public boolean func_203108_i() {
            return this.field_179493_e % 160 == 0;
        }

        protected boolean func_179488_a(IWorldReader worldIn, BlockPos pos) {
            return worldIn.func_180495_p(pos).func_203425_a(Blocks.field_150355_j);
        }
    }

    static class GoHomeGoal
    extends Goal {
        private final TurtleEntity field_203127_a;
        private final double field_203128_b;
        private boolean field_203129_c;
        private int field_203130_d;

        GoHomeGoal(TurtleEntity turtle, double speedIn) {
            this.field_203127_a = turtle;
            this.field_203128_b = speedIn;
        }

        public boolean func_75250_a() {
            if (this.field_203127_a.func_70631_g_()) {
                return false;
            }
            if (this.field_203127_a.func_203020_dx()) {
                return true;
            }
            if (this.field_203127_a.func_70681_au().nextInt(700) != 0) {
                return false;
            }
            return !this.field_203127_a.func_203018_dA().func_218137_a((IPosition)this.field_203127_a.func_213303_ch(), 64.0);
        }

        public void func_75249_e() {
            this.field_203127_a.func_203012_t(true);
            this.field_203129_c = false;
            this.field_203130_d = 0;
        }

        public void func_75251_c() {
            this.field_203127_a.func_203012_t(false);
        }

        public boolean func_75253_b() {
            return !this.field_203127_a.func_203018_dA().func_218137_a((IPosition)this.field_203127_a.func_213303_ch(), 7.0) && !this.field_203129_c && this.field_203130_d <= 600;
        }

        public void func_75246_d() {
            BlockPos blockpos = this.field_203127_a.func_203018_dA();
            boolean flag = blockpos.func_218137_a((IPosition)this.field_203127_a.func_213303_ch(), 16.0);
            if (flag) {
                ++this.field_203130_d;
            }
            if (this.field_203127_a.func_70661_as().func_75500_f()) {
                Vector3d vector3d = Vector3d.func_237492_c_((Vector3i)blockpos);
                Vector3d vector3d1 = RandomPositionGenerator.func_203155_a((CreatureEntity)this.field_203127_a, (int)16, (int)3, (Vector3d)vector3d, (double)0.3141592741012573);
                if (vector3d1 == null) {
                    vector3d1 = RandomPositionGenerator.func_75464_a((CreatureEntity)this.field_203127_a, (int)8, (int)7, (Vector3d)vector3d);
                }
                if (vector3d1 != null && !flag && !this.field_203127_a.field_70170_p.func_180495_p(new BlockPos(vector3d1)).func_203425_a(Blocks.field_150355_j)) {
                    vector3d1 = RandomPositionGenerator.func_75464_a((CreatureEntity)this.field_203127_a, (int)16, (int)5, (Vector3d)vector3d);
                }
                if (vector3d1 == null) {
                    this.field_203129_c = true;
                    return;
                }
                this.field_203127_a.func_70661_as().func_75492_a(vector3d1.field_72450_a, vector3d1.field_72448_b, vector3d1.field_72449_c, this.field_203128_b);
            }
        }
    }
}

