/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity;

import com.google.common.base.Objects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.BedBlock;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.HoneyBlock;
import net.minecraft.block.LadderBlock;
import net.minecraft.block.SoundType;
import net.minecraft.block.TrapDoorBlock;
import net.minecraft.command.arguments.EntityAnchorArgument;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.enchantment.FrostWalkerEnchantment;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityPredicate;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.Pose;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.AttributeModifierManager;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.attributes.GlobalEntityTypeAttributes;
import net.minecraft.entity.ai.attributes.ModifiableAttributeInstance;
import net.minecraft.entity.ai.brain.Brain;
import net.minecraft.entity.boss.WitherEntity;
import net.minecraft.entity.item.ExperienceOrbEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.passive.IFlyingAnimal;
import net.minecraft.entity.passive.PigEntity;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.FluidState;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.ElytraItem;
import net.minecraft.item.Food;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.UseAction;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameterSets;
import net.minecraft.loot.LootParameters;
import net.minecraft.loot.LootTable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.NBTDynamicOps;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.play.server.SAnimateHandPacket;
import net.minecraft.network.play.server.SCollectItemPacket;
import net.minecraft.network.play.server.SEntityEquipmentPacket;
import net.minecraft.network.play.server.SEntityStatusPacket;
import net.minecraft.network.play.server.SSpawnMobPacket;
import net.minecraft.particles.BlockParticleData;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ItemParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.EffectUtils;
import net.minecraft.potion.Effects;
import net.minecraft.potion.PotionUtils;
import net.minecraft.scoreboard.ScorePlayerTeam;
import net.minecraft.state.Property;
import net.minecraft.stats.Stats;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.CombatRules;
import net.minecraft.util.CombatTracker;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.EntityPredicates;
import net.minecraft.util.Hand;
import net.minecraft.util.HandSide;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.GameRules;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerChunkProvider;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.living.LivingEquipmentChangeEvent;
import net.minecraftforge.event.entity.living.LivingKnockBackEvent;
import net.minecraftforge.event.entity.living.PotionColorCalculationEvent;
import net.minecraftforge.event.entity.living.PotionEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.wrapper.EntityEquipmentInvWrapper;
import org.apache.logging.log4j.Logger;

public abstract class LivingEntity
extends Entity {
    private static final UUID field_110156_b = UUID.fromString("662A6B8D-DA3E-4C1C-8813-96EA6097278D");
    private static final UUID field_233625_c_ = UUID.fromString("87f46a96-686f-4796-b035-22e16ee9e038");
    private static final UUID SLOW_FALLING_ID = UUID.fromString("A5B6CF2A-2F7C-31EF-9022-7C3E7D5E6ABA");
    private static final AttributeModifier field_110157_c = new AttributeModifier(field_110156_b, "Sprinting speed boost", (double)0.3f, AttributeModifier.Operation.MULTIPLY_TOTAL);
    private static final AttributeModifier SLOW_FALLING = new AttributeModifier(SLOW_FALLING_ID, "Slow falling acceleration reduction", -0.07, AttributeModifier.Operation.ADDITION);
    protected static final DataParameter<Byte> field_184621_as = EntityDataManager.func_187226_a(LivingEntity.class, DataSerializers.field_187191_a);
    private static final DataParameter<Float> field_184632_c = EntityDataManager.func_187226_a(LivingEntity.class, DataSerializers.field_187193_c);
    private static final DataParameter<Integer> field_184633_f = EntityDataManager.func_187226_a(LivingEntity.class, DataSerializers.field_187192_b);
    private static final DataParameter<Boolean> field_184634_g = EntityDataManager.func_187226_a(LivingEntity.class, DataSerializers.field_187198_h);
    private static final DataParameter<Integer> field_184635_h = EntityDataManager.func_187226_a(LivingEntity.class, DataSerializers.field_187192_b);
    private static final DataParameter<Integer> field_226291_bp_ = EntityDataManager.func_187226_a(LivingEntity.class, DataSerializers.field_187192_b);
    private static final DataParameter<Optional<BlockPos>> field_213379_bs = EntityDataManager.func_187226_a(LivingEntity.class, DataSerializers.field_187201_k);
    protected static final EntitySize field_213377_as = EntitySize.func_220311_c((float)0.2f, (float)0.2f);
    private final AttributeModifierManager field_110155_d;
    private final CombatTracker field_94063_bt = new CombatTracker(this);
    private final Map<Effect, EffectInstance> field_70713_bf = Maps.newHashMap();
    private final NonNullList<ItemStack> field_184630_bs = NonNullList.func_191197_a((int)2, (Object)((Object)ItemStack.field_190927_a));
    private final NonNullList<ItemStack> field_184631_bt = NonNullList.func_191197_a((int)4, (Object)((Object)ItemStack.field_190927_a));
    public boolean field_82175_bq;
    public Hand field_184622_au;
    public int field_110158_av;
    public int field_70720_be;
    public int field_226290_au_;
    public int field_70737_aN;
    public int field_70738_aO;
    public float field_70739_aP;
    public int field_70725_aQ;
    public float field_70732_aI;
    public float field_70733_aJ;
    protected int field_184617_aD;
    public float field_184618_aE;
    public float field_70721_aZ;
    public float field_184619_aG;
    public final int field_70771_an = 20;
    public final float field_70769_ao;
    public final float field_70770_ap;
    public float field_70761_aq;
    public float field_70760_ar;
    public float field_70759_as;
    public float field_70758_at;
    public float field_70747_aH = 0.02f;
    @Nullable
    protected PlayerEntity field_70717_bb;
    protected int field_70718_bc;
    protected boolean field_70729_aU;
    protected int field_70708_bq;
    protected float field_70768_au;
    protected float field_110154_aX;
    protected float field_70764_aw;
    protected float field_70763_ax;
    protected float field_70741_aB;
    protected int field_70744_aE;
    protected float field_110153_bc;
    protected boolean field_70703_bu;
    public float field_70702_br;
    public float field_70701_bs;
    public float field_191988_bg;
    protected int field_70716_bi;
    protected double field_184623_bh;
    protected double field_184624_bi;
    protected double field_184625_bj;
    protected double field_184626_bk;
    protected double field_70709_bj;
    protected double field_208001_bq;
    protected int field_208002_br;
    private boolean field_70752_e = true;
    @Nullable
    private LivingEntity field_70755_b;
    private int field_70756_c;
    private LivingEntity field_110150_bn;
    private int field_142016_bo;
    private float field_70746_aG;
    private int field_70773_bE;
    private float field_110151_bq;
    protected ItemStack field_184627_bm = ItemStack.field_190927_a;
    protected int field_184628_bn;
    protected int field_184629_bo;
    private BlockPos field_184620_bC;
    private Optional<BlockPos> field_233624_bE_ = Optional.empty();
    private DamageSource field_189750_bF;
    private long field_189751_bG;
    protected int field_204807_bs;
    private float field_205017_bL;
    private float field_205018_bM;
    protected Brain<?> field_213378_br;
    private final LazyOptional<?>[] handlers = EntityEquipmentInvWrapper.create((LivingEntity)this);

    protected LivingEntity(EntityType<? extends LivingEntity> type, World worldIn) {
        super(type, worldIn);
        this.field_110155_d = new AttributeModifierManager(GlobalEntityTypeAttributes.func_233835_a_(type));
        this.func_70606_j(this.func_110138_aP());
        this.field_70156_m = true;
        this.field_70770_ap = (float)((Math.random() + 1.0) * (double)0.01f);
        this.func_226264_Z_();
        this.field_70769_ao = (float)Math.random() * 12398.0f;
        this.field_70759_as = this.field_70177_z = (float)(Math.random() * 6.2831854820251465);
        this.field_70138_W = 0.6f;
        NBTDynamicOps nbtdynamicops = NBTDynamicOps.field_210820_a;
        this.field_213378_br = this.func_213364_a(new Dynamic((DynamicOps)nbtdynamicops, nbtdynamicops.createMap((Map)ImmutableMap.of((Object)nbtdynamicops.createString("memories"), (Object)nbtdynamicops.emptyMap()))));
    }

    public Brain<?> func_213375_cj() {
        return this.field_213378_br;
    }

    protected Brain.BrainCodec<?> func_230289_cH_() {
        return Brain.func_233705_a_((Collection)ImmutableList.of(), (Collection)ImmutableList.of());
    }

    protected Brain<?> func_213364_a(Dynamic<?> dynamicIn) {
        return this.func_230289_cH_().func_233748_a_(dynamicIn);
    }

    @Override
    public void func_174812_G() {
        this.func_70097_a(DamageSource.field_76380_i, Float.MAX_VALUE);
    }

    public boolean func_213358_a(EntityType<?> typeIn) {
        return true;
    }

    @Override
    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(field_184621_as, (byte)0);
        this.field_70180_af.func_187214_a(field_184633_f, 0);
        this.field_70180_af.func_187214_a(field_184634_g, false);
        this.field_70180_af.func_187214_a(field_184635_h, 0);
        this.field_70180_af.func_187214_a(field_226291_bp_, 0);
        this.field_70180_af.func_187214_a(field_184632_c, Float.valueOf(1.0f));
        this.field_70180_af.func_187214_a(field_213379_bs, Optional.empty());
    }

    public static AttributeModifierMap.MutableAttribute func_233639_cI_() {
        return AttributeModifierMap.func_233803_a_().func_233814_a_(Attributes.field_233818_a_).func_233814_a_(Attributes.field_233820_c_).func_233814_a_(Attributes.field_233821_d_).func_233814_a_(Attributes.field_233826_i_).func_233814_a_(Attributes.field_233827_j_).func_233814_a_((Attribute)ForgeMod.SWIM_SPEED.get()).func_233814_a_((Attribute)ForgeMod.NAMETAG_DISTANCE.get()).func_233814_a_((Attribute)ForgeMod.ENTITY_GRAVITY.get());
    }

    @Override
    protected void func_184231_a(double y, boolean onGroundIn, BlockState state, BlockPos pos) {
        if (!this.func_70090_H()) {
            this.func_233567_aH_();
        }
        if (!this.field_70170_p.field_72995_K && onGroundIn && this.field_70143_R > 0.0f) {
            this.func_233641_cN_();
            this.func_233642_cO_();
        }
        if (!this.field_70170_p.field_72995_K && this.field_70143_R > 3.0f && onGroundIn) {
            double d0;
            int i;
            float f = MathHelper.func_76123_f((float)(this.field_70143_R - 3.0f));
            if (!state.isAir((IBlockReader)((Object)this.field_70170_p), pos) && !state.addLandingEffects((ServerWorld)this.field_70170_p, pos, state, this, i = (int)(150.0 * (d0 = Math.min((double)(0.2f + f / 15.0f), 2.5))))) {
                ((ServerWorld)this.field_70170_p).func_195598_a(new BlockParticleData(ParticleTypes.field_197611_d, state), this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), i, 0.0, 0.0, 0.0, 0.15f);
            }
        }
        super.func_184231_a(y, onGroundIn, state, pos);
    }

    public boolean func_70648_aU() {
        return this.func_70668_bt() == CreatureAttribute.field_223223_b_;
    }

    @OnlyIn(value=Dist.CLIENT)
    public float func_205015_b(float partialTicks) {
        return MathHelper.func_219799_g((float)partialTicks, (float)this.field_205018_bM, (float)this.field_205017_bL);
    }

    @Override
    public void func_70030_z() {
        boolean flag1;
        this.field_70732_aI = this.field_70733_aJ;
        if (this.field_70148_d) {
            this.func_213374_dv().ifPresent(this::func_213370_a);
        }
        if (this.func_230490_cK_()) {
            this.func_233640_cL_();
        }
        super.func_70030_z();
        this.field_70170_p.func_217381_Z().func_76320_a("livingEntityBaseTick");
        boolean flag = this instanceof PlayerEntity;
        if (this.func_70089_S()) {
            double d1;
            double d0;
            if (this.func_70094_T()) {
                this.func_70097_a(DamageSource.field_76368_d, 1.0f);
            } else if (flag && !this.field_70170_p.func_175723_af().func_177743_a(this.func_174813_aQ()) && (d0 = this.field_70170_p.func_175723_af().func_177745_a(this) + this.field_70170_p.func_175723_af().func_177742_m()) < 0.0 && (d1 = this.field_70170_p.func_175723_af().func_177727_n()) > 0.0) {
                this.func_70097_a(DamageSource.field_76368_d, Math.max(1, MathHelper.func_76128_c((double)(-d0 * d1))));
            }
        }
        if (this.func_230279_az_() || this.field_70170_p.field_72995_K) {
            this.func_70066_B();
        }
        boolean bl = flag1 = flag && ((PlayerEntity)this).field_71075_bZ.field_75102_a;
        if (this.func_70089_S()) {
            BlockPos blockpos;
            if (this.func_208600_a(FluidTags.field_206959_a) && !this.field_70170_p.func_180495_p(new BlockPos(this.func_226277_ct_(), this.func_226280_cw_(), this.func_226281_cx_())).func_203425_a(Blocks.field_203203_C)) {
                if (!(this.func_70648_aU() || EffectUtils.func_205133_c((LivingEntity)this) || flag1)) {
                    this.func_70050_g(this.func_70682_h(this.func_70086_ai()));
                    if (this.func_70086_ai() == -20) {
                        this.func_70050_g(0);
                        Vector3d vector3d = this.func_213322_ci();
                        for (int i = 0; i < 8; ++i) {
                            double d2 = this.field_70146_Z.nextDouble() - this.field_70146_Z.nextDouble();
                            double d3 = this.field_70146_Z.nextDouble() - this.field_70146_Z.nextDouble();
                            double d4 = this.field_70146_Z.nextDouble() - this.field_70146_Z.nextDouble();
                            this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197612_e, this.func_226277_ct_() + d2, this.func_226278_cu_() + d3, this.func_226281_cx_() + d4, vector3d.field_72450_a, vector3d.field_72448_b, vector3d.field_72449_c);
                        }
                        this.func_70097_a(DamageSource.field_76369_e, 2.0f);
                    }
                }
                if (!this.field_70170_p.field_72995_K && this.func_184218_aH() && this.func_184187_bx() != null && !this.func_184187_bx().canBeRiddenInWater(this)) {
                    this.func_184210_p();
                }
            } else if (this.func_70086_ai() < this.func_205010_bg()) {
                this.func_70050_g(this.func_207300_l(this.func_70086_ai()));
            }
            if (!this.field_70170_p.field_72995_K && !Objects.equal((Object)this.field_184620_bC, (Object)(blockpos = this.func_233580_cy_()))) {
                this.field_184620_bC = blockpos;
                this.func_184594_b(blockpos);
            }
        }
        if (this.func_70089_S() && this.func_203008_ap()) {
            this.func_70066_B();
        }
        if (this.field_70737_aN > 0) {
            --this.field_70737_aN;
        }
        if (this.field_70172_ad > 0 && !(this instanceof ServerPlayerEntity)) {
            --this.field_70172_ad;
        }
        if (this.func_233643_dh_()) {
            this.func_70609_aI();
        }
        if (this.field_70718_bc > 0) {
            --this.field_70718_bc;
        } else {
            this.field_70717_bb = null;
        }
        if (this.field_110150_bn != null && !this.field_110150_bn.func_70089_S()) {
            this.field_110150_bn = null;
        }
        if (this.field_70755_b != null) {
            if (!this.field_70755_b.func_70089_S()) {
                this.func_70604_c(null);
            } else if (this.field_70173_aa - this.field_70756_c > 100) {
                this.func_70604_c(null);
            }
        }
        this.func_70679_bo();
        this.field_70763_ax = this.field_70764_aw;
        this.field_70760_ar = this.field_70761_aq;
        this.field_70758_at = this.field_70759_as;
        this.field_70126_B = this.field_70177_z;
        this.field_70127_C = this.field_70125_A;
        this.field_70170_p.func_217381_Z().func_76319_b();
    }

    public boolean func_230490_cK_() {
        return this.field_70173_aa % 5 == 0 && this.func_213322_ci().field_72450_a != 0.0 && this.func_213322_ci().field_72449_c != 0.0 && !this.func_175149_v() && EnchantmentHelper.func_234846_j_(this) && this.func_230296_cM_();
    }

    protected void func_233640_cL_() {
        Vector3d vector3d = this.func_213322_ci();
        this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_239812_C_, this.func_226277_ct_() + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.func_213311_cf(), this.func_226278_cu_() + 0.1, this.func_226281_cx_() + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.func_213311_cf(), vector3d.field_72450_a * -0.2, 0.1, vector3d.field_72449_c * -0.2);
        float f = this.field_70146_Z.nextFloat() * 0.4f + this.field_70146_Z.nextFloat() > 0.9f ? 0.6f : 0.0f;
        this.func_184185_a(SoundEvents.field_232831_nS_, f, 0.6f + this.field_70146_Z.nextFloat() * 0.4f);
    }

    protected boolean func_230296_cM_() {
        return this.func_233568_aJ_().func_235714_a_(BlockTags.field_232876_aq_);
    }

    @Override
    protected float func_225515_ai_() {
        return this.func_230296_cM_() && EnchantmentHelper.func_185284_a(Enchantments.field_234847_l_, this) > 0 ? 1.0f : super.func_225515_ai_();
    }

    protected boolean func_230295_b_(BlockState p_230295_1_) {
        return !p_230295_1_.func_196958_f() || this.func_184613_cA();
    }

    protected void func_233641_cN_() {
        ModifiableAttributeInstance modifiableattributeinstance = this.func_110148_a(Attributes.field_233821_d_);
        if (modifiableattributeinstance != null && modifiableattributeinstance.func_111127_a(field_233625_c_) != null) {
            modifiableattributeinstance.func_188479_b(field_233625_c_);
        }
    }

    protected void func_233642_cO_() {
        int i;
        if (!this.func_233568_aJ_().func_196958_f() && (i = EnchantmentHelper.func_185284_a(Enchantments.field_234847_l_, this)) > 0 && this.func_230296_cM_()) {
            ModifiableAttributeInstance modifiableattributeinstance = this.func_110148_a(Attributes.field_233821_d_);
            if (modifiableattributeinstance == null) {
                return;
            }
            modifiableattributeinstance.func_233767_b_(new AttributeModifier(field_233625_c_, "Soul speed boost", (double)(0.03f * (1.0f + (float)i * 0.35f)), AttributeModifier.Operation.ADDITION));
            if (this.func_70681_au().nextFloat() < 0.04f) {
                ItemStack itemstack = this.func_184582_a(EquipmentSlotType.FEET);
                itemstack.func_222118_a(1, this, p_233654_0_ -> p_233654_0_.func_213361_c(EquipmentSlotType.FEET));
            }
        }
    }

    protected void func_184594_b(BlockPos pos) {
        int i = EnchantmentHelper.func_185284_a(Enchantments.field_185301_j, this);
        if (i > 0) {
            FrostWalkerEnchantment.func_185266_a(this, this.field_70170_p, pos, i);
        }
        if (this.func_230295_b_(this.func_233568_aJ_())) {
            this.func_233641_cN_();
        }
        this.func_233642_cO_();
    }

    public boolean func_70631_g_() {
        return false;
    }

    public float func_213355_cm() {
        return this.func_70631_g_() ? 0.5f : 1.0f;
    }

    protected boolean func_241208_cS_() {
        return true;
    }

    @Override
    public boolean func_205710_ba() {
        return false;
    }

    protected void func_70609_aI() {
        ++this.field_70725_aQ;
        if (this.field_70725_aQ == 20) {
            this.remove(this instanceof ServerPlayerEntity);
            for (int i = 0; i < 20; ++i) {
                double d0 = this.field_70146_Z.nextGaussian() * 0.02;
                double d1 = this.field_70146_Z.nextGaussian() * 0.02;
                double d2 = this.field_70146_Z.nextGaussian() * 0.02;
                this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197598_I, this.func_226282_d_(1.0), this.func_226279_cv_(), this.func_226287_g_(1.0), d0, d1, d2);
            }
        }
    }

    protected boolean func_146066_aG() {
        return !this.func_70631_g_();
    }

    protected boolean func_230282_cS_() {
        return !this.func_70631_g_();
    }

    protected int func_70682_h(int air) {
        int i = EnchantmentHelper.func_185292_c(this);
        return i > 0 && this.field_70146_Z.nextInt(i + 1) > 0 ? air : air - 1;
    }

    protected int func_207300_l(int currentAir) {
        return Math.min(currentAir + 4, this.func_205010_bg());
    }

    protected int func_70693_a(PlayerEntity player) {
        return 0;
    }

    protected boolean func_70684_aJ() {
        return false;
    }

    public Random func_70681_au() {
        return this.field_70146_Z;
    }

    @Nullable
    public LivingEntity func_70643_av() {
        return this.field_70755_b;
    }

    public int func_142015_aE() {
        return this.field_70756_c;
    }

    public void func_230246_e_(@Nullable PlayerEntity p_230246_1_) {
        this.field_70717_bb = p_230246_1_;
        this.field_70718_bc = this.field_70173_aa;
    }

    public void func_70604_c(@Nullable LivingEntity livingBase) {
        this.field_70755_b = livingBase;
        this.field_70756_c = this.field_70173_aa;
    }

    @Nullable
    public LivingEntity func_110144_aD() {
        return this.field_110150_bn;
    }

    public int func_142013_aG() {
        return this.field_142016_bo;
    }

    public void func_130011_c(Entity entityIn) {
        this.field_110150_bn = entityIn instanceof LivingEntity ? (LivingEntity)entityIn : null;
        this.field_142016_bo = this.field_70173_aa;
    }

    public int func_70654_ax() {
        return this.field_70708_bq;
    }

    public void func_213332_m(int idleTimeIn) {
        this.field_70708_bq = idleTimeIn;
    }

    protected void func_184606_a_(ItemStack stack) {
        if (!stack.func_190926_b()) {
            SoundEvent soundevent = SoundEvents.field_187719_p;
            Item item = stack.func_77973_b();
            if (item instanceof ArmorItem) {
                soundevent = ((ArmorItem)item).func_200880_d().func_200899_b();
            } else if (item == Items.field_185160_cR) {
                soundevent = SoundEvents.field_191258_p;
            }
            this.func_184185_a(soundevent, 1.0f, 1.0f);
        }
    }

    @Override
    public void func_213281_b(CompoundNBT compound) {
        compound.func_74776_a("Health", this.func_110143_aJ());
        compound.func_74777_a("HurtTime", (short)this.field_70737_aN);
        compound.func_74768_a("HurtByTimestamp", this.field_70756_c);
        compound.func_74777_a("DeathTime", (short)this.field_70725_aQ);
        compound.func_74776_a("AbsorptionAmount", this.func_110139_bj());
        compound.func_218657_a("Attributes", (INBT)this.func_233645_dx_().func_233794_c_());
        if (!this.field_70713_bf.isEmpty()) {
            ListNBT listnbt = new ListNBT();
            for (EffectInstance effectinstance : this.field_70713_bf.values()) {
                listnbt.add((Object)effectinstance.func_82719_a(new CompoundNBT()));
            }
            compound.func_218657_a("ActiveEffects", (INBT)listnbt);
        }
        compound.func_74757_a("FallFlying", this.func_184613_cA());
        this.func_213374_dv().ifPresent(p_213338_1_ -> {
            compound.func_74768_a("SleepingX", p_213338_1_.func_177958_n());
            compound.func_74768_a("SleepingY", p_213338_1_.func_177956_o());
            compound.func_74768_a("SleepingZ", p_213338_1_.func_177952_p());
        });
        DataResult dataresult = this.field_213378_br.func_233702_a_((DynamicOps)NBTDynamicOps.field_210820_a);
        dataresult.resultOrPartial(arg_0 -> ((Logger)field_184243_a).error(arg_0)).ifPresent(p_233636_1_ -> compound.func_218657_a("Brain", (INBT)p_233636_1_));
    }

    @Override
    public void func_70037_a(CompoundNBT compound) {
        this.func_110149_m(compound.func_74760_g("AbsorptionAmount"));
        if (compound.func_150297_b("Attributes", 9) && this.field_70170_p != null && !this.field_70170_p.field_72995_K) {
            this.func_233645_dx_().func_233788_a_(compound.func_150295_c("Attributes", 10));
        }
        if (compound.func_150297_b("ActiveEffects", 9)) {
            ListNBT listnbt = compound.func_150295_c("ActiveEffects", 10);
            for (int i = 0; i < listnbt.size(); ++i) {
                CompoundNBT compoundnbt = listnbt.func_150305_b(i);
                EffectInstance effectinstance = EffectInstance.func_82722_b(compoundnbt);
                if (effectinstance == null) continue;
                this.field_70713_bf.put(effectinstance.func_188419_a(), effectinstance);
            }
        }
        if (compound.func_150297_b("Health", 99)) {
            this.func_70606_j(compound.func_74760_g("Health"));
        }
        this.field_70737_aN = compound.func_74765_d("HurtTime");
        this.field_70725_aQ = compound.func_74765_d("DeathTime");
        this.field_70756_c = compound.func_74762_e("HurtByTimestamp");
        if (compound.func_150297_b("Team", 8)) {
            boolean flag;
            String s = compound.func_74779_i("Team");
            ScorePlayerTeam scoreplayerteam = this.field_70170_p.func_96441_U().func_96508_e(s);
            boolean bl = flag = scoreplayerteam != null && this.field_70170_p.func_96441_U().func_197901_a(this.func_189512_bd(), scoreplayerteam);
            if (!flag) {
                field_184243_a.warn("Unable to add mob to team \"{}\" (that team probably doesn't exist)", (Object)s);
            }
        }
        if (compound.func_74767_n("FallFlying")) {
            this.func_70052_a(7, true);
        }
        if (compound.func_150297_b("SleepingX", 99) && compound.func_150297_b("SleepingY", 99) && compound.func_150297_b("SleepingZ", 99)) {
            BlockPos blockpos = new BlockPos(compound.func_74762_e("SleepingX"), compound.func_74762_e("SleepingY"), compound.func_74762_e("SleepingZ"));
            this.func_213369_d(blockpos);
            this.field_70180_af.func_187227_b(field_213330_X, Pose.SLEEPING);
            if (!this.field_70148_d) {
                this.func_213370_a(blockpos);
            }
        }
        if (compound.func_150297_b("Brain", 10)) {
            this.field_213378_br = this.func_213364_a(new Dynamic((DynamicOps)NBTDynamicOps.field_210820_a, (Object)compound.func_74781_a("Brain")));
        }
    }

    protected void func_70679_bo() {
        Iterator<Effect> iterator = this.field_70713_bf.keySet().iterator();
        try {
            while (iterator.hasNext()) {
                Effect effect = iterator.next();
                EffectInstance effectinstance = this.field_70713_bf.get((Object)effect);
                if (!effectinstance.func_76455_a(this, () -> this.func_70695_b(effectinstance, true))) {
                    if (this.field_70170_p.field_72995_K || MinecraftForge.EVENT_BUS.post((Event)new PotionEvent.PotionExpiryEvent(this, effectinstance))) continue;
                    iterator.remove();
                    this.func_70688_c(effectinstance);
                    continue;
                }
                if (effectinstance.func_76459_b() % 600 != 0) continue;
                this.func_70695_b(effectinstance, false);
            }
        }
        catch (ConcurrentModificationException effect) {
            // empty catch block
        }
        if (this.field_70752_e) {
            if (!this.field_70170_p.field_72995_K) {
                this.func_175135_B();
            }
            this.field_70752_e = false;
        }
        int i = this.field_70180_af.func_187225_a(field_184633_f);
        boolean flag1 = this.field_70180_af.func_187225_a(field_184634_g);
        if (i > 0) {
            boolean flag = this.func_82150_aj() ? this.field_70146_Z.nextInt(15) == 0 : this.field_70146_Z.nextBoolean();
            if (flag1) {
                flag &= this.field_70146_Z.nextInt(5) == 0;
            }
            if (flag && i > 0) {
                double d0 = (double)(i >> 16 & 0xFF) / 255.0;
                double d1 = (double)(i >> 8 & 0xFF) / 255.0;
                double d2 = (double)(i >> 0 & 0xFF) / 255.0;
                this.field_70170_p.func_195594_a((IParticleData)(flag1 ? ParticleTypes.field_197608_a : ParticleTypes.field_197625_r), this.func_226282_d_(0.5), this.func_226279_cv_(), this.func_226287_g_(0.5), d0, d1, d2);
            }
        }
    }

    protected void func_175135_B() {
        if (this.field_70713_bf.isEmpty()) {
            this.func_175133_bi();
            this.func_82142_c(false);
        } else {
            Collection<EffectInstance> collection = this.field_70713_bf.values();
            PotionColorCalculationEvent event = new PotionColorCalculationEvent(this, PotionUtils.func_185181_a(collection), LivingEntity.func_184593_a(collection), collection);
            MinecraftForge.EVENT_BUS.post((Event)event);
            this.field_70180_af.func_187227_b(field_184634_g, event.areParticlesHidden());
            this.field_70180_af.func_187227_b(field_184633_f, event.getColor());
            this.func_82142_c(this.func_70644_a(Effects.field_76441_p));
        }
    }

    public double func_213340_A(@Nullable Entity lookingEntity) {
        double d0 = 1.0;
        if (this.func_226273_bm_()) {
            d0 *= 0.8;
        }
        if (this.func_82150_aj()) {
            float f = this.func_213343_cS();
            if (f < 0.1f) {
                f = 0.1f;
            }
            d0 *= 0.7 * (double)f;
        }
        if (lookingEntity != null) {
            ItemStack itemstack = this.func_184582_a(EquipmentSlotType.HEAD);
            Item item = itemstack.func_77973_b();
            EntityType<?> entitytype = lookingEntity.func_200600_R();
            if (entitytype == EntityType.field_200741_ag && item == Items.field_196182_dv || entitytype == EntityType.field_200725_aD && item == Items.field_196186_dz || entitytype == EntityType.field_200797_k && item == Items.field_196185_dy) {
                d0 *= 0.5;
            }
        }
        return d0;
    }

    public boolean func_213336_c(LivingEntity target) {
        return true;
    }

    public boolean func_213344_a(LivingEntity livingentityIn, EntityPredicate predicateIn) {
        return predicateIn.func_221015_a(this, livingentityIn);
    }

    public static boolean func_184593_a(Collection<EffectInstance> potionEffects) {
        for (EffectInstance effectinstance : potionEffects) {
            if (effectinstance.func_82720_e()) continue;
            return false;
        }
        return true;
    }

    protected void func_175133_bi() {
        this.field_70180_af.func_187227_b(field_184634_g, false);
        this.field_70180_af.func_187227_b(field_184633_f, 0);
    }

    public boolean func_195061_cb() {
        if (this.field_70170_p.field_72995_K) {
            return false;
        }
        Iterator<EffectInstance> iterator = this.field_70713_bf.values().iterator();
        boolean flag = false;
        while (iterator.hasNext()) {
            EffectInstance effect = iterator.next();
            if (!MinecraftForge.EVENT_BUS.post((Event)new PotionEvent.PotionRemoveEvent(this, effect))) {
                this.func_70688_c(effect);
                iterator.remove();
            }
            flag = true;
        }
        return flag;
    }

    public Collection<EffectInstance> func_70651_bq() {
        return this.field_70713_bf.values();
    }

    public Map<Effect, EffectInstance> func_193076_bZ() {
        return this.field_70713_bf;
    }

    public boolean func_70644_a(Effect potionIn) {
        return this.field_70713_bf.containsKey((Object)potionIn);
    }

    @Nullable
    public EffectInstance func_70660_b(Effect potionIn) {
        return this.field_70713_bf.get((Object)potionIn);
    }

    public boolean func_195064_c(EffectInstance effectInstanceIn) {
        if (!this.func_70687_e(effectInstanceIn)) {
            return false;
        }
        EffectInstance effectinstance = this.field_70713_bf.get((Object)effectInstanceIn.func_188419_a());
        MinecraftForge.EVENT_BUS.post((Event)new PotionEvent.PotionAddedEvent(this, effectinstance, effectInstanceIn));
        if (effectinstance == null) {
            this.field_70713_bf.put(effectInstanceIn.func_188419_a(), effectInstanceIn);
            this.func_70670_a(effectInstanceIn);
            return true;
        }
        if (effectinstance.func_199308_a(effectInstanceIn)) {
            this.func_70695_b(effectinstance, true);
            return true;
        }
        return false;
    }

    public boolean func_70687_e(EffectInstance potioneffectIn) {
        Effect effect;
        PotionEvent.PotionApplicableEvent event = new PotionEvent.PotionApplicableEvent(this, potioneffectIn);
        MinecraftForge.EVENT_BUS.post((Event)event);
        if (event.getResult() != Event.Result.DEFAULT) {
            return event.getResult() == Event.Result.ALLOW;
        }
        return this.func_70668_bt() != CreatureAttribute.field_223223_b_ || (effect = potioneffectIn.func_188419_a()) != Effects.field_76428_l && effect != Effects.field_76436_u;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_233646_e_(EffectInstance p_233646_1_) {
        if (this.func_70687_e(p_233646_1_)) {
            EffectInstance effectinstance = this.field_70713_bf.put(p_233646_1_.func_188419_a(), p_233646_1_);
            if (effectinstance == null) {
                this.func_70670_a(p_233646_1_);
            } else {
                this.func_70695_b(p_233646_1_, true);
            }
        }
    }

    public boolean func_70662_br() {
        return this.func_70668_bt() == CreatureAttribute.field_223223_b_;
    }

    @Nullable
    public EffectInstance func_184596_c(@Nullable Effect potioneffectin) {
        return this.field_70713_bf.remove((Object)potioneffectin);
    }

    public boolean func_195063_d(Effect effectIn) {
        if (MinecraftForge.EVENT_BUS.post((Event)new PotionEvent.PotionRemoveEvent(this, effectIn))) {
            return false;
        }
        EffectInstance effectinstance = this.func_184596_c(effectIn);
        if (effectinstance != null) {
            this.func_70688_c(effectinstance);
            return true;
        }
        return false;
    }

    protected void func_70670_a(EffectInstance id) {
        this.field_70752_e = true;
        if (!this.field_70170_p.field_72995_K) {
            id.func_188419_a().func_111185_a(this, this.func_233645_dx_(), id.func_76458_c());
        }
    }

    protected void func_70695_b(EffectInstance id, boolean reapply) {
        this.field_70752_e = true;
        if (reapply && !this.field_70170_p.field_72995_K) {
            Effect effect = id.func_188419_a();
            effect.func_111187_a(this, this.func_233645_dx_(), id.func_76458_c());
            effect.func_111185_a(this, this.func_233645_dx_(), id.func_76458_c());
        }
    }

    protected void func_70688_c(EffectInstance effect) {
        this.field_70752_e = true;
        if (!this.field_70170_p.field_72995_K) {
            effect.func_188419_a().func_111187_a(this, this.func_233645_dx_(), effect.func_76458_c());
        }
    }

    public void func_70691_i(float healAmount) {
        if ((healAmount = ForgeEventFactory.onLivingHeal((LivingEntity)this, (float)healAmount)) <= 0.0f) {
            return;
        }
        float f = this.func_110143_aJ();
        if (f > 0.0f) {
            this.func_70606_j(f + healAmount);
        }
    }

    public float func_110143_aJ() {
        return this.field_70180_af.func_187225_a(field_184632_c).floatValue();
    }

    public void func_70606_j(float health) {
        this.field_70180_af.func_187227_b(field_184632_c, Float.valueOf(MathHelper.func_76131_a((float)health, (float)0.0f, (float)this.func_110138_aP())));
    }

    public boolean func_233643_dh_() {
        return this.func_110143_aJ() <= 0.0f;
    }

    @Override
    public boolean func_70097_a(DamageSource source, float amount) {
        boolean flag2;
        if (!ForgeHooks.onLivingAttack((LivingEntity)this, (DamageSource)source, (float)amount)) {
            return false;
        }
        if (this.func_180431_b(source)) {
            return false;
        }
        if (this.field_70170_p.field_72995_K) {
            return false;
        }
        if (this.func_233643_dh_()) {
            return false;
        }
        if (source.func_76347_k() && this.func_70644_a(Effects.field_76426_n)) {
            return false;
        }
        if (this.func_70608_bn() && !this.field_70170_p.field_72995_K) {
            this.func_213366_dy();
        }
        this.field_70708_bq = 0;
        float f = amount;
        if (!(source != DamageSource.field_82728_o && source != DamageSource.field_82729_p || this.func_184582_a(EquipmentSlotType.HEAD).func_190926_b())) {
            this.func_184582_a(EquipmentSlotType.HEAD).func_222118_a((int)(amount * 4.0f + this.field_70146_Z.nextFloat() * amount * 2.0f), this, p_233653_0_ -> p_233653_0_.func_213361_c(EquipmentSlotType.HEAD));
            amount *= 0.75f;
        }
        boolean flag = false;
        float f1 = 0.0f;
        if (amount > 0.0f && this.func_184583_d(source)) {
            Entity entity;
            this.func_184590_k(amount);
            f1 = amount;
            amount = 0.0f;
            if (!source.func_76352_a() && (entity = source.func_76364_f()) instanceof LivingEntity) {
                this.func_190629_c((LivingEntity)entity);
            }
            flag = true;
        }
        this.field_70721_aZ = 1.5f;
        boolean flag1 = true;
        if ((float)this.field_70172_ad > 10.0f) {
            if (amount <= this.field_110153_bc) {
                return false;
            }
            this.func_70665_d(source, amount - this.field_110153_bc);
            this.field_110153_bc = amount;
            flag1 = false;
        } else {
            this.field_110153_bc = amount;
            this.field_70172_ad = 20;
            this.func_70665_d(source, amount);
            this.field_70737_aN = this.field_70738_aO = 10;
        }
        this.field_70739_aP = 0.0f;
        Entity entity1 = source.func_76346_g();
        if (entity1 != null) {
            TameableEntity wolfentity;
            if (entity1 instanceof LivingEntity) {
                this.func_70604_c((LivingEntity)entity1);
            }
            if (entity1 instanceof PlayerEntity) {
                this.field_70718_bc = 100;
                this.field_70717_bb = (PlayerEntity)entity1;
            } else if (entity1 instanceof TameableEntity && (wolfentity = (TameableEntity)entity1).func_70909_n()) {
                this.field_70718_bc = 100;
                LivingEntity livingentity = wolfentity.func_70902_q();
                this.field_70717_bb = livingentity != null && livingentity.func_200600_R() == EntityType.field_200729_aH ? (PlayerEntity)livingentity : null;
            }
        }
        if (flag1) {
            if (flag) {
                this.field_70170_p.func_72960_a(this, (byte)29);
            } else if (source instanceof EntityDamageSource && ((EntityDamageSource)source).func_180139_w()) {
                this.field_70170_p.func_72960_a(this, (byte)33);
            } else {
                int b0 = source == DamageSource.field_76369_e ? 36 : (source.func_76347_k() ? 37 : (source == DamageSource.field_220302_v ? 44 : 2));
                this.field_70170_p.func_72960_a(this, (byte)b0);
            }
            if (source != DamageSource.field_76369_e && (!flag || amount > 0.0f)) {
                this.func_70018_K();
            }
            if (entity1 != null) {
                double d1 = entity1.func_226277_ct_() - this.func_226277_ct_();
                double d0 = entity1.func_226281_cx_() - this.func_226281_cx_();
                while (d1 * d1 + d0 * d0 < 1.0E-4) {
                    d1 = (Math.random() - Math.random()) * 0.01;
                    d0 = (Math.random() - Math.random()) * 0.01;
                }
                this.field_70739_aP = (float)(MathHelper.func_181159_b((double)d0, (double)d1) * 57.2957763671875 - (double)this.field_70177_z);
                this.func_233627_a_(0.4f, d1, d0);
            } else {
                this.field_70739_aP = (int)(Math.random() * 2.0) * 180;
            }
        }
        if (this.func_233643_dh_()) {
            if (!this.func_190628_d(source)) {
                SoundEvent soundevent = this.func_184615_bR();
                if (flag1 && soundevent != null) {
                    this.func_184185_a(soundevent, this.func_70599_aP(), this.func_70647_i());
                }
                this.func_70645_a(source);
            }
        } else if (flag1) {
            this.func_184581_c(source);
        }
        boolean bl = flag2 = !flag || amount > 0.0f;
        if (flag2) {
            this.field_189750_bF = source;
            this.field_189751_bG = this.field_70170_p.func_82737_E();
        }
        if (this instanceof ServerPlayerEntity) {
            CriteriaTriggers.field_192128_h.func_192200_a((ServerPlayerEntity)this, source, f, amount, flag);
            if (f1 > 0.0f && f1 < 3.4028235E37f) {
                ((ServerPlayerEntity)this).func_195067_a(Stats.field_212737_I, Math.round(f1 * 10.0f));
            }
        }
        if (entity1 instanceof ServerPlayerEntity) {
            CriteriaTriggers.field_192127_g.func_192220_a((ServerPlayerEntity)entity1, (Entity)this, source, f, amount, flag);
        }
        return flag2;
    }

    protected void func_190629_c(LivingEntity entityIn) {
        entityIn.func_213371_e(this);
    }

    protected void func_213371_e(LivingEntity entityIn) {
        entityIn.func_233627_a_(0.5f, entityIn.func_226277_ct_() - this.func_226277_ct_(), entityIn.func_226281_cx_() - this.func_226281_cx_());
    }

    private boolean func_190628_d(DamageSource damageSourceIn) {
        if (damageSourceIn.func_76357_e()) {
            return false;
        }
        ItemStack itemstack = null;
        for (Hand hand : Hand.values()) {
            ItemStack itemstack1 = this.func_184586_b(hand);
            if (itemstack1.func_77973_b() != Items.field_190929_cY) continue;
            itemstack = itemstack1.func_77946_l();
            itemstack1.func_190918_g(1);
            break;
        }
        if (itemstack != null) {
            if (this instanceof ServerPlayerEntity) {
                ServerPlayerEntity serverplayerentity = (ServerPlayerEntity)this;
                serverplayerentity.func_71029_a(Stats.field_75929_E.func_199076_b(Items.field_190929_cY));
                CriteriaTriggers.field_193130_A.func_193187_a(serverplayerentity, itemstack);
            }
            this.func_70606_j(1.0f);
            this.func_195061_cb();
            this.func_195064_c(new EffectInstance(Effects.field_76428_l, 900, 1));
            this.func_195064_c(new EffectInstance(Effects.field_76444_x, 100, 1));
            this.field_70170_p.func_72960_a(this, (byte)35);
        }
        return itemstack != null;
    }

    @Nullable
    public DamageSource func_189748_bU() {
        if (this.field_70170_p.func_82737_E() - this.field_189751_bG > 40L) {
            this.field_189750_bF = null;
        }
        return this.field_189750_bF;
    }

    protected void func_184581_c(DamageSource source) {
        SoundEvent soundevent = this.func_184601_bQ(source);
        if (soundevent != null) {
            this.func_184185_a(soundevent, this.func_70599_aP(), this.func_70647_i());
        }
    }

    private boolean func_184583_d(DamageSource damageSourceIn) {
        Vector3d vector3d2;
        AbstractArrowEntity abstractarrowentity;
        Entity entity = damageSourceIn.func_76364_f();
        boolean flag = false;
        if (entity instanceof AbstractArrowEntity && (abstractarrowentity = (AbstractArrowEntity)((Object)entity)).func_213874_s() > 0) {
            flag = true;
        }
        if (!damageSourceIn.func_76363_c() && this.func_184585_cz() && !flag && (vector3d2 = damageSourceIn.func_188404_v()) != null) {
            Vector3d vector3d = this.func_70676_i(1.0f);
            Vector3d vector3d1 = vector3d2.func_72444_a(this.func_213303_ch()).func_72432_b();
            vector3d1 = new Vector3d(vector3d1.field_72450_a, 0.0, vector3d1.field_72449_c);
            if (vector3d1.func_72430_b(vector3d) < 0.0) {
                return true;
            }
        }
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    private void func_70669_a(ItemStack stack) {
        if (!stack.func_190926_b()) {
            if (!this.func_174814_R()) {
                this.field_70170_p.func_184134_a(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), SoundEvents.field_187635_cQ, this.func_184176_by(), 0.8f, 0.8f + this.field_70170_p.field_73012_v.nextFloat() * 0.4f, false);
            }
            this.func_195062_a(stack, 5);
        }
    }

    public void func_70645_a(DamageSource cause) {
        if (ForgeHooks.onLivingDeath((LivingEntity)this, (DamageSource)cause)) {
            return;
        }
        if (!this.field_70128_L && !this.field_70729_aU) {
            Entity entity = cause.func_76346_g();
            LivingEntity livingentity = this.func_94060_bK();
            if (this.field_70744_aE >= 0 && livingentity != null) {
                livingentity.func_191956_a(this, this.field_70744_aE, cause);
            }
            if (entity != null) {
                entity.func_70074_a(this);
            }
            if (this.func_70608_bn()) {
                this.func_213366_dy();
            }
            this.field_70729_aU = true;
            this.func_110142_aN().func_94549_h();
            if (!this.field_70170_p.field_72995_K) {
                this.func_213345_d(cause);
                this.func_226298_f_(livingentity);
            }
            this.field_70170_p.func_72960_a(this, (byte)3);
            this.func_213301_b(Pose.DYING);
        }
    }

    protected void func_226298_f_(@Nullable LivingEntity p_226298_1_) {
        if (!this.field_70170_p.field_72995_K) {
            boolean flag = false;
            if (p_226298_1_ instanceof WitherEntity) {
                if (ForgeEventFactory.getMobGriefingEvent((World)this.field_70170_p, (Entity)this)) {
                    BlockPos blockpos = this.func_233580_cy_();
                    BlockState blockstate = Blocks.field_222388_bz.func_176223_P();
                    if (this.field_70170_p.func_175623_d(blockpos) && blockstate.func_196955_c((IWorldReader)((Object)this.field_70170_p), blockpos)) {
                        this.field_70170_p.func_180501_a(blockpos, blockstate, 3);
                        flag = true;
                    }
                }
                if (!flag) {
                    ItemEntity itementity = new ItemEntity(this.field_70170_p, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), new ItemStack(Items.field_221690_bg));
                    this.field_70170_p.func_217376_c(itementity);
                }
            }
        }
    }

    protected void func_213345_d(DamageSource damageSourceIn) {
        boolean flag;
        Entity entity = damageSourceIn.func_76346_g();
        int i = ForgeHooks.getLootingLevel((Entity)this, (Entity)entity, (DamageSource)damageSourceIn);
        this.captureDrops(new ArrayList<ItemEntity>());
        boolean bl = flag = this.field_70718_bc > 0;
        if (this.func_230282_cS_() && this.field_70170_p.func_82736_K().func_223586_b(GameRules.field_223602_e)) {
            this.func_213354_a(damageSourceIn, flag);
            this.func_213333_a(damageSourceIn, i, flag);
        }
        this.func_213337_cE();
        this.func_226294_cV_();
        Collection<ItemEntity> drops = this.captureDrops(null);
        if (!ForgeHooks.onLivingDrops((LivingEntity)this, (DamageSource)damageSourceIn, drops, (int)i, (this.field_70718_bc > 0 ? 1 : 0) != 0)) {
            drops.forEach(e -> this.field_70170_p.func_217376_c((Entity)((Object)e)));
        }
    }

    protected void func_213337_cE() {
    }

    protected void func_226294_cV_() {
        if (!this.field_70170_p.field_72995_K && (this.func_70684_aJ() || this.field_70718_bc > 0 && this.func_146066_aG() && this.field_70170_p.func_82736_K().func_223586_b(GameRules.field_223602_e))) {
            int j;
            int i = this.func_70693_a(this.field_70717_bb);
            for (i = ForgeEventFactory.getExperienceDrop((LivingEntity)this, (PlayerEntity)this.field_70717_bb, (int)i); i > 0; i -= j) {
                j = ExperienceOrbEntity.func_70527_a(i);
                this.field_70170_p.func_217376_c(new ExperienceOrbEntity(this.field_70170_p, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), j));
            }
        }
    }

    protected void func_213333_a(DamageSource source, int looting, boolean recentlyHitIn) {
    }

    public ResourceLocation func_213346_cF() {
        return this.func_200600_R().func_220348_g();
    }

    protected void func_213354_a(DamageSource damageSourceIn, boolean p_213354_2_) {
        ResourceLocation resourcelocation = this.func_213346_cF();
        LootTable loottable = this.field_70170_p.func_73046_m().func_200249_aQ().func_186521_a(resourcelocation);
        LootContext.Builder lootcontext$builder = this.func_213363_a(p_213354_2_, damageSourceIn);
        LootContext ctx = lootcontext$builder.func_216022_a(LootParameterSets.field_216263_d);
        loottable.func_216113_a(ctx).forEach(this::func_199701_a_);
    }

    protected LootContext.Builder func_213363_a(boolean p_213363_1_, DamageSource damageSourceIn) {
        LootContext.Builder lootcontext$builder = new LootContext.Builder((ServerWorld)this.field_70170_p).func_216023_a(this.field_70146_Z).func_216015_a(LootParameters.field_216281_a, this).func_216015_a(LootParameters.field_216286_f, this.func_233580_cy_()).func_216015_a(LootParameters.field_216283_c, damageSourceIn).func_216021_b(LootParameters.field_216284_d, damageSourceIn.func_76346_g()).func_216021_b(LootParameters.field_216285_e, damageSourceIn.func_76364_f());
        if (p_213363_1_ && this.field_70717_bb != null) {
            lootcontext$builder = lootcontext$builder.func_216015_a(LootParameters.field_216282_b, this.field_70717_bb).func_186469_a(this.field_70717_bb.func_184817_da());
        }
        return lootcontext$builder;
    }

    public void func_233627_a_(float p_233627_1_, double p_233627_2_, double p_233627_4_) {
        LivingKnockBackEvent event = ForgeHooks.onLivingKnockBack((LivingEntity)this, null, (float)p_233627_1_, (double)p_233627_2_, (double)p_233627_4_);
        if (event.isCanceled()) {
            return;
        }
        p_233627_1_ = event.getStrength();
        p_233627_2_ = event.getRatioX();
        p_233627_4_ = event.getRatioZ();
        if (!((p_233627_1_ = (float)((double)p_233627_1_ * (1.0 - this.func_233637_b_(Attributes.field_233820_c_)))) <= 0.0f)) {
            this.field_70160_al = true;
            Vector3d vector3d = this.func_213322_ci();
            Vector3d vector3d1 = new Vector3d(p_233627_2_, 0.0, p_233627_4_).func_72432_b().func_186678_a(p_233627_1_);
            this.func_213293_j(vector3d.field_72450_a / 2.0 - vector3d1.field_72450_a, this.field_70122_E ? Math.min(0.4, vector3d.field_72448_b / 2.0 + (double)p_233627_1_) : vector3d.field_72448_b, vector3d.field_72449_c / 2.0 - vector3d1.field_72449_c);
        }
    }

    @Nullable
    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundEvents.field_187543_bD;
    }

    @Nullable
    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187661_by;
    }

    protected SoundEvent func_184588_d(int heightIn) {
        return heightIn > 4 ? SoundEvents.field_187655_bw : SoundEvents.field_187545_bE;
    }

    protected SoundEvent func_213351_c(ItemStack stack) {
        return stack.func_226629_F_();
    }

    public SoundEvent func_213353_d(ItemStack itemStackIn) {
        return itemStackIn.func_226630_G_();
    }

    @Override
    public void func_230245_c_(boolean p_230245_1_) {
        super.func_230245_c_(p_230245_1_);
        if (p_230245_1_) {
            this.field_233624_bE_ = Optional.empty();
        }
    }

    public Optional<BlockPos> func_233644_dn_() {
        return this.field_233624_bE_;
    }

    public boolean func_70617_f_() {
        if (this.func_175149_v()) {
            return false;
        }
        BlockPos blockpos = this.func_233580_cy_();
        BlockState blockstate = this.func_213339_cH();
        return ForgeHooks.isLivingOnLadder((BlockState)blockstate, (World)this.field_70170_p, (BlockPos)blockpos, (LivingEntity)this);
    }

    public BlockState func_213339_cH() {
        return this.field_70170_p.func_180495_p(this.func_233580_cy_());
    }

    private boolean func_184604_a(BlockPos pos, BlockState state) {
        BlockState blockstate;
        return (Boolean)state.func_177229_b((Property)TrapDoorBlock.field_176283_b) != false && (blockstate = this.field_70170_p.func_180495_p(pos.func_177977_b())).func_203425_a(Blocks.field_150468_ap) && blockstate.func_177229_b((Property)LadderBlock.field_176382_a) == state.func_177229_b((Property)TrapDoorBlock.field_185512_D);
    }

    @Override
    public boolean func_70089_S() {
        return !this.field_70128_L && this.func_110143_aJ() > 0.0f;
    }

    @Override
    public boolean func_225503_b_(float distance, float damageMultiplier) {
        float[] ret = ForgeHooks.onLivingFall((LivingEntity)this, (float)distance, (float)damageMultiplier);
        if (ret == null) {
            return false;
        }
        distance = ret[0];
        damageMultiplier = ret[1];
        boolean flag = super.func_225503_b_(distance, damageMultiplier);
        int i = this.func_225508_e_(distance, damageMultiplier);
        if (i > 0) {
            this.func_184185_a(this.func_184588_d(i), 1.0f, 1.0f);
            this.func_226295_cZ_();
            this.func_70097_a(DamageSource.field_76379_h, i);
            return true;
        }
        return flag;
    }

    protected int func_225508_e_(float p_225508_1_, float p_225508_2_) {
        EffectInstance effectinstance = this.func_70660_b(Effects.field_76430_j);
        float f = effectinstance == null ? 0.0f : (float)(effectinstance.func_76458_c() + 1);
        return MathHelper.func_76123_f((float)((p_225508_1_ - 3.0f - f) * p_225508_2_));
    }

    protected void func_226295_cZ_() {
        int k;
        int j;
        int i;
        BlockPos pos;
        BlockState blockstate;
        if (!this.func_174814_R() && !(blockstate = this.field_70170_p.func_180495_p(pos = new BlockPos(i = MathHelper.func_76128_c((double)this.func_226277_ct_()), j = MathHelper.func_76128_c((double)(this.func_226278_cu_() - (double)0.2f)), k = MathHelper.func_76128_c((double)this.func_226281_cx_())))).isAir((IBlockReader)((Object)this.field_70170_p), pos)) {
            SoundType soundtype = blockstate.getSoundType((IWorldReader)((Object)this.field_70170_p), pos, this);
            this.func_184185_a(soundtype.func_185842_g(), soundtype.func_185843_a() * 0.5f, soundtype.func_185847_b() * 0.75f);
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void func_70057_ab() {
        this.field_70737_aN = this.field_70738_aO = 10;
        this.field_70739_aP = 0.0f;
    }

    public int func_70658_aO() {
        return MathHelper.func_76128_c((double)this.func_233637_b_(Attributes.field_233826_i_));
    }

    protected void func_230294_b_(DamageSource p_230294_1_, float p_230294_2_) {
    }

    protected void func_184590_k(float damage) {
    }

    protected float func_70655_b(DamageSource source, float damage) {
        if (!source.func_76363_c()) {
            this.func_230294_b_(source, damage);
            damage = CombatRules.func_189427_a((float)damage, (float)this.func_70658_aO(), (float)((float)this.func_233637_b_(Attributes.field_233827_j_)));
        }
        return damage;
    }

    protected float func_70672_c(DamageSource source, float damage) {
        int i;
        int j;
        float f;
        float f1;
        float f2;
        if (source.func_151517_h()) {
            return damage;
        }
        if (this.func_70644_a(Effects.field_76429_m) && source != DamageSource.field_76380_i && (f2 = (f1 = damage) - (damage = Math.max((f = damage * (float)(j = 25 - (i = (this.func_70660_b(Effects.field_76429_m).func_76458_c() + 1) * 5))) / 25.0f, 0.0f))) > 0.0f && f2 < 3.4028235E37f) {
            if (this instanceof ServerPlayerEntity) {
                ((ServerPlayerEntity)this).func_195067_a(Stats.field_212739_K, Math.round(f2 * 10.0f));
            } else if (source.func_76346_g() instanceof ServerPlayerEntity) {
                ((ServerPlayerEntity)source.func_76346_g()).func_195067_a(Stats.field_212736_G, Math.round(f2 * 10.0f));
            }
        }
        if (damage <= 0.0f) {
            return 0.0f;
        }
        int k = EnchantmentHelper.func_77508_a(this.func_184193_aE(), source);
        if (k > 0) {
            damage = CombatRules.func_188401_b((float)damage, (float)k);
        }
        return damage;
    }

    protected void func_70665_d(DamageSource damageSrc, float damageAmount) {
        if (!this.func_180431_b(damageSrc)) {
            if ((damageAmount = ForgeHooks.onLivingHurt((LivingEntity)this, (DamageSource)damageSrc, (float)damageAmount)) <= 0.0f) {
                return;
            }
            damageAmount = this.func_70655_b(damageSrc, damageAmount);
            damageAmount = this.func_70672_c(damageSrc, damageAmount);
            float f2 = Math.max(damageAmount - this.func_110139_bj(), 0.0f);
            this.func_110149_m(this.func_110139_bj() - (damageAmount - f2));
            float f = damageAmount - f2;
            if (f > 0.0f && f < 3.4028235E37f && damageSrc.func_76346_g() instanceof ServerPlayerEntity) {
                ((ServerPlayerEntity)damageSrc.func_76346_g()).func_195067_a(Stats.field_212735_F, Math.round(f * 10.0f));
            }
            if ((f2 = ForgeHooks.onLivingDamage((LivingEntity)this, (DamageSource)damageSrc, (float)f2)) != 0.0f) {
                float f1 = this.func_110143_aJ();
                this.func_110142_aN().func_94547_a(damageSrc, f1, f2);
                this.func_70606_j(f1 - f2);
                this.func_110149_m(this.func_110139_bj() - f2);
            }
        }
    }

    public CombatTracker func_110142_aN() {
        return this.field_94063_bt;
    }

    @Nullable
    public LivingEntity func_94060_bK() {
        if (this.field_94063_bt.func_94550_c() != null) {
            return this.field_94063_bt.func_94550_c();
        }
        if (this.field_70717_bb != null) {
            return this.field_70717_bb;
        }
        return this.field_70755_b != null ? this.field_70755_b : null;
    }

    public final float func_110138_aP() {
        return (float)this.func_233637_b_(Attributes.field_233818_a_);
    }

    public final int func_85035_bI() {
        return this.field_70180_af.func_187225_a(field_184635_h);
    }

    public final void func_85034_r(int count) {
        this.field_70180_af.func_187227_b(field_184635_h, count);
    }

    public final int func_226297_df_() {
        return this.field_70180_af.func_187225_a(field_226291_bp_);
    }

    public final void func_226300_q_(int p_226300_1_) {
        this.field_70180_af.func_187227_b(field_226291_bp_, p_226300_1_);
    }

    private int func_82166_i() {
        if (EffectUtils.func_205135_a((LivingEntity)this)) {
            return 6 - (1 + EffectUtils.func_205134_b((LivingEntity)this));
        }
        return this.func_70644_a(Effects.field_76419_f) ? 6 + (1 + this.func_70660_b(Effects.field_76419_f).func_76458_c()) * 2 : 6;
    }

    public void func_184609_a(Hand hand) {
        this.func_226292_a_(hand, false);
    }

    public void func_226292_a_(Hand handIn, boolean p_226292_2_) {
        ItemStack stack = this.func_184586_b(handIn);
        if (!stack.func_190926_b() && stack.onEntitySwing(this)) {
            return;
        }
        if (!this.field_82175_bq || this.field_110158_av >= this.func_82166_i() / 2 || this.field_110158_av < 0) {
            this.field_110158_av = -1;
            this.field_82175_bq = true;
            this.field_184622_au = handIn;
            if (this.field_70170_p instanceof ServerWorld) {
                SAnimateHandPacket sanimatehandpacket = new SAnimateHandPacket((Entity)this, handIn == Hand.MAIN_HAND ? 0 : 3);
                ServerChunkProvider serverchunkprovider = ((ServerWorld)this.field_70170_p).func_72863_F();
                if (p_226292_2_) {
                    serverchunkprovider.func_217216_a((Entity)this, (IPacket)sanimatehandpacket);
                } else {
                    serverchunkprovider.func_217218_b((Entity)this, (IPacket)sanimatehandpacket);
                }
            }
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void func_70103_a(byte id) {
        switch (id) {
            case 2: 
            case 33: 
            case 36: 
            case 37: 
            case 44: {
                DamageSource damagesource;
                SoundEvent soundevent1;
                boolean flag1 = id == 33;
                boolean flag2 = id == 36;
                boolean flag3 = id == 37;
                boolean flag = id == 44;
                this.field_70721_aZ = 1.5f;
                this.field_70172_ad = 20;
                this.field_70737_aN = this.field_70738_aO = 10;
                this.field_70739_aP = 0.0f;
                if (flag1) {
                    this.func_184185_a(SoundEvents.field_187903_gc, this.func_70599_aP(), (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f);
                }
                if ((soundevent1 = this.func_184601_bQ(damagesource = flag3 ? DamageSource.field_76370_b : (flag2 ? DamageSource.field_76369_e : (flag ? DamageSource.field_220302_v : DamageSource.field_76377_j)))) != null) {
                    this.func_184185_a(soundevent1, this.func_70599_aP(), (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f);
                }
                this.func_70097_a(DamageSource.field_76377_j, 0.0f);
                break;
            }
            case 3: {
                SoundEvent soundevent = this.func_184615_bR();
                if (soundevent != null) {
                    this.func_184185_a(soundevent, this.func_70599_aP(), (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f);
                }
                if (this instanceof PlayerEntity) break;
                this.func_70606_j(0.0f);
                this.func_70645_a(DamageSource.field_76377_j);
                break;
            }
            default: {
                super.func_70103_a(id);
                break;
            }
            case 29: {
                this.func_184185_a(SoundEvents.field_187767_eL, 1.0f, 0.8f + this.field_70170_p.field_73012_v.nextFloat() * 0.4f);
                break;
            }
            case 30: {
                this.func_184185_a(SoundEvents.field_187769_eM, 0.8f, 0.8f + this.field_70170_p.field_73012_v.nextFloat() * 0.4f);
                break;
            }
            case 46: {
                int i = 128;
                for (int j = 0; j < 128; ++j) {
                    double d0 = (double)j / 127.0;
                    float f = (this.field_70146_Z.nextFloat() - 0.5f) * 0.2f;
                    float f1 = (this.field_70146_Z.nextFloat() - 0.5f) * 0.2f;
                    float f2 = (this.field_70146_Z.nextFloat() - 0.5f) * 0.2f;
                    double d1 = MathHelper.func_219803_d((double)d0, (double)this.field_70169_q, (double)this.func_226277_ct_()) + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.func_213311_cf() * 2.0;
                    double d2 = MathHelper.func_219803_d((double)d0, (double)this.field_70167_r, (double)this.func_226278_cu_()) + this.field_70146_Z.nextDouble() * (double)this.func_213302_cg();
                    double d3 = MathHelper.func_219803_d((double)d0, (double)this.field_70166_s, (double)this.func_226281_cx_()) + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.func_213311_cf() * 2.0;
                    this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197599_J, d1, d2, d3, f, f1, f2);
                }
                break;
            }
            case 47: {
                this.func_70669_a(this.func_184582_a(EquipmentSlotType.MAINHAND));
                break;
            }
            case 48: {
                this.func_70669_a(this.func_184582_a(EquipmentSlotType.OFFHAND));
                break;
            }
            case 49: {
                this.func_70669_a(this.func_184582_a(EquipmentSlotType.HEAD));
                break;
            }
            case 50: {
                this.func_70669_a(this.func_184582_a(EquipmentSlotType.CHEST));
                break;
            }
            case 51: {
                this.func_70669_a(this.func_184582_a(EquipmentSlotType.LEGS));
                break;
            }
            case 52: {
                this.func_70669_a(this.func_184582_a(EquipmentSlotType.FEET));
                break;
            }
            case 54: {
                HoneyBlock.func_226936_b_((Entity)this);
                break;
            }
            case 55: {
                this.func_241352_p_();
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void func_241352_p_() {
        ItemStack itemstack = this.func_184582_a(EquipmentSlotType.OFFHAND);
        this.func_184201_a(EquipmentSlotType.OFFHAND, this.func_184582_a(EquipmentSlotType.MAINHAND));
        this.func_184201_a(EquipmentSlotType.MAINHAND, itemstack);
    }

    @Override
    protected void func_70076_C() {
        this.func_70097_a(DamageSource.field_76380_i, 4.0f);
    }

    protected void func_82168_bl() {
        int i = this.func_82166_i();
        if (this.field_82175_bq) {
            ++this.field_110158_av;
            if (this.field_110158_av >= i) {
                this.field_110158_av = 0;
                this.field_82175_bq = false;
            }
        } else {
            this.field_110158_av = 0;
        }
        this.field_70733_aJ = (float)this.field_110158_av / (float)i;
    }

    @Nullable
    public ModifiableAttributeInstance func_110148_a(Attribute attribute) {
        return this.func_233645_dx_().func_233779_a_(attribute);
    }

    public double func_233637_b_(Attribute p_233637_1_) {
        return this.func_233645_dx_().func_233795_c_(p_233637_1_);
    }

    public double func_233638_c_(Attribute p_233638_1_) {
        return this.func_233645_dx_().func_233797_d_(p_233638_1_);
    }

    public AttributeModifierManager func_233645_dx_() {
        return this.field_110155_d;
    }

    public CreatureAttribute func_70668_bt() {
        return CreatureAttribute.field_223222_a_;
    }

    public ItemStack func_184614_ca() {
        return this.func_184582_a(EquipmentSlotType.MAINHAND);
    }

    public ItemStack func_184592_cb() {
        return this.func_184582_a(EquipmentSlotType.OFFHAND);
    }

    public boolean func_233631_a_(Item p_233631_1_) {
        return this.func_233634_a_(p_233632_1_ -> p_233632_1_ == p_233631_1_);
    }

    public boolean func_233634_a_(Predicate<Item> p_233634_1_) {
        return p_233634_1_.test(this.func_184614_ca().func_77973_b()) || p_233634_1_.test(this.func_184592_cb().func_77973_b());
    }

    public ItemStack func_184586_b(Hand hand) {
        if (hand == Hand.MAIN_HAND) {
            return this.func_184582_a(EquipmentSlotType.MAINHAND);
        }
        if (hand == Hand.OFF_HAND) {
            return this.func_184582_a(EquipmentSlotType.OFFHAND);
        }
        throw new IllegalArgumentException("Invalid hand " + hand);
    }

    public void func_184611_a(Hand hand, ItemStack stack) {
        if (hand == Hand.MAIN_HAND) {
            this.func_184201_a(EquipmentSlotType.MAINHAND, stack);
        } else {
            if (hand != Hand.OFF_HAND) {
                throw new IllegalArgumentException("Invalid hand " + hand);
            }
            this.func_184201_a(EquipmentSlotType.OFFHAND, stack);
        }
    }

    public boolean func_190630_a(EquipmentSlotType slotIn) {
        return !this.func_184582_a(slotIn).func_190926_b();
    }

    @Override
    public abstract Iterable<ItemStack> func_184193_aE();

    public abstract ItemStack func_184582_a(EquipmentSlotType var1);

    @Override
    public abstract void func_184201_a(EquipmentSlotType var1, ItemStack var2);

    public float func_213343_cS() {
        Iterable<ItemStack> iterable = this.func_184193_aE();
        int i = 0;
        int j = 0;
        for (ItemStack itemstack : iterable) {
            if (!itemstack.func_190926_b()) {
                ++j;
            }
            ++i;
        }
        return i > 0 ? (float)j / (float)i : 0.0f;
    }

    @Override
    public void func_70031_b(boolean sprinting) {
        super.func_70031_b(sprinting);
        ModifiableAttributeInstance modifiableattributeinstance = this.func_110148_a(Attributes.field_233821_d_);
        if (modifiableattributeinstance.func_111127_a(field_110156_b) != null) {
            modifiableattributeinstance.func_111124_b(field_110157_c);
        }
        if (sprinting) {
            modifiableattributeinstance.func_233767_b_(field_110157_c);
        }
    }

    protected float func_70599_aP() {
        return 1.0f;
    }

    protected float func_70647_i() {
        return this.func_70631_g_() ? (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.5f : (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f;
    }

    protected boolean func_70610_aX() {
        return this.func_233643_dh_();
    }

    @Override
    public void func_70108_f(Entity entityIn) {
        if (!this.func_70608_bn()) {
            super.func_70108_f(entityIn);
        }
    }

    private void func_233628_a_(Entity p_233628_1_) {
        Vector3d vector3d = !p_233628_1_.field_70128_L && !this.field_70170_p.func_180495_p(p_233628_1_.func_233580_cy_()).func_177230_c().func_203417_a(BlockTags.field_226154_ad_) ? p_233628_1_.func_230268_c_(this) : new Vector3d(p_233628_1_.func_226277_ct_(), p_233628_1_.func_226278_cu_() + (double)p_233628_1_.func_213302_cg(), p_233628_1_.func_226281_cx_());
        this.func_70634_a(vector3d.field_72450_a, vector3d.field_72448_b, vector3d.field_72449_c);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean func_94059_bO() {
        return this.func_174833_aM();
    }

    protected float func_175134_bD() {
        return 0.42f * this.func_226269_ah_();
    }

    protected void func_70664_aZ() {
        float f = this.func_175134_bD();
        if (this.func_70644_a(Effects.field_76430_j)) {
            f += 0.1f * (float)(this.func_70660_b(Effects.field_76430_j).func_76458_c() + 1);
        }
        Vector3d vector3d = this.func_213322_ci();
        this.func_213293_j(vector3d.field_72450_a, f, vector3d.field_72449_c);
        if (this.func_70051_ag()) {
            float f1 = this.field_70177_z * ((float)Math.PI / 180);
            this.func_213317_d(this.func_213322_ci().func_72441_c(-MathHelper.func_76126_a((float)f1) * 0.2f, 0.0, MathHelper.func_76134_b((float)f1) * 0.2f));
        }
        this.field_70160_al = true;
        ForgeHooks.onLivingJump((LivingEntity)this);
    }

    @OnlyIn(value=Dist.CLIENT)
    protected void func_203010_cG() {
        this.func_213317_d(this.func_213322_ci().func_72441_c(0.0, (double)-0.04f * this.func_110148_a((Attribute)ForgeMod.SWIM_SPEED.get()).func_111126_e(), 0.0));
    }

    protected void func_180466_bG(ITag<Fluid> fluidTag) {
        this.func_213317_d(this.func_213322_ci().func_72441_c(0.0, (double)0.04f * this.func_110148_a((Attribute)ForgeMod.SWIM_SPEED.get()).func_111126_e(), 0.0));
    }

    protected float func_189749_co() {
        return 0.8f;
    }

    public boolean func_230285_a_(Fluid p_230285_1_) {
        return false;
    }

    public void func_213352_e(Vector3d p_213352_1_) {
        if (this.func_70613_aW() || this.func_184186_bw()) {
            boolean flag;
            double d0 = 0.08;
            ModifiableAttributeInstance gravity = this.func_110148_a((Attribute)ForgeMod.ENTITY_GRAVITY.get());
            boolean bl = flag = this.func_213322_ci().field_72448_b <= 0.0;
            if (flag && this.func_70644_a(Effects.field_204839_B)) {
                if (!gravity.func_180374_a(SLOW_FALLING)) {
                    gravity.func_233767_b_(SLOW_FALLING);
                }
                this.field_70143_R = 0.0f;
            } else if (gravity.func_180374_a(SLOW_FALLING)) {
                gravity.func_111124_b(SLOW_FALLING);
            }
            d0 = gravity.func_111126_e();
            FluidState fluidstate = this.field_70170_p.func_204610_c(this.func_233580_cy_());
            if (this.func_70090_H() && this.func_241208_cS_() && !this.func_230285_a_(fluidstate.func_206886_c())) {
                double d8 = this.func_226278_cu_();
                float f5 = this.func_70051_ag() ? 0.9f : this.func_189749_co();
                float f6 = 0.02f;
                float f7 = EnchantmentHelper.func_185294_d(this);
                if (f7 > 3.0f) {
                    f7 = 3.0f;
                }
                if (!this.field_70122_E) {
                    f7 *= 0.5f;
                }
                if (f7 > 0.0f) {
                    f5 += (0.54600006f - f5) * f7 / 3.0f;
                    f6 += (this.func_70689_ay() - f6) * f7 / 3.0f;
                }
                if (this.func_70644_a(Effects.field_206827_D)) {
                    f5 = 0.96f;
                }
                this.func_213309_a(f6 *= (float)this.func_110148_a((Attribute)ForgeMod.SWIM_SPEED.get()).func_111126_e(), p_213352_1_);
                this.func_213315_a(MoverType.SELF, this.func_213322_ci());
                Vector3d vector3d6 = this.func_213322_ci();
                if (this.field_70123_F && this.func_70617_f_()) {
                    vector3d6 = new Vector3d(vector3d6.field_72450_a, 0.2, vector3d6.field_72449_c);
                }
                this.func_213317_d(vector3d6.func_216372_d(f5, 0.8f, f5));
                Vector3d vector3d2 = this.func_233626_a_(d0, flag, this.func_213322_ci());
                this.func_213317_d(vector3d2);
                if (this.field_70123_F && this.func_70038_c(vector3d2.field_72450_a, vector3d2.field_72448_b + (double)0.6f - this.func_226278_cu_() + d8, vector3d2.field_72449_c)) {
                    this.func_213293_j(vector3d2.field_72450_a, 0.3f, vector3d2.field_72449_c);
                }
            } else if (this.func_180799_ab() && this.func_241208_cS_() && !this.func_230285_a_(fluidstate.func_206886_c())) {
                double d7 = this.func_226278_cu_();
                this.func_213309_a(0.02f, p_213352_1_);
                this.func_213315_a(MoverType.SELF, this.func_213322_ci());
                if (this.func_233571_b_(FluidTags.field_206960_b) <= this.func_233579_cu_()) {
                    this.func_213317_d(this.func_213322_ci().func_216372_d(0.5, 0.8f, 0.5));
                    Vector3d vector3d3 = this.func_233626_a_(d0, flag, this.func_213322_ci());
                    this.func_213317_d(vector3d3);
                } else {
                    this.func_213317_d(this.func_213322_ci().func_186678_a(0.5));
                }
                if (!this.func_189652_ae()) {
                    this.func_213317_d(this.func_213322_ci().func_72441_c(0.0, -d0 / 4.0, 0.0));
                }
                Vector3d vector3d4 = this.func_213322_ci();
                if (this.field_70123_F && this.func_70038_c(vector3d4.field_72450_a, vector3d4.field_72448_b + (double)0.6f - this.func_226278_cu_() + d7, vector3d4.field_72449_c)) {
                    this.func_213293_j(vector3d4.field_72450_a, 0.3f, vector3d4.field_72449_c);
                }
            } else if (this.func_184613_cA()) {
                double d10;
                double d6;
                float f2;
                Vector3d vector3d = this.func_213322_ci();
                if (vector3d.field_72448_b > -0.5) {
                    this.field_70143_R = 1.0f;
                }
                Vector3d vector3d1 = this.func_70040_Z();
                float f = this.field_70125_A * ((float)Math.PI / 180);
                double d1 = Math.sqrt(vector3d1.field_72450_a * vector3d1.field_72450_a + vector3d1.field_72449_c * vector3d1.field_72449_c);
                double d3 = Math.sqrt(LivingEntity.func_213296_b(vector3d));
                double d4 = vector3d1.func_72433_c();
                float f1 = MathHelper.func_76134_b((float)f);
                f1 = (float)((double)f1 * (double)f1 * Math.min(1.0, d4 / 0.4));
                vector3d = this.func_213322_ci().func_72441_c(0.0, d0 * (-1.0 + (double)f1 * 0.75), 0.0);
                if (vector3d.field_72448_b < 0.0 && d1 > 0.0) {
                    double d5 = vector3d.field_72448_b * -0.1 * (double)f1;
                    vector3d = vector3d.func_72441_c(vector3d1.field_72450_a * d5 / d1, d5, vector3d1.field_72449_c * d5 / d1);
                }
                if (f < 0.0f && d1 > 0.0) {
                    double d9 = d3 * (double)(-MathHelper.func_76126_a((float)f)) * 0.04;
                    vector3d = vector3d.func_72441_c(-vector3d1.field_72450_a * d9 / d1, d9 * 3.2, -vector3d1.field_72449_c * d9 / d1);
                }
                if (d1 > 0.0) {
                    vector3d = vector3d.func_72441_c((vector3d1.field_72450_a / d1 * d3 - vector3d.field_72450_a) * 0.1, 0.0, (vector3d1.field_72449_c / d1 * d3 - vector3d.field_72449_c) * 0.1);
                }
                this.func_213317_d(vector3d.func_216372_d(0.99f, 0.98f, 0.99f));
                this.func_213315_a(MoverType.SELF, this.func_213322_ci());
                if (this.field_70123_F && !this.field_70170_p.field_72995_K && (f2 = (float)((d6 = d3 - (d10 = Math.sqrt(LivingEntity.func_213296_b(this.func_213322_ci())))) * 10.0 - 3.0)) > 0.0f) {
                    this.func_184185_a(this.func_184588_d((int)f2), 1.0f, 1.0f);
                    this.func_70097_a(DamageSource.field_188406_j, f2);
                }
                if (this.field_70122_E && !this.field_70170_p.field_72995_K) {
                    this.func_70052_a(7, false);
                }
            } else {
                BlockPos blockpos = this.func_226270_aj_();
                float f3 = this.field_70170_p.func_180495_p(this.func_226270_aj_()).getSlipperiness((IWorldReader)((Object)this.field_70170_p), this.func_226270_aj_(), this);
                float f4 = this.field_70122_E ? f3 * 0.91f : 0.91f;
                Vector3d vector3d5 = this.func_233633_a_(p_213352_1_, f3);
                double d2 = vector3d5.field_72448_b;
                if (this.func_70644_a(Effects.field_188424_y)) {
                    d2 += (0.05 * (double)(this.func_70660_b(Effects.field_188424_y).func_76458_c() + 1) - vector3d5.field_72448_b) * 0.2;
                    this.field_70143_R = 0.0f;
                } else if (this.field_70170_p.field_72995_K && !this.field_70170_p.func_175667_e(blockpos)) {
                    d2 = this.func_226278_cu_() > 0.0 ? -0.1 : 0.0;
                } else if (!this.func_189652_ae()) {
                    d2 -= d0;
                }
                this.func_213293_j(vector3d5.field_72450_a * (double)f4, d2 * (double)0.98f, vector3d5.field_72449_c * (double)f4);
            }
        }
        this.func_233629_a_(this, this instanceof IFlyingAnimal);
    }

    public void func_233629_a_(LivingEntity p_233629_1_, boolean p_233629_2_) {
        double d2;
        double d1;
        p_233629_1_.field_184618_aE = p_233629_1_.field_70721_aZ;
        double d0 = p_233629_1_.func_226277_ct_() - p_233629_1_.field_70169_q;
        float f = MathHelper.func_76133_a((double)(d0 * d0 + (d1 = p_233629_2_ ? p_233629_1_.func_226278_cu_() - p_233629_1_.field_70167_r : 0.0) * d1 + (d2 = p_233629_1_.func_226281_cx_() - p_233629_1_.field_70166_s) * d2)) * 4.0f;
        if (f > 1.0f) {
            f = 1.0f;
        }
        p_233629_1_.field_70721_aZ += (f - p_233629_1_.field_70721_aZ) * 0.4f;
        p_233629_1_.field_184619_aG += p_233629_1_.field_70721_aZ;
    }

    public Vector3d func_233633_a_(Vector3d p_233633_1_, float p_233633_2_) {
        this.func_213309_a(this.func_213335_r(p_233633_2_), p_233633_1_);
        this.func_213317_d(this.func_213362_f(this.func_213322_ci()));
        this.func_213315_a(MoverType.SELF, this.func_213322_ci());
        Vector3d vector3d = this.func_213322_ci();
        if ((this.field_70123_F || this.field_70703_bu) && this.func_70617_f_()) {
            vector3d = new Vector3d(vector3d.field_72450_a, 0.2, vector3d.field_72449_c);
        }
        return vector3d;
    }

    public Vector3d func_233626_a_(double p_233626_1_, boolean p_233626_3_, Vector3d p_233626_4_) {
        if (!this.func_189652_ae() && !this.func_70051_ag()) {
            double d0 = p_233626_3_ && Math.abs(p_233626_4_.field_72448_b - 0.005) >= 0.003 && Math.abs(p_233626_4_.field_72448_b - p_233626_1_ / 16.0) < 0.003 ? -0.003 : p_233626_4_.field_72448_b - p_233626_1_ / 16.0;
            return new Vector3d(p_233626_4_.field_72450_a, d0, p_233626_4_.field_72449_c);
        }
        return p_233626_4_;
    }

    private Vector3d func_213362_f(Vector3d p_213362_1_) {
        if (this.func_70617_f_()) {
            this.field_70143_R = 0.0f;
            float f = 0.15f;
            double d0 = MathHelper.func_151237_a((double)p_213362_1_.field_72450_a, (double)-0.15f, (double)0.15f);
            double d1 = MathHelper.func_151237_a((double)p_213362_1_.field_72449_c, (double)-0.15f, (double)0.15f);
            double d2 = Math.max(p_213362_1_.field_72448_b, (double)-0.15f);
            if (d2 < 0.0 && !this.func_213339_cH().func_203425_a(Blocks.field_222420_lI) && this.func_230491_ea_() && this instanceof PlayerEntity) {
                d2 = 0.0;
            }
            p_213362_1_ = new Vector3d(d0, d2, d1);
        }
        return p_213362_1_;
    }

    private float func_213335_r(float p_213335_1_) {
        return this.field_70122_E ? this.func_70689_ay() * (0.21600002f / (p_213335_1_ * p_213335_1_ * p_213335_1_)) : this.field_70747_aH;
    }

    public float func_70689_ay() {
        return this.field_70746_aG;
    }

    public void func_70659_e(float speedIn) {
        this.field_70746_aG = speedIn;
    }

    public boolean func_70652_k(Entity entityIn) {
        this.func_130011_c(entityIn);
        return false;
    }

    @Override
    public void func_70071_h_() {
        if (ForgeHooks.onLivingUpdate((LivingEntity)this)) {
            return;
        }
        super.func_70071_h_();
        this.func_184608_ct();
        this.func_205014_p();
        if (!this.field_70170_p.field_72995_K) {
            int j;
            int i = this.func_85035_bI();
            if (i > 0) {
                if (this.field_70720_be <= 0) {
                    this.field_70720_be = 20 * (30 - i);
                }
                --this.field_70720_be;
                if (this.field_70720_be <= 0) {
                    this.func_85034_r(i - 1);
                }
            }
            if ((j = this.func_226297_df_()) > 0) {
                if (this.field_226290_au_ <= 0) {
                    this.field_226290_au_ = 20 * (30 - j);
                }
                --this.field_226290_au_;
                if (this.field_226290_au_ <= 0) {
                    this.func_226300_q_(j - 1);
                }
            }
            this.func_241353_q_();
            if (this.field_70173_aa % 20 == 0) {
                this.func_110142_aN().func_94549_h();
            }
            if (!this.field_184238_ar) {
                boolean flag = this.func_70644_a(Effects.field_188423_x);
                if (this.func_70083_f(6) != flag) {
                    this.func_70052_a(6, flag);
                }
            }
            if (this.func_70608_bn() && !this.func_213359_p()) {
                this.func_213366_dy();
            }
        }
        this.func_70636_d();
        double d0 = this.func_226277_ct_() - this.field_70169_q;
        double d1 = this.func_226281_cx_() - this.field_70166_s;
        float f = (float)(d0 * d0 + d1 * d1);
        float f1 = this.field_70761_aq;
        float f2 = 0.0f;
        this.field_70768_au = this.field_110154_aX;
        float f3 = 0.0f;
        if (f > 0.0025000002f) {
            f3 = 1.0f;
            f2 = (float)Math.sqrt(f) * 3.0f;
            float f4 = (float)MathHelper.func_181159_b((double)d1, (double)d0) * 57.295776f - 90.0f;
            float f5 = MathHelper.func_76135_e((float)(MathHelper.func_76142_g((float)this.field_70177_z) - f4));
            f1 = 95.0f < f5 && f5 < 265.0f ? f4 - 180.0f : f4;
        }
        if (this.field_70733_aJ > 0.0f) {
            f1 = this.field_70177_z;
        }
        if (!this.field_70122_E) {
            f3 = 0.0f;
        }
        this.field_110154_aX += (f3 - this.field_110154_aX) * 0.3f;
        this.field_70170_p.func_217381_Z().func_76320_a("headTurn");
        f2 = this.func_110146_f(f1, f2);
        this.field_70170_p.func_217381_Z().func_76319_b();
        this.field_70170_p.func_217381_Z().func_76320_a("rangeChecks");
        while (this.field_70177_z - this.field_70126_B < -180.0f) {
            this.field_70126_B -= 360.0f;
        }
        while (this.field_70177_z - this.field_70126_B >= 180.0f) {
            this.field_70126_B += 360.0f;
        }
        while (this.field_70761_aq - this.field_70760_ar < -180.0f) {
            this.field_70760_ar -= 360.0f;
        }
        while (this.field_70761_aq - this.field_70760_ar >= 180.0f) {
            this.field_70760_ar += 360.0f;
        }
        while (this.field_70125_A - this.field_70127_C < -180.0f) {
            this.field_70127_C -= 360.0f;
        }
        while (this.field_70125_A - this.field_70127_C >= 180.0f) {
            this.field_70127_C += 360.0f;
        }
        while (this.field_70759_as - this.field_70758_at < -180.0f) {
            this.field_70758_at -= 360.0f;
        }
        while (this.field_70759_as - this.field_70758_at >= 180.0f) {
            this.field_70758_at += 360.0f;
        }
        this.field_70170_p.func_217381_Z().func_76319_b();
        this.field_70764_aw += f2;
        this.field_184629_bo = this.func_184613_cA() ? ++this.field_184629_bo : 0;
        if (this.func_70608_bn()) {
            this.field_70125_A = 0.0f;
        }
    }

    private void func_241353_q_() {
        Map<EquipmentSlotType, ItemStack> map = this.func_241354_r_();
        if (map != null) {
            this.func_241342_a_(map);
            if (!map.isEmpty()) {
                this.func_241344_b_(map);
            }
        }
    }

    @Nullable
    private Map<EquipmentSlotType, ItemStack> func_241354_r_() {
        EnumMap map = null;
        block4: for (EquipmentSlotType equipmentslottype : EquipmentSlotType.values()) {
            ItemStack itemstack;
            switch (equipmentslottype.func_188453_a()) {
                case HAND: {
                    itemstack = this.func_241347_e_(equipmentslottype);
                    break;
                }
                case ARMOR: {
                    itemstack = this.func_241346_d_(equipmentslottype);
                    break;
                }
                default: {
                    continue block4;
                }
            }
            ItemStack itemstack1 = this.func_184582_a(equipmentslottype);
            if (ItemStack.func_77989_b(itemstack1, itemstack)) continue;
            if (!itemstack1.equals(itemstack1, true)) {
                MinecraftForge.EVENT_BUS.post((Event)new LivingEquipmentChangeEvent(this, equipmentslottype, itemstack, itemstack1));
            }
            if (map == null) {
                map = Maps.newEnumMap(EquipmentSlotType.class);
            }
            map.put(equipmentslottype, itemstack1);
            if (!itemstack.func_190926_b()) {
                this.func_233645_dx_().func_233785_a_(itemstack.func_111283_C(equipmentslottype));
            }
            if (itemstack1.func_190926_b()) continue;
            this.func_233645_dx_().func_233793_b_(itemstack1.func_111283_C(equipmentslottype));
        }
        return map;
    }

    private void func_241342_a_(Map<EquipmentSlotType, ItemStack> p_241342_1_) {
        ItemStack itemstack = p_241342_1_.get(EquipmentSlotType.MAINHAND);
        ItemStack itemstack1 = p_241342_1_.get(EquipmentSlotType.OFFHAND);
        if (itemstack != null && itemstack1 != null && ItemStack.func_77989_b(itemstack, this.func_241347_e_(EquipmentSlotType.OFFHAND)) && ItemStack.func_77989_b(itemstack1, this.func_241347_e_(EquipmentSlotType.MAINHAND))) {
            ((ServerWorld)this.field_70170_p).func_72863_F().func_217218_b((Entity)this, (IPacket)new SEntityStatusPacket((Entity)this, 55));
            p_241342_1_.remove(EquipmentSlotType.MAINHAND);
            p_241342_1_.remove(EquipmentSlotType.OFFHAND);
            this.func_241345_c_(EquipmentSlotType.MAINHAND, itemstack.func_77946_l());
            this.func_241345_c_(EquipmentSlotType.OFFHAND, itemstack1.func_77946_l());
        }
    }

    private void func_241344_b_(Map<EquipmentSlotType, ItemStack> p_241344_1_) {
        ArrayList list = Lists.newArrayListWithCapacity((int)p_241344_1_.size());
        p_241344_1_.forEach((p_241341_2_, p_241341_3_) -> {
            ItemStack itemstack = p_241341_3_.func_77946_l();
            list.add(Pair.of((Object)p_241341_2_, (Object)((Object)itemstack)));
            switch (p_241341_2_.func_188453_a()) {
                case HAND: {
                    this.func_241345_c_((EquipmentSlotType)p_241341_2_, itemstack);
                    break;
                }
                case ARMOR: {
                    this.func_241343_b_((EquipmentSlotType)p_241341_2_, itemstack);
                }
            }
        });
        ((ServerWorld)this.field_70170_p).func_72863_F().func_217218_b((Entity)this, (IPacket)new SEntityEquipmentPacket(this.func_145782_y(), (List)list));
    }

    private ItemStack func_241346_d_(EquipmentSlotType p_241346_1_) {
        return (ItemStack)((Object)this.field_184631_bt.get(p_241346_1_.func_188454_b()));
    }

    private void func_241343_b_(EquipmentSlotType p_241343_1_, ItemStack p_241343_2_) {
        this.field_184631_bt.set(p_241343_1_.func_188454_b(), (Object)p_241343_2_);
    }

    private ItemStack func_241347_e_(EquipmentSlotType p_241347_1_) {
        return (ItemStack)((Object)this.field_184630_bs.get(p_241347_1_.func_188454_b()));
    }

    private void func_241345_c_(EquipmentSlotType p_241345_1_, ItemStack p_241345_2_) {
        this.field_184630_bs.set(p_241345_1_.func_188454_b(), (Object)p_241345_2_);
    }

    protected float func_110146_f(float p_110146_1_, float p_110146_2_) {
        boolean flag;
        float f = MathHelper.func_76142_g((float)(p_110146_1_ - this.field_70761_aq));
        this.field_70761_aq += f * 0.3f;
        float f1 = MathHelper.func_76142_g((float)(this.field_70177_z - this.field_70761_aq));
        boolean bl = flag = f1 < -90.0f || f1 >= 90.0f;
        if (f1 < -75.0f) {
            f1 = -75.0f;
        }
        if (f1 >= 75.0f) {
            f1 = 75.0f;
        }
        this.field_70761_aq = this.field_70177_z - f1;
        if (f1 * f1 > 2500.0f) {
            this.field_70761_aq += f1 * 0.2f;
        }
        if (flag) {
            p_110146_2_ *= -1.0f;
        }
        return p_110146_2_;
    }

    public void func_70636_d() {
        if (this.field_70773_bE > 0) {
            --this.field_70773_bE;
        }
        if (this.func_184186_bw()) {
            this.field_70716_bi = 0;
            this.func_213312_b(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_());
        }
        if (this.field_70716_bi > 0) {
            double d0 = this.func_226277_ct_() + (this.field_184623_bh - this.func_226277_ct_()) / (double)this.field_70716_bi;
            double d2 = this.func_226278_cu_() + (this.field_184624_bi - this.func_226278_cu_()) / (double)this.field_70716_bi;
            double d4 = this.func_226281_cx_() + (this.field_184625_bj - this.func_226281_cx_()) / (double)this.field_70716_bi;
            double d6 = MathHelper.func_76138_g((double)(this.field_184626_bk - (double)this.field_70177_z));
            this.field_70177_z = (float)((double)this.field_70177_z + d6 / (double)this.field_70716_bi);
            this.field_70125_A = (float)((double)this.field_70125_A + (this.field_70709_bj - (double)this.field_70125_A) / (double)this.field_70716_bi);
            --this.field_70716_bi;
            this.func_70107_b(d0, d2, d4);
            this.func_70101_b(this.field_70177_z, this.field_70125_A);
        } else if (!this.func_70613_aW()) {
            this.func_213317_d(this.func_213322_ci().func_186678_a(0.98));
        }
        if (this.field_208002_br > 0) {
            this.field_70759_as = (float)((double)this.field_70759_as + MathHelper.func_76138_g((double)(this.field_208001_bq - (double)this.field_70759_as)) / (double)this.field_208002_br);
            --this.field_208002_br;
        }
        Vector3d vector3d = this.func_213322_ci();
        double d1 = vector3d.field_72450_a;
        double d3 = vector3d.field_72448_b;
        double d5 = vector3d.field_72449_c;
        if (Math.abs(vector3d.field_72450_a) < 0.003) {
            d1 = 0.0;
        }
        if (Math.abs(vector3d.field_72448_b) < 0.003) {
            d3 = 0.0;
        }
        if (Math.abs(vector3d.field_72449_c) < 0.003) {
            d5 = 0.0;
        }
        this.func_213293_j(d1, d3, d5);
        this.field_70170_p.func_217381_Z().func_76320_a("ai");
        if (this.func_70610_aX()) {
            this.field_70703_bu = false;
            this.field_70702_br = 0.0f;
            this.field_191988_bg = 0.0f;
        } else if (this.func_70613_aW()) {
            this.field_70170_p.func_217381_Z().func_76320_a("newAi");
            this.func_70626_be();
            this.field_70170_p.func_217381_Z().func_76319_b();
        }
        this.field_70170_p.func_217381_Z().func_76319_b();
        this.field_70170_p.func_217381_Z().func_76320_a("jump");
        if (this.field_70703_bu && this.func_241208_cS_()) {
            double d7 = this.func_180799_ab() ? this.func_233571_b_(FluidTags.field_206960_b) : this.func_233571_b_(FluidTags.field_206959_a);
            boolean flag = this.func_70090_H() && d7 > 0.0;
            double d8 = this.func_233579_cu_();
            if (!flag || this.field_70122_E && !(d7 > d8)) {
                if (!this.func_180799_ab() || this.field_70122_E && !(d7 > d8)) {
                    if ((this.field_70122_E || flag && d7 <= d8) && this.field_70773_bE == 0) {
                        this.func_70664_aZ();
                        this.field_70773_bE = 10;
                    }
                } else {
                    this.func_180466_bG(FluidTags.field_206960_b);
                }
            } else {
                this.func_180466_bG(FluidTags.field_206959_a);
            }
        } else {
            this.field_70773_bE = 0;
        }
        this.field_70170_p.func_217381_Z().func_76319_b();
        this.field_70170_p.func_217381_Z().func_76320_a("travel");
        this.field_70702_br *= 0.98f;
        this.field_191988_bg *= 0.98f;
        this.func_184616_r();
        AxisAlignedBB axisalignedbb = this.func_174813_aQ();
        this.func_213352_e(new Vector3d(this.field_70702_br, this.field_70701_bs, this.field_191988_bg));
        this.field_70170_p.func_217381_Z().func_76319_b();
        this.field_70170_p.func_217381_Z().func_76320_a("push");
        if (this.field_204807_bs > 0) {
            --this.field_204807_bs;
            this.func_204801_a(axisalignedbb, this.func_174813_aQ());
        }
        this.func_85033_bc();
        this.field_70170_p.func_217381_Z().func_76319_b();
        if (!this.field_70170_p.field_72995_K && this.func_230270_dK_() && this.func_203008_ap()) {
            this.func_70097_a(DamageSource.field_76369_e, 1.0f);
        }
    }

    public boolean func_230270_dK_() {
        return false;
    }

    private void func_184616_r() {
        boolean flag = this.func_70083_f(7);
        if (flag && !this.field_70122_E && !this.func_184218_aH() && !this.func_70644_a(Effects.field_188424_y)) {
            ItemStack itemstack = this.func_184582_a(EquipmentSlotType.CHEST);
            if (itemstack.func_77973_b() == Items.field_185160_cR && ElytraItem.func_185069_d((ItemStack)itemstack)) {
                flag = true;
                if (!this.field_70170_p.field_72995_K && (this.field_184629_bo + 1) % 20 == 0) {
                    itemstack.func_222118_a(1, this, p_233652_0_ -> p_233652_0_.func_213361_c(EquipmentSlotType.CHEST));
                }
            } else {
                flag = false;
            }
        } else {
            flag = false;
        }
        if (!this.field_70170_p.field_72995_K) {
            this.func_70052_a(7, flag);
        }
    }

    protected void func_70626_be() {
    }

    protected void func_85033_bc() {
        List<Entity> list = this.field_70170_p.func_175674_a(this, this.func_174813_aQ(), EntityPredicates.func_200823_a((Entity)this));
        if (!list.isEmpty()) {
            int i = this.field_70170_p.func_82736_K().func_223592_c(GameRules.field_223616_s);
            if (i > 0 && list.size() > i - 1 && this.field_70146_Z.nextInt(4) == 0) {
                int j = 0;
                for (int k = 0; k < list.size(); ++k) {
                    if (list.get(k).func_184218_aH()) continue;
                    ++j;
                }
                if (j > i - 1) {
                    this.func_70097_a(DamageSource.field_191291_g, 6.0f);
                }
            }
            for (int l = 0; l < list.size(); ++l) {
                Entity entity = list.get(l);
                this.func_82167_n(entity);
            }
        }
    }

    protected void func_204801_a(AxisAlignedBB p_204801_1_, AxisAlignedBB p_204801_2_) {
        AxisAlignedBB axisalignedbb = p_204801_1_.func_111270_a(p_204801_2_);
        List list = this.field_70170_p.func_72839_b(this, axisalignedbb);
        if (!list.isEmpty()) {
            for (int i = 0; i < list.size(); ++i) {
                Entity entity = (Entity)((Object)list.get(i));
                if (!(entity instanceof LivingEntity)) continue;
                this.func_204804_d((LivingEntity)entity);
                this.field_204807_bs = 0;
                this.func_213317_d(this.func_213322_ci().func_186678_a(-0.2));
                break;
            }
        } else if (this.field_70123_F) {
            this.field_204807_bs = 0;
        }
        if (!this.field_70170_p.field_72995_K && this.field_204807_bs <= 0) {
            this.func_204802_c(4, false);
        }
    }

    protected void func_82167_n(Entity entityIn) {
        entityIn.func_70108_f(this);
    }

    protected void func_204804_d(LivingEntity p_204804_1_) {
    }

    public void func_204803_n(int p_204803_1_) {
        this.field_204807_bs = p_204803_1_;
        if (!this.field_70170_p.field_72995_K) {
            this.func_204802_c(4, true);
        }
    }

    public boolean func_204805_cN() {
        return (this.field_70180_af.func_187225_a(field_184621_as) & 4) != 0;
    }

    @Override
    public void func_184210_p() {
        Entity entity = this.func_184187_bx();
        super.func_184210_p();
        if (entity != null && entity != this.func_184187_bx() && !this.field_70170_p.field_72995_K) {
            this.func_233628_a_(entity);
        }
    }

    @Override
    public void func_70098_U() {
        super.func_70098_U();
        this.field_70768_au = this.field_110154_aX;
        this.field_110154_aX = 0.0f;
        this.field_70143_R = 0.0f;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void func_180426_a(double x, double y, double z, float yaw, float pitch, int posRotationIncrements, boolean teleport) {
        this.field_184623_bh = x;
        this.field_184624_bi = y;
        this.field_184625_bj = z;
        this.field_184626_bk = yaw;
        this.field_70709_bj = pitch;
        this.field_70716_bi = posRotationIncrements;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void func_208000_a(float yaw, int pitch) {
        this.field_208001_bq = yaw;
        this.field_208002_br = pitch;
    }

    public void func_70637_d(boolean jumping) {
        this.field_70703_bu = jumping;
    }

    public void func_233630_a_(ItemEntity p_233630_1_) {
        PlayerEntity playerentity;
        PlayerEntity playerEntity = playerentity = p_233630_1_.func_200214_m() != null ? this.field_70170_p.func_217371_b(p_233630_1_.func_200214_m()) : null;
        if (playerentity instanceof ServerPlayerEntity) {
            CriteriaTriggers.field_232609_O_.func_234830_a_((ServerPlayerEntity)playerentity, p_233630_1_.func_92059_d(), (Entity)this);
        }
    }

    public void func_71001_a(Entity entityIn, int quantity) {
        if (!entityIn.field_70128_L && !this.field_70170_p.field_72995_K && (entityIn instanceof ItemEntity || entityIn instanceof AbstractArrowEntity || entityIn instanceof ExperienceOrbEntity)) {
            ((ServerWorld)this.field_70170_p).func_72863_F().func_217218_b(entityIn, (IPacket)new SCollectItemPacket(entityIn.func_145782_y(), this.func_145782_y(), quantity));
        }
    }

    public boolean func_70685_l(Entity entityIn) {
        Vector3d vector3d1;
        Vector3d vector3d = new Vector3d(this.func_226277_ct_(), this.func_226280_cw_(), this.func_226281_cx_());
        return this.field_70170_p.func_217299_a(new RayTraceContext(vector3d, vector3d1 = new Vector3d(entityIn.func_226277_ct_(), entityIn.func_226280_cw_(), entityIn.func_226281_cx_()), RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, this)).func_216346_c() == RayTraceResult.Type.MISS;
    }

    @Override
    public float func_195046_g(float partialTicks) {
        return partialTicks == 1.0f ? this.field_70759_as : MathHelper.func_219799_g((float)partialTicks, (float)this.field_70758_at, (float)this.field_70759_as);
    }

    @OnlyIn(value=Dist.CLIENT)
    public float func_70678_g(float partialTickTime) {
        float f = this.field_70733_aJ - this.field_70732_aI;
        if (f < 0.0f) {
            f += 1.0f;
        }
        return this.field_70732_aI + f * partialTickTime;
    }

    public boolean func_70613_aW() {
        return !this.field_70170_p.field_72995_K;
    }

    @Override
    public boolean func_70067_L() {
        return !this.field_70128_L;
    }

    @Override
    public boolean func_70104_M() {
        return this.func_70089_S() && !this.func_70617_f_();
    }

    @Override
    protected void func_70018_K() {
        this.field_70133_I = this.field_70146_Z.nextDouble() >= this.func_233637_b_(Attributes.field_233820_c_);
    }

    @Override
    public float func_70079_am() {
        return this.field_70759_as;
    }

    @Override
    public void func_70034_d(float rotation) {
        this.field_70759_as = rotation;
    }

    @Override
    public void func_181013_g(float offset) {
        this.field_70761_aq = offset;
    }

    public float func_110139_bj() {
        return this.field_110151_bq;
    }

    public void func_110149_m(float amount) {
        if (amount < 0.0f) {
            amount = 0.0f;
        }
        this.field_110151_bq = amount;
    }

    public void func_152111_bt() {
    }

    public void func_152112_bu() {
    }

    protected void func_175136_bO() {
        this.field_70752_e = true;
    }

    public abstract HandSide func_184591_cq();

    public boolean func_184587_cr() {
        return (this.field_70180_af.func_187225_a(field_184621_as) & 1) > 0;
    }

    public Hand func_184600_cs() {
        return (this.field_70180_af.func_187225_a(field_184621_as) & 2) > 0 ? Hand.OFF_HAND : Hand.MAIN_HAND;
    }

    private void func_184608_ct() {
        if (this.func_184587_cr()) {
            ItemStack itemStack = this.func_184586_b(this.func_184600_cs());
            if (ForgeHooks.canContinueUsing((ItemStack)this.field_184627_bm, (ItemStack)itemStack)) {
                this.field_184627_bm = itemStack;
            }
            if (itemStack == this.field_184627_bm) {
                if (!this.field_184627_bm.func_190926_b()) {
                    this.field_184628_bn = ForgeEventFactory.onItemUseTick((LivingEntity)this, (ItemStack)this.field_184627_bm, (int)this.field_184628_bn);
                    if (this.field_184628_bn > 0) {
                        this.field_184627_bm.onUsingTick(this, this.field_184628_bn);
                    }
                }
                this.field_184627_bm.func_222121_b(this.field_70170_p, this, this.func_184605_cv());
                if (this.func_226299_p_()) {
                    this.func_226293_b_(this.field_184627_bm, 5);
                }
                if (--this.field_184628_bn == 0 && !this.field_70170_p.field_72995_K && !this.field_184627_bm.func_222122_m()) {
                    this.func_71036_o();
                }
            } else {
                this.func_184602_cy();
            }
        }
    }

    private boolean func_226299_p_() {
        int i = this.func_184605_cv();
        Food food = this.field_184627_bm.func_77973_b().func_219967_s();
        boolean flag = food != null && food.func_221465_e();
        return (flag |= i <= this.field_184627_bm.func_77988_m() - 7) && i % 4 == 0;
    }

    private void func_205014_p() {
        this.field_205018_bM = this.field_205017_bL;
        this.field_205017_bL = this.func_213314_bj() ? Math.min(1.0f, this.field_205017_bL + 0.09f) : Math.max(0.0f, this.field_205017_bL - 0.09f);
    }

    protected void func_204802_c(int key, boolean value) {
        int i = this.field_70180_af.func_187225_a(field_184621_as).byteValue();
        i = value ? (i |= key) : (i &= ~key);
        this.field_70180_af.func_187227_b(field_184621_as, (byte)i);
    }

    public void func_184598_c(Hand hand) {
        ItemStack itemstack = this.func_184586_b(hand);
        if (!itemstack.func_190926_b() && !this.func_184587_cr()) {
            int duration = ForgeEventFactory.onItemUseStart((LivingEntity)this, (ItemStack)itemstack, (int)itemstack.func_77988_m());
            if (duration <= 0) {
                return;
            }
            this.field_184627_bm = itemstack;
            this.field_184628_bn = duration;
            if (!this.field_70170_p.field_72995_K) {
                this.func_204802_c(1, true);
                this.func_204802_c(2, hand == Hand.OFF_HAND);
            }
        }
    }

    @Override
    public void func_184206_a(DataParameter<?> key) {
        super.func_184206_a(key);
        if (field_213379_bs.equals(key)) {
            if (this.field_70170_p.field_72995_K) {
                this.func_213374_dv().ifPresent(this::func_213370_a);
            }
        } else if (field_184621_as.equals(key) && this.field_70170_p.field_72995_K) {
            if (this.func_184587_cr() && this.field_184627_bm.func_190926_b()) {
                this.field_184627_bm = this.func_184586_b(this.func_184600_cs());
                if (!this.field_184627_bm.func_190926_b()) {
                    this.field_184628_bn = this.field_184627_bm.func_77988_m();
                }
            } else if (!this.func_184587_cr() && !this.field_184627_bm.func_190926_b()) {
                this.field_184627_bm = ItemStack.field_190927_a;
                this.field_184628_bn = 0;
            }
        }
    }

    @Override
    public void func_200602_a(EntityAnchorArgument.Type p_200602_1_, Vector3d p_200602_2_) {
        super.func_200602_a(p_200602_1_, p_200602_2_);
        this.field_70758_at = this.field_70759_as;
        this.field_70760_ar = this.field_70761_aq = this.field_70759_as;
    }

    protected void func_226293_b_(ItemStack p_226293_1_, int p_226293_2_) {
        if (!p_226293_1_.func_190926_b() && this.func_184587_cr()) {
            if (p_226293_1_.func_77975_n() == UseAction.DRINK) {
                this.func_184185_a(this.func_213351_c(p_226293_1_), 0.5f, this.field_70170_p.field_73012_v.nextFloat() * 0.1f + 0.9f);
            }
            if (p_226293_1_.func_77975_n() == UseAction.EAT) {
                this.func_195062_a(p_226293_1_, p_226293_2_);
                this.func_184185_a(this.func_213353_d(p_226293_1_), 0.5f + 0.5f * (float)this.field_70146_Z.nextInt(2), (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f);
            }
        }
    }

    private void func_195062_a(ItemStack stack, int count) {
        for (int i = 0; i < count; ++i) {
            Vector3d vector3d = new Vector3d(((double)this.field_70146_Z.nextFloat() - 0.5) * 0.1, Math.random() * 0.1 + 0.1, 0.0);
            vector3d = vector3d.func_178789_a(-this.field_70125_A * ((float)Math.PI / 180));
            vector3d = vector3d.func_178785_b(-this.field_70177_z * ((float)Math.PI / 180));
            double d0 = (double)(-this.field_70146_Z.nextFloat()) * 0.6 - 0.3;
            Vector3d vector3d1 = new Vector3d(((double)this.field_70146_Z.nextFloat() - 0.5) * 0.3, d0, 0.6);
            vector3d1 = vector3d1.func_178789_a(-this.field_70125_A * ((float)Math.PI / 180));
            vector3d1 = vector3d1.func_178785_b(-this.field_70177_z * ((float)Math.PI / 180));
            vector3d1 = vector3d1.func_72441_c(this.func_226277_ct_(), this.func_226280_cw_(), this.func_226281_cx_());
            if (this.field_70170_p instanceof ServerWorld) {
                ((ServerWorld)this.field_70170_p).func_195598_a(new ItemParticleData(ParticleTypes.field_197591_B, stack), vector3d1.field_72450_a, vector3d1.field_72448_b, vector3d1.field_72449_c, 1, vector3d.field_72450_a, vector3d.field_72448_b + 0.05, vector3d.field_72449_c, 0.0);
                continue;
            }
            this.field_70170_p.func_195594_a(new ItemParticleData(ParticleTypes.field_197591_B, stack), vector3d1.field_72450_a, vector3d1.field_72448_b, vector3d1.field_72449_c, vector3d.field_72450_a, vector3d.field_72448_b + 0.05, vector3d.field_72449_c);
        }
    }

    protected void func_71036_o() {
        if (!((Object)((Object)this.field_184627_bm)).equals((Object)this.func_184586_b(this.func_184600_cs()))) {
            this.func_184597_cx();
        } else if (!this.field_184627_bm.func_190926_b() && this.func_184587_cr()) {
            this.func_226293_b_(this.field_184627_bm, 16);
            ItemStack copy = this.field_184627_bm.func_77946_l();
            ItemStack stack = ForgeEventFactory.onItemUseFinish((LivingEntity)this, (ItemStack)copy, (int)this.func_184605_cv(), (ItemStack)this.field_184627_bm.func_77950_b(this.field_70170_p, this));
            this.func_184611_a(this.func_184600_cs(), stack);
            this.func_184602_cy();
        }
    }

    public ItemStack func_184607_cu() {
        return this.field_184627_bm;
    }

    public int func_184605_cv() {
        return this.field_184628_bn;
    }

    public int func_184612_cw() {
        return this.func_184587_cr() ? this.field_184627_bm.func_77988_m() - this.func_184605_cv() : 0;
    }

    public void func_184597_cx() {
        if (!this.field_184627_bm.func_190926_b()) {
            if (!ForgeEventFactory.onUseItemStop((LivingEntity)this, (ItemStack)this.field_184627_bm, (int)this.func_184605_cv())) {
                ItemStack copy = this instanceof PlayerEntity ? this.field_184627_bm.func_77946_l() : null;
                this.field_184627_bm.func_77974_b(this.field_70170_p, this, this.func_184605_cv());
                if (copy != null && this.field_184627_bm.func_190926_b()) {
                    ForgeEventFactory.onPlayerDestroyItem((PlayerEntity)((PlayerEntity)this), (ItemStack)copy, (Hand)this.func_184600_cs());
                }
            }
            if (this.field_184627_bm.func_222122_m()) {
                this.func_184608_ct();
            }
        }
        this.func_184602_cy();
    }

    public void func_184602_cy() {
        if (!this.field_70170_p.field_72995_K) {
            this.func_204802_c(1, false);
        }
        this.field_184627_bm = ItemStack.field_190927_a;
        this.field_184628_bn = 0;
    }

    public boolean func_184585_cz() {
        if (this.func_184587_cr() && !this.field_184627_bm.func_190926_b()) {
            Item item = this.field_184627_bm.func_77973_b();
            if (item.func_77661_b(this.field_184627_bm) != UseAction.BLOCK) {
                return false;
            }
            return item.func_77626_a(this.field_184627_bm) - this.field_184628_bn >= 5;
        }
        return false;
    }

    public boolean func_230491_ea_() {
        return this.func_225608_bj_();
    }

    public boolean func_184613_cA() {
        return this.func_70083_f(7);
    }

    @Override
    public boolean func_213314_bj() {
        return super.func_213314_bj() || !this.func_184613_cA() && this.func_213283_Z() == Pose.FALL_FLYING;
    }

    @OnlyIn(value=Dist.CLIENT)
    public int func_184599_cB() {
        return this.field_184629_bo;
    }

    public boolean func_213373_a(double p_213373_1_, double p_213373_3_, double p_213373_5_, boolean p_213373_7_) {
        double d0 = this.func_226277_ct_();
        double d1 = this.func_226278_cu_();
        double d2 = this.func_226281_cx_();
        double d3 = p_213373_3_;
        boolean flag = false;
        World world = this.field_70170_p;
        BlockPos blockpos = new BlockPos(p_213373_1_, p_213373_3_, p_213373_5_);
        if (world.func_175667_e(blockpos)) {
            boolean flag1 = false;
            while (!flag1 && blockpos.func_177956_o() > 0) {
                BlockPos blockpos1 = blockpos.func_177977_b();
                BlockState blockstate = world.func_180495_p(blockpos1);
                if (blockstate.func_185904_a().func_76230_c()) {
                    flag1 = true;
                    continue;
                }
                d3 -= 1.0;
                blockpos = blockpos1;
            }
            if (flag1) {
                this.func_70634_a(p_213373_1_, d3, p_213373_5_);
                if (world.func_226669_j_(this) && !world.func_72953_d(this.func_174813_aQ())) {
                    flag = true;
                }
            }
        }
        if (!flag) {
            this.func_70634_a(d0, d1, d2);
            return false;
        }
        if (p_213373_7_) {
            world.func_72960_a(this, (byte)46);
        }
        if (this instanceof CreatureEntity) {
            ((CreatureEntity)this).func_70661_as().func_75499_g();
        }
        return true;
    }

    public boolean func_184603_cC() {
        return true;
    }

    public boolean func_190631_cK() {
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_191987_a(BlockPos pos, boolean isPartying) {
    }

    public boolean func_213365_e(ItemStack itemstackIn) {
        return false;
    }

    @Override
    public IPacket<?> func_213297_N() {
        return new SSpawnMobPacket(this);
    }

    @Override
    public EntitySize func_213305_a(Pose poseIn) {
        return poseIn == Pose.SLEEPING ? field_213377_as : super.func_213305_a(poseIn).func_220313_a(this.func_213355_cm());
    }

    public ImmutableList<Pose> func_230297_ef_() {
        return ImmutableList.of((Object)Pose.STANDING);
    }

    public AxisAlignedBB func_233648_f_(Pose p_233648_1_) {
        EntitySize entitysize = this.func_213305_a(p_233648_1_);
        return new AxisAlignedBB((double)(-entitysize.field_220315_a / 2.0f), 0.0, (double)(-entitysize.field_220315_a / 2.0f), (double)(entitysize.field_220315_a / 2.0f), (double)entitysize.field_220316_b, (double)(entitysize.field_220315_a / 2.0f));
    }

    public Optional<BlockPos> func_213374_dv() {
        return this.field_70180_af.func_187225_a(field_213379_bs);
    }

    public void func_213369_d(BlockPos p_213369_1_) {
        this.field_70180_af.func_187227_b(field_213379_bs, Optional.of(p_213369_1_));
    }

    public void func_213372_dw() {
        this.field_70180_af.func_187227_b(field_213379_bs, Optional.empty());
    }

    public boolean func_70608_bn() {
        return this.func_213374_dv().isPresent();
    }

    public void func_213342_e(BlockPos pos) {
        BlockState blockstate;
        if (this.func_184218_aH()) {
            this.func_184210_p();
        }
        if ((blockstate = this.field_70170_p.func_180495_p(pos)).func_177230_c() instanceof BedBlock) {
            this.field_70170_p.func_180501_a(pos, (BlockState)((Object)blockstate.func_206870_a((Property)BedBlock.field_176471_b, Boolean.valueOf(true))), 3);
        }
        this.func_213301_b(Pose.SLEEPING);
        this.func_213370_a(pos);
        this.func_213369_d(pos);
        this.func_213317_d(Vector3d.field_186680_a);
        this.field_70160_al = true;
    }

    private void func_213370_a(BlockPos p_213370_1_) {
        this.func_70107_b((double)p_213370_1_.func_177958_n() + 0.5, (double)p_213370_1_.func_177956_o() + 0.6875, (double)p_213370_1_.func_177952_p() + 0.5);
    }

    private boolean func_213359_p() {
        return this.func_213374_dv().map(p_241350_1_ -> ForgeEventFactory.fireSleepingLocationCheck((LivingEntity)this, (BlockPos)p_241350_1_)).orElse(false);
    }

    public void func_213366_dy() {
        this.func_213374_dv().filter(arg_0 -> this.field_70170_p.func_175667_e(arg_0)).ifPresent(p_241348_1_ -> {
            BlockState blockstate = this.field_70170_p.func_180495_p((BlockPos)p_241348_1_);
            if (blockstate.isBed((IBlockReader)((Object)this.field_70170_p), this.func_226270_aj_(), this)) {
                this.field_70170_p.func_180501_a((BlockPos)p_241348_1_, (BlockState)((Object)((Object)blockstate.func_206870_a((Property)BedBlock.field_176471_b, Boolean.valueOf(false)))), 3);
                Vector3d vector3d1 = BedBlock.func_220172_a(this.func_200600_R(), (IWorldReader)((Object)this.field_70170_p), (BlockPos)p_241348_1_, (int)0).orElseGet(() -> {
                    BlockPos blockpos = p_241348_1_.func_177984_a();
                    return new Vector3d((double)blockpos.func_177958_n() + 0.5, (double)blockpos.func_177956_o() + 0.1, (double)blockpos.func_177952_p() + 0.5);
                });
                this.func_70107_b(vector3d1.field_72450_a, vector3d1.field_72448_b, vector3d1.field_72449_c);
            }
        });
        Vector3d vector3d = this.func_213303_ch();
        this.func_213301_b(Pose.STANDING);
        this.func_70107_b(vector3d.field_72450_a, vector3d.field_72448_b, vector3d.field_72449_c);
        this.func_213372_dw();
    }

    @Nullable
    @OnlyIn(value=Dist.CLIENT)
    public Direction func_213376_dz() {
        BlockPos blockpos = this.func_213374_dv().orElse(null);
        if (blockpos == null) {
            return Direction.UP;
        }
        BlockState state = this.field_70170_p.func_180495_p(blockpos);
        return !state.isBed((IBlockReader)((Object)this.field_70170_p), blockpos, this) ? Direction.UP : state.getBedDirection((IWorldReader)((Object)this.field_70170_p), blockpos);
    }

    @Override
    public boolean func_70094_T() {
        return !this.func_70608_bn() && super.func_70094_T();
    }

    @Override
    protected final float func_213316_a(Pose poseIn, EntitySize sizeIn) {
        return poseIn == Pose.SLEEPING ? 0.2f : this.func_213348_b(poseIn, sizeIn);
    }

    protected float func_213348_b(Pose poseIn, EntitySize sizeIn) {
        return super.func_213316_a(poseIn, sizeIn);
    }

    public ItemStack func_213356_f(ItemStack shootable) {
        return ItemStack.field_190927_a;
    }

    public ItemStack func_213357_a(World p_213357_1_, ItemStack p_213357_2_) {
        if (p_213357_2_.func_222117_E()) {
            p_213357_1_.func_184148_a(null, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), this.func_213353_d(p_213357_2_), SoundCategory.NEUTRAL, 1.0f, 1.0f + (p_213357_1_.field_73012_v.nextFloat() - p_213357_1_.field_73012_v.nextFloat()) * 0.4f);
            this.func_213349_a(p_213357_2_, p_213357_1_, this);
            if (!(this instanceof PlayerEntity) || !((PlayerEntity)this).field_71075_bZ.field_75098_d) {
                p_213357_2_.func_190918_g(1);
            }
        }
        return p_213357_2_;
    }

    private void func_213349_a(ItemStack p_213349_1_, World p_213349_2_, LivingEntity p_213349_3_) {
        Item item = p_213349_1_.func_77973_b();
        if (item.func_219971_r()) {
            for (Pair<EffectInstance, Float> pair : item.func_219967_s().func_221464_f()) {
                if (p_213349_2_.field_72995_K || pair.getFirst() == null || !(p_213349_2_.field_73012_v.nextFloat() < ((Float)pair.getSecond()).floatValue())) continue;
                p_213349_3_.func_195064_c(new EffectInstance((EffectInstance)pair.getFirst()));
            }
        }
    }

    private static byte func_213350_d(EquipmentSlotType p_213350_0_) {
        switch (p_213350_0_) {
            case MAINHAND: {
                return 47;
            }
            case OFFHAND: {
                return 48;
            }
            case HEAD: {
                return 49;
            }
            case CHEST: {
                return 50;
            }
            case FEET: {
                return 52;
            }
            case LEGS: {
                return 51;
            }
        }
        return 47;
    }

    public void func_213361_c(EquipmentSlotType p_213361_1_) {
        this.field_70170_p.func_72960_a(this, LivingEntity.func_213350_d(p_213361_1_));
    }

    public void func_213334_d(Hand p_213334_1_) {
        this.func_213361_c(p_213334_1_ == Hand.MAIN_HAND ? EquipmentSlotType.MAINHAND : EquipmentSlotType.OFFHAND);
    }

    public boolean curePotionEffects(ItemStack curativeItem) {
        if (this.field_70170_p.field_72995_K) {
            return false;
        }
        boolean ret = false;
        Iterator<EffectInstance> itr = this.field_70713_bf.values().iterator();
        while (itr.hasNext()) {
            EffectInstance effect = itr.next();
            if (!effect.isCurativeItem(curativeItem) || MinecraftForge.EVENT_BUS.post((Event)new PotionEvent.PotionRemoveEvent(this, effect))) continue;
            this.func_70688_c(effect);
            itr.remove();
            ret = true;
            this.field_70752_e = true;
        }
        return ret;
    }

    public boolean shouldRiderFaceForward(PlayerEntity player) {
        return this instanceof PigEntity;
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
        if (this.func_70089_S() && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (facing == null) {
                return this.handlers[2].cast();
            }
            if (facing.func_176740_k().func_200128_b()) {
                return this.handlers[0].cast();
            }
            if (facing.func_176740_k().func_176722_c()) {
                return this.handlers[1].cast();
            }
        }
        return super.getCapability(capability, facing);
    }

    @Override
    public void remove(boolean keepData) {
        super.remove(keepData);
        if (!keepData) {
            for (int x = 0; x < this.handlers.length; ++x) {
                this.handlers[x].invalidate();
            }
        }
    }
}

