/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.world;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.function.BooleanSupplier;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.EntityTickableSound;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SimpleSound;
import net.minecraft.client.entity.player.AbstractClientPlayerEntity;
import net.minecraft.client.multiplayer.ClientChunkProvider;
import net.minecraft.client.network.play.ClientPlayNetHandler;
import net.minecraft.client.particle.FireworkParticle;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.color.ColorCache;
import net.minecraft.client.world.DimensionRenderInfo;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.crash.ICrashReportDetail;
import net.minecraft.crash.ReportedException;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.FluidState;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.RecipeManager;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.profiler.IProfiler;
import net.minecraft.scoreboard.Scoreboard;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.NetworkTagManager;
import net.minecraft.util.Direction;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.CubeCoordinateIterator;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DimensionType;
import net.minecraft.world.EmptyTickList;
import net.minecraft.world.GameRules;
import net.minecraft.world.GameType;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.ITickList;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeColors;
import net.minecraft.world.biome.Biomes;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkStatus;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.level.ColorResolver;
import net.minecraft.world.storage.ISpawnWorldInfo;
import net.minecraft.world.storage.MapData;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.PlaySoundAtEntityEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.Event;

@OnlyIn(value=Dist.CLIENT)
public class ClientWorld
extends World {
    private final Int2ObjectMap<Entity> field_217429_b = new Int2ObjectOpenHashMap();
    private final ClientPlayNetHandler field_73035_a;
    private final WorldRenderer field_217430_d;
    private final ClientWorldInfo field_239130_d_;
    private final DimensionRenderInfo field_239131_x_;
    private final Minecraft field_73037_M = Minecraft.func_71410_x();
    private final List<AbstractClientPlayerEntity> field_217431_w = Lists.newArrayList();
    private Scoreboard field_200261_M = new Scoreboard();
    private final Map<String, MapData> field_217432_z = Maps.newHashMap();
    private int field_228314_A_;
    private final Object2ObjectArrayMap<ColorResolver, ColorCache> field_228315_B_ = (Object2ObjectArrayMap)Util.func_200696_a((Object)new Object2ObjectArrayMap(3), p_228319_0_ -> {
        p_228319_0_.put((Object)BiomeColors.field_180291_a, (Object)new ColorCache());
        p_228319_0_.put((Object)BiomeColors.field_180289_b, (Object)new ColorCache());
        p_228319_0_.put((Object)BiomeColors.field_180290_c, (Object)new ColorCache());
    });
    private final ClientChunkProvider field_239129_E_;

    public ClientWorld(ClientPlayNetHandler p_i232337_1_, ClientWorldInfo p_i232337_2_, RegistryKey<World> p_i232337_3_, RegistryKey<DimensionType> p_i232337_4_, DimensionType p_i232337_5_, int p_i232337_6_, Supplier<IProfiler> p_i232337_7_, WorldRenderer p_i232337_8_, boolean p_i232337_9_, long p_i232337_10_) {
        super(p_i232337_2_, p_i232337_3_, p_i232337_4_, p_i232337_5_, p_i232337_7_, true, p_i232337_9_, p_i232337_10_);
        this.field_239129_E_ = new ClientChunkProvider(this, p_i232337_6_);
        this.field_239130_d_ = p_i232337_2_;
        this.field_73035_a = p_i232337_1_;
        this.field_217430_d = p_i232337_8_;
        this.field_239131_x_ = DimensionRenderInfo.func_239215_a_(p_i232337_1_.func_239165_n_().func_230520_a_().func_230519_c_(p_i232337_5_));
        this.func_239136_a_(new BlockPos(8, 64, 8));
        this.func_72966_v();
        this.func_72947_a();
        MinecraftForge.EVENT_BUS.post((Event)new WorldEvent.Load((IWorld)this));
    }

    public DimensionRenderInfo func_239132_a_() {
        return this.field_239131_x_;
    }

    public void func_72835_b(BooleanSupplier hasTimeLeft) {
        this.func_175723_af().func_212673_r();
        this.func_239141_x_();
        this.func_217381_Z().func_76320_a("blocks");
        this.field_239129_E_.func_217207_a(hasTimeLeft);
        this.func_217381_Z().func_76319_b();
    }

    private void func_239141_x_() {
        this.func_239134_a_(this.field_72986_A.func_82573_f() + 1L);
        if (this.field_72986_A.func_82574_x().func_223586_b(GameRules.field_223607_j)) {
            this.func_72877_b(this.field_72986_A.func_76073_f() + 1L);
        }
    }

    public void func_239134_a_(long p_239134_1_) {
        this.field_239130_d_.func_239155_a_(p_239134_1_);
    }

    public void func_72877_b(long time) {
        if (time < 0L) {
            time = -time;
            ((GameRules.BooleanValue)this.func_82736_K().func_223585_a(GameRules.field_223607_j)).func_223570_a(false, (MinecraftServer)null);
        } else {
            ((GameRules.BooleanValue)this.func_82736_K().func_223585_a(GameRules.field_223607_j)).func_223570_a(true, (MinecraftServer)null);
        }
        this.field_239130_d_.func_239158_b_(time);
    }

    public Iterable<Entity> func_217416_b() {
        return this.field_217429_b.values();
    }

    public void func_217419_d() {
        IProfiler iprofiler = this.func_217381_Z();
        iprofiler.func_76320_a("entities");
        ObjectIterator objectiterator = this.field_217429_b.int2ObjectEntrySet().iterator();
        while (objectiterator.hasNext()) {
            Int2ObjectMap.Entry entry = (Int2ObjectMap.Entry)objectiterator.next();
            Entity entity = (Entity)((Object)entry.getValue());
            if (entity.func_184218_aH()) continue;
            iprofiler.func_76320_a("tick");
            if (!entity.field_70128_L) {
                this.func_217390_a(this::func_217418_a, entity);
            }
            iprofiler.func_76319_b();
            iprofiler.func_76320_a("remove");
            if (entity.field_70128_L) {
                objectiterator.remove();
                this.func_217414_d(entity);
            }
            iprofiler.func_76319_b();
        }
        this.func_217391_K();
        iprofiler.func_76319_b();
    }

    public void func_217418_a(Entity entityIn) {
        if (!(entityIn instanceof PlayerEntity) && !this.func_72863_F().func_217204_a(entityIn)) {
            this.func_217423_b(entityIn);
        } else {
            entityIn.func_226286_f_(entityIn.func_226277_ct_(), entityIn.func_226278_cu_(), entityIn.func_226281_cx_());
            entityIn.field_70126_B = entityIn.field_70177_z;
            entityIn.field_70127_C = entityIn.field_70125_A;
            if (entityIn.field_70175_ag || entityIn.func_175149_v()) {
                ++entityIn.field_70173_aa;
                this.func_217381_Z().func_194340_a(() -> Registry.field_212629_r.func_177774_c(entityIn.func_200600_R()).toString());
                if (entityIn.canUpdate()) {
                    entityIn.func_70071_h_();
                }
                this.func_217381_Z().func_76319_b();
            }
            this.func_217423_b(entityIn);
            if (entityIn.field_70175_ag) {
                for (Entity entity : entityIn.func_184188_bt()) {
                    this.func_217420_a(entityIn, entity);
                }
            }
        }
    }

    public void func_217420_a(Entity p_217420_1_, Entity p_217420_2_) {
        if (!p_217420_2_.field_70128_L && p_217420_2_.func_184187_bx() == p_217420_1_) {
            if (p_217420_2_ instanceof PlayerEntity || this.func_72863_F().func_217204_a(p_217420_2_)) {
                p_217420_2_.func_226286_f_(p_217420_2_.func_226277_ct_(), p_217420_2_.func_226278_cu_(), p_217420_2_.func_226281_cx_());
                p_217420_2_.field_70126_B = p_217420_2_.field_70177_z;
                p_217420_2_.field_70127_C = p_217420_2_.field_70125_A;
                if (p_217420_2_.field_70175_ag) {
                    ++p_217420_2_.field_70173_aa;
                    p_217420_2_.func_70098_U();
                }
                this.func_217423_b(p_217420_2_);
                if (p_217420_2_.field_70175_ag) {
                    for (Entity entity : p_217420_2_.func_184188_bt()) {
                        this.func_217420_a(p_217420_2_, entity);
                    }
                }
            }
        } else {
            p_217420_2_.func_184210_p();
        }
    }

    private void func_217423_b(Entity entityIn) {
        if (entityIn.func_233578_ci_()) {
            this.func_217381_Z().func_76320_a("chunkCheck");
            int i = MathHelper.func_76128_c((double)(entityIn.func_226277_ct_() / 16.0));
            int j = MathHelper.func_76128_c((double)(entityIn.func_226278_cu_() / 16.0));
            int k = MathHelper.func_76128_c((double)(entityIn.func_226281_cx_() / 16.0));
            if (!entityIn.field_70175_ag || entityIn.field_70176_ah != i || entityIn.field_70162_ai != j || entityIn.field_70164_aj != k) {
                if (entityIn.field_70175_ag && this.func_217354_b(entityIn.field_70176_ah, entityIn.field_70164_aj)) {
                    this.func_212866_a_(entityIn.field_70176_ah, entityIn.field_70164_aj).func_76608_a(entityIn, entityIn.field_70162_ai);
                }
                if (!entityIn.func_233577_ch_() && !this.func_217354_b(i, k)) {
                    if (entityIn.field_70175_ag) {
                        field_195596_d.warn("Entity {} left loaded chunk area", (Object)entityIn);
                    }
                    entityIn.field_70175_ag = false;
                } else {
                    this.func_212866_a_(i, k).func_76612_a(entityIn);
                }
            }
            this.func_217381_Z().func_76319_b();
        }
    }

    public void func_217409_a(Chunk chunkIn) {
        this.field_147483_b.addAll(chunkIn.func_177434_r().values());
        this.field_239129_E_.func_212863_j_().func_215571_a(chunkIn.func_76632_l(), false);
    }

    public void func_228323_e_(int chunkX, int chunkZ) {
        this.field_228315_B_.forEach((p_228316_2_, p_228316_3_) -> p_228316_3_.func_228070_a_(chunkX, chunkZ));
    }

    public void func_228327_h_() {
        this.field_228315_B_.forEach((p_228320_0_, p_228320_1_) -> p_228320_1_.func_228069_a_());
    }

    public boolean func_217354_b(int chunkX, int chunkZ) {
        return true;
    }

    public int func_217425_f() {
        return this.field_217429_b.size();
    }

    public void func_217408_a(int playerId, AbstractClientPlayerEntity playerEntityIn) {
        this.func_217424_b(playerId, playerEntityIn);
        this.field_217431_w.add(playerEntityIn);
    }

    public void func_217411_a(int entityIdIn, Entity entityToSpawn) {
        this.func_217424_b(entityIdIn, entityToSpawn);
    }

    private void func_217424_b(int entityIdIn, Entity entityToSpawn) {
        if (MinecraftForge.EVENT_BUS.post((Event)new EntityJoinWorldEvent(entityToSpawn, (World)this))) {
            return;
        }
        this.func_217413_d(entityIdIn);
        this.field_217429_b.put(entityIdIn, (Object)entityToSpawn);
        this.func_72863_F().func_212849_a_(MathHelper.func_76128_c((double)(entityToSpawn.func_226277_ct_() / 16.0)), MathHelper.func_76128_c((double)(entityToSpawn.func_226281_cx_() / 16.0)), ChunkStatus.field_222617_m, true).func_76612_a(entityToSpawn);
        entityToSpawn.onAddedToWorld();
    }

    public void func_217413_d(int eid) {
        Entity entity = (Entity)((Object)this.field_217429_b.remove(eid));
        if (entity != null) {
            entity.func_70106_y();
            this.func_217414_d(entity);
        }
    }

    private void func_217414_d(Entity entityIn) {
        entityIn.func_213319_R();
        if (entityIn.field_70175_ag) {
            this.func_212866_a_(entityIn.field_70176_ah, entityIn.field_70164_aj).func_76622_b(entityIn);
        }
        this.field_217431_w.remove((Object)entityIn);
        entityIn.onRemovedFromWorld();
    }

    public void func_217417_b(Chunk chunkIn) {
        for (Int2ObjectMap.Entry entry : this.field_217429_b.int2ObjectEntrySet()) {
            Entity entity = (Entity)((Object)entry.getValue());
            int i = MathHelper.func_76128_c((double)(entity.func_226277_ct_() / 16.0));
            int j = MathHelper.func_76128_c((double)(entity.func_226281_cx_() / 16.0));
            if (i != chunkIn.func_76632_l().field_77276_a || j != chunkIn.func_76632_l().field_77275_b) continue;
            chunkIn.func_76612_a(entity);
        }
    }

    @Override
    @Nullable
    public Entity func_73045_a(int id) {
        return (Entity)((Object)this.field_217429_b.get(id));
    }

    public void func_195597_b(BlockPos pos, BlockState state) {
        this.func_180501_a(pos, state, 19);
    }

    @Override
    public void func_72882_A() {
        this.field_73035_a.func_147298_b().func_150718_a((ITextComponent)new TranslationTextComponent("multiplayer.status.quitting"));
    }

    public void func_73029_E(int posX, int posY, int posZ) {
        int i = 32;
        Random random = new Random();
        boolean flag = false;
        if (this.field_73037_M.field_71442_b.func_178889_l() == GameType.CREATIVE) {
            for (ItemStack itemstack : this.field_73037_M.field_71439_g.func_184214_aD()) {
                if (itemstack.func_77973_b() != Blocks.field_180401_cv.func_199767_j()) continue;
                flag = true;
                break;
            }
        }
        BlockPos.Mutable blockpos$mutable = new BlockPos.Mutable();
        for (int j = 0; j < 667; ++j) {
            this.func_184153_a(posX, posY, posZ, 16, random, flag, blockpos$mutable);
            this.func_184153_a(posX, posY, posZ, 32, random, flag, blockpos$mutable);
        }
    }

    public void func_184153_a(int x, int y, int z, int offset, Random random, boolean holdingBarrier, BlockPos.Mutable pos) {
        int i = x + this.field_73012_v.nextInt(offset) - this.field_73012_v.nextInt(offset);
        int j = y + this.field_73012_v.nextInt(offset) - this.field_73012_v.nextInt(offset);
        int k = z + this.field_73012_v.nextInt(offset) - this.field_73012_v.nextInt(offset);
        pos.func_181079_c(i, j, k);
        BlockState blockstate = this.func_180495_p((BlockPos)pos);
        blockstate.func_177230_c().func_180655_c(blockstate, this, (BlockPos)pos, random);
        FluidState fluidstate = this.func_204610_c((BlockPos)pos);
        if (!fluidstate.func_206888_e()) {
            fluidstate.func_206881_a(this, (BlockPos)pos, random);
            IParticleData iparticledata = fluidstate.func_204521_c();
            if (iparticledata != null && this.field_73012_v.nextInt(10) == 0) {
                boolean flag = blockstate.func_224755_d((IBlockReader)((Object)this), (BlockPos)pos, Direction.DOWN);
                BlockPos blockpos = pos.func_177977_b();
                this.func_211530_a(blockpos, this.func_180495_p(blockpos), iparticledata, flag);
            }
        }
        if (holdingBarrier && blockstate.func_203425_a(Blocks.field_180401_cv)) {
            this.func_195594_a((IParticleData)ParticleTypes.field_197610_c, (double)i + 0.5, (double)j + 0.5, (double)k + 0.5, 0.0, 0.0, 0.0);
        }
        if (!blockstate.func_235785_r_((IBlockReader)((Object)this), (BlockPos)pos)) {
            this.func_226691_t_((BlockPos)pos).func_235090_t_().ifPresent(p_239135_2_ -> {
                if (p_239135_2_.func_235047_a_(this.field_73012_v)) {
                    this.func_195594_a(p_239135_2_.func_235044_a_(), (double)pos.func_177958_n() + this.field_73012_v.nextDouble(), (double)pos.func_177956_o() + this.field_73012_v.nextDouble(), (double)pos.func_177952_p() + this.field_73012_v.nextDouble(), 0.0, 0.0, 0.0);
                }
            });
        }
    }

    private void func_211530_a(BlockPos blockPosIn, BlockState blockStateIn, IParticleData particleDataIn, boolean shapeDownSolid) {
        if (blockStateIn.func_204520_s().func_206888_e()) {
            VoxelShape voxelshape = blockStateIn.func_196952_d((IBlockReader)((Object)this), blockPosIn);
            double d0 = voxelshape.func_197758_c(Direction.Axis.Y);
            if (d0 < 1.0) {
                if (shapeDownSolid) {
                    this.func_211834_a(blockPosIn.func_177958_n(), blockPosIn.func_177958_n() + 1, blockPosIn.func_177952_p(), blockPosIn.func_177952_p() + 1, (double)(blockPosIn.func_177956_o() + 1) - 0.05, particleDataIn);
                }
            } else if (!blockStateIn.func_235714_a_(BlockTags.field_211923_H)) {
                double d1 = voxelshape.func_197762_b(Direction.Axis.Y);
                if (d1 > 0.0) {
                    this.func_211835_a(blockPosIn, particleDataIn, voxelshape, (double)blockPosIn.func_177956_o() + d1 - 0.05);
                } else {
                    BlockPos blockpos = blockPosIn.func_177977_b();
                    BlockState blockstate = this.func_180495_p(blockpos);
                    VoxelShape voxelshape1 = blockstate.func_196952_d((IBlockReader)((Object)this), blockpos);
                    double d2 = voxelshape1.func_197758_c(Direction.Axis.Y);
                    if (d2 < 1.0 && blockstate.func_204520_s().func_206888_e()) {
                        this.func_211835_a(blockPosIn, particleDataIn, voxelshape, (double)blockPosIn.func_177956_o() - 0.05);
                    }
                }
            }
        }
    }

    private void func_211835_a(BlockPos posIn, IParticleData particleDataIn, VoxelShape voxelShapeIn, double y) {
        this.func_211834_a((double)posIn.func_177958_n() + voxelShapeIn.func_197762_b(Direction.Axis.X), (double)posIn.func_177958_n() + voxelShapeIn.func_197758_c(Direction.Axis.X), (double)posIn.func_177952_p() + voxelShapeIn.func_197762_b(Direction.Axis.Z), (double)posIn.func_177952_p() + voxelShapeIn.func_197758_c(Direction.Axis.Z), y, particleDataIn);
    }

    private void func_211834_a(double xStart, double xEnd, double zStart, double zEnd, double y, IParticleData particleDataIn) {
        this.func_195594_a(particleDataIn, MathHelper.func_219803_d((double)this.field_73012_v.nextDouble(), (double)xStart, (double)xEnd), y, MathHelper.func_219803_d((double)this.field_73012_v.nextDouble(), (double)zStart, (double)zEnd), 0.0, 0.0, 0.0);
    }

    public void func_73022_a() {
        ObjectIterator objectiterator = this.field_217429_b.int2ObjectEntrySet().iterator();
        while (objectiterator.hasNext()) {
            Int2ObjectMap.Entry entry = (Int2ObjectMap.Entry)objectiterator.next();
            Entity entity = (Entity)((Object)entry.getValue());
            if (!entity.field_70128_L) continue;
            objectiterator.remove();
            this.func_217414_d(entity);
        }
    }

    @Override
    public CrashReportCategory func_72914_a(CrashReport report) {
        CrashReportCategory crashreportcategory = super.func_72914_a(report);
        crashreportcategory.func_189529_a("Server brand", (ICrashReportDetail<String>)((ICrashReportDetail)() -> this.field_73037_M.field_71439_g.func_142021_k()));
        crashreportcategory.func_189529_a("Server type", (ICrashReportDetail<String>)((ICrashReportDetail)() -> this.field_73037_M.func_71401_C() == null ? "Non-integrated multiplayer server" : "Integrated singleplayer server"));
        return crashreportcategory;
    }

    @Override
    public void func_184148_a(@Nullable PlayerEntity player, double x, double y, double z, SoundEvent soundIn, SoundCategory category, float volume, float pitch) {
        PlaySoundAtEntityEvent event = ForgeEventFactory.onPlaySoundAtEntity((Entity)player, (SoundEvent)soundIn, (SoundCategory)category, (float)volume, (float)pitch);
        if (event.isCanceled() || event.getSound() == null) {
            return;
        }
        soundIn = event.getSound();
        category = event.getCategory();
        volume = event.getVolume();
        if (player == this.field_73037_M.field_71439_g) {
            this.func_184134_a(x, y, z, soundIn, category, volume, pitch, false);
        }
    }

    @Override
    public void func_217384_a(@Nullable PlayerEntity playerIn, Entity entityIn, SoundEvent eventIn, SoundCategory categoryIn, float volume, float pitch) {
        PlaySoundAtEntityEvent event = ForgeEventFactory.onPlaySoundAtEntity((Entity)playerIn, (SoundEvent)eventIn, (SoundCategory)categoryIn, (float)volume, (float)pitch);
        if (event.isCanceled() || event.getSound() == null) {
            return;
        }
        eventIn = event.getSound();
        categoryIn = event.getCategory();
        volume = event.getVolume();
        if (playerIn == this.field_73037_M.field_71439_g) {
            this.field_73037_M.func_147118_V().func_147682_a((ISound)new EntityTickableSound(eventIn, categoryIn, entityIn));
        }
    }

    public void func_184156_a(BlockPos pos, SoundEvent soundIn, SoundCategory category, float volume, float pitch, boolean distanceDelay) {
        this.func_184134_a((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, soundIn, category, volume, pitch, distanceDelay);
    }

    @Override
    public void func_184134_a(double x, double y, double z, SoundEvent soundIn, SoundCategory category, float volume, float pitch, boolean distanceDelay) {
        double d0 = this.field_73037_M.field_71460_t.func_215316_n().func_216785_c().func_186679_c(x, y, z);
        SimpleSound simplesound = new SimpleSound(soundIn, category, volume, pitch, x, y, z);
        if (distanceDelay && d0 > 100.0) {
            double d1 = Math.sqrt(d0) / 40.0;
            this.field_73037_M.func_147118_V().func_147681_a((ISound)simplesound, (int)(d1 * 20.0));
        } else {
            this.field_73037_M.func_147118_V().func_147682_a((ISound)simplesound);
        }
    }

    @Override
    public void func_92088_a(double x, double y, double z, double motionX, double motionY, double motionZ, @Nullable CompoundNBT compound) {
        this.field_73037_M.field_71452_i.func_78873_a((Particle)new FireworkParticle.Starter(this, x, y, z, motionX, motionY, motionZ, this.field_73037_M.field_71452_i, compound));
    }

    @Override
    public void func_184135_a(IPacket<?> packetIn) {
        this.field_73035_a.func_147297_a(packetIn);
    }

    @Override
    public RecipeManager func_199532_z() {
        return this.field_73035_a.func_199526_e();
    }

    public void func_96443_a(Scoreboard scoreboardIn) {
        this.field_200261_M = scoreboardIn;
    }

    public ITickList<Block> func_205220_G_() {
        return EmptyTickList.func_205388_a();
    }

    public ITickList<Fluid> func_205219_F_() {
        return EmptyTickList.func_205388_a();
    }

    public ClientChunkProvider func_72863_F() {
        return this.field_239129_E_;
    }

    @Override
    @Nullable
    public MapData func_217406_a(String mapName) {
        return this.field_217432_z.get(mapName);
    }

    @Override
    public void func_217399_a(MapData mapDataIn) {
        this.field_217432_z.put(mapDataIn.func_195925_e(), mapDataIn);
    }

    @Override
    public int func_217395_y() {
        return 0;
    }

    @Override
    public Scoreboard func_96441_U() {
        return this.field_200261_M;
    }

    @Override
    public NetworkTagManager func_205772_D() {
        return this.field_73035_a.func_199724_l();
    }

    @Override
    public void func_184138_a(BlockPos pos, BlockState oldState, BlockState newState, int flags) {
        this.field_217430_d.func_184376_a((IBlockReader)((Object)this), pos, oldState, newState, flags);
    }

    @Override
    public void func_225319_b(BlockPos blockPosIn, BlockState oldState, BlockState newState) {
        this.field_217430_d.func_224746_a(blockPosIn, oldState, newState);
    }

    public void func_217427_b(int sectionX, int sectionY, int sectionZ) {
        this.field_217430_d.func_215321_a(sectionX, sectionY, sectionZ);
    }

    @Override
    public void func_175715_c(int breakerId, BlockPos pos, int progress) {
        this.field_217430_d.func_180441_b(breakerId, pos, progress);
    }

    @Override
    public void func_175669_a(int id, BlockPos pos, int data) {
        this.field_217430_d.func_180440_a(id, pos, data);
    }

    public void func_217378_a(@Nullable PlayerEntity player, int type, BlockPos pos, int data) {
        try {
            this.field_217430_d.func_180439_a(player, type, pos, data);
        }
        catch (Throwable throwable) {
            CrashReport crashreport = CrashReport.func_85055_a(throwable, "Playing level event");
            CrashReportCategory crashreportcategory = crashreport.func_85058_a("Level event being played");
            crashreportcategory.func_71507_a("Block coordinates", CrashReportCategory.func_180522_a(pos));
            crashreportcategory.func_71507_a("Event source", (Object)player);
            crashreportcategory.func_71507_a("Event type", type);
            crashreportcategory.func_71507_a("Event data", data);
            throw new ReportedException(crashreport);
        }
    }

    @Override
    public void func_195594_a(IParticleData particleData, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
        this.field_217430_d.func_195461_a(particleData, particleData.func_197554_b().func_197575_f(), x, y, z, xSpeed, ySpeed, zSpeed);
    }

    @Override
    public void func_195590_a(IParticleData particleData, boolean forceAlwaysRender, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
        this.field_217430_d.func_195461_a(particleData, particleData.func_197554_b().func_197575_f() || forceAlwaysRender, x, y, z, xSpeed, ySpeed, zSpeed);
    }

    @Override
    public void func_195589_b(IParticleData particleData, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
        this.field_217430_d.func_195462_a(particleData, false, true, x, y, z, xSpeed, ySpeed, zSpeed);
    }

    @Override
    public void func_217404_b(IParticleData particleData, boolean ignoreRange, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
        this.field_217430_d.func_195462_a(particleData, particleData.func_197554_b().func_197575_f() || ignoreRange, true, x, y, z, xSpeed, ySpeed, zSpeed);
    }

    public List<AbstractClientPlayerEntity> func_217369_A() {
        return this.field_217431_w;
    }

    public Biome func_225604_a_(int x, int y, int z) {
        return Biomes.field_76772_c;
    }

    public float func_228326_g_(float partialTicks) {
        float f = this.func_72826_c(partialTicks);
        float f1 = 1.0f - (MathHelper.func_76134_b((float)(f * ((float)Math.PI * 2))) * 2.0f + 0.2f);
        f1 = MathHelper.func_76131_a((float)f1, (float)0.0f, (float)1.0f);
        f1 = 1.0f - f1;
        f1 = (float)((double)f1 * (1.0 - (double)(this.func_72867_j(partialTicks) * 5.0f) / 16.0));
        f1 = (float)((double)f1 * (1.0 - (double)(this.func_72819_i(partialTicks) * 5.0f) / 16.0));
        return f1 * 0.8f + 0.2f;
    }

    public Vector3d func_228318_a_(BlockPos blockPosIn, float partialTicks) {
        float f9;
        float f = this.func_72826_c(partialTicks);
        float f1 = MathHelper.func_76134_b((float)(f * ((float)Math.PI * 2))) * 2.0f + 0.5f;
        f1 = MathHelper.func_76131_a((float)f1, (float)0.0f, (float)1.0f);
        Biome biome = this.func_226691_t_(blockPosIn);
        int i = biome.func_225529_c_();
        float f2 = (float)(i >> 16 & 0xFF) / 255.0f;
        float f3 = (float)(i >> 8 & 0xFF) / 255.0f;
        float f4 = (float)(i & 0xFF) / 255.0f;
        f2 *= f1;
        f3 *= f1;
        f4 *= f1;
        float f5 = this.func_72867_j(partialTicks);
        if (f5 > 0.0f) {
            float f6 = (f2 * 0.3f + f3 * 0.59f + f4 * 0.11f) * 0.6f;
            float f7 = 1.0f - f5 * 0.75f;
            f2 = f2 * f7 + f6 * (1.0f - f7);
            f3 = f3 * f7 + f6 * (1.0f - f7);
            f4 = f4 * f7 + f6 * (1.0f - f7);
        }
        if ((f9 = this.func_72819_i(partialTicks)) > 0.0f) {
            float f10 = (f2 * 0.3f + f3 * 0.59f + f4 * 0.11f) * 0.2f;
            float f8 = 1.0f - f9 * 0.75f;
            f2 = f2 * f8 + f10 * (1.0f - f8);
            f3 = f3 * f8 + f10 * (1.0f - f8);
            f4 = f4 * f8 + f10 * (1.0f - f8);
        }
        if (this.field_228314_A_ > 0) {
            float f11 = (float)this.field_228314_A_ - partialTicks;
            if (f11 > 1.0f) {
                f11 = 1.0f;
            }
            f2 = f2 * (1.0f - (f11 *= 0.45f)) + 0.8f * f11;
            f3 = f3 * (1.0f - f11) + 0.8f * f11;
            f4 = f4 * (1.0f - f11) + 1.0f * f11;
        }
        return new Vector3d(f2, f3, f4);
    }

    public Vector3d func_228328_h_(float partialTicks) {
        float f = this.func_72826_c(partialTicks);
        float f1 = MathHelper.func_76134_b((float)(f * ((float)Math.PI * 2))) * 2.0f + 0.5f;
        f1 = MathHelper.func_76131_a((float)f1, (float)0.0f, (float)1.0f);
        float f2 = 1.0f;
        float f3 = 1.0f;
        float f4 = 1.0f;
        float f5 = this.func_72867_j(partialTicks);
        if (f5 > 0.0f) {
            float f6 = (f2 * 0.3f + f3 * 0.59f + f4 * 0.11f) * 0.6f;
            float f7 = 1.0f - f5 * 0.95f;
            f2 = f2 * f7 + f6 * (1.0f - f7);
            f3 = f3 * f7 + f6 * (1.0f - f7);
            f4 = f4 * f7 + f6 * (1.0f - f7);
        }
        f2 *= f1 * 0.9f + 0.1f;
        f3 *= f1 * 0.9f + 0.1f;
        f4 *= f1 * 0.85f + 0.15f;
        float f9 = this.func_72819_i(partialTicks);
        if (f9 > 0.0f) {
            float f10 = (f2 * 0.3f + f3 * 0.59f + f4 * 0.11f) * 0.2f;
            float f8 = 1.0f - f9 * 0.95f;
            f2 = f2 * f8 + f10 * (1.0f - f8);
            f3 = f3 * f8 + f10 * (1.0f - f8);
            f4 = f4 * f8 + f10 * (1.0f - f8);
        }
        return new Vector3d(f2, f3, f4);
    }

    public float func_228330_j_(float partialTicks) {
        float f = this.func_72826_c(partialTicks);
        float f1 = 1.0f - (MathHelper.func_76134_b((float)(f * ((float)Math.PI * 2))) * 2.0f + 0.25f);
        f1 = MathHelper.func_76131_a((float)f1, (float)0.0f, (float)1.0f);
        return f1 * f1 * 0.5f;
    }

    public int func_228332_n_() {
        return this.field_228314_A_;
    }

    @Override
    public void func_225605_c_(int timeFlashIn) {
        this.field_228314_A_ = timeFlashIn;
    }

    public float func_230487_a_(Direction p_230487_1_, boolean p_230487_2_) {
        boolean flag = this.func_239132_a_().func_239217_c_();
        if (!p_230487_2_) {
            return flag ? 0.9f : 1.0f;
        }
        switch (p_230487_1_) {
            case DOWN: {
                return flag ? 0.9f : 0.5f;
            }
            case UP: {
                return flag ? 0.9f : 1.0f;
            }
            case NORTH: 
            case SOUTH: {
                return 0.8f;
            }
            case WEST: 
            case EAST: {
                return 0.6f;
            }
        }
        return 1.0f;
    }

    public int func_225525_a_(BlockPos blockPosIn, ColorResolver colorResolverIn) {
        ColorCache colorcache = (ColorCache)this.field_228315_B_.get((Object)colorResolverIn);
        return colorcache.func_228071_a_(blockPosIn, () -> this.func_228321_b_(blockPosIn, colorResolverIn));
    }

    public int func_228321_b_(BlockPos blockPosIn, ColorResolver colorResolverIn) {
        int i = Minecraft.func_71410_x().field_71474_y.field_205217_U;
        if (i == 0) {
            return colorResolverIn.getColor(this.func_226691_t_(blockPosIn), (double)blockPosIn.func_177958_n(), (double)blockPosIn.func_177952_p());
        }
        int j = (i * 2 + 1) * (i * 2 + 1);
        int k = 0;
        int l = 0;
        int i1 = 0;
        CubeCoordinateIterator cubecoordinateiterator = new CubeCoordinateIterator(blockPosIn.func_177958_n() - i, blockPosIn.func_177956_o(), blockPosIn.func_177952_p() - i, blockPosIn.func_177958_n() + i, blockPosIn.func_177956_o(), blockPosIn.func_177952_p() + i);
        BlockPos.Mutable blockpos$mutable = new BlockPos.Mutable();
        while (cubecoordinateiterator.func_218301_a()) {
            blockpos$mutable.func_181079_c(cubecoordinateiterator.func_218304_b(), cubecoordinateiterator.func_218302_c(), cubecoordinateiterator.func_218303_d());
            int j1 = colorResolverIn.getColor(this.func_226691_t_((BlockPos)blockpos$mutable), (double)blockpos$mutable.func_177958_n(), (double)blockpos$mutable.func_177952_p());
            k += (j1 & 0xFF0000) >> 16;
            l += (j1 & 0xFF00) >> 8;
            i1 += j1 & 0xFF;
        }
        return (k / j & 0xFF) << 16 | (l / j & 0xFF) << 8 | i1 / j & 0xFF;
    }

    public BlockPos func_239140_u_() {
        BlockPos blockpos = new BlockPos(this.field_72986_A.func_76079_c(), this.field_72986_A.func_76075_d(), this.field_72986_A.func_76074_e());
        if (!this.func_175723_af().func_177746_a(blockpos)) {
            blockpos = this.func_205770_a(Heightmap.Type.MOTION_BLOCKING, new BlockPos(this.func_175723_af().func_230316_a_(), 0.0, this.func_175723_af().func_230317_b_()));
        }
        return blockpos;
    }

    public void func_239136_a_(BlockPos p_239136_1_) {
        this.field_72986_A.func_176143_a(p_239136_1_);
    }

    public String toString() {
        return "ClientLevel";
    }

    public ClientWorldInfo func_72912_H() {
        return this.field_239130_d_;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class ClientWorldInfo
    implements ISpawnWorldInfo {
        private final boolean field_239144_a_;
        private final GameRules field_239145_b_;
        private final boolean field_239146_c_;
        private int field_239147_d_;
        private int field_239148_e_;
        private int field_239149_f_;
        private long field_239150_g_;
        private long field_239151_h_;
        private boolean field_239152_i_;
        private Difficulty field_239153_j_;
        private boolean field_239154_k_;

        public ClientWorldInfo(Difficulty p_i232338_1_, boolean p_i232338_2_, boolean p_i232338_3_) {
            this.field_239153_j_ = p_i232338_1_;
            this.field_239144_a_ = p_i232338_2_;
            this.field_239146_c_ = p_i232338_3_;
            this.field_239145_b_ = new GameRules();
        }

        public int func_76079_c() {
            return this.field_239147_d_;
        }

        public int func_76075_d() {
            return this.field_239148_e_;
        }

        public int func_76074_e() {
            return this.field_239149_f_;
        }

        public long func_82573_f() {
            return this.field_239150_g_;
        }

        public long func_76073_f() {
            return this.field_239151_h_;
        }

        public void func_76058_a(int x) {
            this.field_239147_d_ = x;
        }

        public void func_76056_b(int y) {
            this.field_239148_e_ = y;
        }

        public void func_76087_c(int z) {
            this.field_239149_f_ = z;
        }

        public void func_239155_a_(long p_239155_1_) {
            this.field_239150_g_ = p_239155_1_;
        }

        public void func_239158_b_(long p_239158_1_) {
            this.field_239151_h_ = p_239158_1_;
        }

        public void func_176143_a(BlockPos spawnPoint) {
            this.field_239147_d_ = spawnPoint.func_177958_n();
            this.field_239148_e_ = spawnPoint.func_177956_o();
            this.field_239149_f_ = spawnPoint.func_177952_p();
        }

        public boolean func_76061_m() {
            return false;
        }

        public boolean func_76059_o() {
            return this.field_239152_i_;
        }

        public void func_76084_b(boolean isRaining) {
            this.field_239152_i_ = isRaining;
        }

        public boolean func_76093_s() {
            return this.field_239144_a_;
        }

        public GameRules func_82574_x() {
            return this.field_239145_b_;
        }

        public Difficulty func_176130_y() {
            return this.field_239153_j_;
        }

        public boolean func_176123_z() {
            return this.field_239154_k_;
        }

        public void func_85118_a(CrashReportCategory category) {
            super.func_85118_a(category);
        }

        public void func_239156_a_(Difficulty p_239156_1_) {
            this.field_239153_j_ = p_239156_1_;
        }

        public void func_239157_a_(boolean p_239157_1_) {
            this.field_239154_k_ = p_239157_1_;
        }

        public double func_239159_f_() {
            return this.field_239146_c_ ? 0.0 : 63.0;
        }

        public double func_239160_g_() {
            return this.field_239146_c_ ? 1.0 : 0.03125;
        }
    }
}

