/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.resources;

import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.resources.ReloadListener;
import net.minecraft.profiler.IProfiler;
import net.minecraft.resources.IResource;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class JsonReloadListener
extends ReloadListener<Map<ResourceLocation, JsonElement>> {
    private static final Logger field_223380_a = LogManager.getLogger();
    private static final int field_223381_b = ".json".length();
    private final Gson field_223382_c;
    private final String field_223383_d;

    public JsonReloadListener(Gson p_i51536_1_, String p_i51536_2_) {
        this.field_223382_c = p_i51536_1_;
        this.field_223383_d = p_i51536_2_;
    }

    protected Map<ResourceLocation, JsonElement> func_212854_a_(IResourceManager resourceManagerIn, IProfiler profilerIn) {
        HashMap map = Maps.newHashMap();
        int i = this.field_223383_d.length() + 1;
        for (ResourceLocation resourcelocation : resourceManagerIn.func_199003_a(this.field_223383_d, p_223379_0_ -> p_223379_0_.endsWith(".json"))) {
            String s = resourcelocation.func_110623_a();
            ResourceLocation resourcelocation1 = new ResourceLocation(resourcelocation.func_110624_b(), s.substring(i, s.length() - field_223381_b));
            try {
                IResource iresource = resourceManagerIn.func_199002_a(resourcelocation);
                Throwable throwable = null;
                try {
                    InputStream inputstream = iresource.func_199027_b();
                    Throwable throwable2 = null;
                    try {
                        BufferedReader reader = new BufferedReader(new InputStreamReader(inputstream, StandardCharsets.UTF_8));
                        Throwable throwable3 = null;
                        try {
                            JsonElement jsonelement = (JsonElement)JSONUtils.func_193839_a((Gson)this.field_223382_c, (Reader)reader, JsonElement.class);
                            if (jsonelement != null) {
                                JsonElement jsonelement1 = map.put(resourcelocation1, jsonelement);
                                if (jsonelement1 == null) continue;
                                throw new IllegalStateException("Duplicate data file ignored with ID " + resourcelocation1);
                            }
                            field_223380_a.error("Couldn't load data file {} from {} as it's null or empty", (Object)resourcelocation1, (Object)resourcelocation);
                        }
                        catch (Throwable throwable4) {
                            throwable3 = throwable4;
                            throw throwable4;
                        }
                        finally {
                            if (reader == null) continue;
                            if (throwable3 != null) {
                                try {
                                    ((Reader)reader).close();
                                }
                                catch (Throwable throwable5) {
                                    throwable3.addSuppressed(throwable5);
                                }
                                continue;
                            }
                            ((Reader)reader).close();
                        }
                    }
                    catch (Throwable throwable6) {
                        throwable2 = throwable6;
                        throw throwable6;
                    }
                    finally {
                        if (inputstream == null) continue;
                        if (throwable2 != null) {
                            try {
                                inputstream.close();
                            }
                            catch (Throwable throwable7) {
                                throwable2.addSuppressed(throwable7);
                            }
                            continue;
                        }
                        inputstream.close();
                    }
                }
                catch (Throwable throwable8) {
                    throwable = throwable8;
                    throw throwable8;
                }
                finally {
                    if (iresource == null) continue;
                    if (throwable != null) {
                        try {
                            iresource.close();
                        }
                        catch (Throwable throwable9) {
                            throwable.addSuppressed(throwable9);
                        }
                        continue;
                    }
                    iresource.close();
                }
            }
            catch (JsonParseException | IOException | IllegalArgumentException jsonparseexception) {
                field_223380_a.error("Couldn't parse data file {} from {}", (Object)resourcelocation1, (Object)resourcelocation, (Object)jsonparseexception);
            }
        }
        return map;
    }

    protected ResourceLocation getPreparedPath(ResourceLocation rl) {
        return new ResourceLocation(rl.func_110624_b(), this.field_223383_d + "/" + rl.func_110623_a() + ".json");
    }
}

