/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.model;

import javax.annotation.Nullable;
import net.minecraft.client.renderer.FaceDirection;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.BlockFaceUV;
import net.minecraft.client.renderer.model.BlockPartFace;
import net.minecraft.client.renderer.model.BlockPartRotation;
import net.minecraft.client.renderer.model.IModelTransform;
import net.minecraft.client.renderer.model.UVTransformationUtil;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Matrix3f;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraft.util.math.vector.TransformationMatrix;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.math.vector.Vector4f;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.ForgeHooksClient;

@OnlyIn(value=Dist.CLIENT)
public class FaceBakery {
    private static final float field_178418_a = 1.0f / (float)Math.cos(0.3926991f) - 1.0f;
    private static final float field_178417_b = 1.0f / (float)Math.cos(0.7853981852531433) - 1.0f;

    public BakedQuad func_228824_a_(Vector3f posFrom, Vector3f posTo, BlockPartFace face, TextureAtlasSprite sprite, Direction facing, IModelTransform transformIn, @Nullable BlockPartRotation partRotation, boolean shade, ResourceLocation modelLocationIn) {
        BlockFaceUV blockfaceuv = face.field_178243_e;
        if (transformIn.func_188049_c()) {
            blockfaceuv = FaceBakery.func_228821_a_(face.field_178243_e, facing, transformIn.func_225615_b_(), modelLocationIn);
        }
        float[] afloat = new float[blockfaceuv.field_178351_a.length];
        System.arraycopy(blockfaceuv.field_178351_a, 0, afloat, 0, afloat.length);
        float f = sprite.func_229242_p_();
        float f1 = (blockfaceuv.field_178351_a[0] + blockfaceuv.field_178351_a[0] + blockfaceuv.field_178351_a[2] + blockfaceuv.field_178351_a[2]) / 4.0f;
        float f2 = (blockfaceuv.field_178351_a[1] + blockfaceuv.field_178351_a[1] + blockfaceuv.field_178351_a[3] + blockfaceuv.field_178351_a[3]) / 4.0f;
        blockfaceuv.field_178351_a[0] = MathHelper.func_219799_g((float)f, (float)blockfaceuv.field_178351_a[0], (float)f1);
        blockfaceuv.field_178351_a[2] = MathHelper.func_219799_g((float)f, (float)blockfaceuv.field_178351_a[2], (float)f1);
        blockfaceuv.field_178351_a[1] = MathHelper.func_219799_g((float)f, (float)blockfaceuv.field_178351_a[1], (float)f2);
        blockfaceuv.field_178351_a[3] = MathHelper.func_219799_g((float)f, (float)blockfaceuv.field_178351_a[3], (float)f2);
        int[] aint = this.func_228820_a_(blockfaceuv, sprite, facing, this.func_199337_a(posFrom, posTo), transformIn.func_225615_b_(), partRotation, shade);
        Direction direction = FaceBakery.func_178410_a(aint);
        System.arraycopy(afloat, 0, blockfaceuv.field_178351_a, 0, afloat.length);
        if (partRotation == null) {
            this.func_178408_a(aint, direction);
        }
        ForgeHooksClient.fillNormal((int[])aint, (Direction)direction);
        return new BakedQuad(aint, face.field_178245_c, direction, sprite, shade);
    }

    public static BlockFaceUV func_228821_a_(BlockFaceUV blockFaceUVIn, Direction facing, TransformationMatrix modelRotationIn, ResourceLocation modelLocationIn) {
        float f11;
        float f10;
        float f9;
        float f8;
        Matrix4f matrix4f = UVTransformationUtil.func_229380_a_((TransformationMatrix)modelRotationIn, (Direction)facing, () -> "Unable to resolve UVLock for model: " + modelLocationIn).func_227988_c_();
        float f = blockFaceUVIn.func_178348_a(blockFaceUVIn.func_178345_c(0));
        float f1 = blockFaceUVIn.func_178346_b(blockFaceUVIn.func_178345_c(0));
        Vector4f vector4f = new Vector4f(f / 16.0f, f1 / 16.0f, 0.0f, 1.0f);
        vector4f.func_229372_a_(matrix4f);
        float f2 = 16.0f * vector4f.func_195910_a();
        float f3 = 16.0f * vector4f.func_195913_b();
        float f4 = blockFaceUVIn.func_178348_a(blockFaceUVIn.func_178345_c(2));
        float f5 = blockFaceUVIn.func_178346_b(blockFaceUVIn.func_178345_c(2));
        Vector4f vector4f1 = new Vector4f(f4 / 16.0f, f5 / 16.0f, 0.0f, 1.0f);
        vector4f1.func_229372_a_(matrix4f);
        float f6 = 16.0f * vector4f1.func_195910_a();
        float f7 = 16.0f * vector4f1.func_195913_b();
        if (Math.signum(f4 - f) == Math.signum(f6 - f2)) {
            f8 = f2;
            f9 = f6;
        } else {
            f8 = f6;
            f9 = f2;
        }
        if (Math.signum(f5 - f1) == Math.signum(f7 - f3)) {
            f10 = f3;
            f11 = f7;
        } else {
            f10 = f7;
            f11 = f3;
        }
        float f12 = (float)Math.toRadians(blockFaceUVIn.field_178350_b);
        Vector3f vector3f = new Vector3f(MathHelper.func_76134_b((float)f12), MathHelper.func_76126_a((float)f12), 0.0f);
        Matrix3f matrix3f = new Matrix3f(matrix4f);
        vector3f.func_229188_a_(matrix3f);
        int i = Math.floorMod(-((int)Math.round(Math.toDegrees(Math.atan2(vector3f.func_195900_b(), vector3f.func_195899_a())) / 90.0)) * 90, 360);
        return new BlockFaceUV(new float[]{f8, f10, f9, f11}, i);
    }

    private int[] func_228820_a_(BlockFaceUV uvs, TextureAtlasSprite sprite, Direction orientation, float[] posDiv16, TransformationMatrix rotationIn, @Nullable BlockPartRotation partRotation, boolean shade) {
        int[] aint = new int[32];
        for (int i = 0; i < 4; ++i) {
            this.func_228827_a_(aint, i, orientation, uvs, posDiv16, sprite, rotationIn, partRotation, shade);
        }
        return aint;
    }

    private float[] func_199337_a(Vector3f pos1, Vector3f pos2) {
        float[] afloat = new float[Direction.values().length];
        afloat[FaceDirection.Constants.field_179176_f] = pos1.func_195899_a() / 16.0f;
        afloat[FaceDirection.Constants.field_179178_e] = pos1.func_195900_b() / 16.0f;
        afloat[FaceDirection.Constants.field_179177_d] = pos1.func_195902_c() / 16.0f;
        afloat[FaceDirection.Constants.field_179180_c] = pos2.func_195899_a() / 16.0f;
        afloat[FaceDirection.Constants.field_179179_b] = pos2.func_195900_b() / 16.0f;
        afloat[FaceDirection.Constants.field_179181_a] = pos2.func_195902_c() / 16.0f;
        return afloat;
    }

    private void func_228827_a_(int[] vertexData, int vertexIndex, Direction facing, BlockFaceUV blockFaceUVIn, float[] posDiv16, TextureAtlasSprite sprite, TransformationMatrix rotationIn, @Nullable BlockPartRotation partRotation, boolean shade) {
        FaceDirection.VertexInformation facedirection$vertexinformation = FaceDirection.func_179027_a((Direction)facing).func_179025_a(vertexIndex);
        Vector3f vector3f = new Vector3f(posDiv16[facedirection$vertexinformation.field_179184_a], posDiv16[facedirection$vertexinformation.field_179182_b], posDiv16[facedirection$vertexinformation.field_179183_c]);
        this.func_199336_a(vector3f, partRotation);
        this.func_228822_a_(vector3f, rotationIn);
        this.func_239288_a_(vertexData, vertexIndex, vector3f, sprite, blockFaceUVIn);
    }

    private void func_239288_a_(int[] p_239288_1_, int p_239288_2_, Vector3f p_239288_3_, TextureAtlasSprite p_239288_4_, BlockFaceUV p_239288_5_) {
        int i = p_239288_2_ * 8;
        p_239288_1_[i] = Float.floatToRawIntBits(p_239288_3_.func_195899_a());
        p_239288_1_[i + 1] = Float.floatToRawIntBits(p_239288_3_.func_195900_b());
        p_239288_1_[i + 2] = Float.floatToRawIntBits(p_239288_3_.func_195902_c());
        p_239288_1_[i + 3] = -1;
        p_239288_1_[i + 4] = Float.floatToRawIntBits(p_239288_4_.func_94214_a((double)p_239288_5_.func_178348_a(p_239288_2_) * 0.999 + (double)p_239288_5_.func_178348_a((p_239288_2_ + 2) % 4) * 0.001));
        p_239288_1_[i + 4 + 1] = Float.floatToRawIntBits(p_239288_4_.func_94207_b((double)p_239288_5_.func_178346_b(p_239288_2_) * 0.999 + (double)p_239288_5_.func_178346_b((p_239288_2_ + 2) % 4) * 0.001));
    }

    private void func_199336_a(Vector3f vec, @Nullable BlockPartRotation partRotation) {
        if (partRotation != null) {
            Vector3f vector3f1;
            Vector3f vector3f;
            switch (partRotation.field_178342_b) {
                case X: {
                    vector3f = new Vector3f(1.0f, 0.0f, 0.0f);
                    vector3f1 = new Vector3f(0.0f, 1.0f, 1.0f);
                    break;
                }
                case Y: {
                    vector3f = new Vector3f(0.0f, 1.0f, 0.0f);
                    vector3f1 = new Vector3f(1.0f, 0.0f, 1.0f);
                    break;
                }
                case Z: {
                    vector3f = new Vector3f(0.0f, 0.0f, 1.0f);
                    vector3f1 = new Vector3f(1.0f, 1.0f, 0.0f);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("There are only 3 axes");
                }
            }
            Quaternion quaternion = new Quaternion(vector3f, partRotation.field_178343_c, true);
            if (partRotation.field_178341_d) {
                if (Math.abs(partRotation.field_178343_c) == 22.5f) {
                    vector3f1.func_195898_a(field_178418_a);
                } else {
                    vector3f1.func_195898_a(field_178417_b);
                }
                vector3f1.func_195904_b(1.0f, 1.0f, 1.0f);
            } else {
                vector3f1.func_195905_a(1.0f, 1.0f, 1.0f);
            }
            this.func_228823_a_(vec, partRotation.field_178344_a.func_229195_e_(), new Matrix4f(quaternion), vector3f1);
        }
    }

    public void func_228822_a_(Vector3f posIn, TransformationMatrix transformIn) {
        if (transformIn != TransformationMatrix.func_227983_a_()) {
            this.func_228823_a_(posIn, new Vector3f(0.5f, 0.5f, 0.5f), transformIn.func_227988_c_(), new Vector3f(1.0f, 1.0f, 1.0f));
        }
    }

    private void func_228823_a_(Vector3f posIn, Vector3f originIn, Matrix4f transformIn, Vector3f scaleIn) {
        Vector4f vector4f = new Vector4f(posIn.func_195899_a() - originIn.func_195899_a(), posIn.func_195900_b() - originIn.func_195900_b(), posIn.func_195902_c() - originIn.func_195902_c(), 1.0f);
        vector4f.func_229372_a_(transformIn);
        vector4f.func_195909_a(scaleIn);
        posIn.func_195905_a(vector4f.func_195910_a() + originIn.func_195899_a(), vector4f.func_195913_b() + originIn.func_195900_b(), vector4f.func_195914_c() + originIn.func_195902_c());
    }

    public static Direction func_178410_a(int[] faceData) {
        Vector3f vector3f = new Vector3f(Float.intBitsToFloat(faceData[0]), Float.intBitsToFloat(faceData[1]), Float.intBitsToFloat(faceData[2]));
        Vector3f vector3f1 = new Vector3f(Float.intBitsToFloat(faceData[8]), Float.intBitsToFloat(faceData[9]), Float.intBitsToFloat(faceData[10]));
        Vector3f vector3f2 = new Vector3f(Float.intBitsToFloat(faceData[16]), Float.intBitsToFloat(faceData[17]), Float.intBitsToFloat(faceData[18]));
        Vector3f vector3f3 = vector3f.func_229195_e_();
        vector3f3.func_195897_a(vector3f1);
        Vector3f vector3f4 = vector3f2.func_229195_e_();
        vector3f4.func_195897_a(vector3f1);
        Vector3f vector3f5 = vector3f4.func_229195_e_();
        vector3f5.func_195896_c(vector3f3);
        vector3f5.func_229194_d_();
        Direction direction = null;
        float f = 0.0f;
        for (Direction direction1 : Direction.values()) {
            Vector3i vector3i = direction1.func_176730_m();
            Vector3f vector3f6 = new Vector3f(vector3i.func_177958_n(), vector3i.func_177956_o(), vector3i.func_177952_p());
            float f1 = vector3f5.func_195903_b(vector3f6);
            if (!(f1 >= 0.0f) || !(f1 > f)) continue;
            f = f1;
            direction = direction1;
        }
        return direction == null ? Direction.UP : direction;
    }

    private void func_178408_a(int[] vertexData, Direction directionIn) {
        int[] aint = new int[vertexData.length];
        System.arraycopy(vertexData, 0, aint, 0, vertexData.length);
        float[] afloat = new float[Direction.values().length];
        afloat[FaceDirection.Constants.field_179176_f] = 999.0f;
        afloat[FaceDirection.Constants.field_179178_e] = 999.0f;
        afloat[FaceDirection.Constants.field_179177_d] = 999.0f;
        afloat[FaceDirection.Constants.field_179180_c] = -999.0f;
        afloat[FaceDirection.Constants.field_179179_b] = -999.0f;
        afloat[FaceDirection.Constants.field_179181_a] = -999.0f;
        for (int i = 0; i < 4; ++i) {
            int j = 8 * i;
            float f = Float.intBitsToFloat(aint[j]);
            float f1 = Float.intBitsToFloat(aint[j + 1]);
            float f2 = Float.intBitsToFloat(aint[j + 2]);
            if (f < afloat[FaceDirection.Constants.field_179176_f]) {
                afloat[FaceDirection.Constants.field_179176_f] = f;
            }
            if (f1 < afloat[FaceDirection.Constants.field_179178_e]) {
                afloat[FaceDirection.Constants.field_179178_e] = f1;
            }
            if (f2 < afloat[FaceDirection.Constants.field_179177_d]) {
                afloat[FaceDirection.Constants.field_179177_d] = f2;
            }
            if (f > afloat[FaceDirection.Constants.field_179180_c]) {
                afloat[FaceDirection.Constants.field_179180_c] = f;
            }
            if (f1 > afloat[FaceDirection.Constants.field_179179_b]) {
                afloat[FaceDirection.Constants.field_179179_b] = f1;
            }
            if (!(f2 > afloat[FaceDirection.Constants.field_179181_a])) continue;
            afloat[FaceDirection.Constants.field_179181_a] = f2;
        }
        FaceDirection facedirection = FaceDirection.func_179027_a((Direction)directionIn);
        for (int i1 = 0; i1 < 4; ++i1) {
            int j1 = 8 * i1;
            FaceDirection.VertexInformation facedirection$vertexinformation = facedirection.func_179025_a(i1);
            float f8 = afloat[facedirection$vertexinformation.field_179184_a];
            float f3 = afloat[facedirection$vertexinformation.field_179182_b];
            float f4 = afloat[facedirection$vertexinformation.field_179183_c];
            vertexData[j1] = Float.floatToRawIntBits(f8);
            vertexData[j1 + 1] = Float.floatToRawIntBits(f3);
            vertexData[j1 + 2] = Float.floatToRawIntBits(f4);
            for (int k = 0; k < 4; ++k) {
                int l = 8 * k;
                float f5 = Float.intBitsToFloat(aint[l]);
                float f6 = Float.intBitsToFloat(aint[l + 1]);
                float f7 = Float.intBitsToFloat(aint[l + 2]);
                if (!MathHelper.func_180185_a((float)f8, (float)f5) || !MathHelper.func_180185_a((float)f3, (float)f6) || !MathHelper.func_180185_a((float)f4, (float)f7)) continue;
                vertexData[j1 + 4] = aint[l + 4];
                vertexData[j1 + 4 + 1] = aint[l + 4 + 1];
            }
        }
    }
}

