/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.entity;

import com.mojang.blaze3d.matrix.MatrixStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.culling.ClippingHelper;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.world.LightType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderNameplateEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

@OnlyIn(value=Dist.CLIENT)
public abstract class EntityRenderer<T extends Entity> {
    protected final EntityRendererManager field_76990_c;
    protected float field_76989_e;
    protected float field_76987_f = 1.0f;

    protected EntityRenderer(EntityRendererManager renderManager) {
        this.field_76990_c = renderManager;
    }

    public final int func_229100_c_(T entityIn, float partialTicks) {
        BlockPos blockpos = new BlockPos(((Entity)((Object)entityIn)).func_174824_e(partialTicks));
        return LightTexture.func_228451_a_(this.func_225624_a_(entityIn, blockpos), this.func_239381_b_(entityIn, blockpos));
    }

    protected int func_239381_b_(T p_239381_1_, BlockPos p_239381_2_) {
        return ((Entity)((Object)p_239381_1_)).field_70170_p.func_226658_a_(LightType.SKY, p_239381_2_);
    }

    protected int func_225624_a_(T entityIn, BlockPos partialTicks) {
        return ((Entity)((Object)entityIn)).func_70027_ad() ? 15 : ((Entity)((Object)entityIn)).field_70170_p.func_226658_a_(LightType.BLOCK, partialTicks);
    }

    public boolean func_225626_a_(T livingEntityIn, ClippingHelper camera, double camX, double camY, double camZ) {
        if (!((Entity)((Object)livingEntityIn)).func_145770_h(camX, camY, camZ)) {
            return false;
        }
        if (((Entity)((Object)livingEntityIn)).field_70158_ak) {
            return true;
        }
        AxisAlignedBB axisalignedbb = ((Entity)((Object)livingEntityIn)).func_184177_bl().func_186662_g(0.5);
        if (axisalignedbb.func_181656_b() || axisalignedbb.func_72320_b() == 0.0) {
            axisalignedbb = new AxisAlignedBB(((Entity)((Object)livingEntityIn)).func_226277_ct_() - 2.0, ((Entity)((Object)livingEntityIn)).func_226278_cu_() - 2.0, ((Entity)((Object)livingEntityIn)).func_226281_cx_() - 2.0, ((Entity)((Object)livingEntityIn)).func_226277_ct_() + 2.0, ((Entity)((Object)livingEntityIn)).func_226278_cu_() + 2.0, ((Entity)((Object)livingEntityIn)).func_226281_cx_() + 2.0);
        }
        return camera.func_228957_a_(axisalignedbb);
    }

    public Vector3d func_225627_b_(T entityIn, float partialTicks) {
        return Vector3d.field_186680_a;
    }

    public void func_225623_a_(T entityIn, float entityYaw, float partialTicks, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn) {
        RenderNameplateEvent renderNameplateEvent = new RenderNameplateEvent(entityIn, ((Entity)((Object)entityIn)).func_145748_c_(), this, matrixStackIn, bufferIn, packedLightIn);
        MinecraftForge.EVENT_BUS.post((Event)renderNameplateEvent);
        if (renderNameplateEvent.getResult() != Event.Result.DENY && (renderNameplateEvent.getResult() == Event.Result.ALLOW || this.func_177070_b(entityIn))) {
            this.func_225629_a_(entityIn, renderNameplateEvent.getContent(), matrixStackIn, bufferIn, packedLightIn);
        }
    }

    protected boolean func_177070_b(T entity) {
        return ((Entity)((Object)entity)).func_94059_bO() && ((Entity)((Object)entity)).func_145818_k_();
    }

    public abstract ResourceLocation func_110775_a(T var1);

    public FontRenderer func_76983_a() {
        return this.field_76990_c.func_78716_a();
    }

    protected void func_225629_a_(T entityIn, ITextComponent displayNameIn, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn) {
        double d0 = this.field_76990_c.func_229099_b_((Entity)((Object)entityIn));
        if (!(d0 > 4096.0)) {
            boolean flag = !((Entity)((Object)entityIn)).func_226273_bm_();
            float f = ((Entity)((Object)entityIn)).func_213302_cg() + 0.5f;
            int i = "deadmau5".equals(displayNameIn.getString()) ? -10 : 0;
            matrixStackIn.func_227860_a_();
            matrixStackIn.func_227861_a_(0.0, (double)f, 0.0);
            matrixStackIn.func_227863_a_(this.field_76990_c.func_229098_b_());
            matrixStackIn.func_227862_a_(-0.025f, -0.025f, 0.025f);
            Matrix4f matrix4f = matrixStackIn.func_227866_c_().func_227870_a_();
            float f1 = Minecraft.func_71410_x().field_71474_y.func_216840_a(0.25f);
            int j = (int)(f1 * 255.0f) << 24;
            FontRenderer fontrenderer = this.func_76983_a();
            float f2 = -fontrenderer.func_238414_a_((ITextProperties)displayNameIn) / 2;
            fontrenderer.func_238416_a_((ITextProperties)displayNameIn, f2, (float)i, 0x20FFFFFF, false, matrix4f, bufferIn, flag, j, packedLightIn);
            if (flag) {
                fontrenderer.func_238416_a_((ITextProperties)displayNameIn, f2, (float)i, -1, false, matrix4f, bufferIn, false, 0, packedLightIn);
            }
            matrixStackIn.func_227865_b_();
        }
    }

    public EntityRendererManager func_177068_d() {
        return this.field_76990_c;
    }
}

