/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Queues;
import com.google.common.collect.Sets;
import com.google.gson.JsonSyntaxException;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import com.mojang.blaze3d.vertex.MatrixApplyingVertexBuilder;
import com.mojang.blaze3d.vertex.VertexBuilderUtils;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import it.unimi.dsi.fastutil.objects.ObjectList;
import it.unimi.dsi.fastutil.objects.ObjectListIterator;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.SortedSet;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.CampfireBlock;
import net.minecraft.block.ComposterBlock;
import net.minecraft.block.SoundType;
import net.minecraft.client.AbstractOption;
import net.minecraft.client.GameSettings;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SimpleSound;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.Atlases;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.DestroyBlockProgress;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.OutlineLayerBuffer;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.RenderState;
import net.minecraft.client.renderer.RenderTimeManager;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeBuffers;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.ViewFrustum;
import net.minecraft.client.renderer.WorldVertexBufferUploader;
import net.minecraft.client.renderer.chunk.ChunkRenderDispatcher;
import net.minecraft.client.renderer.culling.ClippingHelper;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.model.ModelBakery;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexBuffer;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.settings.CloudOption;
import net.minecraft.client.settings.GraphicsFanciness;
import net.minecraft.client.settings.ParticleStatus;
import net.minecraft.client.shader.Framebuffer;
import net.minecraft.client.shader.ShaderGroup;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.client.world.DimensionRenderInfo;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.crash.ICrashReportDetail;
import net.minecraft.crash.ReportedException;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.item.BoneMealItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.MusicDiscItem;
import net.minecraft.particles.BasicParticleType;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ItemParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.profiler.IProfiler;
import net.minecraft.resources.IResourceManager;
import net.minecraft.resources.IResourceManagerReloadListener;
import net.minecraft.tags.FluidTags;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.Util;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Tuple3d;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.math.vector.Vector4f;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.LightType;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.border.WorldBorder;
import net.minecraft.world.gen.Heightmap;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.common.ForgeConfig;
import net.minecraftforge.resource.IResourceType;
import net.minecraftforge.resource.VanillaResourceType;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public class WorldRenderer
implements IResourceManagerReloadListener,
AutoCloseable {
    private static final Logger field_147599_m = LogManager.getLogger();
    private static final ResourceLocation field_110927_h = new ResourceLocation("textures/environment/moon_phases.png");
    private static final ResourceLocation field_110928_i = new ResourceLocation("textures/environment/sun.png");
    private static final ResourceLocation field_110925_j = new ResourceLocation("textures/environment/clouds.png");
    private static final ResourceLocation field_110926_k = new ResourceLocation("textures/environment/end_sky.png");
    private static final ResourceLocation field_175006_g = new ResourceLocation("textures/misc/forcefield.png");
    private static final ResourceLocation field_228413_h_ = new ResourceLocation("textures/environment/rain.png");
    private static final ResourceLocation field_228414_i_ = new ResourceLocation("textures/environment/snow.png");
    public static final Direction[] field_200006_a = Direction.values();
    private final Minecraft field_72777_q;
    private final TextureManager field_72770_i;
    private final EntityRendererManager field_175010_j;
    private final RenderTypeBuffers field_228415_m_;
    private ClientWorld field_72769_h;
    private Set<ChunkRenderDispatcher.ChunkRender> field_175009_l = Sets.newLinkedHashSet();
    private final ObjectList<LocalRenderInformationContainer> field_72755_R = new ObjectArrayList(69696);
    private final Set<TileEntity> field_181024_n = Sets.newHashSet();
    private ViewFrustum field_175008_n;
    private final VertexFormat field_175014_r = DefaultVertexFormats.field_181705_e;
    @Nullable
    private VertexBuffer field_175013_s;
    @Nullable
    private VertexBuffer field_175012_t;
    @Nullable
    private VertexBuffer field_175011_u;
    private boolean field_204607_y = true;
    @Nullable
    private VertexBuffer field_204601_A;
    private final RenderTimeManager field_228416_y_ = new RenderTimeManager(100);
    private int field_72773_u;
    private final Int2ObjectMap<DestroyBlockProgress> field_72738_E = new Int2ObjectOpenHashMap();
    private final Long2ObjectMap<SortedSet<DestroyBlockProgress>> field_228407_B_ = new Long2ObjectOpenHashMap();
    private final Map<BlockPos, ISound> field_147593_P = Maps.newHashMap();
    @Nullable
    private Framebuffer field_175015_z;
    @Nullable
    private ShaderGroup field_174991_A;
    @Nullable
    private Framebuffer field_239222_F_;
    @Nullable
    private Framebuffer field_239223_G_;
    @Nullable
    private Framebuffer field_239224_H_;
    @Nullable
    private Framebuffer field_239225_I_;
    @Nullable
    private Framebuffer field_239226_J_;
    @Nullable
    private ShaderGroup field_239227_K_;
    private double field_174992_B = Double.MIN_VALUE;
    private double field_174993_C = Double.MIN_VALUE;
    private double field_174987_D = Double.MIN_VALUE;
    private int field_174988_E = Integer.MIN_VALUE;
    private int field_174989_F = Integer.MIN_VALUE;
    private int field_174990_G = Integer.MIN_VALUE;
    private double field_174997_H = Double.MIN_VALUE;
    private double field_174998_I = Double.MIN_VALUE;
    private double field_174999_J = Double.MIN_VALUE;
    private double field_175000_K = Double.MIN_VALUE;
    private double field_174994_L = Double.MIN_VALUE;
    private int field_204602_S = Integer.MIN_VALUE;
    private int field_204603_T = Integer.MIN_VALUE;
    private int field_204604_U = Integer.MIN_VALUE;
    private Vector3d field_204605_V = Vector3d.field_186680_a;
    private CloudOption field_204800_W;
    private ChunkRenderDispatcher field_174995_M;
    private final VertexFormat field_228408_W_ = DefaultVertexFormats.field_176600_a;
    private int field_72739_F = -1;
    private int field_72749_I;
    private int field_72750_J;
    private boolean field_175002_T;
    @Nullable
    private ClippingHelper field_175001_U;
    private final Vector4f[] field_175004_V = new Vector4f[8];
    private final Tuple3d field_175003_W = new Tuple3d(0.0, 0.0, 0.0);
    private double field_147596_f;
    private double field_147597_g;
    private double field_147602_h;
    private boolean field_147595_R = true;
    private int field_228409_ai_;
    private int field_228410_aj_;
    private final float[] field_228411_ak_ = new float[1024];
    private final float[] field_228412_al_ = new float[1024];

    public WorldRenderer(Minecraft mcIn, RenderTypeBuffers rainTimeBuffersIn) {
        this.field_72777_q = mcIn;
        this.field_175010_j = mcIn.func_175598_ae();
        this.field_228415_m_ = rainTimeBuffersIn;
        this.field_72770_i = mcIn.func_110434_K();
        for (int i = 0; i < 32; ++i) {
            for (int j = 0; j < 32; ++j) {
                float f = j - 16;
                float f1 = i - 16;
                float f2 = MathHelper.func_76129_c((float)(f * f + f1 * f1));
                this.field_228411_ak_[i << 5 | j] = -f1 / f2;
                this.field_228412_al_[i << 5 | j] = f / f2;
            }
        }
        this.func_174963_q();
        this.func_174980_p();
        this.func_174964_o();
    }

    private void func_228438_a_(LightTexture lightmapIn, float partialTicks, double xIn, double yIn, double zIn) {
        float f = this.field_72777_q.field_71441_e.func_72867_j(partialTicks);
        if (!(f <= 0.0f)) {
            lightmapIn.func_205109_c();
            ClientWorld world = this.field_72777_q.field_71441_e;
            int i = MathHelper.func_76128_c((double)xIn);
            int j = MathHelper.func_76128_c((double)yIn);
            int k = MathHelper.func_76128_c((double)zIn);
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder bufferbuilder = tessellator.func_178180_c();
            RenderSystem.enableAlphaTest();
            RenderSystem.disableCull();
            RenderSystem.normal3f((float)0.0f, (float)1.0f, (float)0.0f);
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            RenderSystem.defaultAlphaFunc();
            RenderSystem.enableDepthTest();
            int l = 5;
            if (Minecraft.func_71375_t()) {
                l = 10;
            }
            RenderSystem.depthMask((boolean)Minecraft.func_238218_y_());
            int i1 = -1;
            float f1 = (float)this.field_72773_u + partialTicks;
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            BlockPos.Mutable blockpos$mutable = new BlockPos.Mutable();
            for (int j1 = k - l; j1 <= k + l; ++j1) {
                for (int k1 = i - l; k1 <= i + l; ++k1) {
                    int l1 = (j1 - k + 16) * 32 + k1 - i + 16;
                    double d0 = (double)this.field_228411_ak_[l1] * 0.5;
                    double d1 = (double)this.field_228412_al_[l1] * 0.5;
                    blockpos$mutable.func_181079_c(k1, 0, j1);
                    Biome biome = world.func_226691_t_((BlockPos)blockpos$mutable);
                    if (biome.func_201851_b() == Biome.RainType.NONE) continue;
                    int i2 = world.func_205770_a(Heightmap.Type.MOTION_BLOCKING, (BlockPos)blockpos$mutable).func_177956_o();
                    int j2 = j - l;
                    int k2 = j + l;
                    if (j2 < i2) {
                        j2 = i2;
                    }
                    if (k2 < i2) {
                        k2 = i2;
                    }
                    int l2 = i2;
                    if (i2 < j) {
                        l2 = j;
                    }
                    if (j2 == k2) continue;
                    Random random = new Random(k1 * k1 * 3121 + k1 * 45238971 ^ j1 * j1 * 418711 + j1 * 13761);
                    blockpos$mutable.func_181079_c(k1, j2, j1);
                    float f2 = biome.func_225486_c((BlockPos)blockpos$mutable);
                    if (f2 >= 0.15f) {
                        if (i1 != 0) {
                            if (i1 >= 0) {
                                tessellator.func_78381_a();
                            }
                            i1 = 0;
                            this.field_72777_q.func_110434_K().func_110577_a(field_228413_h_);
                            bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181704_d);
                        }
                        int i3 = this.field_72773_u + k1 * k1 * 3121 + k1 * 45238971 + j1 * j1 * 418711 + j1 * 13761 & 0x1F;
                        float f3 = -((float)i3 + partialTicks) / 32.0f * (3.0f + random.nextFloat());
                        double d2 = (double)((float)k1 + 0.5f) - xIn;
                        double d4 = (double)((float)j1 + 0.5f) - zIn;
                        float f4 = MathHelper.func_76133_a((double)(d2 * d2 + d4 * d4)) / (float)l;
                        float f5 = ((1.0f - f4 * f4) * 0.5f + 0.5f) * f;
                        blockpos$mutable.func_181079_c(k1, l2, j1);
                        int j3 = WorldRenderer.func_228421_a_((IBlockDisplayReader)world, (BlockPos)blockpos$mutable);
                        bufferbuilder.func_225582_a_((double)k1 - xIn - d0 + 0.5, (double)k2 - yIn, (double)j1 - zIn - d1 + 0.5).func_225583_a_(0.0f, (float)j2 * 0.25f + f3).func_227885_a_(1.0f, 1.0f, 1.0f, f5).func_227886_a_(j3).func_181675_d();
                        bufferbuilder.func_225582_a_((double)k1 - xIn + d0 + 0.5, (double)k2 - yIn, (double)j1 - zIn + d1 + 0.5).func_225583_a_(1.0f, (float)j2 * 0.25f + f3).func_227885_a_(1.0f, 1.0f, 1.0f, f5).func_227886_a_(j3).func_181675_d();
                        bufferbuilder.func_225582_a_((double)k1 - xIn + d0 + 0.5, (double)j2 - yIn, (double)j1 - zIn + d1 + 0.5).func_225583_a_(1.0f, (float)k2 * 0.25f + f3).func_227885_a_(1.0f, 1.0f, 1.0f, f5).func_227886_a_(j3).func_181675_d();
                        bufferbuilder.func_225582_a_((double)k1 - xIn - d0 + 0.5, (double)j2 - yIn, (double)j1 - zIn - d1 + 0.5).func_225583_a_(0.0f, (float)k2 * 0.25f + f3).func_227885_a_(1.0f, 1.0f, 1.0f, f5).func_227886_a_(j3).func_181675_d();
                        continue;
                    }
                    if (i1 != 1) {
                        if (i1 >= 0) {
                            tessellator.func_78381_a();
                        }
                        i1 = 1;
                        this.field_72777_q.func_110434_K().func_110577_a(field_228414_i_);
                        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181704_d);
                    }
                    float f6 = -((float)(this.field_72773_u & 0x1FF) + partialTicks) / 512.0f;
                    float f7 = (float)(random.nextDouble() + (double)f1 * 0.01 * (double)((float)random.nextGaussian()));
                    float f8 = (float)(random.nextDouble() + (double)(f1 * (float)random.nextGaussian()) * 0.001);
                    double d3 = (double)((float)k1 + 0.5f) - xIn;
                    double d5 = (double)((float)j1 + 0.5f) - zIn;
                    float f9 = MathHelper.func_76133_a((double)(d3 * d3 + d5 * d5)) / (float)l;
                    float f10 = ((1.0f - f9 * f9) * 0.3f + 0.5f) * f;
                    blockpos$mutable.func_181079_c(k1, l2, j1);
                    int k3 = WorldRenderer.func_228421_a_((IBlockDisplayReader)world, (BlockPos)blockpos$mutable);
                    int l3 = k3 >> 16 & 0xFFFF;
                    int i4 = (k3 & 0xFFFF) * 3;
                    int j4 = (l3 * 3 + 240) / 4;
                    int k4 = (i4 * 3 + 240) / 4;
                    bufferbuilder.func_225582_a_((double)k1 - xIn - d0 + 0.5, (double)k2 - yIn, (double)j1 - zIn - d1 + 0.5).func_225583_a_(0.0f + f7, (float)j2 * 0.25f + f6 + f8).func_227885_a_(1.0f, 1.0f, 1.0f, f10).func_225587_b_(k4, j4).func_181675_d();
                    bufferbuilder.func_225582_a_((double)k1 - xIn + d0 + 0.5, (double)k2 - yIn, (double)j1 - zIn + d1 + 0.5).func_225583_a_(1.0f + f7, (float)j2 * 0.25f + f6 + f8).func_227885_a_(1.0f, 1.0f, 1.0f, f10).func_225587_b_(k4, j4).func_181675_d();
                    bufferbuilder.func_225582_a_((double)k1 - xIn + d0 + 0.5, (double)j2 - yIn, (double)j1 - zIn + d1 + 0.5).func_225583_a_(1.0f + f7, (float)k2 * 0.25f + f6 + f8).func_227885_a_(1.0f, 1.0f, 1.0f, f10).func_225587_b_(k4, j4).func_181675_d();
                    bufferbuilder.func_225582_a_((double)k1 - xIn - d0 + 0.5, (double)j2 - yIn, (double)j1 - zIn - d1 + 0.5).func_225583_a_(0.0f + f7, (float)k2 * 0.25f + f6 + f8).func_227885_a_(1.0f, 1.0f, 1.0f, f10).func_225587_b_(k4, j4).func_181675_d();
                }
            }
            if (i1 >= 0) {
                tessellator.func_78381_a();
            }
            RenderSystem.enableCull();
            RenderSystem.disableBlend();
            RenderSystem.defaultAlphaFunc();
            RenderSystem.disableAlphaTest();
            lightmapIn.func_205108_b();
        }
    }

    public void func_228436_a_(ActiveRenderInfo activeRenderInfoIn) {
        float f = this.field_72777_q.field_71441_e.func_72867_j(1.0f) / (Minecraft.func_71375_t() ? 1.0f : 2.0f);
        if (!(f <= 0.0f)) {
            Random random = new Random((long)this.field_72773_u * 312987231L);
            ClientWorld iworldreader = this.field_72777_q.field_71441_e;
            BlockPos blockpos = new BlockPos(activeRenderInfoIn.func_216785_c());
            BlockPos blockpos1 = null;
            int i = (int)(100.0f * f * f) / (this.field_72777_q.field_71474_y.field_74362_aa == ParticleStatus.DECREASED ? 2 : 1);
            for (int j = 0; j < i; ++j) {
                int k = random.nextInt(21) - 10;
                int l = random.nextInt(21) - 10;
                BlockPos blockpos2 = iworldreader.func_205770_a(Heightmap.Type.MOTION_BLOCKING, blockpos.func_177982_a(k, 0, l)).func_177977_b();
                Biome biome = iworldreader.func_226691_t_(blockpos2);
                if (blockpos2.func_177956_o() <= 0 || blockpos2.func_177956_o() > blockpos.func_177956_o() + 10 || blockpos2.func_177956_o() < blockpos.func_177956_o() - 10 || biome.func_201851_b() != Biome.RainType.RAIN || !(biome.func_225486_c(blockpos2) >= 0.15f)) continue;
                blockpos1 = blockpos2;
                if (this.field_72777_q.field_71474_y.field_74362_aa == ParticleStatus.MINIMAL) break;
                double d0 = random.nextDouble();
                double d1 = random.nextDouble();
                BlockState blockstate = iworldreader.func_180495_p(blockpos2);
                FluidState fluidstate = iworldreader.func_204610_c(blockpos2);
                VoxelShape voxelshape = blockstate.func_196952_d((IBlockReader)((Object)iworldreader), blockpos2);
                double d2 = voxelshape.func_197760_b(Direction.Axis.Y, d0, d1);
                double d3 = fluidstate.func_215679_a((IBlockReader)((Object)iworldreader), blockpos2);
                double d4 = Math.max(d2, d3);
                BasicParticleType iparticledata = !fluidstate.func_206884_a(FluidTags.field_206960_b) && !blockstate.func_203425_a(Blocks.field_196814_hQ) && !CampfireBlock.func_226915_i_(blockstate) ? ParticleTypes.field_197600_K : ParticleTypes.field_197601_L;
                this.field_72777_q.field_71441_e.func_195594_a((IParticleData)iparticledata, (double)blockpos2.func_177958_n() + d0, (double)blockpos2.func_177956_o() + d4, (double)blockpos2.func_177952_p() + d1, 0.0, 0.0, 0.0);
            }
            if (blockpos1 != null && random.nextInt(3) < this.field_228410_aj_++) {
                this.field_228410_aj_ = 0;
                if (blockpos1.func_177956_o() > blockpos.func_177956_o() + 1 && iworldreader.func_205770_a(Heightmap.Type.MOTION_BLOCKING, blockpos).func_177956_o() > MathHelper.func_76141_d((float)blockpos.func_177956_o())) {
                    this.field_72777_q.field_71441_e.func_184156_a(blockpos1, SoundEvents.field_187919_gs, SoundCategory.WEATHER, 0.1f, 0.5f, false);
                } else {
                    this.field_72777_q.field_71441_e.func_184156_a(blockpos1, SoundEvents.field_187918_gr, SoundCategory.WEATHER, 0.2f, 1.0f, false);
                }
            }
        }
    }

    @Override
    public void close() {
        if (this.field_174991_A != null) {
            this.field_174991_A.close();
        }
        if (this.field_239227_K_ != null) {
            this.field_239227_K_.close();
        }
    }

    @Override
    public void func_195410_a(IResourceManager resourceManager) {
        this.field_72770_i.func_110577_a(field_175006_g);
        RenderSystem.texParameter((int)3553, (int)10242, (int)10497);
        RenderSystem.texParameter((int)3553, (int)10243, (int)10497);
        RenderSystem.bindTexture((int)0);
        this.func_174966_b();
        if (Minecraft.func_238218_y_()) {
            this.func_239233_v_();
        }
    }

    public void func_174966_b() {
        if (this.field_174991_A != null) {
            this.field_174991_A.close();
        }
        ResourceLocation resourcelocation = new ResourceLocation("shaders/post/entity_outline.json");
        try {
            this.field_174991_A = new ShaderGroup(this.field_72777_q.func_110434_K(), this.field_72777_q.func_195551_G(), this.field_72777_q.func_147110_a(), resourcelocation);
            this.field_174991_A.func_148026_a(this.field_72777_q.func_228018_at_().func_198109_k(), this.field_72777_q.func_228018_at_().func_198091_l());
            this.field_175015_z = this.field_174991_A.func_177066_a("final");
        }
        catch (IOException ioexception) {
            field_147599_m.warn("Failed to load shader: {}", (Object)resourcelocation, (Object)ioexception);
            this.field_174991_A = null;
            this.field_175015_z = null;
        }
        catch (JsonSyntaxException jsonsyntaxexception) {
            field_147599_m.warn("Failed to parse shader: {}", (Object)resourcelocation, (Object)jsonsyntaxexception);
            this.field_174991_A = null;
            this.field_175015_z = null;
        }
    }

    private void func_239233_v_() {
        this.func_239234_w_();
        ResourceLocation resourcelocation = new ResourceLocation("shaders/post/transparency.json");
        try {
            ShaderGroup shadergroup = new ShaderGroup(this.field_72777_q.func_110434_K(), this.field_72777_q.func_195551_G(), this.field_72777_q.func_147110_a(), resourcelocation);
            shadergroup.func_148026_a(this.field_72777_q.func_228018_at_().func_198109_k(), this.field_72777_q.func_228018_at_().func_198091_l());
            Framebuffer framebuffer3 = shadergroup.func_177066_a("translucent");
            Framebuffer framebuffer4 = shadergroup.func_177066_a("itemEntity");
            Framebuffer framebuffer = shadergroup.func_177066_a("particles");
            Framebuffer framebuffer1 = shadergroup.func_177066_a("weather");
            Framebuffer framebuffer2 = shadergroup.func_177066_a("clouds");
            this.field_239227_K_ = shadergroup;
            this.field_239222_F_ = framebuffer3;
            this.field_239223_G_ = framebuffer4;
            this.field_239224_H_ = framebuffer;
            this.field_239225_I_ = framebuffer1;
            this.field_239226_J_ = framebuffer2;
        }
        catch (Exception exception) {
            String s = exception instanceof JsonSyntaxException ? "parse" : "load";
            GameSettings gamesettings = Minecraft.func_71410_x().field_71474_y;
            gamesettings.field_238330_f_ = GraphicsFanciness.FANCY;
            gamesettings.func_74303_b();
            throw new ShaderException("Failed to " + s + " shader: " + resourcelocation, exception);
        }
    }

    private void func_239234_w_() {
        if (this.field_239227_K_ != null) {
            this.field_239227_K_.close();
            this.field_239222_F_.func_147608_a();
            this.field_239223_G_.func_147608_a();
            this.field_239224_H_.func_147608_a();
            this.field_239225_I_.func_147608_a();
            this.field_239226_J_.func_147608_a();
            this.field_239227_K_ = null;
            this.field_239222_F_ = null;
            this.field_239223_G_ = null;
            this.field_239224_H_ = null;
            this.field_239225_I_ = null;
            this.field_239226_J_ = null;
        }
    }

    public void func_174975_c() {
        if (this.func_174985_d()) {
            RenderSystem.enableBlend();
            RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ZERO, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
            this.field_175015_z.func_178038_a(this.field_72777_q.func_228018_at_().func_198109_k(), this.field_72777_q.func_228018_at_().func_198091_l(), false);
            RenderSystem.disableBlend();
        }
    }

    protected boolean func_174985_d() {
        return this.field_175015_z != null && this.field_174991_A != null && this.field_72777_q.field_71439_g != null;
    }

    private void func_174964_o() {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        if (this.field_175011_u != null) {
            this.field_175011_u.close();
        }
        this.field_175011_u = new VertexBuffer(this.field_175014_r);
        this.func_174968_a(bufferbuilder, -16.0f, true);
        bufferbuilder.func_178977_d();
        this.field_175011_u.func_227875_a_(bufferbuilder);
    }

    private void func_174980_p() {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        if (this.field_175012_t != null) {
            this.field_175012_t.close();
        }
        this.field_175012_t = new VertexBuffer(this.field_175014_r);
        this.func_174968_a(bufferbuilder, 16.0f, false);
        bufferbuilder.func_178977_d();
        this.field_175012_t.func_227875_a_(bufferbuilder);
    }

    private void func_174968_a(BufferBuilder bufferBuilderIn, float posY, boolean reverseX) {
        int i = 64;
        int j = 6;
        bufferBuilderIn.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        for (int k = -384; k <= 384; k += 64) {
            for (int l = -384; l <= 384; l += 64) {
                float f = k;
                float f1 = k + 64;
                if (reverseX) {
                    f1 = k;
                    f = k + 64;
                }
                bufferBuilderIn.func_225582_a_(f, posY, l).func_181675_d();
                bufferBuilderIn.func_225582_a_(f1, posY, l).func_181675_d();
                bufferBuilderIn.func_225582_a_(f1, posY, l + 64).func_181675_d();
                bufferBuilderIn.func_225582_a_(f, posY, l + 64).func_181675_d();
            }
        }
    }

    private void func_174963_q() {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        if (this.field_175013_s != null) {
            this.field_175013_s.close();
        }
        this.field_175013_s = new VertexBuffer(this.field_175014_r);
        this.func_180444_a(bufferbuilder);
        bufferbuilder.func_178977_d();
        this.field_175013_s.func_227875_a_(bufferbuilder);
    }

    private void func_180444_a(BufferBuilder bufferBuilderIn) {
        Random random = new Random(10842L);
        bufferBuilderIn.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        for (int i = 0; i < 1500; ++i) {
            double d0 = random.nextFloat() * 2.0f - 1.0f;
            double d1 = random.nextFloat() * 2.0f - 1.0f;
            double d2 = random.nextFloat() * 2.0f - 1.0f;
            double d3 = 0.15f + random.nextFloat() * 0.1f;
            double d4 = d0 * d0 + d1 * d1 + d2 * d2;
            if (!(d4 < 1.0) || !(d4 > 0.01)) continue;
            d4 = 1.0 / Math.sqrt(d4);
            double d5 = (d0 *= d4) * 100.0;
            double d6 = (d1 *= d4) * 100.0;
            double d7 = (d2 *= d4) * 100.0;
            double d8 = Math.atan2(d0, d2);
            double d9 = Math.sin(d8);
            double d10 = Math.cos(d8);
            double d11 = Math.atan2(Math.sqrt(d0 * d0 + d2 * d2), d1);
            double d12 = Math.sin(d11);
            double d13 = Math.cos(d11);
            double d14 = random.nextDouble() * Math.PI * 2.0;
            double d15 = Math.sin(d14);
            double d16 = Math.cos(d14);
            for (int j = 0; j < 4; ++j) {
                double d17 = 0.0;
                double d18 = (double)((j & 2) - 1) * d3;
                double d19 = (double)((j + 1 & 2) - 1) * d3;
                double d20 = 0.0;
                double d21 = d18 * d16 - d19 * d15;
                double d22 = d19 * d16 + d18 * d15;
                double d23 = d21 * d12 + 0.0 * d13;
                double d24 = 0.0 * d12 - d21 * d13;
                double d25 = d24 * d9 - d22 * d10;
                double d26 = d22 * d9 + d24 * d10;
                bufferBuilderIn.func_225582_a_(d5 + d25, d6 + d23, d7 + d26).func_181675_d();
            }
        }
    }

    public void func_72732_a(@Nullable ClientWorld worldClientIn) {
        this.field_174992_B = Double.MIN_VALUE;
        this.field_174993_C = Double.MIN_VALUE;
        this.field_174987_D = Double.MIN_VALUE;
        this.field_174988_E = Integer.MIN_VALUE;
        this.field_174989_F = Integer.MIN_VALUE;
        this.field_174990_G = Integer.MIN_VALUE;
        this.field_175010_j.func_78717_a(worldClientIn);
        this.field_72769_h = worldClientIn;
        if (worldClientIn != null) {
            this.func_72712_a();
        } else {
            this.field_175009_l.clear();
            this.field_72755_R.clear();
            if (this.field_175008_n != null) {
                this.field_175008_n.func_178160_a();
                this.field_175008_n = null;
            }
            if (this.field_174995_M != null) {
                this.field_174995_M.func_188244_g();
            }
            this.field_174995_M = null;
            this.field_181024_n.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void func_72712_a() {
        if (this.field_72769_h != null) {
            Entity entity;
            if (Minecraft.func_238218_y_()) {
                this.func_239233_v_();
            } else {
                this.func_239234_w_();
            }
            this.field_72769_h.func_228327_h_();
            if (this.field_174995_M == null) {
                this.field_174995_M = new ChunkRenderDispatcher(this.field_72769_h, this, Util.func_215072_e(), this.field_72777_q.func_147111_S(), this.field_228415_m_.func_228484_a_());
            } else {
                this.field_174995_M.func_228895_a_(this.field_72769_h);
            }
            this.field_147595_R = true;
            this.field_204607_y = true;
            RenderTypeLookup.func_228393_a_(Minecraft.func_71375_t());
            this.field_72739_F = this.field_72777_q.field_71474_y.field_151451_c;
            if (this.field_175008_n != null) {
                this.field_175008_n.func_178160_a();
            }
            this.func_174986_e();
            Set<TileEntity> set = this.field_181024_n;
            synchronized (set) {
                this.field_181024_n.clear();
            }
            this.field_175008_n = new ViewFrustum(this.field_174995_M, (World)this.field_72769_h, this.field_72777_q.field_71474_y.field_151451_c, this);
            if (this.field_72769_h != null && (entity = this.field_72777_q.func_175606_aa()) != null) {
                this.field_175008_n.func_178163_a(entity.func_226277_ct_(), entity.func_226281_cx_());
            }
        }
    }

    protected void func_174986_e() {
        this.field_175009_l.clear();
        this.field_174995_M.func_178514_b();
    }

    public void func_72720_a(int width, int height) {
        this.func_174979_m();
        if (this.field_174991_A != null) {
            this.field_174991_A.func_148026_a(width, height);
        }
        if (this.field_239227_K_ != null) {
            this.field_239227_K_.func_148026_a(width, height);
        }
    }

    public String func_72735_c() {
        int i = this.field_175008_n.field_178164_f.length;
        int j = this.func_184382_g();
        return String.format("C: %d/%d %sD: %d, %s", j, i, this.field_72777_q.field_175612_E ? "(s) " : "", this.field_72739_F, this.field_174995_M == null ? "null" : this.field_174995_M.func_178504_a());
    }

    protected int func_184382_g() {
        int i = 0;
        for (LocalRenderInformationContainer worldrenderer$localrenderinformationcontainer : this.field_72755_R) {
            if (worldrenderer$localrenderinformationcontainer.field_178036_a.func_178571_g().func_178489_a()) continue;
            ++i;
        }
        return i;
    }

    public String func_72723_d() {
        return "E: " + this.field_72749_I + "/" + this.field_72769_h.func_217425_f() + ", B: " + this.field_72750_J;
    }

    private void func_228437_a_(ActiveRenderInfo activeRenderInfoIn, ClippingHelper camera, boolean debugCamera, int frameCount, boolean playerSpectator) {
        Vector3d vector3d = activeRenderInfoIn.func_216785_c();
        if (this.field_72777_q.field_71474_y.field_151451_c != this.field_72739_F) {
            this.func_72712_a();
        }
        this.field_72769_h.func_217381_Z().func_76320_a("camera");
        double d0 = this.field_72777_q.field_71439_g.func_226277_ct_() - this.field_174992_B;
        double d1 = this.field_72777_q.field_71439_g.func_226278_cu_() - this.field_174993_C;
        double d2 = this.field_72777_q.field_71439_g.func_226281_cx_() - this.field_174987_D;
        if (this.field_174988_E != this.field_72777_q.field_71439_g.field_70176_ah || this.field_174989_F != this.field_72777_q.field_71439_g.field_70162_ai || this.field_174990_G != this.field_72777_q.field_71439_g.field_70164_aj || d0 * d0 + d1 * d1 + d2 * d2 > 16.0) {
            this.field_174992_B = this.field_72777_q.field_71439_g.func_226277_ct_();
            this.field_174993_C = this.field_72777_q.field_71439_g.func_226278_cu_();
            this.field_174987_D = this.field_72777_q.field_71439_g.func_226281_cx_();
            this.field_174988_E = this.field_72777_q.field_71439_g.field_70176_ah;
            this.field_174989_F = this.field_72777_q.field_71439_g.field_70162_ai;
            this.field_174990_G = this.field_72777_q.field_71439_g.field_70164_aj;
            this.field_175008_n.func_178163_a(this.field_72777_q.field_71439_g.func_226277_ct_(), this.field_72777_q.field_71439_g.func_226281_cx_());
        }
        this.field_174995_M.func_217669_a(vector3d);
        this.field_72769_h.func_217381_Z().func_219895_b("cull");
        this.field_72777_q.func_213239_aq().func_219895_b("culling");
        BlockPos blockpos = activeRenderInfoIn.func_216780_d();
        ChunkRenderDispatcher.ChunkRender chunkrenderdispatcher$chunkrender = this.field_175008_n.func_178161_a(blockpos);
        int i = 16;
        BlockPos blockpos1 = new BlockPos(MathHelper.func_76128_c((double)(vector3d.field_72450_a / 16.0)) * 16, MathHelper.func_76128_c((double)(vector3d.field_72448_b / 16.0)) * 16, MathHelper.func_76128_c((double)(vector3d.field_72449_c / 16.0)) * 16);
        float f = activeRenderInfoIn.func_216777_e();
        float f1 = activeRenderInfoIn.func_216778_f();
        this.field_147595_R = this.field_147595_R || !this.field_175009_l.isEmpty() || vector3d.field_72450_a != this.field_174997_H || vector3d.field_72448_b != this.field_174998_I || vector3d.field_72449_c != this.field_174999_J || (double)f != this.field_175000_K || (double)f1 != this.field_174994_L;
        this.field_174997_H = vector3d.field_72450_a;
        this.field_174998_I = vector3d.field_72448_b;
        this.field_174999_J = vector3d.field_72449_c;
        this.field_175000_K = f;
        this.field_174994_L = f1;
        this.field_72777_q.func_213239_aq().func_219895_b("update");
        if (!debugCamera && this.field_147595_R) {
            this.field_147595_R = false;
            this.field_72755_R.clear();
            ArrayDeque queue = Queues.newArrayDeque();
            Entity.func_184227_b(MathHelper.func_151237_a((double)((double)this.field_72777_q.field_71474_y.field_151451_c / 8.0), (double)1.0, (double)2.5) * (double)this.field_72777_q.field_71474_y.field_238329_c_);
            boolean flag = this.field_72777_q.field_175612_E;
            if (chunkrenderdispatcher$chunkrender != null) {
                if (playerSpectator && this.field_72769_h.func_180495_p(blockpos).func_200015_d((IBlockReader)((Object)this.field_72769_h), blockpos)) {
                    flag = false;
                }
                chunkrenderdispatcher$chunkrender.func_178577_a(frameCount);
                queue.add(new LocalRenderInformationContainer(chunkrenderdispatcher$chunkrender, null, 0));
            } else {
                int j = blockpos.func_177956_o() > 0 ? 248 : 8;
                int k = MathHelper.func_76128_c((double)(vector3d.field_72450_a / 16.0)) * 16;
                int l = MathHelper.func_76128_c((double)(vector3d.field_72449_c / 16.0)) * 16;
                Direction[] list = Lists.newArrayList();
                for (int i1 = -this.field_72739_F; i1 <= this.field_72739_F; ++i1) {
                    for (int j1 = -this.field_72739_F; j1 <= this.field_72739_F; ++j1) {
                        ChunkRenderDispatcher.ChunkRender chunkrenderdispatcher$chunkrender1 = this.field_175008_n.func_178161_a(new BlockPos(k + (i1 << 4) + 8, j, l + (j1 << 4) + 8));
                        if (chunkrenderdispatcher$chunkrender1 == null || !camera.func_228957_a_(chunkrenderdispatcher$chunkrender1.field_178591_c)) continue;
                        chunkrenderdispatcher$chunkrender1.func_178577_a(frameCount);
                        list.add(new LocalRenderInformationContainer(chunkrenderdispatcher$chunkrender1, null, 0));
                    }
                }
                list.sort(Comparator.comparingDouble(p_230016_1_ -> blockpos.func_177951_i((Vector3i)((LocalRenderInformationContainer)p_230016_1_).field_178036_a.func_178568_j().func_177982_a(8, 8, 8))));
                queue.addAll(list);
            }
            this.field_72777_q.func_213239_aq().func_76320_a("iteration");
            while (!queue.isEmpty()) {
                LocalRenderInformationContainer worldrenderer$localrenderinformationcontainer1 = (LocalRenderInformationContainer)queue.poll();
                ChunkRenderDispatcher.ChunkRender chunkrenderdispatcher$chunkrender3 = worldrenderer$localrenderinformationcontainer1.field_178036_a;
                Direction direction = worldrenderer$localrenderinformationcontainer1.field_178034_b;
                this.field_72755_R.add((Object)worldrenderer$localrenderinformationcontainer1);
                for (Direction direction1 : field_200006_a) {
                    ChunkRenderDispatcher.ChunkRender chunkrenderdispatcher$chunkrender2 = this.func_181562_a(blockpos1, chunkrenderdispatcher$chunkrender3, direction1);
                    if (flag && worldrenderer$localrenderinformationcontainer1.func_189560_a(direction1.func_176734_d()) || flag && direction != null && !chunkrenderdispatcher$chunkrender3.func_178571_g().func_178495_a(direction.func_176734_d(), direction1) || chunkrenderdispatcher$chunkrender2 == null || !chunkrenderdispatcher$chunkrender2.func_217674_b() || !chunkrenderdispatcher$chunkrender2.func_178577_a(frameCount) || !camera.func_228957_a_(chunkrenderdispatcher$chunkrender2.field_178591_c)) continue;
                    LocalRenderInformationContainer worldrenderer$localrenderinformationcontainer = new LocalRenderInformationContainer(chunkrenderdispatcher$chunkrender2, direction1, worldrenderer$localrenderinformationcontainer1.field_178032_d + 1);
                    worldrenderer$localrenderinformationcontainer.func_189561_a(worldrenderer$localrenderinformationcontainer1.field_178035_c, direction1);
                    queue.add(worldrenderer$localrenderinformationcontainer);
                }
            }
            this.field_72777_q.func_213239_aq().func_76319_b();
        }
        this.field_72777_q.func_213239_aq().func_219895_b("rebuildNear");
        Set<ChunkRenderDispatcher.ChunkRender> set = this.field_175009_l;
        this.field_175009_l = Sets.newLinkedHashSet();
        for (LocalRenderInformationContainer worldrenderer$localrenderinformationcontainer2 : this.field_72755_R) {
            boolean flag1;
            ChunkRenderDispatcher.ChunkRender chunkrenderdispatcher$chunkrender4 = worldrenderer$localrenderinformationcontainer2.field_178036_a;
            if (!chunkrenderdispatcher$chunkrender4.func_178569_m() && !set.contains(chunkrenderdispatcher$chunkrender4)) continue;
            this.field_147595_R = true;
            BlockPos blockpos2 = chunkrenderdispatcher$chunkrender4.func_178568_j().func_177982_a(8, 8, 8);
            boolean bl = flag1 = blockpos2.func_177951_i((Vector3i)blockpos) < 768.0;
            if (((Boolean)ForgeConfig.CLIENT.alwaysSetupTerrainOffThread.get()).booleanValue() || !chunkrenderdispatcher$chunkrender4.func_188281_o() && !flag1) {
                this.field_175009_l.add(chunkrenderdispatcher$chunkrender4);
                continue;
            }
            this.field_72777_q.func_213239_aq().func_76320_a("build near");
            this.field_174995_M.func_228902_a_(chunkrenderdispatcher$chunkrender4);
            chunkrenderdispatcher$chunkrender4.func_188282_m();
            this.field_72777_q.func_213239_aq().func_76319_b();
        }
        this.field_175009_l.addAll(set);
        this.field_72777_q.func_213239_aq().func_76319_b();
    }

    @Nullable
    private ChunkRenderDispatcher.ChunkRender func_181562_a(BlockPos playerPos, ChunkRenderDispatcher.ChunkRender renderChunkBase, Direction facing) {
        BlockPos blockpos = renderChunkBase.func_181701_a(facing);
        if (MathHelper.func_76130_a((int)(playerPos.func_177958_n() - blockpos.func_177958_n())) > this.field_72739_F * 16) {
            return null;
        }
        if (blockpos.func_177956_o() >= 0 && blockpos.func_177956_o() < 256) {
            return MathHelper.func_76130_a((int)(playerPos.func_177952_p() - blockpos.func_177952_p())) > this.field_72739_F * 16 ? null : this.field_175008_n.func_178161_a(blockpos);
        }
        return null;
    }

    private void func_228419_a_(Matrix4f p_228419_1_, Matrix4f p_228419_2_, double p_228419_3_, double p_228419_5_, double p_228419_7_, ClippingHelper p_228419_9_) {
        this.field_175001_U = p_228419_9_;
        Matrix4f matrix4f = p_228419_2_.func_226601_d_();
        matrix4f.func_226595_a_(p_228419_1_);
        matrix4f.func_226600_c_();
        this.field_175003_W.field_181059_a = p_228419_3_;
        this.field_175003_W.field_181060_b = p_228419_5_;
        this.field_175003_W.field_181061_c = p_228419_7_;
        this.field_175004_V[0] = new Vector4f(-1.0f, -1.0f, -1.0f, 1.0f);
        this.field_175004_V[1] = new Vector4f(1.0f, -1.0f, -1.0f, 1.0f);
        this.field_175004_V[2] = new Vector4f(1.0f, 1.0f, -1.0f, 1.0f);
        this.field_175004_V[3] = new Vector4f(-1.0f, 1.0f, -1.0f, 1.0f);
        this.field_175004_V[4] = new Vector4f(-1.0f, -1.0f, 1.0f, 1.0f);
        this.field_175004_V[5] = new Vector4f(1.0f, -1.0f, 1.0f, 1.0f);
        this.field_175004_V[6] = new Vector4f(1.0f, 1.0f, 1.0f, 1.0f);
        this.field_175004_V[7] = new Vector4f(-1.0f, 1.0f, 1.0f, 1.0f);
        for (int i = 0; i < 8; ++i) {
            this.field_175004_V[i].func_229372_a_(matrix4f);
            this.field_175004_V[i].func_229375_f_();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void func_228426_a_(MatrixStack matrixStackIn, float partialTicks, long finishTimeNano, boolean drawBlockOutline, ActiveRenderInfo activeRenderInfoIn, GameRenderer gameRendererIn, LightTexture lightmapIn, Matrix4f projectionIn) {
        boolean flag1;
        ClippingHelper clippinghelper;
        boolean flag;
        TileEntityRendererDispatcher.field_147556_a.func_217665_a(this.field_72769_h, this.field_72777_q.func_110434_K(), this.field_72777_q.field_71466_p, activeRenderInfoIn, this.field_72777_q.field_71476_x);
        this.field_175010_j.func_229088_a_(this.field_72769_h, activeRenderInfoIn, this.field_72777_q.field_147125_j);
        IProfiler iprofiler = this.field_72769_h.func_217381_Z();
        iprofiler.func_219895_b("light_updates");
        this.field_72777_q.field_71441_e.func_72863_F().func_212863_j_().func_215575_a(Integer.MAX_VALUE, true, true);
        Vector3d vector3d = activeRenderInfoIn.func_216785_c();
        double d0 = vector3d.func_82615_a();
        double d1 = vector3d.func_82617_b();
        double d2 = vector3d.func_82616_c();
        Matrix4f matrix4f = matrixStackIn.func_227866_c_().func_227870_a_();
        iprofiler.func_219895_b("culling");
        boolean bl = flag = this.field_175001_U != null;
        if (flag) {
            clippinghelper = this.field_175001_U;
            clippinghelper.func_228952_a_(this.field_175003_W.field_181059_a, this.field_175003_W.field_181060_b, this.field_175003_W.field_181061_c);
        } else {
            clippinghelper = new ClippingHelper(matrix4f, projectionIn);
            clippinghelper.func_228952_a_(d0, d1, d2);
        }
        this.field_72777_q.func_213239_aq().func_219895_b("captureFrustum");
        if (this.field_175002_T) {
            this.func_228419_a_(matrix4f, projectionIn, vector3d.field_72450_a, vector3d.field_72448_b, vector3d.field_72449_c, flag ? new ClippingHelper(matrix4f, projectionIn) : clippinghelper);
            this.field_175002_T = false;
        }
        iprofiler.func_219895_b("clear");
        FogRenderer.func_228371_a_(activeRenderInfoIn, partialTicks, this.field_72777_q.field_71441_e, this.field_72777_q.field_71474_y.field_151451_c, gameRendererIn.func_205002_d(partialTicks));
        RenderSystem.clear((int)16640, (boolean)Minecraft.field_142025_a);
        float f = gameRendererIn.func_205001_m();
        boolean bl2 = flag1 = this.field_72777_q.field_71441_e.func_239132_a_().func_230493_a_(MathHelper.func_76128_c((double)d0), MathHelper.func_76128_c((double)d1)) || this.field_72777_q.field_71456_v.func_184046_j().func_184056_f();
        if (this.field_72777_q.field_71474_y.field_151451_c >= 4) {
            FogRenderer.setupFog(activeRenderInfoIn, FogRenderer.FogType.FOG_SKY, f, flag1, partialTicks);
            iprofiler.func_219895_b("sky");
            this.func_228424_a_(matrixStackIn, partialTicks);
        }
        iprofiler.func_219895_b("fog");
        FogRenderer.setupFog(activeRenderInfoIn, FogRenderer.FogType.FOG_TERRAIN, Math.max(f - 16.0f, 32.0f), flag1, partialTicks);
        iprofiler.func_219895_b("terrain_setup");
        this.func_228437_a_(activeRenderInfoIn, clippinghelper, flag, this.field_228409_ai_++, this.field_72777_q.field_71439_g.func_175149_v());
        iprofiler.func_219895_b("updatechunks");
        int i = 30;
        int j = this.field_72777_q.field_71474_y.field_74350_i;
        long k = 33333333L;
        long l = (double)j == AbstractOption.field_216701_h.func_216733_c() ? 0L : (long)(1000000000 / j);
        long i1 = Util.func_211178_c() - finishTimeNano;
        long j1 = this.field_228416_y_.func_228732_a_(i1);
        long k1 = j1 * 3L / 2L;
        long l1 = MathHelper.func_226163_a_((long)k1, (long)l, (long)33333333L);
        this.func_174967_a(finishTimeNano + l1);
        iprofiler.func_219895_b("terrain");
        this.func_228441_a_(RenderType.func_228639_c_(), matrixStackIn, d0, d1, d2);
        this.field_72777_q.func_209506_al().func_229356_a_(AtlasTexture.field_110575_b).setBlurMipmap(false, this.field_72777_q.field_71474_y.field_151442_I > 0);
        this.func_228441_a_(RenderType.func_228641_d_(), matrixStackIn, d0, d1, d2);
        this.field_72777_q.func_209506_al().func_229356_a_(AtlasTexture.field_110575_b).restoreLastBlurMipmap();
        this.func_228441_a_(RenderType.func_228643_e_(), matrixStackIn, d0, d1, d2);
        if (this.field_72769_h.func_239132_a_().func_239217_c_()) {
            RenderHelper.func_237533_a_((Matrix4f)matrixStackIn.func_227866_c_().func_227870_a_());
        } else {
            RenderHelper.func_227781_a_((Matrix4f)matrixStackIn.func_227866_c_().func_227870_a_());
        }
        iprofiler.func_219895_b("entities");
        iprofiler.func_76320_a("prepare");
        this.field_72749_I = 0;
        this.field_72750_J = 0;
        iprofiler.func_219895_b("entities");
        if (this.field_239223_G_ != null) {
            this.field_239223_G_.func_216493_b(Minecraft.field_142025_a);
            this.field_239223_G_.func_237506_a_(this.field_72777_q.func_147110_a());
            this.field_72777_q.func_147110_a().func_147610_a(false);
        }
        if (this.field_239225_I_ != null) {
            this.field_239225_I_.func_216493_b(Minecraft.field_142025_a);
        }
        if (this.func_174985_d()) {
            this.field_175015_z.func_216493_b(Minecraft.field_142025_a);
            this.field_72777_q.func_147110_a().func_147610_a(false);
        }
        boolean flag2 = false;
        IRenderTypeBuffer.Impl irendertypebuffer$impl = this.field_228415_m_.func_228487_b_();
        for (Entity entity : this.field_72769_h.func_217416_b()) {
            IRenderTypeBuffer.Impl irendertypebuffer;
            if (!this.field_175010_j.func_229086_a_(entity, clippinghelper, d0, d1, d2) && !entity.func_184215_y(this.field_72777_q.field_71439_g) || entity == activeRenderInfoIn.func_216773_g() && !activeRenderInfoIn.func_216770_i() && (!(activeRenderInfoIn.func_216773_g() instanceof LivingEntity) || !((LivingEntity)activeRenderInfoIn.func_216773_g()).func_70608_bn()) || entity instanceof ClientPlayerEntity && activeRenderInfoIn.func_216773_g() != entity) continue;
            ++this.field_72749_I;
            if (entity.field_70173_aa == 0) {
                entity.field_70142_S = entity.func_226277_ct_();
                entity.field_70137_T = entity.func_226278_cu_();
                entity.field_70136_U = entity.func_226281_cx_();
            }
            if (this.func_174985_d() && this.field_72777_q.func_238206_b_(entity)) {
                flag2 = true;
                OutlineLayerBuffer outlinelayerbuffer = this.field_228415_m_.func_228490_d_();
                irendertypebuffer = outlinelayerbuffer;
                int i2 = entity.func_226263_P_();
                int j2 = 255;
                int k2 = i2 >> 16 & 0xFF;
                int l2 = i2 >> 8 & 0xFF;
                int i3 = i2 & 0xFF;
                outlinelayerbuffer.func_228472_a_(k2, l2, i3, 255);
            } else {
                irendertypebuffer = irendertypebuffer$impl;
            }
            this.func_228418_a_(entity, d0, d1, d2, partialTicks, matrixStackIn, (IRenderTypeBuffer)irendertypebuffer);
        }
        this.func_228423_a_(matrixStackIn);
        irendertypebuffer$impl.func_228462_a_(RenderType.func_228634_a_((ResourceLocation)AtlasTexture.field_110575_b));
        irendertypebuffer$impl.func_228462_a_(RenderType.func_228638_b_((ResourceLocation)AtlasTexture.field_110575_b));
        irendertypebuffer$impl.func_228462_a_(RenderType.func_228640_c_((ResourceLocation)AtlasTexture.field_110575_b));
        irendertypebuffer$impl.func_228462_a_(RenderType.func_228646_f_((ResourceLocation)AtlasTexture.field_110575_b));
        iprofiler.func_219895_b("blockentities");
        for (Object worldrenderer$localrenderinformationcontainer : this.field_72755_R) {
            List<TileEntity> list = ((LocalRenderInformationContainer)worldrenderer$localrenderinformationcontainer).field_178036_a.func_178571_g().func_178485_b();
            if (list.isEmpty()) continue;
            for (TileEntity tileentity1 : list) {
                int j3;
                if (!clippinghelper.func_228957_a_(tileentity1.getRenderBoundingBox())) continue;
                BlockPos blockpos3 = tileentity1.func_174877_v();
                IRenderTypeBuffer.Impl irendertypebuffer1 = irendertypebuffer$impl;
                matrixStackIn.func_227860_a_();
                matrixStackIn.func_227861_a_((double)blockpos3.func_177958_n() - d0, (double)blockpos3.func_177956_o() - d1, (double)blockpos3.func_177952_p() - d2);
                SortedSet sortedset = (SortedSet)this.field_228407_B_.get(blockpos3.func_218275_a());
                if (sortedset != null && !sortedset.isEmpty() && (j3 = ((DestroyBlockProgress)sortedset.last()).func_73106_e()) >= 0) {
                    MatrixStack.Entry matrixstack$entry = matrixStackIn.func_227866_c_();
                    MatrixApplyingVertexBuilder ivertexbuilder = new MatrixApplyingVertexBuilder(this.field_228415_m_.func_228489_c_().getBuffer(ModelBakery.field_229320_k_.get(j3)), matrixstack$entry.func_227870_a_(), matrixstack$entry.func_227872_b_());
                    irendertypebuffer1 = arg_0 -> WorldRenderer.lambda$updateCameraAndRender$1(irendertypebuffer$impl, (IVertexBuilder)ivertexbuilder, arg_0);
                }
                TileEntityRendererDispatcher.field_147556_a.func_228850_a_(tileentity1, partialTicks, matrixStackIn, (IRenderTypeBuffer)irendertypebuffer1);
                matrixStackIn.func_227865_b_();
            }
        }
        Set<TileEntity> set = this.field_181024_n;
        synchronized (set) {
            for (TileEntity tileentity : this.field_181024_n) {
                if (!clippinghelper.func_228957_a_(tileentity.getRenderBoundingBox())) continue;
                BlockPos blockpos2 = tileentity.func_174877_v();
                matrixStackIn.func_227860_a_();
                matrixStackIn.func_227861_a_((double)blockpos2.func_177958_n() - d0, (double)blockpos2.func_177956_o() - d1, (double)blockpos2.func_177952_p() - d2);
                TileEntityRendererDispatcher.field_147556_a.func_228850_a_(tileentity, partialTicks, matrixStackIn, (IRenderTypeBuffer)irendertypebuffer$impl);
                matrixStackIn.func_227865_b_();
            }
        }
        this.func_228423_a_(matrixStackIn);
        irendertypebuffer$impl.func_228462_a_(RenderType.func_228639_c_());
        irendertypebuffer$impl.func_228462_a_(Atlases.func_228782_g_());
        irendertypebuffer$impl.func_228462_a_(Atlases.func_228783_h_());
        irendertypebuffer$impl.func_228462_a_(Atlases.func_228778_c_());
        irendertypebuffer$impl.func_228462_a_(Atlases.func_228779_d_());
        irendertypebuffer$impl.func_228462_a_(Atlases.func_228780_e_());
        irendertypebuffer$impl.func_228462_a_(Atlases.func_228781_f_());
        this.field_228415_m_.func_228490_d_().func_228471_a_();
        if (flag2) {
            this.field_174991_A.func_148018_a(partialTicks);
            this.field_72777_q.func_147110_a().func_147610_a(false);
        }
        iprofiler.func_219895_b("destroyProgress");
        for (Long2ObjectMap.Entry entry : this.field_228407_B_.long2ObjectEntrySet()) {
            SortedSet sortedset1;
            double d5;
            double d4;
            BlockPos blockpos1 = BlockPos.func_218283_e((long)entry.getLongKey());
            double d3 = (double)blockpos1.func_177958_n() - d0;
            if (d3 * d3 + (d4 = (double)blockpos1.func_177956_o() - d1) * d4 + (d5 = (double)blockpos1.func_177952_p() - d2) * d5 > 1024.0 || (sortedset1 = (SortedSet)entry.getValue()) == null || sortedset1.isEmpty()) continue;
            int k3 = ((DestroyBlockProgress)sortedset1.last()).func_73106_e();
            matrixStackIn.func_227860_a_();
            matrixStackIn.func_227861_a_((double)blockpos1.func_177958_n() - d0, (double)blockpos1.func_177956_o() - d1, (double)blockpos1.func_177952_p() - d2);
            MatrixStack.Entry matrixstack$entry1 = matrixStackIn.func_227866_c_();
            MatrixApplyingVertexBuilder ivertexbuilder1 = new MatrixApplyingVertexBuilder(this.field_228415_m_.func_228489_c_().getBuffer(ModelBakery.field_229320_k_.get(k3)), matrixstack$entry1.func_227870_a_(), matrixstack$entry1.func_227872_b_());
            this.field_72777_q.func_175602_ab().func_228792_a_(this.field_72769_h.func_180495_p(blockpos1), blockpos1, (IBlockDisplayReader)this.field_72769_h, matrixStackIn, (IVertexBuilder)ivertexbuilder1);
            matrixStackIn.func_227865_b_();
        }
        this.func_228423_a_(matrixStackIn);
        iprofiler.func_76319_b();
        RayTraceResult raytraceresult = this.field_72777_q.field_71476_x;
        if (drawBlockOutline && raytraceresult != null && raytraceresult.func_216346_c() == RayTraceResult.Type.BLOCK) {
            iprofiler.func_219895_b("outline");
            BlockPos blockpos = ((BlockRayTraceResult)raytraceresult).func_216350_a();
            BlockState blockstate = this.field_72769_h.func_180495_p(blockpos);
            if (!ForgeHooksClient.onDrawBlockHighlight((WorldRenderer)this, (ActiveRenderInfo)activeRenderInfoIn, (RayTraceResult)this.field_72777_q.field_71476_x, (float)partialTicks, (MatrixStack)matrixStackIn, (IRenderTypeBuffer)irendertypebuffer$impl) && !blockstate.isAir((IBlockReader)((Object)this.field_72769_h), blockpos) && this.field_72769_h.func_175723_af().func_177746_a(blockpos)) {
                IVertexBuilder ivertexbuilder2 = irendertypebuffer$impl.getBuffer(RenderType.func_228659_m_());
                this.func_228429_a_(matrixStackIn, ivertexbuilder2, activeRenderInfoIn.func_216773_g(), d0, d1, d2, blockpos, blockstate);
            }
        }
        RenderSystem.pushMatrix();
        RenderSystem.multMatrix((Matrix4f)matrixStackIn.func_227866_c_().func_227870_a_());
        this.field_72777_q.field_184132_p.func_229019_a_(matrixStackIn, irendertypebuffer$impl, d0, d1, d2);
        RenderSystem.popMatrix();
        irendertypebuffer$impl.func_228462_a_(Atlases.func_228785_j_());
        irendertypebuffer$impl.func_228462_a_(Atlases.func_228768_a_());
        irendertypebuffer$impl.func_228462_a_(Atlases.func_228776_b_());
        irendertypebuffer$impl.func_228462_a_(RenderType.func_239270_k_());
        irendertypebuffer$impl.func_228462_a_(RenderType.func_239271_l_());
        irendertypebuffer$impl.func_228462_a_(RenderType.func_228653_j_());
        irendertypebuffer$impl.func_228462_a_(RenderType.func_228655_k_());
        irendertypebuffer$impl.func_228462_a_(RenderType.func_228651_i_());
        this.field_228415_m_.func_228489_c_().func_228461_a_();
        irendertypebuffer$impl.func_228462_a_(RenderType.func_228659_m_());
        irendertypebuffer$impl.func_228461_a_();
        if (this.field_239227_K_ != null) {
            this.field_239222_F_.func_216493_b(Minecraft.field_142025_a);
            this.field_239222_F_.func_237506_a_(this.field_72777_q.func_147110_a());
            iprofiler.func_219895_b("translucent");
            this.func_228441_a_(RenderType.func_228645_f_(), matrixStackIn, d0, d1, d2);
            iprofiler.func_219895_b("string");
            this.func_228441_a_(RenderType.func_241715_r_(), matrixStackIn, d0, d1, d2);
            this.field_239224_H_.func_216493_b(Minecraft.field_142025_a);
            this.field_239224_H_.func_237506_a_(this.field_72777_q.func_147110_a());
            RenderState.field_239237_T_.func_228547_a_();
            iprofiler.func_219895_b("particles");
            this.field_72777_q.field_71452_i.func_228345_a_(matrixStackIn, irendertypebuffer$impl, lightmapIn, activeRenderInfoIn, partialTicks);
            RenderState.field_239237_T_.func_228549_b_();
        } else {
            iprofiler.func_219895_b("translucent");
            this.func_228441_a_(RenderType.func_228645_f_(), matrixStackIn, d0, d1, d2);
            iprofiler.func_219895_b("string");
            this.func_228441_a_(RenderType.func_241715_r_(), matrixStackIn, d0, d1, d2);
            iprofiler.func_219895_b("particles");
            this.field_72777_q.field_71452_i.func_228345_a_(matrixStackIn, irendertypebuffer$impl, lightmapIn, activeRenderInfoIn, partialTicks);
        }
        RenderSystem.pushMatrix();
        RenderSystem.multMatrix((Matrix4f)matrixStackIn.func_227866_c_().func_227870_a_());
        if (this.field_72777_q.field_71474_y.func_216842_e() != CloudOption.OFF) {
            if (this.field_239227_K_ != null) {
                this.field_239226_J_.func_216493_b(Minecraft.field_142025_a);
                RenderState.field_239239_V_.func_228547_a_();
                iprofiler.func_219895_b("clouds");
                this.func_228425_a_(matrixStackIn, partialTicks, d0, d1, d2);
                RenderState.field_239239_V_.func_228549_b_();
            } else {
                iprofiler.func_219895_b("clouds");
                this.func_228425_a_(matrixStackIn, partialTicks, d0, d1, d2);
            }
        }
        if (this.field_239227_K_ != null) {
            RenderState.field_239238_U_.func_228547_a_();
            iprofiler.func_219895_b("weather");
            this.func_228438_a_(lightmapIn, partialTicks, d0, d1, d2);
            this.func_228447_c_(activeRenderInfoIn);
            RenderState.field_239238_U_.func_228549_b_();
            this.field_239227_K_.func_148018_a(partialTicks);
            this.field_72777_q.func_147110_a().func_147610_a(false);
        } else {
            RenderSystem.depthMask((boolean)false);
            iprofiler.func_219895_b("weather");
            this.func_228438_a_(lightmapIn, partialTicks, d0, d1, d2);
            this.func_228447_c_(activeRenderInfoIn);
            RenderSystem.depthMask((boolean)true);
        }
        this.func_228446_b_(activeRenderInfoIn);
        RenderSystem.shadeModel((int)7424);
        RenderSystem.depthMask((boolean)true);
        RenderSystem.disableBlend();
        RenderSystem.popMatrix();
        FogRenderer.func_228370_a_();
    }

    private void func_228423_a_(MatrixStack matrixStackIn) {
        if (!matrixStackIn.func_227867_d_()) {
            throw new IllegalStateException("Pose stack not empty");
        }
    }

    private void func_228418_a_(Entity entityIn, double camX, double camY, double camZ, float partialTicks, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn) {
        double d0 = MathHelper.func_219803_d((double)partialTicks, (double)entityIn.field_70142_S, (double)entityIn.func_226277_ct_());
        double d1 = MathHelper.func_219803_d((double)partialTicks, (double)entityIn.field_70137_T, (double)entityIn.func_226278_cu_());
        double d2 = MathHelper.func_219803_d((double)partialTicks, (double)entityIn.field_70136_U, (double)entityIn.func_226281_cx_());
        float f = MathHelper.func_219799_g((float)partialTicks, (float)entityIn.field_70126_B, (float)entityIn.field_70177_z);
        this.field_175010_j.func_229084_a_(entityIn, d0 - camX, d1 - camY, d2 - camZ, f, partialTicks, matrixStackIn, bufferIn, this.field_175010_j.func_229085_a_(entityIn, partialTicks));
    }

    private void func_228441_a_(RenderType blockLayerIn, MatrixStack matrixStackIn, double xIn, double yIn, double zIn) {
        blockLayerIn.func_228547_a_();
        if (blockLayerIn == RenderType.func_228645_f_()) {
            this.field_72777_q.func_213239_aq().func_76320_a("translucent_sort");
            double d0 = xIn - this.field_147596_f;
            double d1 = yIn - this.field_147597_g;
            double d2 = zIn - this.field_147602_h;
            if (d0 * d0 + d1 * d1 + d2 * d2 > 1.0) {
                this.field_147596_f = xIn;
                this.field_147597_g = yIn;
                this.field_147602_h = zIn;
                int i = 0;
                for (LocalRenderInformationContainer worldrenderer$localrenderinformationcontainer : this.field_72755_R) {
                    if (i >= 15 || !worldrenderer$localrenderinformationcontainer.field_178036_a.func_228925_a_(blockLayerIn, this.field_174995_M)) continue;
                    ++i;
                }
            }
            this.field_72777_q.func_213239_aq().func_76319_b();
        }
        this.field_72777_q.func_213239_aq().func_76320_a("filterempty");
        this.field_72777_q.func_213239_aq().func_194339_b(() -> "render_" + blockLayerIn);
        boolean flag = blockLayerIn != RenderType.func_228645_f_();
        ObjectListIterator objectlistiterator = this.field_72755_R.listIterator(flag ? 0 : this.field_72755_R.size());
        while (!(!flag ? !objectlistiterator.hasPrevious() : !objectlistiterator.hasNext())) {
            LocalRenderInformationContainer worldrenderer$localrenderinformationcontainer1 = flag ? (LocalRenderInformationContainer)objectlistiterator.next() : (LocalRenderInformationContainer)objectlistiterator.previous();
            ChunkRenderDispatcher.ChunkRender chunkrenderdispatcher$chunkrender = worldrenderer$localrenderinformationcontainer1.field_178036_a;
            if (chunkrenderdispatcher$chunkrender.func_178571_g().func_228912_a_(blockLayerIn)) continue;
            VertexBuffer vertexbuffer = chunkrenderdispatcher$chunkrender.func_228924_a_(blockLayerIn);
            matrixStackIn.func_227860_a_();
            BlockPos blockpos = chunkrenderdispatcher$chunkrender.func_178568_j();
            matrixStackIn.func_227861_a_((double)blockpos.func_177958_n() - xIn, (double)blockpos.func_177956_o() - yIn, (double)blockpos.func_177952_p() - zIn);
            vertexbuffer.func_177359_a();
            this.field_228408_W_.func_227892_a_(0L);
            vertexbuffer.func_227874_a_(matrixStackIn.func_227866_c_().func_227870_a_(), 7);
            matrixStackIn.func_227865_b_();
        }
        VertexBuffer.func_177361_b();
        RenderSystem.clearCurrentColor();
        this.field_228408_W_.func_227895_d_();
        this.field_72777_q.func_213239_aq().func_76319_b();
        blockLayerIn.func_228549_b_();
    }

    private void func_228446_b_(ActiveRenderInfo activeRenderInfoIn) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        if (this.field_72777_q.field_228004_B_ || this.field_72777_q.field_228005_C_) {
            double d0 = activeRenderInfoIn.func_216785_c().func_82615_a();
            double d1 = activeRenderInfoIn.func_216785_c().func_82617_b();
            double d2 = activeRenderInfoIn.func_216785_c().func_82616_c();
            RenderSystem.depthMask((boolean)true);
            RenderSystem.disableCull();
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            RenderSystem.disableTexture();
            for (LocalRenderInformationContainer worldrenderer$localrenderinformationcontainer : this.field_72755_R) {
                ChunkRenderDispatcher.ChunkRender chunkrenderdispatcher$chunkrender = worldrenderer$localrenderinformationcontainer.field_178036_a;
                RenderSystem.pushMatrix();
                BlockPos blockpos = chunkrenderdispatcher$chunkrender.func_178568_j();
                RenderSystem.translated((double)((double)blockpos.func_177958_n() - d0), (double)((double)blockpos.func_177956_o() - d1), (double)((double)blockpos.func_177952_p() - d2));
                if (this.field_72777_q.field_228004_B_) {
                    bufferbuilder.func_181668_a(1, DefaultVertexFormats.field_181706_f);
                    RenderSystem.lineWidth((float)10.0f);
                    int i = worldrenderer$localrenderinformationcontainer.field_178032_d == 0 ? 0 : MathHelper.func_181758_c((float)((float)worldrenderer$localrenderinformationcontainer.field_178032_d / 50.0f), (float)0.9f, (float)0.9f);
                    int j = i >> 16 & 0xFF;
                    int k = i >> 8 & 0xFF;
                    int l = i & 0xFF;
                    Direction direction = worldrenderer$localrenderinformationcontainer.field_178034_b;
                    if (direction != null) {
                        bufferbuilder.func_225582_a_(8.0, 8.0, 8.0).func_225586_a_(j, k, l, 255).func_181675_d();
                        bufferbuilder.func_225582_a_(8 - 16 * direction.func_82601_c(), 8 - 16 * direction.func_96559_d(), 8 - 16 * direction.func_82599_e()).func_225586_a_(j, k, l, 255).func_181675_d();
                    }
                    tessellator.func_78381_a();
                    RenderSystem.lineWidth((float)1.0f);
                }
                if (this.field_72777_q.field_228005_C_ && !chunkrenderdispatcher$chunkrender.func_178571_g().func_178489_a()) {
                    bufferbuilder.func_181668_a(1, DefaultVertexFormats.field_181706_f);
                    RenderSystem.lineWidth((float)10.0f);
                    int i1 = 0;
                    for (Direction direction2 : field_200006_a) {
                        for (Direction direction1 : field_200006_a) {
                            boolean flag = chunkrenderdispatcher$chunkrender.func_178571_g().func_178495_a(direction2, direction1);
                            if (flag) continue;
                            ++i1;
                            bufferbuilder.func_225582_a_(8 + 8 * direction2.func_82601_c(), 8 + 8 * direction2.func_96559_d(), 8 + 8 * direction2.func_82599_e()).func_225586_a_(1, 0, 0, 1).func_181675_d();
                            bufferbuilder.func_225582_a_(8 + 8 * direction1.func_82601_c(), 8 + 8 * direction1.func_96559_d(), 8 + 8 * direction1.func_82599_e()).func_225586_a_(1, 0, 0, 1).func_181675_d();
                        }
                    }
                    tessellator.func_78381_a();
                    RenderSystem.lineWidth((float)1.0f);
                    if (i1 > 0) {
                        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181706_f);
                        float f = 0.5f;
                        float f1 = 0.2f;
                        bufferbuilder.func_225582_a_(0.5, 15.5, 0.5).func_227885_a_(0.9f, 0.9f, 0.0f, 0.2f).func_181675_d();
                        bufferbuilder.func_225582_a_(15.5, 15.5, 0.5).func_227885_a_(0.9f, 0.9f, 0.0f, 0.2f).func_181675_d();
                        bufferbuilder.func_225582_a_(15.5, 15.5, 15.5).func_227885_a_(0.9f, 0.9f, 0.0f, 0.2f).func_181675_d();
                        bufferbuilder.func_225582_a_(0.5, 15.5, 15.5).func_227885_a_(0.9f, 0.9f, 0.0f, 0.2f).func_181675_d();
                        bufferbuilder.func_225582_a_(0.5, 0.5, 15.5).func_227885_a_(0.9f, 0.9f, 0.0f, 0.2f).func_181675_d();
                        bufferbuilder.func_225582_a_(15.5, 0.5, 15.5).func_227885_a_(0.9f, 0.9f, 0.0f, 0.2f).func_181675_d();
                        bufferbuilder.func_225582_a_(15.5, 0.5, 0.5).func_227885_a_(0.9f, 0.9f, 0.0f, 0.2f).func_181675_d();
                        bufferbuilder.func_225582_a_(0.5, 0.5, 0.5).func_227885_a_(0.9f, 0.9f, 0.0f, 0.2f).func_181675_d();
                        bufferbuilder.func_225582_a_(0.5, 15.5, 0.5).func_227885_a_(0.9f, 0.9f, 0.0f, 0.2f).func_181675_d();
                        bufferbuilder.func_225582_a_(0.5, 15.5, 15.5).func_227885_a_(0.9f, 0.9f, 0.0f, 0.2f).func_181675_d();
                        bufferbuilder.func_225582_a_(0.5, 0.5, 15.5).func_227885_a_(0.9f, 0.9f, 0.0f, 0.2f).func_181675_d();
                        bufferbuilder.func_225582_a_(0.5, 0.5, 0.5).func_227885_a_(0.9f, 0.9f, 0.0f, 0.2f).func_181675_d();
                        bufferbuilder.func_225582_a_(15.5, 0.5, 0.5).func_227885_a_(0.9f, 0.9f, 0.0f, 0.2f).func_181675_d();
                        bufferbuilder.func_225582_a_(15.5, 0.5, 15.5).func_227885_a_(0.9f, 0.9f, 0.0f, 0.2f).func_181675_d();
                        bufferbuilder.func_225582_a_(15.5, 15.5, 15.5).func_227885_a_(0.9f, 0.9f, 0.0f, 0.2f).func_181675_d();
                        bufferbuilder.func_225582_a_(15.5, 15.5, 0.5).func_227885_a_(0.9f, 0.9f, 0.0f, 0.2f).func_181675_d();
                        bufferbuilder.func_225582_a_(0.5, 0.5, 0.5).func_227885_a_(0.9f, 0.9f, 0.0f, 0.2f).func_181675_d();
                        bufferbuilder.func_225582_a_(15.5, 0.5, 0.5).func_227885_a_(0.9f, 0.9f, 0.0f, 0.2f).func_181675_d();
                        bufferbuilder.func_225582_a_(15.5, 15.5, 0.5).func_227885_a_(0.9f, 0.9f, 0.0f, 0.2f).func_181675_d();
                        bufferbuilder.func_225582_a_(0.5, 15.5, 0.5).func_227885_a_(0.9f, 0.9f, 0.0f, 0.2f).func_181675_d();
                        bufferbuilder.func_225582_a_(0.5, 15.5, 15.5).func_227885_a_(0.9f, 0.9f, 0.0f, 0.2f).func_181675_d();
                        bufferbuilder.func_225582_a_(15.5, 15.5, 15.5).func_227885_a_(0.9f, 0.9f, 0.0f, 0.2f).func_181675_d();
                        bufferbuilder.func_225582_a_(15.5, 0.5, 15.5).func_227885_a_(0.9f, 0.9f, 0.0f, 0.2f).func_181675_d();
                        bufferbuilder.func_225582_a_(0.5, 0.5, 15.5).func_227885_a_(0.9f, 0.9f, 0.0f, 0.2f).func_181675_d();
                        tessellator.func_78381_a();
                    }
                }
                RenderSystem.popMatrix();
            }
            RenderSystem.depthMask((boolean)true);
            RenderSystem.disableBlend();
            RenderSystem.enableCull();
            RenderSystem.enableTexture();
        }
        if (this.field_175001_U != null) {
            RenderSystem.disableCull();
            RenderSystem.disableTexture();
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            RenderSystem.lineWidth((float)10.0f);
            RenderSystem.pushMatrix();
            RenderSystem.translatef((float)((float)(this.field_175003_W.field_181059_a - activeRenderInfoIn.func_216785_c().field_72450_a)), (float)((float)(this.field_175003_W.field_181060_b - activeRenderInfoIn.func_216785_c().field_72448_b)), (float)((float)(this.field_175003_W.field_181061_c - activeRenderInfoIn.func_216785_c().field_72449_c)));
            RenderSystem.depthMask((boolean)true);
            bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181706_f);
            this.func_228434_a_((IVertexBuilder)((Object)bufferbuilder), 0, 1, 2, 3, 0, 1, 1);
            this.func_228434_a_((IVertexBuilder)((Object)bufferbuilder), 4, 5, 6, 7, 1, 0, 0);
            this.func_228434_a_((IVertexBuilder)((Object)bufferbuilder), 0, 1, 5, 4, 1, 1, 0);
            this.func_228434_a_((IVertexBuilder)((Object)bufferbuilder), 2, 3, 7, 6, 0, 0, 1);
            this.func_228434_a_((IVertexBuilder)((Object)bufferbuilder), 0, 4, 7, 3, 0, 1, 0);
            this.func_228434_a_((IVertexBuilder)((Object)bufferbuilder), 1, 5, 6, 2, 1, 0, 1);
            tessellator.func_78381_a();
            RenderSystem.depthMask((boolean)false);
            bufferbuilder.func_181668_a(1, DefaultVertexFormats.field_181705_e);
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.func_228433_a_((IVertexBuilder)((Object)bufferbuilder), 0);
            this.func_228433_a_((IVertexBuilder)((Object)bufferbuilder), 1);
            this.func_228433_a_((IVertexBuilder)((Object)bufferbuilder), 1);
            this.func_228433_a_((IVertexBuilder)((Object)bufferbuilder), 2);
            this.func_228433_a_((IVertexBuilder)((Object)bufferbuilder), 2);
            this.func_228433_a_((IVertexBuilder)((Object)bufferbuilder), 3);
            this.func_228433_a_((IVertexBuilder)((Object)bufferbuilder), 3);
            this.func_228433_a_((IVertexBuilder)((Object)bufferbuilder), 0);
            this.func_228433_a_((IVertexBuilder)((Object)bufferbuilder), 4);
            this.func_228433_a_((IVertexBuilder)((Object)bufferbuilder), 5);
            this.func_228433_a_((IVertexBuilder)((Object)bufferbuilder), 5);
            this.func_228433_a_((IVertexBuilder)((Object)bufferbuilder), 6);
            this.func_228433_a_((IVertexBuilder)((Object)bufferbuilder), 6);
            this.func_228433_a_((IVertexBuilder)((Object)bufferbuilder), 7);
            this.func_228433_a_((IVertexBuilder)((Object)bufferbuilder), 7);
            this.func_228433_a_((IVertexBuilder)((Object)bufferbuilder), 4);
            this.func_228433_a_((IVertexBuilder)((Object)bufferbuilder), 0);
            this.func_228433_a_((IVertexBuilder)((Object)bufferbuilder), 4);
            this.func_228433_a_((IVertexBuilder)((Object)bufferbuilder), 1);
            this.func_228433_a_((IVertexBuilder)((Object)bufferbuilder), 5);
            this.func_228433_a_((IVertexBuilder)((Object)bufferbuilder), 2);
            this.func_228433_a_((IVertexBuilder)((Object)bufferbuilder), 6);
            this.func_228433_a_((IVertexBuilder)((Object)bufferbuilder), 3);
            this.func_228433_a_((IVertexBuilder)((Object)bufferbuilder), 7);
            tessellator.func_78381_a();
            RenderSystem.popMatrix();
            RenderSystem.depthMask((boolean)true);
            RenderSystem.disableBlend();
            RenderSystem.enableCull();
            RenderSystem.enableTexture();
            RenderSystem.lineWidth((float)1.0f);
        }
    }

    private void func_228433_a_(IVertexBuilder bufferIn, int vertex) {
        bufferIn.func_225582_a_(this.field_175004_V[vertex].func_195910_a(), this.field_175004_V[vertex].func_195913_b(), this.field_175004_V[vertex].func_195914_c()).func_181675_d();
    }

    private void func_228434_a_(IVertexBuilder bufferIn, int vertex1, int vertex2, int vertex3, int vertex4, int red, int green, int blue) {
        float f = 0.25f;
        bufferIn.func_225582_a_(this.field_175004_V[vertex1].func_195910_a(), this.field_175004_V[vertex1].func_195913_b(), this.field_175004_V[vertex1].func_195914_c()).func_227885_a_(red, green, blue, 0.25f).func_181675_d();
        bufferIn.func_225582_a_(this.field_175004_V[vertex2].func_195910_a(), this.field_175004_V[vertex2].func_195913_b(), this.field_175004_V[vertex2].func_195914_c()).func_227885_a_(red, green, blue, 0.25f).func_181675_d();
        bufferIn.func_225582_a_(this.field_175004_V[vertex3].func_195910_a(), this.field_175004_V[vertex3].func_195913_b(), this.field_175004_V[vertex3].func_195914_c()).func_227885_a_(red, green, blue, 0.25f).func_181675_d();
        bufferIn.func_225582_a_(this.field_175004_V[vertex4].func_195910_a(), this.field_175004_V[vertex4].func_195913_b(), this.field_175004_V[vertex4].func_195914_c()).func_227885_a_(red, green, blue, 0.25f).func_181675_d();
    }

    public void func_72734_e() {
        ++this.field_72773_u;
        if (this.field_72773_u % 20 == 0) {
            ObjectIterator iterator = this.field_72738_E.values().iterator();
            while (iterator.hasNext()) {
                DestroyBlockProgress destroyblockprogress = (DestroyBlockProgress)iterator.next();
                int i = destroyblockprogress.func_82743_f();
                if (this.field_72773_u - i <= 400) continue;
                iterator.remove();
                this.func_228442_a_(destroyblockprogress);
            }
        }
    }

    private void func_228442_a_(DestroyBlockProgress progressIn) {
        long i = progressIn.func_180246_b().func_218275_a();
        Set set = (Set)this.field_228407_B_.get(i);
        set.remove(progressIn);
        if (set.isEmpty()) {
            this.field_228407_B_.remove(i);
        }
    }

    private void func_228444_b_(MatrixStack matrixStackIn) {
        RenderSystem.disableAlphaTest();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.depthMask((boolean)false);
        this.field_72770_i.func_110577_a(field_110926_k);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        for (int i = 0; i < 6; ++i) {
            matrixStackIn.func_227860_a_();
            if (i == 1) {
                matrixStackIn.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(90.0f));
            }
            if (i == 2) {
                matrixStackIn.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(-90.0f));
            }
            if (i == 3) {
                matrixStackIn.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(180.0f));
            }
            if (i == 4) {
                matrixStackIn.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(90.0f));
            }
            if (i == 5) {
                matrixStackIn.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(-90.0f));
            }
            Matrix4f matrix4f = matrixStackIn.func_227866_c_().func_227870_a_();
            bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181709_i);
            bufferbuilder.func_227888_a_(matrix4f, -100.0f, -100.0f, -100.0f).func_225583_a_(0.0f, 0.0f).func_225586_a_(40, 40, 40, 255).func_181675_d();
            bufferbuilder.func_227888_a_(matrix4f, -100.0f, -100.0f, 100.0f).func_225583_a_(0.0f, 16.0f).func_225586_a_(40, 40, 40, 255).func_181675_d();
            bufferbuilder.func_227888_a_(matrix4f, 100.0f, -100.0f, 100.0f).func_225583_a_(16.0f, 16.0f).func_225586_a_(40, 40, 40, 255).func_181675_d();
            bufferbuilder.func_227888_a_(matrix4f, 100.0f, -100.0f, -100.0f).func_225583_a_(16.0f, 0.0f).func_225586_a_(40, 40, 40, 255).func_181675_d();
            tessellator.func_78381_a();
            matrixStackIn.func_227865_b_();
        }
        RenderSystem.depthMask((boolean)true);
        RenderSystem.enableTexture();
        RenderSystem.disableBlend();
        RenderSystem.enableAlphaTest();
    }

    public void func_228424_a_(MatrixStack matrixStackIn, float partialTicks) {
        if (this.field_72777_q.field_71441_e.func_239132_a_().func_241683_c_() == DimensionRenderInfo.FogType.END) {
            this.func_228444_b_(matrixStackIn);
        } else if (this.field_72777_q.field_71441_e.func_239132_a_().func_241683_c_() == DimensionRenderInfo.FogType.NORMAL) {
            RenderSystem.disableTexture();
            Vector3d vector3d = this.field_72769_h.func_228318_a_(this.field_72777_q.field_71460_t.func_215316_n().func_216780_d(), partialTicks);
            float f = (float)vector3d.field_72450_a;
            float f1 = (float)vector3d.field_72448_b;
            float f2 = (float)vector3d.field_72449_c;
            FogRenderer.func_228373_b_();
            BufferBuilder bufferbuilder = Tessellator.func_178181_a().func_178180_c();
            RenderSystem.depthMask((boolean)false);
            RenderSystem.enableFog();
            RenderSystem.color3f((float)f, (float)f1, (float)f2);
            this.field_175012_t.func_177359_a();
            this.field_175014_r.func_227892_a_(0L);
            this.field_175012_t.func_227874_a_(matrixStackIn.func_227866_c_().func_227870_a_(), 7);
            VertexBuffer.func_177361_b();
            this.field_175014_r.func_227895_d_();
            RenderSystem.disableFog();
            RenderSystem.disableAlphaTest();
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            float[] afloat = this.field_72769_h.func_239132_a_().func_230492_a_(this.field_72769_h.func_72826_c(partialTicks), partialTicks);
            if (afloat != null) {
                RenderSystem.disableTexture();
                RenderSystem.shadeModel((int)7425);
                matrixStackIn.func_227860_a_();
                matrixStackIn.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(90.0f));
                float f3 = MathHelper.func_76126_a((float)this.field_72769_h.func_72929_e(partialTicks)) < 0.0f ? 180.0f : 0.0f;
                matrixStackIn.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(f3));
                matrixStackIn.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(90.0f));
                float f4 = afloat[0];
                float f5 = afloat[1];
                float f6 = afloat[2];
                Matrix4f matrix4f = matrixStackIn.func_227866_c_().func_227870_a_();
                bufferbuilder.func_181668_a(6, DefaultVertexFormats.field_181706_f);
                bufferbuilder.func_227888_a_(matrix4f, 0.0f, 100.0f, 0.0f).func_227885_a_(f4, f5, f6, afloat[3]).func_181675_d();
                int i = 16;
                for (int j = 0; j <= 16; ++j) {
                    float f7 = (float)j * ((float)Math.PI * 2) / 16.0f;
                    float f8 = MathHelper.func_76126_a((float)f7);
                    float f9 = MathHelper.func_76134_b((float)f7);
                    bufferbuilder.func_227888_a_(matrix4f, f8 * 120.0f, f9 * 120.0f, -f9 * 40.0f * afloat[3]).func_227885_a_(afloat[0], afloat[1], afloat[2], 0.0f).func_181675_d();
                }
                bufferbuilder.func_178977_d();
                WorldVertexBufferUploader.func_181679_a((BufferBuilder)bufferbuilder);
                matrixStackIn.func_227865_b_();
                RenderSystem.shadeModel((int)7424);
            }
            RenderSystem.enableTexture();
            RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
            matrixStackIn.func_227860_a_();
            float f11 = 1.0f - this.field_72769_h.func_72867_j(partialTicks);
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)f11);
            matrixStackIn.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(-90.0f));
            matrixStackIn.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(this.field_72769_h.func_72826_c(partialTicks) * 360.0f));
            Matrix4f matrix4f1 = matrixStackIn.func_227866_c_().func_227870_a_();
            float f12 = 30.0f;
            this.field_72770_i.func_110577_a(field_110928_i);
            bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            bufferbuilder.func_227888_a_(matrix4f1, -f12, 100.0f, -f12).func_225583_a_(0.0f, 0.0f).func_181675_d();
            bufferbuilder.func_227888_a_(matrix4f1, f12, 100.0f, -f12).func_225583_a_(1.0f, 0.0f).func_181675_d();
            bufferbuilder.func_227888_a_(matrix4f1, f12, 100.0f, f12).func_225583_a_(1.0f, 1.0f).func_181675_d();
            bufferbuilder.func_227888_a_(matrix4f1, -f12, 100.0f, f12).func_225583_a_(0.0f, 1.0f).func_181675_d();
            bufferbuilder.func_178977_d();
            WorldVertexBufferUploader.func_181679_a((BufferBuilder)bufferbuilder);
            f12 = 20.0f;
            this.field_72770_i.func_110577_a(field_110927_h);
            int k = this.field_72769_h.func_72853_d();
            int l = k % 4;
            int i1 = k / 4 % 2;
            float f13 = (float)(l + 0) / 4.0f;
            float f14 = (float)(i1 + 0) / 2.0f;
            float f15 = (float)(l + 1) / 4.0f;
            float f16 = (float)(i1 + 1) / 2.0f;
            bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            bufferbuilder.func_227888_a_(matrix4f1, -f12, -100.0f, f12).func_225583_a_(f15, f16).func_181675_d();
            bufferbuilder.func_227888_a_(matrix4f1, f12, -100.0f, f12).func_225583_a_(f13, f16).func_181675_d();
            bufferbuilder.func_227888_a_(matrix4f1, f12, -100.0f, -f12).func_225583_a_(f13, f14).func_181675_d();
            bufferbuilder.func_227888_a_(matrix4f1, -f12, -100.0f, -f12).func_225583_a_(f15, f14).func_181675_d();
            bufferbuilder.func_178977_d();
            WorldVertexBufferUploader.func_181679_a((BufferBuilder)bufferbuilder);
            RenderSystem.disableTexture();
            float f10 = this.field_72769_h.func_228330_j_(partialTicks) * f11;
            if (f10 > 0.0f) {
                RenderSystem.color4f((float)f10, (float)f10, (float)f10, (float)f10);
                this.field_175013_s.func_177359_a();
                this.field_175014_r.func_227892_a_(0L);
                this.field_175013_s.func_227874_a_(matrixStackIn.func_227866_c_().func_227870_a_(), 7);
                VertexBuffer.func_177361_b();
                this.field_175014_r.func_227895_d_();
            }
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.disableBlend();
            RenderSystem.enableAlphaTest();
            RenderSystem.enableFog();
            matrixStackIn.func_227865_b_();
            RenderSystem.disableTexture();
            RenderSystem.color3f((float)0.0f, (float)0.0f, (float)0.0f);
            double d0 = this.field_72777_q.field_71439_g.func_174824_e((float)partialTicks).field_72448_b - this.field_72769_h.func_72912_H().func_239159_f_();
            if (d0 < 0.0) {
                matrixStackIn.func_227860_a_();
                matrixStackIn.func_227861_a_(0.0, 12.0, 0.0);
                this.field_175011_u.func_177359_a();
                this.field_175014_r.func_227892_a_(0L);
                this.field_175011_u.func_227874_a_(matrixStackIn.func_227866_c_().func_227870_a_(), 7);
                VertexBuffer.func_177361_b();
                this.field_175014_r.func_227895_d_();
                matrixStackIn.func_227865_b_();
            }
            if (this.field_72769_h.func_239132_a_().func_239216_b_()) {
                RenderSystem.color3f((float)(f * 0.2f + 0.04f), (float)(f1 * 0.2f + 0.04f), (float)(f2 * 0.6f + 0.1f));
            } else {
                RenderSystem.color3f((float)f, (float)f1, (float)f2);
            }
            RenderSystem.enableTexture();
            RenderSystem.depthMask((boolean)true);
            RenderSystem.disableFog();
        }
    }

    public void func_228425_a_(MatrixStack matrixStackIn, float partialTicks, double viewEntityX, double viewEntityY, double viewEntityZ) {
        float f = this.field_72769_h.func_239132_a_().func_239213_a_();
        if (!Float.isNaN(f)) {
            RenderSystem.disableCull();
            RenderSystem.enableBlend();
            RenderSystem.enableAlphaTest();
            RenderSystem.enableDepthTest();
            RenderSystem.defaultAlphaFunc();
            RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            RenderSystem.enableFog();
            RenderSystem.depthMask((boolean)true);
            float f1 = 12.0f;
            float f2 = 4.0f;
            double d0 = 2.0E-4;
            double d1 = ((float)this.field_72773_u + partialTicks) * 0.03f;
            double d2 = (viewEntityX + d1) / 12.0;
            double d3 = f - (float)viewEntityY + 0.33f;
            double d4 = viewEntityZ / 12.0 + (double)0.33f;
            d2 -= (double)(MathHelper.func_76128_c((double)(d2 / 2048.0)) * 2048);
            d4 -= (double)(MathHelper.func_76128_c((double)(d4 / 2048.0)) * 2048);
            float f3 = (float)(d2 - (double)MathHelper.func_76128_c((double)d2));
            float f4 = (float)(d3 / 4.0 - (double)MathHelper.func_76128_c((double)(d3 / 4.0))) * 4.0f;
            float f5 = (float)(d4 - (double)MathHelper.func_76128_c((double)d4));
            Vector3d vector3d = this.field_72769_h.func_228328_h_(partialTicks);
            int i = (int)Math.floor(d2);
            int j = (int)Math.floor(d3 / 4.0);
            int k = (int)Math.floor(d4);
            if (i != this.field_204602_S || j != this.field_204603_T || k != this.field_204604_U || this.field_72777_q.field_71474_y.func_216842_e() != this.field_204800_W || this.field_204605_V.func_72436_e(vector3d) > 2.0E-4) {
                this.field_204602_S = i;
                this.field_204603_T = j;
                this.field_204604_U = k;
                this.field_204605_V = vector3d;
                this.field_204800_W = this.field_72777_q.field_71474_y.func_216842_e();
                this.field_204607_y = true;
            }
            if (this.field_204607_y) {
                this.field_204607_y = false;
                BufferBuilder bufferbuilder = Tessellator.func_178181_a().func_178180_c();
                if (this.field_204601_A != null) {
                    this.field_204601_A.close();
                }
                this.field_204601_A = new VertexBuffer(DefaultVertexFormats.field_181712_l);
                this.func_204600_a(bufferbuilder, d2, d3, d4, vector3d);
                bufferbuilder.func_178977_d();
                this.field_204601_A.func_227875_a_(bufferbuilder);
            }
            this.field_72770_i.func_110577_a(field_110925_j);
            matrixStackIn.func_227860_a_();
            matrixStackIn.func_227862_a_(12.0f, 1.0f, 12.0f);
            matrixStackIn.func_227861_a_((double)(-f3), (double)f4, (double)(-f5));
            if (this.field_204601_A != null) {
                int i1;
                this.field_204601_A.func_177359_a();
                DefaultVertexFormats.field_181712_l.func_227892_a_(0L);
                for (int l = i1 = this.field_204800_W == CloudOption.FANCY ? 0 : 1; l < 2; ++l) {
                    if (l == 0) {
                        RenderSystem.colorMask((boolean)false, (boolean)false, (boolean)false, (boolean)false);
                    } else {
                        RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
                    }
                    this.field_204601_A.func_227874_a_(matrixStackIn.func_227866_c_().func_227870_a_(), 7);
                }
                VertexBuffer.func_177361_b();
                DefaultVertexFormats.field_181712_l.func_227895_d_();
            }
            matrixStackIn.func_227865_b_();
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.disableAlphaTest();
            RenderSystem.enableCull();
            RenderSystem.disableBlend();
            RenderSystem.disableFog();
        }
    }

    private void func_204600_a(BufferBuilder bufferIn, double cloudsX, double cloudsY, double cloudsZ, Vector3d cloudsColor) {
        float f = 4.0f;
        float f1 = 0.00390625f;
        int i = 8;
        int j = 4;
        float f2 = 9.765625E-4f;
        float f3 = (float)MathHelper.func_76128_c((double)cloudsX) * 0.00390625f;
        float f4 = (float)MathHelper.func_76128_c((double)cloudsZ) * 0.00390625f;
        float f5 = (float)cloudsColor.field_72450_a;
        float f6 = (float)cloudsColor.field_72448_b;
        float f7 = (float)cloudsColor.field_72449_c;
        float f8 = f5 * 0.9f;
        float f9 = f6 * 0.9f;
        float f10 = f7 * 0.9f;
        float f11 = f5 * 0.7f;
        float f12 = f6 * 0.7f;
        float f13 = f7 * 0.7f;
        float f14 = f5 * 0.8f;
        float f15 = f6 * 0.8f;
        float f16 = f7 * 0.8f;
        bufferIn.func_181668_a(7, DefaultVertexFormats.field_181712_l);
        float f17 = (float)Math.floor(cloudsY / 4.0) * 4.0f;
        if (this.field_204800_W == CloudOption.FANCY) {
            for (int k = -3; k <= 4; ++k) {
                for (int l = -3; l <= 4; ++l) {
                    float f18 = k * 8;
                    float f19 = l * 8;
                    if (f17 > -5.0f) {
                        bufferIn.func_225582_a_(f18 + 0.0f, f17 + 0.0f, f19 + 8.0f).func_225583_a_((f18 + 0.0f) * 0.00390625f + f3, (f19 + 8.0f) * 0.00390625f + f4).func_227885_a_(f11, f12, f13, 0.8f).func_225584_a_(0.0f, -1.0f, 0.0f).func_181675_d();
                        bufferIn.func_225582_a_(f18 + 8.0f, f17 + 0.0f, f19 + 8.0f).func_225583_a_((f18 + 8.0f) * 0.00390625f + f3, (f19 + 8.0f) * 0.00390625f + f4).func_227885_a_(f11, f12, f13, 0.8f).func_225584_a_(0.0f, -1.0f, 0.0f).func_181675_d();
                        bufferIn.func_225582_a_(f18 + 8.0f, f17 + 0.0f, f19 + 0.0f).func_225583_a_((f18 + 8.0f) * 0.00390625f + f3, (f19 + 0.0f) * 0.00390625f + f4).func_227885_a_(f11, f12, f13, 0.8f).func_225584_a_(0.0f, -1.0f, 0.0f).func_181675_d();
                        bufferIn.func_225582_a_(f18 + 0.0f, f17 + 0.0f, f19 + 0.0f).func_225583_a_((f18 + 0.0f) * 0.00390625f + f3, (f19 + 0.0f) * 0.00390625f + f4).func_227885_a_(f11, f12, f13, 0.8f).func_225584_a_(0.0f, -1.0f, 0.0f).func_181675_d();
                    }
                    if (f17 <= 5.0f) {
                        bufferIn.func_225582_a_(f18 + 0.0f, f17 + 4.0f - 9.765625E-4f, f19 + 8.0f).func_225583_a_((f18 + 0.0f) * 0.00390625f + f3, (f19 + 8.0f) * 0.00390625f + f4).func_227885_a_(f5, f6, f7, 0.8f).func_225584_a_(0.0f, 1.0f, 0.0f).func_181675_d();
                        bufferIn.func_225582_a_(f18 + 8.0f, f17 + 4.0f - 9.765625E-4f, f19 + 8.0f).func_225583_a_((f18 + 8.0f) * 0.00390625f + f3, (f19 + 8.0f) * 0.00390625f + f4).func_227885_a_(f5, f6, f7, 0.8f).func_225584_a_(0.0f, 1.0f, 0.0f).func_181675_d();
                        bufferIn.func_225582_a_(f18 + 8.0f, f17 + 4.0f - 9.765625E-4f, f19 + 0.0f).func_225583_a_((f18 + 8.0f) * 0.00390625f + f3, (f19 + 0.0f) * 0.00390625f + f4).func_227885_a_(f5, f6, f7, 0.8f).func_225584_a_(0.0f, 1.0f, 0.0f).func_181675_d();
                        bufferIn.func_225582_a_(f18 + 0.0f, f17 + 4.0f - 9.765625E-4f, f19 + 0.0f).func_225583_a_((f18 + 0.0f) * 0.00390625f + f3, (f19 + 0.0f) * 0.00390625f + f4).func_227885_a_(f5, f6, f7, 0.8f).func_225584_a_(0.0f, 1.0f, 0.0f).func_181675_d();
                    }
                    if (k > -1) {
                        for (int i1 = 0; i1 < 8; ++i1) {
                            bufferIn.func_225582_a_(f18 + (float)i1 + 0.0f, f17 + 0.0f, f19 + 8.0f).func_225583_a_((f18 + (float)i1 + 0.5f) * 0.00390625f + f3, (f19 + 8.0f) * 0.00390625f + f4).func_227885_a_(f8, f9, f10, 0.8f).func_225584_a_(-1.0f, 0.0f, 0.0f).func_181675_d();
                            bufferIn.func_225582_a_(f18 + (float)i1 + 0.0f, f17 + 4.0f, f19 + 8.0f).func_225583_a_((f18 + (float)i1 + 0.5f) * 0.00390625f + f3, (f19 + 8.0f) * 0.00390625f + f4).func_227885_a_(f8, f9, f10, 0.8f).func_225584_a_(-1.0f, 0.0f, 0.0f).func_181675_d();
                            bufferIn.func_225582_a_(f18 + (float)i1 + 0.0f, f17 + 4.0f, f19 + 0.0f).func_225583_a_((f18 + (float)i1 + 0.5f) * 0.00390625f + f3, (f19 + 0.0f) * 0.00390625f + f4).func_227885_a_(f8, f9, f10, 0.8f).func_225584_a_(-1.0f, 0.0f, 0.0f).func_181675_d();
                            bufferIn.func_225582_a_(f18 + (float)i1 + 0.0f, f17 + 0.0f, f19 + 0.0f).func_225583_a_((f18 + (float)i1 + 0.5f) * 0.00390625f + f3, (f19 + 0.0f) * 0.00390625f + f4).func_227885_a_(f8, f9, f10, 0.8f).func_225584_a_(-1.0f, 0.0f, 0.0f).func_181675_d();
                        }
                    }
                    if (k <= 1) {
                        for (int j2 = 0; j2 < 8; ++j2) {
                            bufferIn.func_225582_a_(f18 + (float)j2 + 1.0f - 9.765625E-4f, f17 + 0.0f, f19 + 8.0f).func_225583_a_((f18 + (float)j2 + 0.5f) * 0.00390625f + f3, (f19 + 8.0f) * 0.00390625f + f4).func_227885_a_(f8, f9, f10, 0.8f).func_225584_a_(1.0f, 0.0f, 0.0f).func_181675_d();
                            bufferIn.func_225582_a_(f18 + (float)j2 + 1.0f - 9.765625E-4f, f17 + 4.0f, f19 + 8.0f).func_225583_a_((f18 + (float)j2 + 0.5f) * 0.00390625f + f3, (f19 + 8.0f) * 0.00390625f + f4).func_227885_a_(f8, f9, f10, 0.8f).func_225584_a_(1.0f, 0.0f, 0.0f).func_181675_d();
                            bufferIn.func_225582_a_(f18 + (float)j2 + 1.0f - 9.765625E-4f, f17 + 4.0f, f19 + 0.0f).func_225583_a_((f18 + (float)j2 + 0.5f) * 0.00390625f + f3, (f19 + 0.0f) * 0.00390625f + f4).func_227885_a_(f8, f9, f10, 0.8f).func_225584_a_(1.0f, 0.0f, 0.0f).func_181675_d();
                            bufferIn.func_225582_a_(f18 + (float)j2 + 1.0f - 9.765625E-4f, f17 + 0.0f, f19 + 0.0f).func_225583_a_((f18 + (float)j2 + 0.5f) * 0.00390625f + f3, (f19 + 0.0f) * 0.00390625f + f4).func_227885_a_(f8, f9, f10, 0.8f).func_225584_a_(1.0f, 0.0f, 0.0f).func_181675_d();
                        }
                    }
                    if (l > -1) {
                        for (int k2 = 0; k2 < 8; ++k2) {
                            bufferIn.func_225582_a_(f18 + 0.0f, f17 + 4.0f, f19 + (float)k2 + 0.0f).func_225583_a_((f18 + 0.0f) * 0.00390625f + f3, (f19 + (float)k2 + 0.5f) * 0.00390625f + f4).func_227885_a_(f14, f15, f16, 0.8f).func_225584_a_(0.0f, 0.0f, -1.0f).func_181675_d();
                            bufferIn.func_225582_a_(f18 + 8.0f, f17 + 4.0f, f19 + (float)k2 + 0.0f).func_225583_a_((f18 + 8.0f) * 0.00390625f + f3, (f19 + (float)k2 + 0.5f) * 0.00390625f + f4).func_227885_a_(f14, f15, f16, 0.8f).func_225584_a_(0.0f, 0.0f, -1.0f).func_181675_d();
                            bufferIn.func_225582_a_(f18 + 8.0f, f17 + 0.0f, f19 + (float)k2 + 0.0f).func_225583_a_((f18 + 8.0f) * 0.00390625f + f3, (f19 + (float)k2 + 0.5f) * 0.00390625f + f4).func_227885_a_(f14, f15, f16, 0.8f).func_225584_a_(0.0f, 0.0f, -1.0f).func_181675_d();
                            bufferIn.func_225582_a_(f18 + 0.0f, f17 + 0.0f, f19 + (float)k2 + 0.0f).func_225583_a_((f18 + 0.0f) * 0.00390625f + f3, (f19 + (float)k2 + 0.5f) * 0.00390625f + f4).func_227885_a_(f14, f15, f16, 0.8f).func_225584_a_(0.0f, 0.0f, -1.0f).func_181675_d();
                        }
                    }
                    if (l > 1) continue;
                    for (int l2 = 0; l2 < 8; ++l2) {
                        bufferIn.func_225582_a_(f18 + 0.0f, f17 + 4.0f, f19 + (float)l2 + 1.0f - 9.765625E-4f).func_225583_a_((f18 + 0.0f) * 0.00390625f + f3, (f19 + (float)l2 + 0.5f) * 0.00390625f + f4).func_227885_a_(f14, f15, f16, 0.8f).func_225584_a_(0.0f, 0.0f, 1.0f).func_181675_d();
                        bufferIn.func_225582_a_(f18 + 8.0f, f17 + 4.0f, f19 + (float)l2 + 1.0f - 9.765625E-4f).func_225583_a_((f18 + 8.0f) * 0.00390625f + f3, (f19 + (float)l2 + 0.5f) * 0.00390625f + f4).func_227885_a_(f14, f15, f16, 0.8f).func_225584_a_(0.0f, 0.0f, 1.0f).func_181675_d();
                        bufferIn.func_225582_a_(f18 + 8.0f, f17 + 0.0f, f19 + (float)l2 + 1.0f - 9.765625E-4f).func_225583_a_((f18 + 8.0f) * 0.00390625f + f3, (f19 + (float)l2 + 0.5f) * 0.00390625f + f4).func_227885_a_(f14, f15, f16, 0.8f).func_225584_a_(0.0f, 0.0f, 1.0f).func_181675_d();
                        bufferIn.func_225582_a_(f18 + 0.0f, f17 + 0.0f, f19 + (float)l2 + 1.0f - 9.765625E-4f).func_225583_a_((f18 + 0.0f) * 0.00390625f + f3, (f19 + (float)l2 + 0.5f) * 0.00390625f + f4).func_227885_a_(f14, f15, f16, 0.8f).func_225584_a_(0.0f, 0.0f, 1.0f).func_181675_d();
                    }
                }
            }
        } else {
            boolean j1 = true;
            int k1 = 32;
            for (int l1 = -32; l1 < 32; l1 += 32) {
                for (int i2 = -32; i2 < 32; i2 += 32) {
                    bufferIn.func_225582_a_(l1 + 0, f17, i2 + 32).func_225583_a_((float)(l1 + 0) * 0.00390625f + f3, (float)(i2 + 32) * 0.00390625f + f4).func_227885_a_(f5, f6, f7, 0.8f).func_225584_a_(0.0f, -1.0f, 0.0f).func_181675_d();
                    bufferIn.func_225582_a_(l1 + 32, f17, i2 + 32).func_225583_a_((float)(l1 + 32) * 0.00390625f + f3, (float)(i2 + 32) * 0.00390625f + f4).func_227885_a_(f5, f6, f7, 0.8f).func_225584_a_(0.0f, -1.0f, 0.0f).func_181675_d();
                    bufferIn.func_225582_a_(l1 + 32, f17, i2 + 0).func_225583_a_((float)(l1 + 32) * 0.00390625f + f3, (float)(i2 + 0) * 0.00390625f + f4).func_227885_a_(f5, f6, f7, 0.8f).func_225584_a_(0.0f, -1.0f, 0.0f).func_181675_d();
                    bufferIn.func_225582_a_(l1 + 0, f17, i2 + 0).func_225583_a_((float)(l1 + 0) * 0.00390625f + f3, (float)(i2 + 0) * 0.00390625f + f4).func_227885_a_(f5, f6, f7, 0.8f).func_225584_a_(0.0f, -1.0f, 0.0f).func_181675_d();
                }
            }
        }
    }

    private void func_174967_a(long finishTimeNano) {
        this.field_147595_R |= this.field_174995_M.func_228908_d_();
        long i = Util.func_211178_c();
        int j = 0;
        if (!this.field_175009_l.isEmpty()) {
            Iterator<ChunkRenderDispatcher.ChunkRender> iterator = this.field_175009_l.iterator();
            while (iterator.hasNext()) {
                long l;
                long i1;
                ChunkRenderDispatcher.ChunkRender chunkrenderdispatcher$chunkrender = iterator.next();
                if (chunkrenderdispatcher$chunkrender.func_188281_o()) {
                    this.field_174995_M.func_228902_a_(chunkrenderdispatcher$chunkrender);
                } else {
                    chunkrenderdispatcher$chunkrender.func_228929_a_(this.field_174995_M);
                }
                chunkrenderdispatcher$chunkrender.func_188282_m();
                iterator.remove();
                long k = Util.func_211178_c();
                long j1 = finishTimeNano - k;
                if (j1 >= (i1 = (l = k - i) / (long)(++j))) continue;
                break;
            }
        }
    }

    private void func_228447_c_(ActiveRenderInfo activeRenderInfoIn) {
        BufferBuilder bufferbuilder = Tessellator.func_178181_a().func_178180_c();
        WorldBorder worldborder = this.field_72769_h.func_175723_af();
        double d0 = this.field_72777_q.field_71474_y.field_151451_c * 16;
        if (!(activeRenderInfoIn.func_216785_c().field_72450_a < worldborder.func_177728_d() - d0 && activeRenderInfoIn.func_216785_c().field_72450_a > worldborder.func_177726_b() + d0 && activeRenderInfoIn.func_216785_c().field_72449_c < worldborder.func_177733_e() - d0 && activeRenderInfoIn.func_216785_c().field_72449_c > worldborder.func_177736_c() + d0)) {
            double d1 = 1.0 - worldborder.func_177729_b(activeRenderInfoIn.func_216785_c().field_72450_a, activeRenderInfoIn.func_216785_c().field_72449_c) / d0;
            d1 = Math.pow(d1, 4.0);
            double d2 = activeRenderInfoIn.func_216785_c().field_72450_a;
            double d3 = activeRenderInfoIn.func_216785_c().field_72448_b;
            double d4 = activeRenderInfoIn.func_216785_c().field_72449_c;
            RenderSystem.enableBlend();
            RenderSystem.enableDepthTest();
            RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
            this.field_72770_i.func_110577_a(field_175006_g);
            RenderSystem.depthMask((boolean)Minecraft.func_238218_y_());
            RenderSystem.pushMatrix();
            int i = worldborder.func_177734_a().func_177766_a();
            float f = (float)(i >> 16 & 0xFF) / 255.0f;
            float f1 = (float)(i >> 8 & 0xFF) / 255.0f;
            float f2 = (float)(i & 0xFF) / 255.0f;
            RenderSystem.color4f((float)f, (float)f1, (float)f2, (float)((float)d1));
            RenderSystem.polygonOffset((float)-3.0f, (float)-3.0f);
            RenderSystem.enablePolygonOffset();
            RenderSystem.defaultAlphaFunc();
            RenderSystem.enableAlphaTest();
            RenderSystem.disableCull();
            float f3 = (float)(Util.func_211177_b() % 3000L) / 3000.0f;
            float f4 = 0.0f;
            float f5 = 0.0f;
            float f6 = 128.0f;
            bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            double d5 = Math.max((double)MathHelper.func_76128_c((double)(d4 - d0)), worldborder.func_177736_c());
            double d6 = Math.min((double)MathHelper.func_76143_f((double)(d4 + d0)), worldborder.func_177733_e());
            if (d2 > worldborder.func_177728_d() - d0) {
                float f7 = 0.0f;
                double d7 = d5;
                while (d7 < d6) {
                    double d8 = Math.min(1.0, d6 - d7);
                    float f8 = (float)d8 * 0.5f;
                    this.func_228422_a_(bufferbuilder, d2, d3, d4, worldborder.func_177728_d(), 256, d7, f3 + f7, f3 + 0.0f);
                    this.func_228422_a_(bufferbuilder, d2, d3, d4, worldborder.func_177728_d(), 256, d7 + d8, f3 + f8 + f7, f3 + 0.0f);
                    this.func_228422_a_(bufferbuilder, d2, d3, d4, worldborder.func_177728_d(), 0, d7 + d8, f3 + f8 + f7, f3 + 128.0f);
                    this.func_228422_a_(bufferbuilder, d2, d3, d4, worldborder.func_177728_d(), 0, d7, f3 + f7, f3 + 128.0f);
                    d7 += 1.0;
                    f7 += 0.5f;
                }
            }
            if (d2 < worldborder.func_177726_b() + d0) {
                float f9 = 0.0f;
                double d9 = d5;
                while (d9 < d6) {
                    double d12 = Math.min(1.0, d6 - d9);
                    float f12 = (float)d12 * 0.5f;
                    this.func_228422_a_(bufferbuilder, d2, d3, d4, worldborder.func_177726_b(), 256, d9, f3 + f9, f3 + 0.0f);
                    this.func_228422_a_(bufferbuilder, d2, d3, d4, worldborder.func_177726_b(), 256, d9 + d12, f3 + f12 + f9, f3 + 0.0f);
                    this.func_228422_a_(bufferbuilder, d2, d3, d4, worldborder.func_177726_b(), 0, d9 + d12, f3 + f12 + f9, f3 + 128.0f);
                    this.func_228422_a_(bufferbuilder, d2, d3, d4, worldborder.func_177726_b(), 0, d9, f3 + f9, f3 + 128.0f);
                    d9 += 1.0;
                    f9 += 0.5f;
                }
            }
            d5 = Math.max((double)MathHelper.func_76128_c((double)(d2 - d0)), worldborder.func_177726_b());
            d6 = Math.min((double)MathHelper.func_76143_f((double)(d2 + d0)), worldborder.func_177728_d());
            if (d4 > worldborder.func_177733_e() - d0) {
                float f10 = 0.0f;
                double d10 = d5;
                while (d10 < d6) {
                    double d13 = Math.min(1.0, d6 - d10);
                    float f13 = (float)d13 * 0.5f;
                    this.func_228422_a_(bufferbuilder, d2, d3, d4, d10, 256, worldborder.func_177733_e(), f3 + f10, f3 + 0.0f);
                    this.func_228422_a_(bufferbuilder, d2, d3, d4, d10 + d13, 256, worldborder.func_177733_e(), f3 + f13 + f10, f3 + 0.0f);
                    this.func_228422_a_(bufferbuilder, d2, d3, d4, d10 + d13, 0, worldborder.func_177733_e(), f3 + f13 + f10, f3 + 128.0f);
                    this.func_228422_a_(bufferbuilder, d2, d3, d4, d10, 0, worldborder.func_177733_e(), f3 + f10, f3 + 128.0f);
                    d10 += 1.0;
                    f10 += 0.5f;
                }
            }
            if (d4 < worldborder.func_177736_c() + d0) {
                float f11 = 0.0f;
                double d11 = d5;
                while (d11 < d6) {
                    double d14 = Math.min(1.0, d6 - d11);
                    float f14 = (float)d14 * 0.5f;
                    this.func_228422_a_(bufferbuilder, d2, d3, d4, d11, 256, worldborder.func_177736_c(), f3 + f11, f3 + 0.0f);
                    this.func_228422_a_(bufferbuilder, d2, d3, d4, d11 + d14, 256, worldborder.func_177736_c(), f3 + f14 + f11, f3 + 0.0f);
                    this.func_228422_a_(bufferbuilder, d2, d3, d4, d11 + d14, 0, worldborder.func_177736_c(), f3 + f14 + f11, f3 + 128.0f);
                    this.func_228422_a_(bufferbuilder, d2, d3, d4, d11, 0, worldborder.func_177736_c(), f3 + f11, f3 + 128.0f);
                    d11 += 1.0;
                    f11 += 0.5f;
                }
            }
            bufferbuilder.func_178977_d();
            WorldVertexBufferUploader.func_181679_a((BufferBuilder)bufferbuilder);
            RenderSystem.enableCull();
            RenderSystem.disableAlphaTest();
            RenderSystem.polygonOffset((float)0.0f, (float)0.0f);
            RenderSystem.disablePolygonOffset();
            RenderSystem.enableAlphaTest();
            RenderSystem.disableBlend();
            RenderSystem.popMatrix();
            RenderSystem.depthMask((boolean)true);
        }
    }

    private void func_228422_a_(BufferBuilder bufferIn, double camX, double camY, double camZ, double xIn, int yIn, double zIn, float texU, float texV) {
        bufferIn.func_225582_a_(xIn - camX, (double)yIn - camY, zIn - camZ).func_225583_a_(texU, texV).func_181675_d();
    }

    private void func_228429_a_(MatrixStack matrixStackIn, IVertexBuilder bufferIn, Entity entityIn, double xIn, double yIn, double zIn, BlockPos blockPosIn, BlockState blockStateIn) {
        WorldRenderer.func_228445_b_(matrixStackIn, bufferIn, blockStateIn.func_215700_a((IBlockReader)((Object)this.field_72769_h), blockPosIn, ISelectionContext.func_216374_a(entityIn)), (double)blockPosIn.func_177958_n() - xIn, (double)blockPosIn.func_177956_o() - yIn, (double)blockPosIn.func_177952_p() - zIn, 0.0f, 0.0f, 0.0f, 0.4f);
    }

    public static void func_228431_a_(MatrixStack matrixStackIn, IVertexBuilder bufferIn, VoxelShape shapeIn, double xIn, double yIn, double zIn, float red, float green, float blue, float alpha) {
        List list = shapeIn.func_197756_d();
        int i = MathHelper.func_76143_f((double)((double)list.size() / 3.0));
        for (int j = 0; j < list.size(); ++j) {
            AxisAlignedBB axisalignedbb = (AxisAlignedBB)list.get(j);
            float f = ((float)j % (float)i + 1.0f) / (float)i;
            float f1 = j / i;
            float f2 = f * (float)(f1 == 0.0f ? 1 : 0);
            float f3 = f * (float)(f1 == 1.0f ? 1 : 0);
            float f4 = f * (float)(f1 == 2.0f ? 1 : 0);
            WorldRenderer.func_228445_b_(matrixStackIn, bufferIn, VoxelShapes.func_197881_a((AxisAlignedBB)axisalignedbb.func_72317_d(0.0, 0.0, 0.0)), xIn, yIn, zIn, f2, f3, f4, 1.0f);
        }
    }

    private static void func_228445_b_(MatrixStack matrixStackIn, IVertexBuilder bufferIn, VoxelShape shapeIn, double xIn, double yIn, double zIn, float red, float green, float blue, float alpha) {
        Matrix4f matrix4f = matrixStackIn.func_227866_c_().func_227870_a_();
        shapeIn.func_197754_a((p_230013_12_, p_230013_14_, p_230013_16_, p_230013_18_, p_230013_20_, p_230013_22_) -> {
            bufferIn.func_227888_a_(matrix4f, (float)(p_230013_12_ + xIn), (float)(p_230013_14_ + yIn), (float)(p_230013_16_ + zIn)).func_227885_a_(red, green, blue, alpha).func_181675_d();
            bufferIn.func_227888_a_(matrix4f, (float)(p_230013_18_ + xIn), (float)(p_230013_20_ + yIn), (float)(p_230013_22_ + zIn)).func_227885_a_(red, green, blue, alpha).func_181675_d();
        });
    }

    public static void func_228430_a_(MatrixStack matrixStackIn, IVertexBuilder bufferIn, AxisAlignedBB aabbIn, float red, float green, float blue, float alpha) {
        WorldRenderer.func_228428_a_(matrixStackIn, bufferIn, aabbIn.field_72340_a, aabbIn.field_72338_b, aabbIn.field_72339_c, aabbIn.field_72336_d, aabbIn.field_72337_e, aabbIn.field_72334_f, red, green, blue, alpha, red, green, blue);
    }

    public static void func_228427_a_(MatrixStack matrixStackIn, IVertexBuilder bufferIn, double minX, double minY, double minZ, double maxX, double maxY, double maxZ, float red, float green, float blue, float alpha) {
        WorldRenderer.func_228428_a_(matrixStackIn, bufferIn, minX, minY, minZ, maxX, maxY, maxZ, red, green, blue, alpha, red, green, blue);
    }

    public static void func_228428_a_(MatrixStack matrixStackIn, IVertexBuilder bufferIn, double minX, double minY, double minZ, double maxX, double maxY, double maxZ, float red, float green, float blue, float alpha, float red2, float green2, float blue2) {
        Matrix4f matrix4f = matrixStackIn.func_227866_c_().func_227870_a_();
        float f = (float)minX;
        float f1 = (float)minY;
        float f2 = (float)minZ;
        float f3 = (float)maxX;
        float f4 = (float)maxY;
        float f5 = (float)maxZ;
        bufferIn.func_227888_a_(matrix4f, f, f1, f2).func_227885_a_(red, green2, blue2, alpha).func_181675_d();
        bufferIn.func_227888_a_(matrix4f, f3, f1, f2).func_227885_a_(red, green2, blue2, alpha).func_181675_d();
        bufferIn.func_227888_a_(matrix4f, f, f1, f2).func_227885_a_(red2, green, blue2, alpha).func_181675_d();
        bufferIn.func_227888_a_(matrix4f, f, f4, f2).func_227885_a_(red2, green, blue2, alpha).func_181675_d();
        bufferIn.func_227888_a_(matrix4f, f, f1, f2).func_227885_a_(red2, green2, blue, alpha).func_181675_d();
        bufferIn.func_227888_a_(matrix4f, f, f1, f5).func_227885_a_(red2, green2, blue, alpha).func_181675_d();
        bufferIn.func_227888_a_(matrix4f, f3, f1, f2).func_227885_a_(red, green, blue, alpha).func_181675_d();
        bufferIn.func_227888_a_(matrix4f, f3, f4, f2).func_227885_a_(red, green, blue, alpha).func_181675_d();
        bufferIn.func_227888_a_(matrix4f, f3, f4, f2).func_227885_a_(red, green, blue, alpha).func_181675_d();
        bufferIn.func_227888_a_(matrix4f, f, f4, f2).func_227885_a_(red, green, blue, alpha).func_181675_d();
        bufferIn.func_227888_a_(matrix4f, f, f4, f2).func_227885_a_(red, green, blue, alpha).func_181675_d();
        bufferIn.func_227888_a_(matrix4f, f, f4, f5).func_227885_a_(red, green, blue, alpha).func_181675_d();
        bufferIn.func_227888_a_(matrix4f, f, f4, f5).func_227885_a_(red, green, blue, alpha).func_181675_d();
        bufferIn.func_227888_a_(matrix4f, f, f1, f5).func_227885_a_(red, green, blue, alpha).func_181675_d();
        bufferIn.func_227888_a_(matrix4f, f, f1, f5).func_227885_a_(red, green, blue, alpha).func_181675_d();
        bufferIn.func_227888_a_(matrix4f, f3, f1, f5).func_227885_a_(red, green, blue, alpha).func_181675_d();
        bufferIn.func_227888_a_(matrix4f, f3, f1, f5).func_227885_a_(red, green, blue, alpha).func_181675_d();
        bufferIn.func_227888_a_(matrix4f, f3, f1, f2).func_227885_a_(red, green, blue, alpha).func_181675_d();
        bufferIn.func_227888_a_(matrix4f, f, f4, f5).func_227885_a_(red, green, blue, alpha).func_181675_d();
        bufferIn.func_227888_a_(matrix4f, f3, f4, f5).func_227885_a_(red, green, blue, alpha).func_181675_d();
        bufferIn.func_227888_a_(matrix4f, f3, f1, f5).func_227885_a_(red, green, blue, alpha).func_181675_d();
        bufferIn.func_227888_a_(matrix4f, f3, f4, f5).func_227885_a_(red, green, blue, alpha).func_181675_d();
        bufferIn.func_227888_a_(matrix4f, f3, f4, f2).func_227885_a_(red, green, blue, alpha).func_181675_d();
        bufferIn.func_227888_a_(matrix4f, f3, f4, f5).func_227885_a_(red, green, blue, alpha).func_181675_d();
    }

    public static void func_189693_b(BufferBuilder builder, double x1, double y1, double z1, double x2, double y2, double z2, float red, float green, float blue, float alpha) {
        builder.func_225582_a_(x1, y1, z1).func_227885_a_(red, green, blue, alpha).func_181675_d();
        builder.func_225582_a_(x1, y1, z1).func_227885_a_(red, green, blue, alpha).func_181675_d();
        builder.func_225582_a_(x1, y1, z1).func_227885_a_(red, green, blue, alpha).func_181675_d();
        builder.func_225582_a_(x1, y1, z2).func_227885_a_(red, green, blue, alpha).func_181675_d();
        builder.func_225582_a_(x1, y2, z1).func_227885_a_(red, green, blue, alpha).func_181675_d();
        builder.func_225582_a_(x1, y2, z2).func_227885_a_(red, green, blue, alpha).func_181675_d();
        builder.func_225582_a_(x1, y2, z2).func_227885_a_(red, green, blue, alpha).func_181675_d();
        builder.func_225582_a_(x1, y1, z2).func_227885_a_(red, green, blue, alpha).func_181675_d();
        builder.func_225582_a_(x2, y2, z2).func_227885_a_(red, green, blue, alpha).func_181675_d();
        builder.func_225582_a_(x2, y1, z2).func_227885_a_(red, green, blue, alpha).func_181675_d();
        builder.func_225582_a_(x2, y1, z2).func_227885_a_(red, green, blue, alpha).func_181675_d();
        builder.func_225582_a_(x2, y1, z1).func_227885_a_(red, green, blue, alpha).func_181675_d();
        builder.func_225582_a_(x2, y2, z2).func_227885_a_(red, green, blue, alpha).func_181675_d();
        builder.func_225582_a_(x2, y2, z1).func_227885_a_(red, green, blue, alpha).func_181675_d();
        builder.func_225582_a_(x2, y2, z1).func_227885_a_(red, green, blue, alpha).func_181675_d();
        builder.func_225582_a_(x2, y1, z1).func_227885_a_(red, green, blue, alpha).func_181675_d();
        builder.func_225582_a_(x1, y2, z1).func_227885_a_(red, green, blue, alpha).func_181675_d();
        builder.func_225582_a_(x1, y1, z1).func_227885_a_(red, green, blue, alpha).func_181675_d();
        builder.func_225582_a_(x1, y1, z1).func_227885_a_(red, green, blue, alpha).func_181675_d();
        builder.func_225582_a_(x2, y1, z1).func_227885_a_(red, green, blue, alpha).func_181675_d();
        builder.func_225582_a_(x1, y1, z2).func_227885_a_(red, green, blue, alpha).func_181675_d();
        builder.func_225582_a_(x2, y1, z2).func_227885_a_(red, green, blue, alpha).func_181675_d();
        builder.func_225582_a_(x2, y1, z2).func_227885_a_(red, green, blue, alpha).func_181675_d();
        builder.func_225582_a_(x1, y2, z1).func_227885_a_(red, green, blue, alpha).func_181675_d();
        builder.func_225582_a_(x1, y2, z1).func_227885_a_(red, green, blue, alpha).func_181675_d();
        builder.func_225582_a_(x1, y2, z2).func_227885_a_(red, green, blue, alpha).func_181675_d();
        builder.func_225582_a_(x2, y2, z1).func_227885_a_(red, green, blue, alpha).func_181675_d();
        builder.func_225582_a_(x2, y2, z2).func_227885_a_(red, green, blue, alpha).func_181675_d();
        builder.func_225582_a_(x2, y2, z2).func_227885_a_(red, green, blue, alpha).func_181675_d();
        builder.func_225582_a_(x2, y2, z2).func_227885_a_(red, green, blue, alpha).func_181675_d();
    }

    public void func_184376_a(IBlockReader worldIn, BlockPos pos, BlockState oldState, BlockState newState, int flags) {
        this.func_215324_a(pos, (flags & 8) != 0);
    }

    private void func_215324_a(BlockPos posIn, boolean rerenderOnMainThread) {
        for (int i = posIn.func_177952_p() - 1; i <= posIn.func_177952_p() + 1; ++i) {
            for (int j = posIn.func_177958_n() - 1; j <= posIn.func_177958_n() + 1; ++j) {
                for (int k = posIn.func_177956_o() - 1; k <= posIn.func_177956_o() + 1; ++k) {
                    this.func_215319_a(j >> 4, k >> 4, i >> 4, rerenderOnMainThread);
                }
            }
        }
    }

    public void func_147585_a(int x1, int y1, int z1, int x2, int y2, int z2) {
        for (int i = z1 - 1; i <= z2 + 1; ++i) {
            for (int j = x1 - 1; j <= x2 + 1; ++j) {
                for (int k = y1 - 1; k <= y2 + 1; ++k) {
                    this.func_215328_b(j >> 4, k >> 4, i >> 4);
                }
            }
        }
    }

    public void func_224746_a(BlockPos blockPosIn, BlockState oldState, BlockState newState) {
        if (this.field_72777_q.func_209506_al().func_224742_a(oldState, newState)) {
            this.func_147585_a(blockPosIn.func_177958_n(), blockPosIn.func_177956_o(), blockPosIn.func_177952_p(), blockPosIn.func_177958_n(), blockPosIn.func_177956_o(), blockPosIn.func_177952_p());
        }
    }

    public void func_215321_a(int sectionX, int sectionY, int sectionZ) {
        for (int i = sectionZ - 1; i <= sectionZ + 1; ++i) {
            for (int j = sectionX - 1; j <= sectionX + 1; ++j) {
                for (int k = sectionY - 1; k <= sectionY + 1; ++k) {
                    this.func_215328_b(j, k, i);
                }
            }
        }
    }

    public void func_215328_b(int sectionX, int sectionY, int sectionZ) {
        this.func_215319_a(sectionX, sectionY, sectionZ, false);
    }

    private void func_215319_a(int sectionX, int sectionY, int sectionZ, boolean rerenderOnMainThread) {
        this.field_175008_n.func_217628_a(sectionX, sectionY, sectionZ, rerenderOnMainThread);
    }

    @Deprecated
    public void func_184377_a(@Nullable SoundEvent soundIn, BlockPos pos) {
        this.playRecord(soundIn, pos, soundIn == null ? null : MusicDiscItem.func_185074_a(soundIn));
    }

    public void playRecord(@Nullable SoundEvent soundIn, BlockPos pos, @Nullable MusicDiscItem musicDiscItem) {
        ISound isound = this.field_147593_P.get(pos);
        if (isound != null) {
            this.field_72777_q.func_147118_V().func_147683_b(isound);
            this.field_147593_P.remove(pos);
        }
        if (soundIn != null) {
            MusicDiscItem musicdiscitem = musicDiscItem;
            if (musicdiscitem != null) {
                this.field_72777_q.field_71456_v.func_238451_a_((ITextComponent)musicdiscitem.func_234801_g_());
            }
            SimpleSound simplesound = SimpleSound.func_184372_a((SoundEvent)soundIn, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p());
            this.field_147593_P.put(pos, (ISound)simplesound);
            this.field_72777_q.func_147118_V().func_147682_a((ISound)simplesound);
        }
        this.func_193054_a(this.field_72769_h, pos, soundIn != null);
    }

    private void func_193054_a(World worldIn, BlockPos pos, boolean isPartying) {
        for (LivingEntity livingentity : worldIn.func_217357_a(LivingEntity.class, new AxisAlignedBB(pos).func_186662_g(3.0))) {
            livingentity.func_191987_a(pos, isPartying);
        }
    }

    public void func_195461_a(IParticleData particleData, boolean alwaysRender, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
        this.func_195462_a(particleData, alwaysRender, false, x, y, z, xSpeed, ySpeed, zSpeed);
    }

    public void func_195462_a(IParticleData particleData, boolean ignoreRange, boolean minimizeLevel, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
        try {
            this.func_195469_b(particleData, ignoreRange, minimizeLevel, x, y, z, xSpeed, ySpeed, zSpeed);
        }
        catch (Throwable throwable) {
            CrashReport crashreport = CrashReport.func_85055_a(throwable, "Exception while adding particle");
            CrashReportCategory crashreportcategory = crashreport.func_85058_a("Particle being added");
            crashreportcategory.func_71507_a("ID", Registry.field_212632_u.func_177774_c(particleData.func_197554_b()));
            crashreportcategory.func_71507_a("Parameters", particleData.func_197555_a());
            crashreportcategory.func_189529_a("Position", (ICrashReportDetail<String>)((ICrashReportDetail)() -> CrashReportCategory.func_85074_a(x, y, z)));
            throw new ReportedException(crashreport);
        }
    }

    private <T extends IParticleData> void func_195467_a(T particleData, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
        this.func_195461_a(particleData, particleData.func_197554_b().func_197575_f(), x, y, z, xSpeed, ySpeed, zSpeed);
    }

    @Nullable
    private Particle func_195471_b(IParticleData particleData, boolean alwaysRender, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
        return this.func_195469_b(particleData, alwaysRender, false, x, y, z, xSpeed, ySpeed, zSpeed);
    }

    @Nullable
    private Particle func_195469_b(IParticleData particleData, boolean alwaysRender, boolean minimizeLevel, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
        ActiveRenderInfo activerenderinfo = this.field_72777_q.field_71460_t.func_215316_n();
        if (this.field_72777_q != null && activerenderinfo.func_216786_h() && this.field_72777_q.field_71452_i != null) {
            ParticleStatus particlestatus = this.func_215327_a(minimizeLevel);
            if (alwaysRender) {
                return this.field_72777_q.field_71452_i.func_199280_a(particleData, x, y, z, xSpeed, ySpeed, zSpeed);
            }
            if (activerenderinfo.func_216785_c().func_186679_c(x, y, z) > 1024.0) {
                return null;
            }
            return particlestatus == ParticleStatus.MINIMAL ? null : this.field_72777_q.field_71452_i.func_199280_a(particleData, x, y, z, xSpeed, ySpeed, zSpeed);
        }
        return null;
    }

    private ParticleStatus func_215327_a(boolean minimiseLevel) {
        ParticleStatus particlestatus = this.field_72777_q.field_71474_y.field_74362_aa;
        if (minimiseLevel && particlestatus == ParticleStatus.MINIMAL && this.field_72769_h.field_73012_v.nextInt(10) == 0) {
            particlestatus = ParticleStatus.DECREASED;
        }
        if (particlestatus == ParticleStatus.DECREASED && this.field_72769_h.field_73012_v.nextInt(3) == 0) {
            particlestatus = ParticleStatus.MINIMAL;
        }
        return particlestatus;
    }

    public void func_72728_f() {
    }

    public void func_180440_a(int soundID, BlockPos pos, int data) {
        switch (soundID) {
            case 1023: 
            case 1028: 
            case 1038: {
                ActiveRenderInfo activerenderinfo = this.field_72777_q.field_71460_t.func_215316_n();
                if (!activerenderinfo.func_216786_h()) break;
                double d0 = (double)pos.func_177958_n() - activerenderinfo.func_216785_c().field_72450_a;
                double d1 = (double)pos.func_177956_o() - activerenderinfo.func_216785_c().field_72448_b;
                double d2 = (double)pos.func_177952_p() - activerenderinfo.func_216785_c().field_72449_c;
                double d3 = Math.sqrt(d0 * d0 + d1 * d1 + d2 * d2);
                double d4 = activerenderinfo.func_216785_c().field_72450_a;
                double d5 = activerenderinfo.func_216785_c().field_72448_b;
                double d6 = activerenderinfo.func_216785_c().field_72449_c;
                if (d3 > 0.0) {
                    d4 += d0 / d3 * 2.0;
                    d5 += d1 / d3 * 2.0;
                    d6 += d2 / d3 * 2.0;
                }
                if (soundID == 1023) {
                    this.field_72769_h.func_184134_a(d4, d5, d6, SoundEvents.field_187855_gD, SoundCategory.HOSTILE, 1.0f, 1.0f, false);
                    break;
                }
                if (soundID == 1038) {
                    this.field_72769_h.func_184134_a(d4, d5, d6, SoundEvents.field_193782_bq, SoundCategory.HOSTILE, 1.0f, 1.0f, false);
                    break;
                }
                this.field_72769_h.func_184134_a(d4, d5, d6, SoundEvents.field_187522_aL, SoundCategory.HOSTILE, 5.0f, 1.0f, false);
            }
        }
    }

    public void func_180439_a(PlayerEntity player, int type, BlockPos blockPosIn, int data) {
        Random random = this.field_72769_h.field_73012_v;
        switch (type) {
            case 1000: {
                this.field_72769_h.func_184156_a(blockPosIn, SoundEvents.field_187574_as, SoundCategory.BLOCKS, 1.0f, 1.0f, false);
                break;
            }
            case 1001: {
                this.field_72769_h.func_184156_a(blockPosIn, SoundEvents.field_187576_at, SoundCategory.BLOCKS, 1.0f, 1.2f, false);
                break;
            }
            case 1002: {
                this.field_72769_h.func_184156_a(blockPosIn, SoundEvents.field_187578_au, SoundCategory.BLOCKS, 1.0f, 1.2f, false);
                break;
            }
            case 1003: {
                this.field_72769_h.func_184156_a(blockPosIn, SoundEvents.field_187528_aR, SoundCategory.NEUTRAL, 1.0f, 1.2f, false);
                break;
            }
            case 1004: {
                this.field_72769_h.func_184156_a(blockPosIn, SoundEvents.field_187634_bp, SoundCategory.NEUTRAL, 1.0f, 1.2f, false);
                break;
            }
            case 1005: {
                this.field_72769_h.func_184156_a(blockPosIn, SoundEvents.field_187611_cI, SoundCategory.BLOCKS, 1.0f, random.nextFloat() * 0.1f + 0.9f, false);
                break;
            }
            case 1006: {
                this.field_72769_h.func_184156_a(blockPosIn, SoundEvents.field_187875_gN, SoundCategory.BLOCKS, 1.0f, random.nextFloat() * 0.1f + 0.9f, false);
                break;
            }
            case 1007: {
                this.field_72769_h.func_184156_a(blockPosIn, SoundEvents.field_187879_gP, SoundCategory.BLOCKS, 1.0f, random.nextFloat() * 0.1f + 0.9f, false);
                break;
            }
            case 1008: {
                this.field_72769_h.func_184156_a(blockPosIn, SoundEvents.field_187613_bi, SoundCategory.BLOCKS, 1.0f, random.nextFloat() * 0.1f + 0.9f, false);
                break;
            }
            case 1009: {
                this.field_72769_h.func_184156_a(blockPosIn, SoundEvents.field_187646_bt, SoundCategory.BLOCKS, 0.5f, 2.6f + (random.nextFloat() - random.nextFloat()) * 0.8f, false);
                break;
            }
            case 1010: {
                if (Item.func_150899_d(data) instanceof MusicDiscItem) {
                    this.playRecord(((MusicDiscItem)Item.func_150899_d(data)).func_185075_h(), blockPosIn, (MusicDiscItem)Item.func_150899_d(data));
                    break;
                }
                this.func_184377_a(null, blockPosIn);
                break;
            }
            case 1011: {
                this.field_72769_h.func_184156_a(blockPosIn, SoundEvents.field_187608_cH, SoundCategory.BLOCKS, 1.0f, random.nextFloat() * 0.1f + 0.9f, false);
                break;
            }
            case 1012: {
                this.field_72769_h.func_184156_a(blockPosIn, SoundEvents.field_187873_gM, SoundCategory.BLOCKS, 1.0f, random.nextFloat() * 0.1f + 0.9f, false);
                break;
            }
            case 1013: {
                this.field_72769_h.func_184156_a(blockPosIn, SoundEvents.field_187877_gO, SoundCategory.BLOCKS, 1.0f, random.nextFloat() * 0.1f + 0.9f, false);
                break;
            }
            case 1014: {
                this.field_72769_h.func_184156_a(blockPosIn, SoundEvents.field_187610_bh, SoundCategory.BLOCKS, 1.0f, random.nextFloat() * 0.1f + 0.9f, false);
                break;
            }
            case 1015: {
                this.field_72769_h.func_184156_a(blockPosIn, SoundEvents.field_187559_bL, SoundCategory.HOSTILE, 10.0f, (random.nextFloat() - random.nextFloat()) * 0.2f + 1.0f, false);
                break;
            }
            case 1016: {
                this.field_72769_h.func_184156_a(blockPosIn, SoundEvents.field_187557_bK, SoundCategory.HOSTILE, 10.0f, (random.nextFloat() - random.nextFloat()) * 0.2f + 1.0f, false);
                break;
            }
            case 1017: {
                this.field_72769_h.func_184156_a(blockPosIn, SoundEvents.field_187527_aQ, SoundCategory.HOSTILE, 10.0f, (random.nextFloat() - random.nextFloat()) * 0.2f + 1.0f, false);
                break;
            }
            case 1018: {
                this.field_72769_h.func_184156_a(blockPosIn, SoundEvents.field_187606_E, SoundCategory.HOSTILE, 2.0f, (random.nextFloat() - random.nextFloat()) * 0.2f + 1.0f, false);
                break;
            }
            case 1019: {
                this.field_72769_h.func_184156_a(blockPosIn, SoundEvents.field_187927_ha, SoundCategory.HOSTILE, 2.0f, (random.nextFloat() - random.nextFloat()) * 0.2f + 1.0f, false);
                break;
            }
            case 1020: {
                this.field_72769_h.func_184156_a(blockPosIn, SoundEvents.field_187928_hb, SoundCategory.HOSTILE, 2.0f, (random.nextFloat() - random.nextFloat()) * 0.2f + 1.0f, false);
                break;
            }
            case 1021: {
                this.field_72769_h.func_184156_a(blockPosIn, SoundEvents.field_187929_hc, SoundCategory.HOSTILE, 2.0f, (random.nextFloat() - random.nextFloat()) * 0.2f + 1.0f, false);
                break;
            }
            case 1022: {
                this.field_72769_h.func_184156_a(blockPosIn, SoundEvents.field_187926_gz, SoundCategory.HOSTILE, 2.0f, (random.nextFloat() - random.nextFloat()) * 0.2f + 1.0f, false);
                break;
            }
            case 1024: {
                this.field_72769_h.func_184156_a(blockPosIn, SoundEvents.field_187853_gC, SoundCategory.HOSTILE, 2.0f, (random.nextFloat() - random.nextFloat()) * 0.2f + 1.0f, false);
                break;
            }
            case 1025: {
                this.field_72769_h.func_184156_a(blockPosIn, SoundEvents.field_187744_z, SoundCategory.NEUTRAL, 0.05f, (random.nextFloat() - random.nextFloat()) * 0.2f + 1.0f, false);
                break;
            }
            case 1026: {
                this.field_72769_h.func_184156_a(blockPosIn, SoundEvents.field_187945_hs, SoundCategory.HOSTILE, 2.0f, (random.nextFloat() - random.nextFloat()) * 0.2f + 1.0f, false);
                break;
            }
            case 1027: {
                this.field_72769_h.func_184156_a(blockPosIn, SoundEvents.field_187941_ho, SoundCategory.NEUTRAL, 2.0f, (random.nextFloat() - random.nextFloat()) * 0.2f + 1.0f, false);
                break;
            }
            case 1029: {
                this.field_72769_h.func_184156_a(blockPosIn, SoundEvents.field_187680_c, SoundCategory.BLOCKS, 1.0f, random.nextFloat() * 0.1f + 0.9f, false);
                break;
            }
            case 1030: {
                this.field_72769_h.func_184156_a(blockPosIn, SoundEvents.field_187698_i, SoundCategory.BLOCKS, 1.0f, random.nextFloat() * 0.1f + 0.9f, false);
                break;
            }
            case 1031: {
                this.field_72769_h.func_184156_a(blockPosIn, SoundEvents.field_187689_f, SoundCategory.BLOCKS, 0.3f, this.field_72769_h.field_73012_v.nextFloat() * 0.1f + 0.9f, false);
                break;
            }
            case 1032: {
                this.field_72777_q.func_147118_V().func_147682_a((ISound)SimpleSound.func_239532_b_((SoundEvent)SoundEvents.field_187812_eh, (float)(random.nextFloat() * 0.4f + 0.8f), (float)0.25f));
                break;
            }
            case 1033: {
                this.field_72769_h.func_184156_a(blockPosIn, SoundEvents.field_187542_ac, SoundCategory.BLOCKS, 1.0f, 1.0f, false);
                break;
            }
            case 1034: {
                this.field_72769_h.func_184156_a(blockPosIn, SoundEvents.field_187540_ab, SoundCategory.BLOCKS, 1.0f, 1.0f, false);
                break;
            }
            case 1035: {
                this.field_72769_h.func_184156_a(blockPosIn, SoundEvents.field_187621_J, SoundCategory.BLOCKS, 1.0f, 1.0f, false);
                break;
            }
            case 1036: {
                this.field_72769_h.func_184156_a(blockPosIn, SoundEvents.field_187614_cJ, SoundCategory.BLOCKS, 1.0f, random.nextFloat() * 0.1f + 0.9f, false);
                break;
            }
            case 1037: {
                this.field_72769_h.func_184156_a(blockPosIn, SoundEvents.field_187617_cK, SoundCategory.BLOCKS, 1.0f, random.nextFloat() * 0.1f + 0.9f, false);
                break;
            }
            case 1039: {
                this.field_72769_h.func_184156_a(blockPosIn, SoundEvents.field_203257_fu, SoundCategory.HOSTILE, 0.3f, this.field_72769_h.field_73012_v.nextFloat() * 0.1f + 0.9f, false);
                break;
            }
            case 1040: {
                this.field_72769_h.func_184156_a(blockPosIn, SoundEvents.field_204783_kG, SoundCategory.NEUTRAL, 2.0f, (random.nextFloat() - random.nextFloat()) * 0.2f + 1.0f, false);
                break;
            }
            case 1041: {
                this.field_72769_h.func_184156_a(blockPosIn, SoundEvents.field_207378_dT, SoundCategory.NEUTRAL, 2.0f, (random.nextFloat() - random.nextFloat()) * 0.2f + 1.0f, false);
                break;
            }
            case 1042: {
                this.field_72769_h.func_184156_a(blockPosIn, SoundEvents.field_219642_eu, SoundCategory.BLOCKS, 1.0f, this.field_72769_h.field_73012_v.nextFloat() * 0.1f + 0.9f, false);
                break;
            }
            case 1043: {
                this.field_72769_h.func_184156_a(blockPosIn, SoundEvents.field_219617_ah, SoundCategory.BLOCKS, 1.0f, this.field_72769_h.field_73012_v.nextFloat() * 0.1f + 0.9f, false);
                break;
            }
            case 1044: {
                this.field_72769_h.func_184156_a(blockPosIn, SoundEvents.field_232842_og_, SoundCategory.BLOCKS, 1.0f, this.field_72769_h.field_73012_v.nextFloat() * 0.1f + 0.9f, false);
                break;
            }
            case 1500: {
                ComposterBlock.func_220292_a((World)this.field_72769_h, (BlockPos)blockPosIn, (data > 0 ? 1 : 0) != 0);
                break;
            }
            case 1501: {
                this.field_72769_h.func_184156_a(blockPosIn, SoundEvents.field_187659_cY, SoundCategory.BLOCKS, 0.5f, 2.6f + (random.nextFloat() - random.nextFloat()) * 0.8f, false);
                for (int i2 = 0; i2 < 8; ++i2) {
                    this.field_72769_h.func_195594_a((IParticleData)ParticleTypes.field_197594_E, (double)blockPosIn.func_177958_n() + random.nextDouble(), (double)blockPosIn.func_177956_o() + 1.2, (double)blockPosIn.func_177952_p() + random.nextDouble(), 0.0, 0.0, 0.0);
                }
                break;
            }
            case 1502: {
                this.field_72769_h.func_184156_a(blockPosIn, SoundEvents.field_187745_eA, SoundCategory.BLOCKS, 0.5f, 2.6f + (random.nextFloat() - random.nextFloat()) * 0.8f, false);
                for (int l1 = 0; l1 < 5; ++l1) {
                    double d15 = (double)blockPosIn.func_177958_n() + random.nextDouble() * 0.6 + 0.2;
                    double d20 = (double)blockPosIn.func_177956_o() + random.nextDouble() * 0.6 + 0.2;
                    double d26 = (double)blockPosIn.func_177952_p() + random.nextDouble() * 0.6 + 0.2;
                    this.field_72769_h.func_195594_a((IParticleData)ParticleTypes.field_197601_L, d15, d20, d26, 0.0, 0.0, 0.0);
                }
                break;
            }
            case 1503: {
                this.field_72769_h.func_184156_a(blockPosIn, SoundEvents.field_193781_bp, SoundCategory.BLOCKS, 1.0f, 1.0f, false);
                for (int k1 = 0; k1 < 16; ++k1) {
                    double d14 = (double)blockPosIn.func_177958_n() + (5.0 + random.nextDouble() * 6.0) / 16.0;
                    double d19 = (double)blockPosIn.func_177956_o() + 0.8125;
                    double d25 = (double)blockPosIn.func_177952_p() + (5.0 + random.nextDouble() * 6.0) / 16.0;
                    this.field_72769_h.func_195594_a((IParticleData)ParticleTypes.field_197601_L, d14, d19, d25, 0.0, 0.0, 0.0);
                }
                break;
            }
            case 2000: {
                Direction direction = Direction.func_82600_a(data);
                int j1 = direction.func_82601_c();
                int j2 = direction.func_96559_d();
                int k2 = direction.func_82599_e();
                double d18 = (double)blockPosIn.func_177958_n() + (double)j1 * 0.6 + 0.5;
                double d24 = (double)blockPosIn.func_177956_o() + (double)j2 * 0.6 + 0.5;
                double d28 = (double)blockPosIn.func_177952_p() + (double)k2 * 0.6 + 0.5;
                for (int i3 = 0; i3 < 10; ++i3) {
                    double d4 = random.nextDouble() * 0.2 + 0.01;
                    double d6 = d18 + (double)j1 * 0.01 + (random.nextDouble() - 0.5) * (double)k2 * 0.5;
                    double d8 = d24 + (double)j2 * 0.01 + (random.nextDouble() - 0.5) * (double)j2 * 0.5;
                    double d30 = d28 + (double)k2 * 0.01 + (random.nextDouble() - 0.5) * (double)j1 * 0.5;
                    double d9 = (double)j1 * d4 + random.nextGaussian() * 0.01;
                    double d10 = (double)j2 * d4 + random.nextGaussian() * 0.01;
                    double d11 = (double)k2 * d4 + random.nextGaussian() * 0.01;
                    this.func_195467_a(ParticleTypes.field_197601_L, d6, d8, d30, d9, d10, d11);
                }
                break;
            }
            case 2001: {
                BlockState blockstate = Block.func_196257_b(data);
                if (!blockstate.isAir((IBlockReader)((Object)this.field_72769_h), blockPosIn)) {
                    SoundType soundtype = blockstate.getSoundType((IWorldReader)((Object)this.field_72769_h), blockPosIn, null);
                    this.field_72769_h.func_184156_a(blockPosIn, soundtype.func_185845_c(), SoundCategory.BLOCKS, (soundtype.func_185843_a() + 1.0f) / 2.0f, soundtype.func_185847_b() * 0.8f, false);
                }
                this.field_72777_q.field_71452_i.func_180533_a(blockPosIn, blockstate);
                break;
            }
            case 2002: 
            case 2007: {
                Vector3d vector3d = Vector3d.func_237492_c_((Vector3i)blockPosIn);
                for (int i1 = 0; i1 < 8; ++i1) {
                    this.func_195467_a(new ItemParticleData(ParticleTypes.field_197591_B, new ItemStack(Items.field_185155_bH)), vector3d.field_72450_a, vector3d.field_72448_b, vector3d.field_72449_c, random.nextGaussian() * 0.15, random.nextDouble() * 0.2, random.nextGaussian() * 0.15);
                }
                float f3 = (float)(data >> 16 & 0xFF) / 255.0f;
                float f4 = (float)(data >> 8 & 0xFF) / 255.0f;
                float f5 = (float)(data >> 0 & 0xFF) / 255.0f;
                BasicParticleType iparticledata = type == 2007 ? ParticleTypes.field_197590_A : ParticleTypes.field_197620_m;
                for (int j = 0; j < 100; ++j) {
                    double d23 = random.nextDouble() * 4.0;
                    double d27 = random.nextDouble() * Math.PI * 2.0;
                    double d29 = Math.cos(d27) * d23;
                    double d5 = 0.01 + random.nextDouble() * 0.5;
                    double d7 = Math.sin(d27) * d23;
                    Particle particle1 = this.func_195471_b((IParticleData)iparticledata, iparticledata.func_197554_b().func_197575_f(), vector3d.field_72450_a + d29 * 0.1, vector3d.field_72448_b + 0.3, vector3d.field_72449_c + d7 * 0.1, d29, d5, d7);
                    if (particle1 == null) continue;
                    float f2 = 0.75f + random.nextFloat() * 0.25f;
                    particle1.func_70538_b(f3 * f2, f4 * f2, f5 * f2);
                    particle1.func_70543_e((float)d23);
                }
                this.field_72769_h.func_184156_a(blockPosIn, SoundEvents.field_187825_fO, SoundCategory.NEUTRAL, 1.0f, random.nextFloat() * 0.1f + 0.9f, false);
                break;
            }
            case 2003: {
                double d0 = (double)blockPosIn.func_177958_n() + 0.5;
                double d13 = blockPosIn.func_177956_o();
                double d17 = (double)blockPosIn.func_177952_p() + 0.5;
                for (int l2 = 0; l2 < 8; ++l2) {
                    this.func_195467_a(new ItemParticleData(ParticleTypes.field_197591_B, new ItemStack(Items.field_151061_bv)), d0, d13, d17, random.nextGaussian() * 0.15, random.nextDouble() * 0.2, random.nextGaussian() * 0.15);
                }
                for (double d22 = 0.0; d22 < Math.PI * 2; d22 += 0.15707963267948966) {
                    this.func_195467_a(ParticleTypes.field_197599_J, d0 + Math.cos(d22) * 5.0, d13 - 0.4, d17 + Math.sin(d22) * 5.0, Math.cos(d22) * -5.0, 0.0, Math.sin(d22) * -5.0);
                    this.func_195467_a(ParticleTypes.field_197599_J, d0 + Math.cos(d22) * 5.0, d13 - 0.4, d17 + Math.sin(d22) * 5.0, Math.cos(d22) * -7.0, 0.0, Math.sin(d22) * -7.0);
                }
                break;
            }
            case 2004: {
                for (int l = 0; l < 20; ++l) {
                    double d12 = (double)blockPosIn.func_177958_n() + 0.5 + (random.nextDouble() - 0.5) * 2.0;
                    double d16 = (double)blockPosIn.func_177956_o() + 0.5 + (random.nextDouble() - 0.5) * 2.0;
                    double d21 = (double)blockPosIn.func_177952_p() + 0.5 + (random.nextDouble() - 0.5) * 2.0;
                    this.field_72769_h.func_195594_a((IParticleData)ParticleTypes.field_197601_L, d12, d16, d21, 0.0, 0.0, 0.0);
                    this.field_72769_h.func_195594_a((IParticleData)ParticleTypes.field_197631_x, d12, d16, d21, 0.0, 0.0, 0.0);
                }
                break;
            }
            case 2005: {
                BoneMealItem.func_195965_a(this.field_72769_h, blockPosIn, data);
                break;
            }
            case 2006: {
                for (int k = 0; k < 200; ++k) {
                    float f = random.nextFloat() * 4.0f;
                    float f1 = random.nextFloat() * ((float)Math.PI * 2);
                    double d1 = MathHelper.func_76134_b((float)f1) * f;
                    double d2 = 0.01 + random.nextDouble() * 0.5;
                    double d3 = MathHelper.func_76126_a((float)f1) * f;
                    Particle particle = this.func_195471_b((IParticleData)ParticleTypes.field_197616_i, false, (double)blockPosIn.func_177958_n() + d1 * 0.1, (double)blockPosIn.func_177956_o() + 0.3, (double)blockPosIn.func_177952_p() + d3 * 0.1, d1, d2, d3);
                    if (particle == null) continue;
                    particle.func_70543_e(f);
                }
                if (data != 1) break;
                this.field_72769_h.func_184156_a(blockPosIn, SoundEvents.field_187523_aM, SoundCategory.HOSTILE, 1.0f, random.nextFloat() * 0.1f + 0.9f, false);
                break;
            }
            case 2008: {
                this.field_72769_h.func_195594_a((IParticleData)ParticleTypes.field_197627_t, (double)blockPosIn.func_177958_n() + 0.5, (double)blockPosIn.func_177956_o() + 0.5, (double)blockPosIn.func_177952_p() + 0.5, 0.0, 0.0, 0.0);
                break;
            }
            case 2009: {
                for (int i = 0; i < 8; ++i) {
                    this.field_72769_h.func_195594_a((IParticleData)ParticleTypes.field_197613_f, (double)blockPosIn.func_177958_n() + random.nextDouble(), (double)blockPosIn.func_177956_o() + 1.2, (double)blockPosIn.func_177952_p() + random.nextDouble(), 0.0, 0.0, 0.0);
                }
                break;
            }
            case 3000: {
                this.field_72769_h.func_195590_a((IParticleData)ParticleTypes.field_197626_s, true, (double)blockPosIn.func_177958_n() + 0.5, (double)blockPosIn.func_177956_o() + 0.5, (double)blockPosIn.func_177952_p() + 0.5, 0.0, 0.0, 0.0);
                this.field_72769_h.func_184156_a(blockPosIn, SoundEvents.field_187598_bd, SoundCategory.BLOCKS, 10.0f, (1.0f + (this.field_72769_h.field_73012_v.nextFloat() - this.field_72769_h.field_73012_v.nextFloat()) * 0.2f) * 0.7f, false);
                break;
            }
            case 3001: {
                this.field_72769_h.func_184156_a(blockPosIn, SoundEvents.field_187525_aO, SoundCategory.HOSTILE, 64.0f, 0.8f + this.field_72769_h.field_73012_v.nextFloat() * 0.3f, false);
            }
        }
    }

    public void func_180441_b(int breakerId, BlockPos pos, int progress) {
        if (progress >= 0 && progress < 10) {
            DestroyBlockProgress destroyblockprogress1 = (DestroyBlockProgress)this.field_72738_E.get(breakerId);
            if (destroyblockprogress1 != null) {
                this.func_228442_a_(destroyblockprogress1);
            }
            if (destroyblockprogress1 == null || destroyblockprogress1.func_180246_b().func_177958_n() != pos.func_177958_n() || destroyblockprogress1.func_180246_b().func_177956_o() != pos.func_177956_o() || destroyblockprogress1.func_180246_b().func_177952_p() != pos.func_177952_p()) {
                destroyblockprogress1 = new DestroyBlockProgress(breakerId, pos);
                this.field_72738_E.put(breakerId, (Object)destroyblockprogress1);
            }
            destroyblockprogress1.func_73107_a(progress);
            destroyblockprogress1.func_82744_b(this.field_72773_u);
            ((SortedSet)this.field_228407_B_.computeIfAbsent(destroyblockprogress1.func_180246_b().func_218275_a(), p_230017_0_ -> Sets.newTreeSet())).add(destroyblockprogress1);
        } else {
            DestroyBlockProgress destroyblockprogress = (DestroyBlockProgress)this.field_72738_E.remove(breakerId);
            if (destroyblockprogress != null) {
                this.func_228442_a_(destroyblockprogress);
            }
        }
    }

    public boolean func_184384_n() {
        return this.field_175009_l.isEmpty() && this.field_174995_M.func_188247_f();
    }

    public void func_174979_m() {
        this.field_147595_R = true;
        this.field_204607_y = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void func_181023_a(Collection<TileEntity> tileEntitiesToRemove, Collection<TileEntity> tileEntitiesToAdd) {
        Set<TileEntity> set = this.field_181024_n;
        synchronized (set) {
            this.field_181024_n.removeAll(tileEntitiesToRemove);
            this.field_181024_n.addAll(tileEntitiesToAdd);
        }
    }

    public static int func_228421_a_(IBlockDisplayReader lightReaderIn, BlockPos blockPosIn) {
        return WorldRenderer.func_228420_a_(lightReaderIn, lightReaderIn.func_180495_p(blockPosIn), blockPosIn);
    }

    public static int func_228420_a_(IBlockDisplayReader lightReaderIn, BlockState blockStateIn, BlockPos blockPosIn) {
        int k;
        if (blockStateIn.func_227035_k_((IBlockReader)lightReaderIn, blockPosIn)) {
            return 0xF000F0;
        }
        int i = lightReaderIn.func_226658_a_(LightType.SKY, blockPosIn);
        int j = lightReaderIn.func_226658_a_(LightType.BLOCK, blockPosIn);
        if (j < (k = blockStateIn.getLightValue((IBlockReader)lightReaderIn, blockPosIn))) {
            j = k;
        }
        return i << 20 | j << 4;
    }

    @Nullable
    public Framebuffer func_228448_p_() {
        return this.field_175015_z;
    }

    @Nullable
    public Framebuffer func_239228_q_() {
        return this.field_239222_F_;
    }

    @Nullable
    public Framebuffer func_239229_r_() {
        return this.field_239223_G_;
    }

    @Nullable
    public Framebuffer func_239230_s_() {
        return this.field_239224_H_;
    }

    @Nullable
    public Framebuffer func_239231_t_() {
        return this.field_239225_I_;
    }

    @Nullable
    public Framebuffer func_239232_u_() {
        return this.field_239226_J_;
    }

    @Override
    public IResourceType getResourceType() {
        return VanillaResourceType.MODELS;
    }

    private static /* synthetic */ IVertexBuilder lambda$updateCameraAndRender$1(IRenderTypeBuffer.Impl irendertypebuffer$impl, IVertexBuilder ivertexbuilder, RenderType p_230014_2_) {
        IVertexBuilder ivertexbuilder3 = irendertypebuffer$impl.getBuffer(p_230014_2_);
        return p_230014_2_.func_228665_s_() ? VertexBuilderUtils.func_227915_a_((IVertexBuilder)ivertexbuilder, (IVertexBuilder)ivertexbuilder3) : ivertexbuilder3;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class ShaderException
    extends RuntimeException {
        public ShaderException(String p_i232463_1_, Throwable p_i232463_2_) {
            super(p_i232463_1_, p_i232463_2_);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    class LocalRenderInformationContainer {
        private final ChunkRenderDispatcher.ChunkRender field_178036_a;
        private final Direction field_178034_b;
        private byte field_178035_c;
        private final int field_178032_d;

        private LocalRenderInformationContainer(@Nullable ChunkRenderDispatcher.ChunkRender renderChunkIn, Direction facingIn, int counterIn) {
            this.field_178036_a = renderChunkIn;
            this.field_178034_b = facingIn;
            this.field_178032_d = counterIn;
        }

        public void func_189561_a(byte dir, Direction facingIn) {
            this.field_178035_c = (byte)(this.field_178035_c | dir | 1 << facingIn.ordinal());
        }

        public boolean func_189560_a(Direction facingIn) {
            return (this.field_178035_c & 1 << facingIn.ordinal()) > 0;
        }
    }
}

