/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer;

import com.google.common.collect.Sets;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import com.mojang.blaze3d.vertex.MatrixApplyingVertexBuilder;
import com.mojang.blaze3d.vertex.VertexBuilderUtils;
import java.util.List;
import java.util.Random;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BreakableBlock;
import net.minecraft.block.StainedGlassPaneBlock;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.ItemModelMesher;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.color.ItemColors;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.model.ModelManager;
import net.minecraft.client.renderer.model.ModelResourceLocation;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.crash.ICrashReportDetail;
import net.minecraft.crash.ReportedException;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.resources.IResourceManager;
import net.minecraft.resources.IResourceManagerReloadListener;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.ItemModelMesherForge;
import net.minecraftforge.resource.IResourceType;
import net.minecraftforge.resource.VanillaResourceType;

@OnlyIn(value=Dist.CLIENT)
public class ItemRenderer
implements IResourceManagerReloadListener {
    public static final ResourceLocation field_110798_h = new ResourceLocation("textures/misc/enchanted_item_glint.png");
    private static final Set<Item> field_195411_c = Sets.newHashSet((Object[])new Item[]{Items.field_190931_a});
    public float field_77023_b;
    private final ItemModelMesher field_175059_m;
    private final TextureManager field_175057_n;
    private final ItemColors field_184395_f;

    public ItemRenderer(TextureManager textureManagerIn, ModelManager modelManagerIn, ItemColors itemColorsIn) {
        this.field_175057_n = textureManagerIn;
        this.field_175059_m = new ItemModelMesherForge(modelManagerIn);
        for (Item item : Registry.field_212630_s) {
            if (field_195411_c.contains((Object)item)) continue;
            this.field_175059_m.func_199311_a(item, new ModelResourceLocation(Registry.field_212630_s.func_177774_c((Object)item), "inventory"));
        }
        this.field_184395_f = itemColorsIn;
    }

    public ItemModelMesher func_175037_a() {
        return this.field_175059_m;
    }

    private void func_229114_a_(IBakedModel modelIn, ItemStack stack, int combinedLightIn, int combinedOverlayIn, MatrixStack matrixStackIn, IVertexBuilder bufferIn) {
        Random random = new Random();
        long i = 42L;
        for (Direction direction : Direction.values()) {
            random.setSeed(42L);
            this.func_229112_a_(matrixStackIn, bufferIn, modelIn.func_200117_a(null, direction, random), stack, combinedLightIn, combinedOverlayIn);
        }
        random.setSeed(42L);
        this.func_229112_a_(matrixStackIn, bufferIn, modelIn.func_200117_a(null, null, random), stack, combinedLightIn, combinedOverlayIn);
    }

    public void func_229111_a_(ItemStack itemStackIn, ItemCameraTransforms.TransformType transformTypeIn, boolean leftHand, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int combinedLightIn, int combinedOverlayIn, IBakedModel modelIn) {
        if (!itemStackIn.func_190926_b()) {
            boolean flag;
            matrixStackIn.func_227860_a_();
            boolean bl = flag = transformTypeIn == ItemCameraTransforms.TransformType.GUI || transformTypeIn == ItemCameraTransforms.TransformType.GROUND || transformTypeIn == ItemCameraTransforms.TransformType.FIXED;
            if (itemStackIn.func_77973_b() == Items.field_203184_eO && flag) {
                modelIn = this.field_175059_m.func_178083_a().func_174953_a(new ModelResourceLocation("minecraft:trident#inventory"));
            }
            modelIn = ForgeHooksClient.handleCameraTransforms((MatrixStack)matrixStackIn, (IBakedModel)modelIn, (ItemCameraTransforms.TransformType)transformTypeIn, (boolean)leftHand);
            matrixStackIn.func_227861_a_(-0.5, -0.5, -0.5);
            if (!modelIn.func_188618_c() && (itemStackIn.func_77973_b() != Items.field_203184_eO || flag)) {
                IVertexBuilder ivertexbuilder;
                Block block;
                boolean flag1 = transformTypeIn != ItemCameraTransforms.TransformType.GUI && !transformTypeIn.func_241716_a_() && itemStackIn.func_77973_b() instanceof BlockItem ? !((block = ((BlockItem)itemStackIn.func_77973_b()).func_179223_d()) instanceof BreakableBlock) && !(block instanceof StainedGlassPaneBlock) : true;
                RenderType rendertype = RenderTypeLookup.func_239219_a_(itemStackIn, flag1);
                if (itemStackIn.func_77973_b() == Items.field_151111_aL && itemStackIn.func_77962_s()) {
                    matrixStackIn.func_227860_a_();
                    MatrixStack.Entry matrixstack$entry = matrixStackIn.func_227866_c_();
                    if (transformTypeIn == ItemCameraTransforms.TransformType.GUI) {
                        matrixstack$entry.func_227870_a_().func_226592_a_(0.5f);
                    } else if (transformTypeIn.func_241716_a_()) {
                        matrixstack$entry.func_227870_a_().func_226592_a_(0.75f);
                    }
                    ivertexbuilder = flag1 ? ItemRenderer.func_241732_b_(bufferIn, rendertype, matrixstack$entry) : ItemRenderer.func_241731_a_(bufferIn, rendertype, matrixstack$entry);
                    matrixStackIn.func_227865_b_();
                } else {
                    ivertexbuilder = flag1 ? ItemRenderer.func_239391_c_(bufferIn, rendertype, true, itemStackIn.func_77962_s()) : ItemRenderer.func_229113_a_(bufferIn, rendertype, true, itemStackIn.func_77962_s());
                }
                this.func_229114_a_(modelIn, itemStackIn, combinedLightIn, combinedOverlayIn, matrixStackIn, ivertexbuilder);
            } else {
                itemStackIn.func_77973_b().getItemStackTileEntityRenderer().func_239207_a_(itemStackIn, transformTypeIn, matrixStackIn, bufferIn, combinedLightIn, combinedOverlayIn);
            }
            matrixStackIn.func_227865_b_();
        }
    }

    public static IVertexBuilder func_239386_a_(IRenderTypeBuffer p_239386_0_, RenderType p_239386_1_, boolean p_239386_2_, boolean p_239386_3_) {
        return p_239386_3_ ? VertexBuilderUtils.func_227915_a_((IVertexBuilder)p_239386_0_.getBuffer(p_239386_2_ ? RenderType.func_239270_k_() : RenderType.func_239271_l_()), (IVertexBuilder)p_239386_0_.getBuffer(p_239386_1_)) : p_239386_0_.getBuffer(p_239386_1_);
    }

    public static IVertexBuilder func_241731_a_(IRenderTypeBuffer p_241731_0_, RenderType p_241731_1_, MatrixStack.Entry p_241731_2_) {
        return VertexBuilderUtils.func_227915_a_((IVertexBuilder)new MatrixApplyingVertexBuilder(p_241731_0_.getBuffer(RenderType.func_228653_j_()), p_241731_2_.func_227870_a_(), p_241731_2_.func_227872_b_()), (IVertexBuilder)p_241731_0_.getBuffer(p_241731_1_));
    }

    public static IVertexBuilder func_241732_b_(IRenderTypeBuffer p_241732_0_, RenderType p_241732_1_, MatrixStack.Entry p_241732_2_) {
        return VertexBuilderUtils.func_227915_a_((IVertexBuilder)new MatrixApplyingVertexBuilder(p_241732_0_.getBuffer(RenderType.func_239273_n_()), p_241732_2_.func_227870_a_(), p_241732_2_.func_227872_b_()), (IVertexBuilder)p_241732_0_.getBuffer(p_241732_1_));
    }

    public static IVertexBuilder func_229113_a_(IRenderTypeBuffer bufferIn, RenderType renderTypeIn, boolean isItemIn, boolean glintIn) {
        return glintIn ? VertexBuilderUtils.func_227915_a_((IVertexBuilder)bufferIn.getBuffer(isItemIn ? RenderType.func_228653_j_() : RenderType.func_228655_k_()), (IVertexBuilder)bufferIn.getBuffer(renderTypeIn)) : bufferIn.getBuffer(renderTypeIn);
    }

    public static IVertexBuilder func_239391_c_(IRenderTypeBuffer p_239391_0_, RenderType p_239391_1_, boolean p_239391_2_, boolean p_239391_3_) {
        return p_239391_3_ ? VertexBuilderUtils.func_227915_a_((IVertexBuilder)p_239391_0_.getBuffer(p_239391_2_ ? RenderType.func_239273_n_() : RenderType.func_239274_p_()), (IVertexBuilder)p_239391_0_.getBuffer(p_239391_1_)) : p_239391_0_.getBuffer(p_239391_1_);
    }

    public void func_229112_a_(MatrixStack matrixStackIn, IVertexBuilder bufferIn, List<BakedQuad> quadsIn, ItemStack itemStackIn, int combinedLightIn, int combinedOverlayIn) {
        boolean flag = !itemStackIn.func_190926_b();
        MatrixStack.Entry matrixstack$entry = matrixStackIn.func_227866_c_();
        for (BakedQuad bakedquad : quadsIn) {
            int i = -1;
            if (flag && bakedquad.func_178212_b()) {
                i = this.field_184395_f.func_186728_a(itemStackIn, bakedquad.func_178211_c());
            }
            float f = (float)(i >> 16 & 0xFF) / 255.0f;
            float f1 = (float)(i >> 8 & 0xFF) / 255.0f;
            float f2 = (float)(i & 0xFF) / 255.0f;
            bufferIn.addVertexData(matrixstack$entry, bakedquad, f, f1, f2, combinedLightIn, combinedOverlayIn, true);
        }
    }

    public IBakedModel func_184393_a(ItemStack stack, @Nullable World worldIn, @Nullable LivingEntity entitylivingbaseIn) {
        Item item = stack.func_77973_b();
        IBakedModel ibakedmodel = item == Items.field_203184_eO ? this.field_175059_m.func_178083_a().func_174953_a(new ModelResourceLocation("minecraft:trident_in_hand#inventory")) : this.field_175059_m.func_178089_a(stack);
        ClientWorld clientworld = worldIn instanceof ClientWorld ? (ClientWorld)worldIn : null;
        IBakedModel ibakedmodel1 = ibakedmodel.func_188617_f().func_239290_a_(ibakedmodel, stack, clientworld, entitylivingbaseIn);
        return ibakedmodel1 == null ? this.field_175059_m.func_178083_a().func_174951_a() : ibakedmodel1;
    }

    public void func_229110_a_(ItemStack itemStackIn, ItemCameraTransforms.TransformType transformTypeIn, int combinedLightIn, int combinedOverlayIn, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn) {
        this.func_229109_a_(null, itemStackIn, transformTypeIn, false, matrixStackIn, bufferIn, null, combinedLightIn, combinedOverlayIn);
    }

    public void func_229109_a_(@Nullable LivingEntity livingEntityIn, ItemStack itemStackIn, ItemCameraTransforms.TransformType transformTypeIn, boolean leftHand, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, @Nullable World worldIn, int combinedLightIn, int combinedOverlayIn) {
        if (!itemStackIn.func_190926_b()) {
            IBakedModel ibakedmodel = this.func_184393_a(itemStackIn, worldIn, livingEntityIn);
            this.func_229111_a_(itemStackIn, transformTypeIn, leftHand, matrixStackIn, bufferIn, combinedLightIn, combinedOverlayIn, ibakedmodel);
        }
    }

    public void func_175042_a(ItemStack stack, int x, int y) {
        this.func_191962_a(stack, x, y, this.func_184393_a(stack, null, null));
    }

    protected void func_191962_a(ItemStack stack, int x, int y, IBakedModel bakedmodel) {
        boolean flag;
        RenderSystem.pushMatrix();
        this.field_175057_n.func_110577_a(AtlasTexture.field_110575_b);
        this.field_175057_n.func_229267_b_(AtlasTexture.field_110575_b).func_174937_a(false, false);
        RenderSystem.enableRescaleNormal();
        RenderSystem.enableAlphaTest();
        RenderSystem.defaultAlphaFunc();
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.translatef((float)x, (float)y, (float)(100.0f + this.field_77023_b));
        RenderSystem.translatef((float)8.0f, (float)8.0f, (float)0.0f);
        RenderSystem.scalef((float)1.0f, (float)-1.0f, (float)1.0f);
        RenderSystem.scalef((float)16.0f, (float)16.0f, (float)16.0f);
        MatrixStack matrixstack = new MatrixStack();
        IRenderTypeBuffer.Impl irendertypebuffer$impl = Minecraft.func_71410_x().func_228019_au_().func_228487_b_();
        boolean bl = flag = !bakedmodel.func_230044_c_();
        if (flag) {
            RenderHelper.func_227783_c_();
        }
        this.func_229111_a_(stack, ItemCameraTransforms.TransformType.GUI, false, matrixstack, (IRenderTypeBuffer)irendertypebuffer$impl, 0xF000F0, OverlayTexture.field_229196_a_, bakedmodel);
        irendertypebuffer$impl.func_228461_a_();
        RenderSystem.enableDepthTest();
        if (flag) {
            RenderHelper.func_227784_d_();
        }
        RenderSystem.disableAlphaTest();
        RenderSystem.disableRescaleNormal();
        RenderSystem.popMatrix();
    }

    public void func_180450_b(ItemStack stack, int xPosition, int yPosition) {
        this.func_239387_b_(Minecraft.func_71410_x().field_71439_g, stack, xPosition, yPosition);
    }

    public void func_239390_c_(ItemStack p_239390_1_, int p_239390_2_, int p_239390_3_) {
        this.func_239387_b_(null, p_239390_1_, p_239390_2_, p_239390_3_);
    }

    public void func_184391_a(LivingEntity entityIn, ItemStack itemIn, int x, int y) {
        this.func_239387_b_(entityIn, itemIn, x, y);
    }

    private void func_239387_b_(@Nullable LivingEntity p_239387_1_, ItemStack p_239387_2_, int p_239387_3_, int p_239387_4_) {
        if (!p_239387_2_.func_190926_b()) {
            this.field_77023_b += 50.0f;
            try {
                this.func_191962_a(p_239387_2_, p_239387_3_, p_239387_4_, this.func_184393_a(p_239387_2_, null, p_239387_1_));
            }
            catch (Throwable throwable) {
                CrashReport crashreport = CrashReport.func_85055_a(throwable, "Rendering item");
                CrashReportCategory crashreportcategory = crashreport.func_85058_a("Item being rendered");
                crashreportcategory.func_189529_a("Item Type", (ICrashReportDetail<String>)((ICrashReportDetail)() -> String.valueOf((Object)p_239387_2_.func_77973_b())));
                crashreportcategory.func_189529_a("Registry Name", (ICrashReportDetail<String>)((ICrashReportDetail)() -> String.valueOf(p_239387_2_.func_77973_b().getRegistryName())));
                crashreportcategory.func_189529_a("Item Damage", (ICrashReportDetail<String>)((ICrashReportDetail)() -> String.valueOf(p_239387_2_.func_77952_i())));
                crashreportcategory.func_189529_a("Item NBT", (ICrashReportDetail<String>)((ICrashReportDetail)() -> String.valueOf(p_239387_2_.func_77978_p())));
                crashreportcategory.func_189529_a("Item Foil", (ICrashReportDetail<String>)((ICrashReportDetail)() -> String.valueOf(p_239387_2_.func_77962_s())));
                throw new ReportedException(crashreport);
            }
            this.field_77023_b -= 50.0f;
        }
    }

    public void func_175030_a(FontRenderer fr, ItemStack stack, int xPosition, int yPosition) {
        this.func_180453_a(fr, stack, xPosition, yPosition, null);
    }

    public void func_180453_a(FontRenderer fr, ItemStack stack, int xPosition, int yPosition, @Nullable String text) {
        if (!stack.func_190926_b()) {
            ClientPlayerEntity clientplayerentity;
            float f3;
            MatrixStack matrixstack = new MatrixStack();
            if (stack.func_190916_E() != 1 || text != null) {
                String s = text == null ? String.valueOf(stack.func_190916_E()) : text;
                matrixstack.func_227861_a_(0.0, 0.0, (double)(this.field_77023_b + 200.0f));
                IRenderTypeBuffer.Impl irendertypebuffer$impl = IRenderTypeBuffer.func_228455_a_((BufferBuilder)Tessellator.func_178181_a().func_178180_c());
                fr.func_228079_a_(s, (float)(xPosition + 19 - 2 - fr.func_78256_a(s)), (float)(yPosition + 6 + 3), 0xFFFFFF, true, matrixstack.func_227866_c_().func_227870_a_(), (IRenderTypeBuffer)irendertypebuffer$impl, false, 0, 0xF000F0);
                irendertypebuffer$impl.func_228461_a_();
            }
            if (stack.func_77973_b().showDurabilityBar(stack)) {
                RenderSystem.disableDepthTest();
                RenderSystem.disableTexture();
                RenderSystem.disableAlphaTest();
                RenderSystem.disableBlend();
                Tessellator tessellator = Tessellator.func_178181_a();
                BufferBuilder bufferbuilder = tessellator.func_178180_c();
                double health = stack.func_77973_b().getDurabilityForDisplay(stack);
                int i = Math.round(13.0f - (float)health * 13.0f);
                int j = stack.func_77973_b().getRGBDurabilityForDisplay(stack);
                this.func_181565_a(bufferbuilder, xPosition + 2, yPosition + 13, 13, 2, 0, 0, 0, 255);
                this.func_181565_a(bufferbuilder, xPosition + 2, yPosition + 13, i, 1, j >> 16 & 0xFF, j >> 8 & 0xFF, j & 0xFF, 255);
                RenderSystem.enableBlend();
                RenderSystem.enableAlphaTest();
                RenderSystem.enableTexture();
                RenderSystem.enableDepthTest();
            }
            float f = f3 = (clientplayerentity = Minecraft.func_71410_x().field_71439_g) == null ? 0.0f : clientplayerentity.func_184811_cZ().func_185143_a(stack.func_77973_b(), Minecraft.func_71410_x().func_184121_ak());
            if (f3 > 0.0f) {
                RenderSystem.disableDepthTest();
                RenderSystem.disableTexture();
                RenderSystem.enableBlend();
                RenderSystem.defaultBlendFunc();
                Tessellator tessellator1 = Tessellator.func_178181_a();
                BufferBuilder bufferbuilder1 = tessellator1.func_178180_c();
                this.func_181565_a(bufferbuilder1, xPosition, yPosition + MathHelper.func_76141_d((float)(16.0f * (1.0f - f3))), 16, MathHelper.func_76123_f((float)(16.0f * f3)), 255, 255, 255, 127);
                RenderSystem.enableTexture();
                RenderSystem.enableDepthTest();
            }
        }
    }

    private void func_181565_a(BufferBuilder renderer, int x, int y, int width, int height, int red, int green, int blue, int alpha) {
        renderer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        renderer.func_225582_a_(x + 0, y + 0, 0.0).func_225586_a_(red, green, blue, alpha).func_181675_d();
        renderer.func_225582_a_(x + 0, y + height, 0.0).func_225586_a_(red, green, blue, alpha).func_181675_d();
        renderer.func_225582_a_(x + width, y + height, 0.0).func_225586_a_(red, green, blue, alpha).func_181675_d();
        renderer.func_225582_a_(x + width, y + 0, 0.0).func_225586_a_(red, green, blue, alpha).func_181675_d();
        Tessellator.func_178181_a().func_78381_a();
    }

    @Override
    public void func_195410_a(IResourceManager resourceManager) {
        this.field_175059_m.func_178085_b();
    }

    @Override
    public IResourceType getResourceType() {
        return VanillaResourceType.MODELS;
    }
}

