/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.network;

import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.mojang.authlib.GameProfile;
import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelException;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.multiplayer.ServerAddress;
import net.minecraft.client.multiplayer.ServerData;
import net.minecraft.client.network.status.IClientStatusNetHandler;
import net.minecraft.network.INetHandler;
import net.minecraft.network.IPacket;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.ProtocolType;
import net.minecraft.network.ServerStatusResponse;
import net.minecraft.network.handshake.client.CHandshakePacket;
import net.minecraft.network.status.client.CPingPacket;
import net.minecraft.network.status.client.CServerQueryPacket;
import net.minecraft.network.status.server.SPongPacket;
import net.minecraft.network.status.server.SServerInfoPacket;
import net.minecraft.util.Util;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.client.ClientHooks;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public class ServerPinger {
    private static final Splitter field_147230_a = Splitter.on((char)'\u0000').limit(6);
    private static final Logger field_147228_b = LogManager.getLogger();
    private final List<NetworkManager> field_147229_c = Collections.synchronizedList(Lists.newArrayList());

    public void func_147224_a(final ServerData server, final Runnable p_147224_2_) throws UnknownHostException {
        ServerAddress serveraddress = ServerAddress.func_78860_a((String)server.field_78845_b);
        final NetworkManager networkmanager = NetworkManager.func_181124_a(InetAddress.getByName(serveraddress.func_78861_a()), serveraddress.func_78864_b(), false);
        this.field_147229_c.add(networkmanager);
        server.field_78843_d = new TranslationTextComponent("multiplayer.status.pinging");
        server.field_78844_e = -1L;
        server.field_147412_i = null;
        networkmanager.func_150719_a((INetHandler)new IClientStatusNetHandler(){
            private boolean field_147403_d;
            private boolean field_183009_e;
            private long field_175092_e;

            public void func_147397_a(SServerInfoPacket packetIn) {
                if (this.field_183009_e) {
                    networkmanager.func_150718_a((ITextComponent)new TranslationTextComponent("multiplayer.status.unrequested"));
                } else {
                    this.field_183009_e = true;
                    ServerStatusResponse serverstatusresponse = packetIn.func_149294_c();
                    server.field_78843_d = serverstatusresponse.func_151317_a() != null ? serverstatusresponse.func_151317_a() : StringTextComponent.field_240750_d_;
                    if (serverstatusresponse.func_151322_c() != null) {
                        server.field_82822_g = new StringTextComponent(serverstatusresponse.func_151322_c().func_151303_a());
                        server.field_82821_f = serverstatusresponse.func_151322_c().func_151304_b();
                    } else {
                        server.field_82822_g = new TranslationTextComponent("multiplayer.status.old");
                        server.field_82821_f = 0;
                    }
                    if (serverstatusresponse.func_151318_b() != null) {
                        server.field_78846_c = ServerPinger.func_239171_b_(serverstatusresponse.func_151318_b().func_151333_b(), serverstatusresponse.func_151318_b().func_151332_a());
                        ArrayList list = Lists.newArrayList();
                        if (ArrayUtils.isNotEmpty((Object[])serverstatusresponse.func_151318_b().func_151331_c())) {
                            for (GameProfile gameprofile : serverstatusresponse.func_151318_b().func_151331_c()) {
                                list.add(new StringTextComponent(gameprofile.getName()));
                            }
                            if (serverstatusresponse.func_151318_b().func_151331_c().length < serverstatusresponse.func_151318_b().func_151333_b()) {
                                list.add(new TranslationTextComponent("multiplayer.status.and_more", serverstatusresponse.func_151318_b().func_151333_b() - serverstatusresponse.func_151318_b().func_151331_c().length));
                            }
                            server.field_147412_i = list;
                        }
                    } else {
                        server.field_78846_c = new TranslationTextComponent("multiplayer.status.unknown").func_240699_a_(TextFormatting.DARK_GRAY);
                    }
                    String s = null;
                    if (serverstatusresponse.func_151316_d() != null) {
                        String s1 = serverstatusresponse.func_151316_d();
                        if (s1.startsWith("data:image/png;base64,")) {
                            s = s1.substring("data:image/png;base64,".length());
                        } else {
                            field_147228_b.error("Invalid server icon (unknown format)");
                        }
                    }
                    if (!Objects.equals(s, server.func_147409_e())) {
                        server.func_147407_a(s);
                        p_147224_2_.run();
                    }
                    ClientHooks.processForgeListPingData((ServerStatusResponse)serverstatusresponse, (ServerData)server);
                    this.field_175092_e = Util.func_211177_b();
                    networkmanager.func_179290_a((IPacket<?>)new CPingPacket(this.field_175092_e));
                    this.field_147403_d = true;
                }
            }

            public void func_147398_a(SPongPacket packetIn) {
                long i = this.field_175092_e;
                long j = Util.func_211177_b();
                server.field_78844_e = j - i;
                networkmanager.func_150718_a((ITextComponent)new TranslationTextComponent("multiplayer.status.finished"));
            }

            public void func_147231_a(ITextComponent reason) {
                if (!this.field_147403_d) {
                    field_147228_b.error("Can't ping {}: {}", (Object)server.field_78845_b, (Object)reason.getString());
                    server.field_78843_d = new TranslationTextComponent("multiplayer.status.cannot_connect").func_240699_a_(TextFormatting.DARK_RED);
                    server.field_78846_c = StringTextComponent.field_240750_d_;
                    ServerPinger.this.func_147225_b(server);
                }
            }

            public NetworkManager func_147298_b() {
                return networkmanager;
            }
        });
        try {
            networkmanager.func_179290_a(new CHandshakePacket(serveraddress.func_78861_a(), serveraddress.func_78864_b(), ProtocolType.STATUS));
            networkmanager.func_179290_a((IPacket<?>)new CServerQueryPacket());
        }
        catch (Throwable throwable) {
            field_147228_b.error((Object)throwable);
        }
    }

    private void func_147225_b(final ServerData server) {
        final ServerAddress serveraddress = ServerAddress.func_78860_a((String)server.field_78845_b);
        ((Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().group((EventLoopGroup)NetworkManager.field_179295_d.func_179281_c())).handler((ChannelHandler)new ChannelInitializer<Channel>(){

            protected void initChannel(Channel p_initChannel_1_) throws Exception {
                try {
                    p_initChannel_1_.config().setOption(ChannelOption.TCP_NODELAY, (Object)true);
                }
                catch (ChannelException channelException) {
                    // empty catch block
                }
                p_initChannel_1_.pipeline().addLast(new ChannelHandler[]{new SimpleChannelInboundHandler<ByteBuf>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void channelActive(ChannelHandlerContext p_channelActive_1_) throws Exception {
                        super.channelActive(p_channelActive_1_);
                        ByteBuf bytebuf = Unpooled.buffer();
                        try {
                            bytebuf.writeByte(254);
                            bytebuf.writeByte(1);
                            bytebuf.writeByte(250);
                            char[] achar = "MC|PingHost".toCharArray();
                            bytebuf.writeShort(achar.length);
                            for (char c0 : achar) {
                                bytebuf.writeChar((int)c0);
                            }
                            bytebuf.writeShort(7 + 2 * serveraddress.func_78861_a().length());
                            bytebuf.writeByte(127);
                            achar = serveraddress.func_78861_a().toCharArray();
                            bytebuf.writeShort(achar.length);
                            for (char c1 : achar) {
                                bytebuf.writeChar((int)c1);
                            }
                            bytebuf.writeInt(serveraddress.func_78864_b());
                            p_channelActive_1_.channel().writeAndFlush((Object)bytebuf).addListener((GenericFutureListener)ChannelFutureListener.CLOSE_ON_FAILURE);
                        }
                        finally {
                            bytebuf.release();
                        }
                    }

                    protected void channelRead0(ChannelHandlerContext p_channelRead0_1_, ByteBuf p_channelRead0_2_) throws Exception {
                        short short1 = p_channelRead0_2_.readUnsignedByte();
                        if (short1 == 255) {
                            String s = new String(p_channelRead0_2_.readBytes(p_channelRead0_2_.readShort() * 2).array(), StandardCharsets.UTF_16BE);
                            String[] astring = (String[])Iterables.toArray((Iterable)field_147230_a.split((CharSequence)s), String.class);
                            if ("\u00a71".equals(astring[0])) {
                                int i = MathHelper.func_82715_a((String)astring[1], (int)0);
                                String s1 = astring[2];
                                String s2 = astring[3];
                                int j = MathHelper.func_82715_a((String)astring[4], (int)-1);
                                int k = MathHelper.func_82715_a((String)astring[5], (int)-1);
                                server.field_82821_f = -1;
                                server.field_82822_g = new StringTextComponent(s1);
                                server.field_78843_d = new StringTextComponent(s2);
                                server.field_78846_c = ServerPinger.func_239171_b_(j, k);
                            }
                        }
                        p_channelRead0_1_.close();
                    }

                    public void exceptionCaught(ChannelHandlerContext p_exceptionCaught_1_, Throwable p_exceptionCaught_2_) throws Exception {
                        p_exceptionCaught_1_.close();
                    }
                }});
            }
        })).channel(NioSocketChannel.class)).connect(serveraddress.func_78861_a(), serveraddress.func_78864_b());
    }

    private static ITextComponent func_239171_b_(int p_239171_0_, int p_239171_1_) {
        return new StringTextComponent(Integer.toString(p_239171_0_)).func_230529_a_((ITextComponent)new StringTextComponent("/").func_240699_a_(TextFormatting.DARK_GRAY)).func_240702_b_(Integer.toString(p_239171_1_)).func_240699_a_(TextFormatting.GRAY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void func_147223_a() {
        List<NetworkManager> list = this.field_147229_c;
        synchronized (list) {
            Iterator<NetworkManager> iterator = this.field_147229_c.iterator();
            while (iterator.hasNext()) {
                NetworkManager networkmanager = iterator.next();
                if (networkmanager.func_150724_d()) {
                    networkmanager.func_74428_b();
                    continue;
                }
                iterator.remove();
                networkmanager.func_179293_l();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void func_147226_b() {
        List<NetworkManager> list = this.field_147229_c;
        synchronized (list) {
            Iterator<NetworkManager> iterator = this.field_147229_c.iterator();
            while (iterator.hasNext()) {
                NetworkManager networkmanager = iterator.next();
                if (!networkmanager.func_150724_d()) continue;
                iterator.remove();
                networkmanager.func_150718_a((ITextComponent)new TranslationTextComponent("multiplayer.status.cancelled"));
            }
        }
    }
}

