/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.multiplayer;

import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.SharedConstants;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.client.ExtendedServerListData;

@OnlyIn(value=Dist.CLIENT)
public class ServerData {
    public String field_78847_a;
    public String field_78845_b;
    public ITextComponent field_78846_c;
    public ITextComponent field_78843_d;
    public long field_78844_e;
    public int field_82821_f = SharedConstants.func_215069_a().getProtocolVersion();
    public ITextComponent field_82822_g = new StringTextComponent(SharedConstants.func_215069_a().getName());
    public boolean field_78841_f;
    public List<ITextComponent> field_147412_i = Collections.emptyList();
    private ServerResourceMode field_152587_j = ServerResourceMode.PROMPT;
    @Nullable
    private String field_147411_m;
    private boolean field_181042_l;
    public ExtendedServerListData forgeData = null;

    public ServerData(String name, String ip, boolean isLan) {
        this.field_78847_a = name;
        this.field_78845_b = ip;
        this.field_181042_l = isLan;
    }

    public CompoundNBT func_78836_a() {
        CompoundNBT compoundnbt = new CompoundNBT();
        compoundnbt.func_74778_a("name", this.field_78847_a);
        compoundnbt.func_74778_a("ip", this.field_78845_b);
        if (this.field_147411_m != null) {
            compoundnbt.func_74778_a("icon", this.field_147411_m);
        }
        if (this.field_152587_j == ServerResourceMode.ENABLED) {
            compoundnbt.func_74757_a("acceptTextures", true);
        } else if (this.field_152587_j == ServerResourceMode.DISABLED) {
            compoundnbt.func_74757_a("acceptTextures", false);
        }
        return compoundnbt;
    }

    public ServerResourceMode func_152586_b() {
        return this.field_152587_j;
    }

    public void func_152584_a(ServerResourceMode mode) {
        this.field_152587_j = mode;
    }

    public static ServerData func_78837_a(CompoundNBT nbtCompound) {
        ServerData serverdata = new ServerData(nbtCompound.func_74779_i("name"), nbtCompound.func_74779_i("ip"), false);
        if (nbtCompound.func_150297_b("icon", 8)) {
            serverdata.func_147407_a(nbtCompound.func_74779_i("icon"));
        }
        if (nbtCompound.func_150297_b("acceptTextures", 1)) {
            if (nbtCompound.func_74767_n("acceptTextures")) {
                serverdata.func_152584_a(ServerResourceMode.ENABLED);
            } else {
                serverdata.func_152584_a(ServerResourceMode.DISABLED);
            }
        } else {
            serverdata.func_152584_a(ServerResourceMode.PROMPT);
        }
        return serverdata;
    }

    @Nullable
    public String func_147409_e() {
        return this.field_147411_m;
    }

    public void func_147407_a(@Nullable String icon) {
        this.field_147411_m = icon;
    }

    public boolean func_181041_d() {
        return this.field_181042_l;
    }

    public void func_152583_a(ServerData serverDataIn) {
        this.field_78845_b = serverDataIn.field_78845_b;
        this.field_78847_a = serverDataIn.field_78847_a;
        this.func_152584_a(serverDataIn.func_152586_b());
        this.field_147411_m = serverDataIn.field_147411_m;
        this.field_181042_l = serverDataIn.field_181042_l;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static enum ServerResourceMode {
        ENABLED("enabled"),
        DISABLED("disabled"),
        PROMPT("prompt");

        private final ITextComponent field_152594_d;

        private ServerResourceMode(String name) {
            this.field_152594_d = new TranslationTextComponent("addServer.resourcePack." + name);
        }

        public ITextComponent func_152589_a() {
            return this.field_152594_d;
        }
    }
}

