/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.block;

import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.AbstractFireBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.SixWayBlock;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.GameRules;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class FireBlock
extends AbstractFireBlock {
    public static final IntegerProperty field_176543_a = BlockStateProperties.field_208171_X;
    public static final BooleanProperty field_176545_N = SixWayBlock.field_196488_a;
    public static final BooleanProperty field_176546_O = SixWayBlock.field_196490_b;
    public static final BooleanProperty field_176541_P = SixWayBlock.field_196492_c;
    public static final BooleanProperty field_176539_Q = SixWayBlock.field_196495_y;
    public static final BooleanProperty field_176542_R = SixWayBlock.field_196496_z;
    private static final Map<Direction, BooleanProperty> field_196449_B = (Map)SixWayBlock.field_196491_B.entrySet().stream().filter(p_199776_0_ -> p_199776_0_.getKey() != Direction.DOWN).collect(Util.func_199749_a());
    private final Object2IntMap<Block> field_149849_a = new Object2IntOpenHashMap();
    private final Object2IntMap<Block> field_149848_b = new Object2IntOpenHashMap();

    public FireBlock(AbstractBlock.Properties builder) {
        super(builder, 1.0f);
        this.func_180632_j((BlockState)((Object)((BlockState)((Object)((BlockState)((Object)((BlockState)((Object)((BlockState)((Object)((BlockState)((Object)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)field_176543_a, Integer.valueOf(0)))).func_206870_a((Property)field_176545_N, Boolean.valueOf(false)))).func_206870_a((Property)field_176546_O, Boolean.valueOf(false)))).func_206870_a((Property)field_176541_P, Boolean.valueOf(false)))).func_206870_a((Property)field_176539_Q, Boolean.valueOf(false)))).func_206870_a((Property)field_176542_R, Boolean.valueOf(false))));
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        return this.func_196260_a(stateIn, (IWorldReader)worldIn, currentPos) ? this.func_235494_a_(worldIn, currentPos, (Integer)stateIn.func_177229_b((Property)field_176543_a)) : Blocks.field_150350_a.func_176223_P();
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        VoxelShape voxelshape = VoxelShapes.func_197880_a();
        if (((Boolean)state.func_177229_b((Property)field_176542_R)).booleanValue()) {
            voxelshape = field_235319_a_;
        }
        if (((Boolean)state.func_177229_b((Property)field_176539_Q)).booleanValue()) {
            voxelshape = VoxelShapes.func_197872_a((VoxelShape)voxelshape, (VoxelShape)field_235321_c_);
        }
        if (((Boolean)state.func_177229_b((Property)field_176546_O)).booleanValue()) {
            voxelshape = VoxelShapes.func_197872_a((VoxelShape)voxelshape, (VoxelShape)field_235322_d_);
        }
        if (((Boolean)state.func_177229_b((Property)field_176545_N)).booleanValue()) {
            voxelshape = VoxelShapes.func_197872_a((VoxelShape)voxelshape, (VoxelShape)field_235323_e_);
        }
        if (((Boolean)state.func_177229_b((Property)field_176541_P)).booleanValue()) {
            voxelshape = VoxelShapes.func_197872_a((VoxelShape)voxelshape, (VoxelShape)field_235324_f_);
        }
        return voxelshape == VoxelShapes.func_197880_a() ? field_235320_b_ : voxelshape;
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        return this.func_196448_a((IBlockReader)((Object)context.func_195991_k()), context.func_195995_a());
    }

    protected BlockState func_196448_a(IBlockReader p_196448_1_, BlockPos p_196448_2_) {
        BlockPos blockpos = p_196448_2_.func_177977_b();
        BlockState blockstate = p_196448_1_.func_180495_p(blockpos);
        if (!this.canCatchFire(p_196448_1_, p_196448_2_, Direction.UP) && !Block.func_220056_d(blockstate, p_196448_1_, blockpos, Direction.UP)) {
            BlockState blockstate1 = this.func_176223_P();
            for (Direction direction : Direction.values()) {
                BooleanProperty booleanproperty = field_196449_B.get((Object)direction);
                if (booleanproperty == null) continue;
                blockstate1 = (BlockState)((Object)blockstate1.func_206870_a((Property)booleanproperty, Boolean.valueOf(this.canCatchFire(p_196448_1_, p_196448_2_.func_177972_a(direction), direction.func_176734_d()))));
            }
            return blockstate1;
        }
        return this.func_176223_P();
    }

    public boolean func_196260_a(BlockState state, IWorldReader worldIn, BlockPos pos) {
        BlockPos blockpos = pos.func_177977_b();
        return worldIn.func_180495_p(blockpos).func_224755_d((IBlockReader)((Object)worldIn), blockpos, Direction.UP) || this.func_196447_a((IBlockReader)((Object)worldIn), pos);
    }

    public void func_225534_a_(BlockState state, ServerWorld worldIn, BlockPos pos, Random rand) {
        worldIn.func_205220_G_().func_205360_a(pos, (Object)this, FireBlock.func_235495_a_(worldIn.field_73012_v));
        if (worldIn.func_82736_K().func_223586_b(GameRules.field_223598_a)) {
            if (!state.func_196955_c((IWorldReader)((Object)worldIn), pos)) {
                worldIn.func_217377_a(pos, false);
            }
            BlockState blockstate = worldIn.func_180495_p(pos.func_177977_b());
            boolean flag = blockstate.isFireSource((IWorldReader)((Object)worldIn), pos, Direction.UP);
            int i = (Integer)state.func_177229_b((Property)field_176543_a);
            if (!flag && worldIn.func_72896_J() && this.func_176537_d(worldIn, pos) && rand.nextFloat() < 0.2f + (float)i * 0.03f) {
                worldIn.func_217377_a(pos, false);
            } else {
                boolean flag1;
                int j = Math.min(15, i + rand.nextInt(3) / 2);
                if (i != j) {
                    state = (BlockState)((Object)state.func_206870_a((Property)field_176543_a, Integer.valueOf(j)));
                    worldIn.func_180501_a(pos, state, 4);
                }
                if (!flag) {
                    if (!this.func_196447_a((IBlockReader)((Object)worldIn), pos)) {
                        BlockPos blockpos = pos.func_177977_b();
                        if (!worldIn.func_180495_p(blockpos).func_224755_d((IBlockReader)((Object)worldIn), blockpos, Direction.UP) || i > 3) {
                            worldIn.func_217377_a(pos, false);
                        }
                        return;
                    }
                    if (i == 15 && rand.nextInt(4) == 0 && !this.canCatchFire((IBlockReader)((Object)worldIn), pos.func_177977_b(), Direction.UP)) {
                        worldIn.func_217377_a(pos, false);
                        return;
                    }
                }
                int k = (flag1 = worldIn.func_180502_D(pos)) ? -50 : 0;
                this.tryCatchFire(worldIn, pos.func_177974_f(), 300 + k, rand, i, Direction.WEST);
                this.tryCatchFire(worldIn, pos.func_177976_e(), 300 + k, rand, i, Direction.EAST);
                this.tryCatchFire(worldIn, pos.func_177977_b(), 250 + k, rand, i, Direction.UP);
                this.tryCatchFire(worldIn, pos.func_177984_a(), 250 + k, rand, i, Direction.DOWN);
                this.tryCatchFire(worldIn, pos.func_177978_c(), 300 + k, rand, i, Direction.SOUTH);
                this.tryCatchFire(worldIn, pos.func_177968_d(), 300 + k, rand, i, Direction.NORTH);
                BlockPos.Mutable blockpos$mutable = new BlockPos.Mutable();
                for (int l = -1; l <= 1; ++l) {
                    for (int i1 = -1; i1 <= 1; ++i1) {
                        for (int j1 = -1; j1 <= 4; ++j1) {
                            if (l == 0 && j1 == 0 && i1 == 0) continue;
                            int k1 = 100;
                            if (j1 > 1) {
                                k1 += (j1 - 1) * 100;
                            }
                            blockpos$mutable.func_239621_a_((Vector3i)pos, l, j1, i1);
                            int l1 = this.func_176538_m((IWorldReader)((Object)worldIn), (BlockPos)blockpos$mutable);
                            if (l1 <= 0) continue;
                            int i2 = (l1 + 40 + worldIn.func_175659_aa().func_151525_a() * 7) / (i + 30);
                            if (flag1) {
                                i2 /= 2;
                            }
                            if (i2 <= 0 || rand.nextInt(k1) > i2 || worldIn.func_72896_J() && this.func_176537_d(worldIn, (BlockPos)blockpos$mutable)) continue;
                            int j2 = Math.min(15, i + rand.nextInt(5) / 4);
                            worldIn.func_180501_a((BlockPos)blockpos$mutable, this.func_235494_a_(worldIn, (BlockPos)blockpos$mutable, j2), 3);
                        }
                    }
                }
            }
        }
    }

    protected boolean func_176537_d(World worldIn, BlockPos pos) {
        return worldIn.func_175727_C(pos) || worldIn.func_175727_C(pos.func_177976_e()) || worldIn.func_175727_C(pos.func_177974_f()) || worldIn.func_175727_C(pos.func_177978_c()) || worldIn.func_175727_C(pos.func_177968_d());
    }

    @Deprecated
    public int func_220274_q(BlockState p_220274_1_) {
        return p_220274_1_.func_235901_b_((Property)BlockStateProperties.field_208198_y) && (Boolean)p_220274_1_.func_177229_b((Property)BlockStateProperties.field_208198_y) != false ? 0 : this.field_149848_b.getInt((Object)p_220274_1_.func_177230_c());
    }

    @Deprecated
    public int func_220275_r(BlockState p_220275_1_) {
        return p_220275_1_.func_235901_b_((Property)BlockStateProperties.field_208198_y) && (Boolean)p_220275_1_.func_177229_b((Property)BlockStateProperties.field_208198_y) != false ? 0 : this.field_149849_a.getInt((Object)p_220275_1_.func_177230_c());
    }

    private void tryCatchFire(World worldIn, BlockPos pos, int chance, Random random, int age, Direction face) {
        int i = this.func_220274_q(worldIn.func_180495_p(pos));
        if (random.nextInt(chance) < i) {
            BlockState blockstate = worldIn.func_180495_p(pos);
            if (random.nextInt(age + 10) < 5 && !worldIn.func_175727_C(pos)) {
                int j = Math.min(age + random.nextInt(5) / 4, 15);
                worldIn.func_180501_a(pos, this.func_235494_a_(worldIn, pos, j), 3);
            } else {
                worldIn.func_217377_a(pos, false);
            }
            Block block = blockstate.func_177230_c();
            blockstate.catchFire(worldIn, pos, face, null);
        }
    }

    private BlockState func_235494_a_(IWorld p_235494_1_, BlockPos p_235494_2_, int p_235494_3_) {
        BlockState blockstate = FireBlock.func_235326_a_((IBlockReader)p_235494_1_, (BlockPos)p_235494_2_);
        return blockstate.func_203425_a(Blocks.field_150480_ab) ? (BlockState)((Object)blockstate.func_206870_a((Property)field_176543_a, Integer.valueOf(p_235494_3_))) : blockstate;
    }

    private boolean func_196447_a(IBlockReader worldIn, BlockPos pos) {
        for (Direction direction : Direction.values()) {
            if (!this.canCatchFire(worldIn, pos.func_177972_a(direction), direction.func_176734_d())) continue;
            return true;
        }
        return false;
    }

    private int func_176538_m(IWorldReader worldIn, BlockPos pos) {
        if (!worldIn.func_175623_d(pos)) {
            return 0;
        }
        int i = 0;
        for (Direction direction : Direction.values()) {
            BlockState blockstate = worldIn.func_180495_p(pos.func_177972_a(direction));
            i = Math.max(blockstate.getFireSpreadSpeed((IBlockReader)((Object)worldIn), pos.func_177972_a(direction), direction.func_176734_d()), i);
        }
        return i;
    }

    @Deprecated
    protected boolean func_196446_i(BlockState p_196446_1_) {
        return this.func_220275_r(p_196446_1_) > 0;
    }

    public void func_220082_b(BlockState state, World worldIn, BlockPos pos, BlockState oldState, boolean isMoving) {
        super.func_220082_b(state, worldIn, pos, oldState, isMoving);
        worldIn.func_205220_G_().func_205360_a(pos, (Object)this, FireBlock.func_235495_a_(worldIn.field_73012_v));
    }

    private static int func_235495_a_(Random p_235495_0_) {
        return 30 + p_235495_0_.nextInt(10);
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{field_176543_a, field_176545_N, field_176546_O, field_176541_P, field_176539_Q, field_176542_R});
    }

    private void func_180686_a(Block blockIn, int encouragement, int flammability) {
        if (blockIn == Blocks.field_150350_a) {
            throw new IllegalArgumentException("Tried to set air on fire... This is bad.");
        }
        this.field_149849_a.put((Object)blockIn, encouragement);
        this.field_149848_b.put((Object)blockIn, flammability);
    }

    public boolean canCatchFire(IBlockReader world, BlockPos pos, Direction face) {
        return world.func_180495_p(pos).isFlammable(world, pos, face);
    }

    public static void func_149843_e() {
        FireBlock fireblock = (FireBlock)((Object)Blocks.field_150480_ab);
        fireblock.func_180686_a(Blocks.field_196662_n, 5, 20);
        fireblock.func_180686_a(Blocks.field_196664_o, 5, 20);
        fireblock.func_180686_a(Blocks.field_196666_p, 5, 20);
        fireblock.func_180686_a(Blocks.field_196668_q, 5, 20);
        fireblock.func_180686_a(Blocks.field_196670_r, 5, 20);
        fireblock.func_180686_a(Blocks.field_196672_s, 5, 20);
        fireblock.func_180686_a(Blocks.field_196622_bq, 5, 20);
        fireblock.func_180686_a(Blocks.field_196624_br, 5, 20);
        fireblock.func_180686_a(Blocks.field_196627_bs, 5, 20);
        fireblock.func_180686_a(Blocks.field_196630_bt, 5, 20);
        fireblock.func_180686_a(Blocks.field_196632_bu, 5, 20);
        fireblock.func_180686_a(Blocks.field_196635_bv, 5, 20);
        fireblock.func_180686_a(Blocks.field_180390_bo, 5, 20);
        fireblock.func_180686_a(Blocks.field_180391_bp, 5, 20);
        fireblock.func_180686_a(Blocks.field_180392_bq, 5, 20);
        fireblock.func_180686_a(Blocks.field_180386_br, 5, 20);
        fireblock.func_180686_a(Blocks.field_180385_bs, 5, 20);
        fireblock.func_180686_a(Blocks.field_180387_bt, 5, 20);
        fireblock.func_180686_a(Blocks.field_180407_aO, 5, 20);
        fireblock.func_180686_a(Blocks.field_180408_aP, 5, 20);
        fireblock.func_180686_a(Blocks.field_180404_aQ, 5, 20);
        fireblock.func_180686_a(Blocks.field_180403_aR, 5, 20);
        fireblock.func_180686_a(Blocks.field_180406_aS, 5, 20);
        fireblock.func_180686_a(Blocks.field_180405_aT, 5, 20);
        fireblock.func_180686_a(Blocks.field_150476_ad, 5, 20);
        fireblock.func_180686_a(Blocks.field_150487_bG, 5, 20);
        fireblock.func_180686_a(Blocks.field_150485_bF, 5, 20);
        fireblock.func_180686_a(Blocks.field_150481_bH, 5, 20);
        fireblock.func_180686_a(Blocks.field_150400_ck, 5, 20);
        fireblock.func_180686_a(Blocks.field_150401_cl, 5, 20);
        fireblock.func_180686_a(Blocks.field_196617_K, 5, 5);
        fireblock.func_180686_a(Blocks.field_196618_L, 5, 5);
        fireblock.func_180686_a(Blocks.field_196619_M, 5, 5);
        fireblock.func_180686_a(Blocks.field_196620_N, 5, 5);
        fireblock.func_180686_a(Blocks.field_196621_O, 5, 5);
        fireblock.func_180686_a(Blocks.field_196623_P, 5, 5);
        fireblock.func_180686_a(Blocks.field_203204_R, 5, 5);
        fireblock.func_180686_a(Blocks.field_203205_S, 5, 5);
        fireblock.func_180686_a(Blocks.field_203206_T, 5, 5);
        fireblock.func_180686_a(Blocks.field_203207_U, 5, 5);
        fireblock.func_180686_a(Blocks.field_203208_V, 5, 5);
        fireblock.func_180686_a(Blocks.field_203209_W, 5, 5);
        fireblock.func_180686_a(Blocks.field_209389_ab, 5, 5);
        fireblock.func_180686_a(Blocks.field_209390_ac, 5, 5);
        fireblock.func_180686_a(Blocks.field_209391_ad, 5, 5);
        fireblock.func_180686_a(Blocks.field_209392_ae, 5, 5);
        fireblock.func_180686_a(Blocks.field_209393_af, 5, 5);
        fireblock.func_180686_a(Blocks.field_209394_ag, 5, 5);
        fireblock.func_180686_a(Blocks.field_196626_Q, 5, 5);
        fireblock.func_180686_a(Blocks.field_196629_R, 5, 5);
        fireblock.func_180686_a(Blocks.field_196631_S, 5, 5);
        fireblock.func_180686_a(Blocks.field_196634_T, 5, 5);
        fireblock.func_180686_a(Blocks.field_196637_U, 5, 5);
        fireblock.func_180686_a(Blocks.field_196639_V, 5, 5);
        fireblock.func_180686_a(Blocks.field_196642_W, 30, 60);
        fireblock.func_180686_a(Blocks.field_196645_X, 30, 60);
        fireblock.func_180686_a(Blocks.field_196647_Y, 30, 60);
        fireblock.func_180686_a(Blocks.field_196648_Z, 30, 60);
        fireblock.func_180686_a(Blocks.field_196572_aa, 30, 60);
        fireblock.func_180686_a(Blocks.field_196574_ab, 30, 60);
        fireblock.func_180686_a(Blocks.field_150342_X, 30, 20);
        fireblock.func_180686_a(Blocks.field_150335_W, 15, 100);
        fireblock.func_180686_a(Blocks.field_150349_c, 60, 100);
        fireblock.func_180686_a(Blocks.field_196554_aH, 60, 100);
        fireblock.func_180686_a(Blocks.field_196555_aI, 60, 100);
        fireblock.func_180686_a(Blocks.field_196800_gd, 60, 100);
        fireblock.func_180686_a(Blocks.field_196801_ge, 60, 100);
        fireblock.func_180686_a(Blocks.field_196802_gf, 60, 100);
        fireblock.func_180686_a(Blocks.field_196803_gg, 60, 100);
        fireblock.func_180686_a(Blocks.field_196804_gh, 60, 100);
        fireblock.func_180686_a(Blocks.field_196805_gi, 60, 100);
        fireblock.func_180686_a(Blocks.field_196605_bc, 60, 100);
        fireblock.func_180686_a(Blocks.field_196606_bd, 60, 100);
        fireblock.func_180686_a(Blocks.field_196607_be, 60, 100);
        fireblock.func_180686_a(Blocks.field_196609_bf, 60, 100);
        fireblock.func_180686_a(Blocks.field_196610_bg, 60, 100);
        fireblock.func_180686_a(Blocks.field_196612_bh, 60, 100);
        fireblock.func_180686_a(Blocks.field_196613_bi, 60, 100);
        fireblock.func_180686_a(Blocks.field_196614_bj, 60, 100);
        fireblock.func_180686_a(Blocks.field_196615_bk, 60, 100);
        fireblock.func_180686_a(Blocks.field_196616_bl, 60, 100);
        fireblock.func_180686_a(Blocks.field_222387_by, 60, 100);
        fireblock.func_180686_a(Blocks.field_222383_bA, 60, 100);
        fireblock.func_180686_a(Blocks.field_222388_bz, 60, 100);
        fireblock.func_180686_a(Blocks.field_196556_aL, 30, 60);
        fireblock.func_180686_a(Blocks.field_196557_aM, 30, 60);
        fireblock.func_180686_a(Blocks.field_196558_aN, 30, 60);
        fireblock.func_180686_a(Blocks.field_196559_aO, 30, 60);
        fireblock.func_180686_a(Blocks.field_196560_aP, 30, 60);
        fireblock.func_180686_a(Blocks.field_196561_aQ, 30, 60);
        fireblock.func_180686_a(Blocks.field_196562_aR, 30, 60);
        fireblock.func_180686_a(Blocks.field_196563_aS, 30, 60);
        fireblock.func_180686_a(Blocks.field_196564_aT, 30, 60);
        fireblock.func_180686_a(Blocks.field_196565_aU, 30, 60);
        fireblock.func_180686_a(Blocks.field_196566_aV, 30, 60);
        fireblock.func_180686_a(Blocks.field_196567_aW, 30, 60);
        fireblock.func_180686_a(Blocks.field_196568_aX, 30, 60);
        fireblock.func_180686_a(Blocks.field_196569_aY, 30, 60);
        fireblock.func_180686_a(Blocks.field_196570_aZ, 30, 60);
        fireblock.func_180686_a(Blocks.field_196602_ba, 30, 60);
        fireblock.func_180686_a(Blocks.field_150395_bd, 15, 100);
        fireblock.func_180686_a(Blocks.field_150402_ci, 5, 5);
        fireblock.func_180686_a(Blocks.field_150407_cf, 60, 20);
        fireblock.func_180686_a(Blocks.field_235396_nb_, 15, 20);
        fireblock.func_180686_a(Blocks.field_196724_fH, 60, 20);
        fireblock.func_180686_a(Blocks.field_196725_fI, 60, 20);
        fireblock.func_180686_a(Blocks.field_196727_fJ, 60, 20);
        fireblock.func_180686_a(Blocks.field_196729_fK, 60, 20);
        fireblock.func_180686_a(Blocks.field_196731_fL, 60, 20);
        fireblock.func_180686_a(Blocks.field_196733_fM, 60, 20);
        fireblock.func_180686_a(Blocks.field_196735_fN, 60, 20);
        fireblock.func_180686_a(Blocks.field_196737_fO, 60, 20);
        fireblock.func_180686_a(Blocks.field_196739_fP, 60, 20);
        fireblock.func_180686_a(Blocks.field_196741_fQ, 60, 20);
        fireblock.func_180686_a(Blocks.field_196743_fR, 60, 20);
        fireblock.func_180686_a(Blocks.field_196745_fS, 60, 20);
        fireblock.func_180686_a(Blocks.field_196747_fT, 60, 20);
        fireblock.func_180686_a(Blocks.field_196749_fU, 60, 20);
        fireblock.func_180686_a(Blocks.field_196751_fV, 60, 20);
        fireblock.func_180686_a(Blocks.field_196753_fW, 60, 20);
        fireblock.func_180686_a(Blocks.field_203216_jz, 30, 60);
        fireblock.func_180686_a(Blocks.field_222405_kQ, 60, 60);
        fireblock.func_180686_a(Blocks.field_222420_lI, 60, 60);
        fireblock.func_180686_a(Blocks.field_222428_lQ, 30, 20);
        fireblock.func_180686_a(Blocks.field_222436_lZ, 5, 20);
        fireblock.func_180686_a(Blocks.field_222434_lW, 60, 100);
        fireblock.func_180686_a(Blocks.field_226906_mb_, 5, 20);
        fireblock.func_180686_a(Blocks.field_226905_ma_, 30, 20);
    }
}

