/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.block;

import java.util.Random;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.FenceGateBlock;
import net.minecraft.block.MovingPistonBlock;
import net.minecraft.entity.Entity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.pathfinding.PathType;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.FarmlandWaterManager;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.IPlantable;

public class FarmlandBlock
extends Block {
    public static final IntegerProperty field_176531_a = BlockStateProperties.field_208133_ah;
    protected static final VoxelShape field_196432_b = Block.func_208617_a(0.0, 0.0, 0.0, 16.0, 15.0, 16.0);

    public FarmlandBlock(AbstractBlock.Properties builder) {
        super(builder);
        this.func_180632_j((BlockState)((Object)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)field_176531_a, Integer.valueOf(0))));
    }

    @Override
    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (facing == Direction.UP && !stateIn.func_196955_c((IWorldReader)worldIn, currentPos)) {
            worldIn.func_205220_G_().func_205360_a(currentPos, (Object)this, 1);
        }
        return super.func_196271_a(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    @Override
    public boolean func_196260_a(BlockState state, IWorldReader worldIn, BlockPos pos) {
        BlockState blockstate = worldIn.func_180495_p(pos.func_177984_a());
        return !blockstate.func_185904_a().func_76220_a() || blockstate.func_177230_c() instanceof FenceGateBlock || blockstate.func_177230_c() instanceof MovingPistonBlock;
    }

    @Override
    public BlockState func_196258_a(BlockItemUseContext context) {
        return !this.func_176223_P().func_196955_c((IWorldReader)((Object)context.func_195991_k()), context.func_195995_a()) ? Blocks.field_150346_d.func_176223_P() : super.func_196258_a(context);
    }

    @Override
    public boolean func_220074_n(BlockState state) {
        return true;
    }

    @Override
    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return field_196432_b;
    }

    @Override
    public void func_225534_a_(BlockState state, ServerWorld worldIn, BlockPos pos, Random rand) {
        if (!state.func_196955_c((IWorldReader)((Object)worldIn), pos)) {
            FarmlandBlock.func_199610_d(state, worldIn, pos);
        }
    }

    @Override
    public void func_225542_b_(BlockState state, ServerWorld worldIn, BlockPos pos, Random random) {
        int i = (Integer)state.func_177229_b((Property)field_176531_a);
        if (!FarmlandBlock.func_176530_e((IWorldReader)((Object)worldIn), pos) && !worldIn.func_175727_C(pos.func_177984_a())) {
            if (i > 0) {
                worldIn.func_180501_a(pos, (BlockState)((Object)state.func_206870_a((Property)field_176531_a, Integer.valueOf(i - 1))), 2);
            } else if (!this.func_176529_d((IBlockReader)((Object)worldIn), pos)) {
                FarmlandBlock.func_199610_d(state, worldIn, pos);
            }
        } else if (i < 7) {
            worldIn.func_180501_a(pos, (BlockState)((Object)state.func_206870_a((Property)field_176531_a, Integer.valueOf(7))), 2);
        }
    }

    @Override
    public void func_180658_a(World worldIn, BlockPos pos, Entity entityIn, float fallDistance) {
        if (!worldIn.field_72995_K && ForgeHooks.onFarmlandTrample((World)worldIn, (BlockPos)pos, (BlockState)Blocks.field_150346_d.func_176223_P(), (float)fallDistance, (Entity)entityIn)) {
            FarmlandBlock.func_199610_d(worldIn.func_180495_p(pos), worldIn, pos);
        }
        super.func_180658_a(worldIn, pos, entityIn, fallDistance);
    }

    public static void func_199610_d(BlockState state, World worldIn, BlockPos pos) {
        worldIn.func_175656_a(pos, FarmlandBlock.func_199601_a(state, Blocks.field_150346_d.func_176223_P(), worldIn, pos));
    }

    private boolean func_176529_d(IBlockReader worldIn, BlockPos pos) {
        BlockState state = worldIn.func_180495_p(pos.func_177984_a());
        return state.func_177230_c() instanceof IPlantable && this.canSustainPlant(state, worldIn, pos, Direction.UP, (IPlantable)state.func_177230_c());
    }

    private static boolean func_176530_e(IWorldReader worldIn, BlockPos pos) {
        for (BlockPos blockpos : BlockPos.func_218278_a((BlockPos)pos.func_177982_a(-4, 0, -4), (BlockPos)pos.func_177982_a(4, 1, 4))) {
            if (!worldIn.func_204610_c(blockpos).func_206884_a(FluidTags.field_206959_a)) continue;
            return true;
        }
        return FarmlandWaterManager.hasBlockWaterTicket((IWorldReader)worldIn, (BlockPos)pos);
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{field_176531_a});
    }

    @Override
    public boolean func_196266_a(BlockState state, IBlockReader worldIn, BlockPos pos, PathType type) {
        return false;
    }
}

