/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.server.command;

import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.util.Collection;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.arguments.BlockPosArgument;
import net.minecraft.command.arguments.DimensionArgument;
import net.minecraft.command.arguments.EntityArgument;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.server.ServerWorld;

public class CommandSetDimension {
    private static final SimpleCommandExceptionType NO_ENTITIES = new SimpleCommandExceptionType((Message)new TranslationTextComponent("commands.forge.setdim.invalid.entity"));
    private static final DynamicCommandExceptionType INVALID_DIMENSION = new DynamicCommandExceptionType(dim -> new TranslationTextComponent("commands.forge.setdim.invalid.dim", new Object[]{dim}));

    static ArgumentBuilder<CommandSource, ?> register() {
        return ((LiteralArgumentBuilder)Commands.func_197057_a((String)"setdimension").requires(cs -> cs.func_197034_c(2))).then(Commands.func_197056_a((String)"targets", (ArgumentType)EntityArgument.func_197093_b()).then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"dim", (ArgumentType)DimensionArgument.func_212595_a()).then(Commands.func_197056_a((String)"pos", (ArgumentType)BlockPosArgument.func_197276_a()).executes(ctx -> CommandSetDimension.execute((CommandSource)ctx.getSource(), EntityArgument.func_197087_c((CommandContext)ctx, (String)"targets"), DimensionArgument.func_212592_a((CommandContext)ctx, (String)"dim"), BlockPosArgument.func_197274_b((CommandContext)ctx, (String)"pos"))))).executes(ctx -> CommandSetDimension.execute((CommandSource)ctx.getSource(), EntityArgument.func_197087_c((CommandContext)ctx, (String)"targets"), DimensionArgument.func_212592_a((CommandContext)ctx, (String)"dim"), new BlockPos(((CommandSource)ctx.getSource()).func_197036_d())))));
    }

    private static int execute(CommandSource sender, Collection<? extends Entity> entities, ServerWorld dim, BlockPos pos) throws CommandSyntaxException {
        entities.removeIf(e -> !CommandSetDimension.canEntityTeleport(e));
        if (entities.isEmpty()) {
            throw NO_ENTITIES.create();
        }
        entities.stream().filter(e -> e.field_70170_p == dim).forEach(e -> sender.func_197030_a((ITextComponent)new TranslationTextComponent("commands.forge.setdim.invalid.nochange", new Object[]{e.func_145748_c_().getString(), dim}), true));
        entities.stream().filter(e -> e.field_70170_p != dim).forEach(e -> e.func_241206_a_(dim));
        return 0;
    }

    private static boolean canEntityTeleport(Entity entity) {
        return !entity.func_184218_aH() && !entity.func_184207_aI() && entity.func_184222_aU();
    }
}

