/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.server.command;

import com.google.common.collect.Maps;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.ISuggestionProvider;
import net.minecraft.command.arguments.DimensionArgument;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.tuple.MutablePair;
import org.apache.commons.lang3.tuple.Pair;

class CommandEntity {
    CommandEntity() {
    }

    static ArgumentBuilder<CommandSource, ?> register() {
        return Commands.func_197057_a((String)"entity").then(EntityListCommand.register());
    }

    private static class EntityListCommand {
        private static final SimpleCommandExceptionType INVALID_FILTER = new SimpleCommandExceptionType((Message)new TranslationTextComponent("commands.forge.entity.list.invalid"));
        private static final DynamicCommandExceptionType INVALID_DIMENSION = new DynamicCommandExceptionType(dim -> new TranslationTextComponent("commands.forge.entity.list.invalidworld", new Object[]{dim}));
        private static final SimpleCommandExceptionType NO_ENTITIES = new SimpleCommandExceptionType((Message)new TranslationTextComponent("commands.forge.entity.list.none"));

        private EntityListCommand() {
        }

        static ArgumentBuilder<CommandSource, ?> register() {
            return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"list").requires(cs -> cs.func_197034_c(2))).then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"filter", (ArgumentType)StringArgumentType.string()).suggests((ctx, builder) -> ISuggestionProvider.func_197013_a(ForgeRegistries.ENTITIES.getKeys().stream().map(ResourceLocation::toString), (SuggestionsBuilder)builder)).then(Commands.func_197056_a((String)"dim", (ArgumentType)DimensionArgument.func_212595_a()).executes(ctx -> EntityListCommand.execute((CommandSource)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"filter"), (RegistryKey<World>)DimensionArgument.func_212592_a((CommandContext)ctx, (String)"dim").func_234923_W_())))).executes(ctx -> EntityListCommand.execute((CommandSource)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"filter"), (RegistryKey<World>)((CommandSource)ctx.getSource()).func_197023_e().func_234923_W_())))).executes(ctx -> EntityListCommand.execute((CommandSource)ctx.getSource(), "*", (RegistryKey<World>)((CommandSource)ctx.getSource()).func_197023_e().func_234923_W_()));
        }

        private static int execute(CommandSource sender, String filter, RegistryKey<World> dim) throws CommandSyntaxException {
            String cleanFilter = filter.replace("?", ".?").replace("*", ".*?");
            Set names = ForgeRegistries.ENTITIES.getKeys().stream().filter(n -> n.toString().matches(cleanFilter)).collect(Collectors.toSet());
            if (names.isEmpty()) {
                throw INVALID_FILTER.create();
            }
            ServerWorld world = sender.func_197028_i().func_71218_a(dim);
            if (world == null) {
                throw INVALID_DIMENSION.create(dim);
            }
            HashMap list = Maps.newHashMap();
            world.getEntities().forEach(e -> {
                MutablePair info = list.computeIfAbsent(e.func_200600_R().getRegistryName(), k -> MutablePair.of((Object)0, (Object)Maps.newHashMap()));
                ChunkPos chunk = new ChunkPos(e.func_233580_cy_());
                MutablePair mutablePair = info;
                Integer n = (Integer)mutablePair.left;
                mutablePair.left = (Integer)mutablePair.left + 1;
                Integer n2 = mutablePair.left;
                ((Map)info.right).put(chunk, ((Map)info.right).getOrDefault(chunk, 0) + 1);
            });
            if (names.size() == 1) {
                ResourceLocation name = (ResourceLocation)names.iterator().next();
                Pair info = (Pair)list.get(name);
                if (info == null) {
                    throw NO_ENTITIES.create();
                }
                sender.func_197030_a((ITextComponent)new TranslationTextComponent("commands.forge.entity.list.single.header", new Object[]{name, info.getLeft()}), false);
                ArrayList toSort = new ArrayList();
                toSort.addAll(((Map)info.getRight()).entrySet());
                toSort.sort((a, b) -> {
                    if (Objects.equals(a.getValue(), b.getValue())) {
                        return ((ChunkPos)a.getKey()).toString().compareTo(((ChunkPos)b.getKey()).toString());
                    }
                    return (Integer)b.getValue() - (Integer)a.getValue();
                });
                long limit = 10L;
                for (Map.Entry entry : toSort) {
                    if (limit-- == 0L) break;
                    sender.func_197030_a((ITextComponent)new StringTextComponent("  " + entry.getValue() + ": " + ((ChunkPos)entry.getKey()).field_77276_a + ", " + ((ChunkPos)entry.getKey()).field_77275_b), false);
                }
                return toSort.size();
            }
            ArrayList info = new ArrayList();
            list.forEach((key, value) -> {
                if (names.contains(key)) {
                    Pair of = Pair.of((Object)key, (Object)value.left);
                    info.add(of);
                }
            });
            info.sort((a, b) -> {
                if (Objects.equals(a.getRight(), b.getRight())) {
                    return ((ResourceLocation)a.getKey()).toString().compareTo(((ResourceLocation)b.getKey()).toString());
                }
                return (Integer)b.getRight() - (Integer)a.getRight();
            });
            if (info.size() == 0) {
                throw NO_ENTITIES.create();
            }
            int count = info.stream().mapToInt(Pair::getRight).sum();
            sender.func_197030_a((ITextComponent)new TranslationTextComponent("commands.forge.entity.list.multiple.header", new Object[]{count}), false);
            info.forEach(e -> sender.func_197030_a((ITextComponent)new StringTextComponent("  " + e.getValue() + ": " + e.getKey()), false));
            return info.size();
        }
    }
}

