/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.server;

import java.util.List;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.LoadingFailedException;
import net.minecraftforge.fml.LogicalSidedProvider;
import net.minecraftforge.fml.ModLoader;
import net.minecraftforge.fml.ModLoadingWarning;
import net.minecraftforge.fml.SidedProvider;
import net.minecraftforge.fml.loading.LogMarkers;
import net.minecraftforge.fml.server.LanguageHook;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ServerModLoader {
    private static final Logger LOGGER = LogManager.getLogger();
    private static boolean hasErrors = false;

    public static void load() {
        SidedProvider.setServer(() -> {
            throw new IllegalStateException("Unable to access server yet");
        });
        LogicalSidedProvider.setServer(() -> {
            throw new IllegalStateException("Unable to access server yet");
        });
        LanguageHook.loadForgeAndMCLangs();
        try {
            ModLoader.get().gatherAndInitializeMods(() -> {});
            ModLoader.get().loadMods(Runnable::run, a -> {}, a -> {});
            ModLoader.get().finishMods(Runnable::run);
        }
        catch (LoadingFailedException e) {
            hasErrors = true;
            throw e;
        }
        List<ModLoadingWarning> warnings = ModLoader.get().getWarnings();
        if (!warnings.isEmpty()) {
            LOGGER.warn(LogMarkers.LOADING, "Mods loaded with {} warnings", (Object)warnings.size());
            warnings.forEach(warning -> LOGGER.warn(LogMarkers.LOADING, warning.formatToString()));
        }
        MinecraftForge.EVENT_BUS.start();
    }

    public static boolean hasErrors() {
        return hasErrors;
    }
}

