/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.packs;

import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.resources.IPackFinder;
import net.minecraft.resources.ResourcePackInfo;
import net.minecraft.resources.ResourcePackList;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.loading.moddiscovery.ModFile;
import net.minecraftforge.fml.loading.moddiscovery.ModFileInfo;
import net.minecraftforge.fml.packs.ModFileResourcePack;
import net.minecraftforge.forgespi.language.IModInfo;

public class ResourcePackLoader {
    private static Map<ModFile, ModFileResourcePack> modResourcePacks;
    private static ResourcePackList<?> resourcePackList;

    public static Optional<ModFileResourcePack> getResourcePackFor(String modId) {
        return Optional.ofNullable(ModList.get().getModFileById(modId)).map(ModFileInfo::getFile).map(mf -> modResourcePacks.get(mf));
    }

    public static <T extends ResourcePackInfo> void loadResourcePacks(ResourcePackList<T> resourcePacks, BiFunction<Map<ModFile, ? extends ModFileResourcePack>, BiConsumer<? super ModFileResourcePack, T>, IPackInfoFinder> packFinder) {
        resourcePackList = resourcePacks;
        modResourcePacks = ModList.get().getModFiles().stream().filter(mf -> !Objects.equals(mf.getModLoader(), "minecraft")).map(mf -> new ModFileResourcePack(mf.getFile())).collect(Collectors.toMap(ModFileResourcePack::getModFile, Function.identity(), (u, v) -> {
            throw new IllegalStateException(String.format("Duplicate key %s", u));
        }, LinkedHashMap::new));
        resourcePacks.addPackFinder((IPackFinder)new LambdaFriendlyPackFinder(packFinder.apply(modResourcePacks, ModFileResourcePack::setPackInfo)));
    }

    public static <V> Comparator<Map.Entry<String, V>> getSorter() {
        ArrayList<String> order = new ArrayList<String>();
        order.add("vanilla");
        order.add("mod_resources");
        ModList.get().getModFiles().stream().filter(mf -> !Objects.equals(mf.getModLoader(), "minecraft")).map(e -> ((IModInfo)e.getMods().get(0)).getModId()).filter(e -> !"minecraft".equals(e)).map(e -> "mod:" + e).forEach(order::add);
        Object2IntOpenHashMap order_f = new Object2IntOpenHashMap(order.size());
        for (int x = 0; x < order.size(); ++x) {
            order_f.put(order.get(x), x);
        }
        return (arg_0, arg_1) -> ResourcePackLoader.lambda$getSorter$8((Object2IntMap)order_f, arg_0, arg_1);
    }

    private static /* synthetic */ int lambda$getSorter$8(Object2IntMap order_f, Map.Entry e1, Map.Entry e2) {
        int i2;
        String s1 = (String)e1.getKey();
        String s2 = (String)e2.getKey();
        int i1 = order_f.getOrDefault((Object)s1, -1);
        if (i1 == (i2 = order_f.getOrDefault((Object)s2, -1)) && i1 == -1) {
            return s1.compareTo(s2);
        }
        if (i1 == -1) {
            return 1;
        }
        if (i2 == -1) {
            return -1;
        }
        return i2 - i1;
    }

    private static class LambdaFriendlyPackFinder
    implements IPackFinder {
        private IPackInfoFinder wrapped;

        private LambdaFriendlyPackFinder(IPackInfoFinder wrapped) {
            this.wrapped = wrapped;
        }

        public <T extends ResourcePackInfo> void func_230230_a_(Consumer<T> consumer, ResourcePackInfo.IFactory<T> factory) {
            this.wrapped.addPackInfos(consumer, factory);
        }
    }

    public static interface IPackInfoFinder<T extends ResourcePackInfo> {
        public void addPackInfos(Consumer<T> var1, ResourcePackInfo.IFactory<T> var2);
    }
}

