/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.network;

import java.util.Arrays;
import java.util.List;
import net.minecraftforge.fml.config.ConfigTracker;
import net.minecraftforge.fml.network.FMLHandshakeHandler;
import net.minecraftforge.fml.network.FMLHandshakeMessages;
import net.minecraftforge.fml.network.FMLMCRegisterPacketHandler;
import net.minecraftforge.fml.network.FMLNetworkConstants;
import net.minecraftforge.fml.network.FMLPlayMessages;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkRegistry;
import net.minecraftforge.fml.network.event.EventNetworkChannel;
import net.minecraftforge.fml.network.simple.SimpleChannel;
import net.minecraftforge.registries.RegistryManager;

class NetworkInitialization {
    NetworkInitialization() {
    }

    public static SimpleChannel getHandshakeChannel() {
        SimpleChannel handshakeChannel = NetworkRegistry.ChannelBuilder.named(FMLNetworkConstants.FML_HANDSHAKE_RESOURCE).clientAcceptedVersions(a -> true).serverAcceptedVersions(a -> true).networkProtocolVersion(() -> "FML2").simpleChannel();
        handshakeChannel.messageBuilder(FMLHandshakeMessages.C2SAcknowledge.class, 99, NetworkDirection.LOGIN_TO_SERVER).loginIndex(FMLHandshakeMessages.LoginIndexedMessage::getLoginIndex, FMLHandshakeMessages.LoginIndexedMessage::setLoginIndex).decoder(FMLHandshakeMessages.C2SAcknowledge::decode).encoder(FMLHandshakeMessages.C2SAcknowledge::encode).consumer(FMLHandshakeHandler.indexFirst(FMLHandshakeHandler::handleClientAck)).add();
        handshakeChannel.messageBuilder(FMLHandshakeMessages.S2CModList.class, 1, NetworkDirection.LOGIN_TO_CLIENT).loginIndex(FMLHandshakeMessages.LoginIndexedMessage::getLoginIndex, FMLHandshakeMessages.LoginIndexedMessage::setLoginIndex).decoder(FMLHandshakeMessages.S2CModList::decode).encoder(FMLHandshakeMessages.S2CModList::encode).markAsLoginPacket().consumer(FMLHandshakeHandler.biConsumerFor(FMLHandshakeHandler::handleServerModListOnClient)).add();
        handshakeChannel.messageBuilder(FMLHandshakeMessages.C2SModListReply.class, 2, NetworkDirection.LOGIN_TO_SERVER).loginIndex(FMLHandshakeMessages.LoginIndexedMessage::getLoginIndex, FMLHandshakeMessages.LoginIndexedMessage::setLoginIndex).decoder(FMLHandshakeMessages.C2SModListReply::decode).encoder(FMLHandshakeMessages.C2SModListReply::encode).consumer(FMLHandshakeHandler.indexFirst(FMLHandshakeHandler::handleClientModListOnServer)).add();
        handshakeChannel.messageBuilder(FMLHandshakeMessages.S2CRegistry.class, 3, NetworkDirection.LOGIN_TO_CLIENT).loginIndex(FMLHandshakeMessages.LoginIndexedMessage::getLoginIndex, FMLHandshakeMessages.LoginIndexedMessage::setLoginIndex).decoder(FMLHandshakeMessages.S2CRegistry::decode).encoder(FMLHandshakeMessages.S2CRegistry::encode).buildLoginPacketList(RegistryManager::generateRegistryPackets).consumer(FMLHandshakeHandler.biConsumerFor(FMLHandshakeHandler::handleRegistryMessage)).add();
        handshakeChannel.messageBuilder(FMLHandshakeMessages.S2CConfigData.class, 4, NetworkDirection.LOGIN_TO_CLIENT).loginIndex(FMLHandshakeMessages.LoginIndexedMessage::getLoginIndex, FMLHandshakeMessages.LoginIndexedMessage::setLoginIndex).decoder(FMLHandshakeMessages.S2CConfigData::decode).encoder(FMLHandshakeMessages.S2CConfigData::encode).buildLoginPacketList(ConfigTracker.INSTANCE::syncConfigs).consumer(FMLHandshakeHandler.biConsumerFor(FMLHandshakeHandler::handleConfigSync)).add();
        return handshakeChannel;
    }

    public static SimpleChannel getPlayChannel() {
        SimpleChannel playChannel = NetworkRegistry.ChannelBuilder.named(FMLNetworkConstants.FML_PLAY_RESOURCE).clientAcceptedVersions(a -> true).serverAcceptedVersions(a -> true).networkProtocolVersion(() -> "FML2").simpleChannel();
        playChannel.messageBuilder(FMLPlayMessages.SpawnEntity.class, 0).decoder(FMLPlayMessages.SpawnEntity::decode).encoder(FMLPlayMessages.SpawnEntity::encode).consumer(FMLPlayMessages.SpawnEntity::handle).add();
        playChannel.messageBuilder(FMLPlayMessages.OpenContainer.class, 1).decoder(FMLPlayMessages.OpenContainer::decode).encoder(FMLPlayMessages.OpenContainer::encode).consumer(FMLPlayMessages.OpenContainer::handle).add();
        return playChannel;
    }

    public static List<EventNetworkChannel> buildMCRegistrationChannels() {
        EventNetworkChannel mcRegChannel = NetworkRegistry.ChannelBuilder.named(FMLNetworkConstants.MC_REGISTER_RESOURCE).clientAcceptedVersions(a -> true).serverAcceptedVersions(a -> true).networkProtocolVersion(() -> "FML2").eventNetworkChannel();
        mcRegChannel.addListener(FMLMCRegisterPacketHandler.INSTANCE::registerListener);
        EventNetworkChannel mcUnregChannel = NetworkRegistry.ChannelBuilder.named(FMLNetworkConstants.MC_UNREGISTER_RESOURCE).clientAcceptedVersions(a -> true).serverAcceptedVersions(a -> true).networkProtocolVersion(() -> "FML2").eventNetworkChannel();
        mcUnregChannel.addListener(FMLMCRegisterPacketHandler.INSTANCE::unregisterListener);
        return Arrays.asList(mcRegChannel, mcUnregChannel);
    }
}

