/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.network;

import io.netty.buffer.Unpooled;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.IHasContainer;
import net.minecraft.client.gui.ScreenManager;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.fml.LogicalSidedProvider;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.network.NetworkEvent;

public class FMLPlayMessages {

    public static class OpenContainer {
        private final int id;
        private final int windowId;
        private final ITextComponent name;
        private final PacketBuffer additionalData;

        OpenContainer(ContainerType<?> id, int windowId, ITextComponent name, PacketBuffer additionalData) {
            this(Registry.field_218366_G.func_148757_b(id), windowId, name, additionalData);
        }

        private OpenContainer(int id, int windowId, ITextComponent name, PacketBuffer additionalData) {
            this.id = id;
            this.windowId = windowId;
            this.name = name;
            this.additionalData = additionalData;
        }

        public static void encode(OpenContainer msg, PacketBuffer buf) {
            buf.func_150787_b(msg.id);
            buf.func_150787_b(msg.windowId);
            buf.func_179256_a(msg.name);
            buf.func_179250_a(msg.additionalData.func_179251_a());
        }

        public static OpenContainer decode(PacketBuffer buf) {
            return new OpenContainer(buf.func_150792_a(), buf.func_150792_a(), buf.func_179258_d(), new PacketBuffer(Unpooled.wrappedBuffer((byte[])buf.func_189425_b(32600))));
        }

        public static void handle(OpenContainer msg, Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> ScreenManager.getScreenFactory(msg.getType(), (Minecraft)Minecraft.func_71410_x(), (int)msg.getWindowId(), (ITextComponent)msg.getName()).ifPresent(f -> {
                Container c = msg.getType().create(msg.getWindowId(), Minecraft.func_71410_x().field_71439_g.field_71071_by, msg.getAdditionalData());
                Screen s = f.create(c, Minecraft.func_71410_x().field_71439_g.field_71071_by, msg.getName());
                Minecraft.func_71410_x().field_71439_g.field_71070_bA = ((IHasContainer)s).func_212873_a_();
                Minecraft.func_71410_x().func_147108_a(s);
            }));
            ctx.get().setPacketHandled(true);
        }

        public final ContainerType<?> getType() {
            return (ContainerType)Registry.field_218366_G.func_148745_a(this.id);
        }

        public int getWindowId() {
            return this.windowId;
        }

        public ITextComponent getName() {
            return this.name;
        }

        public PacketBuffer getAdditionalData() {
            return this.additionalData;
        }
    }

    public static class SpawnEntity {
        private final Entity entity;
        private final int typeId;
        private final int entityId;
        private final UUID uuid;
        private final double posX;
        private final double posY;
        private final double posZ;
        private final byte pitch;
        private final byte yaw;
        private final byte headYaw;
        private final int velX;
        private final int velY;
        private final int velZ;
        private final PacketBuffer buf;

        SpawnEntity(Entity e) {
            this.entity = e;
            this.typeId = Registry.field_212629_r.func_148757_b((Object)e.func_200600_R());
            this.entityId = e.func_145782_y();
            this.uuid = e.func_110124_au();
            this.posX = e.func_226277_ct_();
            this.posY = e.func_226278_cu_();
            this.posZ = e.func_226281_cx_();
            this.pitch = (byte)MathHelper.func_76141_d((float)(e.field_70125_A * 256.0f / 360.0f));
            this.yaw = (byte)MathHelper.func_76141_d((float)(e.field_70177_z * 256.0f / 360.0f));
            this.headYaw = (byte)(e.func_70079_am() * 256.0f / 360.0f);
            Vector3d vec3d = e.func_213322_ci();
            double d1 = MathHelper.func_151237_a((double)vec3d.field_72450_a, (double)-3.9, (double)3.9);
            double d2 = MathHelper.func_151237_a((double)vec3d.field_72448_b, (double)-3.9, (double)3.9);
            double d3 = MathHelper.func_151237_a((double)vec3d.field_72449_c, (double)-3.9, (double)3.9);
            this.velX = (int)(d1 * 8000.0);
            this.velY = (int)(d2 * 8000.0);
            this.velZ = (int)(d3 * 8000.0);
            this.buf = null;
        }

        private SpawnEntity(int typeId, int entityId, UUID uuid, double posX, double posY, double posZ, byte pitch, byte yaw, byte headYaw, int velX, int velY, int velZ, PacketBuffer buf) {
            this.entity = null;
            this.typeId = typeId;
            this.entityId = entityId;
            this.uuid = uuid;
            this.posX = posX;
            this.posY = posY;
            this.posZ = posZ;
            this.pitch = pitch;
            this.yaw = yaw;
            this.headYaw = headYaw;
            this.velX = velX;
            this.velY = velY;
            this.velZ = velZ;
            this.buf = buf;
        }

        public static void encode(SpawnEntity msg, PacketBuffer buf) {
            buf.func_150787_b(msg.typeId);
            buf.writeInt(msg.entityId);
            buf.writeLong(msg.uuid.getMostSignificantBits());
            buf.writeLong(msg.uuid.getLeastSignificantBits());
            buf.writeDouble(msg.posX);
            buf.writeDouble(msg.posY);
            buf.writeDouble(msg.posZ);
            buf.writeByte((int)msg.pitch);
            buf.writeByte((int)msg.yaw);
            buf.writeByte((int)msg.headYaw);
            buf.writeShort(msg.velX);
            buf.writeShort(msg.velY);
            buf.writeShort(msg.velZ);
            if (msg.entity instanceof IEntityAdditionalSpawnData) {
                ((IEntityAdditionalSpawnData)msg.entity).writeSpawnData(buf);
            }
        }

        public static SpawnEntity decode(PacketBuffer buf) {
            return new SpawnEntity(buf.func_150792_a(), buf.readInt(), new UUID(buf.readLong(), buf.readLong()), buf.readDouble(), buf.readDouble(), buf.readDouble(), buf.readByte(), buf.readByte(), buf.readByte(), buf.readShort(), buf.readShort(), buf.readShort(), buf);
        }

        public static void handle(SpawnEntity msg, Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> {
                EntityType type = (EntityType)Registry.field_212629_r.func_148745_a(msg.typeId);
                if (type == null) {
                    throw new RuntimeException(String.format("Could not spawn entity (id %d) with unknown type at (%f, %f, %f)", msg.entityId, msg.posX, msg.posY, msg.posZ));
                }
                Optional world = (Optional)LogicalSidedProvider.CLIENTWORLD.get(((NetworkEvent.Context)ctx.get()).getDirection().getReceptionSide());
                Entity e = world.map(w -> type.customClientSpawn(msg, w)).orElse(null);
                if (e == null) {
                    return;
                }
                e.func_213312_b(msg.posX, msg.posY, msg.posZ);
                e.func_70080_a(msg.posX, msg.posY, msg.posZ, (float)(msg.yaw * 360) / 256.0f, (float)(msg.pitch * 360) / 256.0f);
                e.func_70034_d((float)(msg.headYaw * 360) / 256.0f);
                e.func_181013_g((float)(msg.headYaw * 360) / 256.0f);
                e.func_145769_d(msg.entityId);
                e.func_184221_a(msg.uuid);
                world.filter(ClientWorld.class::isInstance).ifPresent(w -> ((ClientWorld)w).func_217411_a(msg.entityId, e));
                e.func_70016_h((double)msg.velX / 8000.0, (double)msg.velY / 8000.0, (double)msg.velZ / 8000.0);
                if (e instanceof IEntityAdditionalSpawnData) {
                    ((IEntityAdditionalSpawnData)e).readSpawnData(msg.buf);
                }
            });
            ctx.get().setPacketHandled(true);
        }

        public Entity getEntity() {
            return this.entity;
        }

        public int getTypeId() {
            return this.typeId;
        }

        public int getEntityId() {
            return this.entityId;
        }

        public UUID getUuid() {
            return this.uuid;
        }

        public double getPosX() {
            return this.posX;
        }

        public double getPosY() {
            return this.posY;
        }

        public double getPosZ() {
            return this.posZ;
        }

        public byte getPitch() {
            return this.pitch;
        }

        public byte getYaw() {
            return this.yaw;
        }

        public byte getHeadYaw() {
            return this.headYaw;
        }

        public int getVelX() {
            return this.velX;
        }

        public int getVelY() {
            return this.velY;
        }

        public int getVelZ() {
            return this.velZ;
        }

        public PacketBuffer getAdditionalData() {
            return this.buf;
        }
    }
}

