/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.client.gui.screen;

import com.mojang.blaze3d.matrix.MatrixStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.client.gui.ScrollPanel;
import net.minecraftforge.fml.StartupQuery;

public class NotificationScreen
extends Screen {
    protected static final int PADDING = 6;
    protected final StartupQuery query;
    private final String[] headerLines;
    private final String[] textLines;
    private final String action;
    private ScrollPanel textPanel;

    public NotificationScreen(StartupQuery query) {
        super((ITextComponent)new TranslationTextComponent("fml.menu.notification.title"));
        this.query = query;
        this.headerLines = query.getHeader().isEmpty() ? new String[]{} : query.getHeader().split("\n");
        this.textLines = query.getText().split("\n");
        this.action = query.getAction();
    }

    public void func_231160_c_() {
        super.func_231160_c_();
        int n = this.headerLines.length;
        this.field_230712_o_.getClass();
        int panelY = 6 + n * 9 + 6;
        int panelHeight = this.field_230709_l_ - 6 - 20 - panelY;
        if (!this.action.isEmpty()) {
            this.field_230712_o_.getClass();
            panelHeight = panelHeight - 9 - 6;
        }
        this.textPanel = new TextPanel(this.field_230706_i_, this.field_230708_k_ - 12, panelHeight, panelY, 6);
        this.field_230705_e_.add(this.textPanel);
        this.addConfirmationButtons();
    }

    protected void addConfirmationButtons() {
        this.field_230710_m_.add(new Button(this.field_230708_k_ / 2 - 100, this.field_230709_l_ - 6 - 20, 200, 20, (ITextComponent)new TranslationTextComponent("gui.done"), b -> {
            this.field_230706_i_.func_147108_a(null);
            this.query.finish();
        }));
    }

    public void func_230430_a_(MatrixStack mStack, int mouseX, int mouseY, float partialTicks) {
        this.func_230446_a_(mStack);
        this.drawCenteredLines(mStack, 6, this.headerLines);
        if (this.textPanel != null) {
            this.textPanel.func_230430_a_(mStack, mouseX, mouseY, partialTicks);
        }
        if (!this.action.isEmpty()) {
            int n = this.field_230708_k_ / 2;
            this.field_230712_o_.getClass();
            this.func_238471_a_(mStack, this.field_230712_o_, this.action, n, this.field_230709_l_ - 6 - 20 - 9, -1);
        }
        super.func_230430_a_(mStack, mouseX, mouseY, partialTicks);
    }

    protected void drawCenteredLines(MatrixStack mStack, int yStart, String ... lines) {
        for (String line : lines) {
            if (!line.isEmpty()) {
                this.func_238471_a_(mStack, this.field_230712_o_, line, this.field_230708_k_ / 2, yStart, 0xFFFFFF);
            }
            this.field_230712_o_.getClass();
            yStart += 9;
        }
    }

    private class TextPanel
    extends ScrollPanel {
        TextPanel(Minecraft client, int width, int height, int top, int left) {
            super(client, width, height, top, left);
        }

        @Override
        protected int getContentHeight() {
            int height = 0;
            int n = NotificationScreen.this.textLines.length;
            NotificationScreen.this.field_230712_o_.getClass();
            if ((height += n * 9 + 4) < this.height - 50) {
                height = this.height - 50;
            }
            return height;
        }

        @Override
        protected void drawPanel(MatrixStack mStack, int entryRight, int relativeY, Tessellator tess, int mouseX, int mouseY) {
            NotificationScreen.this.drawCenteredLines(mStack, relativeY, NotificationScreen.this.textLines);
        }

        @Override
        protected int getScrollAmount() {
            NotificationScreen.this.field_230712_o_.getClass();
            return 9 * 3;
        }
    }
}

